# -*- Autoconf -*-
#
# Copyright (C) 2005-2010 ABINIT Group (Yann Pouillon)
#
# This file is part of the ABINIT software package. For license information,
# please see the COPYING file in the top-level directory of the ABINIT source
# distribution.
#

#
# Support for external FFT libraries
#



# _ABI_FFT_CHECK_ASL()
# ----------------------
#
# Check whether the ASL library is working.
#
AC_DEFUN([_ABI_FFT_CHECK_ASL],[
  dnl Init
  abi_fft_asl_serial="no"
  abi_fft_asl_mpi="no"
  abi_fft_asl_fcflags=""
  abi_fft_asl_ldflags=""
  abi_fft_asl_incs=""
  abi_fft_asl_libs=""

  dnl Look for libraries and routines
  if test "${with_fft_libs}" = ""; then
    AC_CHECK_LIB([asl],[zfc3fb])
    if test "${ac_cv_lib_asl_zfc3fb}" = "yes"; then
      abi_fft_asl_serial="yes"
      abi_fft_asl_libs="-lasl"
    fi
    if test "${enable_mpi}" = "yes" -a \
            "${abi_fft_asl_serial}" = "yes"; then
      abi_fft_asl_mpi="no"
    fi
  else
    _ABI_FFT_CHECK_USER
    abi_fft_asl_serial="${abi_fft_user_serial}"
    abi_fft_asl_mpi="${abi_fft_user_mpi}"
    if test "${abi_fft_asl_serial}" = "yes"; then
      abi_fft_asl_incs="${with_fft_includes}"
      abi_fft_asl_libs="${with_fft_libs}"
    fi
  fi
]) # _ABI_FFT_CHECK_ASL



# _ABI_FFT_CHECK_FFTW2()
# ----------------------
#
# Check whether the FFTW2 library is working.
#
AC_DEFUN([_ABI_FFT_CHECK_FFTW2],[
  dnl Init
  abi_fft_fftw2_serial="no"
  abi_fft_fftw2_mpi="no"
  abi_fft_fftw2_fcflags=""
  abi_fft_fftw2_ldflags=""
  abi_fft_fftw2_incs=""
  abi_fft_fftw2_libs=""

  dnl Look for libraries and routines
  if test "${with_fft_libs}" = ""; then
    AC_CHECK_LIB([fftw2],[fftw_execute])
    if test "${ac_cv_lib_fftw2_fftw_execute}" = "yes"; then
      abi_fft_fftw2_serial="yes"
      abi_fft_fftw2_libs="-lfftw2"
    fi
    if test "${enable_mpi}" = "yes" -a \
            "${abi_fft_fftw2_serial}" = "yes"; then
      abi_fft_fftw2_mpi="no"
    fi
  else
    _ABI_FFT_CHECK_USER
    abi_fft_fftw2_serial="${abi_fft_user_serial}"
    abi_fft_fftw2_mpi="${abi_fft_user_mpi}"
    if test "${abi_fft_fftw2_serial}" = "yes"; then
      abi_fft_fftw2_incs="${with_fft_includes}"
      abi_fft_fftw2_libs="${with_fft_libs}"
    fi
  fi
]) # _ABI_FFT_CHECK_FFTW2



# _ABI_FFT_CHECK_FFTW3()
# ----------------------
#
# Check whether the FFTW3 library is working.
#
AC_DEFUN([_ABI_FFT_CHECK_FFTW3],[
  dnl Init
  abi_fft_fftw3_serial="no"
  abi_fft_fftw3_mpi="no"
  abi_fft_fftw3_threads="no"
  abi_fft_fftw3_fcflags=""
  abi_fft_fftw3_ldflags=""
  abi_fft_fftw3_incs=""
  abi_fft_fftw3_libs=""

  dnl Look for libraries and routines
  if test "${with_fft_libs}" = ""; then
    AC_CHECK_LIB([fftw3],[dfftw_execute])
    if test "${ac_cv_lib_fftw3_dfftw_execute}" = "yes"; then
      abi_fft_fftw3_serial="yes"
      abi_fft_fftw3_libs="-lfftw3"
    fi
    if test "${enable_mpi}" = "yes" -a \
            "${abi_fft_fftw3_serial}" = "yes"; then
      abi_fft_fftw3_mpi="no"
    fi
  else
    _ABI_FFT_CHECK_USER
    abi_fft_fftw3_serial="${abi_fft_user_serial}"
    abi_fft_fftw3_mpi="${abi_fft_user_mpi}"
    if test "${abi_fft_fftw3_serial}" = "yes"; then
      abi_fft_fftw3_incs="${with_fft_includes}"
      abi_fft_fftw3_libs="${with_fft_libs}"
    fi
  fi

  dnl Look for a threaded version of FFTW
  if test "${abi_fft_fftw3_serial}" = "yes"; then
    if test "${with_fft_libs}" = ""; then
      AC_CHECK_LIB([fftw3_threads],[dfftw_init_threads])
      if test "${ac_cv_lib_fftw3_threads_dfftw_init_threads}" = "yes"; then
        abi_fft_fftw3_threads="yes"
        abi_fft_fftw3_libs="-lfftw3_threads ${abi_fft_fftw3_libs}"
      fi
    else
      abi_fft_fftw3_threads="${abi_fft_user_threads}"
    fi
  fi
]) # _ABI_FFT_CHECK_FFTW3



# _ABI_FFT_CHECK_MLIB()
# ----------------------
#
# Check whether the MLIB library is working.
#
AC_DEFUN([_ABI_FFT_CHECK_MLIB],[
  dnl Init
  abi_fft_mlib_serial="no"
  abi_fft_mlib_mpi="no"
  abi_fft_mlib_fcflags=""
  abi_fft_mlib_ldflags=""
  abi_fft_mlib_incs=""
  abi_fft_mlib_libs=""

  dnl Look for libraries and routines
  if test "${with_fft_libs}" = ""; then
    AC_CHECK_LIB([veclib],[c1dfft])
    if test "${ac_cv_lib_veclib_c1dfft}" = "yes"; then
      abi_fft_mlib_serial="yes"
      abi_fft_mlib_libs="-lveclib"
    fi
    if test "${enable_mpi}" = "yes" -a \
            "${abi_fft_mlib_serial}" = "yes"; then
      abi_fft_mlib_mpi="no"
    fi
  else
    _ABI_FFT_CHECK_USER
    abi_fft_mlib_serial="${abi_fft_user_serial}"
    abi_fft_mlib_mpi="${abi_fft_user_mpi}"
    if test "${abi_fft_mlib_serial}" = "yes"; then
      abi_fft_mlib_incs="${with_fft_includes}"
      abi_fft_mlib_libs="${with_fft_libs}"
    fi
  fi
]) # _ABI_FFT_CHECK_MLIB



# _ABI_FFT_CHECK_SGIMATH()
# ----------------------
#
# Check whether the complib.sgimath library is working.
#
AC_DEFUN([_ABI_FFT_CHECK_SGIMATH],[
  dnl Init
  abi_fft_sgimath_serial="no"
  abi_fft_sgimath_mpi="no"
  abi_fft_sgimath_fcflags=""
  abi_fft_sgimath_ldflags=""
  abi_fft_sgimath_incs=""
  abi_fft_sgimath_libs=""

  dnl Look for libraries and routines
  if test "${with_fft_libs}" = ""; then
    AC_CHECK_LIB([complib.sgimath],[dfft1du])
    if test "${ac_cv_lib_complib_sgimath_dfft1du}" = "yes"; then
      abi_fft_sgimath_serial="yes"
      abi_fft_sgimath_libs="-lcomplib.sgimath"
    fi
    if test "${enable_mpi}" = "yes" -a \
            "${abi_fft_sgimath_serial}" = "yes"; then
      abi_fft_sgimath_mpi="no"
    fi
  else
    _ABI_FFT_CHECK_USER
    abi_fft_sgimath_serial="${abi_fft_user_serial}"
    abi_fft_sgimath_mpi="${abi_fft_user_mpi}"
    if test "${abi_fft_sgimath_serial}" = "yes"; then
      abi_fft_sgimath_incs="${with_fft_includes}"
      abi_fft_sgimath_libs="${with_fft_libs}"
    fi
  fi
]) # _ABI_FFT_CHECK_SGIMATH



# _ABI_FFT_CHECK_USER()
# ------------------------
#
# Check whether user-specified libraries are working.
#
# Note: the build environment should already be prepared.
#
AC_DEFUN([_ABI_FFT_CHECK_USER],[
  dnl Init
  abi_fft_user_serial="no"
  abi_fft_user_mpi="no"
  abi_fft_user_threads="no"

  dnl Check serial routines
  dnl FIXME: choose routine according to library
  AC_MSG_CHECKING([for a serial optimized FFT support])
  AC_LINK_IFELSE([AC_LANG_PROGRAM([],
    [[
      call dfftw_execute
    ]])], [abi_fft_user_serial="yes"], [abi_fft_user_serial="no"])
  AC_MSG_RESULT([${abi_fft_user_serial}])

  dnl Check MPI routines
  dnl FIXME: implement something
  AC_MSG_CHECKING([for a MPI optimized FFT support])
  if test "${enable_mpi}" = "yes"; then
    AC_LINK_IFELSE([AC_LANG_PROGRAM([],
      [[
        choke me
      ]])], [abi_fft_user_mpi="yes"], [abi_fft_user_mpi="no"])
  fi
  AC_MSG_RESULT([${abi_fft_user_mpi}])

  dnl Check serial routines
  dnl FIXME: choose routine according to library
  AC_MSG_CHECKING([for a threaded optimized FFT support])
  AC_LINK_IFELSE([AC_LANG_PROGRAM([],
    [[
      call dfftw_init_threads
    ]])], [abi_fft_user_threads="yes"], [abi_fft_user_threads="no"])
  AC_MSG_RESULT([${abi_fft_user_threads}])
]) # _ABI_FFT_CHECK_USER



# ABI_CONNECT_FFT()
# -------------------
#
# Sets all variables needed to handle the FFT external libraries.
#
AC_DEFUN([ABI_CONNECT_FFT],[
  dnl Initial setup
  lib_fft_flavor="${with_fft_flavor}"
  lib_fft_fcflags=""
  lib_fft_ldflags=""
  lib_fft_incs=""
  lib_fft_libs=""
  abi_fft_serial="no"
  abi_fft_mpi="no"

  dnl Display user requests
  AC_MSG_CHECKING([whether to use optimized FFT libraries])
  AC_MSG_RESULT([${enable_fft}])

  dnl Prepare environment
  ABI_ENV_BACKUP
  abi_saved_LIBS="${LIBS}"
  CPPFLAGS="${with_fft_includes} ${CPPFLAGS}"
  LDFLAGS="${FC_LDFLAGS}"
  LIBS="${with_fft_libs} ${LIBS}"
  AC_LANG_PUSH([Fortran])

  dnl Look for external FFT libraries
  if test "${enable_fft}" = "yes"; then

    dnl Check whether we have a working FFT environment
    AC_MSG_CHECKING([for the requested FFT support])
    AC_MSG_RESULT([${with_fft_flavor}])

    case "${with_fft_flavor}" in

      asl)
        _ABI_FFT_CHECK_ASL
        abi_fft_serial="${abi_fft_asl_serial}"
        abi_fft_mpi="${abi_fft_asl_mpi}"
        if test "${abi_fft_serial}" = "yes"; then
          AC_DEFINE([HAVE_FFT_ASL],1,[Define to 1 if you want to use the ASL library for FFT.])
          lib_fft_fcflags="${abi_fft_asl_fcflags}"
          lib_fft_ldflags="${abi_fft_asl_ldflags}"
          lib_fft_incs="${abi_fft_asl_incs}"
          lib_fft_libs="${abi_fft_asl_libs}"
        fi
        ;;

      fftw2*)
        _ABI_FFT_CHECK_FFTW2
        abi_fft_serial="${abi_fft_fftw2_serial}"
        abi_fft_mpi="${abi_fft_fftw2_mpi}"
        if test "${abi_fft_serial}" = "yes"; then
          AC_DEFINE([HAVE_FFT_FFTW2],1,[Define to 1 if you want to use the FFTW2 library.])
          if test "${with_fft_flavor}" = "fftw2-threads"; then
            AC_DEFINE([HAVE_FFT_FFTW2_THREADS],1,[Define to 1 if you want to use the threaded FFTW2 library.])
          fi
          lib_fft_fcflags="${abi_fft_fftw2_fcflags}"
          lib_fft_ldflags="${abi_fft_fftw2_ldflags}"
          lib_fft_incs="${abi_fft_fftw2_incs}"
          lib_fft_libs="${abi_fft_fftw2_libs}"
        fi
        ;;

      fftw3*)
        _ABI_FFT_CHECK_FFTW3
        abi_fft_serial="${abi_fft_fftw3_serial}"
        abi_fft_mpi="${abi_fft_fftw3_mpi}"
        abi_fft_threads="${abi_fft_fftw3_threads}"
        if test "${abi_fft_serial}" = "yes"; then
          AC_DEFINE([HAVE_FFT_FFTW3],1,[Define to 1 if you want to use the FFTW3 library.])
          if test "${abi_fft_threads}" = "yes"; then
            AC_DEFINE([HAVE_FFT_FFTW3_THREADS],1,[Define to 1 if you want to use the threaded FFTW3 library.])
            lib_fft_flavor="fftw3-threads"
          else
            lib_fft_flavor="fftw3"
          fi
          if test "${with_fft_flavor}" = "fftw3-mkl"; then
            AC_DEFINE([HAVE_FFT_FFTW3_MKL],1,[Define to 1 if you want to use the threaded FFTW3 library.])
          fi
          lib_fft_fcflags="${abi_fft_fftw3_fcflags}"
          lib_fft_ldflags="${abi_fft_fftw3_ldflags}"
          lib_fft_incs="${abi_fft_fftw3_incs}"
          lib_fft_libs="${abi_fft_fftw3_libs}"
        fi
        ;;

      mlib)
        _ABI_FFT_CHECK_MLIB
        abi_fft_serial="${abi_fft_mlib_serial}"
        abi_fft_mpi="${abi_fft_mlib_mpi}"
        if test "${abi_fft_serial}" = "yes"; then
          AC_DEFINE([HAVE_FFT_MLIB],1,[Define to 1 if you want to use the HP MLIB library for FFT.])
          lib_fft_fcflags="${abi_fft_mlib_fcflags}"
          lib_fft_ldflags="${abi_fft_mlib_ldflags}"
          lib_fft_incs="${abi_fft_mlib_incs}"
          lib_fft_libs="${abi_fft_mlib_libs}"
        fi
        ;;

      sgimath)
        _ABI_FFT_CHECK_SGIMATH
        abi_fft_serial="${abi_fft_sgimath_serial}"
        abi_fft_mpi="${abi_fft_sgimath_mpi}"
        if test "${abi_fft_serial}" = "yes"; then
          AC_DEFINE([HAVE_FFT_SGIMATH],1,[Define to 1 if you want to use the SGIMATH library for FFT.])
          lib_fft_fcflags="${abi_fft_sgimath_fcflags}"
          lib_fft_ldflags="${abi_fft_sgimath_ldflags}"
          lib_fft_incs="${abi_fft_sgimath_incs}"
          lib_fft_libs="${abi_fft_sgimath_libs}"
        fi
        ;;

    esac

  fi

  dnl Transmit serial status to the source code
  if test "${abi_fft_serial}" = "yes"; then
    AC_DEFINE([HAVE_FFT],1,[Define to 1 if you have an optimized FFT library.])
    AC_DEFINE([HAVE_FFT_SERIAL],1,[Define to 1 if you have an optimized serial FFT library.])
  else
    lib_fft_flavor="none"
  fi

  dnl Transmit MPI status to the source code
  if test "${abi_fft_mpi}" = "yes"; then
    AC_DEFINE([HAVE_FFT_MPI],1,[Define to 1 if you have an optimized MPI-parallel FFT library.])
  fi

  dnl Restore build environment
  AC_LANG_POP
  LIBS="${abi_saved_LIBS}"
  ABI_ENV_RESTORE

  dnl Output final flavor
  if test "${enable_fft}" = "yes"; then
    AC_MSG_CHECKING([for the actual FFT support])
    AC_MSG_RESULT([${lib_fft_flavor}])
  fi

  dnl Substitute variables needed for the use of the library
  AC_SUBST(lib_fft_flavor)
  AC_SUBST(lib_fft_fcflags)
  AC_SUBST(lib_fft_ldflags)
  AC_SUBST(lib_fft_incs)
  AC_SUBST(lib_fft_libs)
]) # ABI_CONNECT_FFT
