# -*- Autoconf -*-
#
# Copyright (C) 2005-2010 ABINIT Group (Yann Pouillon)
#
# This file is part of the ABINIT software package. For license information,
# please see the COPYING file in the top-level directory of the ABINIT source
# distribution.
#

#
# Support for external linear algebra libraries
#



# _ABI_LINALG_CHECK_ASL()
# -------------------------
#
# Check whether the ASL library is working.
#
AC_DEFUN([_ABI_LINALG_CHECK_ASL],[
  dnl Init
  abi_linalg_asl_serial="no"
  abi_linalg_asl_mpi="no"
  abi_linalg_asl_fcflags=""
  abi_linalg_asl_ldflags=""
  abi_linalg_asl_incs=""
  abi_linalg_asl_libs=""
  abi_linalg_asl_deps=""

  dnl Look for libraries and routines
  if test "${with_linalg_libs}" = ""; then
    AC_CHECK_LIB([asl],[zgemm])
    AC_CHECK_LIB([asl],[zhpev])
    if test "${ac_cv_lib_asl_zgemm}" = "yes" -a \
            "${ac_cv_lib_asl_zhpev}" = "yes"; then
      abi_linalg_asl_serial="yes"
      abi_linalg_asl_libs="-lasl"
    fi
  else
    _ABI_LINALG_CHECK_USER
    abi_linalg_asl_serial="${abi_linalg_user_serial}"
    abi_linalg_asl_mpi="${abi_linalg_user_mpi}"
    if test "${abi_linalg_user_serial}" = "yes"; then
      abi_linalg_asl_incs="${with_linalg_includes}"
      abi_linalg_asl_libs="${with_linalg_libs}"
    fi
  fi
]) # _ABI_LINALG_CHECK_ASL



# _ABI_LINALG_CHECK_ATLAS()
# -------------------------
#
# Check whether the Atlas library is working.
#
AC_DEFUN([_ABI_LINALG_CHECK_ATLAS],[
  dnl Init
  abi_linalg_atlas_serial="no"
  abi_linalg_atlas_mpi="no"
  abi_linalg_atlas_fcflags=""
  abi_linalg_atlas_ldflags=""
  abi_linalg_atlas_incs=""
  abi_linalg_atlas_libs=""
  abi_linalg_atlas_deps=""

  dnl Look for libraries and routines
  if test "${with_linalg_libs}" = ""; then
    AC_LANG_PUSH([C])
    AC_CHECK_LIB([atlas],[ATL_buildinfo])
    AC_CHECK_LIB([cblas],[cblas_zgemm])
    AC_LANG_POP
    AC_CHECK_LIB([f77blas],[zgemm])
    AC_CHECK_LIB([lapack],[zhpev])
    if test "${ac_cv_lib_atlas_ATL_buildinfo}" = "yes" -a \
            "${ac_cv_lib_cblas_cblas_zgemm}" = "yes" -a \
            "${ac_cv_lib_f77blas_zgemm}" = "yes" -a \
            "${ac_cv_lib_lapack_zhpev}" = "yes"; then
      abi_linalg_atlas_serial="yes"
      abi_linalg_atlas_libs="-llapack -lf77blas -lcblas -latlas"
    fi
  else
    _ABI_LINALG_CHECK_USER
    abi_linalg_atlas_serial="${abi_linalg_user_serial}"
    abi_linalg_atlas_mpi="${abi_linalg_user_mpi}"
    if test "${abi_linalg_user_serial}" = "yes"; then
      abi_linalg_atlas_incs="${with_linalg_includes}"
      abi_linalg_atlas_libs="${with_linalg_libs}"
    fi
  fi
]) # _ABI_LINALG_CHECK_ATLAS



# _ABI_LINALG_CHECK_ESSL()
# ------------------------
#
# Check whether the ESSL library is working.
#
AC_DEFUN([_ABI_LINALG_CHECK_ESSL],[
  dnl Init
  abi_linalg_essl_serial="no"
  abi_linalg_essl_mpi="no"
  abi_linalg_essl_fcflags=""
  abi_linalg_essl_ldflags=""
  abi_linalg_essl_incs=""
  abi_linalg_essl_libs=""

  dnl Prepare build environment
  if test "${abi_fc_vendor}" = "ibm"; then
    abi_linalg_essl_fcflags="-qessl"
    abi_linalg_essl_ldflags="-qessl"
  fi
  FCFLAGS="${abi_linalg_essl_fcflags} ${FCFLAGS}"
  LDFLAGS="${abi_linalg_essl_ldflags} ${LDFLAGS}"

  dnl Looking whether library has particular routines
  if test "${with_linalg_libs}" = ""; then
    AC_CHECK_LIB([essl],[zgemm])
    AC_CHECK_LIB([essl],[zhpev])
    if test "${ac_cv_lib_essl_zgemm}" = "yes" -a \
            "${ac_cv_lib_essl_zhpev}" = "yes"; then
      abi_linalg_essl_serial="yes"
      abi_linalg_essl_libs="-lessl"
    fi
    if test "${enable_mpi}" = "yes" -a "${enable_scalapack}" = "yes" -a \
            "${abi_linalg_essl_serial}" = "yes"; then
      AC_CHECK_LIB([essl],[blacs_gridinit])
      AC_CHECK_LIB([essl],[pzheevx])
      if test "${ac_cv_lib_essl_blacs_gridinit}" = "yes" -a \
              "${ac_cv_lib_essl_pzheevx}" = "yes"; then
        abi_linalg_essl_mpi="yes"
      fi
    fi
  else
    _ABI_LINALG_CHECK_USER
    abi_linalg_essl_serial="${abi_linalg_user_serial}"
    abi_linalg_essl_mpi="${abi_linalg_user_mpi}"
    if test "${abi_linalg_user_serial}" = "yes"; then
      abi_linalg_essl_incs="${with_linalg_includes}"
      abi_linalg_essl_libs="${with_linalg_libs}"
    fi
  fi
]) # _ABI_LINALG_CHECK_ESSL



# _ABI_LINALG_CHECK_MKL()
# ------------------------
#
# Check whether the MKL library is working.
#
AC_DEFUN([_ABI_LINALG_CHECK_MKL],[
  dnl Init
  abi_linalg_mkl_serial="no"
  abi_linalg_mkl_mpi="no"
  abi_linalg_mkl_fcflags=""
  abi_linalg_mkl_ldflags=""
  abi_linalg_mkl_incs=""
  abi_linalg_mkl_libs=""
  abi_linalg_mkl_deps=""

  dnl Look for libraries and routines (this one is particularly tough!)
  if test "${with_linalg_libs}" = ""; then
    AC_CHECK_LIB([guide],[kmp_alloc])
    if test "${ac_cv_lib_guide_kmp_alloc}" = "no"; then
      AC_CHECK_LIB([pthread],[pthread_create])
      AC_CHECK_LIB([guide],[kmp_alloc])
    fi
    if test "${ac_cv_lib_guide_kmp_alloc}" = "yes"; then
      abi_linlag_mkl_deps="-lpthread"
    fi
    AC_CHECK_LIB([mkl],[zgemm])
    AC_CHECK_LIB([mkl_lapack],[zhpev])
    if test "${ac_cv_lib_mkl_zgemm}" = "yes" -a \
            "${ac_cv_lib_mkl_lapack_zhpev}" = "yes"; then
      abi_linalg_mkl_serial="yes"
      abi_linalg_mkl_libs="-lmkl_lapack -lmkl -lguide ${abi_linalg_mkl_deps}"
    fi
    if test "${enable_mpi}" = "yes" -a "${enable_scalapack}" = "yes" -a \
            "${abi_linalg_mkl_serial}" = "yes"; then
      AC_CHECK_LIB([mkl_blacs],[blacs_gridinit])
      AC_CHECK_LIB([mkl_scalapack],[pzheevx])
      if test "${ac_cv_lib_mkl_blacs_blacs_gridinit}" = "yes" -a \
              "${ac_cv_lib_mkl_scalapack_pzheevx}" = "yes"; then
        abi_linalg_mkl_mpi="yes"
        abi_linalg_mkl_libs="-lmkl_scalapack -lmkl_blacs ${abi_linalg_mkl_libs}"
      fi
    fi
  else
    _ABI_LINALG_CHECK_USER
    abi_linalg_mkl_serial="${abi_linalg_user_serial}"
    abi_linalg_mkl_mpi="${abi_linalg_user_mpi}"
    if test "${abi_linalg_user_serial}" = "yes"; then
      abi_linalg_mkl_incs="${with_linalg_includes}"
      abi_linalg_mkl_libs="${with_linalg_libs}"
    fi
  fi
]) # _ABI_LINALG_CHECK_MKL



# _ABI_LINALG_CHECK_NETLIB()
# --------------------------
#
# Check whether the Netlib libraries are working.
#
AC_DEFUN([_ABI_LINALG_CHECK_NETLIB],[
  dnl Init
  abi_linalg_netlib_serial="no"
  abi_linalg_netlib_mpi="no"
  abi_linalg_netlib_fcflags=""
  abi_linalg_netlib_ldflags=""
  abi_linalg_netlib_incs=""
  abi_linalg_netlib_libs=""

  dnl Look for libraries and routines
  if test "${with_linalg_libs}" = ""; then
    AC_CHECK_LIB([blas],[zgemm])
    AC_CHECK_LIB([lapack],[zhpev])
    if test "${ac_cv_lib_blas_zgemm}" = "yes" -a \
            "${ac_cv_lib_lapack_zhpev}" = "yes"; then
      abi_linalg_netlib_serial="yes"
      abi_linalg_netlib_libs="-llapack -lblas"
    fi
    if test "${enable_mpi}" = "yes" -a "${enable_scalapack}" = "yes" -a \
            "${abi_linalg_netlib_serial}" = "yes"; then
      LIBS="-lblacsCinit -lblacsF77init ${LIBS}"
      AC_CHECK_LIB([blacs],[blacs_gridinit])
      AC_CHECK_LIB([scalapack],[pzheevx])
      if test "${ac_cv_lib_blacs_blacs_gridinit}" = "yes" -a \
              "${ac_cv_lib_scalapack_pzheevx}" = "yes"; then
        abi_linalg_netlib_mpi="yes"
        abi_linalg_netlib_libs="-lscalapack -lblacs -lblacsCinit -lblacsF77init ${abi_linalg_netlib_libs}"
      fi
    fi
  else
    _ABI_LINALG_CHECK_USER
    abi_linalg_netlib_serial="${abi_linalg_user_serial}"
    abi_linalg_netlib_mpi="${abi_linalg_user_mpi}"
    if test "${abi_linalg_netlib_serial}" = "yes"; then
      abi_linalg_netlib_incs="${with_linalg_includes}"
      abi_linalg_netlib_libs="${with_linalg_libs}"
    fi
  fi
]) # _ABI_LINALG_CHECK_NETLIB



# _ABI_LINALG_CHECK_USER()
# ------------------------
#
# Check whether user-specified libraries are working.
#
# Note: the build environment should already be prepared.
#
AC_DEFUN([_ABI_LINALG_CHECK_USER],[
  dnl Init
  abi_linalg_user_serial="no"
  abi_linalg_user_mpi="no"

  dnl Check serial routines
  AC_MSG_CHECKING([for a serial optimized linear algebra support])
  AC_LINK_IFELSE([AC_LANG_PROGRAM([],
    [[
      call zgemm
      call zhpev
    ]])], [abi_linalg_user_serial="yes"], [abi_linalg_user_serial="no"])
  AC_MSG_RESULT([${abi_linalg_user_serial}])

  dnl Check MPI routines
  AC_MSG_CHECKING([for a MPI optimized linear algebra support])
  if test "${enable_mpi}" = "yes" -a "${enable_scalapack}" = "yes"; then
    AC_LINK_IFELSE([AC_LANG_PROGRAM([],
      [[
        call blacs_gridinit
        call pzheevx
      ]])], [abi_linalg_user_mpi="yes"], [abi_linalg_user_mpi="no"])
  fi
  AC_MSG_RESULT([${abi_linalg_user_mpi}])
]) # _ABI_LINALG_CHECK_USER



# ABI_CONNECT_LINALG()
# --------------------
#
# Sets all variables needed to handle the optimized linear algebra
# libraries.
#
AC_DEFUN([ABI_CONNECT_LINALG],[
  dnl Initial setup
  lib_linalg_flavor="${with_linalg_flavor}"
  lib_linalg_fcflags=""
  lib_linalg_ldflags=""
  lib_linalg_incs=""
  lib_linalg_libs=""
  abi_linalg_serial="no"
  abi_linalg_mpi="no"

  dnl Display user requests
  AC_MSG_CHECKING([whether to use optimized linear algebra libraries])
  AC_MSG_RESULT([${enable_linalg}])
  AC_MSG_CHECKING([whether to activate ScaLAPACK support])
  AC_MSG_RESULT([${enable_scalapack}])

  dnl Check consistency
  if test "${enable_mpi}" = "no" -a "${enable_scalapack}" = "yes"; then
    AC_MSG_WARN([disabling ScaLAPACK support (MPI is disabled)])
    enable_scalapack="no"
  fi

  dnl Define variables needed to build the fallback library
  if test -z "${CPPFLAGS_LINALG}"; then
    CPPFLAGS_LINALG="${CPPFLAGS}"
  fi
  AC_SUBST(CPPFLAGS_LINALG)
  if test -z "${CFLAGS_LINALG}"; then
    CFLAGS_LINALG="${CFLAGS}"
  fi
  AC_SUBST(CFLAGS_LINALG)
  if test -z "${CXXFLAGS_LINALG}"; then
    CXXFLAGS_LINALG="${CXXFLAGS}"
  fi
  AC_SUBST(CXXFLAGS_LINALG)
  if test -z "${FCFLAGS_LINALG}"; then
    FCFLAGS_LINALG="${FCFLAGS} ${fcflags_opt_linalg}"
  fi
  AC_SUBST(FCFLAGS_LINALG)

  dnl Prepare environment
  ABI_ENV_BACKUP
  abi_saved_LIBS="${LIBS}"
  CPPFLAGS="${with_linalg_includes} ${CPPFLAGS}"
  LDFLAGS="${FC_LDFLAGS}"
  LIBS="${with_linalg_libs} ${LIBS}"
  AC_LANG_PUSH([Fortran])

  dnl Look for external linear algebra libraries
  if test "${enable_linalg}" = "yes"; then

    dnl Check whether we have a working linalg environment
    AC_MSG_CHECKING([for the requested linear algebra support])
    AC_MSG_RESULT([${with_linalg_flavor}])

    case "${with_linalg_flavor}" in

      asl)
        _ABI_LINALG_CHECK_ASL
        abi_linalg_serial="${abi_linalg_asl_serial}"
        abi_linalg_mpi="${abi_linalg_asl_mpi}"
        if test "${abi_linalg_serial}" = "yes"; then
          AC_DEFINE([HAVE_LINALG_ASL],1,[Define to 1 if you have the ASL linear algebra library.])
          lib_linalg_fcflags="${abi_linalg_asl_fcflags}"
          lib_linalg_ldflags="${abi_linalg_asl_ldflags}"
          lib_linalg_incs="${abi_linalg_asl_incs}"
          lib_linalg_libs="${abi_linalg_asl_libs}"
        fi
        ;;

      atlas)
        _ABI_LINALG_CHECK_ATLAS
        abi_linalg_serial="${abi_linalg_atlas_serial}"
        abi_linalg_mpi="${abi_linalg_atlas_mpi}"
        if test "${abi_linalg_serial}" = "yes"; then
          AC_DEFINE([HAVE_LINALG_ATLAS],1,[Define to 1 if you have the Atlas linear algebra library.])
          lib_linalg_fcflags="${abi_linalg_atlas_fcflags}"
          lib_linalg_ldflags="${abi_linalg_atlas_ldflags}"
          lib_linalg_incs="${abi_linalg_atlas_incs}"
          lib_linalg_libs="${abi_linalg_atlas_libs}"
        fi
        ;;

      essl)
        _ABI_LINALG_CHECK_ESSL
        abi_linalg_serial="${abi_linalg_essl_serial}"
        abi_linalg_mpi="${abi_linalg_essl_mpi}"
        if test "${abi_linalg_serial}" = "yes"; then
          AC_DEFINE([HAVE_LINALG_ESSL],1,[Define to 1 if you have the ESSL linear algebra library.])
          lib_linalg_fcflags="${abi_linalg_essl_fcflags}"
          lib_linalg_ldflags="${abi_linalg_essl_ldflags}"
          lib_linalg_incs="${abi_linalg_essl_incs}"
          lib_linalg_libs="${abi_linalg_essl_libs}"
        fi
        ;;

      mkl)
        _ABI_LINALG_CHECK_MKL
        abi_linalg_serial="${abi_linalg_mkl_serial}"
        abi_linalg_mpi="${abi_linalg_mkl_mpi}"
        if test "${abi_linalg_serial}" = "yes"; then
          AC_DEFINE([HAVE_LINALG_MKL],1,[Define to 1 if you have the MKL linear algebra library.])
          lib_linalg_fcflags="${abi_linalg_mkl_fcflags}"
          lib_linalg_ldflags="${abi_linalg_mkl_ldflags}"
          lib_linalg_incs="${abi_linalg_mkl_incs}"
          lib_linalg_libs="${abi_linalg_mkl_libs}"
        fi
        ;;

      netlib)
        _ABI_LINALG_CHECK_NETLIB
        abi_linalg_serial="${abi_linalg_netlib_serial}"
        abi_linalg_mpi="${abi_linalg_netlib_mpi}"
        if test "${abi_linalg_serial}" = "yes"; then
          AC_DEFINE([HAVE_LINALG_NETLIB],1,[Define to 1 if you have the Netlib linear algebra library.])
          lib_linalg_fcflags="${abi_linalg_netlib_fcflags}"
          lib_linalg_ldflags="${abi_linalg_netlib_ldflags}"
          lib_linalg_incs="${abi_linalg_netlib_incs}"
          lib_linalg_libs="${abi_linalg_netlib_libs}"
        fi
        ;;

    esac

  fi

  dnl Transmit serial status to the source code
  if test "${abi_linalg_serial}" = "yes"; then
    AC_DEFINE([HAVE_LINALG],1,[Define to 1 if you have an optimized linear algebra library.])
    AC_DEFINE([HAVE_LINALG_SERIAL],1,[Define to 1 if you have an optimized serial linear algebra library.])
  else
    lib_linalg_libs="-L\$(abinit_builddir)/prereqs/linalg -llapack -lblas"
    lib_linalg_flavor="none"
  fi

  dnl Transmit MPI status to the source code
  if test "${abi_linalg_mpi}" = "yes"; then
    if test "${enable_scalapack}" = "yes"; then
      AC_DEFINE([HAVE_LINALG_MPI],1,[Define to 1 if you have an optimized MPI-parallel linear algebra library.])
    fi
  fi

  dnl Restore build environment
  AC_LANG_POP
  LIBS="${abi_saved_LIBS}"
  ABI_ENV_RESTORE

  dnl Output final flavor
  if test "${enable_linalg}" = "yes"; then
    AC_MSG_CHECKING([for the actual linear algebra support])
    AC_MSG_RESULT([${lib_linalg_flavor}])
  fi

  dnl Substitute variables needed for the use of the library
  AC_SUBST(lib_linalg_flavor)
  AC_SUBST(lib_linalg_fcflags)
  AC_SUBST(lib_linalg_ldflags)
  AC_SUBST(lib_linalg_incs)
  AC_SUBST(lib_linalg_libs)

  dnl Inform Automake
  AM_CONDITIONAL(DO_BUILD_LINALG,[test "${lib_linalg_flavor}" = "none"])
]) # ABI_CONNECT_LINALG
