# -*- Autoconf -*-
#
# Copyright (C) 2005-2010 ABINIT Group (Yann Pouillon)
#
# This file is part of the ABINIT software package. For license information,
# please see the COPYING file in the top-level directory of the ABINIT source
# distribution.
#

#
# Support for transferable file I/O libraries
#



# _ABI_TRIO_CHECK_ETSF()
# ----------------------
#
# Check whether the ETSF_IO library is working.
#
AC_DEFUN([_ABI_TRIO_CHECK_ETSF],[
  dnl Init
  abi_trio_etsf_has_incs="no"
  abi_trio_etsf_has_libs="no"
  abi_trio_etsf_serial="no"
  abi_trio_etsf_mpi="no"
  abi_trio_etsf_fcflags=""
  abi_trio_etsf_ldflags=""
  abi_trio_etsf_incs="${with_trio_includes}"
  abi_trio_etsf_libs="${with_trio_libs}"


  dnl Look for includes
  dnl FIXME: uncomment this when the C version is ready
  dnl AC_LANG_PUSH([C])
  dnl AC_CHECK_HEADERS([etsf_io.h],[abi_trio_etsf_has_incs="yes"],[abi_trio_etsf_has_incs="no"])
  dnl AC_LANG_POP

  dnl Look for libraries and routines
  if test "${abi_trio_etsf_libs}" = ""; then
    dnl FIXME: uncomment this when the C version is ready
    dnl AC_LANG_PUSH([C])
    dnl AC_CHECK_LIB([etsf],[etsf_io_low_open_create])
    dnl AC_LANG_POP
    LIBS="-letsf_io_utils -letsf_io ${LIBS}"
    AC_MSG_CHECKING([whether we have a working ETSF_IO library])
    AC_LINK_IFELSE([AC_LANG_PROGRAM([],
      [[
        use etsf_io_low_level
        use etsf_io
        use etsf_io_tools
        character(len=etsf_charlen),allocatable :: atoms(:)
        integer :: ncid
        logical :: lstat
        type(etsf_io_low_error) :: err
        call etsf_io_tools_get_atom_names(ncid,atoms,lstat,err)
      ]])], [abi_trio_etsf_has_libs="yes"], [abi_trio_etsf_has_libs="no"])
    AC_MSG_RESULT([${abi_trio_etsf_has_libs}])
    if test "${abi_trio_etsf_has_libs}" = "yes"; then
      abi_trio_etsf_has_incs="yes"
      abi_trio_etsf_libs="-letsf_io_utils -letsf_io"
    fi
  else
    AC_MSG_CHECKING([whether the specified ETSF_IO library works])
    AC_LINK_IFELSE([AC_LANG_PROGRAM([],
      [[
        use etsf_io_low_level
        use etsf_io
        use etsf_io_tools
        character(len=etsf_charlen),allocatable :: atoms(:)
        integer :: ncid
        logical :: lstat
        type(etsf_io_low_error) :: err
        call etsf_io_tools_get_atom_names(ncid,atoms,lstat,err)
      ]])], [abi_trio_etsf_has_incs="yes"; abi_trio_etsf_has_libs="yes"], [abi_trio_etsf_has_libs="no"])
    AC_MSG_RESULT([${abi_trio_etsf_has_libs}])
  fi

  dnl Take final decision for the serial case
  if test "${abi_trio_etsf_has_incs}" = "yes" -a \
          "${abi_trio_etsf_has_libs}" = "yes"; then
    abi_trio_etsf_serial="yes"
  fi

  dnl Check for MPI support
  if test "${enable_mpi_trio}" = "yes"; then
    AC_MSG_CHECKING([whether ETSF_IO supports MPI I/O])
    AC_LINK_IFELSE([AC_LANG_PROGRAM([],
      [[
        use etsf_io_low_level
        call etsf_io_low_open_create_par
      ]])], [abi_trio_etsf_mpi="yes"], [abi_trio_etsf_mpi="no"])
    AC_MSG_RESULT([${abi_trio_etsf_has_libs}])
  fi
]) # _ABI_TRIO_CHECK_ETSF



# _ABI_TRIO_CHECK_FOX()
# ---------------------
#
# Check whether the FoX library is working.
#
AC_DEFUN([_ABI_TRIO_CHECK_FOX],[
  dnl Init
  abi_trio_fox_has_incs="no"
  abi_trio_fox_has_libs="no"
  abi_trio_fox_serial="no"
  abi_trio_fox_mpi="no"
  abi_trio_fox_fcflags=""
  abi_trio_fox_ldflags=""
  abi_trio_fox_incs="${with_trio_includes}"
  abi_trio_fox_libs="${with_trio_libs}"

  dnl Look for libraries and routines
  if test "${abi_trio_fox_libs}" = ""; then
    LIBS="-lFoX_sax -lFoX_utils -lFoX_fsys -lFoX_common ${LIBS}"
    AC_MSG_CHECKING([whether we have a working FoX library])
    AC_LINK_IFELSE([AC_LANG_PROGRAM([],
      [[
        use fox_sax
        type(xml_t) :: xt
        call open_xml_file(xt,"conftest.xml")
      ]])], [abi_trio_fox_has_libs="yes"], [abi_trio_fox_has_libs="no"])
    AC_MSG_RESULT([${abi_trio_fox_has_libs}])
    if test "${abi_trio_fox_has_libs}" = "yes"; then
      abi_trio_fox_has_incs="yes"
      abi_trio_fox_libs="-lFoX_sax -lFoX_utils -lFoX_fsys -lFoX_common"
    fi
  else
    AC_MSG_CHECKING([whether the specified FoX library works])
    AC_LINK_IFELSE([AC_LANG_PROGRAM([],
      [[
        use fox_sax
        type(xml_t) :: xt
        call open_xml_file(xt,"conftest.xml")
      ]])], [abi_trio_fox_has_incs="yes"; abi_trio_fox_has_libs="yes"], [abi_trio_fox_has_libs="no"])
    AC_MSG_RESULT([${abi_trio_fox_has_libs}])
  fi

  dnl Take final decision for the serial case
  if test "${abi_trio_fox_has_incs}" = "yes" -a \
          "${abi_trio_fox_has_libs}" = "yes"; then
    abi_trio_fox_serial="yes"
  fi
]) # _ABI_TRIO_CHECK_FOX



# _ABI_TRIO_CHECK_HDF()
# ---------------------
#
# Check whether the HDF library is working.
#
AC_DEFUN([_ABI_TRIO_CHECK_HDF],[
  dnl Init
  abi_trio_hdf_has_incs="no"
  abi_trio_hdf_has_libs="no"
  abi_trio_hdf_serial="no"
  abi_trio_hdf_mpi="no"
  abi_trio_hdf_fcflags=""
  abi_trio_hdf_ldflags=""
  abi_trio_hdf_incs="${with_trio_includes}"
  abi_trio_hdf_libs="${with_trio_libs}"

  dnl Look for includes
  AC_LANG_PUSH([C])
  AC_CHECK_HEADERS([hdf5.h],[abi_trio_hdf_has_incs="yes"],[abi_trio_hdf_has_incs="no"])
  AC_LANG_POP

  dnl Look for libraries and routines
  if test "${abi_trio_hdf_libs}" = ""; then
    AC_LANG_PUSH([C])
    AC_CHECK_LIB([hdf5],[H5Fcreate])
    AC_LANG_POP
    if test "${ac_cv_lib_hdf5_H5Fcreate}" = "yes"; then
      AC_CHECK_LIB([hdf5],[h5fcreate_f],[abi_trio_hdf_has_libs="yes"],[abi_trio_hdf_has_libs="no"])
      if test "${abi_trio_hdf_has_libs}" = "yes"; then
        abi_trio_hdf_libs="-lhdf5"
      fi
    fi
  else
    AC_MSG_CHECKING([whether the specified HDF library works])
    AC_LINK_IFELSE([AC_LANG_PROGRAM([],
      [[
        call h5fcreate_f
      ]])], [abi_trio_hdf_has_libs="yes"], [abi_trio_hdf_has_libs="no"])
    AC_MSG_RESULT([${abi_trio_hdf_has_libs}])
  fi

  dnl Take final decision for the serial case
  if test "${abi_trio_hdf_has_incs}" = "yes" -a \
          "${abi_trio_hdf_has_libs}" = "yes"; then
    abi_trio_hdf_serial="yes"
  fi

  dnl Check for MPI support
  dnl FIXME: find a proper test
  if test "${enable_mpi_trio}" = "yes"; then
    AC_MSG_CHECKING([whether HDF supports MPI I/O])
    AC_LINK_IFELSE([AC_LANG_PROGRAM([],
      [[
        call h5fcreate_f_par
      ]])], [abi_trio_hdf_mpi="yes"], [abi_trio_hdf_mpi="no"])
    AC_MSG_RESULT([${abi_trio_hdf_has_libs}])
  fi
]) # _ABI_TRIO_CHECK_HDF



# _ABI_TRIO_CHECK_NETCDF()
# ------------------------
#
# Check whether the NetCDF library is working.
#
AC_DEFUN([_ABI_TRIO_CHECK_NETCDF],[
  dnl Init
  abi_trio_netcdf_has_incs="no"
  abi_trio_netcdf_has_libs="no"
  abi_trio_netcdf_serial="no"
  abi_trio_netcdf_mpi="no"
  abi_trio_netcdf_fcflags=""
  abi_trio_netcdf_ldflags=""
  abi_trio_netcdf_incs="${with_trio_includes}"
  abi_trio_netcdf_libs="${with_trio_libs}"

  dnl Look for includes
  AC_LANG_PUSH([C])
  AC_CHECK_HEADERS([netcdf.h],[abi_trio_netcdf_has_incs="yes"],[abi_trio_netcdf_has_incs="no"])
  AC_LANG_POP

  dnl Look for libraries and routines
  if test "${abi_trio_netcdf_libs}" = ""; then
    AC_LANG_PUSH([C])
    AC_CHECK_LIB([netcdf],[nc_open])
    AC_LANG_POP
    if test "${ac_cv_lib_netcdf_nc_open}" = "yes"; then
      AC_CHECK_LIB([netcdf],[nf_open],[abi_trio_netcdf_has_libs="yes"],[abi_trio_netcdf_has_libs="no"])
      if test "${abi_trio_netcdf_has_libs}" = "yes"; then
        abi_trio_netcdf_libs="-lnetcdf"
      else
        AC_CHECK_LIB([netcdff],[nf_open],[abi_trio_netcdf_has_libs="yes"],[abi_trio_netcdf_has_libs="no"])
        if test "${abi_trio_netcdf_has_libs}" = "yes"; then
          abi_trio_netcdf_libs="-lnetcdff -lnetcdf"
        fi
      fi
    fi
  else
    AC_MSG_CHECKING([whether the specified NetCDF library works])
    AC_LINK_IFELSE([AC_LANG_PROGRAM([],
      [[
        use netcdf
        call nf90_open
      ]])], [abi_trio_netcdf_has_libs="yes"], [abi_trio_netcdf_has_libs="no"])
    AC_MSG_RESULT([${abi_trio_netcdf_has_libs}])
  fi

  dnl Take final decision for the serial case
  if test "${abi_trio_netcdf_has_incs}" = "yes" -a \
          "${abi_trio_netcdf_has_libs}" = "yes"; then
    abi_trio_netcdf_serial="yes"
  fi

  dnl Check for MPI support
  if test "${enable_mpi_trio}" = "yes"; then
    AC_MSG_CHECKING([whether NetCDF supports MPI I/O])
    AC_LINK_IFELSE([AC_LANG_PROGRAM([],
      [[
        use netcdf
        call nf90_open_par
      ]])], [abi_trio_netcdf_mpi="yes"], [abi_trio_netcdf_mpi="no"])
    AC_MSG_RESULT([${abi_trio_netcdf_has_libs}])
  fi

  dnl Make sure LIBS are properly set for ETSF_IO
  LIBS="${abi_trio_netcdf_libs} ${LIBS}"
]) # _ABI_TRIO_CHECK_NETCDF



# ABI_CONNECT_TRIO()
# ------------------
#
# Sets all variables needed to handle the transferable I/O libraries.
#
AC_DEFUN([ABI_CONNECT_TRIO],[
  dnl Initial setup
  lib_trio_flavor="${with_trio_flavor}"
  lib_trio_fcflags=""
  lib_trio_ldflags=""
  lib_trio_incs=""
  lib_trio_libs=""

  dnl Display user requests
  AC_MSG_CHECKING([whether to use transferable I/O libraries])
  AC_MSG_RESULT([${enable_trio}])

  dnl Prepare environment
  ABI_ENV_BACKUP
  abi_saved_LIBS="${LIBS}"
  CPPFLAGS="${with_trio_includes} ${CPPFLAGS}"
  FCFLAGS="${with_trio_includes} ${FCFLAGS}"
  LDFLAGS="${FC_LDFLAGS}"
  LIBS="${with_trio_libs} ${LIBS}"
  AC_LANG_PUSH([Fortran])

  dnl Look for external I/O libraries
  if test "${enable_trio}" = "yes"; then

    dnl Check whether we have a working I/O environment
    AC_MSG_CHECKING([for the requested transferable I/O support])
    AC_MSG_RESULT([${with_trio_flavor}])

    dnl Make sure NetCDF is looked for before ETSF_IO
    abi_trio_iter=`echo "${with_trio_flavor}" | sed -e 's/+/\n/g' | sort -u | awk '{printf " %s",[$]1}'`
    abi_trio_tmp="${abi_trio_iter}"
    for abi_trio_flavor in ${abi_trio_iter}; do
      if test "${abi_trio_flavor}" = "etsf"; then
        abi_trio_tmp=`echo "${abi_trio_iter}" | sed -e 's/netcdf//'`
        abi_trio_tmp="netcdf ${abi_trio_tmp}"
      fi
    done
    abi_trio_iter="${abi_trio_tmp}"

    for abi_trio_flavor in ${abi_trio_iter}; do

      case "${abi_trio_flavor}" in

        etsf)
          if test "${abi_trio_netcdf_serial}" = "yes"; then
            _ABI_TRIO_CHECK_ETSF
          else
            abi_trio_etsf_serial="no"
            abi_trio_etsf_mpi="no"
          fi
          if test "${abi_trio_etsf_serial}" = "yes"; then
            AC_DEFINE([HAVE_TRIO_ETSF],1,[Define to 1 if you have the ETSF_IO library.])
            dnl FIXME: temporary takeover
            AC_MSG_WARN([disabling ETSF_IO plugin])
            enable_etsf_io="no"
            AC_DEFINE([HAVE_ETSF_IO],1,[Define to 1 if you have the ETSF_IO library.])
          else
            AC_MSG_WARN([falling back to ETSF_IO plugin])
            enable_etsf_io="yes"
          fi
          ;;

        fox)
          _ABI_TRIO_CHECK_FOX
          if test "${abi_trio_fox_serial}" = "yes"; then
            AC_DEFINE([HAVE_TRIO_FOX],1,[Define to 1 if you have the FoX library.])
            dnl FIXME: temporary takeover
            AC_MSG_WARN([disabling FoX plugin])
            enable_fox="no"
            AC_DEFINE([HAVE_FOX],1,[Define to 1 if you have the FoX library.])
          else
            AC_MSG_WARN([falling back to FoX plugin])
            enable_fox="yes"
          fi
          ;;

        hdf)
          _ABI_TRIO_CHECK_HDF
          if test "${abi_trio_hdf_serial}" = "yes"; then
            AC_DEFINE([HAVE_TRIO_HDF],1,[Define to 1 if you have the HDF library.])
          fi
          ;;

        netcdf)
          _ABI_TRIO_CHECK_NETCDF
          if test "${abi_trio_netcdf_serial}" = "yes"; then
            AC_DEFINE([HAVE_TRIO_NETCDF],1,[Define to 1 if you have the NetCDF library.])
            AC_MSG_WARN([disabling NetCDF plugin])
            enable_netcdf="no"
            dnl FIXME: temporary takeover
            AC_DEFINE([HAVE_NETCDF],1,[Define to 1 if you have the NetCDF library.])
          else
            AC_MSG_WARN([falling back to NetCDF plugin])
            enable_netcdf="yes"
          fi
          ;;

        *)
          AC_MSG_ERROR([unknown TRIO flavor '${abi_trio_flavor}'])
          ;;

      esac

    done

    dnl Rebuild actual flavor
    if test "${abi_trio_hdf_serial}" = "no"; then
      abi_trio_iter=`echo "${abi_trio_iter}" | sed -e 's/hdf//'`
    fi
    lib_trio_flavor=`echo "${abi_trio_iter}" | sed -e 's/^[[ ]]*//;s/[[ ]]*$//;s/ [[ ]]*/+/g;'`
  fi

  dnl Transmit information
  lib_trio_fcflags="${abi_trio_netcdf_fcflags} ${abi_trio_etsf_fcflags} ${abi_trio_fox_fcflags} ${abi_trio_hdf_fcflags}"
  lib_trio_ldflags="${abi_trio_netcdf_ldflags} ${abi_trio_etsf_ldflags} ${abi_trio_fox_ldflags} ${abi_trio_hdf_ldflags}"
  lib_trio_incs="${abi_trio_netcdf_incs} ${abi_trio_etsf_incs} ${abi_trio_fox_incs} ${abi_trio_hdf_incs}"
  lib_trio_libs="${abi_trio_etsf_libs} ${abi_trio_netcdf_libs} ${abi_trio_fox_libs} ${abi_trio_hdf_libs}"

  dnl Restore build environment
  AC_LANG_POP
  LIBS="${abi_saved_LIBS}"
  ABI_ENV_RESTORE

  dnl Output final flavor
  if test "${enable_trio}" = "yes"; then
    AC_MSG_CHECKING([for the actual transferable I/O support])
    AC_MSG_RESULT([${lib_trio_flavor}])
  fi

  dnl Substitute variables needed for the use of the library
  AC_SUBST(lib_trio_flavor)
  AC_SUBST(lib_trio_fcflags)
  AC_SUBST(lib_trio_ldflags)
  AC_SUBST(lib_trio_incs)
  AC_SUBST(lib_trio_libs)
]) # ABI_CONNECT_TRIO
