# -*- Autoconf -*-
#
# Copyright (C) 2006-2010 ABINIT Group (Yann Pouillon)
#
# This file is part of the ABINIT software package. For license information,
# please see the COPYING file in the top-level directory of the ABINIT source
# distribution.
#

#
# Tricks for external libraries
#



# ABI_TRICKS_BIGDFT(FC_VENDOR,FC_VERSION)
# ---------------------------------------
#
# Applies tricks and workarounds to have the BigDFT library correctly
# linked to the binaries.
#
AC_DEFUN([ABI_TRICKS_BIGDFT],[
  dnl Do some sanity checking of the arguments
  m4_if([$1], , [AC_FATAL([$0: missing argument 1])])dnl
  m4_if([$2], , [AC_FATAL([$0: missing argument 2])])dnl

  if test "$1" != "unknown"; then
    AC_MSG_NOTICE([applying BigDFT tricks (vendor: $1, version: $2)])
  fi

  CFGFLAGS_BIGDFT="${CFGFLAGS_BIGDFT} --disable-binaries --disable-libabinit --enable-libpoissonsolver"
]) # ABI_TRICKS_BIGDFT



# ABI_TRICKS_ETSF_IO(FC_VENDOR,FC_VERSION)
# ----------------------------------------
#
# Applies tricks and workarounds to have the ETSF I/O library correctly
# linked to the binaries.
#
AC_DEFUN([ABI_TRICKS_ETSF_IO],[
  dnl Do some sanity checking of the arguments
  m4_if([$1], , [AC_FATAL([$0: missing argument 1])])dnl
  m4_if([$2], , [AC_FATAL([$0: missing argument 2])])dnl

  if test "$1" != "unknown"; then
    AC_MSG_NOTICE([applying ETSF_IO tricks (vendor: $1, version: $2)])
  fi

  case "$1" in

    ibm)
      FCFLAGS_ETSF_IO="${FCFLAGS_ETSF_IO} -qsuffix=cpp=f90:f=f"
      ;;

  esac
]) # ABI_TRICKS_ETSF_IO



# ABI_TRICKS_FFTW()
# -----------------
#
# Applies tricks and workarounds to have the FFTW library correctly
# linked to the binaries.
#
AC_DEFUN([ABI_TRICKS_FFTW],
[
  AC_MSG_NOTICE([applying FFTW tricks (not needed yet)])
]) # ABI_TRICKS_FFTW



# ABI_TRICKS_FOX(FC_VENDOR,FC_VERSION)
# ------------------------------------
#
# Applies tricks and workarounds to have the FoX library correctly
# linked to the binaries.
#
AC_DEFUN([ABI_TRICKS_FOX],[
  dnl Do some sanity checking of the arguments
  m4_if([$1], , [AC_FATAL([$0: missing argument 1])])dnl
  m4_if([$2], , [AC_FATAL([$0: missing argument 2])])dnl

  if test "$1" != "unknown"; then
    AC_MSG_NOTICE([applying FOX tricks (vendor: $1, version: $2)])
  fi

  CFGFLAGS_FOX="${CFGFLAGS_FOX} --enable-sax"
]) # ABI_TRICKS_FOX



# ABI_TRICKS_LIBXC(FC_VENDOR,FC_VERSION)
# --------------------------------------
#
# Applies tricks and workarounds to have the LIBXC library correctly
# linked to the binaries.
#
AC_DEFUN([ABI_TRICKS_LIBXC],
[
  AC_MSG_NOTICE([applying LIBXC tricks])

  dnl Enable the build of Fortran modules
  CFGFLAGS_LIBXC="--enable-fortran"

  dnl Enforce C99 programming-style
  case "$1" in

    ibm)
      if test "${ac_cv_prog_cc_c99}" != "no"; then
        CFLAGS_LIBXC="${CFLAGS_LIBXC} ${ac_cv_prog_cc_c99}"
      fi
      ;;

  esac
]) # ABI_TRICKS_LIBXC



# ABI_TRICKS_LINALG(TYPE)
# -----------------------
#
# Applies tricks and workarounds to have the optimized linear algebra
# libraries correctly linked to the binaries.
#
AC_DEFUN([ABI_TRICKS_LINALG],[
  dnl Do some sanity checking of the arguments
  m4_if([$1], , [AC_FATAL([$0: missing argument 1])])dnl

  dnl Init
  linalg_tricks_build=""

  if test "$1" != ""; then
    AC_MSG_NOTICE([applying linear algebra tricks (type: $1)])
  fi

  case "$1" in

    atlas)
      FC_LIBS_LINALG="${FC_LIBS_LINALG} -llapack -lblas"
      linalg_tricks_build="no"
      ;;

    essl)
      FCFLAGS_LINALG="${FCFLAGS_LINALG} -qessl"
      FC_LDFLAGS_TRICKS="${FC_LDFLAGS_TRICKS} -lessl"
      linalg_tricks_bypass="yes"
      ;;

    *)
      AC_MSG_WARN([tricks not yet implemented for $1])
      ;;

  esac

  AC_SUBST(linalg_tricks_bypass)
]) # ABI_TRICKS_LINALG



# ABI_TRICKS_NETCDF(COMPILER, VERSION)
# ------------------------------------
#
# Applies tricks and workarounds to have the optimized linear algebra
# libraries correctly linked to the binaries.
#
AC_DEFUN([ABI_TRICKS_NETCDF],[
  dnl Do some sanity checking of the arguments
  m4_if([$1], , [AC_FATAL([$0: missing argument 1])])dnl
  m4_if([$2], , [AC_FATAL([$0: missing argument 2])])dnl

  if test "$1" != "unknown"; then
    AC_MSG_NOTICE([applying NetCDF tricks (vendor: $1, version: $2)])
  fi

  CFGFLAGS_NETCDF="${CFGFLAGS_NETCDF} --disable-cxx"
  CPPFLAGS_NETCDF="${CPPFLAGS_NETCDF} -DNDEBUG"

  case "$1" in

    g95)
      CPPFLAGS_NETCDF="${CPPFLAGS_NETCDF} -Df2cFortran"
      ;;

    gnu)
      CPPFLAGS_NETCDF="${CPPFLAGS_NETCDF} -DpgiFortran"
      ;;

    ibm)
      CPPFLAGS_NETCDF="${CPPFLAGS_NETCDF} -DIBMR2Fortran"
      FCFLAGS_NETCDF="${FCFLAGS_NETCDF} -WF,-DIBMR2Fortran,-DNDEBUG"
      ;;

    intel)
      CPPFLAGS_NETCDF="${CPPFLAGS_NETCDF} -DpgiFortran"
      case "$2" in
        9.0|9.1)
          FCFLAGS_NETCDF="${FCFLAGS_NETCDF} -mp"
          ;;
        *)
          FCFLAGS_NETCDF="${FCFLAGS_NETCDF} -ip -no-prec-div"
          ;;
      esac
      ;;

    pathscale)
      CPPFLAGS_NETCDF="${CPPFLAGS_NETCDF} -Df2cFortran"
      ;;

    pgi)
      CPPFLAGS_NETCDF="${CPPFLAGS_NETCDF} -DpgiFortran"
      ;;

    sun)
      CPPFLAGS_NETCDF="${CPPFLAGS_NETCDF} -DsunFortran"
      ;;

  esac
]) # ABI_TRICKS_NETCDF



# ABI_TRICKS_WANNIER90(COMPILER, VERSION)
# ---------------------------------------
#
# Applies tricks and workarounds to have the Wannier90 bindings correctly
# linked to the binaries.
#
AC_DEFUN([ABI_TRICKS_WANNIER90],[
  dnl Do some sanity checking of the arguments
  m4_if([$1], , [AC_FATAL([$0: missing argument 1])])dnl
  m4_if([$2], , [AC_FATAL([$0: missing argument 2])])dnl

  if test "$1" != "unknown"; then
    AC_MSG_NOTICE([applying Wannier90 tricks (vendor: $1, version: $2)])
  fi

  CPPFLAGS_WANNIER90="${lib_linalg_incs} ${CPPFLAGS_WANNIER90}"
  FCLIBS_WANNIER90="${lib_linalg_libs} ${FCLIBS_WANNIER90}"

  case "$1" in

    intel)
      case "${target_cpu}" in
        ia64)
          # Do nothing
          ;;
        *)
          FCLIBS_WANNIER90="${FCLIBS_WANNIER90} -lsvml"
          ;;
      esac
      ;;

  esac
]) # ABI_TRICKS_WANNIER90
