#
# Makefile for the LibXC library embedded in ABINIT
#

include ../../config.mk

all_targets all libxc: install
	@echo "$(libxc_pkg_name) is now ready for use."

uncompress: uncompress-stamp
	@echo "$(libxc_pkg_name) has been uncompressed."

patches: patches-stamp
	@echo "$(libxc_pkg_name) has been patched."

configure: configure-stamp
	@echo "$(libxc_pkg_name) has been configured."

build: build-stamp
	@echo "$(libxc_pkg_name) has been built."

install: install-stamp
	@echo "$(libxc_pkg_name) has been installed."

uncompress-stamp:
	gzip -cd $(abinit_tardir)/$(libxc_pkg_name).tar.gz | tar xf -
	sed -i -e "s/^AR.*//g" $(libxc_pkg_name)/src/Makefile.in
	touch uncompress-stamp

patches-stamp: uncompress
	touch patches-stamp

configure-stamp: patches
	cd $(libxc_pkg_name) && \
	 CPP="$(CPP)" \
	 CPPFLAGS="$(CPPFLAGS_LIBXC)" \
	 CC="$(CC)" \
	 CFLAGS="$(CFLAGS_LIBXC)" \
	 FCCPP="$(TRUE_CPP) $(TRUE_CPPFLAGS)" \
	 FC="$(FC)" \
	 FCLIBS="$(FC_LIBS)" \
	 LIBS="$(CC_LIBS)" \
	 FCFLAGS="$(FCFLAGS_FREEFORM) $(FCFLAGS_LIBXC)" \
	 ./configure \
	  --prefix="$(abinit_builddir)/plugins/libxc/tmp" \
	  $(CFGFLAGS_LIBXC)
	touch configure-stamp

build-stamp: configure
	cd $(libxc_pkg_name) && $(MAKE)
	touch build-stamp

install-stamp: build
	cd $(libxc_pkg_name) && $(MAKE) install
	touch install-stamp

clean:
	rm -rf dummy
