!{\src2tex{textfont=tt}}
!!****m* ABINIT/m_initcuda
!! NAME
!! m_initcuda
!!
!! FUNCTION
!!  Module containing all variables concerning GPU device
!!  and the functions needed to extract them
!!
!! COPYRIGHT
!!  Copyright (C) 2009-2010 ABINIT group (MMancini)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!
!! NOTES
!!  Is an experimental development
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#if defined HAVE_GPU_CUDA
#include "cuda_common.h"
#endif

module m_initcuda
    
 use defs_basis

 implicit none

#if defined HAVE_GPU_CUDA
 integer,parameter,public :: cudap=kind(CUDA_KIND)
#endif

!Structures
!!***

!!****t* m_initcuda/devGPU_type
!! NAME
!! devGPU_type
!!
!! FUNCTION
!! This structured datatype used to contains GPU properties
!!
!!
!! SOURCE

 type,public :: devGPU_type
  integer :: ndevice  !--number of available devices
  real,pointer  :: maxmemdev(:)  !--max global memory on any device 
 end type devGPU_type
!!***

 
 private

 private ::            &
   prt_device_info       ! To print information about GPU

 public ::             &
   InitGPU,            & ! Initialise GPU
   Get_Mem_Dev,        & ! To obtain the max memory availeble on GPU device
   Get_ndevice,        & ! Number of devices of Capability>1.2 
   CleanGPU              ! Clean devGPU_type variables


CONTAINS !===========================================================
!!***


!!****f* m_initcuda/prt_device_info
!! NAME
!! prt_device_info
!!
!! FUNCTION
!! Print information about GPU device
!!
!! PARENTS
!!      m_initcuda
!!
!! CHILDREN
!!
!! SOURCE

 subroutine prt_device_info(device)


!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
!End of the abilint section

  implicit none
!Arguments ------------------------------------
  integer,intent(in) :: device
!Local ---------------------------
  integer :: gflop,constmem,sharemem
  integer :: ii,regist,lenname
  real 	  :: globalmem,clockRate
  character(20)  :: name
  character(20)  :: formatdev
  character(500) :: msg
  integer :: vers(0:1)
! *********************************************************************
#if defined HAVE_GPU_CUDA
  write(msg,'(a,80a)')' ',('_',ii=1,80); call wrtout(std_out,msg,'COLL')
  write(msg,'(a25,a25,a31,a)')'________________________',' Graphic Card Properties ','_______________________________' ,ch10
  call wrtout(std_out,msg,'COLL')


  call get_dev_info(device,name,lenname,vers,globalmem,clockRate,gflop,constmem,sharemem,regist)                     
  
  write(formatdev,'(a12,i4,a)'),'(a23,i4,a3,a',lenname,')' 
  write (msg,formatdev)&
       & '  Device             ',device,' : ',name(1:lenname)
  call wrtout(std_out,msg,'COLL') 
  write (msg,'(a39,2(i1,a),2(a35,f7.1,2a),3(a35,i7,2a),a35,i7,a)')&
       & ' Revision number:                   ',vers(0),'.',vers(1),ch10, &
       & ' Total amount of global memory: ',globalmem,' Mbytes',ch10, &
       & ' Clock rate:                    ',clockRate,' GHz',ch10, &
       & ' Max GFLOP:                     ',gflop,' GFP',ch10, &
       & ' Total  constant memory:        ',constmem,' bytes',ch10, &  
       & ' Shared memory per block:       ',sharemem,' bytes',ch10, &
       & ' Number of registers per block: ',regist,ch10
  call wrtout(std_out,msg,'COLL') 
  if(device == -1)then
    write(msg,'(a)')' no cuda-GPU devices found'; call wrtout(std_out,msg,'COLL')
  end if
  write(msg,'(a,80a)')' ',('_',ii=1,80); call wrtout(std_out,msg,'COLL')
#endif
 end subroutine prt_device_info
!!***



!!****f* m_initcuda/InitGPU
!! NAME
!! InitGPU
!!
!! FUNCTION
!! Print information about GPU device
!!
!! PARENTS
!!      m_hidecudarec
!!
!! CHILDREN
!!
!! SOURCE

 subroutine InitGPU(gpuinfo,device)


!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#if defined HAVE_GPU_CUDA
#endif
!End of the abilint section

  implicit none
!Arguments ------------------------------------
  integer,intent(in)              :: device
  type(devGPU_type),intent(inout) :: gpuinfo
!Local ---------------------------
  real :: locmax
! character(500) :: msg
! *********************************************************************
#if defined HAVE_GPU_CUDA

  !--Initialization
  gpuinfo%ndevice = 0
  nullify(gpuinfo%maxmemdev)
  if(device>-1)then
    !--Get the number of device for this proc
    gpuinfo%ndevice = 1 
    allocate(gpuinfo%maxmemdev(0:1))      
    call get_GPU_max_mem(device,locmax)
    gpuinfo%maxmemdev(0:1) = locmax
    call  prt_device_info(device)
  endif

#endif
 end subroutine InitGPU
!!***


!****f* m_initcuda/Get_ndevice
!! NAME
!! Get_ndevice
!!
!! FUNCTION
!! Give the number of device with capability>=1.2
!!
!! PARENTS
!!      m_gpu_detect
!!
!! CHILDREN
!!
!! SOURCE

 subroutine Get_ndevice(ndevice)


   implicit none
!Arguments ------------------------------------
  integer,intent(out) :: ndevice
!Local ---------------------------
! character(500) :: msg
! *********************************************************************
#if defined HAVE_GPU_CUDA
  !--Get the number of device for this proc
  call c_get_ndevice(ndevice)                       
#endif
 end subroutine Get_ndevice
!!***



!!****f* m_initcuda/Get_Mem_Dev
!! NAME
!! Get_Mem_Dev
!!
!! FUNCTION
!! Get the max memory availeble on device
!!
!! INPUTS
!! device  device number
!!
!! OUTPUT
!! max_mem_dev 
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE

subroutine Get_Mem_Dev(device,max_mem_dev)


 implicit none
 !Arguments ------------------------------------
 ! scalars
 integer,intent(in) :: device
 real,intent(out) :: max_mem_dev
 ! arrays
 !Local ----------------------------------------
 ! scalars
 ! *********************************************************************
 
#if defined HAVE_GPU_CUDA
 call get_GPU_max_mem(device,max_mem_dev)
#endif
end subroutine Get_Mem_Dev
!!***


!!****f* m_initcuda/CleanGPU
!! NAME
!! CleanGPU
!!
!! FUNCTION
!! Print information about GPU device
!!
!! PARENTS
!!      m_hidecudarec
!!
!! CHILDREN
!!
!! SOURCE

 subroutine CleanGPU(gpuinfo)


  implicit none
!Arguments ------------------------------------
! scalars
 type(devGPU_type),intent(inout) :: gpuinfo
! arrays
! *********************************************************************

#if defined HAVE_GPU_CUDA
 
  if (associated(gpuinfo%maxmemdev)) deallocate(gpuinfo%maxmemdev)

#endif

 end subroutine CleanGPU
!!***


end module m_initcuda
!!***
