!{\src2tex{textfont=tt}}
!!****m* ABINIT/m_errors
!! NAME
!!  m_errors
!!
!! FUNCTION
!!  This module contains low-level procedures to check assertions and handle errors.
!!
!! COPYRIGHT
!! Copyright (C) 2008-2010 ABINIT group (MG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

MODULE m_errors

 use defs_basis
 use m_xmpi
#if defined HAVE_MPI && defined HAVE_MPI2
 use mpi
#endif

 !use m_build_info,     only : dump_config
 use m_io_tools,        only : flush_unit
 use m_fstrings,        only : toupper, basename
 use m_build_info_fake, only : dump_config_fake

 implicit none

#if defined HAVE_MPI && defined HAVE_MPI1
 include 'mpif.h'
#endif

 private

 public :: assert_eq       ! Report and die gracefully if integers not all equal (used for size checking).
 public :: assert          ! Report and die if any logical is false (used for argument range checking).
 public :: sentinel        ! Announce the entering or the exiting from a procedure.
 public :: die             ! Stop execution in case of unexpected events.
 public :: msg_hndl        ! Basic Error handlers. 
 public :: check_mpi_ierr  ! Erro handler for MPI routines.
 public :: io_hndl         ! Error handler for IO operations on external files.
 public :: unused_var      ! Helper function used to silence compiler warnings due to unused variables.

 integer,public ::  ERR_ALLOCATE_STAT ! Store the status reported by Fortran allocate

 interface assert_eq  
   module procedure assert_eq2
   module procedure assert_eq3
   module procedure assert_eq4
   module procedure assert_eqn
 end interface assert_eq

 interface assert 
   module procedure assert1
   module procedure assert2
   module procedure assert3
   module procedure assert4
   module procedure assert_v
 end interface assert

 interface unused_var
   module procedure unused_int
   module procedure unused_int_d1
   module procedure unused_real_dp
   module procedure unused_real_dp_d1
   module procedure unused_cplx_dpc
   module procedure unused_cplx_dpc_d1
   module procedure unused_ch_d0
 end interface unused_var

CONTAINS  !===========================================================
!!***

!!****f* m_errors/assert_eq2
!! NAME
!!  assert_eq2
!!
!! FUNCTION
!!  Report and die gracefully if integers not all equal (used for size checking).
!!
!! INPUT 
!!  l1,l2,.. Integers to be checked (array version is also provided)
!!  message(len=*)=tag with additional information
!!
!! OUTPUT
!!
!! PARENTS 
!! 
!! CHILDREN
!!
!! SOURCE

function assert_eq2(l1,l2,message,file,line)

!Arguments ------------------------------------

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
!End of the abilint section

 integer,intent(in) :: l1,l2 
 integer,optional,intent(in) :: line
 integer :: assert_eq2
 character(len=*),intent(in) :: message
 character(len=*),optional,intent(in) :: file

!Local variables-------------------------------
 integer :: f90line=0
 character(len=500) :: f90name='Subroutine Unknown'

! *************************************************************************

 if (l1==l2) then
  assert_eq2=l1
 else
  if (PRESENT(line)) f90line=line
  if (PRESENT(file)) f90name= basename(file)
  call msg_hndl(message,'ERROR','COLL',f90name,line)
 end if

end function assert_eq2
!!***

!!****f* m_errors/assert_eq3
!! NAME
!!  assert_eq3
!!
!! FUNCTION
!!  Report and die gracefully if integers not all equal (used for size checking).
!!
!! INPUT 
!!  l1,l2,.. Integers to be checked (array version is also provided)
!!  message(len=*)=tag with additional information
!!
!! OUTPUT
!!
!! PARENTS 
!! 
!! CHILDREN
!!
!! SOURCE

function assert_eq3(l1,l2,l3,message,file,line)

!Arguments ------------------------------------

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
!End of the abilint section

 integer,intent(in) :: l1,l2,l3 
 integer,optional,intent(in) :: line
 integer :: assert_eq3
 character(len=*),intent(in) :: message
 character(len=*),optional,intent(in) :: file

!Local variables-------------------------------
 integer :: f90line=0
 character(len=500) :: f90name='Subroutine Unknown'
! *************************************************************************

 if (l1==l2.and.l2==l3) then
  assert_eq3=l1
 else
  if (PRESENT(line)) f90line=line
  if (PRESENT(file)) f90name= basename(file)
  call msg_hndl(message,'ERROR','COLL',f90name,line)
 end if

end function assert_eq3
!!***

!!****f* m_errors/assert_eq4
!! NAME
!!  assert_eq4
!!
!! FUNCTION
!!  Report and die gracefully if integers not all equal (used for size checking).
!!
!! INPUT 
!!  l1,l2,.. Integers to be checked (array version is also provided)
!!  message(len=*)=tag with additional information
!!
!! OUTPUT
!!
!! PARENTS 
!! 
!! CHILDREN
!!
!! SOURCE

function assert_eq4(l1,l2,l3,l4,message,file,line)

!Arguments ------------------------------------
!scalars

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
!End of the abilint section

 integer,intent(in) :: l1,l2,l3,l4 
 integer,optional,intent(in) :: line
 integer :: assert_eq4
 character(len=*),intent(in) :: message
 character(len=*),optional,intent(in) :: file

!Local variables-------------------------------
 integer :: f90line=0
 character(len=500) :: f90name='Subroutine Unknown'
! *************************************************************************

 if (l1==l2.and.l2==l3.and.l3==l4) then
  assert_eq4=l1
 else
  if (PRESENT(line)) f90line=line
  if (PRESENT(file)) f90name= basename(file)
  call msg_hndl(message,'ERROR','COLL',f90name,line)
 end if

end function assert_eq4
!!***

!!****f* m_errors/assert_eqn
!! NAME
!!  assert_eqn
!!
!! FUNCTION
!!  Report and die gracefully if integers not all equal (used for size checking).
!!
!! INPUT 
!!
!! OUTPUT
!!
!! PARENTS 
!! 
!! CHILDREN
!!
!! SOURCE

function assert_eqn(nn,message,file,line)

!Arguments ------------------------------------
!scalars

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
!End of the abilint section

 integer,optional,intent(in) :: line
 integer :: assert_eqn
 character(len=*),intent(in) :: message
 character(len=*),optional,intent(in) :: file 
!arrays
 integer,intent(in) :: nn(:)

!Local variables-------------------------------
 integer :: f90line=0
 character(len=500) :: f90name='Subroutine Unknown'
! *************************************************************************

 if (ALL(nn(2:)==nn(1))) then
  assert_eqn=nn(1)
 else
  if (PRESENT(line)) f90line=line
  if (PRESENT(file)) f90name= basename(file)
  call msg_hndl(message,'ERROR','COLL',f90name,line)
 end if

end function assert_eqn
!!***

!!****f* m_errors/assert1
!! NAME
!!  assert1
!!
!! FUNCTION
!!  Routines for argument checking and error handling. Report and die if 
!!  any logical is false (used for arg range checking).
!!
!! INPUT 
!!  l1,l2,.. logical values to be checked (array version is also provided)
!!  message(len=*)=tag with additiona information
!!
!! OUTPUT
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE

subroutine assert1(l1,message,file,line)

!Arguments ------------------------------------

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
!End of the abilint section

 integer,optional,intent(in) :: line
 character(len=*),intent(in) :: message
 character(len=*),optional,intent(in) :: file
 logical,intent(in) :: l1

!Local variables-------------------------------
 integer :: f90line=0
 character(len=500) :: f90name='Subroutine Unknown'
! *************************************************************************

 if (.not.l1) then
  if (PRESENT(line)) f90line=line
  if (PRESENT(file)) f90name= basename(file)
  call msg_hndl(message,'ERROR','COLL',f90name,f90line)
 end if

end subroutine assert1
!!***

!----------------------------------------------------------------------

!!****f* m_errors/assert2
!! NAME
!!  assert2
!!
!! FUNCTION
!!  Routines for argument checking and error handling. Report and die if 
!   any logical is false (used for arg range checking).
!!
!! INPUT 
!!  l1,l2,.. logical values to be checked (array version is also provided)
!!  message(len=*)=tag with additional information
!!
!! OUTPUT
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE
subroutine assert2(l1,l2,message,file,line)

!Arguments ------------------------------------

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
!End of the abilint section

 integer,optional,intent(in) :: line
 character(len=*),intent(in) :: message
 character(len=*),optional,intent(in) :: file
 logical,intent(in) :: l1,l2

!Local variables-------------------------------
 integer :: f90line=0
 character(len=500) :: f90name='Subroutine Unknown'
! *************************************************************************

 if (.not.(l1.and.l2)) then
  if (PRESENT(line)) f90line=line
  if (PRESENT(file)) f90name= basename(file)
  call msg_hndl(message,'ERROR','COLL',f90name,f90line)
 end if

end subroutine assert2
!!***

!----------------------------------------------------------------------

!!****f* m_errors/assert3
!! NAME
!!  assert3
!!
!! FUNCTION
!!  Routines for argument checking and error handling. Report and die if 
!!  any logical is false (used for arg range checking).
!!
!! INPUT 
!!  l1,l2,.. logical values to be checked (array version is also provided)
!!  message(len=*)=tag with additional information
!!
!! OUTPUT
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE
subroutine assert3(l1,l2,l3,message,file,line)

!Arguments ------------------------------------

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
!End of the abilint section

 integer,optional,intent(in) :: line
 character(len=*),intent(in) :: message
 character(len=*),optional,intent(in) :: file
 logical,intent(in) :: l1,l2,l3

!Local variables-------------------------------
 integer :: f90line=0
 character(len=500) :: f90name='Subroutine Unknown'
! *************************************************************************

 if (.not.(l1.and.l2.and.l3)) then
  if (PRESENT(line)) f90line=line
  if (PRESENT(file)) f90name= basename(file)
  call msg_hndl(message,'ERROR','COLL',f90name,f90line)
 end if

end subroutine assert3
!!***

!----------------------------------------------------------------------

!!****f* m_errors/assert4
!! NAME
!!  assert4
!!
!! FUNCTION
!!  Routines for argument checking and error handling. Report and die if 
!!  any logical is false (used for arg range checking).
!!
!! INPUT 
!!  l1,l2,.. logical values to be checked (array version is also provided)
!!  message(len=*)=tag with additional information
!!
!! OUTPUT
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE
subroutine assert4(l1,l2,l3,l4,message,file,line)

!Arguments ------------------------------------

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
!End of the abilint section

 integer,optional,intent(in) :: line
 character(len=*),intent(in) :: message
 character(len=*),optional,intent(in) :: file
 logical,intent(in) :: l1,l2,l3,l4

!Local variables-------------------------------
 integer :: f90line=0
 character(len=500) :: f90name='Subroutine Unknown'
! *************************************************************************

 if (.not.(l1.and.l2.and.l3.and.l4)) then
  if (PRESENT(line)) f90line=line
  if (PRESENT(file)) f90name= basename(file)
  call msg_hndl(message,'ERROR','COLL',f90name,f90line)
 end if

end subroutine assert4
!!***

!----------------------------------------------------------------------

!!****f* m_errors/assert_v
!! NAME
!!  assert_v
!!
!! FUNCTION
!!  Routines for argument checking and error handling. Report and die if 
!!  any logical is false (used for arg range checking).
!!
!! INPUT 
!!
!! OUTPUT
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE
subroutine assert_v(n,message,file,line)

!Arguments ------------------------------------

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
!End of the abilint section

 integer,optional,intent(in) :: line
 character(len=*),intent(in) :: message
 character(len=*),optional,intent(in) :: file
 logical,intent(in) :: n(:)

!Local variables-------------------------------
 integer :: f90line=0
 character(len=500) :: f90name='Subroutine Unknown'
! *************************************************************************

 if (.not.ALL(n)) then
  if (PRESENT(line)) f90line=line
  if (PRESENT(file)) f90name= basename(file)
  call msg_hndl(message,'ERROR','COLL',f90name,f90line)
 end if

end subroutine assert_v
!!***

!----------------------------------------------------------------------

!!****f* m_errors/sentinel
!! NAME
!!  sentinel
!!
!! FUNCTION
!!  Announce the entering and the exiting from a function. Useful for poor-man debugging.
!!
!! INPUT 
!!  level=1 when entering, 2 for exit.
!!  mode_paral= ['COLL'|'PERS'|'COLL_SILENT|PERS_SILENT'] 
!!   'COLL' and 'PERS' refer to the output mode used in wrtout to report the message.
!!   'COLL_SILENT' and 'PERS_SILENT' can be used if the procedure is called several times inside a loop.
!!   In this case sentinel will report only the first entry and the first exit using either 'COLL' or 'PERS' mode.
!!  funcname=Name of the procedure to be tested (TODO should be passed through ABI_func)
!!  [lineno]=Line number. Defaults to 0.
!!
!! NOTES
!!  This routine is usually interfaced with the macros defined in abi_common.h
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE

subroutine sentinel(level,mode_paral,funcname,lineno)

!Arguments ------------------------------------

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
 use interfaces_27_toolbox_oop
!End of the abilint section

 integer,intent(in) :: level
 integer,optional,intent(in) :: lineno
 character(len=*),intent(in) :: mode_paral
 character(len=*),optional,intent(in) :: funcname

!Local variables-------------------------------
 integer,save :: level_save=0 
 integer :: ii
 integer :: f90line
 character(len=500),save :: funcname_save
 character(len=4) :: my_mode
 character(len=10) :: lnum
 character(len=500) :: my_funcname='Function Unknown'
 character(len=500) :: msg

! *********************************************************************


 if (toupper(mode_paral)=='COLL_SILENT'.or.toupper(mode_paral)=='PERS_SILENT') then
  ! * Silent mode, check if we are inside a loop.
  if (level==level_save .and. funcname==funcname_save) RETURN
  ii = index( toupper(mode_paral), '_SILENT')
  my_mode=toupper(mode_paral(1:ii-1))
 else 
  ! * Normal mode.
  my_mode=mode_paral
 end if

 level_save   =level
 funcname_save=funcname

 if (my_mode/='COLL'.or.my_mode/='PERS') my_mode='COLL'
 if (PRESENT(funcname)) my_funcname = basename(funcname)

 f90line=0; if (PRESENT(lineno)) f90line=lineno
 call int2char(f90line,lnum)
 my_funcname= TRIM(my_funcname)//":"//TRIM(lnum)

 if (level==1) then 
  msg = TRIM(my_funcname)//' : enter'//ch10
 else if (level==2) then
  msg = TRIM(my_funcname)//' : exit '//ch10
 else 
  call die('Wrong level',__FILE__,__LINE__)
 end if

 call wrtout(std_out,msg,my_mode) 
 call flush_unit(std_out)

end subroutine sentinel
!!***

!----------------------------------------------------------------------

!!****f* m_errors/die
!! NAME
!!  die
!!
!! FUNCTION
!!  Stop smoothly the execution in case of unexpected events reporting the
!!  line number and the file name where the error occurred as well as the 
!!  MPI rank of the processor. This routine is usually interfaced through 
!!  some macro defined in abi_common.h
!!
!! INPUT 
!!  message=String containing additional information on the nature of the problem
!!  line=Line number of the file where problem occurred
!!  f90name=Name of the f90 file containing the caller
!!
!! PARENTS
!!      m_errors
!!
!! CHILDREN
!!
!! SOURCE

subroutine die(message,file,line)

!Arguments ------------------------------------

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
 use interfaces_16_hideleave
 use interfaces_27_toolbox_oop
!End of the abilint section

 integer,optional,intent(in) :: line
 character(len=*),intent(in) :: message
 character(len=*),optional,intent(in) :: file

!Local variables-------------------------------
 integer,parameter :: comm=xmpi_world
 integer :: rank 
 integer :: f90line=0
 character(len=10) :: lnum,strank
 character(len=500) :: f90name='Subroutine Unknown'
 character(len=500) :: msg

! *********************************************************************

 if (PRESENT(line)) f90line=line
 call int2char(f90line,lnum)

 ! === Determine my rank inside MPI_COMM_WORLD ===
 rank = xcomm_rank(comm)
 call int2char(rank,strank)

 if (PRESENT(file)) f90name= basename(file)
 msg=TRIM(f90name)//':'//TRIM(lnum)//' P'//TRIM(strank)

 write(msg,'(a,2x,2a,2x,a)')ch10,&
& TRIM(msg),ch10,&
& TRIM(message)

 call wrtout(std_out,msg,'COLL') 
 call leave_new('COLL')

end subroutine die
!!***

!----------------------------------------------------------------------

!!****f* m_errors/msg_hndl
!! NAME
!!  msg_hndl
!!
!! FUNCTION
!!  Basic error handler for abinit. This routine is usually interfaced through some macro defined in abi_common.h
!!
!! INPUT 
!!  message=string containing additional information on the nature of the problem
!!  level=string defining the type of problem. Possible values are
!!   COMMENT
!!   WARNING
!!   ERROR
!!   BUG
!!  line=line number of the file where problem occurred
!!  file=name of the f90 file containing the caller
!!  mode_paral=Either "COLL" or "PERS".
!!
!! OUTPUT
!!
!! PARENTS
!!      m_abi_etsf,m_errors
!!
!! CHILDREN
!!
!! SOURCE

subroutine msg_hndl(message,level,mode_paral,file,line)

!Arguments ------------------------------------

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
 use interfaces_16_hideleave
 use interfaces_27_toolbox_oop
!End of the abilint section

 integer,optional,intent(in) :: line
 character(len=*),intent(in) :: level,message
 character(len=*),optional,intent(in) :: file
 character(len=*),intent(in) :: mode_paral

!Local variables-------------------------------
 integer :: f90line=0
 character(len=10) :: lnum
 character(len=500) :: f90name='Subroutine Unknown'
 character(len=500) :: my_msg,sbuf
! *********************************************************************

 if (PRESENT(line)) f90line=line
 call int2char(f90line,lnum)

 if (PRESENT(file)) f90name = basename(file)
 my_msg=TRIM(f90name)//":"//TRIM(lnum)//":"

 select case (toupper(level))

 !TODO problem if message is more than one line, wrtout should be modified so 
 ! that assumed shape strings can be passed.
 case ('COMMENT','WARNING')
  write(sbuf,'(a,1x,3a,1x,a)')ch10,&
&  TRIM(my_msg),toupper(level),ch10,&
&  TRIM(message)
  call wrtout(std_out,sbuf,mode_paral) 

 case ('ERROR','BUG')
  write(sbuf,'(a,1x,3a,1x,a)')ch10,&
&  TRIM(my_msg),toupper(level),ch10,&
&  TRIM(message)
  call wrtout(std_out,sbuf,mode_paral) 
  !$call dump_config(std_out)
  call dump_config_fake()
  call leave_new('COLL')

 case default 
  write(sbuf,'(4a)')ch10,&
&  ' msg_hndl: BUG**2 - ',ch10,&
&  ' Wrong value for level '
  call die(sbuf,&
&  __FILE__,__LINE__)
 end select

end subroutine  msg_hndl
!!***

!----------------------------------------------------------------------

!!****f* m_errors/io_hndl
!! NAME
!!  io_hndl
!!
!! FUNCTION
!!  Basic error handler for I/O operations on external files. This routine is usually interfaced 
!!  through some macro defined in abi_common.h
!!
!! INPUT 
!!  unit=Fortran unit number
!!  ios=IO status
!!  f90name=name of the subroutine where error occurs
!!  line=line number in the f90name file
!!
!! OUTPUT
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE

subroutine io_hndl(ios,unit,f90name,line)

!Arguments ------------------------------------

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
 use interfaces_16_hideleave
 use interfaces_27_toolbox_oop
!End of the abilint section

 integer,intent(in) :: unit,ios,line
 character(len=*),intent(in) :: f90name

!Local variables-------------------------------
 character(len=fnlen) :: fname
 character(len=10) :: lnum,s_ios,s_unt
 character(len=500) :: msg
 logical :: lexist,lopened,lnamed
! *********************************************************************

 call int2char(line,lnum) ; msg=TRIM(f90name)//':'//TRIM(lnum)
 call int2char(ios,s_ios) 
 call int2char(unit,s_unt)

 write(msg,'(8a)')ch10,&
& TRIM(msg),' I/O ERROR- ',ch10,&
& ' while operating on unit ',TRIM(s_unt),', iostat = ',TRIM(s_ios)
 call wrtout(std_out,msg,'COLL') 

 inquire(unit=unit,exist=lexist,named=lnamed,opened=lopened)
 fname='None' ; if (lnamed) inquire(unit=unit,name=fname)

 write(msg,'(2a,2(a,l7,a),2a)')&
& ' Inquire reports : ',ch10,&
& '  exist  = ',lexist,ch10,&
& '  opened = ',lopened,ch10,&
& '  name   = ',TRIM(fname)
 call wrtout(std_out,msg,'COLL') 
 
 call leave_new('COLL')

end subroutine io_hndl
!!***

!----------------------------------------------------------------------

!!****f* m_errors/check_mpi_ierr
!! NAME
!!  check_mpi_ierr
!!
!! FUNCTION
!!  Basic error handler for MPI calls. This routine is usually interfaced through some macro defined in abi_common.h
!!
!! INPUT 
!!  ierr=Exit status reported by an MPI call.
!!  line=line number of the file where problem occurred
!!  file=name of the f90 file containing the caller
!!  mode_paral=Either "COLL" or "PERS".
!!
!! OUTPUT
!!  Write error message thep stop execution.
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE

subroutine check_mpi_ierr(ierr,msg,mode_paral,file,line)

 use defs_basis

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
 use interfaces_16_hideleave
 use interfaces_27_toolbox_oop
!End of the abilint section

 implicit none

!Arguments ------------------------------------
 integer,intent(in) :: ierr
 integer,optional,intent(in) :: line
 character(len=*),intent(in) :: msg,mode_paral
 character(len=*),optional,intent(in) :: file

!Local variables-------------------------------
 integer,parameter :: mpi_msg_len=1000
 integer :: f90line=0 
 integer :: ilen,ierr2
 character(len=10) :: lnum
 character(len=500) :: f90name='Subroutine Unknown'
 character(len=mpi_msg_len) :: mpi_msg_error
 character(len=500) :: my_msg
! *********************************************************************

#ifdef HAVE_MPI
 if (ierr==MPI_SUCCESS) RETURN
 call MPI_ERROR_STRING(ierr, mpi_msg_error, ilen, ierr2)
#else
 ilen=0; ierr2=0
 mpi_msg_error = " Check_mpi_ierr should not be called in non-MPI mode!"
 if (ierr==0) RETURN
#endif

 if (ilen>mpi_msg_len) write(*,*)" Warning_ MPI message has been truncated!"
 if (ierr2/=0) write(*,*)" Warning: MPI_ERROR_STRING returned ierr2= ",ierr2

 if (PRESENT(line)) f90line=line
 call int2char(f90line,lnum)

 if (PRESENT(file)) f90name = basename(file)
 my_msg=" "//TRIM(f90name)//":"//TRIM(lnum)//":"//TRIM(msg)
 call wrtout(std_out,my_msg,mode_paral) 
 call wrtout(std_out,mpi_msg_error,mode_paral) 

 call leave_new('COLL')

end subroutine check_mpi_ierr
!!***

!----------------------------------------------------------------------

!!****f* m_errors/unused_int
!! NAME
!!  unused_int
!!
!! FUNCTION
!!  Helper function used to silence compiler warnings due to unused variables.  
!!  Interfaced via the ABI_UNUSED macro.
!!
!! INPUT 
!!  var=Scalar integer value
!!
!! OUTPUT
!!  None
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE

subroutine unused_int(var) 

!Arguments ------------------------------------

 integer,intent(in) :: var

!Local variables-------------------------------
 integer :: dummy
! *********************************************************************

 dummy = var

end subroutine unused_int
!!***

!----------------------------------------------------------------------

!!****f* m_errors/unused_int_d1
!! NAME
!!  unused_int_d1
!!
!! FUNCTION
!!  Helper function used to silence compiler warnings due to unused variables.  
!!  Interfaced via the ABI_UNUSED macro. Target: one-dimensional integer vector.
!!
!! INPUT 
!!  var_arr=Vector of integer values.
!!
!! OUTPUT
!!  None
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE

subroutine unused_int_d1(var_arr) 

!Arguments ------------------------------------

 integer,intent(in) :: var_arr(:)

!Local variables-------------------------------
 integer :: dummy(SIZE(var_arr))
! *********************************************************************

 dummy = var_arr

end subroutine unused_int_d1
!!***

!----------------------------------------------------------------------

!!****f* m_errors/unused_real_dp
!! NAME
!!  unused_real_dp
!!
!! FUNCTION
!!  Helper function used to silence warning messages due to unused variables.  
!!  Interfaced via the ABI_UNUSED macro.
!!
!! INPUT 
!!  var=Scalar real value.
!!
!! OUTPUT
!!  None
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE

subroutine unused_real_dp(var) 

!Arguments ------------------------------------

 real(dp),intent(in) :: var

!Local variables-------------------------------
 real(dp) :: dummy
! *********************************************************************

 dummy = var

end subroutine unused_real_dp
!!***

!----------------------------------------------------------------------

!!****f* m_errors/unused_real_dp_d1
!! NAME
!!  unused_real_dp_d1
!!
!! FUNCTION
!!  Helper function used to silence compiler warnings due to unused variables.  
!!  Interfaced via the ABI_UNUSED macro. Target: one-dimensional real(dp) vector.
!!
!! INPUT 
!!  var_arr=Vector of real(dp) values.
!!
!! OUTPUT
!!  None
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE

subroutine unused_real_dp_d1(var_arr) 

!Arguments ------------------------------------

 real(dp),intent(in) :: var_arr(:)

!Local variables-------------------------------
 real(dp) :: dummy(SIZE(var_arr))
! *********************************************************************

 dummy = var_arr

end subroutine unused_real_dp_d1
!!***

!----------------------------------------------------------------------

!!****f* m_errors/unused_cplx_dpc
!! NAME
!!  unused_cplx_dpc
!!
!! FUNCTION
!!  Helper function used to silence compiler warnings due to unused variables.  
!!  Interfaced via the ABI_UNUSED macro.
!!
!! INPUT 
!!  var=Scalar complex value
!!
!! OUTPUT
!!  None
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE

subroutine unused_cplx_dpc(var) 

!Arguments ------------------------------------

 complex(dpc),intent(in) :: var

!Local variables-------------------------------
 complex(dpc) :: dummy
! *********************************************************************

 dummy = var

end subroutine unused_cplx_dpc
!!***

!----------------------------------------------------------------------

!!****f* m_errors/unused_cplx_dpc_d1
!! NAME
!!  unused_cplx_dpc_d1
!!
!! FUNCTION
!!  Helper function used to silence compiler warnings due to unused variables.  
!!  Interfaced via the ABI_UNUSED macro. Target: one-dimensional complex(dpc) vector.
!!
!! INPUT 
!!  var_arr=Vector of complex(dpc) values.
!!
!! OUTPUT
!!  None
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE

subroutine unused_cplx_dpc_d1(var_arr) 

!Arguments ------------------------------------

 complex(dpc),intent(in) :: var_arr(:)

!Local variables-------------------------------
 complex(dpc) :: dummy(SIZE(var_arr))
! *********************************************************************

 dummy = var_arr

end subroutine unused_cplx_dpc_d1
!!***

!----------------------------------------------------------------------

!!****f* m_errors/unused_ch_d0
!! NAME
!!  unused_ch_d0
!!
!! FUNCTION
!!  Helper function used to silence compiler warnings due to unused variables.  
!!  Interfaced via the ABI_UNUSED macro.
!!
!! INPUT 
!!  var=Scalar character value
!!
!! OUTPUT
!!  None
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE

subroutine unused_ch_d0(var) 

!Arguments ------------------------------------

 character(len=*),intent(in) :: var

!Local variables-------------------------------
 character(len=LEN(var)) :: dummy
! *********************************************************************

 dummy = var

end subroutine unused_ch_d0
!!***

!----------------------------------------------------------------------

END MODULE m_errors
!!***
