!{\src2tex{textfont=tt}}
!!****f* ABINIT/dist2
!! NAME
!!  dist2 
!!
!! FUNCTION
!!  dist2(v1,v2,rprimd,option) calculates the distance of v1 and v2 in a crystal by
!!  repeating the unit-cell 
!!
!! COPYRIGHT
!!  Copyright (C) 1998-2010 ABINIT group (DJA)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!  For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  v1,v2
!!  rprimd: dimensions of the unit cell. if not given 1,0,0/0,1,0/0,0,1 is assumed
!!  option: 0 v1, v2 given in cartesian coordinates (default) / 1 v1,v2 given in reciprocal coordinates
!!
!! OUTPUT
!!  dist2
!!
!! PARENTS
!!  ioniondist
!!
!! CHILDREN
!!
!! SOURCE


#if defined HAVE_CONFIG_H
#include "config.h"
#endif

function dist2(v1,v2,rprimd,option)

 use defs_basis

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in),optional                      :: option
 real(dp)                                         :: dist2
!arrays
 real(dp),intent(in),dimension(3,3),optional      :: rprimd
 real(dp),intent(in),dimension(3)                 :: v1,v2

!Local variables-------------------------------
!scalars
 integer                               :: iatom
!arrays
 real(dp),dimension(3)                 :: hv1,hv2
 real(dp)                              :: gprimd(3,3),hx(3,27),distv(27)

! *************************************************************************
 if (.not.PRESENT(rprimd)) then
   gprimd=reshape((/1,0,0,  0,1,0,  0,0,1/),(/3,3/))
 else
   gprimd=rprimd
 end if

 if (option==1) then
   hv1=matmul(gprimd,v1)
   hv2=matmul(gprimd,v2)
 else
   hv1=v1
   hv2=v2
 end if

 hx=reshape((/0,0,0,  0,0,1,  0,0,-1,  0,1,0,  0,1,1,  0,1,-1,  0,-1,0,&
& 0,-1,1,  0,-1,-1,  1,0,0,  1,0,1,  1,0,-1,  1,1,0,  1,1,1,&
& 1,1,-1,  1,-1,0,  1,-1,1,  1,-1,-1,  -1,0,0,  -1,0,1,  -1,0,-1,&
& -1,1,0,  -1,1,1,  -1,1,-1,  -1,-1,0,  -1,-1,1,  -1,-1,-1/),(/3,27/))
 hx=matmul(gprimd,hx)
 do iatom=1,27
   hx(:,iatom)=hv2-hv1-hx(:,iatom)
   distv(iatom)=sqrt(dot_product(hx(:,iatom),hx(:,iatom)))
 end do
 dist2=minval(distv)

end function dist2
!!***
