!{\src2tex{textfont=tt}}
!!****f* ABINIT/hist2var
!!
!! NAME
!! hist2var
!!
!! FUNCTION
!! Set the values of xcart, xred, acell and rprimd
!! with the values that comes from the history "hist"
!!
!! COPYRIGHT
!! Copyright (C) 1998-2010 ABINIT group (DCA, XG, GMR)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors,
!! see ~abinit/doc/developers/contributors.txt .
!!
!! INPUT (in)
!! ab_mover<type ab_movetype>=Subset of dtset only related with
!!          |                 movement of ions and acell, contains:
!!          | dtion:  Time step
!!          ! natom:  Number of atoms
!!          | vis:    viscosity
!!          | iatfix: Index of atoms and directions fixed
!!          | amass:  Mass of ions
!! hist<type ab_movehistory>=Historical record of positions, forces
!!      |                    acell, stresses, and energies,
!!      |                    contains:
!!      | mxhist:  Maximun number of records
!!      | ihistA:  Index of present record of histA
!!      | ihistE:  Index of present record of histE
!!      | ihistR:  Index of present record of histR
!!      | ihistS:  Index of present record of histS
!!      | ihistV:  Index of present record of histV
!!      | ihistXF: Index of present record of histXF
!!      | histA:   Historical record of acell(A) and rprimd(R)
!!      | histE:   Historical record of energy(E)
!!      | histR:   Historical record of rprimd(R)
!!      | histS:   Historical record of strten(S)
!!      | histV:   Historical record of velocity(V)
!!      | histXF:  Historical record of positions(X) and forces(F)
!!
!! OUTPUT (out)
!!  xred(3,ab_mover%natom) = reduced dimensionless atomic
!!                           coordinates
!!  xcart(3,ab_mover%natom)= cartesian dimensional atomic
!!                           coordinates (bohr)
!!  acell(3)    = length scales of primitive translations (bohr)
!!  rprimd(3,3) = dimensionless real space primitive translations
!!                (bohr)
!!
!! SIDE EFFECTS (inout)
!!
!! PARENTS
!!      mover,pred_bfgs,pred_moldyn
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine hist2var(ab_mover,hist,acell,rprimd,xcart,xred)

! define dp,sixth,third,etc...
use defs_basis
! type(ab_movetype), type(ab_movehistory)
use defs_mover

implicit none

!Arguments ------------------------------------
!scalars
type(ab_movetype),intent(in) :: ab_mover
type(ab_movehistory),intent(in) :: hist
!arrays
real(dp),intent(out) :: acell(3)
real(dp),intent(out) :: rprimd(3,3)
real(dp),intent(out) :: xcart(3,ab_mover%natom)
real(dp),intent(out) :: xred(3,ab_mover%natom)

!Local variables-------------------------------
!scalars
!integer :: jj,kk

! *************************************************************

 xcart(:,:) =hist%histXF(:,:,1,hist%ihist)
 xred(:,:)  =hist%histXF(:,:,2,hist%ihist)
 acell(:)   =hist%histA(:,hist%ihist)
 rprimd(:,:)=hist%histR(:,:,hist%ihist)

!! ###########################################################
!! ### 1. XCART

!do kk=1,ab_mover%natom
!do jj=1,3
!xcart(jj,kk)=hist%histXF(jj,kk,1,hist%ihist)
!end do
!end do

!! ###########################################################
!! ### 2. XRED

!do kk=1,ab_mover%natom
!do jj=1,3
!xred(jj,kk)=hist%histXF(jj,kk,2,hist%ihist)
!end do
!end do

!! ###########################################################
!! ### 3. ACELL

!do jj=1,3
!acell(jj)=hist%histA(jj,hist%ihist)
!end do

!! ###########################################################
!! ### 4. RPRIMD

!do kk=1,3
!do jj=1,3
!rprimd(jj,kk)=hist%histR(jj,kk,hist%ihist)
!end do
!end do

end subroutine hist2var
!!***
