!!****m* ABINIT/interfaces_42_geomoptim
!! NAME
!! interfaces_42_geomoptim
!!
!! FUNCTION
!! This module contains the interfaces of the routines
!! in the directory src/42_geomoptim
!!
!! COPYRIGHT
!! Copyright (C) 2010 ABINIT group
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!!
!! NOTES
!! THIS FILE IS GENERATED AUTOMATICALLY BY abilint.
!! To do that: config/scripts/abilint . .
!! 
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

module interfaces_42_geomoptim

 implicit none

interface
 subroutine calc_b_matrix(deloc,natom,rprimd,xcart,b_matrix)
  use defs_mover
  use defs_basis
  implicit none
  integer,intent(in) :: natom
  type(ab_delocint),intent(inout) :: deloc
  real(dp),intent(out) :: b_matrix(deloc%ninternal,3*natom)
  real(dp),intent(in) :: rprimd(3,3)
  real(dp),intent(in) :: xcart(3,natom)
 end subroutine calc_b_matrix
end interface

interface
 subroutine dbond_length_d1(r1,r2,bb)
  use defs_basis
  implicit none
  real(dp),intent(out) :: bb(3)
  real(dp),intent(in) :: r1(3)
  real(dp),intent(in) :: r2(3)
 end subroutine dbond_length_d1
end interface

interface
 subroutine dang_d1(r1,r2,r3,bb)
  use defs_basis
  implicit none
  real(dp),intent(out) :: bb(3)
  real(dp),intent(in) :: r1(3)
  real(dp),intent(in) :: r2(3)
  real(dp),intent(in) :: r3(3)
 end subroutine dang_d1
end interface

interface
 subroutine dang_d2(r1,r2,r3,bb)
  use defs_basis
  implicit none
  real(dp),intent(out) :: bb(3)
  real(dp),intent(in) :: r1(3)
  real(dp),intent(in) :: r2(3)
  real(dp),intent(in) :: r3(3)
 end subroutine dang_d2
end interface

interface
 subroutine ddihedral_d1(r1,r2,r3,r4,bb)
  use defs_basis
  implicit none
  real(dp),intent(out) :: bb(3)
  real(dp),intent(in) :: r1(3)
  real(dp),intent(in) :: r2(3)
  real(dp),intent(in) :: r3(3)
  real(dp),intent(in) :: r4(3)
 end subroutine ddihedral_d1
end interface

interface
 subroutine ddihedral_d2(r1,r2,r3,r4,bb)
  use defs_basis
  implicit none
  real(dp),intent(out) :: bb(3)
  real(dp),intent(in) :: r1(3)
  real(dp),intent(in) :: r2(3)
  real(dp),intent(in) :: r3(3)
  real(dp),intent(in) :: r4(3)
 end subroutine ddihedral_d2
end interface

interface
 subroutine calc_prim_int(deloc,natom,rprimd,xcart,prim_int)
  use defs_mover
  use defs_basis
  implicit none
  integer,intent(in) :: natom
  type(ab_delocint),intent(inout) :: deloc
  real(dp),intent(out) :: prim_int(deloc%ninternal)
  real(dp),intent(in) :: rprimd(3,3)
  real(dp),intent(in) :: xcart(3,natom)
 end subroutine calc_prim_int
end interface

interface
 function bond_length(r1,r2)
  use defs_basis
  implicit none
  real(dp) :: bond_length
  real(dp),intent(in) :: r1(3)
  real(dp),intent(in) :: r2(3)
 end function bond_length
end interface

interface
 function angle_ang(r1,r2,r3)
  use defs_basis
  implicit none
  real(dp) :: angle_ang
  real(dp),intent(in) :: r1(3)
  real(dp),intent(in) :: r2(3)
  real(dp),intent(in) :: r3(3)
 end function angle_ang
end interface

interface
 function angle_dihedral(r1,r2,r3,r4)
  use defs_basis
  implicit none
  real(dp) :: angle_dihedral
  real(dp),intent(in) :: r1(3)
  real(dp),intent(in) :: r2(3)
  real(dp),intent(in) :: r3(3)
  real(dp),intent(in) :: r4(3)
 end function angle_dihedral
end interface

interface
 subroutine chkrprimd(acell,rprim,rprimd,iout)
  use defs_basis
  implicit none
  integer,intent(in) :: iout
  real(dp),intent(in) :: acell(3)
  real(dp),intent(in) :: rprim(3,3)
  real(dp),intent(in) :: rprimd(3,3)
 end subroutine chkrprimd
end interface

interface
 subroutine deloc2xcart(deloc,natom,rprimd,xcart,&  
  &  deloc_int,btinv,u_matrix)
  use defs_mover
  use defs_basis
  implicit none
  integer,intent(in) :: natom
  type(ab_delocint),intent(inout) :: deloc
  real(dp),intent(out) :: btinv(3*(natom-1),3*natom)
  real(dp),intent(in) :: deloc_int(3*(natom-1))
  real(dp),intent(in) :: rprimd(3,3)
  real(dp),intent(inout) :: u_matrix(deloc%ninternal,3*(natom-1))
  real(dp),intent(inout) :: xcart(3,natom)
 end subroutine deloc2xcart
end interface

interface
 subroutine fred2fdeloc(btinv,deloc_force,fred,natom,gprimd)
  use defs_basis
  implicit none
  integer, intent(in) :: natom
  real(dp),intent(in) :: btinv(3*(natom-1),3*natom)
  real(dp),intent(out) :: deloc_force(3*(natom-1))
  real(dp),intent(in) :: fred(3,natom)
  real(dp),intent(in) :: gprimd(3,3)
 end subroutine fred2fdeloc
end interface

interface
 subroutine hessinit_new(ab_mover, hessin, init_matrix, ndim, ucvol)
  use defs_mover
  use defs_basis
  implicit none
  integer,intent(in) :: ndim
  type(ab_movetype),intent(in) :: ab_mover
  real(dp),intent(in) :: ucvol
  real(dp),intent(out) :: hessin(ndim,ndim)
  real(dp),intent(in) :: init_matrix(3,3)
 end subroutine hessinit_new
end interface

interface
 subroutine hessupdt(hessin,iatfix,natom,ndim,vin,vin_prev,vout,vout_prev)
  use defs_basis
  implicit none
  integer,intent(in) :: natom
  integer,intent(in) :: ndim
  real(dp),intent(inout) :: hessin(ndim,ndim)
  integer,intent(in) :: iatfix(3,natom)
  real(dp),intent(in) :: vin(ndim)
  real(dp),intent(in) :: vin_prev(ndim)
  real(dp),intent(in) :: vout(ndim)
  real(dp),intent(in) :: vout_prev(ndim)
 end subroutine hessupdt
end interface

interface
 subroutine hist2var(ab_mover,hist,acell,rprimd,xcart,xred)
  use defs_mover
  use defs_basis
  implicit none
  type(ab_movetype),intent(in) :: ab_mover
  type(ab_movehistory),intent(in) :: hist
  real(dp),intent(out) :: acell(3)
  real(dp),intent(out) :: rprimd(3,3)
  real(dp),intent(out) :: xcart(3,ab_mover%natom)
  real(dp),intent(out) :: xred(3,ab_mover%natom)
 end subroutine hist2var
end interface

interface
 subroutine make_angles(deloc,icenter,natom)
  use defs_mover
  implicit none
  integer,intent(in) :: icenter
  integer,intent(in) :: natom
  type(ab_delocint),intent(inout) :: deloc
 end subroutine make_angles
end interface

interface
 subroutine make_bonds(deloc,natom,ntypat,icenter,rprimd,typat,xcart,znucl)
  use defs_mover
  use defs_basis
  implicit none
  integer,intent(in) :: icenter
  integer,intent(in) :: natom
  integer,intent(in) :: ntypat
  type(ab_delocint),intent(inout) :: deloc
  real(dp),intent(in) :: rprimd(3,3)
  integer,intent(in) :: typat(natom)
  real(dp),intent(in) :: xcart(3,natom)
  real(dp),intent(in) :: znucl(:)
 end subroutine make_bonds
end interface

interface
 subroutine make_dihedrals(badangles,deloc,icenter)
  use defs_mover
  implicit none
  integer,intent(in) :: icenter
  type(ab_delocint),intent(inout) :: deloc
  integer,intent(in) :: badangles(deloc%nang)
 end subroutine make_dihedrals
end interface

interface
 subroutine make_prim_internals(deloc,icenter,natom,ntypat,rprimd,&  
  &  typat,xcart,znucl)
  use defs_mover
  use defs_basis
  implicit none
  integer,intent(in) :: icenter
  integer,intent(in) :: natom
  integer,intent(in) :: ntypat
  type(ab_delocint),intent(inout) :: deloc
  real(dp),intent(in) :: rprimd(3,3)
  integer,intent(in) :: typat(natom)
  real(dp),intent(in) :: xcart(3,natom)
  real(dp),intent(in) :: znucl(:)
 end subroutine make_prim_internals
end interface

interface
 subroutine predict_copy(acell_timimage,itimimage,list_dynimage,natom,ndynimage,nimage,ntimimage,&  
  &  rprim_timimage,vel_timimage,xred_timimage)
  use defs_basis
  implicit none
  integer,intent(in) :: itimimage
  integer,intent(in) :: natom
  integer,intent(in) :: ndynimage
  integer,intent(in) :: nimage
  integer,intent(in) :: ntimimage
  real(dp),intent(inout) :: acell_timimage(3,nimage,ntimimage)
  integer,intent(in) :: list_dynimage(ndynimage)
  real(dp),intent(inout) :: rprim_timimage(3,3,nimage,ntimimage)
  real(dp),intent(inout) :: vel_timimage(3,natom,nimage,ntimimage)
  real(dp),intent(inout) :: xred_timimage(3,natom,nimage,ntimimage)
 end subroutine predict_copy
end interface

interface
 subroutine predict_ga(acell_timimage,fxcartfactor,itimimage,list_dynimage,natom,ndynimage,nimage,ntimimage,&  
  &  results_gs_timimage,rprim_timimage,vel_timimage,xred_timimage)
  use defs_basis
  use defs_datatypes
  implicit none
  integer,intent(in) :: itimimage
  integer,intent(in) :: natom
  integer,intent(in) :: ndynimage
  integer,intent(in) :: nimage
  integer,intent(in) :: ntimimage
  real(dp),intent(in) :: fxcartfactor
  real(dp),intent(inout) :: acell_timimage(3,nimage,ntimimage)
  integer,intent(in) :: list_dynimage(ndynimage)
  type(results_gs_type) :: results_gs_timimage(nimage,ntimimage)
  real(dp),intent(inout) :: rprim_timimage(3,3,nimage,ntimimage)
  real(dp),intent(inout) :: vel_timimage(3,natom,nimage,ntimimage)
  real(dp),intent(inout) :: xred_timimage(3,natom,nimage,ntimimage)
 end subroutine predict_ga
end interface

interface
 subroutine predict_pimd(acell_timimage,fxcartfactor,iatfix,itimimage,list_dynimage,natom,ndynimage,nimage,ntimimage,&  
  &  results_gs_timimage,rprim_timimage,vel_timimage,xred_timimage,mdparam)
  use defs_mover
  use defs_basis
  use defs_datatypes
  implicit none
  integer,intent(in) :: itimimage
  integer,intent(in) :: natom
  integer,intent(in) :: ndynimage
  integer,intent(in) :: nimage
  integer,intent(in) :: ntimimage
  real(dp),intent(in) :: fxcartfactor
  type(ab_movetype) :: mdparam
  real(dp),intent(inout) :: acell_timimage(3,nimage,ntimimage)
  integer,intent(in) :: iatfix(3,natom)
  integer,intent(in) :: list_dynimage(ndynimage)
  type(results_gs_type) :: results_gs_timimage(nimage,ntimimage)
  real(dp),intent(inout) :: rprim_timimage(3,3,nimage,ntimimage)
  real(dp),intent(inout) :: vel_timimage(3,natom,nimage,ntimimage)
  real(dp),intent(inout) :: xred_timimage(3,natom,nimage,ntimimage)
 end subroutine predict_pimd
end interface

interface
 subroutine predict_steepest(acell_timimage,fxcartfactor,itimimage,list_dynimage,natom,ndynimage,nimage,ntimimage,&  
  &  results_gs_timimage,rprim_timimage,vel_timimage,xred_timimage)
  use defs_basis
  use defs_datatypes
  implicit none
  integer,intent(in) :: itimimage
  integer,intent(in) :: natom
  integer,intent(in) :: ndynimage
  integer,intent(in) :: nimage
  integer,intent(in) :: ntimimage
  real(dp),intent(in) :: fxcartfactor
  real(dp),intent(inout) :: acell_timimage(3,nimage,ntimimage)
  integer,intent(in) :: list_dynimage(ndynimage)
  type(results_gs_type) :: results_gs_timimage(nimage,ntimimage)
  real(dp),intent(inout) :: rprim_timimage(3,3,nimage,ntimimage)
  real(dp),intent(inout) :: vel_timimage(3,natom,nimage,ntimimage)
  real(dp),intent(inout) :: xred_timimage(3,natom,nimage,ntimimage)
 end subroutine predict_steepest
end interface

interface
 subroutine predict_string(acell_timimage,fxcartfactor,iatfix,itimimage,list_dynimage,natom,ndynimage,nimage,ntimimage,&  
  &  results_gs_timimage,rprim_timimage,vel_timimage,xred_timimage)
  use defs_basis
  use defs_datatypes
  implicit none
  integer,intent(in) :: itimimage
  integer,intent(in) :: natom
  integer,intent(in) :: ndynimage
  integer,intent(in) :: nimage
  integer,intent(in) :: ntimimage
  real(dp),intent(in) :: fxcartfactor
  real(dp),intent(inout) :: acell_timimage(3,nimage,ntimimage)
  integer,intent(in) :: iatfix(3,natom)
  integer,intent(in) :: list_dynimage(ndynimage)
  type(results_gs_type) :: results_gs_timimage(nimage,ntimimage)
  real(dp),intent(inout) :: rprim_timimage(3,3,nimage,ntimimage)
  real(dp),intent(inout) :: vel_timimage(3,natom,nimage,ntimimage)
  real(dp),intent(inout) :: xred_timimage(3,natom,nimage,ntimimage)
 end subroutine predict_string
end interface

interface
 subroutine predictimg(acell_timimage,fxcartfactor,iatfix,imgmov,itimimage,list_dynimage,natom,ndynimage,nimage,ntimimage,&  
  &  results_gs_timimage,rprim_timimage,vel_timimage,xred_timimage,mdparam)
  use defs_mover
  use defs_basis
  use defs_datatypes
  implicit none
  integer,intent(in) :: imgmov
  integer,intent(in) :: itimimage
  integer,intent(in) :: natom
  integer,intent(in) :: ndynimage
  integer,intent(in) :: nimage
  integer,intent(in) :: ntimimage
  real(dp),intent(in) :: fxcartfactor
  type(ab_movetype) :: mdparam
  real(dp),intent(inout) :: acell_timimage(3,nimage,ntimimage)
  integer,intent(in) :: iatfix(3,natom)
  integer,intent(in) :: list_dynimage(ndynimage)
  type(results_gs_type) :: results_gs_timimage(nimage,ntimimage)
  real(dp),intent(inout) :: rprim_timimage(3,3,nimage,ntimimage)
  real(dp),intent(inout) :: vel_timimage(3,natom,nimage,ntimimage)
  real(dp),intent(inout) :: xred_timimage(3,natom,nimage,ntimimage)
 end subroutine predictimg
end interface

interface
 subroutine prtxfase(ab_mover,hist,iout,icycle,itime,pos)
  use defs_mover
  implicit none
  integer,intent(in) :: icycle
  integer,intent(in) :: iout
  integer,intent(in) :: itime
  integer,intent(in) :: pos
  type(ab_movetype),intent(in) :: ab_mover
  type(ab_movehistory),intent(in) :: hist
 end subroutine prtxfase
end interface

interface
 subroutine strainsym(nsym,rprimd0,rprimd,rprimd_symm,symrel)
  use defs_basis
  implicit none
  integer,intent(in) :: nsym
  real(dp),intent(in) :: rprimd(3,3)
  real(dp),intent(in) :: rprimd0(3,3)
  real(dp),intent(out) :: rprimd_symm(3,3)
  integer,intent(in) :: symrel(3,3,nsym)
 end subroutine strainsym
end interface

interface
 subroutine var2hist(ab_mover,hist,acell,rprimd,xcart,xred)
  use defs_mover
  use defs_basis
  implicit none
  type(ab_movetype),intent(in) :: ab_mover
  type(ab_movehistory),intent(inout) :: hist
  real(dp),intent(in) :: acell(3)
  real(dp),intent(in) :: rprimd(3,3)
  real(dp),intent(in) :: xcart(3,ab_mover%natom)
  real(dp),intent(in) :: xred(3,ab_mover%natom)
 end subroutine var2hist
end interface

interface
 subroutine xcart2deloc(deloc,natom,rprimd,xcart,&  
  &  bt_inv_matrix,u_matrix,deloc_int,prim_int)
  use defs_mover
  use defs_basis
  implicit none
  integer,intent(in) :: natom
  type(ab_delocint),intent(inout) :: deloc
  real(dp),intent(out) :: bt_inv_matrix(3*(natom-1),3*natom)
  real(dp),intent(out) :: deloc_int(3*(natom-1))
  real(dp),intent(out) :: prim_int(deloc%ninternal)
  real(dp),intent(in) :: rprimd(3,3)
  real(dp),intent(inout) :: u_matrix(deloc%ninternal,3*(natom-1))
  real(dp),intent(in) :: xcart(3,natom)
 end subroutine xcart2deloc
end interface

interface
 subroutine calc_btinv_matrix(b_matrix,natom,&  
  &  ninternal,bt_inv_matrix,u_matrix)
  use defs_basis
  implicit none
  integer,intent(in) :: natom
  integer,intent(in) :: ninternal
  real(dp),intent(in) :: b_matrix(ninternal,3*natom)
  real(dp),intent(out) :: bt_inv_matrix(3*(natom-1),3*natom)
  real(dp),intent(inout) :: u_matrix(ninternal,3*(natom-1))
 end subroutine calc_btinv_matrix
end interface

interface
 subroutine align_u_matrices(natom,ninternal,u_matrix,u_matrix_old,s_matrix,f_eigs)
  use defs_basis
  implicit none
  integer,intent(in) :: natom
  integer,intent(in) :: ninternal
  real(dp),intent(inout) :: f_eigs(3*natom)
  real(dp),intent(inout) :: s_matrix(3*natom,3*natom)
  real(dp),intent(inout) :: u_matrix(ninternal,3*(natom-1))
  real(dp),intent(in) :: u_matrix_old(ninternal,3*(natom-1))
 end subroutine align_u_matrices
end interface

interface
 subroutine xfh_recover_deloc(ab_xfh,ab_mover,acell,acell0,cycl_main,&  
  &  fred,hessin,ndim,rprim,rprimd0,strten,ucvol,ucvol0,vin,vin_prev,&  
  &  vout,vout_prev,xred,deloc,deloc_int,deloc_force,btinv,gprimd,prim_int,&  
  &  u_matrix)
  use defs_mover
  use defs_basis
  implicit none
  integer,intent(out) :: cycl_main
  integer,intent(in) :: ndim
  type(ab_movetype),intent(in) :: ab_mover
  type(ab_xfh_type),intent(inout) :: ab_xfh
  type(ab_delocint),intent(inout) :: deloc
  real(dp),intent(inout) :: ucvol
  real(dp),intent(inout) :: ucvol0
  real(dp),intent(inout) :: acell(3)
  real(dp),intent(in) :: acell0(3)
  real(dp),intent(inout) :: btinv(3*(ab_mover%natom-1),3*ab_mover%natom)
  real(dp),intent(inout) :: deloc_force(3*(ab_mover%natom-1))
  real(dp),intent(inout) :: deloc_int(3*(ab_mover%natom-1))
  real(dp),intent(inout) :: fred(3,ab_mover%natom)
  real(dp),intent(inout) :: gprimd(3,3)
  real(dp),intent(inout) :: hessin(:,:)
  real(dp),intent(inout) :: prim_int(:)
  real(dp),intent(inout) :: rprim(3,3)
  real(dp),intent(inout) :: rprimd0(3,3)
  real(dp),intent(inout) :: strten(6)
  real(dp),intent(inout) :: u_matrix(:,:)
  real(dp),intent(inout) :: vin(:)
  real(dp),intent(inout) :: vin_prev(:)
  real(dp),intent(inout) :: vout(:)
  real(dp),intent(inout) :: vout_prev(:)
  real(dp),intent(inout) :: xred(3,ab_mover%natom)
 end subroutine xfh_recover_deloc
end interface

interface
 subroutine xfh_recover_new(ab_xfh,ab_mover,acell,acell0,cycl_main,fred,&  
  &  hessin,ndim,rprim,rprimd0,strten,ucvol,ucvol0,vin,vin_prev,vout,&  
  &  vout_prev,xred)
  use defs_mover
  use defs_basis
  implicit none
  integer,intent(out) :: cycl_main
  integer,intent(in) :: ndim
  type(ab_movetype),intent(in) :: ab_mover
  type(ab_xfh_type),intent(inout) :: ab_xfh
  real(dp),intent(inout) :: ucvol
  real(dp),intent(inout) :: ucvol0
  real(dp),intent(inout) :: acell(3)
  real(dp),intent(in) :: acell0(3)
  real(dp),intent(inout) :: fred(3,ab_mover%natom)
  real(dp),intent(inout) :: hessin(:,:)
  real(dp),intent(inout) :: rprim(3,3)
  real(dp),intent(inout) :: rprimd0(3,3)
  real(dp),intent(inout) :: strten(6)
  real(dp),intent(inout) :: vin(:)
  real(dp),intent(inout) :: vin_prev(:)
  real(dp),intent(inout) :: vout(:)
  real(dp),intent(inout) :: vout_prev(:)
  real(dp),intent(inout) :: xred(3,ab_mover%natom)
 end subroutine xfh_recover_new
end interface

interface
 subroutine xfh_update(ab_xfh,acell,fred_corrected,natom,rprim,strten,xred)
  use defs_mover
  use defs_basis
  implicit none
  integer,intent(in) :: natom
  type(ab_xfh_type),intent(inout) :: ab_xfh
  real(dp),intent(in) :: acell(3)
  real(dp),intent(in) :: fred_corrected(3,natom)
  real(dp),intent(in) :: rprim(3,3)
  real(dp),intent(in) :: strten(6)
  real(dp),intent(in) :: xred(3,natom)
 end subroutine xfh_update
end interface

interface
 subroutine xfpack(acell,acell0,fred,natom,ndim,nsym,optcell,&  
  &  option,rprim,rprimd0,strtarget,strten,symrel,ucvol,ucvol0,&  
  &  vin,vout,xred)
  use defs_basis
  implicit none
  integer,intent(in) :: natom
  integer,intent(in) :: ndim
  integer,intent(in) :: nsym
  integer,intent(in) :: optcell
  integer,intent(in) :: option
  real(dp),intent(inout) :: ucvol
  real(dp),intent(in) :: ucvol0
  real(dp),intent(inout) :: acell(3)
  real(dp),intent(in) :: acell0(3)
  real(dp),intent(inout) :: fred(3,natom)
  real(dp),intent(inout) :: rprim(3,3)
  real(dp),intent(in) :: rprimd0(3,3)
  real(dp),intent(in) :: strtarget(6)
  real(dp),intent(inout) :: strten(6)
  integer,intent(in) :: symrel(3,3,nsym)
  real(dp),intent(inout) :: vin(ndim)
  real(dp),intent(inout) :: vout(ndim)
  real(dp),intent(inout) :: xred(3,natom)
 end subroutine xfpack
end interface

end module interfaces_42_geomoptim
!!***
