!{\src2tex{textfont=tt}}
!!****f* ABINIT/predict_copy
!! NAME
!! predict_copy
!!
!! FUNCTION
!! Given the past history of images, predict the new set of images.
!! Here, simple copy of the previous image.
!!
!! COPYRIGHT
!! Copyright (C) 2009-2010 ABINIT group (XG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!! itimimage=number of the current time for image propagation (itimimage+1 is to be predicted here)
!! list_dynimage(nimage)=list of dynamical images. The non-dynamical ones will not change.
!!       Example : in the NEB of string method, one expect the two end images to be fixed.
!! natom=dimension of vel_timimage and xred_timimage
!! ndynimage=number of dynamical images
!! nimage=number of images
!! ntimimage=dimension of several arrays
!!
!! OUTPUT
!!
!! SIDE EFFECTS
!! acell_timimage(3,ntimimage,nimage)
!!   at input, history of the values of acell for all images, up to itimimage
!!   at output, the predicted values of acell for all images, stored in acell_timimage(3,itimimage+1,nimage)
!! rprim_timimage(3,3,ntimimage,nimage)
!!   at input, history of the values of rprim for all images, up to itimimage
!!   at output, the predicted values of rprim for all images, stored in rprim_timimage(3,itimimage+1,nimage)
!! vel_timimage(3,natom,ntimimage,nimage)
!!   at input, history of the values of vel for all images, up to itimimage
!!   at output, the predicted values of vel for all images, stored in vel_timimage(3,natom,itimimage+1,nimage)
!! xred_timimage(3,natom,ntimimage,nimage)
!!   at input, history of the values of xred for all images, up to itimimage
!!   at output, the predicted values of xred for all images, stored in xred_timimage(3,natom,itimimage+1,nimage)
!!
!! PARENTS
!!      predictimg
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine predict_copy(acell_timimage,itimimage,list_dynimage,natom,ndynimage,nimage,ntimimage,&
& rprim_timimage,vel_timimage,xred_timimage)

 use defs_basis

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: itimimage,natom,ndynimage,nimage,ntimimage
 integer,intent(in) :: list_dynimage(ndynimage)
!arrays
 real(dp),intent(inout) :: acell_timimage(3,nimage,ntimimage)
 real(dp),intent(inout) :: rprim_timimage(3,3,nimage,ntimimage)
 real(dp),intent(inout) :: vel_timimage(3,natom,nimage,ntimimage)
 real(dp),intent(inout) :: xred_timimage(3,natom,nimage,ntimimage)

!Local variables-------------------------------
!scalars
 integer :: idynimage,iimage
!character(len=500) :: message
!arrays

! *************************************************************************

 do idynimage=1,ndynimage

   iimage=list_dynimage(idynimage)

   acell_timimage(:,iimage,itimimage+1)  =acell_timimage(:,iimage,itimimage)
   rprim_timimage(:,:,iimage,itimimage+1)=rprim_timimage(:,:,iimage,itimimage)
   vel_timimage(:,:,iimage,itimimage+1)  =vel_timimage(:,:,iimage,itimimage)
   xred_timimage(:,:,iimage,itimimage+1) =xred_timimage(:,:,iimage,itimimage)

 end do  ! idynimage

end subroutine predict_copy
!!***
