!{\src2tex{textfont=tt}}
!!****f* ABINIT/predict_pimd
!! NAME
!! predict_pimd
!!
!! FUNCTION
!! Predicts new positions in Path Integral Molecular Dynamics
!! Given the positions at time t and t-dtion, an estimation of the velocities at time t,
!! the forces and an estimation of the stress at time t, and an estimation of the cell at time t,
!! computes in the Path Integral Molecular Dynamics framework the new positions at time t+dtion,
!! computes self-consistently the velocities, the stress and the cell at time t and produces
!! an estimation of the velocities, stress and new cell at time t+dtion
!! No change of acell and rprim at present.
!!
!! COPYRIGHT
!! Copyright (C) 2010 ABINIT group (GG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!! itimimage=number of the current time for image propagation (itimimage+1 is to be predicted here)
!! list_dynimage(nimage)=list of dynamical images. The non-dynamical ones will not change.
!!       Example : in the NEB of string method, one expect the two end images to be fixed.
!! This is quite useful when ground states of the A and B states is known
!! natom=dimension of vel_timimage and xred_timimage
!! ndynimage=number of dynamical images
!! nimage=number of images
!! ntimimage=dimension of several arrays
!! results_gs_timimage(ntimimage,nimage)=datastructure that hold all the history of previous computations.
!! mdparam=datastructure that contains all the parameters necessary to molecular dynamics
!!
!! OUTPUT
!!
!! SIDE EFFECTS
!! acell_timimage(3,ntimimage,nimage)
!!   at input, history of the values of acell for all images, up to itimimage
!!   at output, the predicted values of acell for all images, stored in acell_timimage(3,itimimage+1,nimage)
!! rprim_timimage(3,3,ntimimage,nimage)
!!   at input, history of the values of rprim for all images, up to itimimage
!!   at output, the predicted values of rprim for all images, stored in rprim_timimage(3,itimimage+1,nimage)
!! vel_timimage(3,natom,ntimimage,nimage)
!!   at input, history of the values of vel for all images, up to itimimage
!!   at output, the predicted values of vel for all images, stored in vel_timimage(3,natom,itimimage+1,nimage)
!! xred_timimage(3,natom,ntimimage,nimage)
!!   at input, history of the values of xred for all images, up to itimimage
!!   at output, the predicted values of xred for all images, stored in xred_timimage(3,natom,itimimage+1,nimage)
!!
!! PARENTS
!!      predictimg
!!
!! CHILDREN
!!
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine predict_pimd(acell_timimage,fxcartfactor,iatfix,itimimage,list_dynimage,natom,ndynimage,nimage,ntimimage,&
& results_gs_timimage,rprim_timimage,vel_timimage,xred_timimage,mdparam)

 use defs_basis
 use defs_datatypes
 use defs_mover
 use m_splines

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
 use interfaces_42_geometry
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: itimimage,natom,ndynimage,nimage,ntimimage
 real(dp),intent(in) :: fxcartfactor
!arrays
 integer,intent(in)     :: list_dynimage(ndynimage)
 integer,intent(in)     :: iatfix(3,natom)
 real(dp),intent(inout) :: acell_timimage(3,nimage,ntimimage)
 real(dp),intent(inout) :: rprim_timimage(3,3,nimage,ntimimage)
 real(dp),intent(inout) :: vel_timimage(3,natom,nimage,ntimimage)
 real(dp),intent(inout) :: xred_timimage(3,natom,nimage,ntimimage)
 type(results_gs_type)  :: results_gs_timimage(nimage,ntimimage)
 type(ab_movetype) :: mdparam

!Local variables-------------------------------
!scalars
 integer :: idynimage,iimage,iatom
 integer :: nintervals
 real(dp) :: acell(3),rprim(3,3),rprimd(3,3),coordif(3)
 real(dp),allocatable :: xcart(:,:),dimage(:),dintimage(:)
 real(dp),allocatable :: x2(:),y2(:),z2(:),dequal(:)
 real(dp),allocatable :: x(:),y(:),z(:)
 real(dp),allocatable :: xout(:),yout(:),zout(:)
 character(len=500) :: message

!arrays

! *************************************************************************

!XG100717
!FAKE WRITE, TO FOOL ABIRULES INTO BELIEVING THAT mdparam IS REALLY USED
!TO BE REMOVED AS SOON AS mdparam IS EFFECTIVELY USED
 write(6,*)mdparam%natom

 nintervals=nimage-1
 allocate(xcart(3,natom))
 allocate(dimage(nimage),dintimage(nimage),dequal(nimage))
 allocate(x2(nimage),y2(nimage),z2(nimage),x(nimage),y(nimage),z(nimage))
 allocate(xout(nimage),yout(nimage),zout(nimage))

!image evolution

 write(message,'(a,i4)') &
& ' STRING METHOD NEW STEP ON IMAGES, STEP = ',itimimage
 call wrtout(std_out,message,'COLL')

 do iimage=1,nimage
   acell_timimage(:,iimage,itimimage+1)=acell_timimage(:,iimage,itimimage)
   rprim_timimage(:,:,iimage,itimimage+1)=rprim_timimage(:,:,iimage,itimimage)
   xred_timimage(:,:,iimage,itimimage+1)=xred_timimage(:,:,iimage,itimimage)
 end do

 do idynimage=1,ndynimage
   iimage=list_dynimage(idynimage)
   acell(:)=acell_timimage(:,iimage,itimimage)
   rprim(:,:)=rprim_timimage(:,:,iimage,itimimage)
   call mkrdim(acell,rprim,rprimd)
   call xredxcart(natom,1,rprimd,xcart,xred_timimage(:,:,iimage,itimimage))
!  Note that one uses fcart, for which the sum of forces on all atoms vanish (this is not the case for fred).
   xcart(:,:)=xcart(:,:)+fxcartfactor*results_gs_timimage(iimage,itimimage)%fcart(:,:)
   call xredxcart(natom,-1,rprimd,xcart,xred_timimage(:,:,iimage,itimimage+1))
!  in case atom is fixed, we restore its previous value
   where(iatfix(:,:)==1)
   xred_timimage(:,:,iimage,itimimage+1)=xred_timimage(:,:,iimage,itimimage)
   end where
 end do

!reparametrize the string
!Here the distance between images is calculated and normalized to a string length of 1.0

 dimage=zero
 dintimage=zero
 do iimage=2,nimage
   dimage(iimage)=dimage(iimage-1)
   do iatom=1,natom
     coordif=xred_timimage(:,iatom,iimage,itimimage+1)-xred_timimage(:,iatom,iimage-1,itimimage+1)
     dimage(iimage)=dimage(iimage)+sqrt(dot_product(coordif,coordif))
   end do
 end do
 dimage=dimage/dimage(nimage)

!dequal is just the parametrization on the string with equal arc-lengths

 dequal(1)=zero
 do iimage=2,nimage
   dequal(iimage)=dequal(iimage-1)+one/(float(nintervals))
 end do

!New image coordinates are calculated and such that now the mesh is uniform

 do iatom=1,natom
   do iimage=1,nimage
     x(iimage)=xred_timimage(1,iatom,iimage,itimimage+1)
     y(iimage)=xred_timimage(2,iatom,iimage,itimimage+1)
     z(iimage)=xred_timimage(3,iatom,iimage,itimimage+1)
   end do
   call spline(dimage,x,nimage,greatest_real,greatest_real,x2)
   call spline(dimage,y,nimage,greatest_real,greatest_real,y2)
   call spline(dimage,z,nimage,greatest_real,greatest_real,z2)
   call splint(nimage,dimage,x,x2,nimage,dequal,xout)
   call splint(nimage,dimage,y,y2,nimage,dequal,yout)
   call splint(nimage,dimage,z,z2,nimage,dequal,zout)

!  after a spline, new image coordinate for that particular atom are generated only if they are dynamical

   do idynimage=1,ndynimage
     iimage=list_dynimage(idynimage)
     xred_timimage(1,iatom,iimage,itimimage+1)=xout(iimage)
     xred_timimage(2,iatom,iimage,itimimage+1)=yout(iimage)
     xred_timimage(3,iatom,iimage,itimimage+1)=zout(iimage)
   end do  ! iimage
 end do  ! iatom

!store acell, rprim and vel for the new iteration

 do iimage=1,nimage
   acell_timimage(:,iimage,itimimage+1)  =acell_timimage(:,iimage,itimimage)
   rprim_timimage(:,:,iimage,itimimage+1)=rprim_timimage(:,:,iimage,itimimage)
   vel_timimage(:,:,iimage,itimimage+1)  =vel_timimage(:,:,iimage,itimimage)
 end do

 deallocate(xcart,x2,y2,z2,x,y,z,xout,yout,zout)
 deallocate(dequal,dimage,dintimage)

end subroutine predict_pimd
!!***
