!{\src2tex{textfont=tt}}
!!****f* ABINIT/predictimg
!! NAME
!! predictimg
!!
!! FUNCTION
!! Given the past history of images, predict the new set of images
!!
!! COPYRIGHT
!! Copyright (C) 2009-2010 ABINIT group (XG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!! fxcartfactor=factor that allows to transform forces in cartesian displacements for selected algorithms.
!! iatfix(3,natom)= fix xred coordinates if 1
!! imgmov=gives the algorithm to be used for prediction of new set of images
!! itimimage=number of the current time for image propagation (itimimage+1 is to be predicted here)
!! list_dynimage(nimage)=list of dynamical images. The non-dynamical ones will not change.
!!       Example : in the NEB of string method, one expect the two end images to be fixed.
!! natom=dimension of vel_timimage and xred_timimage
!! ndynimage=number of dynamical images
!! nimage=number of images
!! ntimimage=dimension of several arrays
!! results_gs_timimage(ntimimage,nimage)=datastructure that hold all the history of previous computations.
!!
!! OUTPUT
!!
!! SIDE EFFECTS
!! acell_timimage(3,ntimimage,nimage)
!!   at input, history of the values of acell for all images, up to itimimage
!!   at output, the predicted values of acell for all images, stored in acell_timimage(3,itimimage+1,nimage)
!! rprim_timimage(3,3,ntimimage,nimage)
!!   at input, history of the values of rprim for all images, up to itimimage
!!   at output, the predicted values of rprim for all images, stored in rprim_timimage(3,itimimage+1,nimage)
!! vel_timimage(3,natom,ntimimage,nimage)
!!   at input, history of the values of vel for all images, up to itimimage
!!   at output, the predicted values of vel for all images, stored in vel_timimage(3,natom,itimimage+1,nimage)
!! xred_timimage(3,natom,ntimimage,nimage)
!!   at input, history of the values of xred for all images, up to itimimage
!!   at output, the predicted values of xred for all images, stored in xred_timimage(3,natom,itimimage+1,nimage)
!!
!! PARENTS
!!      gstateimg
!!
!! CHILDREN
!!      predict_copy,predict_pimd,predict_steepest,predict_string
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine predictimg(acell_timimage,fxcartfactor,iatfix,imgmov,itimimage,list_dynimage,natom,ndynimage,nimage,ntimimage,&
& results_gs_timimage,rprim_timimage,vel_timimage,xred_timimage,mdparam)

 use defs_basis
 use defs_datatypes
 use defs_mover

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_42_geomoptim, except_this_one => predictimg
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: imgmov,itimimage,natom,ndynimage,nimage,ntimimage
 real(dp),intent(in) :: fxcartfactor
!arrays
 integer,intent(in) :: list_dynimage(ndynimage)
 integer,intent(in) :: iatfix(3,natom)
 real(dp),intent(inout) :: acell_timimage(3,nimage,ntimimage)
 real(dp),intent(inout) :: rprim_timimage(3,3,nimage,ntimimage)
 real(dp),intent(inout) :: vel_timimage(3,natom,nimage,ntimimage)
 real(dp),intent(inout) :: xred_timimage(3,natom,nimage,ntimimage)
 type(results_gs_type) :: results_gs_timimage(nimage,ntimimage)
 type(ab_movetype) :: mdparam

!Local variables-------------------------------
!scalars
!character(len=500) :: message
!arrays

! *************************************************************************
 select case(imgmov)

   case(0)

     call predict_copy(acell_timimage,itimimage,list_dynimage,natom,ndynimage,nimage,ntimimage,&
&     rprim_timimage,vel_timimage,xred_timimage)

   case(1)

     call predict_steepest(acell_timimage,fxcartfactor,itimimage,list_dynimage,natom,ndynimage,nimage,ntimimage,&
&     results_gs_timimage,rprim_timimage,vel_timimage,xred_timimage)

   case(2)

     call predict_string(acell_timimage,fxcartfactor,iatfix,itimimage,list_dynimage,natom,ndynimage,nimage,ntimimage,&
&     results_gs_timimage,rprim_timimage,vel_timimage,xred_timimage)

   case(9, 13)
!    Path Integral Molecular Dynamics
     call predict_pimd(acell_timimage,fxcartfactor,iatfix,itimimage,list_dynimage,natom,ndynimage,nimage,ntimimage,&
&     results_gs_timimage,rprim_timimage,vel_timimage,xred_timimage,mdparam)

     case default

 end select

end subroutine predictimg
!!***
