!{\src2tex{textfont=tt}}
!!****f* ABINIT/prtxfase
!!
!! NAME
!! prtxfase
!!
!! FUNCTION
!! Print the values of xcart (X), forces (F)
!! acell (A), Stresses (S), and energy (E)
!! All values come from the history hist
!! Also compute and print max and rms forces.
!! Also compute absolute and relative differences
!! with previous calculation
!!
!! COPYRIGHT
!! Copyright (C) 1998-2010 ABINIT group (DCA, XG, GMR)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors,
!! see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!! ab_mover<type ab_movetype>=Subset of dtset only related with
!!          |                 movement of ions and acell, contains:
!!          | dtion:  Time step
!!          ! natom:  Number of atoms
!!          | vis:    viscosity
!!          | iatfix: Index of atoms and directions fixed
!!          | amass:  Mass of ions
!! hist<type ab_movehistory>=Historical record of positions, forces
!!      |                    acell, stresses, and energies,
!!      |                    contains:
!!      | mxhist:  Maximun number of records
!!      | ihistA:  Index of present record of histA
!!      | ihistE:  Index of present record of histE
!!      | ihistR:  Index of present record of histR
!!      | ihistS:  Index of present record of histS
!!      | ihistV:  Index of present record of histV
!!      | ihistXF: Index of present record of histXF
!!      | histA:   Historical record of acell(A) and rprimd(R)
!!      | histE:   Historical record of energy(E)
!!      | histR:   Historical record of rprimd(R)
!!      | histS:   Historical record of strten(S)
!!      | histV:   Historical record of velocity(V)
!!      | histXF:  Historical record of positions(X) and forces(F)
!! iout=unit number for printing
!!
!! OUTPUT
!!  (only writing)
!!
!! PARENTS
!!      mover
!!
!! CHILDREN
!!      wrtout
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine prtxfase(ab_mover,hist,iout,icycle,itime,pos)

! define dp,sixth,third,etc...
use defs_basis
! type(ab_movetype), type(ab_movehistory)
use defs_mover

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
!End of the abilint section

implicit none

!Arguments ------------------------------------
!scalars
type(ab_movetype),intent(in) :: ab_mover
type(ab_movehistory),intent(in) :: hist
integer,intent(in) :: iout
integer,intent(in) :: icycle
integer,intent(in) :: itime
integer,intent(in) :: pos
!arrays

!Local variables-------------------------------
!scalars
integer :: jj,kk,unfixd
real(dp) :: val_max,val_rms,ucvol ! Values maximal and RMS, Volume of Unitary cell
real(dp) :: dEabs,dErel ! Diff of energy absolute and relative
real(dp) :: angle(3),rmet(3,3)
character(len=80*(max(ab_mover%natom,3)+1)) :: message
character(len=1)   :: tag
character(len=10)   :: tag10
character(len=18)   :: fmt1
logical :: NEWCODE=.TRUE.

! ***********************************************************

 write(tag10, '(a,I2.2,a,I2.2,a)') '[T',itime,',C',icycle,'] '
 tag=' '
 fmt1='(a,a,a,1p,3e22.14)'

!###########################################################
!### 1. Positions

 write(message, '(a,a)' )&
& tag,'Cartesian coordinates (xcart) [bohr]'
!call wrtout(iout,message,'COLL')
 do kk=1,ab_mover%natom
   write(message,fmt1)&
&   TRIM(message),ch10,&
&   tag,&
&   hist%histXF(:,kk,1,hist%ihist)
!  call wrtout(iout,message,'COLL')
 end do
 call wrtout(iout,message,'COLL')

 write(message, '(a,a)' )&
& tag,'Reduced coordinates (xred)'
!call wrtout(iout,message,'COLL')
 do kk=1,ab_mover%natom
   write(message,fmt1)&
&   TRIM(message),ch10,&
&   tag,&
&   hist%histXF(:,kk,2,hist%ihist)
!  call wrtout(iout,message,'COLL')
 end do
 call wrtout(iout,message,'COLL')

!###########################################################
!### 2. Forces

  if(pos==mover_AFTER)then
!  Compute max |f| and rms f,
!  EXCLUDING the components determined by iatfix
   val_max=0.0_dp
   val_rms=0.0_dp
   unfixd=0
   do kk=1,ab_mover%natom
     do jj=1,3
       if (ab_mover%iatfix(jj,kk) /= 1) then
         unfixd=unfixd+1
         val_rms=val_rms+hist%histXF(jj,kk,3,hist%ihist)**2
         val_max=max(val_max,abs(hist%histXF(jj,kk,3,hist%ihist)**2))
       end if
     end do
   end do
   if ( unfixd /= 0 ) val_rms=sqrt(val_rms/dble(unfixd))

   write(message, '(a,a,1p,2e12.5,a)' ) &
&   tag,'Cartesian forces (fcart) [Ha/bohr]; max,rms=',&
&   sqrt(val_max),val_rms,' (free atoms)'
!  call wrtout(iout,message,'COLL')
   do kk=1,ab_mover%natom
     write(message,fmt1)&
&     TRIM(message),ch10,&
&     tag,&
&     hist%histXF(:,kk,3,hist%ihist)
!    call wrtout(iout,message,'COLL')
   end do
   call wrtout(iout,message,'COLL')

   write(message, '(a,a)' )&
&   tag,'Reduced forces (fred)'
!  call wrtout(iout,message,'COLL')
   do kk=1,ab_mover%natom
     write(message,fmt1)&
&     TRIM(message),ch10,&
&     tag,&
&     hist%histXF(:,kk,4,hist%ihist)
!    call wrtout(iout,message,'COLL')
   end do
   call wrtout(iout,message,'COLL')
  end if

!###########################################################
!### 3. Velocities

!Only if the velocities are being used
 if (hist%isVused)then
!  Only if velocities are recorded in a history
   if (associated(hist%histV))then
!    Compute max |v| and rms v,
!    EXCLUDING the components determined by iatfix
     val_max=0.0_dp
     val_rms=0.0_dp
     unfixd=0
     do kk=1,ab_mover%natom
       do jj=1,3
         if (ab_mover%iatfix(jj,kk) /= 1) then
           unfixd=unfixd+1
           val_rms=val_rms+hist%histV(jj,kk,hist%ihist)**2
           val_max=max(val_max,abs(hist%histV(jj,kk,hist%ihist)**2))
         end if
       end do
     end do
     if ( unfixd /= 0 ) val_rms=sqrt(val_rms/dble(unfixd))

     write(message, '(a,a,1p,2e12.5,a)' ) &
&     tag,'Cartesian velocities (vel) [bohr*Ha/hbar]; max,rms=',&
&     sqrt(val_max),val_rms,' (free atoms)'
!    call wrtout(iout,message,'COLL')
     do kk=1,ab_mover%natom
       write(message,fmt1)&
&       TRIM(message),ch10,&
&       tag,&
&       hist%histV(:,kk,hist%ihist)
!      call wrtout(iout,message,'COLL')
     end do
     call wrtout(iout,message,'COLL')

   end if
 end if

!###########################################################
!### 3. ACELL

!Only if the acell is being used
 if (hist%isARused)then
!  Only if acell is recorded in a history
   if (associated(hist%histA))then

     write(message, '(a,a)' ) &
&     tag,'Scale of Primitive Cell (acell) [bohr]'
!    call wrtout(iout,message,'COLL')
     write(message,fmt1)&
&     TRIM(message),ch10,&
&     tag,&
&     hist%histA(:,hist%ihist)
     call wrtout(iout,message,'COLL')
   end if
 end if

!###########################################################
!### 4. RPRIMD

!Only if the acell is being used
 if (hist%isARused)then
!  Only if rprimd is recorded in a history
   if (associated(hist%histR))then
     write(message, '(a,a)' ) &
&     tag,'Real space primitive translations (rprimd) [bohr]'
!    call wrtout(iout,message,'COLL')
     do kk=1,3
       write(message,fmt1)&
&       TRIM(message),ch10,&
&       tag,&
&       hist%histR(:,kk,hist%ihist)
!      call wrtout(iout,message,'COLL')
     end do
     call wrtout(iout,message,'COLL')
   end if
 end if

!###########################################################
!### 5. Unitary cell volume

 if (ab_mover%optcell/=0)then

   ucvol=hist%histR(1,1,hist%ihist)*&
&   (hist%histR(2,2,hist%ihist)*hist%histR(3,3,hist%ihist)-&
&   hist%histR(3,2,hist%ihist)*hist%histR(2,3,hist%ihist))+&
&   hist%histR(2,1,hist%ihist)*&
&   (hist%histR(3,2,hist%ihist)*hist%histR(1,3,hist%ihist)-&
&   hist%histR(1,2,hist%ihist)*hist%histR(3,3,hist%ihist))+&
&   hist%histR(3,1,hist%ihist)*&
&   (hist%histR(1,2,hist%ihist)*hist%histR(2,3,hist%ihist)-&
&   hist%histR(2,2,hist%ihist)*hist%histR(1,3,hist%ihist))

   write(message, '(a,a,1p,e22.14)' )&
&   tag,'Unitary Cell Volume (ucvol) [Bohr^3]=',&
&   ucvol
   call wrtout(iout,message,'COLL')

!  ###########################################################
!  ### 5. Angles and lengths

!  Compute real space metric.
   rmet = MATMUL(TRANSPOSE(hist%histR(:,:,hist%ihist)),hist%histR(:,:,hist%ihist))

   angle(1)=acos(rmet(2,3)/sqrt(rmet(2,2)*rmet(3,3)))/two_pi*360.0d0
   angle(2)=acos(rmet(1,3)/sqrt(rmet(1,1)*rmet(3,3)))/two_pi*360.0d0
   angle(3)=acos(rmet(1,2)/sqrt(rmet(1,1)*rmet(2,2)))/two_pi*360.0d0

   write(message, '(a,a)' ) &
&   tag,'Angles (23,13,12)= [degrees]'
!  call wrtout(iout,message,'COLL')
   write(message,fmt1)&
&   TRIM(message),ch10,&
&   tag,&
&   angle(:)
   call wrtout(iout,message,'COLL')

   write(message, '(a,a)' ) &
&   tag,'Lengths [Bohr]'
!  call wrtout(iout,message,'COLL')
   write(message,fmt1)&
&   TRIM(message),ch10,&
&   tag,&
&   sqrt(rmet(1,1)),sqrt(rmet(2,2)),sqrt(rmet(3,3))
   call wrtout(iout,message,'COLL')


!  ###########################################################
!  ### 5. Stress Tensor

    if(pos==mover_AFTER)then
!    Only if strten is recorded in a history
     if (associated(hist%histS))then

       write(message, '(a,a)' ) &
&       tag,&
&       'Stress tensor in cartesian coordinates (strten) [Ha/bohr^3]'
!      call wrtout(iout,message,'COLL')

       write(message,fmt1)&
&       TRIM(message),ch10,&
&       tag,&
&       hist%histS(1,hist%ihist),&
&       hist%histS(6,hist%ihist),&
&       hist%histS(5,hist%ihist)
!      call wrtout(iout,message,'COLL')
       write(message,fmt1)&
&       TRIM(message),ch10,&
&       tag,&
&       hist%histS(6,hist%ihist),&
&       hist%histS(2,hist%ihist),&
&       hist%histS(4,hist%ihist)
!      call wrtout(iout,message,'COLL')
       write(message,fmt1)&
&       TRIM(message),ch10,&
&       tag,&
&       hist%histS(5,hist%ihist),&
&       hist%histS(4,hist%ihist),&
&       hist%histS(3,hist%ihist)
       call wrtout(iout,message,'COLL')
     end if
   end if
  end if

!###########################################################
!### 6. Energy

  if(pos==mover_AFTER)then
   write(message, '(a,a,1p,e22.14,a)' )&
&   tag,'Total energy (etotal) [Ha]=',&
&   hist%histE(hist%ihist),ch10
!  call wrtout(iout,message,'COLL')

   if (NEWCODE)then
     if (hist%ihist>1)then
       dEabs=hist%histE(hist%ihist)-hist%histE(hist%ihist-1)
       dErel=2*dEabs/(abs(hist%histE(hist%ihist))+&
&       abs(hist%histE(hist%ihist-1)))
       write(message, '(a,a,a,a)' )&
&       TRIM(message),ch10,&
&       tag,&
&       'Difference of energy with previous step:'
!      call wrtout(iout,message,'COLL')
       write(message, '(a,a,a,10a,a,1p,e12.5,a,a,10a,a,1p,e12.5,a)')&
&       TRIM(message),ch10,&
&       tag,&
&       (' ',jj=1,10),' Absolute (Ha)=',dEabs,ch10,&
&       tag,&
&       (' ',jj=1,10),' Relative     =',dErel,ch10
!      call wrtout(iout,message,'COLL')
     end if
   end if
   call wrtout(iout,message,'COLL')
  end if

end subroutine prtxfase
!!***
