!{\src2tex{textfont=tt}}
!!****f* ABINIT/var2hist
!!
!! NAME
!! var2hist
!!
!! FUNCTION
!! Set the values of the history "hist"
!! with the values of xcart, xred, acell and rprimd
!!
!! COPYRIGHT
!! Copyright (C) 1998-2010 ABINIT group (DCA, XG, GMR)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors,
!! see ~abinit/doc/developers/contributors.txt .
!!
!! INPUT (in)
!! ab_mover<type ab_movetype>=Subset of dtset only related with
!!          |                 movement of ions and acell, contains:
!!          | dtion:  Time step
!!          ! natom:  Number of atoms
!!          | vis:    viscosity
!!          | iatfix: Index of atoms and directions fixed
!!          | amass:  Mass of ions
!! xred(3,ab_mover%natom) = reduced dimensionless atomic
!!                           coordinates
!! xcart(3,ab_mover%natom)= cartesian dimensional atomic
!!                           coordinates (bohr)
!! acell(3)    = length scales of primitive translations (bohr)
!! rprimd(3,3) = dimensionless real space primitive translations
!!               (bohr)
!!
!! OUTPUT (out)
!!
!! SIDE EFFECTS (inout)
!! hist<type ab_movehistory>=Historical record of positions, forces
!!      |                    acell, stresses, and energies,
!!      |                    contains:
!!      | mxhist:  Maximun number of records
!!      | ihistA:  Index of present record of histA
!!      | ihistE:  Index of present record of histE
!!      | ihistR:  Index of present record of histR
!!      | ihistS:  Index of present record of histS
!!      | ihistV:  Index of present record of histV
!!      | ihistXF: Index of present record of histXF
!!      | histA:   Historical record of acell(A) and rprimd(R)
!!      | histE:   Historical record of energy(E)
!!      | histR:   Historical record of rprimd(R)
!!      | histS:   Historical record of strten(S)
!!      | histV:   Historical record of velocity(V)
!!      | histXF:  Historical record of positions(X) and forces(F)
!!
!! PARENTS
!!      pred_moldyn
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine var2hist(ab_mover,hist,acell,rprimd,xcart,xred)

! define dp,sixth,third,etc...
use defs_basis
! type(ab_movetype), type(ab_movehistory)
use defs_mover

implicit none

!Arguments ------------------------------------
!scalars
type(ab_movetype),intent(in) :: ab_mover
type(ab_movehistory),intent(inout) :: hist
!arrays
real(dp),intent(in) :: acell(3)
real(dp),intent(in) :: rprimd(3,3)
real(dp),intent(in) :: xcart(3,ab_mover%natom)
real(dp),intent(in) :: xred(3,ab_mover%natom)

!Local variables-------------------------------
!scalars
!integer :: jj,kk

! *************************************************************

 hist%histXF(:,:,1,hist%ihist)=xcart(:,:)
 hist%histXF(:,:,2,hist%ihist)=xred(:,:)
 hist%histA(:,hist%ihist)=acell(:)
 hist%histR(:,:,hist%ihist)=rprimd(:,:)

!! ###########################################################
!! ### 1. XCART

!do kk=1,ab_mover%natom
!do jj=1,3
!hist%histXF(jj,kk,1,hist%ihist)=xcart(jj,kk)
!end do
!end do

!! ###########################################################
!! ### 2. XRED

!do kk=1,ab_mover%natom
!do jj=1,3
!hist%histXF(jj,kk,2,hist%ihist)=xred(jj,kk)
!end do
!end do

!! ###########################################################
!! ### 3. ACELL

!do jj=1,3
!hist%histA(jj,hist%ihist)=acell(jj)
!end do

!! ###########################################################
!! ### 4. RPRIMD

!do kk=1,3
!do jj=1,3
!hist%histR(jj,kk,hist%ihist)=rprimd(jj,kk)
!end do
!end do

end subroutine var2hist
!!***
