!{\src2tex{textfont=tt}}
!!****m* ABINIT/defs_gw
!! NAME
!! defs_gw
!!
!! FUNCTION
!! This module contains definitions of all structured GW data for the
!! ABINIT package.
!! If you want to add one new datatype, please, examine first whether
!! another datatype might meet your need (e.g. adding some records to it).
!! Then, if you are sure your new structured datatype is needed,
!! write it here, and DOCUMENT it properly (not all datastructure here are
!! well documented, it is a shame ...).
!! Do not forget : you will likely be the major winner if you document
!! properly.
!! Proper documentation of a structured datatype means :
!!  (1) Mention it in the list just below
!!  (2) Describe it in the NOTES section
!!  (3) Put it in alphabetical order in the the main section of this module
!!  (4) Document each of its records, except if they are described elsewhere
!!      (this exception is typically the case of the dataset associated with
!!      input variables, for which there is a help file)
!!
!! List of datatypes :
!!
!! COPYRIGHT
!! Copyright (C) 2001-2010 ABINIT group (XG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"

module defs_gw

 use defs_basis
 use defs_parameters
 use defs_abitypes

 implicit none

!Structures

!!***

!!****t* defs_gw/ScrHdr_type
!! NAME
!!  ScrHdr_type
!!
!! FUNCTION
!!  For the GW part of ABINIT, this structure defines the header
!!  of the _SCR or _SUSC file.
!!  FIXME:
!!   This is just an hack to cheat the build system.
!!   It should be defined in the appropriated module (m_io_screening.F90)
!!
!! SOURCE

 type ScrHdr_type

! WARNING : if you modify this datatype, please check there there is no creation/destruction/copy routine,
! declared in another part of ABINIT, that might need to take into account your modification.

  !Other variables that can be added are, for the moment, commented out.
  !Most of them are related to the Abinit implementation  and are not specified in the ETSF specs.

  !Index of the qlwl section?
  !gwcomp, gwencomp  ! Info on the extrapolar algorithm

  integer :: ID           ! Matrix identifier: O if not yet defined, 1 for chi0,
                          ! 2 for chi, 3 for epsilon, 4 for espilon^{-1}
  integer :: ikxc         ! Kxc kernel used, 0 for None (RPA), >0 for static TDDFT (=ixc), <0 for frequency-dependent TDDFT
  integer :: inclvkb      ! q-->0 treatment, 0 for None, 1-2 for transversal gauge, 3 for longitudinal
  integer :: headform     ! format of the SCR header
  integer :: fform        ! File format:
  integer :: gwcalctyp    ! Calculation type (G0W0, G0W, GW ...)
  integer :: nI,nJ        ! Number of spin components (rows,columns) in chi|eps^-1. (1,1) if collinear.
                          !  The internal representation of the matrix is eps(nI*npwe,nJ*npwe)
  integer :: nqibz        ! Number of q-points in the IBZ.
  integer :: nqlwl        ! Number of points for the treatment of the long wavelength limit.
  integer :: nomega       ! Total number of frequencies.
  integer :: nbnds_used   ! Number of bands used during the screening calculation (only for info)
  integer :: npwe         ! Number of G vectors reported on the file.
  integer :: npwwfn_used  ! Number of G vectors for wavefunctions used during the screening calculation (only for info)
  integer :: spmeth       ! Method used to approximate the delta function in the expression for Im Chi_0
  integer :: test_type    ! 0 for None, 1 for TEST-PARTICLE, 2 for TEST-ELECTRON (only for TDDFT)
  integer :: tordering    ! 0 if not defined, 1 for Time-Ordered, 2 for Advanced, 3 for Retarded.

  real(dp) :: soenergy    ! Scissor Energy, zero if not used
  real(dp) :: spsmear     ! Smearing of the delta in case of spmeth==2
  real(dp) :: zcut        ! Imaginary shift to avoid the poles along the real axis.

!arrays
  character(len=80) :: title(2)
  ! Title describing the content of the file.

  integer,pointer :: gvec(:,:)   SET2NULL
  ! gvec(3,npwe)
  ! G vectors in r.l.u.

  real(dp),pointer :: qibz(:,:)  SET2NULL
  ! qibz(3,nqibz)
  ! q-points in r.l.u.

  real(dp),pointer :: qlwl(:,:)  SET2NULL
  ! qlwl(3,nqlwl)
  ! q-points for the long wave-length limit treatment (r.l.u)

  complex(dpc),pointer :: lwing(:,:,:)  SET2NULL
  ! lwing(npwe,nomega,nqlwl)
  ! Lower wings for the different q"s -->0

  complex(dpc),pointer :: omega(:)   SET2NULL
  ! omega(nomega)
  ! All frequencies calculated both along the real and the imaginary axis.

  complex(dpc),pointer :: uwing(:,:,:)   SET2NULL
  ! uwing(npwe,nomega,nqlwl)
  ! Upper wings for the different q"s -->0

  type(Hdr_type) :: Hdr   ! The abinit header.

 end type ScrHdr_type
!!***

!----------------------------------------------------------------------

!!****t* defs_gw/epsilonm1_results
!! NAME
!! epsilonm1_results
!!
!! FUNCTION
!! For the GW part of ABINIT, the epsilonm1_results structured datatype
!! gather the results of screening : the inverse dielectric matrix,
!! and the omega matrices .
!!
!! SOURCE

 type Epsilonm1_results

! WARNING : if you modify this datatype, please check there there is no creation/destruction/copy routine,
! declared in another part of ABINIT, that might need to take into account your modification.

  integer :: ID                          ! Matrix identifier: O if not yet defined, 1 for chi0,
                                         ! 2 for chi, 3 for epsilon, 4 for espilon^{-1}, 5 for W.
  integer :: ikxc                        ! Kxc kernel used, 0 for None (RPA), >0 for static TDDFT (=ixc), <0 for TDDFT
  integer :: fform                       ! File format: 1002 for SCR|SUSC files.
  integer :: mqmem                       ! =0 for out-of-core solution, =nqibz if entire matrix is stored in memory.
  integer :: nI,nJ                       ! Number of components (rows,columns) in chi|eps^-1. (1,1) if collinear.
  integer :: nqibz                       ! Number of q-points in the IBZ used.
  integer :: nqlwl                       ! Number of point used for the treatment of the long wave-length limit.
  integer :: nomega                      ! Number of frequencies used.
  integer :: nomega_i                    ! Number of purely imaginary frequencies used.
  integer :: nomega_r                    ! Number of real frequencies used.
  integer :: npwe                        ! Number of G vectors used.
  integer :: test_type                   ! 0 for None, 1 for TEST-PARTICLE, 2 for TEST-ELECTRON (only for TDDFT)
  integer :: Tordering                   ! 0 if not defined, 1 for Time-Ordered, 2 for Advanced, 3 for Retarded.

  character(len=fnlen) :: fname          ! Name of the file from which epsm1 is read.

!arrays
  integer,pointer  :: gvec(:,:)   SET2NULL
  ! gvec(3,npwe)
  ! G-vectors used to describe the two-point function (r.l.u.).

  real(dp),pointer :: qibz(:,:)  SET2NULL
  ! qibz(3,nqibz)
  ! q-points in reduced coordinates

  real(dp),pointer :: qlwl(:,:) SET2NULL
  ! qlwl(3,nqlwl)
  ! q-points used for the long wave-length limit treatment.

  complex(gwpc),pointer :: epsm1(:,:,:,:)  SET2NULL
  ! epsm1(npwe,npwe,nomega,nqibz)
  ! Contains the two-point function $\epsilon_{G,Gp}(q,omega)$ in frequency and reciprocal space.

  complex(dpc),pointer :: lwing(:,:,:)  SET2NULL
  ! lwing(npwe,nomega,nqlwl)
  ! Lower wings for the different q"s -->0

  complex(dpc),pointer :: omega(:)  SET2NULL
  ! omega(nomega)
  ! Frequencies used both along the real and the imaginary axis.

  complex(dpc),pointer :: uwing(:,:,:)  SET2NULL
  ! uwing(npwe,nomega,nqlwl)
  ! Upper wings for the different q"s -->0

  type(ScrHdr_type) :: Hscr
  ! The header reported in the _SCR of _SUSC file.
  ! This object contains information on the susceptibility or the inverse dielectric matrix
  ! as stored in the external file. These quantities do *NOT* correspond to the quantities
  ! used during the GW calculation since some parameters might differ, actually they might be smaller.
  ! For example, the number of G-vectors used can be smaller than the number of G"s stored on file.

 end type Epsilonm1_results
!!***

end module defs_gw
!!***
