!{\src2tex{textfont=tt}}
!!****f* ABINIT/initmpi_grid
!! NAME
!!  initmpi_grid
!!
!! FUNCTION
!!  Initializes the MPI information for the grid:
!!    * 2D if parallization FFT/BAND (!MPI paral_kgb)
!!    * 3D if parallization KPT/FFT/BAND (paral_kgb & MPI)
!!
!! COPYRIGHT
!!  Copyright (C) 2005-2010 ABINIT group
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt.
!!  For the initials of contributors, see
!!  ~abinit/doc/developers/contributors.txt.
!!
!! INPUTS
!!
!! OUTPUT
!!
!! SIDE EFFECTS
!!  mpi_enreg=informations about MPI parallelization
!!
!! TODO
!!
!! PARENTS
!!      initmpi_fft,invars1
!!
!! CHILDREN
!!      mpi_cart_coords,mpi_cart_create,mpi_cart_sub,mpi_comm_rank
!!      mpi_comm_size
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine initmpi_grid(mpi_enreg)

 use defs_basis
 use defs_abitypes

#if defined HAVE_MPI && defined HAVE_MPI2 && !defined FC_G95
 use mpi
#endif

 implicit none
#if defined HAVE_MPI && ( defined HAVE_MPI1 || defined FC_G95 )
 include 'mpif.h'
#endif

!Arguments ------------------------------------
 type(MPI_type),intent(inout) :: mpi_enreg
 
!Local variables-------------------------------
#if defined HAVE_MPI 
 !Variables introduced for MPI version
 integer :: ierr

 !Variables introduced for the bandFFT version
 logical :: reorder
 logical, allocatable :: periode(:), keepdim(:)
 integer :: np_test
#endif

! *********************************************************************

!DEBUG
!write(6,*)' initmpi_grid : enter'
!ENDDEBUG

!Default parameters, for safety of sequential use
 mpi_enreg%me_fft=0
 mpi_enreg%me_kpt=0
 mpi_enreg%me_band=0

#if defined HAVE_MPI 

!TEST THE PARAMETERS OF THE 3D GRID
!========================================

 if(mpi_enreg%nproc_fft*  &
& mpi_enreg%nproc_band* &
& mpi_enreg%nproc_kpt /= mpi_enreg%nproc)then

   write(6,'(8a,i5,a,i5,a,i5,a,i5)') ch10,&
&   ' initmpi_grid : WARNING -',ch10,&
&   '  The number of band*FFT*kpt processors, npband*npfft*kpt, should be',ch10,&
&   '  equal to the total number of processors, nproc.',ch10,&
&   '  However, npband=',mpi_enreg%nproc_band,&
&   ' npfft =',mpi_enreg%nproc_fft,&
&   ' npkpt =',mpi_enreg%nproc_kpt,&
&   ' and nproc=',mpi_enreg%nproc
!  call leave_new('PERS')

 end if

 write(6,*) 'npfft, npband and npkpt',&
& mpi_enreg%nproc_fft,&
& mpi_enreg%nproc_band,&
& mpi_enreg%nproc_kpt

!CREATE THE 3D GRID
!==================================================

 mpi_enreg%dimcart=3

 allocate(mpi_enreg%sizecart(mpi_enreg%dimcart))
!valgrind claims this is not deallocated in test v5/72 Can someone knowledgable check?
 allocate(periode           (mpi_enreg%dimcart))
 allocate(mpi_enreg%coords  (mpi_enreg%dimcart))

 mpi_enreg%sizecart(1) = mpi_enreg%nproc_fft
 mpi_enreg%sizecart(2) = mpi_enreg%nproc_band
 mpi_enreg%sizecart(3) = mpi_enreg%nproc_kpt

 periode(:)=.false.
 reorder   =.false.

!create the cartesian grid with commcart as a communicator.
 call MPI_CART_CREATE(MPI_COMM_WORLD,mpi_enreg%dimcart,mpi_enreg%sizecart,periode,&
& reorder,mpi_enreg%commcart_3d,ierr)


!Find the index and coordinates of the current  processor
 call MPI_COMM_RANK(mpi_enreg%commcart_3d, mpi_enreg%me_cart, ierr)
 call MPI_CART_COORDS(mpi_enreg%commcart_3d, mpi_enreg%me_cart,  mpi_enreg%dimcart, &
& mpi_enreg%coords, ierr)


!Create the communicator for space (Fourier) distribution
 allocate(keepdim(mpi_enreg%dimcart))

 keepdim(1)=.true.
 keepdim(2)=.false.
 keepdim(3)=.false.
 call MPI_CART_SUB(mpi_enreg%commcart_3d, keepdim, mpi_enreg%comm_fft,ierr)

!Create the communicator for band distribution
 keepdim(1)=.false.
 keepdim(2)=.true.
 keepdim(3)=.false.
 call MPI_CART_SUB(mpi_enreg%commcart_3d, keepdim, mpi_enreg%comm_band,ierr)


!Create the communicator for kpt distribution
 keepdim(1)=.false.
 keepdim(2)=.false.
 keepdim(3)=.true.
 call MPI_CART_SUB(mpi_enreg%commcart_3d, keepdim, mpi_enreg%comm_kpt,ierr)

 call MPI_COMM_SIZE(mpi_enreg%comm_fft,np_test, ierr)
 write(6,*) 'mpi_enreg%sizecart(1),np_fft' ,mpi_enreg%sizecart(1), np_test
 call MPI_COMM_SIZE(mpi_enreg%comm_band,np_test, ierr)
 write(6,*) 'mpi_enreg%sizecart(2),np_band',mpi_enreg%sizecart(2), np_test
 call MPI_COMM_SIZE(mpi_enreg%comm_kpt,np_test, ierr)
 write(6,*) 'mpi_enreg%sizecart(3),np_kpt',mpi_enreg%sizecart(3), np_test


!Create the communicator for FFT/band distribution
 keepdim(1)=.true.
 keepdim(2)=.true.
 keepdim(3)=.false.
 call MPI_CART_SUB(mpi_enreg%commcart_3d, keepdim, mpi_enreg%commcart,ierr)

 call MPI_COMM_RANK(mpi_enreg%commcart, mpi_enreg%me_cart_2d, ierr)

!Define the correspondance with the fft
 mpi_enreg%me_fft  = mpi_enreg%coords(1)
 mpi_enreg%me_band = mpi_enreg%coords(2)
 mpi_enreg%me_kpt  = mpi_enreg%coords(3)


!WRITE THE PROCESSORS COORDINATES IN THE 3D GRID
!=====================================================
 write(6,*) 'in initmpi_grid : me_fft, me_band, me_kpt are',&
& mpi_enreg%me_fft,mpi_enreg%me_band,mpi_enreg%me_kpt

 deallocate(periode,keepdim)

!endif
#endif

!DEBUG
!write(6,*)' initmpi_grid : exit'
!ENDDEBUG

end subroutine initmpi_grid
!!***
