!!****m* ABINIT/interfaces_51_manage_mpi
!! NAME
!! interfaces_51_manage_mpi
!!
!! FUNCTION
!! This module contains the interfaces of the routines
!! in the directory src/51_manage_mpi
!!
!! COPYRIGHT
!! Copyright (C) 2010 ABINIT group
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!!
!! NOTES
!! THIS FILE IS GENERATED AUTOMATICALLY BY abilint.
!! To do that: config/scripts/abilint . .
!! 
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

module interfaces_51_manage_mpi

 implicit none

interface
 subroutine clnmpi_atom(mpi_enreg)
  use defs_abitypes
  implicit none
  type(mpi_type), intent(inout) :: mpi_enreg
 end subroutine clnmpi_atom
end interface

interface
 subroutine clnmpi_band(mpi_enreg)
  use defs_abitypes
  implicit none
  type(mpi_type), intent(inout) :: mpi_enreg
 end subroutine clnmpi_band
end interface

interface
 subroutine clnmpi_bandfft(mpi_enreg)
  use defs_abitypes
  implicit none
  type(mpi_type), intent(inout) :: mpi_enreg
 end subroutine clnmpi_bandfft
end interface

interface
 subroutine clnmpi_fft(mpi_enreg)
  use defs_abitypes
  implicit none
  type(mpi_type), intent(inout) :: mpi_enreg
 end subroutine clnmpi_fft
end interface

interface
 subroutine clnmpi_gs(mpi_enreg)
  use defs_abitypes
  implicit none
  type(mpi_type),intent(inout) :: mpi_enreg
 end subroutine clnmpi_gs
end interface

interface
 subroutine clnmpi_respfn(mpi_enreg,spaceComm_noparalrf)
  use defs_abitypes
  implicit none
  integer,intent(in) :: spaceComm_noparalrf
  type(mpi_type),intent(inout) :: mpi_enreg
 end subroutine clnmpi_respfn
end interface

interface
 subroutine distrb2(mband, nband, nkpt, nsppol, mpi_enreg)
  use defs_abitypes
  implicit none
  integer,intent(in) :: mband
  integer,intent(in) :: nkpt
  integer,intent(in) :: nsppol
  type(mpi_type),intent(inout) :: mpi_enreg
  integer,intent(in) :: nband(nkpt*nsppol)
 end subroutine distrb2
end interface

interface
 subroutine filnam_comm(nfilnam,filnam,mpi_enreg)
  use defs_basis
  use defs_abitypes
  implicit none
  integer, intent(in) :: nfilnam
  type(mpi_type), intent(in) :: mpi_enreg
  character(len=fnlen), intent(inout) :: filnam(nfilnam)
 end subroutine filnam_comm
end interface

interface
 subroutine herald(code_name,code_version,iout)
  implicit none
  integer,intent(in) :: iout
  character(len=24),intent(in) :: code_name
  character(len=6),intent(in) :: code_version
 end subroutine herald
end interface

interface
 subroutine initmpi_atom(dtset,mpi_enreg)
  use defs_abitypes
  implicit none
  type(dataset_type),intent(in) :: dtset
  type(mpi_type),intent(inout) :: mpi_enreg
 end subroutine initmpi_atom
end interface

interface
 subroutine initmpi_band(mpi_enreg,nband,nkpt,nsppol)
  use defs_abitypes
  implicit none
  integer,intent(in) :: nkpt
  integer,intent(in) :: nsppol
  type(mpi_type),intent(inout) :: mpi_enreg
  integer,intent(in) :: nband(nkpt*nsppol)
 end subroutine initmpi_band
end interface

interface
 subroutine initmpi_fft(dtset,mpi_enreg)
  use defs_abitypes
  implicit none
  type(dataset_type),intent(in) :: dtset
  type(mpi_type),intent(inout) :: mpi_enreg
 end subroutine initmpi_fft
end interface

interface
 subroutine initmpi_grid(mpi_enreg)
  use defs_abitypes
  implicit none
  type(mpi_type),intent(inout) :: mpi_enreg
 end subroutine initmpi_grid
end interface

interface
 subroutine initmpi_gs(dtset,mpi_enreg)
  use defs_abitypes
  implicit none
  type(dataset_type),intent(in) :: dtset
  type(mpi_type),intent(inout) :: mpi_enreg
 end subroutine initmpi_gs
end interface

interface
 subroutine initmpi_respfn(mpi_enreg,spaceComm,spaceComm_noparalrf)
  use defs_abitypes
  implicit none
  integer,intent(in) :: spaceComm
  integer,intent(out) :: spaceComm_noparalrf
  type(mpi_type),intent(inout) :: mpi_enreg
 end subroutine initmpi_respfn
end interface

interface
 subroutine initmpi_seq(mpi_enreg)
  use defs_abitypes
  implicit none
  type(mpi_type),intent(out) :: mpi_enreg
 end subroutine initmpi_seq
end interface

interface
 subroutine leave_test(mpi_enreg)
  use defs_abitypes
  implicit none
  type(mpi_type),intent(in) :: mpi_enreg
 end subroutine leave_test
end interface

interface
 subroutine nullify_mpi_enreg(MPI_enreg)
  use defs_abitypes
  implicit none
  type(mpi_type),intent(inout) :: MPI_enreg
 end subroutine nullify_mpi_enreg
end interface

interface
 subroutine destroy_mpi_enreg(MPI_enreg)
  use defs_abitypes
  implicit none
  type(mpi_type),intent(inout) :: MPI_enreg
 end subroutine destroy_mpi_enreg
end interface

interface
 subroutine copy_mpi_enreg(MPI_enreg1,MPI_enreg2,opt_bandfft)
  use defs_abitypes
  implicit none
  integer :: opt_bandfft
  type(mpi_type),intent(inout) :: MPI_enreg2
  type(mpi_type),intent(inout) :: mpi_enreg1
 end subroutine copy_mpi_enreg
end interface

interface
 subroutine my_indeces(MPI_enreg,ikpt,isppol,nkpt,nsppol,nspinor,npwarr,nband,kindex,bdtot_index,ibg,ikg,ierr)
  use defs_abitypes
  implicit none
  integer,intent(out) :: bdtot_index
  integer,intent(out) :: ibg
  integer,intent(out) :: ierr
  integer,intent(out) :: ikg
  integer,intent(in) :: ikpt
  integer,intent(in) :: isppol
  integer,intent(out) :: kindex
  integer,intent(in) :: nkpt
  integer,intent(in) :: nspinor
  integer,intent(in) :: nsppol
  type(mpi_type),intent(in) :: MPI_enreg
  integer,intent(in) :: nband(nkpt*nsppol)
  integer,intent(in) :: npwarr(nkpt)
 end subroutine my_indeces
end interface

interface
 subroutine pre_gather(array,array_allgather,n1,n2,n3,n4,mpi_enreg)
  use defs_basis
  use defs_abitypes
  implicit none
  integer,intent(in) :: n1
  integer,intent(in) :: n2
  integer,intent(in) :: n3
  integer,intent(in) :: n4
  type(mpi_type),intent(inout) :: mpi_enreg
  real(dp),intent(in) :: array(n1,n2,n4,1)
  real(dp),intent(inout) :: array_allgather(n1,n2,n3,1)
 end subroutine pre_gather
end interface

interface
 subroutine pre_scatter(array,array_allgather,n1,n2,n3,n4,mpi_enreg)
  use defs_basis
  use defs_abitypes
  implicit none
  integer,intent(in) :: n1
  integer,intent(in) :: n2
  integer,intent(in) :: n3
  integer,intent(in) :: n4
  type(mpi_type),intent(inout) :: mpi_enreg
  real(dp),intent(out) :: array(n1,n2,n4,1)
  real(dp),intent(in) :: array_allgather(n1,n2,n3,1)
 end subroutine pre_scatter
end interface

interface
 subroutine pspheads_comm(npsp,mpi_enreg,pspheads,test_paw)
  use defs_abitypes
  use defs_datatypes
  implicit none
  integer,intent(in) :: npsp
  integer,intent(inout) :: test_paw
  type(mpi_type), intent(in) :: mpi_enreg
  type(pspheader_type),intent(inout) :: pspheads(npsp)
 end subroutine pspheads_comm
end interface

interface
 subroutine build_grid_scalapack(grid,nbprocs, communicator)
  use defs_scalapack
  implicit none
  integer, intent(in) :: communicator
  integer,intent(in) :: nbprocs
  type(grid_scalapack),intent(out) :: grid
 end subroutine build_grid_scalapack
end interface

interface
 subroutine build_processor_scalapack(processor,grid,myproc, comm)
  use defs_scalapack
  implicit none
  integer,intent(in) :: comm
  integer,intent(in) :: myproc
  type(grid_scalapack),intent(in) :: grid
  type(processor_scalapack),intent(out) :: processor
 end subroutine build_processor_scalapack
end interface

interface
 subroutine init_scalapack(processor,communicator)
  use defs_scalapack
  implicit none
  integer, intent(in) :: communicator
  type(processor_scalapack),intent(out) :: processor
 end subroutine init_scalapack
end interface

interface
 subroutine end_scalapack(processor)
  use defs_scalapack
  implicit none
  type(processor_scalapack),intent(inout) :: processor
 end subroutine end_scalapack
end interface

interface
 subroutine init_matrix_scalapack(matrix,nbli_global,nbco_global,processor,istwf_k,tbloc)
  use defs_scalapack
  implicit none
  integer,intent(in) :: istwf_k
  integer,intent(in) :: nbco_global
  integer,intent(in) :: nbli_global
  integer,intent(in),optional :: tbloc
  type(matrix_scalapack),intent(out) :: matrix
  type(processor_scalapack),intent(in),target :: processor
 end subroutine init_matrix_scalapack
end interface

interface
 subroutine destruction_matrix_scalapack(matrix)
  use defs_scalapack
  implicit none
  type(matrix_scalapack),intent(inout) :: matrix
 end subroutine destruction_matrix_scalapack
end interface

interface
 function matrix_get_local_cplx(matrix,i,j)
  use defs_basis
  use defs_scalapack
  implicit none
  integer, intent(in) :: i
  integer, intent(in) :: j
  type(matrix_scalapack),intent(in) :: matrix
  complex(dp) :: matrix_get_local_cplx
 end function matrix_get_local_cplx
end interface

interface
 function matrix_get_local_real(matrix,i,j)
  use defs_basis
  use defs_scalapack
  implicit none
  integer, intent(in) :: i
  integer, intent(in) :: j
  type(matrix_scalapack),intent(in) :: matrix
  real(dp) :: matrix_get_local_real
 end function matrix_get_local_real
end interface

interface
 subroutine matrix_set_local_cplx(matrix,i,j,value)
  use defs_basis
  use defs_scalapack
  implicit none
  integer, intent(in) :: i
  integer, intent(in) :: j
  type(matrix_scalapack),intent(out) :: matrix
  complex(dp), intent(in) :: value
 end subroutine matrix_set_local_cplx
end interface

interface
 subroutine matrix_set_local_real(matrix,i,j,value)
  use defs_basis
  use defs_scalapack
  implicit none
  integer, intent(in) :: i
  integer, intent(in) :: j
  type(matrix_scalapack),intent(out) :: matrix
  real(dp), intent(in) :: value
 end subroutine matrix_set_local_real
end interface

interface
 subroutine idx_loc(matrix,i,j,iloc,jloc)
  use defs_scalapack
  implicit none
  integer, intent(in) :: i
  integer, intent(out) :: iloc
  integer, intent(in) :: j
  integer, intent(out) :: jloc
  type(matrix_scalapack),intent(in) :: matrix
 end subroutine idx_loc
end interface

interface
 function glob_loc(matrix,idx,lico)
  use defs_scalapack
  implicit none
  integer :: glob_loc
  integer, intent(in) :: idx
  integer, intent(in) :: lico
  type(matrix_scalapack),intent(in) :: matrix
 end function glob_loc
end interface

interface
 subroutine idx_glob(matrix,iloc,jloc,i,j)
  use defs_scalapack
  implicit none
  integer, intent(out) :: i
  integer, intent(in) :: iloc
  integer, intent(out) :: j
  integer, intent(in) :: jloc
  type(matrix_scalapack),intent(in) :: matrix
 end subroutine idx_glob
end interface

interface
 function loc_glob(matrix,proc,idx,lico)
  use defs_scalapack
  implicit none
  integer, intent(in) :: idx
  integer, intent(in) :: lico
  integer :: loc_glob
  type(matrix_scalapack),intent(in) :: matrix
  type(processor_scalapack),intent(in) :: proc
 end function loc_glob
end interface

interface
 subroutine matrix_from_global(matrix,reference,istwf_k)
  use defs_basis
  use defs_scalapack
  implicit none
  integer,intent(in) :: istwf_k
  type(matrix_scalapack),intent(inout) :: matrix
  real(dp),dimension(:),intent(in) :: reference
 end subroutine matrix_from_global
end interface

interface
 subroutine matrix_to_global(matrix,reference,istwf_k)
  use defs_basis
  use defs_scalapack
  implicit none
  integer,intent(in) :: istwf_k
  type(matrix_scalapack),intent(in) :: matrix
  real(dp),dimension(:),intent(inout) :: reference
 end subroutine matrix_to_global
end interface

interface
 subroutine matrix_to_reference(matrix,reference,istwf_k)
  use defs_basis
  use defs_scalapack
  implicit none
  integer,intent(in) :: istwf_k
  type(matrix_scalapack),intent(in) :: matrix
  real(dp),dimension(:,:),intent(inout) :: reference
 end subroutine matrix_to_reference
end interface

interface
 subroutine slk_matrix_from_global_dpc_2D(Slk_mat,uplo,glob_mat)
  use defs_basis
  use defs_scalapack
  implicit none
  type(matrix_scalapack),intent(inout) :: Slk_mat
  character(len=*),intent(in) :: uplo
  complex(dpc),intent(in) :: glob_mat(:,:)
 end subroutine slk_matrix_from_global_dpc_2D
end interface

interface
 subroutine slk_matrix_from_global_dpc_1Dp(Slk_mat,uplo,glob_pmat)
  use defs_basis
  use defs_scalapack
  implicit none
  type(matrix_scalapack),intent(inout) :: Slk_mat
  character(len=*),intent(in) :: uplo
  complex(dpc),intent(in) :: glob_pmat(:)
 end subroutine slk_matrix_from_global_dpc_1Dp
end interface

interface
 subroutine slk_matrix_to_global_dpc_2D(Slk_mat,uplo,glob_mat)
  use defs_basis
  use defs_scalapack
  implicit none
  type(matrix_scalapack),intent(in) :: Slk_mat
  character(len=*),intent(in) :: uplo
  complex(dpc),intent(inout) :: glob_mat(:,:)
 end subroutine slk_matrix_to_global_dpc_2D
end interface

interface
 function my_locr(Slk_mat)
  use defs_scalapack
  implicit none
  integer :: my_locr
  type(matrix_scalapack),intent(in) :: Slk_mat
 end function my_locr
end interface

interface
 function my_locc(Slk_mat)
  use defs_scalapack
  implicit none
  integer :: my_locc
  type(matrix_scalapack),intent(in) :: Slk_mat
 end function my_locc
end interface

interface
 subroutine matrix_pzgemm(matrix1,alpha,matrix2,beta,results)
  use defs_basis
  use defs_scalapack
  implicit none
  complex(dp), intent(in) :: alpha
  complex(dp), intent(in) :: beta
  type(matrix_scalapack),intent(in) :: matrix1
  type(matrix_scalapack),intent(in) :: matrix2
  type(matrix_scalapack),intent(inout) :: results
 end subroutine matrix_pzgemm
end interface

interface
 subroutine compute_eigen_values_vectors(processor,matrix,results,eigen,communicator,istwf_k)
  use defs_scalapack
  implicit none
  integer,intent(in) :: communicator
  integer,intent(in) :: istwf_k
  type(matrix_scalapack),intent(in) :: matrix
  type(processor_scalapack),intent(in) :: processor
  type(matrix_scalapack),intent(inout) :: results
  double precision,dimension(:),intent(inout) :: eigen
 end subroutine compute_eigen_values_vectors
end interface

interface
 subroutine compute_eigen_problem(processor,matrix1,matrix2,results,eigen,communicator,istwf_k)
  use defs_scalapack
  implicit none
  integer,intent(in) :: communicator
  integer,intent(in) :: istwf_k
  type(matrix_scalapack),intent(in) :: matrix1
  type(matrix_scalapack),intent(in) :: matrix2
  type(processor_scalapack),intent(in) :: processor
  type(matrix_scalapack),intent(inout) :: results
  double precision,dimension(:),intent(inout) :: eigen
 end subroutine compute_eigen_problem
end interface

interface
 subroutine slk_pzheev(jobz,uplo,Slk_mat,Slk_vec,w)
  use defs_basis
  use defs_scalapack
  implicit none
  type(matrix_scalapack),intent(inout) :: Slk_mat
  type(matrix_scalapack),intent(inout) :: Slk_vec
  character(len=*),intent(in) :: jobz
  character(len=*),intent(in) :: uplo
  real(dp),intent(out) :: w(:)
 end subroutine slk_pzheev
end interface

interface
 subroutine slk_pzheevx(jobz,range,uplo,Slk_mat,vl,vu,il,iu,abstol,Slk_vec,mene_found,eigen)
  use defs_basis
  use defs_scalapack
  implicit none
  integer,intent(in) :: il
  integer,intent(in) :: iu
  integer,intent(out) :: mene_found
  type(matrix_scalapack),intent(inout) :: Slk_mat
  type(matrix_scalapack),intent(inout) :: Slk_vec
  real(dp),intent(in) :: abstol
  character(len=*),intent(in) :: jobz
  character(len=*),intent(in) :: range
  character(len=*),intent(in) :: uplo
  real(dp),intent(in) :: vl
  real(dp),intent(in) :: vu
  real(dp),intent(out) :: eigen(:)
 end subroutine slk_pzheevx
end interface

interface
 subroutine slk_pzhegvx(ibtype,jobz,range,uplo,Slk_matA,Slk_matB,vl,vu,il,iu,abstol,Slk_vec,mene_found,eigen)
  use defs_basis
  use defs_scalapack
  implicit none
  integer,intent(in) :: ibtype
  integer,intent(in) :: il
  integer,intent(in) :: iu
  integer,intent(out) :: mene_found
  type(matrix_scalapack),intent(inout) :: Slk_matA
  type(matrix_scalapack),intent(inout) :: Slk_matB
  type(matrix_scalapack),intent(inout) :: Slk_vec
  real(dp),intent(in) :: abstol
  character(len=*),intent(in) :: jobz
  character(len=*),intent(in) :: range
  character(len=*),intent(in) :: uplo
  real(dp),intent(in) :: vl
  real(dp),intent(in) :: vu
  real(dp),intent(out) :: eigen(:)
 end subroutine slk_pzhegvx
end interface

interface
 subroutine slk_zinvert(Slk_mat)
  use defs_scalapack
  implicit none
  type(matrix_scalapack),intent(inout) :: Slk_mat
 end subroutine slk_zinvert
end interface

interface
 subroutine slk_write(Slk_mat,uplo,fname,use_mpiio,offset,flags)
  use defs_basis
  use defs_scalapack
  implicit none
  integer,optional,intent(in) :: flags
  integer(kind=i8b),optional,intent(in) :: offset
  type(matrix_scalapack),intent(in) :: Slk_mat
  character(len=*),intent(in) :: fname
  character(len=*),intent(in) :: uplo
  logical,intent(in) :: use_mpiio
 end subroutine slk_write
end interface

interface
 subroutine slk_read(Slk_mat,uplo,symtype,fname,use_mpiio,offset,flags)
  use defs_basis
  use defs_scalapack
  implicit none
  integer,optional,intent(in) :: flags
  integer(kind=i8b),optional,intent(in) :: offset
  type(matrix_scalapack),intent(inout) :: Slk_mat
  character(len=*),intent(in) :: fname
  character(len=*),intent(in) :: symtype
  character(len=*),intent(in) :: uplo
  logical,intent(in) :: use_mpiio
 end subroutine slk_read
end interface

interface
 subroutine no_scalapack
  implicit none
 end subroutine no_scalapack
end interface

interface
 subroutine split_work(ntasks,comm,istart,istop,verbose)
  implicit none
  integer,intent(in) :: comm
  integer,intent(out) :: istart
  integer,intent(out) :: istop
  integer,intent(in) :: ntasks
  integer,optional,intent(in) :: verbose
 end subroutine split_work
end interface

interface
 subroutine split_work2(ntasks,nprocs,istart,istop,verbose)
  implicit none
  integer,intent(in) :: nprocs
  integer,intent(in) :: ntasks
  integer,optional,intent(in) :: verbose
  integer,intent(inout) :: istart(nprocs)
  integer,intent(inout) :: istop(nprocs)
 end subroutine split_work2
end interface

interface
 subroutine fill_task_distrib_4D(nprocs,task_distrib)
  implicit none
  integer,intent(in) :: nprocs
  integer,intent(inout) :: task_distrib(:,:,:,:)
 end subroutine fill_task_distrib_4D
end interface

interface
 subroutine xcomm_world(mpi_enreg,spaceComm)
  use defs_abitypes
  implicit none
  integer,intent(out) :: spaceComm
  type(mpi_type),intent(in) :: mpi_enreg
 end subroutine xcomm_world
end interface

interface
 subroutine xcomm_self(spaceComm)
  implicit none
  integer,intent(out) :: spaceComm
 end subroutine xcomm_self
end interface

interface
 subroutine xcomm_init(mpi_enreg,spaceComm,spaceComm_bandfft)
  use defs_abitypes
  implicit none
  integer,intent(out) :: spaceComm
  integer,intent(in),optional :: spaceComm_bandfft
  type(mpi_type),intent(in) :: mpi_enreg
 end subroutine xcomm_init
end interface

interface
 subroutine xmaster_init(mpi_enreg,master)
  use defs_abitypes
  implicit none
  integer,intent(out) :: master
  type(mpi_type),intent(in) :: mpi_enreg
 end subroutine xmaster_init
end interface

interface
 subroutine xmaster_init_fft(mpi_enreg,master)
  use defs_abitypes
  implicit none
  integer,intent(out) :: master
  type(mpi_type),intent(in) :: mpi_enreg
 end subroutine xmaster_init_fft
end interface

interface
 subroutine xme_init(mpi_enreg,me,option_comm)
  use defs_abitypes
  implicit none
  integer,intent(out) :: me
  integer,intent(in),optional :: option_comm
  type(mpi_type),intent(in) :: mpi_enreg
 end subroutine xme_init
end interface

interface
 subroutine xproc_init(mpi_enreg,nproc_max)
  use defs_abitypes
  implicit none
  integer,intent(out) :: nproc_max
  type(mpi_type),intent(in) :: mpi_enreg
 end subroutine xproc_init
end interface

interface
 subroutine xdefineOff(formeig,wff,mpi_enreg,nband,npwarr,nspinor,nsppol,nkpt)
  use defs_abitypes
  use m_wffile
  implicit none
  integer, intent(in) :: formeig
  integer, intent(in) :: nkpt
  integer, intent(in) :: nspinor
  integer, intent(in) :: nsppol
  type(mpi_type),intent(in) :: mpi_enreg
  type(wffile_type),intent(inout) :: wff
  integer, intent(in) :: nband(nkpt*nsppol)
  integer, intent(in) :: npwarr(nkpt)
 end subroutine xdefineOff
end interface


!Generic interface of the routines xderiveread
interface xderiveread
 subroutine xderiveRead_int(wff,xval,ierr)
  use m_wffile
  implicit none
  integer,intent(out) :: ierr
  integer,intent(out) :: xval
  type(wffile_type),intent(inout) :: wff
 end subroutine xderiveRead_int
 subroutine xderiveRead_int1d(wff,xval,n1,spaceComm,ierr)
  use m_wffile
  implicit none
  integer,intent(out) :: ierr
  integer,intent(in) :: n1
  integer,intent(in) :: spaceComm
  type(wffile_type),intent(inout) :: wff
  integer,intent(out) :: xval(:)
 end subroutine xderiveRead_int1d
 subroutine xderiveRead_int2d(wff,xval,n1,n2,spaceComm,ierr)
  use m_wffile
  implicit none
  integer,intent(out) :: ierr
  integer,intent(in) :: n1
  integer,intent(in) :: n2
  integer,intent(in) :: spaceComm
  type(wffile_type),intent(inout) :: wff
  integer,intent(out) :: xval(:,:)
 end subroutine xderiveRead_int2d
 subroutine xderiveRead_dp(wff,xval,ierr)
  use defs_basis
  use m_wffile
  implicit none
  integer,intent(out) :: ierr
  type(wffile_type),intent(inout) :: wff
  real(dp),intent(out) :: xval
 end subroutine xderiveRead_dp
 subroutine xderiveRead_dp1d(wff,xval,n1,spaceComm,ierr)
  use defs_basis
  use m_wffile
  implicit none
  integer,intent(out) :: ierr
  integer,intent(in) :: n1
  integer,intent(in) :: spaceComm
  type(wffile_type),intent(inout) :: wff
  real(dp),intent(out) :: xval(:)
 end subroutine xderiveRead_dp1d
 subroutine xderiveRead_dp2d(wff,xval,n1,n2,spaceComm,ierr)
  use defs_basis
  use m_wffile
  implicit none
  integer,intent(out) :: ierr
  integer,intent(in) :: n1
  integer,intent(in) :: n2
  integer,intent(in) :: spaceComm
  type(wffile_type),intent(inout) :: wff
  real(dp),intent(out) :: xval(:,:)
 end subroutine xderiveRead_dp2d
 subroutine xderiveRead_int2d_displ(wff,xval,n1,n2,spaceComm,displace,ierr)
  use m_wffile
  implicit none
  integer,intent(out) :: ierr
  integer,intent(in) :: n1
  integer,intent(in) :: n2
  integer,intent(in) :: spaceComm
  type(wffile_type),intent(inout) :: wff
  integer,intent(in) :: displace(:)
  integer,intent(out) :: xval(:,:)
 end subroutine xderiveRead_int2d_displ
 subroutine xderiveRead_dp2d_displ(wff,xval,n1,n2,spaceComm,displace,ierr)
  use defs_basis
  use m_wffile
  implicit none
  integer,intent(out) :: ierr
  integer,intent(in) :: n1
  integer,intent(in) :: n2
  integer,intent(in) :: spaceComm
  type(wffile_type),intent(inout) :: wff
  integer,intent(in) :: displace(:)
  real(dp),intent(out) :: xval(:,:)
 end subroutine xderiveRead_dp2d_displ
 subroutine xderiveReadVal_char(wff,xval,n,ierr)
  use m_wffile
  implicit none
  integer,intent(out) :: ierr
  integer,intent(in) :: n
  type(wffile_type),intent(inout) :: wff
  character(len=*),intent(out) :: xval
 end subroutine xderiveReadVal_char
end interface
!End of the generic interface of xderiveread


!Generic interface of the routines xderivewrite
interface xderivewrite
 subroutine xderiveWrite_int(wff,xval,ierr)
  use m_wffile
  implicit none
  integer,intent(out) :: ierr
  integer,intent(in) :: xval
  type(wffile_type),intent(inout) :: wff
 end subroutine xderiveWrite_int
 subroutine xderiveWrite_int1d(wff,xval,n1,spaceComm,ierr)
  use m_wffile
  implicit none
  integer,intent(out) :: ierr
  integer,intent(in) :: n1
  integer,intent(in) :: spaceComm
  type(wffile_type),intent(inout) :: wff
  integer,intent(in) :: xval(:)
 end subroutine xderiveWrite_int1d
 subroutine xderiveWrite_int2d(wff,xval,n1,n2,spaceComm,ierr)
  use m_wffile
  implicit none
  integer,intent(out) :: ierr
  integer,intent(in) :: n1
  integer,intent(in) :: n2
  integer,intent(in) :: spaceComm
  type(wffile_type),intent(inout) :: wff
  integer,intent(in) :: xval(:,:)
 end subroutine xderiveWrite_int2d
 subroutine xderiveWrite_dp(wff,xval,ierr)
  use defs_basis
  use m_wffile
  implicit none
  integer,intent(out) :: ierr
  type(wffile_type),intent(inout) :: wff
  real(dp),intent(in) :: xval
 end subroutine xderiveWrite_dp
 subroutine xderiveWrite_dp1d(wff,xval,n1,spaceComm,ierr)
  use defs_basis
  use m_wffile
  implicit none
  integer,intent(out) :: ierr
  integer,intent(in) :: n1
  integer,intent(in) :: spaceComm
  type(wffile_type),intent(inout) :: wff
  real(dp),intent(in) :: xval(:)
 end subroutine xderiveWrite_dp1d
 subroutine xderiveWrite_dp2d(wff,xval,n1,n2,spaceComm,ierr)
  use defs_basis
  use m_wffile
  implicit none
  integer,intent(out) :: ierr
  integer,intent(in) :: n1
  integer,intent(in) :: n2
  integer,intent(in) :: spaceComm
  type(wffile_type),intent(inout) :: wff
  real(dp),intent(in) :: xval(:,:)
 end subroutine xderiveWrite_dp2d
 subroutine xderiveWrite_int2d_displ(wff,xval,n1,n2,spaceComm,displace,ierr)
  use m_wffile
  implicit none
  integer,intent(out) :: ierr
  integer,intent(in) :: n1
  integer,intent(in) :: n2
  integer,intent(in) :: spaceComm
  type(wffile_type),intent(inout) :: wff
  integer,intent(in) :: displace(:)
  integer,intent(in) :: xval(:,:)
 end subroutine xderiveWrite_int2d_displ
 subroutine xderiveWrite_dp2d_displ(wff,xval,n1,n2,spaceComm,displace,ierr)
  use defs_basis
  use m_wffile
  implicit none
  integer,intent(out) :: ierr
  integer,intent(in) :: n1
  integer,intent(in) :: n2
  integer,intent(in) :: spaceComm
  type(wffile_type),intent(inout) :: wff
  integer,intent(in) :: displace(:)
  real(dp),intent(in) :: xval(:,:)
 end subroutine xderiveWrite_dp2d_displ
 subroutine xderiveWrite_char(wff,xval,n,ierr)
  use m_wffile
  implicit none
  integer,intent(out) :: ierr
  integer,intent(in) :: n
  type(wffile_type),intent(inout) :: wff
  character(len=*),intent(in) :: xval
 end subroutine xderiveWrite_char
end interface
!End of the generic interface of xderivewrite

end module interfaces_51_manage_mpi
!!***
