!{\src2tex{textfont=tt}}
!!****f* ABINIT/split_work
!! NAME
!!  split_work
!!
!! FUNCTION
!!  Splits a number of tasks, ntasks, among nprocs processors.
!!  Useful for on-the-fly parallelization of simple loops
!!
!! COPYRIGHT
!!  Copyright (C) 2007-2010 ABINIT group (MG)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!  For the initials of contributors, see
!!  ~abinit/doc/developers/contributors.txt.
!!
!! INPUTS
!!  ntasks=number of tasks
!!  comm=MPI communicator.
!!  [verbose]=Verbosity level, if verb>0, warning messages will be printed is the load distribution is not optimal.
!!
!! OUTPUT
!!  istart,istop= indices defining the initial and final task for this processor
!!
!! NOTES
!!  If nprocs>ntasks then : 
!!    istart=ntasks+1
!!    istop=ntask 
!!                                                                  
!!  In this particular case, loops of the form  
!!                                                                  
!!  do ii=istart,istop 
!!   ...
!!  end do
!!                                                                  
!!  are not executed. Moreover allocation such as foo(istart:istop) will generate a zero-sized array.
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine split_work(ntasks,comm,istart,istop,verbose)
    
 use defs_basis
 use m_xmpi

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
!End of the abilint section

 implicit none

!Arguments ------------------------------------
 integer,intent(in)  :: ntasks,comm
 integer,optional,intent(in) :: verbose
 integer,intent(out) :: istart,istop

!Local variables-------------------------------
 integer :: res,nprocs,my_rank,block_p1,block,verb
 character(len=500) :: msg                  
 
! *************************************************************************
 
 verb=0; if (PRESENT(verbose)) verb=verbose

 nprocs  = xcomm_size(comm)
 my_rank = xcomm_rank(comm)
!master=0

 block   = ntasks/nprocs 
 res     = MOD(ntasks,nprocs) 
 block_p1= block+1   

 if (res/=0.and.verb/=0) then 
   write(msg,'(4a,i5,a,i4)')ch10,&
&   ' split_work : WARNING - ',ch10,&
&   '  number of tasks= ',ntasks,' not divisible by nprocs= ',nprocs
   call wrtout(std_out,msg,'COLL')
 end if 
 if (block==0) then 
   write(msg,'(4a,i4,a,i5,3a)')ch10,&
&   ' split_work : WARNING - ',ch10,&
&   ' number of processors= ',nprocs,' larger than number of tasks= ',ntasks,ch10,&
&   ' This is a waste ',ch10
   call wrtout(std_out,msg,'COLL')
 end if 

 if (my_rank<res) then
   istart =  my_rank   *block_p1+1
   istop  = (my_rank+1)*block_p1
 else
   istart = res*block_p1 + (my_rank-res  )*block + 1
   istop  = res*block_p1 + (my_rank-res+1)*block
 end if

end subroutine split_work
!!***
