!{\src2tex{textfont=tt}}
!!****f* ABINIT/xdef_comm
!! NAME
!!  xdef_comm
!!
!! FUNCTION
!!  Defines communicator and tools for MPI.
!!
!! COPYRIGHT
!!  Copyright (C) 2003-2010 ABINIT group (MB)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!  For the initials of contributors, see
!!  ~abinit/doc/developers/contributors.txt.
!!
!! NOTES
!!  Should become a module.
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

!!***

!!****f* ABINIT/xcomm_world
!! NAME
!!  xcomm_world
!!
!! FUNCTION
!!  Defines the communicator with the world communicator
!!
!! INPUTS
!!  mpi_enreg= information about MPI parallelization
!!
!! OUTPUT
!!  spaceComm= MPI communicator
!!
!! SIDE EFFECTS
!!  None
!!
!! NOTES
!!  Used to distinguish serial execution when performing reduction operations.
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE

subroutine xcomm_world(mpi_enreg,spaceComm)

 use defs_abitypes

#if defined HAVE_MPI && defined HAVE_MPI2
 use mpi
#endif

 implicit none

#if defined HAVE_MPI && defined HAVE_MPI1
 include 'mpif.h'
#endif

!Arguments-------------------------
 type(MPI_type),intent(in) :: mpi_enreg
 integer,intent(out) :: spaceComm

!Local variables-------------------

! *********************************************************************

#if defined HAVE_MPI
 if (mpi_enreg%paral_compil_respfn == 1) then
   spaceComm = mpi_enreg%spaceComm
 else
   spaceComm = MPI_COMM_WORLD
 end if
#else
 spaceComm = abinit_comm_serial
#endif
end subroutine xcomm_world
!!***


!!****f* ABINIT/xcomm_self
!! NAME
!!  xcomm_self
!!
!! FUNCTION
!!  Defines the communicator with the self communicator
!!
!! INPUTS
!!  None
!!
!! OUTPUT
!!  spaceComm= MPI communicator
!!
!! SIDE EFFECTS
!!  None
!!
!! NOTES
!!  Used to distinguish serial execution when performing reduction operations.
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE

subroutine xcomm_self(spaceComm)

 use defs_abitypes

#if defined HAVE_MPI && defined HAVE_MPI2
 use mpi
#endif

 implicit none

#if defined HAVE_MPI && defined HAVE_MPI1
 include 'mpif.h'
#endif

!Arguments-------------------------
 integer,intent(out) :: spaceComm

!Local variables-------------------

! *********************************************************************

#if defined HAVE_MPI
 spaceComm = MPI_COMM_SELF
#else
 spaceComm = abinit_comm_serial
#endif
end subroutine xcomm_self
!!***


!!****f* ABINIT/xcomm_init
!! NAME
!!  xcomm_init
!!
!! FUNCTION
!!  Initializes the communicator.
!!
!! INPUTS
!!  mpi_enreg= information about MPI parallelization
!!  spaceComm_bandfft= MPI communicator which has to be used is band-fft parallelism is activated (optional argument)
!!
!! OUTPUT
!!  spaceComm= MPI communicator
!!
!! SIDE EFFECTS
!!  None
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE

subroutine xcomm_init(mpi_enreg,spaceComm,spaceComm_bandfft)
 use defs_basis
 use defs_abitypes

#if defined HAVE_MPI && defined HAVE_MPI2
 use mpi
#endif

 implicit none

#if defined HAVE_MPI && defined HAVE_MPI1
 include 'mpif.h'
#endif

!Arguments-------------------------
 type(MPI_type),intent(in) :: mpi_enreg
 integer,intent(in),optional :: spaceComm_bandfft
 integer,intent(out) :: spaceComm

!Local variables-------------------

! *********************************************************************

#if defined HAVE_MPI
 if (mpi_enreg%mode_para=='b'.and.present(spaceComm_bandfft)) then
   spaceComm=spaceComm_bandfft
 else if (mpi_enreg%paral_compil_respfn == 1) then
   if (mpi_enreg%paral_level == 2) then
     spaceComm = mpi_enreg%spaceComm
   else
     if (mpi_enreg%num_group_fft /= 0) then
       spaceComm =  mpi_enreg%fft_comm(mpi_enreg%num_group_fft)
     else
       spaceComm = MPI_COMM_SELF
     end if
   end if
 elseif (mpi_enreg%paral_level > 1) then
   if (mpi_enreg%paral_level == 2) then
     spaceComm = MPI_COMM_WORLD
   else
     if (mpi_enreg%num_group_fft /= 0) then
       spaceComm =  mpi_enreg%fft_comm(mpi_enreg%num_group_fft)
     else
       spaceComm = MPI_COMM_SELF
     end if
   end if
 else
   spaceComm = MPI_COMM_WORLD
 end if
#else
 spaceComm = abinit_comm_serial
#endif
end subroutine xcomm_init
!!***


!!****f* ABINIT/xmaster_init
!! NAME
!!  xmaster_init
!!
!! FUNCTION
!!  Defines the master MPI node.
!!
!! INPUTS
!!  mpi_enreg= information about MPI parallelization
!!
!! OUTPUT
!!  master= master MPI node
!!
!! SIDE EFFECTS
!!  None
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE

subroutine xmaster_init(mpi_enreg,master)
 use defs_abitypes

#if defined HAVE_MPI && defined HAVE_MPI2
 use mpi
#endif

 implicit none

#if defined HAVE_MPI && defined HAVE_MPI1
 include 'mpif.h'
#endif

!Arguments-------------------------
 type(MPI_type),intent(in) :: mpi_enreg
 integer,intent(out) :: master

! *********************************************************************

 master = 0
 if(.false.)write(6,*)mpi_enreg%nproc

end subroutine xmaster_init
!!***

!!****f* ABINIT/xmaster_init_fft
!! NAME
!!  xmaster_init_fft
!!
!! FUNCTION
!!  Defines the master MPI-FFT node.
!!
!! INPUTS
!!  mpi_enreg= information about MPI parallelization
!!
!! OUTPUT
!!  master= master MPI node
!!
!! SIDE EFFECTS
!!  None
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE

subroutine xmaster_init_fft(mpi_enreg,master)
 use defs_abitypes

#if defined HAVE_MPI && defined HAVE_MPI2
 use mpi
#endif

 implicit none

#if defined HAVE_MPI && defined HAVE_MPI1
 include 'mpif.h'
#endif

!Arguments-------------------------
 type(MPI_type),intent(in) :: mpi_enreg
 integer,intent(out) :: master

!Local variables-------------------

! *********************************************************************

#if defined HAVE_MPI
 if (mpi_enreg%paral_fft == 0) then
   master = mpi_enreg%me
 else
   master = mpi_enreg%master_fft
 end if
#else
 master = 0
#endif
end subroutine xmaster_init_fft
!!***

!!****f* ABINIT/xme_init
!! NAME
!!  xme_init
!!
!! FUNCTION
!!  Defines who is the current node ("me") in the world (or k-points) communicator
!!
!! INPUTS
!!  mpi_enreg= information about MPI parallelization
!!  option_comm= (optional argument) 1 = k-points communicator (default)
!!                                   2 = world communocator
!!
!! OUTPUT
!!  me= index of the current MPI node
!!
!! SIDE EFFECTS
!!  None
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE

subroutine xme_init(mpi_enreg,me,option_comm)
 use defs_abitypes

#if defined HAVE_MPI && defined HAVE_MPI2
 use mpi
#endif

 implicit none

#if defined HAVE_MPI && defined HAVE_MPI1
 include 'mpif.h'
#endif

!Arguments-------------------------
 type(MPI_type),intent(in) :: mpi_enreg
 integer,intent(out) :: me
 integer,intent(in),optional :: option_comm

!Local variables-------------------

! *********************************************************************

#if defined HAVE_MPI
 if(mpi_enreg%paral_compil_respfn == 1.and.mpi_enreg%me_respfn/=-1) then
   me = mpi_enreg%me_respfn
 else if ((mpi_enreg%paral_compil_kpt==1).and.(mpi_enreg%paral_compil_fft==1).and.&
&   mpi_enreg%mode_para=='b') then
   me=mpi_enreg%me_kpt
   if (present(option_comm)) then
     if (option_comm==2) me=mpi_enreg%me
   end if
 else
   me=mpi_enreg%me
 end if
#else
 me = 0
#endif
end subroutine xme_init
!!***

!!****f* ABINIT/xproc_init
!! NAME
!!  xproc_init
!!
!! FUNCTION
!!  Defines the total number of procesoors.
!!
!! INPUTS
!!  mpi_enreg= information about MPI parallelization
!!
!! OUTPUT
!!  nproc_max= total number of processors
!!
!! SIDE EFFECTS
!!  None
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE

subroutine xproc_init(mpi_enreg,nproc_max)
 use defs_abitypes

#if defined HAVE_MPI && defined HAVE_MPI2
 use mpi
#endif

 implicit none

#if defined HAVE_MPI && defined HAVE_MPI1
 include 'mpif.h'
#endif

!Arguments-------------------------
 integer,intent(out) :: nproc_max
 type(MPI_type),intent(in) :: mpi_enreg

!Local variables-------------------

! *********************************************************************

#if defined HAVE_MPI
 if (mpi_enreg%paral_compil_respfn == 1) then
   nproc_max=mpi_enreg%nproc_respfn
 else
   nproc_max=mpi_enreg%nproc
 end if

#else
 nproc_max = 1
#endif
end subroutine xproc_init
!!***
