!{\src2tex{textfont=tt}}
!!****f* ABINIT/dtsetfree
!! NAME
!! dtsetfree
!!
!! FUNCTION
!! Free a dataset after use.
!!
!! COPYRIGHT
!! Copyright (C) 1998-2010 ABINIT group (DCA, XG, GMR, MF, GZ)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! SIDE EFFECTS
!!  dtset <type(dataset_type)>=free all associated pointers.
!!
!! PARENTS
!!  abinit,afterscfloop,cvxclda,driver,kxc_alda,outkss,wvl_memory,xc_kernel
!!
!! CHILDREN
!!
!! INPUTS
!!
!! OUTPUT
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine dtsetFree(dtset)

 use defs_basis
 use defs_abitypes

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_53_abiutil, except_this_one => dtsetFree
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 type(dataset_type),intent(inout) :: dtset

! *************************************************************************

 if (associated(dtset%acell_orig)) deallocate(dtset%acell_orig)
 if (associated(dtset%algalch))    deallocate(dtset%algalch)
 if (associated(dtset%atvshift))   deallocate(dtset%atvshift)
 if (associated(dtset%bdgw))       deallocate(dtset%bdgw)
 if (associated(dtset%corecs))     deallocate(dtset%corecs)
 if (associated(dtset%dynimage))   deallocate(dtset%dynimage)
 if (associated(dtset%iatfix))     deallocate(dtset%iatfix)
 if (associated(dtset%iatsph))     deallocate(dtset%iatsph)
 if (associated(dtset%istwfk))     deallocate(dtset%istwfk)
 if (associated(dtset%kberry))     deallocate(dtset%kberry)
 if (associated(dtset%lexexch))    deallocate(dtset%lexexch)
 if (associated(dtset%lpawu))      deallocate(dtset%lpawu)
 if (associated(dtset%nband))      deallocate(dtset%nband)
 if (associated(dtset%qmass))      deallocate(dtset%qmass)
 if (associated(dtset%so_psp))     deallocate(dtset%so_psp)
 if (associated(dtset%symafm))     deallocate(dtset%symafm)
 if (associated(dtset%symrel))     deallocate(dtset%symrel)
 if (associated(dtset%typat))      deallocate(dtset%typat)
 if (associated(dtset%amu))        deallocate(dtset%amu)
 if (associated(dtset%densty))     deallocate(dtset%densty)
 if (associated(dtset%dmatpawu))   deallocate(dtset%dmatpawu)
 if (associated(dtset%gw_qlwl))    deallocate(dtset%gw_qlwl)
 if (associated(dtset%jpawu))      deallocate(dtset%jpawu)
 if (associated(dtset%kpt))        deallocate(dtset%kpt)
 if (associated(dtset%kptgw))      deallocate(dtset%kptgw)
 if (associated(dtset%kptns))      deallocate(dtset%kptns)
 if (associated(dtset%mixalch))    deallocate(dtset%mixalch)
 if (associated(dtset%normpawu))   deallocate(dtset%normpawu)
 if (associated(dtset%occ_orig))   deallocate(dtset%occ_orig)
 if (associated(dtset%ptcharge))   deallocate(dtset%ptcharge)
 if (associated(dtset%quadmom))    deallocate(dtset%quadmom)
 if (associated(dtset%qptdm))      deallocate(dtset%qptdm)
 if (associated(dtset%ratsph))     deallocate(dtset%ratsph)
 if (associated(dtset%rprim_orig)) deallocate(dtset%rprim_orig)
 if (associated(dtset%rprimd_orig))deallocate(dtset%rprimd_orig)
 if (associated(dtset%shiftk))     deallocate(dtset%shiftk)
 if (associated(dtset%spinat))     deallocate(dtset%spinat)
 if (associated(dtset%tnons))      deallocate(dtset%tnons)
 if (associated(dtset%upawu))      deallocate(dtset%upawu)
 if (associated(dtset%vel_orig))   deallocate(dtset%vel_orig)
 if (associated(dtset%wtatcon))    deallocate(dtset%wtatcon)
 if (associated(dtset%wtk))        deallocate(dtset%wtk)
 if (associated(dtset%xred_orig))  deallocate(dtset%xred_orig)
 if (associated(dtset%ziontypat))  deallocate(dtset%ziontypat)
 if (associated(dtset%znucl))      deallocate(dtset%znucl)

 if (dtset%usewvl == 1) then
   call wvl_atoms_data_free(dtset)
 end if

end subroutine dtsetFree
!!***
