!!****m* ABINIT/interfaces_53_abiutil
!! NAME
!! interfaces_53_abiutil
!!
!! FUNCTION
!! This module contains the interfaces of the routines
!! in the directory src/53_abiutil
!!
!! COPYRIGHT
!! Copyright (C) 2010 ABINIT group
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!!
!! NOTES
!! THIS FILE IS GENERATED AUTOMATICALLY BY abilint.
!! To do that: config/scripts/abilint . .
!! 
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

module interfaces_53_abiutil

 implicit none

interface
 subroutine cprj_alloc(cprj,ncpgr,nlmn)
  use defs_datatypes
  implicit none
  integer,intent(in) :: ncpgr
  integer,intent(in) :: nlmn(:)
  type(cprj_type),intent(inout) :: cprj(:,:)
 end subroutine cprj_alloc
end interface

interface
 subroutine cprj_free(cprj)
  use defs_datatypes
  implicit none
  type(cprj_type),intent(inout) :: cprj(:,:)
 end subroutine cprj_free
end interface

interface
 subroutine cprj_nullify(cprj)
  use defs_datatypes
  implicit none
  type(cprj_type),intent(inout) :: cprj(:,:)
 end subroutine cprj_nullify
end interface

interface
 subroutine cprj_copy(cprj_in,cprj_out,&  
  &  icpgr) ! optional argument
  use defs_datatypes
  implicit none
  integer,intent(in),optional :: icpgr
  type(cprj_type),intent(in) :: cprj_in(:,:)
  type(cprj_type),intent(inout) :: cprj_out(:,:)
 end subroutine cprj_copy
end interface

interface
 subroutine cprj_axpby(alpha,beta,cprjx,cprjy)
  use defs_basis
  use defs_datatypes
  implicit none
  real(dp),intent(in) :: alpha
  real(dp),intent(in) :: beta
  type(cprj_type),intent(in) :: cprjx(:,:)
  type(cprj_type),intent(inout) :: cprjy(:,:)
 end subroutine cprj_axpby
end interface

interface
 subroutine cprj_zaxpby(alpha,beta,cprjx,cprjy)
  use defs_basis
  use defs_datatypes
  implicit none
  real(dp),intent(in) :: alpha(2)
  real(dp),intent(in) :: beta(2)
  type(cprj_type),intent(in) :: cprjx(:,:)
  type(cprj_type),intent(inout) :: cprjy(:,:)
 end subroutine cprj_zaxpby
end interface

interface
 subroutine cprj_lincom(alpha,cprj_in,cprj_out,nn)
  use defs_basis
  use defs_datatypes
  implicit none
  integer,intent(in) :: nn
  real(dp),intent(in) :: alpha(2,nn)
  type(cprj_type),intent(in) :: cprj_in(:,:)
  type(cprj_type),intent(inout) :: cprj_out(:,:)
 end subroutine cprj_lincom
end interface

interface
 subroutine cprj_diskinit_r(atind,dimcp,iorder,mkmem,natom,ncpgr,nlmn,nspinor,uncp)
  implicit none
  integer,intent(in) :: dimcp
  integer,intent(in) :: iorder
  integer,intent(in) :: mkmem
  integer,intent(in) :: natom
  integer,intent(in) :: ncpgr
  integer,intent(in) :: nspinor
  integer,intent(in) :: uncp
  integer,intent(in) :: atind(natom)
  integer,intent(in) :: nlmn(dimcp)
 end subroutine cprj_diskinit_r
end interface

interface
 subroutine cprj_diskinit_w(atind,dimcp,iorder,mkmem,natom,ncpgr,nlmn,nspinor,uncp)
  implicit none
  integer,intent(in) :: dimcp
  integer,intent(in) :: iorder
  integer,intent(in) :: mkmem
  integer,intent(in) :: natom
  integer,intent(in) :: ncpgr
  integer,intent(in) :: nspinor
  integer,intent(in) :: uncp
  integer,intent(in) :: atind(natom)
  integer,intent(in) :: nlmn(dimcp)
 end subroutine cprj_diskinit_w
end interface

interface
 subroutine cprj_diskskip(mkmem,ncpgr,nrec,uncp)
  implicit none
  integer,intent(in) :: mkmem
  integer,intent(in) :: ncpgr
  integer,intent(in) :: nrec
  integer,intent(in) :: uncp
 end subroutine cprj_diskskip
end interface

interface
 subroutine cprj_get(atind,cprj_k,cprj,dimcp,iband1,ibg,ikpt,iorder,isppol,mband,&  
  &  mkmem,mpi_enreg,natom,nband,nband_k,nspinor,nsppol,uncp,&  
  &  icpgr,ncpgr) ! optionals arguments
  use defs_abitypes
  use defs_datatypes
  implicit none
  integer,intent(in) :: dimcp
  integer,intent(in) :: iband1
  integer,intent(in) :: ibg
  integer,intent(in),optional :: icpgr
  integer,intent(in) :: ikpt
  integer,intent(in) :: iorder
  integer,intent(in) :: isppol
  integer,intent(in) :: mband
  integer,intent(in) :: mkmem
  integer,intent(in) :: natom
  integer,intent(in) :: nband
  integer,intent(in) :: nband_k
  integer,intent(in),optional :: ncpgr
  integer,intent(in) :: nspinor
  integer,intent(in) :: nsppol
  integer,intent(in) :: uncp
  type(mpi_type), intent(inout) :: mpi_enreg
  integer,intent(in) :: atind(natom)
  type(cprj_type),intent(in) :: cprj(dimcp,nspinor*mband*mkmem*nsppol)
  type(cprj_type),intent(inout) :: cprj_k(dimcp,nspinor*nband)
 end subroutine cprj_get
end interface

interface
 subroutine cprj_put(atind,cprj_k,cprj,dimcp,iband1,ibg,ikpt,iorder,isppol,mband,&  
  &  mkmem,mpi_enreg,natom,nband,nband_k,nlmn,nspinor,nsppol,spaceComm_band,uncp,&  
  &  to_be_gathered) ! Optional argument
  use defs_abitypes
  use defs_datatypes
  implicit none
  integer,intent(in) :: dimcp
  integer,intent(in) :: iband1
  integer,intent(in) :: ibg
  integer,intent(in) :: ikpt
  integer,intent(in) :: iorder
  integer,intent(in) :: isppol
  integer,intent(in) :: mband
  integer,intent(in) :: mkmem
  integer,intent(in) :: natom
  integer,intent(in) :: nband
  integer,intent(in) :: nband_k
  integer,intent(in) :: nspinor
  integer,intent(in) :: nsppol
  integer,intent(in) :: spaceComm_band
  integer,intent(in) :: uncp
  type(mpi_type), intent(inout) :: mpi_enreg
  logical,optional,intent(in) :: to_be_gathered
  integer :: atind(natom)
  type(cprj_type),intent(out) :: cprj(dimcp,nspinor*mband*mkmem*nsppol)
  type(cprj_type),intent(in) :: cprj_k(dimcp,nspinor*nband)
  integer :: nlmn(dimcp)
 end subroutine cprj_put
end interface

interface
 subroutine cprj_exch(natom,n2dim,nlmn,ncpgr,Cprj_send,Cprj_recv,sender,receiver,spaceComm,ierr)
  use defs_datatypes
  implicit none
  integer,intent(out) :: ierr
  integer,intent(in) :: n2dim
  integer,intent(in) :: natom
  integer,intent(in) :: ncpgr
  integer,intent(in) :: receiver
  integer,intent(in) :: sender
  integer,intent(in) :: spaceComm
  type(cprj_type),intent(inout) :: Cprj_recv(:,:)
  type(cprj_type),intent(in) :: Cprj_send(:,:)
  integer,intent(in) :: nlmn(natom)
 end subroutine cprj_exch
end interface

interface
 subroutine cprj_mpi_send(natom,n2dim,nlmn,ncpgr,cprj_out,receiver,spaceComm,ierr)
  use defs_datatypes
  implicit none
  integer,intent(out) :: ierr
  integer,intent(in) :: n2dim
  integer,intent(in) :: natom
  integer,intent(in) :: ncpgr
  integer,intent(in) :: receiver
  integer,intent(in) :: spaceComm
  type(cprj_type),intent(in) :: cprj_out(:,:)
  integer,intent(in) :: nlmn(natom)
 end subroutine cprj_mpi_send
end interface

interface
 subroutine cprj_mpi_recv(natom,n2dim,nlmn,ncpgr,cprj_in,sender,spaceComm,ierr)
  use defs_datatypes
  implicit none
  integer,intent(out) :: ierr
  integer,intent(in) :: n2dim
  integer,intent(in) :: natom
  integer,intent(in) :: ncpgr
  integer,intent(in) :: sender
  integer,intent(in) :: spaceComm
  type(cprj_type),intent(inout) :: cprj_in(:,:)
  integer,intent(in) :: nlmn(natom)
 end subroutine cprj_mpi_recv
end interface

interface
 subroutine cprj_mpi_allgather(cprj_loc,cprj_gat,natom,n2dim,nlmn,ncpgr,nproc,spaceComm,ierr)
  use defs_datatypes
  implicit none
  integer,intent(out) :: ierr
  integer,intent(in) :: n2dim
  integer,intent(in) :: natom
  integer,intent(in) :: ncpgr
  integer,intent(in) :: nproc
  integer,intent(in) :: spaceComm
  type(cprj_type),intent(out) :: cprj_gat(:,:)
  type(cprj_type),intent(in) :: cprj_loc(:,:)
  integer,intent(in) :: nlmn(natom)
 end subroutine cprj_mpi_allgather
end interface

interface
 subroutine cprj_bcast(natom,n2dim,nlmn,ncpgr,Cprj,master,spaceComm,ierr)
  use defs_datatypes
  implicit none
  integer,intent(out) :: ierr
  integer,intent(in) :: master
  integer,intent(in) :: n2dim
  integer,intent(in) :: natom
  integer,intent(in) :: ncpgr
  integer,intent(in) :: spaceComm
  type(cprj_type),intent(inout) :: Cprj(natom,n2dim)
  integer,intent(in) :: nlmn(natom)
 end subroutine cprj_bcast
end interface

interface
 subroutine cprj_transpose(cprjin,cprjout,cprj_bandpp,natom,nband,nspinor,spaceComm)
  use defs_datatypes
  implicit none
  integer :: cprj_bandpp
  integer :: natom
  integer :: nband
  integer :: nspinor
  integer :: spaceComm
  type(cprj_type),intent(in) :: cprjin(:,:)
  type(cprj_type),intent(out) :: cprjout(:,:)
 end subroutine cprj_transpose
end interface

interface
 subroutine cprj_transpose_all(cprjin,cprjout,dtfil,mband,mkmem,mpi_enreg,natom,nband,&  
  &  nkpt,nspinor,nsppol,paral_kgb,spaceComm)
  use defs_abitypes
  use defs_datatypes
  implicit none
  integer,intent(in) :: mband
  integer,intent(in) :: mkmem
  integer,intent(in) :: natom
  integer,intent(in) :: nkpt
  integer,intent(in) :: nspinor
  integer,intent(in) :: nsppol
  integer,intent(in) :: paral_kgb
  integer,intent(in) :: spaceComm
  type(datafiles_type),intent(in) :: dtfil
  type(mpi_type),intent(inout) :: mpi_enreg
  type(cprj_type),intent(in) :: cprjin(:,:)
  type(cprj_type),intent(out) :: cprjout(:,:)
  integer :: nband(nkpt*nsppol)
 end subroutine cprj_transpose_all
end interface

interface
 function paw_overlap(cprj1,cprj2,typat,pawtab) result(onsite)
  use defs_basis
  use defs_datatypes
  implicit none
  integer,intent(in) :: typat(:)
  type(cprj_type),intent(in) :: cprj1(:,:)
  type(cprj_type),intent(in) :: cprj2(:,:)
  real(dp) :: onsite(2)
  type(pawtab_type),intent(in) :: pawtab(:)
 end function paw_overlap
end interface

interface
 subroutine cprj_output(cprj)
  use defs_datatypes
  implicit none
  type(cprj_type),intent(in) :: cprj(:,:)
 end subroutine cprj_output
end interface

interface
 subroutine dtset_nullify(dtset)
  use defs_abitypes
  implicit none
  type(dataset_type),intent(inout) :: dtset
 end subroutine dtset_nullify
end interface

interface
 subroutine dtsetCopy(dtout, dtin)
  use defs_abitypes
  implicit none
  type(dataset_type),intent(in) :: dtin
  type(dataset_type),intent(out) :: dtout
 end subroutine dtsetCopy
end interface

interface
 subroutine  tells_sizes(chosen_size,name,index,default_size,actual_size)
  implicit none
  integer,intent(in) :: actual_size
  integer,intent(out) :: chosen_size
  integer,intent(in) :: default_size
  integer,intent(in) :: index
  character(len=12),intent(in) :: name
 end subroutine tells_sizes
end interface

interface
 subroutine dtsetFree(dtset)
  use defs_abitypes
  implicit none
  type(dataset_type),intent(inout) :: dtset
 end subroutine dtsetFree
end interface

interface
 subroutine find_getdtset(dtsets,getvalue,getname,idtset,iget,miximage,mxnimage,ndtset_alloc)
  use defs_basis
  use defs_abitypes
  implicit none
  integer, intent(in) :: getvalue
  integer, intent(in) :: idtset
  integer, intent(out) :: iget
  integer, intent(in) :: mxnimage
  integer, intent(in) :: ndtset_alloc
  character(len=*),intent(in) :: getname
  type(dataset_type),intent(in) :: dtsets(0:ndtset_alloc)
  real(dp), intent(out) :: miximage(mxnimage,mxnimage)
 end subroutine find_getdtset
end interface

interface
 subroutine mkfilename(filnam,filnam_out,get,idtset,&  
  &  ird,jdtset_,ndtset,stringfil,stringvar,will_read)
  use defs_basis
  implicit none
  integer,intent(in) :: get
  integer,intent(in) :: idtset
  integer,intent(in) :: ird
  integer,intent(in) :: ndtset
  integer,intent(out) :: will_read
  character(len=fnlen),intent(out) :: filnam_out
  character(len=*),intent(in) :: stringfil
  character(len=*),intent(in) :: stringvar
  character(len=fnlen),intent(in) :: filnam(5)
  integer,intent(in) :: jdtset_(0:ndtset)
 end subroutine mkfilename
end interface

interface
 subroutine orthonormalize(blockvectorx,blockvectorbx,blocksize,mpi_enreg,sqgram,vectsize)
  use defs_basis
  use defs_abitypes
  implicit none
  integer,intent(in) :: blocksize
  integer,intent(in) :: vectsize
  type(mpi_type) :: mpi_enreg
  real(dp) :: blockvectorbx(vectsize,blocksize)
  real(dp) :: blockvectorx(vectsize,blocksize)
  real(dp) :: sqgram(blocksize,blocksize)
 end subroutine orthonormalize
end interface

interface
 subroutine rhoij_alloc(cplex,nlmn,nspden,nspinor,nsppol,pawrhoij,typat,&  ! Mandatory arguments
  &  mpi_enreg,ngrhoij,nlmnmix,use_rhoij_,use_rhoijres) ! Optional arguments
  use defs_abitypes
  use defs_datatypes
  implicit none
  integer,intent(in) :: cplex
  integer,intent(in),optional :: ngrhoij
  integer,intent(in),optional :: nlmnmix
  integer,intent(in) :: nspden
  integer,intent(in) :: nspinor
  integer,intent(in) :: nsppol
  integer,intent(in),optional :: use_rhoij_
  integer,intent(in),optional :: use_rhoijres
  type(mpi_type),intent(inout),optional :: mpi_enreg
  integer,intent(in) :: nlmn(:)
  integer,intent(in) :: typat(:)
  type(pawrhoij_type),intent(inout) :: pawrhoij(:)
 end subroutine rhoij_alloc
end interface

interface
 subroutine rhoij_free(pawrhoij)
  use defs_datatypes
  implicit none
  type(pawrhoij_type),intent(inout) :: pawrhoij(:)
 end subroutine rhoij_free
end interface

interface
 subroutine rhoij_copy(pawrhoij_in,pawrhoij_out,&  
  &  keep_cplex,keep_nspden,mpi_enreg) ! optional arguments
  use defs_abitypes
  use defs_datatypes
  implicit none
  logical,intent(in),optional :: keep_cplex
  logical,intent(in),optional :: keep_nspden
  type(mpi_type),intent(inout),optional :: mpi_enreg
  type(pawrhoij_type),intent(in) :: pawrhoij_in(:)
  type(pawrhoij_type),intent(inout) :: pawrhoij_out(:)
 end subroutine rhoij_copy
end interface

interface
 subroutine rhoij_allgather(mpi_enreg,pawrhoij_in,pawrhoij_gathered)
  use defs_abitypes
  use defs_datatypes
  implicit none
  type(mpi_type),intent(inout) :: mpi_enreg
  type(pawrhoij_type),intent(inout) :: pawrhoij_gathered(:)
  type(pawrhoij_type),intent(in) :: pawrhoij_in(:)
 end subroutine rhoij_allgather
end interface

interface
 subroutine rhoij_io(pawrhoij,unitfi,nsppol_in,nspinor_in,nspden_in,nlmn_type,typat,headform,rdwr_mode,form,natinc)
  use defs_datatypes
  implicit none
  integer,intent(in) :: headform
  integer,optional,intent(in) :: natinc
  integer,intent(in) :: nspden_in
  integer,intent(in) :: nspinor_in
  integer,intent(in) :: nsppol_in
  integer,intent(in) :: unitfi
  character(len=*),optional,intent(in) :: form
  character(len=*),intent(in) :: rdwr_mode
  integer,intent(in) :: nlmn_type(:)
  integer,intent(in) :: typat(:)
  type(pawrhoij_type),intent(inout) :: pawrhoij(:)
 end subroutine rhoij_io
end interface

interface
 subroutine rhoij_unpack(rhoij)
  use defs_datatypes
  implicit none
  type(pawrhoij_type),intent(inout) :: rhoij(:)
 end subroutine rhoij_unpack
end interface

interface
 subroutine rhoij_init_unpacked(rhoij)
  use defs_datatypes
  implicit none
  type(pawrhoij_type),intent(inout) :: rhoij(:)
 end subroutine rhoij_init_unpacked
end interface

interface
 subroutine rhoij_destroy_unpacked(rhoij)
  use defs_datatypes
  implicit none
  type(pawrhoij_type),intent(inout) :: rhoij(:)
 end subroutine rhoij_destroy_unpacked
end interface

interface
 subroutine rhoij_mpi_sum(pawrhoij,comm1,comm2)
  use defs_datatypes
  implicit none
  integer,intent(in) :: comm1
  integer,optional,intent(in) :: comm2
  type(pawrhoij_type),intent(inout) :: pawrhoij(:)
 end subroutine rhoij_mpi_sum
end interface

interface
 subroutine wvl_atoms_data_set(acell, dtset)
  use defs_basis
  use defs_abitypes
  implicit none
  type(dataset_type), intent(inout) :: dtset
  real(dp), intent(in) :: acell(3)
 end subroutine wvl_atoms_data_set
end interface

interface
 subroutine wvl_atoms_data_set_psp(dtset, psps)
  use defs_abitypes
  use defs_datatypes
  implicit none
  type(dataset_type), intent(inout) :: dtset
  type(pseudopotential_type), intent(in) :: psps
 end subroutine wvl_atoms_data_set_psp
end interface

interface
 subroutine wvl_atoms_data_free(dtset)
  use defs_abitypes
  implicit none
  type(dataset_type), intent(inout) :: dtset
 end subroutine wvl_atoms_data_free
end interface

interface
 subroutine wvl_atoms_data_copy(dtto, dtfrom)
  use defs_abitypes
  implicit none
  type(dataset_type), intent(in) :: dtfrom
  type(dataset_type), intent(inout) :: dtto
 end subroutine wvl_atoms_data_copy
end interface

interface
 subroutine zorthonormalize(blockvectorx,blockvectorbx,blocksize,mpi_enreg,sqgram,vectsize)
  use defs_basis
  use defs_abitypes
  implicit none
  integer,intent(in) :: blocksize
  integer,intent(in) :: vectsize
  type(mpi_type) :: mpi_enreg
  complex(dpc) :: blockvectorbx(vectsize,blocksize)
  complex(dpc) :: blockvectorx(vectsize,blocksize)
  complex(dpc) :: sqgram(blocksize,blocksize)
 end subroutine zorthonormalize
end interface

end module interfaces_53_abiutil
!!***
