!{\src2tex{textfont=tt}}
!!****f* ABINIT/bfactor
!! NAME
!! bfactor
!!
!! FUNCTION
!! Calculate the nesting factor
!!
!! COPYRIGHT
!!  Copyright (C) 2006-2010 ABINIT group (MG)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!!  nkpt = number of k-points
!!  kpt(3,nkpt) = k-point grid
!!  nqpt = number of qpoints
!!  qpt(3,nqpt) = q-point grid (must be a subgrid of the k grid),
!!                the nesting factor will be calculated for each q point in this array
!!  weight(nband,nkpt) =  integration weights for each k-point and band (NOT NORMALISED!!!)
!!  nband = number of bands
!!
!! OUTPUT
!!  nestfactor(nqpt) = array containing the nesting factor values
!!
!! SIDE EFFECTS
!!
!! NOTES
!! Inspired to nmsq_gam_sumfs and mkqptequiv
!!  TODO : better use of symmetries to reduce the computational effort
!!
!! PARENTS
!!      mknesting,outelph
!!
!! CHILDREN
!!      destroy_kptrank,get_rank_1kpt,leave_new,mkkptrank,wrtout
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine bfactor(nkpt,kpt,nqpt,qpt,weight,nband,nestfactor)

 use defs_basis
 use m_kptrank

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
 use interfaces_16_hideleave
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: nband,nkpt,nqpt
!arrays
 real(dp),intent(in) :: kpt(3,nkpt),qpt(3,nqpt),weight(nband,nkpt)
 real(dp),intent(inout) :: nestfactor(nqpt)

!Local variables-------------------------------
!scalars
 integer :: ib1,ib2,ikplusq,ikpt,iqpt,symrank_kpt
 real(dp) :: factor,w1,w2
 character(len=500) :: message
 type(kptrank_type) :: kptrank_t
!arrays
 real(dp) :: kptpq(3)

! *************************************************************************

 nestfactor(:)=zero

 write (message,'(a)')' bfactor : making rank_kpt and invrank_kpt '
 call wrtout(std_out,message,'COLL')

 call mkkptrank (kpt,nkpt,kptrank_t)

 do iqpt=1,nqpt
   do ikpt=1,nkpt

     kptpq(:) = kpt(:,ikpt) + qpt(:,iqpt)
     call get_rank_1kpt (kptpq,symrank_kpt,kptrank_t)

     ikplusq = kptrank_t%invrank(symrank_kpt)
     if (ikplusq == -1) then
       write (message,'(4a)')ch10,' bfactor : ERROR- :',ch10,' it looks like no kpoint equiv to k+q !!!'
       call wrtout(std_out,message,'COLL')
       call leave_new('COLL')
     end if

     do ib1=1,nband
       w1 = weight(ib1,ikpt) !weight for distance from the Fermi surface
       if (w1 < tol6 ) cycle
       do ib2=1,nband
         w2 = weight(ib2,ikplusq) !weight for distance from the Fermi surface
         if (w1 < tol6 ) cycle
         nestfactor(iqpt) = nestfactor(iqpt)+w1*w2
       end do !ib2
     end do !ib1

   end do !ikpt
 end do !iqpt

 call destroy_kptrank (kptrank_t)

!need prefactor of 1/nkpt for each integration over 1 kpoint index.
!and (1/nkpt)**2 for normalisation of double delta over FS
 factor=1./nkpt ; factor=factor**3
 nestfactor(:)=factor*nestfactor(:)

end subroutine bfactor
!!***
