!{\src2tex{textfont=tt}}
!!****f* ABINIT/mknesting
!! NAME
!! mknesting
!!
!! FUNCTION
!!  Calculate the nesting factor over the dense k-grid,
!!  interpolate the values along a given q path
!!  and write the data on file in the X-Y format or
!!  in the XCrysden format (XSF)
!!
!! COPYRIGHT
!!  Copyright (C) 2006-2010 ABINIT group (MG)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!!  nkpt = number of k points
!!  kpt(3,nkpt) = k points
!!  nkx, nky, nkz = number of k-point along each direction
!!  nband = number of bands to be considered in the calculation
!!  weight(nband,nkpt) =  integration weights for each k-point and band
!!  nqpath = number of points requested along the trajectory
!!  qpath_vertices = vertices of the reciprocal space trajectory
!!  base_name = prefix of the output file
!!  gprimd(3,3) dimensional reciprocal lattice vectors
!!  gmet = metric in reciprocal space
!!  prtnest = flags governing the format of the output file
!! OUTPUT
!!  only write to file
!!
!! SIDE EFFECTS
!!
!! NOTES
!!
!! PARENTS
!!      elphon
!!
!! CHILDREN
!!      bfactor,interpol3d,leave_new,printxsf,wrap2_zero_one,wrtout
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine mknesting(nkpt,kpt,kptrlatt,nband,weight,nqpath,&
& qpath_vertices,nqptfull,qptfull,base_name,gprimd,gmet,prtnest,qptrlatt)

 use defs_basis

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
 use interfaces_16_hideleave
 use interfaces_32_util
 use interfaces_56_recipspace, except_this_one => mknesting
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: nband,nkpt,nqpath,prtnest
 integer, intent(in) :: nqptfull
 character(len=fnlen),intent(in) :: base_name
!arrays
 integer,intent(in) :: kptrlatt(3,3)
 real(dp),intent(in) :: gprimd(3,3),kpt(3,nkpt)
 real(dp),intent(in) :: qptfull(3,nqptfull)
 real(dp),intent(in) :: gmet(3,3)
 real(dp),intent(in) :: qpath_vertices(3,nqpath)
 real(dp),intent(in) :: weight(nband,nkpt)
 integer,intent(in)  :: qptrlatt(3,3)

!Local variables-------------------------------
!scalars
 integer :: ikpt,jkpt,kindex,maxrank
 real(dp) :: res
 character(len=500) :: message
!arrays
 integer,allocatable :: kptrank(:),ktable(:)
 character(len=fnlen) :: tmpname
 real(dp) :: tmpkpt(3)
 real(dp),allocatable :: convkpt(:,:)
 real(dp),allocatable :: nestfactor(:),nestordered(:)

! *************************************************************************

 if (  kptrlatt(1,2) /= 0 .or. kptrlatt(1,3) /= 0 .or. kptrlatt(2,1) /= 0       &
& .or. kptrlatt(2,3) /= 0 .or. kptrlatt(3,1) /= 0 .or. kptrlatt(3,2) /= 0 ) then
   write (message,'(7a)')ch10,' mknesting : WARNING-',ch10,                         &
&   ' kptrlatt should be diagonal in order to calculate the nesting factor,',ch10,&
&   ' skipping the nesting factor calculation ',ch10
   call wrtout(std_out,message,'COLL')
   call wrtout(ab_out,message,'COLL')
   return
 end if

 if (prtnest /= 1 .and. prtnest /= 2) then
   write(message,'(4a)')ch10,' mknesting : BUG-',ch10,&
&   ' prtnest should be 1 or 2'
   call wrtout(std_out,message,'COLL')
   call leave_new('COLL')
 end if

 write(message,'(a,9i5)')' mknesting : kptrlatt = ',kptrlatt
 call wrtout(std_out,message,'COLL')

 allocate (nestfactor(nkpt))
 nestfactor(:)=zero

!NOTE: input weights are not normalised, the normalisation factor in introduced in bfactor
 call bfactor(nkpt,kpt,nkpt,kpt,weight,nband,nestfactor)

!================================================================================================
!use linear interpolation to plot the bfactor along the given q-path
!1) order the kpoints of the grid putting them in increasing x, then y, then z (FORTRAN convention)
!2) make table from input kpts to ordered kpts
!3) perform interpolation
!================================================================================================

 allocate (convkpt(3,nkpt))
 convkpt(:,:)=zero

!rank is used to order kpoints
 allocate (kptrank(nkpt))
 kptrank(:) = 0

 do ikpt=1,nkpt
   call wrap2_zero_one(kpt(1,ikpt),tmpkpt(1),res)
   call wrap2_zero_one(kpt(2,ikpt),tmpkpt(2),res)
   call wrap2_zero_one(kpt(3,ikpt),tmpkpt(3),res)
   convkpt(:,ikpt)=tmpkpt(:)
   kptrank(ikpt) = 100000000.0_dp*(tmpkpt(3)+one) + &
&   100000.0_dp*(tmpkpt(2)+one) + &
&   100.0_dp*(tmpkpt(1)+one)
 end do
 deallocate (convkpt)

 allocate (ktable(nkpt))
 ktable(:)=0

 kindex=nkpt
 do ikpt=1,nkpt
!  FIXME: this whole operation could be replaced by a sort(kptrank)
!  and then using the sorted indirect indexing ignoring the -1 rank values
   maxrank=maxval(kptrank)
   findmax: do jkpt=1,nkpt
     if(kptrank(jkpt)==maxrank) then
       kptrank(jkpt)=-kptrank(jkpt)
       ktable(jkpt)=kindex
       kindex=kindex-1
       exit findmax
     end if
   end do findmax
 end do !ikpt
 deallocate (kptrank)

!fill the datagrid for the nesting factor using the Fortran convention and the conventional unit cell
!NOTE: the Fortran convention is a must if we want to plot the data
!in the BXSF format, useful for the linear interpolation since we use interpol3d.F90

 allocate (nestordered(nkpt))
 nestordered(:)=zero
 do jkpt=1,nkpt
   ikpt = ktable(jkpt)
   nestordered(ikpt)=nestfactor(jkpt)
 end do
 deallocate (nestfactor)
 deallocate (ktable)

 call outnesting(base_name,gmet,gprimd,kptrlatt,nestordered,nkpt,nqpath,prtnest,qpath_vertices)

 deallocate (nestordered)

!now do the same, but for the nesting factor over the phonon qpoints only

 allocate (nestfactor(nqptfull))
 nestfactor(:)=zero
 call bfactor(nkpt,kpt,nqptfull,qptfull,weight,nband,nestfactor)

 allocate (convkpt(3,nqptfull))
 convkpt(:,:)=zero

!rank is used to order kpoints
 allocate (kptrank(nqptfull))
 kptrank(:) = 0

 do ikpt=1,nqptfull
   call wrap2_zero_one(qptfull(1,ikpt),tmpkpt(1),res)
   call wrap2_zero_one(qptfull(2,ikpt),tmpkpt(2),res)
   call wrap2_zero_one(qptfull(3,ikpt),tmpkpt(3),res)
   convkpt(:,ikpt)=tmpkpt(:)
   kptrank(ikpt) = 100000000.0_dp*(tmpkpt(3)+one) + &
&   100000.0_dp*(tmpkpt(2)+one) + &
&   100.0_dp*(tmpkpt(1)+one)
 end do
 deallocate (convkpt)

 allocate (ktable(nqptfull))
 ktable(:)=0

 kindex=nqptfull
 do ikpt=1,nqptfull
!  FIXME: this whole operation could be replaced by a sort(kptrank)
!  and then using the sorted indirect indexing ignoring the -1 rank values
   maxrank=maxval(kptrank)
   findmax2: do jkpt=1,nqptfull
     if(kptrank(jkpt)==maxrank) then
       kptrank(jkpt)=-kptrank(jkpt)
       ktable(jkpt)=kindex
       kindex=kindex-1
       exit findmax2
     end if
   end do findmax2
 end do !ikpt
 deallocate (kptrank)

!fill the datagrid for the nesting factor using the Fortran convention and the conventional unit cell
!NOTE: the Fortran convention is a must if we want to plot the data
!in the BXSF format, useful for the linear interpolation since we use interpol3d.F90

 allocate (nestordered(nqptfull))
 nestordered(:)=zero
 do jkpt=1,nqptfull
   ikpt = ktable(jkpt)
   nestordered(ikpt)=nestfactor(jkpt)
 end do
 deallocate (nestfactor)
 deallocate (ktable)

 tmpname = trim(base_name)//"kplusq"
 call outnesting(tmpname,gmet,gprimd,qptrlatt,nestordered,nqptfull,nqpath,prtnest,qpath_vertices)

 deallocate (nestordered)

end subroutine mknesting
!!***

!{\src2tex{textfont=tt}}
!!****f* ABINIT/outnesting
!! NAME
!! outnesting
!!
!! FUNCTION
!!  Write ou the nesting factors calculated in mknesting
!!  Data on file in the X-Y format (prtnest 1) or
!!  in the XCrysden format (XSF)   (prtnest 2)
!!
!! COPYRIGHT
!!  Copyright (C) 2006-2010 ABINIT group (MG)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!!  base_name = prefix of the output file
!!  gmet = metric in reciprocal space
!!  gprimd(3,3) dimensional reciprocal lattice vectors
!!  kptrlatt(3,3) basis vectors for k-grid
!!  nestordered = nesting function on full grid, points ordered in x, then y, then z
!!  nkpt = number of k points
!!  nqpath = number of points requested along the trajectory
!!  prtnest = flags governing the format of the output file
!!  qpath_vertices = vertices of the reciprocal space trajectory
!!
!! OUTPUT
!!  only write to file
!!
!! SIDE EFFECTS
!!
!! NOTES
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE


subroutine outnesting(base_name,gmet,gprimd,kptrlatt,nestordered,nkpt,nqpath,prtnest,qpath_vertices)

 use defs_basis
 use m_io_tools
 use m_bz_mesh

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
 use interfaces_16_hideleave
 use interfaces_32_util
!End of the abilint section

 implicit none

!Arguments ------------------------------------
 integer,intent(in) :: nqpath,prtnest,nkpt
 character(len=fnlen),intent(in) :: base_name
!arrays
 integer,intent(in) :: kptrlatt(3,3)
 real(dp),intent(in) :: gprimd(3,3)
 real(dp),intent(in) :: gmet(3,3)
 real(dp),intent(in) :: qpath_vertices(3,nqpath)
 real(dp),intent(in) :: nestordered(nkpt)


!local
 integer :: unit_nest, nkx,nky,nkz
 integer :: iost, indx, ii, ipoint
 integer :: npt_tot
 integer :: realrecip

 character(len=fnlen) :: fname
 character(len=500) :: message
 integer :: ndiv(nqpath-1)
 real(dp), pointer :: finepath(:,:)
 real(dp) :: tmpkpt(3)
 real(dp) :: origin(3),qpt(3), res, kval
 
! dummy variables for call to printxsf
 integer :: natom, ntypat, typat(1)
 real(dp) :: xcart (3,1), znucl(1)

!===================================================================
!Definition of the q path along which ph linwid will be interpolated
!===================================================================
 nullify(finepath)
 call make_path(nqpath,qpath_vertices,gmet,'G',20,ndiv,npt_tot,finepath)

 nkx=kptrlatt(1,1)
 nky=kptrlatt(2,2)
 nkz=kptrlatt(3,3)

 if (nkpt /= nkx*nky*nkz) then
   write(message,'(5a,9I6)')ch10,' outnesting : ERROR-',ch10,&
&   ' Wrong input value for kptrlatt',ch10,&
&   kptrlatt
   call wrtout(std_out,message,'COLL')
   call leave_new('COLL')
 end if

!open output file and write header
 unit_nest=get_unit()
 fname=trim(base_name)
 open (unit=unit_nest,file=fname,status='unknown',iostat=iost)
 if (iost /= 0) then
   write (message,'(2a)')' outnesting : ERROR- opening file ',trim(fname)
   call wrtout(std_out,message,'COLL')
   call leave_new('COLL')
 end if

 write (unit_nest,'(a)')'#'
 write (unit_nest,'(a)')'# ABINIT package : Nesting factor file'
 write (unit_nest,'(a)')'#'
 write (unit_nest,'(a,i10,a)')'# Nesting factor calculated on ',npt_tot,' Q-points'
 write (unit_nest,'(a)')'# Description of the Q-path :'
 write (unit_nest,'(a,i10)')'# Number of line segments = ',nqpath-1
 write (unit_nest,'(a)')'# Vertices of the Q-path and corresponding index = '
 indx=1
 do ii=1,nqpath
   write (unit_nest,'(a,3(E16.6,1x),i8)')'#  ',qpath_vertices(:,ii),indx
   if(ii<nqpath) indx=indx+ndiv(ii)
 end do
 write (unit_nest,'(a)')'#'

!Get qpoint along the q-path from finepath and interpolate the nesting factor
 indx=1

 do ipoint=1, npt_tot
   qpt(:) = finepath(:,ipoint)
   call wrap2_zero_one(qpt(1),tmpkpt(1),res)
   call wrap2_zero_one(qpt(2),tmpkpt(2),res)
   call wrap2_zero_one(qpt(3),tmpkpt(3),res)

   call interpol3d(tmpkpt,nkx,nky,nkz,kval,nestordered)

   write(unit_nest,'(i5,18e16.5)')indx,kval
   indx = indx+1
 end do !end ipoint do
 close (unit_nest)
 deallocate (finepath)

 if (prtnest==2) then !write also the nest factor in the XSF format
   fname=trim(base_name) // '_NEST_XSF'
   open (unit=unit_nest,file=fname,status='unknown',iostat=iost)
   if (iost /= 0) then
     write (message,'(2a)')' outnesting : ERROR- opening file ',trim(fname)
     call wrtout(std_out,message,'COLL')
     call leave_new('COLL')
   end if

   origin(:)=zero
   realrecip=1 !reciprocal space
   natom = 1
   ntypat = 1
   typat = (/1/)
   xcart = reshape ((/zero, zero, zero/), (/3,1/)) 
   znucl = (/one/)
   call printxsf(nkx,nky,nkz,nestordered,gprimd,origin,natom, ntypat, typat, xcart, znucl, unit_nest,realrecip)

   close (unit_nest)
 end if

end subroutine outnesting
!!***
