!{\src2tex{textfont=tt}}
!!****f* ABINIT/xc_kernel
!! NAME
!! xc_kernel
!!
!! FUNCTION
!! Calculate exchange-correlation kernel in reciprocal space
!!
!! COPYRIGHT
!! Copyright (C) 1999-2010 ABINIT group (Rhaltaf,XG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!! Dtset <type(dataset_type)>=all input variables in this dataset
!! ixc = choice for the exchange-correlation potential.
!! MPI_enreg = informations about MPI parallelization.
!! ngfft(18)=contain all needed information about 3D FFT,
!!  see ~abinit/doc/input_variables/vargs.htm#ngfft
!! nfft = total number of points on the FFT grid.
!! nsppol=1 for unpolarized, 2 for spin-polarized
!! rhor(nfft,nsppol) = the charge density on the FFT grid.
!!  (total in first half and spin-up in second half if nsppol=2)
!! rprimd(3,3) = dimensional real space primitive translations (bohr).
!! npw: the size of kernel matrix
!! dim_kxcg=dimension of the kernel.
!!
!! OUTPUT
!!  kxcg(nfft,dim_kxcg) = the exchange-correlation potential on the FFT grid.
!!  warning: the kernel is not divided by unit cell volume
!!
!! NOTES
!!  No xc quadrature
!!  No nl core correction
!!
!! PARENTS
!!      eps1_tc
!!
!! CHILDREN
!!      dtsetcopy,dtsetfree,fourdp,mkvxc3,rhohxc,wrtout
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"

subroutine xc_kernel(Dtset,ixc,MPI_enreg,ngfft,nfft,nsppol,rhor,rprimd,npw,dim_kxcg,kxcg,gvec)

 use defs_basis
 use defs_abitypes
 use m_errors

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
 use interfaces_53_abiutil
 use interfaces_53_ffts
 use interfaces_56_xc, except_this_one => xc_kernel
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: ixc,npw,nfft,nsppol,dim_kxcg
 type(dataset_type),intent(in) :: Dtset
 type(MPI_type),intent(inout) :: MPI_enreg
!arrays
 integer,intent(in) :: gvec(3,npw),ngfft(18)
 real(dp),intent(in) :: rhor(nfft,nsppol),rprimd(3,3)
 complex(gwpc),intent(out) :: kxcg(nfft,dim_kxcg)

!Local variables ------------------------------
!scalars
 integer :: cplex,i1,i2,i3,ig,igp,iq,ir,n3xccc,ngfft1,ngfft2,izero
 integer :: ngfft3,nkxc,nspden,option,ikxc
 integer :: nk3xc
 real(dp) :: enxc,expo,gpqx,gpqy,gpqz,gsqcut
 real(dp) :: vxcavg
 character(len=500) :: msg
 type(dataset_type) :: DtGW
!arrays
 real(dp) :: qphon(3),strsxc(6)
 real(dp),allocatable :: dum(:),kxcpw_g(:,:),kxcr(:,:),phas(:,:,:)
 real(dp),allocatable :: rhog(:,:),vhartr(:),kxcpw_r(:,:),vxclda(:,:)
 real(dp),allocatable :: xccc3d(:),xx(:,:)
 real(dp),allocatable :: my_kxcg(:,:)

!************************************************************************

 ABI_CHECK(nsppol==1,'nsppol/=1 not coded')
 ABI_CHECK(Dtset%nspden==1,'nsppol/=1 not coded')
 ABI_CHECK(nfft==PRODUCT(ngfft(1:3)),"mismatch in nfftot")

 nspden=1

 write(msg,'(a,i3)') ' xc_kernel: calculating exchange-correlation kernel using ixc = ',ixc
 call wrtout(std_out,msg,'COLL')

 call dtsetCopy(DtGW,Dtset)
 DtGW%intxc = 0
 DtGW%ixc   = ixc

!Redefine xclevel.
 DtGW%xclevel=0
 if( ( 1<=DtGW%ixc .and. DtGW%ixc<=10).or.(30<=DtGW%ixc .and. DtGW%ixc<=39) )DtGW%xclevel=1 ! LDA
 if( (11<=DtGW%ixc .and. DtGW%ixc<=19).or.(23<=DtGW%ixc .and. DtGW%ixc<=29) )DtGW%xclevel=2 ! GGA
 if( 20<=DtGW%ixc .and. DtGW%ixc<=22 )DtGW%xclevel=3 ! ixc for TDDFT kernel tests

 if (ALL(DtGW%xclevel/=(/1,2/))) then
   write(msg,'(a,i0)')"Unsupported xclevel = ",DtGW%xclevel
   MSG_ERROR(msg)
 end if
 
 ngfft1=ngfft(1)
 ngfft2=ngfft(2)
 ngfft3=ngfft(3)

 if (ixc>=1.and.ixc<11) then ! LDA case
!  nkxc=3
!  nkxc=1
   nkxc=2*min(DtGW%nspden,2)-1
 else ! GGA
   nkxc=23
   ABI_CHECK(dtset%xclevel==2,"Functional should be GGA")
   MSG_ERROR("GGA functional not tested")
 end if
 
 allocate(kxcr(nfft,nkxc))

!gsqcut and rhog are zeroed because they are not used by rhohxc if 1<=ixc<=16 and option=0
 gsqcut=zero

 allocate(rhog(2,nfft),vhartr(nfft))
 rhog(:,:)=zero
!MG FIXME this is the 3D core electron density for XC core correction (bohr^-3)
!should implement the non linear core correction 
 n3xccc=0       
 allocate(xccc3d(n3xccc),vxclda(nfft,nspden))

 option=2 ! 2 for Hxc and kxcr (no paramagnetic part if nspden=1)
 qphon(:)=0.0

!to be adjusted for the call to rhohxc
 nk3xc=1

!Compute the kernel.
 izero=0

 call rhohxc(DtGW,enxc,gsqcut,izero,kxcr,MPI_enreg,nfft,ngfft,&
& dum,0,dum,0,nkxc,nk3xc,nspden,n3xccc,option,rhog,rhor,rprimd,&
& strsxc,1,vhartr,vxclda,vxcavg,xccc3d)

 deallocate(xccc3d,vxclda)

 allocate(my_kxcg(2,nfft))

 do ikxc=1,nkxc
   call fourdp(1,my_kxcg,kxcr(:,ikxc),-1,MPI_enreg,nfft,ngfft,dtset%paral_kgb,0)
   kxcg(:,ikxc)=CMPLX(my_kxcg(1,:),my_kxcg(2,:))
 end do

!write(*,*)"kxcr(r=0)",kxcr(1,1)
!write(*,*)"my_kxg(G=0)",my_kxcg(:,1)
!write(*,*)"SUM kxcr/nfft ",SUM(kxcr(:,1))/nfft
!write(*,*)"SUM my_kxg ",SUM(kxcg(:,1))

 deallocate(my_kxcg)

!MG this part is never executed, but one should use mkvxc3 for the GGA kernel.
 if (DtGW%xclevel==2) then
   MSG_ERROR("check GGA implementation")
   cplex=2
   allocate(phas(cplex*nfft,npw,nspden),kxcpw_r(cplex*nfft,nspden),xx(3,nfft),kxcpw_g(2,nfft))
   
   kxcg = czero

!  find the coordinates for all r in the FFT grid
   ir=0
   do i3=1,ngfft3
     do i2=1,ngfft2
       do i1=1,ngfft1
         ir=ir+1
         xx(1,ir)=dble((i1-1))/ngfft1
         xx(2,ir)=dble((i2-1))/ngfft2
         xx(3,ir)=dble((i3-1))/ngfft3
       end do
     end do
   end do

   do iq=1,1

!    Calculate at once exp(i(G+q).r), for all possible q,G,r
     do ig=1,npw
       gpqx=dble(gvec(1,ig))
       gpqy=dble(gvec(2,ig))
       gpqz=dble(gvec(3,ig))
       do ir=1,nfft
         expo=gpqx*xx(1,ir)+gpqy*xx(2,ir)+gpqz*xx(3,ir)              
         phas(2*ir-1,ig,1)= cos(two_pi*expo)
         phas(2*ir,ig,1) =  sin(two_pi*expo)
       end do
     end do

!    Calculate $K(G,G'',q)=\frac{1}{nfft}\sum_{r} exp(-i(q+G_{2}).r_{2} kxcr(r_{1}r_{2}) exp(i(q+G_{1}).r_{1} $

     do igp=1,npw

       kxcpw_r(:,:)=zero

       call mkvxc3(cplex,kxcr,MPI_enreg,nfft,ngfft,nkxc,nspden,n3xccc,option,&
&       DtGW%paral_kgb,qphon(:),phas(:,igp,:),rprimd,kxcpw_r,xccc3d)

!      MPI_enreg%me_fft=0
!      MPI_enreg%nproc_fft=1

!      FFT the first index to --> to G space
       call fourdp(cplex,kxcpw_g(:,:),kxcpw_r(:,1),-1,MPI_enreg,nfft,ngfft,DtGW%paral_kgb,0)

!      kxcg(:,igp,iq)=CMPLX(kxcpw_g(1,igfft(:)),kxcpw_g(2,igfft(:)))
!      kxcg(:,igp)=CMPLX(kxcpw_g(1,igfft(:)),kxcpw_g(2,igfft(:)))

     end do ! igp
   end do ! iq

   deallocate(phas,kxcpw_r,xx,kxcpw_g)
 end if !xclevel==2

 call dtsetFree(DtGW)
 deallocate(kxcr) 

end subroutine xc_kernel
!!***
