!{\src2tex{textfont=tt}}
!!****m* ABINIT/m_abi_etsf
!! NAME
!! m_abi_etsf
!!
!! FUNCTION
!!
!! COPYRIGHT
!! Copyright (C) 2006-2010 ABINIT group (DCA,YP,MJV,MG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!!
!! NOTES
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"

module m_abi_etsf

 use defs_basis
 use defs_datatypes
 use defs_abitypes
 use defs_wvltypes
 use m_errors
#if defined HAVE_ETSF_IO
 use etsf_io
#endif

 implicit none

 private

#if defined HAVE_ETSF_IO
 public :: abi_etsf_dims_init   ! TODO should be moved to m_errors
 public :: abietsf_msg_hndl

CONTAINS  !===========================================================
!!***

!!****f* m_abi_etsf/abi_etsf_dims_init
!! NAME
!! abi_etsf_dims_init
!!
!! FUNCTION
!!  Initialize the structure defining ETSF dimensions.
!!  starting from values stored in the dataset_type, the pseudopotential_type.
!!  and the wave function handler for the BIGDFT part.
!!
!! INPUTS
!!  dtset<type(dataset_type)>=all input variables for this dataset
!!  psps<type(pseudopotential_type)>=variables related to pseudopotentials
!!  wfs<wvl_wf_type>=Object to handle wave functions for the BIGDFT part
!!    Presently not used, likely will be needed when ETSF-IO will be generalized to deal with PAW.
!!  itype = an integer to define what to put in the output file. This can
!!          be one of the following values (maybe a sum latter):
!!          1 for a density file,
!!          2 for a wavefunction file,
!!          4 for a KSS file,
!!          8 for the exchange potential,
!!         16 for the correlation potential.
!!
!! OUTPUT
!!  dims=structure with ETSF dimensions.
!!
!! PARENTS
!!      pawmkaewf
!!
!! CHILDREN
!!      etsf_io_low_error_to_str,msg_hndl
!!
!! SOURCE

subroutine abi_etsf_dims_init(dims, dtset, itype, psps, wfs)

 use defs_basis

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: itype
 type(dataset_type),intent(in) :: dtset
 type(pseudopotential_type),intent(in) :: psps
 type(wvl_wf_type),intent(in) :: wfs
 type(etsf_dims),intent(inout) :: dims

! *************************************************************************

!Set-up the dimensions
!=====================
 dims%max_number_of_angular_momenta  = psps%mpsang
!In the case of BigDFT, the number of coefficients are the number of wavelets.
 if (dtset%usewvl == 0) then
  dims%max_number_of_coefficients      = dtset%mpw
  dims%max_number_of_basis_grid_points = etsf_no_dimension
#if defined HAVE_BIGDFT
 else
  dims%max_number_of_coefficients      = wfs%keys%nvctr_c + 7 * wfs%keys%nvctr_f
  dims%max_number_of_basis_grid_points = wfs%keys%nvctr_c
#endif
 end if
 dims%max_number_of_projectors       = 1
 dims%max_number_of_states           = dtset%mband
 dims%number_of_atoms                = dtset%natom
 dims%number_of_atom_species         = dtset%ntypat
 dims%number_of_components           = dtset%nspden
!In the case of BigDFT, the grid size is not defined by ngfft.
 if (dtset%usewvl == 1) then
  dims%number_of_grid_points_vector1  = dtset%wvl%n(1) * 2
  dims%number_of_grid_points_vector2  = dtset%wvl%n(2) * 2
  dims%number_of_grid_points_vector3  = dtset%wvl%n(3) * 2
 else
  dims%number_of_grid_points_vector1  = dtset%ngfft(1)
  dims%number_of_grid_points_vector2  = dtset%ngfft(2)
  dims%number_of_grid_points_vector3  = dtset%ngfft(3)
 end if
 dims%number_of_kpoints              = dtset%nkpt
 dims%number_of_spinor_components    = dtset%nspinor
 dims%number_of_spins                = dtset%nsppol
 dims%number_of_symmetry_operations  = dtset%nsym
!The density real_or_complex.
 if (iand(itype, 1) /= 0) then
  dims%real_or_complex_density        = 1
 else
  dims%real_or_complex_density        = etsf_no_dimension
 end if
!The coefficient of wavefunctions real_or_complex.
 if (iand(itype, 2) /= 0 .or. iand(itype, 4) /= 0) then
  if (dtset%usewvl == 0) then
   dims%real_or_complex_coefficients= 2 ! used in plane waves
  else
   dims%real_or_complex_coefficients= 1 ! used in wavelets
  end if
 else
  dims%real_or_complex_coefficients   = etsf_no_dimension
 end if
!The gw corrections real_or_complex.
!Todo: Currently not exported.
!if (.false. .and. iand(itype, 4) /= 0) then
 if (iand(itype, 4) /= 0) then
  dims%real_or_complex_gw_corrections = 2 ! used in plane waves
! dims%real_or_complex_gw_corrections = 1 ! used in plane waves
 else
  dims%real_or_complex_gw_corrections = etsf_no_dimension
 end if
!The potential real_or_complex.
 if (iand(itype, 8) /= 0 .or. iand(itype, 16) /= 0) then
  dims%real_or_complex_potential      = 1
 else
  dims%real_or_complex_potential      = etsf_no_dimension
 end if
 dims%real_or_complex_wavefunctions  = etsf_no_dimension

end subroutine abi_etsf_dims_init
!!***

!----------------------------------------------------------------------

!!****f* m_abi_etsf/abietsf_msg_hndl
!! NAME
!!  abietsf_msg_hndl
!!
!! FUNCTION
!!  Wrapper to interface the abinint error handlers with the error handling routines used in etsf-io.
!!  It is usually interfaced via the macro ETSF_* defined in abi_common.h
!!
!! INPUT 
!!  lstat=Logical flag returned by etsf-io routines.
!!  Error_data<ETSF_io_low_error>=Structure storing the error returned by etsf-io calls.
!!  [line]=line number of the file where the problem occurred
!!  [file]=name of the f90 file containing the caller
!!  mode_paral=Either "COLL" or "PERS".
!!
!! OUTPUT
!!  Only writing, then the code is stopped.
!!
!! PARENTS
!!
!! CHILDREN
!!      etsf_io_low_error_to_str,msg_hndl
!!
!! SOURCE

subroutine abietsf_msg_hndl(lstat,Error_data,mode_paral,file,line)

!Arguments ------------------------------------

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
!End of the abilint section

 integer,optional,intent(in) :: line
 character(len=*),optional,intent(in) :: file
 character(len=*),intent(in) :: mode_paral
 logical,intent(in) :: lstat
 type(ETSF_io_low_error),intent(in) :: Error_data

!Local variables-------------------------------
 integer :: f90line=0
 character(len=500) :: f90name='Subroutine Unknown'
 character(len=etsf_io_low_error_len) :: errmess
! *********************************************************************

 if (lstat) RETURN

 if (PRESENT(line)) f90line=line
 if (PRESENT(file)) f90name = file
 call etsf_io_low_error_to_str(errmess,Error_data)

 call msg_hndl(errmess,"ERROR",mode_paral,f90name,f90line)

end subroutine abietsf_msg_hndl
!!***

!----------------------------------------------------------------------

#endif

END MODULE m_abi_etsf
!!***
