! {\src2tex{textfont=tt}}
!!****f* ABINIT/prtbltztrp_out
!! NAME
!! prtbltztrp_out
!!
!! FUNCTION
!!
!! COPYRIGHT
!! Copyright (C) 2005-2010 ABINIT group (?)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!!  eigen(mband*nkpt*nsppol) = array for holding eigenvalues (hartree)
!!  fermie = Fermi level
!!  fname_radix = radix of file names for output
!!  natom = number of atoms in cell.
!!  nband = number of bands
!!  nkpt = number of k points.
!!  nsppol = 1 for unpolarized, 2 for spin-polarized
!!  nsym = number of symmetries in space group
!!  rprimd(3,3) = dimensional primitive translations for real space (bohr)
!!  spgroup = space group 
!!  symrel = symmetry operations in reduced coordinates, real space
!!  tnons(3,nsym) = primitive translations for symops
!!  to be used in future  xred(3,natom) = reduced dimensionless atomic coordinates
!!
!! OUTPUT
!!  (only writing, printing)
!!
!! SIDE EFFECTS
!!
!! NOTES
!!
!! PARENTS
!!      outscfcv
!!
!! CHILDREN
!!      metric,spgdata,wrtout
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine prtbltztrp_out (eigen, fermie, fname_radix, kpt, natom, nband, nkpt, nsppol, nsym, &
&       rprimd, spgroup, symrel, tnons)

 use defs_basis
 use m_io_tools

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
 use interfaces_42_geometry
!End of the abilint section

 implicit none

! arguments
 integer, intent(in) :: natom, nsym, nband, nkpt, nsppol
 integer, intent(in) :: spgroup
 real(dp), intent(in) :: fermie

 integer, intent(in) :: symrel(3,3,nsym)
 real(dp), intent(in) :: tnons(3,nsym), kpt(3,nkpt)
 real(dp), intent(in) :: eigen(nband, nkpt, nsppol)
 character(len=fnlen), intent(in) :: fname_radix
 real(dp), intent(in) :: rprimd(3,3)

!local
 integer :: iout, isym, iband, isppol, ikpt
 integer :: sporder
 character(len=1)  :: brvsb
 character(len=15) :: intsb,ptintsb,ptschsb,schsb
 character(len=35) :: intsbl
 character(4) :: lattic
 character(len=fnlen) :: filename
 character(len=500) :: message
 real(dp) :: ucvol, ha2ryd
 real(dp) :: gprimd(3,3), rmet(3,3), gmet(3,3)
 real(dp) :: symconv(3,3,nsym)
 real(dp) :: kpt_incube(3)
 real(dp) :: convmat(3,3), convmat_inv(3,3)
 real(dp) :: rprimd_conv(3,3)

! matrices for conversion to conventional cells, from Giacovazzo Fundamentals of Crystallography, table 2.C.1
! this should go in a module somewhere, and can be used by cif output format as well (same directory)
 real(dp) :: convmat_I2P (3,3) = reshape((/-half, half, half,  half,-half, half,  half, half,-half/), (/3,3/))
 real(dp) :: convmat_P2I (3,3) = reshape((/ zero,  one,  one,   one, zero,  one,   one,  one, zero/), (/3,3/))

 real(dp) :: convmat_F2P (3,3) = reshape((/ zero, half, half,  half, zero, half,  half, half, zero/), (/3,3/))
 real(dp) :: convmat_P2F (3,3) = reshape((/ -one,  one,  one,   one, -one,  one,   one,  one, -one/), (/3,3/))

 real(dp) :: convmat_Robv2P (3,3) = reshape((/ two*third, -third, -third,  third,  third,  -two*third,&
&                                              third, third, third/), (/3,3/))
 real(dp) :: convmat_P2Robv (3,3) = reshape((/  one, zero,  one,  -one,  one,  one,  zero, -one,  one/), (/3,3/))

 real(dp) :: convmat_Rrev2P (3,3) = reshape((/ third, third, -two*third,  -third,  two*third,  -third,&
&                                              third, third, third/), (/3,3/))
 real(dp) :: convmat_P2Rrev (3,3) = reshape((/  one, -one,  one,  zero,  one,  one,  -one, zero, one/), (/3,3/))

 real(dp) :: convmat_A2P (3,3) = reshape((/ -one, zero, zero,  zero, -half,  half,  zero,  half,  half/), (/3,3/))
 real(dp) :: convmat_P2A (3,3) = reshape((/ -one, zero, zero,  zero, -one,  one,  zero,  one,  one/), (/3,3/))

 real(dp) :: convmat_B2P (3,3) = reshape((/ -half, zero,  half,  zero, -one, zero,   half, zero,  half/), (/3,3/))
 real(dp) :: convmat_P2B (3,3) = reshape((/ -one, zero,  one,  zero, -one, zero,   one, zero,  one/), (/3,3/))

 real(dp) :: convmat_C2P (3,3) = reshape((/  half,  half, zero,   half, -half, zero,  zero, zero, -one/), (/3,3/))
 real(dp) :: convmat_P2C (3,3) = reshape((/  one,  one, zero,   one, -one, zero,  zero, zero, -one/), (/3,3/))


!source code

 ha2ryd = two

 iout = get_unit()

! first file is for geometry symmetries etc
 filename= trim(fname_radix)//"_BLZTRP_GEOM"
 open (iout, file=filename, form='formatted')

 write (iout, '(a)') "BoltzTraP geometry file generated by ABINIT."
! make up abbreviation for point group: lattic
 call spgdata(brvsb,intsb,intsbl,ptintsb,ptschsb,&
& schsb,1,spgroup,sporder,1)

! to use SIESTA notation, complicate the lattic symbol, so that BoltzTraP can simplify it again later
!  back to original brvsb value
 lattic=brvsb//'   '
 convmat = reshape((/  one, zero, zero,  zero, one, zero,  zero, zero, one/), (/3,3/))
 convmat_inv = convmat
 if      (brvsb == 'I') then
   lattic = 'B   '
   convmat     = convmat_P2I
   convmat_inv = convmat_I2P
 else if (brvsb == 'A') then
   lattic = 'CYZ '
   convmat     = convmat_P2A
   convmat_inv = convmat_A2P
 else if (brvsb == 'B') then
   lattic = 'CXZ '
   convmat     = convmat_P2B
   convmat_inv = convmat_B2P
 else if (brvsb == 'C') then
   lattic = 'CXY '
   convmat     = convmat_P2C
   convmat_inv = convmat_C2P
 else if (brvsb == 'F') then
   convmat     = convmat_P2F
   convmat_inv = convmat_F2P
 else if (brvsb == 'R') then
   convmat     = convmat_P2Robv
   convmat_inv = convmat_Robv2P
   if (.false.) then
     convmat     = convmat_P2Rrev
     convmat_inv = convmat_Rrev2P
   end if
 end if

 rprimd_conv = matmul(convmat,rprimd)
 write (message,'(a)') "Conventional lattice vectors, for BoltzTraP "
 call wrtout(std_out,message,'COLL')
 write (message,'(3(3E20.10,a))') rprimd_conv(:,1),ch10,rprimd_conv(:,2),ch10,rprimd_conv(:,3),ch10
 call wrtout(std_out,message,'COLL')

! here we need to print out the conventional cell, and corresponding symops
 write (iout, '(a,i7)') lattic, natom
 call metric(gmet,gprimd,-1,rmet,rprimd_conv,ucvol)
 write (iout, '(6E20.10)') &
&   sqrt(rmet(1,1)), &
&   sqrt(rmet(2,2)), &
&   sqrt(rmet(3,3)), &
&   acos(rmet(2,3)/sqrt(rmet(2,2)*rmet(3,3)))/two_pi*360.0d0, &
&   acos(rmet(1,3)/sqrt(rmet(1,1)*rmet(3,3)))/two_pi*360.0d0, &
&   acos(rmet(1,2)/sqrt(rmet(1,1)*rmet(2,2)))/two_pi*360.0d0

 write (iout, '(I7)') nsym

! wien2k and BoltzTraP take conventional cell symops as input (CIF file does too)
! convmat = p2c_rec matrix in Boltztrap
 do isym=1, nsym
   symconv(:,:,isym) = matmul(transpose(convmat_inv), matmul(real(symrel(:,:,isym)), convmat))

   write (iout,'(3(3I5, 1x, E20.10), 2x, I5)') &
&      int(symconv(:,1,isym)), tnons(1,isym), &
&      int(symconv(:,2,isym)), tnons(2,isym), &
&      int(symconv(:,3,isym)), tnons(3,isym), &
&      isym
 end do

 close (iout)

! second file is for eigenvalues
 filename= trim(fname_radix)//"_BLZTRP_EIGS"
 open (iout, file=filename, form='formatted')

 write (iout, '(I7, I7, E20.10, a)') nkpt, nsppol, ha2ryd*fermie, '     ! nk, nspin, Fermi level(Ry)'
 do isppol = 1, nsppol 
   do ikpt = 1, nkpt
!     call wrap2_zero_one(kpt(1,ikpt),kpt_incube(1),res)
!     call wrap2_zero_one(kpt(2,ikpt),kpt_incube(2),res)
!     call wrap2_zero_one(kpt(3,ikpt),kpt_incube(3),res)
!
! these need to be in cartesian reduced coordinates. Multiply by 
     kpt_incube = matmul(convmat, kpt(:,ikpt))
     write (iout, '(3E20.10, I7, a)') kpt_incube(1), kpt_incube(2), kpt_incube(3), nband, '    ! kpt nband'
     do iband = 1, nband
! output in eV
       write (iout, '(E20.10)') ha2ryd*eigen(iband, ikpt, isppol)
     end do
   end do
 end do

 close (iout)

end subroutine prtbltztrp_out
!!***


