!{\src2tex{textfont=tt}}
!!****f* ABINIT/getghc
!!
!! NAME
!! getghc
!!
!! FUNCTION
!! Compute <G|H|C> for input vector |C> expressed in reciprocal space
!! Result is put in array ghc.
!! <G|Vnonlocal|C> is also returned in gvnlc.
!! if required, <G|S|C> is returned in gsc (S=overlap - PAW only)
!!
!! COPYRIGHT
!! Copyright (C) 1998-2010 ABINIT group (DCA, XG, GMR, LSI, MT)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!! cpopt=flag defining the status of cwaveprj%cp(:)=<Proj_i|Cnk> scalars (PAW only)
!!       (same meaning as in nonlop.F90 routine)
!!       if cpopt=-1, cwaveprj is not used
!!       if cpopt= 0, cwaveprj is output
!! cwavef(2,npw*nspinor*ndat)=planewave coefficients of wavefunction.
!! dimffnl=second dimension of ffnl (1+number of derivatives)
!! ffnl(npw,dimffnl,lmnmax,ntypat)=nonlocal form factors on basis sphere.
!! filstat=name of the status file
!! gs_ham <type(gs_hamiltonian_type)>=all data for the Hamiltonian to be applied
!! kg_k(3,npw)=G vec coordinates wrt recip lattice transl.
!! kinpw(npw)=(modified) kinetic energy for each plane wave (Hartree)
!! lambda=factor to be used when computing <G|H-lambda.S|C> - only for sij_opt=-1
!!        Typically lambda is the eigenvalue (or its guess)
!! lmnmax=if useylm=1, max number of (l,m,n) comp. over all type of psps
!!       =if useylm=0, max number of (l,n)   comp. over all type of psps
!! matblk=dimension of the array ph3d
!! mgfft=maximum size for 1D FFTs
!! mpi_enreg=informations about MPI parallelization
!! mpsang= 1+maximum angular momentum for nonlocal pseudopotentials
!! mpssoang= 1+maximum (spin*angular momentum) for nonlocal pseudopotentials
!! natom=number of atoms in unit cell.
!! ndat=number of FFT to do in //
!! npw=number of planewaves in basis for given k point.
!! nspinor=number of spinorial components of the wavefunctions
!! ntypat=number of types of atoms in cell.
!! nvloc=final dimension of vlocal (usually 1, but 4 for non-collinear)
!! n4,n5,n6 used for dimensionning of vlocal
!! ph3d(2,npw,matblk)=3-dim structure factors, for each atom and plane wave.
!! prtvol=control print volume and debugging output
!! sij_opt= -PAW ONLY-  if  0, only matrix elements <G|H|C> have to be computed
!!    (S=overlap)       if  1, matrix elements <G|S|C> have to be computed in gsc in addition to ghc
!!                      if -1, matrix elements <G|H-lambda.S|C> have to be computed in ghc (gsc not used)
!! tim_getghc=timing code of the calling subroutine(can be set to 0 if not attributed)
!! type_calc= option governing which part of Hamitonian is to be applied:
!             0: whole Hamiltonian
!!            1: local part only
!!            2: non-local+kinetic only (added to the exixting Hamiltonian)
!! vlocal(n4,n5,n6,nvloc)= local potential in real space, on the augmented fft grid
!!
!! OUTPUT
!!  ghc(2,npw*nspinor*ndat)=matrix elements <G|H|C> (if sij_opt>=0)
!!                                       or <G|H-lambda.S|C> (if sij_opt=-1)
!!  gvnlc(2,npw*nspinor*ndat)=matrix elements <G|Vnonlocal|C> (if sij_opt>=0)
!!                                         or <G|Vnonlocal-lambda.S|C> (if sij_opt=-1)
!!    (sometimes desired for computing nonlocal part of total energy, but can be ignored).
!!  if (sij_opt=1)
!!    gsc(2,npw*nspinor*ndat)=matrix elements <G|S|C> (S=overlap).
!!
!! SIDE EFFECTS
!!  ====== if gs_ham%usepaw==1 and
!!  cwaveprj(natom,nspinor*(1+cpopt))= wave functions at k projected with nl projectors
!!
!! PARENTS
!!      cgwf,cgwf3,ks_ddiago,lobpcgIIIwf,lobpcgIIwf,lobpcgccIIIwf,lobpcgccIIwf
!!      lobpcgccwf,lobpcgwf,mkresi,prep_getghc,update_mmat
!!
!! CHILDREN
!!      fourwf,leave_new,nonlop,status,timab,wrtout
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine getghc(cpopt,cwavef,cwaveprj,dimffnl,ffnl,filstat,ghc,gsc,gs_ham,&
&  gvnlc,kg_k,kinpw,lambda,lmnmax,&
&  matblk,mgfft,mpi_enreg,mpsang,mpssoang,&
&  natom,ndat,npw,nspinor,ntypat,nvloc,n4,n5,n6,&
&  paral_kgb,ph3d,prtvol,sij_opt,tim_getghc,type_calc,vlocal)

 use defs_basis
 use defs_datatypes
 use defs_abitypes

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
 use interfaces_16_hideleave
 use interfaces_18_timing
 use interfaces_32_util
 use interfaces_53_ffts
 use interfaces_65_nonlocal
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!This type is defined in defs_mpi
!scalars
 integer,intent(in) :: cpopt,dimffnl,lmnmax,matblk,mgfft,mpsang,mpssoang,n4,n5
 integer,intent(in) :: n6,natom,ndat,npw,nspinor,ntypat,nvloc,paral_kgb,prtvol
 integer,intent(in) :: sij_opt,tim_getghc,type_calc
 real(dp) :: lambda
 character(len=fnlen),intent(in) :: filstat
 type(MPI_type),intent(inout) :: mpi_enreg
 type(gs_hamiltonian_type),intent(in) :: gs_ham
!arrays
 integer,intent(in) :: kg_k(3,npw)
 real(dp),intent(in) :: ffnl(npw,dimffnl,lmnmax,ntypat),kinpw(npw)
 real(dp),intent(inout) :: cwavef(2,npw*nspinor*ndat),ghc(2,npw*nspinor*ndat)
 real(dp),intent(inout) :: gvnlc(2,npw*nspinor*ndat),ph3d(2,npw,matblk)
 real(dp),intent(inout) :: vlocal(n4,n5,n6,nvloc)
 real(dp),intent(out) :: gsc(2,npw*nspinor*ndat*((sij_opt+1)/2))
 type(cprj_type),intent(inout) :: cwaveprj(natom,nspinor*(1+cpopt)*gs_ham%usepaw)

!Local variables-------------------------------
!scalars
 integer,parameter :: im=2,level=114,re=1
 integer :: choice,cplex,cpopt_here,i1,i2,i3,idat,idir,iexit,ig,igspinor,ii,ipw
 integer :: ispinor,nkpg,nnlout,paw_opt,signs,tim_fourwf,tim_nonlop
 real(dp) :: ghcim,ghcre,weight
 character(len=500) :: message
!arrays
 real(dp) :: enlout(1),nonlop_dum(1,1),nonlop_dum2(1,1),tsec(2)
 real(dp),allocatable :: cwavef1(:,:),cwavef2(:,:),cwavef_nonlop(:,:)
 real(dp),allocatable :: ghc1(:,:),ghc2(:,:),ghc3(:,:),ghc4(:,:),gsc_nonlop(:,:)
 real(dp),allocatable :: gvnlc_nonlop(:,:),kpg_dum(:,:),vlocal_tmp(:,:,:)
 real(dp),allocatable :: work(:,:,:,:)

! *********************************************************************

!Keep track of total time spent in getghc:
 call timab(200+tim_getghc,1,tsec)

!DEBUG
!write(6,*)' enter getghc '
!write(6,*)' getghc : cwavef(:,1)=',cwavef(:,1)
!stop
!ENDDEBUG

 if(prtvol<0)then
   call status(0,filstat,iexit,level,'enter         ')
 end if

!Structured debugging if prtvol==-level
 if(prtvol==-level)then
   write(message,'(80a,a,a)') ('=',ii=1,80),ch10,&
&   ' getghc : enter, debugging '
   call wrtout(std_out,message,'PERS')
 end if

 if ((type_calc==0).or.(type_calc==1)) then

   allocate(work(2,n4,n5,n6*ndat))

!  Apply the local potential to the wavefunction
!  Start from wavefunction in reciprocal space cwavef
!  End with function ghc in reciprocal space also.
   weight=1.0_dp

!  DEBUG
!  write(6,*)' getghc : will call fourwf '
!  write(6,*)' vlocal='
!  do i1=1,n4
!  do i2=1,n5
!  do i3=1,n6
!  write(6,*)i1,i2,i3,vlocal(i1,i2,i3,1)
!  end do
!  end do
!  end do
!  do i1 =1, nspinor
!  do ii=1,npw
!  write(6,*)ii,i1,cwavef(1,ii),cwavef(2,ii)
!  end do
!  end do
!  ENDDEBUG

!  Application of the local potential
   tim_fourwf=1
   if (nspinor==2) then
     allocate(cwavef1(2,npw*ndat),cwavef2(2,npw*ndat))
     do idat=1,ndat
       do ipw=1,npw
         cwavef1(1:2,ipw+(idat-1)*npw)=cwavef(1:2,ipw+(idat-1)*nspinor*npw)
         cwavef2(1:2,ipw+(idat-1)*npw)=cwavef(1:2,ipw+(idat-1)*nspinor*npw+npw)
       end do
     end do
   end if

!  Treat scalar local potentials
   if (nvloc==1) then
     if (nspinor==1) then
       call fourwf(1,vlocal,cwavef,ghc,work,gs_ham%gbound,gs_ham%gbound,&
&       gs_ham%istwf_k,kg_k,kg_k,mgfft,mpi_enreg,ndat,gs_ham%ngfft,&
&       npw,npw,n4,n5,n6,2,paral_kgb,tim_fourwf,weight,weight)
     else ! nspinor==2
       allocate(ghc1(2,npw*ndat),ghc2(2,npw*ndat))
       call fourwf(1,vlocal,cwavef1,ghc1,work,gs_ham%gbound,gs_ham%gbound,&
&       gs_ham%istwf_k,kg_k,kg_k,mgfft,mpi_enreg,ndat,gs_ham%ngfft,&
&       npw,npw,n4,n5,n6,2,paral_kgb,tim_fourwf,weight,weight)
       call fourwf(1,vlocal,cwavef2,ghc2,work,gs_ham%gbound,gs_ham%gbound,&
&       gs_ham%istwf_k,kg_k,kg_k,mgfft,mpi_enreg,ndat,gs_ham%ngfft,&
&       npw,npw,n4,n5,n6,2,paral_kgb,tim_fourwf,weight,weight)
       do idat=1,ndat
         do ipw =1, npw
           ghc(1:2,ipw+(idat-1)*nspinor*npw)    =ghc1(1:2,ipw+(idat-1)*npw)
           ghc(1:2,ipw+(idat-1)*nspinor*npw+npw)=ghc2(1:2,ipw+(idat-1)*npw)
         end do
       end do
       deallocate(ghc1,ghc2)
     end if

!    Treat non-collinear local potentials
   else if (nvloc==4) then
     allocate(ghc1(2,npw*ndat),ghc2(2,npw*ndat),ghc3(2,npw*ndat),ghc4(2,npw*ndat))
     allocate(vlocal_tmp(n4,n5,n6))
!    ghc1=v11*phi1
     vlocal_tmp(:,:,:)=vlocal(:,:,:,1)
     call fourwf(1,vlocal_tmp,cwavef1,ghc1,work,gs_ham%gbound,gs_ham%gbound,&
&     gs_ham%istwf_k,kg_k,kg_k,mgfft,mpi_enreg,ndat,gs_ham%ngfft,&
&     npw,npw,n4,n5,n6,2,paral_kgb,tim_fourwf,weight,weight)
!    ghc2=v22*phi2
     vlocal_tmp(:,:,:)=vlocal(:,:,:,2)
     call fourwf(1,vlocal_tmp,cwavef2,ghc2,work,gs_ham%gbound,gs_ham%gbound,&
&     gs_ham%istwf_k,kg_k,kg_k,mgfft,mpi_enreg,ndat,gs_ham%ngfft,&
&     npw,npw,n4,n5,n6,2,paral_kgb,tim_fourwf,weight,weight)
     deallocate(vlocal_tmp)
     cplex=2;allocate(vlocal_tmp(cplex*n4,n5,n6))
!    ghc3=(re(v12)-im(v12))*phi1
     do i3=1,n6
       do i2=1,n5
         do i1=1,n4
           vlocal_tmp(2*i1-1,i2,i3)= vlocal(i1,i2,i3,3)
           vlocal_tmp(2*i1  ,i2,i3)=-vlocal(i1,i2,i3,4)
         end do
       end do
     end do
     call fourwf(cplex,vlocal_tmp,cwavef1,ghc3,work,gs_ham%gbound,gs_ham%gbound,&
&     gs_ham%istwf_k,kg_k,kg_k,mgfft,mpi_enreg,ndat,gs_ham%ngfft,&
&     npw,npw,n4,n5,n6,2,paral_kgb,tim_fourwf,weight,weight)
!    ghc4=(re(v12)+im(v12))*phi2
     do i3=1,n6
       do i2=1,n5
         do i1=1,n4
           vlocal_tmp(2*i1,i2,i3)=-vlocal_tmp(2*i1,i2,i3)
         end do
       end do
     end do
     call fourwf(cplex,vlocal_tmp,cwavef2,ghc4,work,gs_ham%gbound,gs_ham%gbound,&
&     gs_ham%istwf_k,kg_k,kg_k,mgfft,mpi_enreg,ndat,gs_ham%ngfft,&
&     npw,npw,n4,n5,n6,2,paral_kgb,tim_fourwf,weight,weight)
     deallocate(vlocal_tmp)
!    Buildghc from pieces
!    (v11,v22,Re(v12)+iIm(v12);Re(v12)-iIm(v12))(psi1;psi2): matrix product
     do idat=1,ndat
       do ipw=1,npw
         ghc(1:2,ipw+(idat-1)*nspinor*npw)    =ghc1(1:2,ipw+(idat-1)*npw)+ghc4(1:2,ipw+(idat-1)*npw)
         ghc(1:2,ipw+(idat-1)*nspinor*npw+npw)=ghc3(1:2,ipw+(idat-1)*npw)+ghc2(1:2,ipw+(idat-1)*npw)
       end do
     end do

     deallocate(ghc1,ghc2,ghc3,ghc4)
   end if ! nvloc==1

   if (nspinor==2) deallocate(cwavef1,cwavef2)
   deallocate(work)
   if(prtvol<0)then
     call status(0,filstat,iexit,level,'call nonlop   ')
   end if

 end if


 if ((type_calc==0).or.(type_calc==2)) then

!  DEBUG
!  write(6,*)' getghc: before nonlop'
!  ENDDEBUG

   signs=2 ; choice=1 ; nnlout=1 ; idir=0 ; tim_nonlop=1 ; nkpg=0
   cpopt_here=-1;if (gs_ham%usepaw==1) cpopt_here=cpopt
   paw_opt=gs_ham%usepaw ; if (sij_opt/=0) paw_opt=sij_opt+3
   if(ndat==1)then
     if(gs_ham%usepaw==0)then
       call nonlop(gs_ham%atindx1,choice,cpopt_here,cwaveprj,gs_ham%dimekb1,gs_ham%dimekb2,dimffnl,dimffnl,&
&       gs_ham%ekb,enlout,ffnl,ffnl,gs_ham%gmet,gs_ham%gprimd,idir,&
&       gs_ham%indlmn,gs_ham%istwf_k,kg_k,kg_k,kpg_dum,kpg_dum,gs_ham%kpoint,gs_ham%kpoint,&
&       lambda,lmnmax,matblk,mgfft,mpi_enreg,mpsang,mpssoang,natom,gs_ham%nattyp,&
&       gs_ham%ngfft,nkpg,nkpg,gs_ham%nloalg,nnlout,npw,npw,nspinor,ntypat,0,paw_opt,&
&       gs_ham%phkxred,gs_ham%phkxred,gs_ham%ph1d,ph3d,ph3d,&
&       signs,nonlop_dum,nonlop_dum2,tim_nonlop,gs_ham%ucvol,gs_ham%useylm,cwavef,gvnlc)
     else
       call nonlop(gs_ham%atindx1,choice,cpopt_here,cwaveprj,gs_ham%dimekb1,gs_ham%dimekb2,dimffnl,dimffnl,&
&       gs_ham%ekb,enlout,ffnl,ffnl,gs_ham%gmet,gs_ham%gprimd,idir,&
&       gs_ham%indlmn,gs_ham%istwf_k,kg_k,kg_k,kpg_dum,kpg_dum,gs_ham%kpoint,gs_ham%kpoint,&
&       lambda,lmnmax,matblk,mgfft,mpi_enreg,mpsang,mpssoang,natom,gs_ham%nattyp,&
&       gs_ham%ngfft,nkpg,nkpg,gs_ham%nloalg,nnlout,npw,npw,nspinor,ntypat,0,paw_opt,&
&       gs_ham%phkxred,gs_ham%phkxred,gs_ham%ph1d,ph3d,ph3d,&
&       signs,gs_ham%sij,gsc,tim_nonlop,gs_ham%ucvol,gs_ham%useylm,cwavef,gvnlc)
     end if
   else
     allocate(cwavef_nonlop(2,npw*nspinor),gvnlc_nonlop(2,npw*nspinor))
     if (sij_opt==1) allocate(gsc_nonlop(2,npw*nspinor))
     do idat=1,ndat
       cwavef_nonlop(re,1:npw*nspinor)=cwavef(re,1+npw*nspinor*(idat-1):npw*nspinor*idat)
       cwavef_nonlop(im,1:npw*nspinor)=cwavef(im,1+npw*nspinor*(idat-1):npw*nspinor*idat)
       if(gs_ham%usepaw==0)then
         call nonlop(gs_ham%atindx1,choice,cpopt_here,cwaveprj,gs_ham%dimekb1,gs_ham%dimekb2,dimffnl,dimffnl,&
&         gs_ham%ekb,enlout,ffnl,ffnl,gs_ham%gmet,gs_ham%gprimd,idir,&
&         gs_ham%indlmn,gs_ham%istwf_k,kg_k,kg_k,kpg_dum,kpg_dum,gs_ham%kpoint,gs_ham%kpoint,&
&         lambda,lmnmax,matblk,mgfft,mpi_enreg,mpsang,mpssoang,natom,gs_ham%nattyp,&
&         gs_ham%ngfft,nkpg,nkpg,gs_ham%nloalg,nnlout,npw,npw,nspinor,ntypat,0,paw_opt,&
&         gs_ham%phkxred,gs_ham%phkxred,gs_ham%ph1d,ph3d,ph3d,&
&         signs,nonlop_dum,nonlop_dum2,tim_nonlop,gs_ham%ucvol,gs_ham%useylm,cwavef_nonlop,gvnlc_nonlop)
       else
         call nonlop(gs_ham%atindx1,choice,cpopt_here,cwaveprj,gs_ham%dimekb1,gs_ham%dimekb2,dimffnl,dimffnl,&
&         gs_ham%ekb,enlout,ffnl,ffnl,gs_ham%gmet,gs_ham%gprimd,idir,&
&         gs_ham%indlmn,gs_ham%istwf_k,kg_k,kg_k,kpg_dum,kpg_dum,gs_ham%kpoint,gs_ham%kpoint,&
&         lambda,lmnmax,matblk,mgfft,mpi_enreg,mpsang,mpssoang,natom,gs_ham%nattyp,&
&         gs_ham%ngfft,nkpg,nkpg,gs_ham%nloalg,nnlout,npw,npw,nspinor,ntypat,0,paw_opt,&
&         gs_ham%phkxred,gs_ham%phkxred,gs_ham%ph1d,ph3d,ph3d,&
&         signs,gs_ham%sij,gsc_nonlop,tim_nonlop,gs_ham%ucvol,gs_ham%useylm,cwavef_nonlop,gvnlc_nonlop)
       end if
       gvnlc(re,1+npw*nspinor*(idat-1):npw*nspinor*idat)=gvnlc_nonlop(re,1:npw*nspinor)
       gvnlc(im,1+npw*nspinor*(idat-1):npw*nspinor*idat)=gvnlc_nonlop(im,1:npw*nspinor)
       if (sij_opt==1) then
         gsc(re,1+npw*nspinor*(idat-1):npw*nspinor*idat)=gsc_nonlop(re,1:npw*nspinor)
         gsc(im,1+npw*nspinor*(idat-1):npw*nspinor*idat)=gsc_nonlop(im,1:npw*nspinor)
       end if
     end do
     deallocate(cwavef_nonlop,gvnlc_nonlop)
     if (sij_opt==1) deallocate(gsc_nonlop)
   end if
!  DEBUG
!  write(6,*)' getghc: after nonlop'
!  ENDDEBUG

   if(prtvol<0)then
     call status(0,filstat,iexit,level,'assemble      ')
   end if

   if(prtvol==-level)then
     write(message,'(a)')' getghc : components of ghc '
     call wrtout(std_out,message,'PERS')
     write(message,'(a,a)')' ig re/im     ghc     ',&
&     '   kinpw         cwavef      glocc        gvnlc '
     call wrtout(std_out,message,'PERS')
   end if

!  Assemble modified kinetic, local and nonlocal contributions
!  to <G|H|C(n,k)>. Take also into account build-in debugging.
   if(prtvol/=-level)then
     do idat=1,ndat
       do ispinor=1,nspinor
!        $OMP PARALLEL DO PRIVATE(idat,ig,igspinor) &
!        $OMP&SHARED(cwavef,ghc,gvnlc,kinpw,ndat,npw)
         do ig=1,npw
           igspinor=ig+npw*(ispinor-1)+npw*nspinor*(idat-1)
           if(kinpw(ig)<huge(zero)*1.d-11)then
             ghc(re,igspinor)=kinpw(ig)*cwavef(re,igspinor)+ghc(re,igspinor)+gvnlc(re,igspinor)
             ghc(im,igspinor)=kinpw(ig)*cwavef(im,igspinor)+ghc(im,igspinor)+gvnlc(im,igspinor)
           else
             ghc(re,igspinor)=zero
             ghc(im,igspinor)=zero
             if (sij_opt==1) then
               gsc(re,igspinor)=zero
               gsc(im,igspinor)=zero
             end if
           end if
         end do ! ig
       end do ! ispinor
!      $OMP END PARALLEL DO
     end do ! idat
   else
!    Here, debugging section
     do idat=1,ndat
       do ispinor=1,nspinor
!        $OMP PARALLEL DO PRIVATE(ghcre,ghcim,idat,ig,igspinor) &
!        $OMP&SHARED(cwavef,ghc,gvnlc,kinpw,ndat,npw)
         do ig=1,npw
           igspinor=ig+npw*(ispinor-1)+npw*nspinor*(idat-1)
           if(kinpw(ig)<huge(zero)*1.d-11)then
             ghcre=kinpw(ig)*cwavef(re,igspinor)+ghc(re,igspinor)+gvnlc(re,igspinor)
             ghcim=kinpw(ig)*cwavef(im,igspinor)+ghc(im,igspinor)+gvnlc(im,igspinor)
           else
             ghcre=zero
             ghcim=zero
             if (sij_opt==1) then
               gsc(re,igspinor)=zero
               gsc(im,igspinor)=zero
             end if
           end if
           if(ig<=3 .or. mod(ig,50)==0 )then
!            DEBUG
!            if(ig<=25 .or. mod(ig,20)==0 )then
!            ENDDEBUG
             write(message,'(i3,a,5es13.6)')igspinor,'  1  ',ghcre,&
&             kinpw(ig),cwavef(re,igspinor),ghc(re,igspinor),gvnlc(re,igspinor)
             call wrtout(std_out,message,'PERS')
             write(message,'(a,5es13.6)')'     2  ',ghcim,&
&             kinpw(ig),cwavef(im,igspinor),ghc(im,igspinor),gvnlc(im,igspinor)
             call wrtout(std_out,message,'PERS')
           end if
           ghc(re,igspinor)=ghcre
           ghc(im,igspinor)=ghcim
         end do ! ig
       end do ! ispinor
!      $OMP END PARALLEL DO
     end do ! idat
   end if

!  Structured debugging : if prtvol=-level, stop here.
   if(prtvol==-level)then
     write(message,'(a,a,a,a,i2,a)') ch10,&
&     ' getghc : exit ',&
&     ch10,'  prtvol=-',level,', debugging mode => stop '
     call wrtout(std_out,message,'PERS')
     call status(0,filstat,iexit,level,'debug => stop ')
     call leave_new('PERS')
   end if

   if(prtvol<0)then
     call status(0,filstat,iexit,level,'exit          ')
   end if

 end if

 call timab(200+tim_getghc,2,tsec)

!DEBUG
!write(6,*)' getghc : exit'
!ENDDEBUG

end subroutine getghc
!!***
