!{\src2tex{textfont=tt}}
!!****f* ABINIT/evdw_wannier
!! NAME
!! evdw_wannier
!!
!! FUNCTION
!!  FIXME: Evaluates the van der Waals correlation energy using maximally
!!         localized Wannier funcitons (MLWF) as proposed by P. L. Silvestrelli
!!         in PRL 100:053002 (2008).
!!
!! COPYRIGHT
!!  Copyright (C) 2010 ABINIT group (CE and TR)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!!   nwan            = Total number of MLWF in the system. (nwan=vdw_nwan(1)+vdw_nwan(2)).
!!   vdw_nwan(2)     = Number of MLWF in each interacting fragment. For layered materials
!!                     abs(vdw_nwan(2))=nwan and vdw_nwan(2)=1,2 or 3 indicates which of
!!                     x,y or z is the normal axis to the layers.
!!   vdw_supercell(3)     = Distance along each rprimd components for 
!!                          which vdW interactions between MLWF will be taken into account. 
!!   rprimd               = Real space primitive translations.    
!!   wann_centres(3:nwan) = The centers of MLWFs  in a.u. 
!!   wann_spreads(nwan)   = Spread of the MLWFs, in Ang**2. (from wannier90).
!!
!! OUTPUT
!!   csix(nwana:nwanb) = dispersion coefficient between each pair of MLWF.          
!!   corrvdw           = van der Waals correction to the energy.
!! SIDE EFFECTS
!!
!! NOTES
!!
!! PARENTS
!!  Will be filled automatically by the parent script
!!
!! CHILDREN
!!  Will be filled automatically by  script
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine evdw_wannier(csix,corrvdw,nwan,vdw_nwan,&
& vdw_supercell,rprimd,wann_centres,wann_spreads)    

use defs_basis

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
 use interfaces_42_geometry
 use interfaces_67_common, except_this_one => evdw_wannier
!End of the abilint section

 implicit none

!Arguments ------------------------------------
 integer , intent(in)  :: nwan
 integer , intent(in)  :: vdw_nwan(2),vdw_supercell(3)
 real(dp), intent(in)  :: rprimd(3,3),wann_centres(3,nwan),wann_spreads(nwan)
 real(dp), intent(out) :: corrvdw
 real(dp), intent(out), allocatable :: csix(:,:) 

!Local variables-------------------------------
 integer :: ii,inx,iny,inz,iwan,jwan                      
 real(dp) ::fij,rij,fu,shift
 real(dp), parameter :: a = 20.d0
 real(dp), allocatable:: dcenters(:,:),rc(:),rv(:),wanncent(:,:),wannspr(:)
 real(dp), allocatable:: wc_rec(:,:) 
 character(len=500) :: message                   ! to be uncommented, if needed
 
! *************************************************************************
 
!DEBUG
!write (std_out,*) ' evdw_wannier : enter'
!ENDDEBUG

!DEBUG                                           ! to be uncommented, if needed
!if(option/=1 .and. option/=2 )then
!write(message,'(a,a,a,a,a,a,i6)') ch10,&
!&  ' evdw_wannier: BUG -',ch10,&
!&  '  The argument option should be 1 or 2,',ch10,&
!&  '  however, option=',option
!call wrtout(std_out,message,'COLL')
!call leave_new('COLL')
!endif
!if(sizein<1)then
!write(message,'(a,a,a,a,a,a,i6)') ch10,&
!&  ' evdw_wannier: BUG -',ch10,&
!&  '  The argument sizein should be a positive number,',ch10,&
!&  '  however, sizein=',sizein
!call wrtout(std_out,message,'COLL')
!call leave_new('COLL')
!endif
!ENDDEBUG
 
 allocate(dcenters(3,nwan),rc(nwan),rv(nwan),wanncent(3,nwan),wannspr(nwan))
 allocate(wc_rec(3,nwan))

 wanncent(:,:)=wann_centres(:,:)/Bohr_Ang

!converting to bohr**2 and then squared 
 wannspr(:)=sqrt(wann_spreads(:)/Bohr_Ang**2)
!write(*,*) "spread of WF",i, "=", wann_spreads(i)

 write(*,*) 'Original Wannier centres and spreads:',ch10
 do iwan=1,nwan
   write(*,*) (wanncent(ii,iwan),ii=1,3), wannspr(iwan)
 end do

!if(vdw_nwan(1)/=nwan)then

 call xredxcart(nwan,-1,rprimd,wanncent,wc_rec)  !get centers in reduced coor
 do iwan=1,nwan
   do ii=1,3
     if(wc_rec(ii,iwan)<zero) then
       shift=REAL(CEILING(ABS(wc_rec(ii,iwan))),dp)
       wc_rec(ii,iwan) = wc_rec(ii,iwan)+shift
     end if 
     if(wc_rec(ii,iwan)>one) then                      
       shift=-REAL(INT(wc_rec(ii,iwan)),dp)
       wc_rec(ii,iwan) = wc_rec(ii,iwan)+shift
     end if 
   end do
 end do
 call xredxcart(nwan,1,rprimd,wanncent,wc_rec)


!====================================================================

 write(*,*) 'Wannier centres translated to unit cell and spr:',ch10
 do iwan=1,nwan
   write(*,*) (wanncent(ii,iwan),ii=1,3), wannspr(iwan)
 end do

!endif !vdw_nwan(1)/=nwan

 call order_wannier(nwan,wanncent,wannspr)  !Ordering of MLWFs according to 
!the z component of its centres.
!This is for proper definition of
!interacting fragments.                                                                                                   

 write(*,*) ch10,'Ordered Wannier centres and spreads',ch10
 do iwan=1,nwan
   write(*,*) (wanncent(ii,iwan),ii=1,3), wannspr(iwan)
 end do 

!Calculate intermediate quantities
 do iwan=1, nwan                                              
   rc(iwan)=three*(0.769d0+half*dlog(wannspr(iwan)))            
   rv(iwan)= (1.475d0-half_sqrt3*dlog(wannspr(iwan)))*wannspr(iwan) 
!  write(*,*)"iwan ",iwan," rc=",rc(iwan), "rv=", rv(iwan)    
 end do                                                      
 
 corrvdw=0.0d0  !INITIALIZING THE VDW CORRECTION ENERGY.
 
 allocate (csix(nwan,nwan)) !THIS COEFFICIENTS ARE DISTANCE INDEPENDENT
 
 do iwan=1,nwan
   do jwan=1,nwan
     
     call getFu(wannspr(iwan),wannspr(jwan),rc(iwan),rc(jwan),fu)
     csix(iwan,jwan)=sqrt2*( ( ((wannspr(iwan))**onehalf)*&
&     (wannspr(jwan)**three))/(two*(three**1.25d0) ) )*fu
     
   end do
 end do

 write(*,*) ch10,'C6ij coefficients',ch10,'index i(j) from mlwf in fragment 1(2):',ch10

 do iwan=1,vdw_nwan(1)
   write(*,*) (csix(iwan,jwan),jwan=1,nwan)
 end do

!test   k=0   
 do iwan=1,nwan
   do inx=-vdw_supercell(1),vdw_supercell(1)
     do iny=-vdw_supercell(2),vdw_supercell(2)
       do inz=-vdw_supercell(3),vdw_supercell(3)
         do jwan=1,nwan 
           if(abs(vdw_nwan(1))/=nwan)then
             IF(inx==0.and.iny==0.and.inz==0.and.jwan==iwan) CYCLE !This avoids self vdw interaction.
             IF(iwan<=vdw_nwan(1).and.jwan<=vdw_nwan(1)) CYCLE     !This two conditions allow 
             IF(iwan>vdw_nwan(1).and.jwan>vdw_nwan(1)) CYCLE       !for inter fragment interaction only,
           end if                                                   !and avoid intra fragment interactions.

           if(abs(vdw_nwan(1))==nwan)then           !This is for the case where there is not           
             if(inx==0.and.iny==0.and.inz==0)cycle  !fragments inside the unit cell, as in
             if(vdw_nwan(1)<0)then                  !molecular crystals (intercell vdw interactions).   
               if(vdw_nwan(2)==1.and.inx==0)cycle
               if(vdw_nwan(2)==2.and.iny==0)cycle   !This 3 conditions are for layered materials.
               if(vdw_nwan(2)==3.and.inz==0)cycle
             end if
           end if                                   

           dcenters(:,jwan) = (real(inx,dp))*rprimd(:,1)+(real(iny,dp))*rprimd(:,2)+&
&           (real(inz,dp))*rprimd(:,3)+wanncent(:,jwan) 
           rij=sqrt((dcenters(1,jwan)-wanncent(1,iwan))**2+(dcenters(2,jwan)-wanncent(2,iwan))**2+&
&           (dcenters(3,jwan)-wanncent(3,iwan))**2) 

           fij=one/(one+exp(-a*(rij/(rv(iwan)+rv(jwan))-one))) !Damping function.  
           
           corrvdw = corrvdw - csix(iwan,jwan)*fij/(two*(rij**6)) !making the sum of eq(4) of 
!          JPhysChemA 113:5224-5234. Each term is divided by two because
!          we are counting twice within the unit cell, also the 
!          interactions with neighbor cells are properly acounted for in 
!          this way.
           
!          write(*,*) 'i=',iwan, 'j=',jwan, 'C6ij=', csix(iwan,jwan)
!          write(*,*) 'inx=',inx, "iny=",iny, "inz=",inz, "Evdw=",&
!          & -(csix(iwan,jwan)*fij/(two*rij**6))*Ha_ev*ten**3 
!          write(*,*) 'rnl=',rnl
         end do
       end do
     end do
   end do
 end do 
 deallocate(dcenters,rc,rv,wanncent,wannspr)
 
 write(message, '(2a,i2,2a,f12.3,2a,f12.3,a)' )ch10,&
& ' vdw_xc : ',10,ch10,&                                                              
& ' van der Waals correction(Ha):',   corrvdw,ch10,&                            
& ' van der Waals correction(meV):',   corrvdw*Ha_ev*ten**3,ch10                                                           
 call wrtout(std_out,message,'COLL')                                                     
 call wrtout(ab_out,message,'COLL')

!DEBUG
!write (std_out,*) ' evdw_wannier : exit'
!stop
!ENDDEBUG

end subroutine evdw_wannier
!!***

!!****f* ABINIT/getFu
!! NAME
!! getFu
!!
!! FUNCTION
!!
!! COPYRIGHT
!!  Copyright (C) 2010 ABINIT group (CE and TR)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!!
!! OUTPUT

!! SIDE EFFECTS
!!
!! NOTES
!!
!! PARENTS
!!  Will be filled automatically by the parent script
!!
!! CHILDREN
!!  Will be filled automatically by  script
!!
!! SOURCE

 subroutine getFu(sn,sl,rn,rl,fu) ! sn-->spread(n), sl-->spread(l), rn --> rc(n), rl --> rc(l) 
 use defs_basis

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_32_util
!End of the abilint section

 implicit none
 real(dp),intent(in)::sn,sl,rn,rl
 real(dp),intent(out)::fu
 !local variables
 integer::nx,ny,ix,iy
 real(dp)::deltax,deltay
 real(dp)::beta,xc,yc,y,x
 real(dp),allocatable::arg1(:),res1(:),arg2(:),res2(:)

 ny=100
 nx=100
 beta=(sn/sl)**(1.5d0)
 xc=sqrt3*rn/sn
 yc=sqrt3*rl/sl

 deltax=xc/(real(nx,dp)-1.d0)
 deltay=yc/(real(ny,dp)-1.d0)
 
 allocate(arg1(ny),res1(ny))
 allocate(arg2(nx),res2(nx))  

 do ix=1,nx

   x=deltax*(real(ix,dp)-1.d0)
 
    do iy=1,ny
      y=deltay*(real(iy,dp)-1.d0)
      arg1(iy)=( (y**2.d0)*exp(-y) )/( (exp(-x)/beta) + exp(-y) )
    end do

    call simpson_int(ny,deltay,arg1,res1)
    arg2(ix)=(x**2.d0)*exp(-x)*res1(ny)

 end do

    call simpson_int(nx,deltax,arg2,res2)
    
  Fu = res2(nx)
  
 deallocate(arg1,res1,arg2,res2)
end subroutine getFu
!!*** 
      
!!****f* ABINIT/order_wannier
!! NAME
!! order_wannier
!!  
!! FUNCTION
!!
!! COPYRIGHT
!!  Copyright (C) 2010 ABINIT group (CE and TR)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!!
!! OUTPUT

!! SIDE EFFECTS
!!
!! NOTES
!!
!! PARENTS
!!      evdw_wannier
!!
!! CHILDREN
!!
!! SOURCE
subroutine order_wannier(nwan,wanncent,wannspr)

   use defs_basis

   implicit none
!Arguments
   integer, intent(in) :: nwan
   real(dp),intent(inout) :: wanncent(3,nwan), wannspr(nwan)
!Local variables
   integer::ii,jj,kk
   integer,allocatable::ord(:),cont(:)
   real(dp)::res
   real(dp),allocatable::ordwanncent(:,:),ordwannspr(:)

  

 allocate(cont(nwan),ord(nwan),ordwanncent(3,nwan),ordwannspr(nwan))


  cont(:)=0
  do ii=1,nwan
     do jj=1,nwan
       res=wanncent(3,ii)-wanncent(3,jj)
        if(res > 0.d0) then
         cont(ii)=cont(ii)+1
        endif
     enddo
  enddo
  ii=0 
  do kk=0,nwan-1
     do jj=1,nwan 
       if (cont(jj)>=kk .and. cont(jj)<kk+1)  then
       ii=ii+1
       ord(jj)= ii
       endif
     enddo
  enddo

  do kk=1,nwan
    do jj=1,nwan
      if (ord(jj)==kk) then
      ordwanncent(:,kk)=wanncent(:,jj)
      ordwannspr(kk)=wannspr(jj)
      endif
    enddo
  enddo

 do ii=1,nwan 
   wanncent(:,ii)=ordwanncent(:,ii)
   wannspr(ii)=ordwannspr(ii)
 enddo

!write(*,*) ch10,'Ordered MLWF centres:',ch10
!do jj=1,nwan
! write(*,*) ordwanncent(jj)
!enddo

   
 deallocate (cont,ord,ordwanncent,ordwannspr)

 end subroutine order_wannier
!!***
