!{\src2tex{textfont=tt}}
!!****f* ABINIT/mag_out
!! NAME
!! mag_out
!!
!! FUNCTION
!! This routine prints the magnetization.
!!
!! COPYRIGHT
!!
!! INPUTS
!!  dtefield <type(efield_type)> = variables related to Berry phase. 
!!  nkpt = number of kpoints
!!  rprimd(3,3) = dimensional primitive translations (bohr)
!!  ucvol = volume of unit cell
!!  wtk = weights of k points
!!
!! OUTPUT
!!  only printing
!!
!! SIDE EFFECTS
!!
!! NOTES
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine mag_out(dtefield,nkpt,rprimd,ucvol,wtk)

 use defs_basis
 use defs_datatypes

#if defined HAVE_MPI && defined HAVE_MPI2
 use mpi
#endif

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
 use interfaces_32_util
!End of the abilint section

 implicit none

#if defined HAVE_MPI && defined HAVE_MPI1
 include 'mpif.h'
#endif

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: nkpt
 real(dp),intent(in) :: ucvol
 type(efield_type),intent(in) :: dtefield
!arrays
 real(dp),intent(in) :: rprimd(3,3),wtk(nkpt)

!Local variables-------------------------------
!scalars
 integer :: bdir,bfor,bsig,iband,idir,idum1,istep,jdir,ikpt,kdir,mu
 real(dp) :: intfac1, intfac2,mr,mi,sfac
!arrays
 character(len=500) :: message
 real(dp) :: bcart(3),chern(3), gprimd(3,3)
 real(dp) :: mag_loc(3), mag_bare(3), mag_mmat(3)
 real(dp) :: mag_tot(3)

! ************************************************************************

 call matr3inv(rprimd,gprimd)

 mag_loc(:) = zero
 mag_bare(:) = zero
 chern(:) = zero

 mag_mmat(:) = zero

 intfac1 = 1.0/(Sp_Lt)
 intfac2 = -1.0/(2.0*Sp_Lt*ucvol)

 do idir = 1, 3
   do mu=1,3
     bcart(mu)=dot_product(dtefield%dkvecs(:,idir),gprimd(mu,:))
   end do
   do ikpt = 1, nkpt
     mag_loc(idir) = mag_loc(idir) - wtk(ikpt)*dtefield%mag_local_k(idir,ikpt)
     do jdir = 1, 3
       do iband = 1, dtefield%nband_occ
         chern(jdir) = chern(jdir) - &
&         bcart(jdir)*wtk(ikpt)*dtefield%cmat(2,iband,iband,ikpt,idir)
       end do
     end do

   end do ! end loop over ikpt
 end do ! end loop over idir
 
 sfac = 0.5
 mr = zero; mi = zero
 do idir = 1, 3
   do mu=1,3
     bcart(mu)=dot_product(dtefield%dkvecs(:,idir),gprimd(mu,:))
   end do
   select case(idir)
     case(1)
       bdir = 2; kdir = 3
     case(2)
       bdir = 3; kdir = 1
     case(3)
       bdir = 1; kdir = 2
   end select
   do istep = 1, 2
     do bsig = -1, 1, 2
       bfor = (-bsig+3)/2
       do ikpt = 1, nkpt
         do iband = 1, dtefield%nband_occ
           do jdir = 1, 3
             mag_mmat(jdir) = mag_mmat(jdir) - &
&             bcart(jdir)*wtk(ikpt)*sfac*bsig*&
&             dtefield%mmat(2,iband,iband,ikpt,bdir,bfor,kdir)
           end do   
         end do ! end loop over bands
       end do ! end loop over nkpt
     end do ! end loop over bsig
     sfac = -sfac
     idum1 = bdir; bdir = kdir; kdir = idum1
   end do !end loop over istep
 end do ! end loop over idir

 mag_loc(:) = mag_loc(:)*intfac1
 mag_mmat(:) = mag_mmat(:)*intfac2
 mag_tot(:) = mag_loc(:) + mag_mmat(:)

 chern(:) = chern(:)/two_pi !
!two_pi comes from the definition and the rest on going from the integral to the sum

 write(message,'(a)')' On-site local magnetization (mag_loc): '  
 call wrtout(std_out,message,'COLL')
 do idir = 1, 3
   write(message,'(a,i4,a,es16.8)')'   dir = ',idir,'  mag_loc = ',mag_loc(idir)
   call wrtout(std_out,message,'COLL')
 end do 
 
  write(message,'(a)')' Bare magnetization (mag_mmat): '  
 call wrtout(std_out,message,'COLL')
 do idir = 1, 3
   write(message,'(a,i4,a,es16.8)')'   dir = ',idir,'  mag_mmat = ',mag_mmat(idir)
   call wrtout(std_out,message,'COLL')
 end do 

 write(message,'(a)')' Chern number: '  
 call wrtout(std_out,message,'COLL')
 do idir = 1, 3
   write(message,'(a,i4,a,es16.8)')'   dir = ',idir,'  Chern = ',chern(idir)
   call wrtout(std_out,message,'COLL')
 end do 

end subroutine mag_out
!!***
