!{\src2tex{textfont=tt}}
!!****f* ABINIT/magcart
!! NAME
!! magcart
!!
!! FUNCTION
!! This routine outputs the orbital magnetization in cartesian coordinates and
!! reduced coordinates.
!!
!! COPYRIGHT
!!
!! INPUTS
!!  nkpt = number of kpoints
!!  rprimd(3,3) = dimensional primitive translations (bohr)
!!  ucvol = volume of unit cell
!!  wtk = weights of k points
!!
!! OUTPUT
!!
!! SIDE EFFECTS
!!  dtefield <type(efield_type)> orbital magnetization is stored here.
!! 
!!  dtefield%mag_cg is in reduced units
!!  dtefield%mag_cart is in cartesian units and divided by ucvol
!!
!! NOTES
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine magcart(dtefield,nkpt,rprimd,ucvol,wtk)

 use defs_basis
 use defs_datatypes

#if defined HAVE_MPI && defined HAVE_MPI2
 use mpi
#endif

 implicit none

#if defined HAVE_MPI && defined HAVE_MPI1
 include 'mpif.h'
#endif

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: nkpt
 real(dp),intent(in) :: ucvol
 type(efield_type),intent(inout) :: dtefield
!arrays
 real(dp),intent(in) :: rprimd(3,3),wtk(nkpt)

!Local variables-------------------------------
!scalars
 integer :: iband,idir,ikpt
 real(dp) :: intfac1, intfac2
!arrays
 real(dp) :: mag_loc(3), mag_mmat(3)
 real(dp) :: mag_tot(3)

! ************************************************************************

 mag_loc(:) = zero
 mag_mmat(:) = zero

 intfac1 = -1.0/(Sp_Lt) ! -2.0/(2.0*c), where the numerator is the band occupation
 intfac2 = -1.0/(Sp_Lt*ucvol) ! -2.0/(2.0*Sp_Lt*two_pi^3) * Omega_BZ, where again
!the first factor of 2.0 is the band occupation and the Omega_BZ comes from converting 
!the integral to a sum

 do idir = 1, 3
   do ikpt = 1, nkpt
     mag_loc(idir) = mag_loc(idir) + wtk(ikpt)*dtefield%mag_local_k(idir,ikpt)
   end do ! end loop over ikpt
 end do ! end loop over idir

 mag_loc(:) = mag_loc(:)*intfac1
 
 do ikpt =1, nkpt
   do iband = 1, dtefield%nband_occ
     mag_mmat(1) = mag_mmat(1) + & 
&     0.5*wtk(ikpt)*(dtefield%mmat(2,iband,iband,ikpt,2,1,3)/abs(dtefield%dkvecs(2,2)) - &
&     dtefield%mmat(2,iband,iband,ikpt,2,2,3)/abs(dtefield%dkvecs(2,2)) - &
&     dtefield%mmat(2,iband,iband,ikpt,3,1,2)/abs(dtefield%dkvecs(3,3)) + &
&     dtefield%mmat(2,iband,iband,ikpt,3,2,2)/abs(dtefield%dkvecs(3,3)))
     mag_mmat(2) = mag_mmat(2) + & 
&     0.5*wtk(ikpt)*(dtefield%mmat(2,iband,iband,ikpt,3,1,1)/abs(dtefield%dkvecs(3,3)) - &
&     dtefield%mmat(2,iband,iband,ikpt,3,2,1)/abs(dtefield%dkvecs(3,3)) - &
&     dtefield%mmat(2,iband,iband,ikpt,1,1,3)/abs(dtefield%dkvecs(1,1)) + &
&     dtefield%mmat(2,iband,iband,ikpt,1,2,3)/abs(dtefield%dkvecs(1,1)))
     mag_mmat(3) = mag_mmat(3) + & 
&     0.5*wtk(ikpt)*(dtefield%mmat(2,iband,iband,ikpt,1,1,2)/abs(dtefield%dkvecs(1,1)) - &
&     dtefield%mmat(2,iband,iband,ikpt,1,2,2)/abs(dtefield%dkvecs(1,1)) - &
&     dtefield%mmat(2,iband,iband,ikpt,2,1,1)/abs(dtefield%dkvecs(2,2)) + &
&     dtefield%mmat(2,iband,iband,ikpt,2,2,1)/abs(dtefield%dkvecs(2,2)))
   end do ! end loop over iband
 end do ! end loop over kpts

 mag_tot(:) = mag_loc(:) + intfac2*mag_mmat

 dtefield%mag_cg(:) = mag_tot(:)

 do idir = 1, 3
   dtefield%mag_cart(idir) =  rprimd(idir,1)*mag_tot(1) + rprimd(idir,2)*mag_tot(2) + &
&   rprimd(idir,3)*mag_tot(3)
 end do
 dtefield%mag_cart(:) = dtefield%mag_cart(:)/ucvol

end subroutine magcart
!!***
