!{\src2tex{textfont=tt}}
!!****f* ABINIT/mlwfovlp_proj
!! NAME
!! mlwfovlp_proj
!!
!! FUNCTION
!! Routine which computes projection A_{mn}(k)
!! for Wannier code (www.wannier.org f90 version).
!!
!! COPYRIGHT
!! Copyright (C) 2005-2010 ABINIT group (BAmadon,FJollet,TRangel,drh)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!!  cg(2,mpw*nspinor*mband*mkmem*nsppol)=planewave coefficients of wavefunctions
!!  cprj(natom,nspinor*mband*mkmem*nsppol)= <p_lmn|Cnk> coefficients for each WF |Cnk>
!!                                          and each |p_lmn> non-local projector
!!  dtset <type(dataset_type)>=all input variables for this dataset
!!  kg(3,mpw*mkmem)=reduced planewave coordinates.
!!  lproj= flag 0: no projections, 1: random projections,
!!              2: projections on atomic orbitals
!!              3: projections on projectors
!!  mband=maximum number of bands
!!  mkmem =number of k points which can fit in memory; set to 0 if use disk
!!  npwarr(nkpt)=number of planewaves in basis at this k point
!!  mpi_enreg=informations about MPI parallelization
!!  mpw=maximum dimensioned size of npw.
!!  natom=number of atoms in cell.
!!  nattyp(ntypat)= # atoms of each type.
!!  nkpt=number of k points.
!!  nspinor=number of spinorial components of the wavefunctions
!!  nsppol=1 for unpolarized, 2 for spin-polarized
!!  ntypat=number of types of atoms in unit cell.
!!  num_bands=number of bands actually used to construct the wannier function
!!  nwan= number of wannier fonctions (read in wannier90.win).
!!  proj_l(mband)= angular part of the projection function (quantum number l)
!!  proj_m(mband)= angular part of the projection function (quantum number m)
!!  proj_radial(mband)= radial part of the projection.
!!  proj_site(3,mband)= site of the projection.
!!  proj_x(3,mband)= x axis for the projection.
!!  proj_z(3,mband)= z axis for the projection.
!!  proj_zona(mband)= extension of the radial part.
!!  psps <type(pseudopotential_type)>=variables related to pseudopotentials
!!  seed_name=character string for generating wannier90 filenames
!!
!! OUTPUT
!!  A_matrix(num_bands,nwan,nkpt,nsppol)= Matrix of projections needed by wannier_run
!!  ( also wannier90random.amn is written)
!!
!! SIDE EFFECTS
!!  (only writing, printing)
!!
!! NOTES
!!
!! PARENTS
!!      mlwfovlp_setup
!!
!! CHILDREN
!!      (none)
!!
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

 subroutine mlwfovlp_proj(A_matrix,band_in,cg,cprj,dtset,gprimd,just_augmentation,kg,&
&lproj,mband,mkmem,mpi_enreg,mpw,natom,nattyp,&
&nkpt,npwarr,nspinor,&
&nsppol,ntypat,num_bands,nwan,pawtab,proj_l,proj_m,proj_radial,&
&proj_site,proj_x,proj_z,proj_zona,psps,seed_name,ucvol)

 use defs_basis
 use defs_datatypes
 use defs_abitypes
 use defs_wannier90

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
 use interfaces_16_hideleave
 use interfaces_28_numeric_noabirule
 use interfaces_32_util
 use interfaces_51_manage_mpi
 use interfaces_67_common, except_this_one => mlwfovlp_proj
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 complex(dpc),parameter :: c0=(0._dp,0._dp),c1=(1._dp,0._dp),ci=(0._dp,1._dp)
 integer,intent(in) :: lproj,mband,mkmem,mpw,natom,nkpt,nspinor,nsppol
 integer,intent(in) :: ntypat,num_bands,nwan
 character(len=fnlen),intent(in) :: seed_name
 type(MPI_type),intent(inout) :: mpi_enreg
 type(dataset_type),intent(in) :: dtset
 type(pseudopotential_type),intent(in) :: psps
!arrays
 integer ::nattyp(ntypat)
 integer,intent(in) :: kg(3,mpw*mkmem),npwarr(nkpt),proj_l(mband)
 integer,intent(in) :: proj_m(mband)
 integer,intent(inout)::proj_radial(mband)
 real(dp),intent(in) :: cg(2,mpw*nspinor*mband*mkmem*nsppol)
 real(dp),intent(in) :: gprimd(3,3),proj_site(3,mband)
 real(dp),intent(in) :: proj_x(3,mband),proj_z(3,mband),proj_zona(mband)
 complex(dpc),intent(out) :: A_matrix(num_bands,nwan,nkpt,nsppol)
 logical,intent(in) :: band_in(mband)
 logical,intent(in)::just_augmentation(nwan)
 type(cprj_type) :: cprj(natom,nspinor*mband*mkmem*nsppol)
 type(pawtab_type),intent(in) :: pawtab(psps%ntypat*psps%usepaw)

!Local variables-------------------------------
!scalars
 integer :: iatom,iatprjn,iband,iband1,iband2,ibg,icat,icg,icg_shift
 integer :: idum,idx,ikg,ikpt,ilmn,ipw,iproj
 integer :: ispinor,isppol,itypat,iwan,jband,jj1,libprjn,lmax,lmax2
 integer :: lmn_size,natprjn,nband_k,nbprjn,npw_k,nproj
 integer :: sumtmp
 integer :: master,nprocs,spaceComm,rank
 real(dp),parameter :: qtol=2.0d-8
 real(dp) :: arg,norm_error,norm_error_bar
 real(dp) :: ucvol,x1,x2,xnorm,xnormb,xx,yy,zz
 complex(dpc) :: amn_tmp(nspinor)
 complex(dpc) :: cstr_fact
 character(len=500) :: message
 character(len=fnlen) :: filew90_win
!arrays
 integer :: kg_k(3,mpw)
 integer,allocatable :: lprjn(:),npprjn(:)
 real(dp) :: kpg(3),kpt(3)
 real(dp),allocatable :: amn(:,:,:,:),amn2(:,:,:,:,:,:,:)
 real(dp),allocatable :: gsum2(:),kpg2(:),radial(:)
 complex(dpc),allocatable :: gf(:,:),gft_lm(:)
 complex(dpc),allocatable :: ylmc_fac(:,:),ylmcp(:)

!no_abirules
!Tables 3.1 & 3.2, User guide
 integer,save :: orb_l_defs(-5:3)=(/2,2,1,1,1,0,1,2,3/) 
 integer,parameter :: mtransfo(0:3,7)=&
&  reshape((/1,0,0,0,0,0,0,1,1,1,0,0,0,0,0,-2,-1,2,1,0,0,0,-1,1,2,-2,-3,3/),(/4,7/))

!************************************************************************


!TODO AND POSSIBLE BUGS:
!MAGNETISM


!mpi initialization
 call xcomm_init  (MPI_enreg,spaceComm) 
 call xmaster_init(MPI_enreg,master   )  
 call xme_init    (MPI_enreg,rank     )          
 call xproc_init(MPI_enreg,nprocs)
!write(*,'("master ",i3," rank ",i3," nprocs ",i3)') master,rank,nprocs

!Check input variables
 if ((lproj/=1).and.(lproj/=2).and.(lproj/=5)) then
   write(message, '(a,a,a,a,a,a)' ) ch10,&
&   '  mlwfovlp_proj : ERROR -',ch10,&
&   '  Value of lproj no allowed ',ch10,&
&   '  Action : change lproj.'
   call wrtout(std_out,  message,'COLL')
   call leave_new('COLL')
 end if
 filew90_win=trim(seed_name)//'.win'

 write(message, '(a,a)' )ch10,&
& '** mlwfovlp_proj:  compute A_matrix of initial guess for wannier functions'
 call wrtout(std_out,message,'COLL')

!Initialize to 0.d0
 A_matrix(:,:,:,:)=cmplx(0.d0,0.d0)


!
!End of preliminarities
!

!********************* Write Random projectors
 if(lproj==1) then
   idum=123456
!  Compute random projections
   allocate(amn(2,mband,nwan,nkpt))
   do isppol=1,nsppol
     amn=zero
     do ikpt=1,nkpt
!      
!      MPI: cycle over kpts not treated by this node
!      
       if ( mpi_enreg%paral_compil_kpt==1) then
         if (ABS(MPI_enreg%proc_distrb(ikpt,1,isppol)-rank)/=0) CYCLE
!        write(*,'("kpt loop2: ikpt",i3," rank ",i3)') ikpt,rank
       end if
!      
       do iband1=1,mband
         xnormb=0.d0
         do iband2=1,nwan
           x1=uniformrandom(idum)
           x2=uniformrandom(idum)
           xnorm=sqrt(x1**2+x2**2)
           xnormb=xnormb+xnorm
           amn(1,iband1,iband2,ikpt)=x1
           amn(2,iband1,iband2,ikpt)=x2
         end do
         do iband2=1,nwan
           amn(1,iband1,iband2,ikpt)=amn(1,iband1,iband2,ikpt)/xnormb
           amn(2,iband1,iband2,ikpt)=amn(1,iband1,iband2,ikpt)/xnormb
         end do !iband2
       end do !iband1
     end do !ikpt
   end do !isppol
   do isppol=1,nsppol
     do ikpt=1,nkpt
!      
!      MPI: cycle over kpts not treated by this node
!      
       if ( mpi_enreg%paral_compil_kpt==1) then
         if (ABS(MPI_enreg%proc_distrb(ikpt,1,isppol)-rank)/=0) CYCLE
       end if
!      
       do iband2=1,nwan
         jband=0
         do iband1=1,mband
           if(band_in(iband1)) then
             jband=jband+1
             if(jband.gt.num_bands) then
               write(message, '(a,a,a,a,a,a)' ) ch10,&
&               '  mlwfovlp_proj : ERROR -',ch10,&
&               '  Value of jband is above num_bands ',ch10,&
&               '  Action : contact Abinit group'
               call wrtout(std_out,  message,'COLL')
               call leave_new('COLL')
             end if
             A_matrix(jband,iband2,ikpt,isppol)=cmplx(amn(1,iband1,iband2,ikpt),amn(2,iband1,iband2,ikpt))
           end if
         end do !iband1
       end do !iband2
     end do !ikpt
   end do !isppol
   deallocate(amn)
 end if

!********************* Projection on atomic orbitals based on .win file
 if( lproj==2) then !based on .win file
   nproj=nwan/nspinor !if spinors, then the number of projections are 
!  half the total of wannier functions
!  
!  obtain lmax and lmax2
   lmax=0
   do iproj=1,nproj
     lmax=max(lmax,orb_l_defs(proj_l(iproj)))
   end do !iproj
   lmax2=(lmax+1)**2

!  Allocate arrays

   allocate(ylmc_fac(lmax2,nproj),ylmcp(lmax2))

!  get ylmfac, factor used for rotations and hybrid orbitals
   call mlwfovlp_ylmfac(ylmc_fac,lmax,lmax2,mband,nproj,proj_l,proj_m,proj_x,proj_z)

!  Allocate arrays
   allocate(gf(mpw,nproj),gft_lm(lmax2),gsum2(nproj))
   allocate(kpg2(mpw),radial(lmax2))

   norm_error=zero
   norm_error_bar=zero
   icg=0

   do isppol=1,nsppol
     ikg=0

     do ikpt=1, nkpt
!      
!      MPI: cycle over kpts not treated by this node
!      
       if ( mpi_enreg%paral_compil_kpt==1) then
         if (ABS(MPI_enreg%proc_distrb(ikpt,1,isppol)-rank)/=0) CYCLE
       end if
!      
       write(message, '(a,i6,a,2i6)' ) &
&       '   processor',rank,' will compute k-point,spin=',ikpt,isppol
!      write(*,*)trim(message)
       call wrtout(std_out,  message,'COLL')

!      Initialize variables
       npw_k=npwarr(ikpt)
       gsum2(:)=0.d0
       gf(:,:) = (0.d0,0.d0)
       kpt(:)=dtset%kpt(:,ikpt)
       kg_k(:,1:npw_k)=kg(:,1+ikg:npw_k+ikg)

       do ipw=1, npw_k
         kpg(1)= (kpt(1) + real(kg_k(1,ipw),dp))     !k+G
         kpg(2)= (kpt(2) + real(kg_k(2,ipw),dp))
         kpg(3)= (kpt(3) + real(kg_k(3,ipw),dp))

!        Calculate modulus of k+G
         xx=gprimd(1,1)*kpg(1)+gprimd(1,2)*kpg(2)+gprimd(1,3)*kpg(3)
         yy=gprimd(2,1)*kpg(1)+gprimd(2,2)*kpg(2)+gprimd(2,3)*kpg(3)
         zz=gprimd(3,1)*kpg(1)+gprimd(3,2)*kpg(2)+gprimd(3,3)*kpg(3)
         kpg2(ipw)= two_pi*sqrt(xx**2+yy**2+zz**2)

!        Complex Y_lm for k+G
         if(lmax==0) then
           ylmcp(1)=c1/sqrt(four_pi)
         else
           call ylm_cmplx(lmax,ylmcp,xx,yy,zz)
         end if

         do iproj=1,nproj
!          
!          In PAW, we can use proj_radial > 4 to indicate that we just 
!          want the in-sphere contribution
!          
           if( psps%usepaw==1) then
             if( just_augmentation(iproj)) cycle
           end if
!          
!          obtain radial part
           call mlwfovlp_radial(proj_zona(iproj),lmax,lmax2,radial,proj_radial(iproj)&
&           ,kpg2(ipw))

!          scale complex representation of projector orbital with radial functions
!          of appropriate l
           gft_lm(:)=radial(:)*ylmc_fac(:,iproj)

!          complex structure factor for projector orbital position
           arg = ( kpg(1)*proj_site(1,iproj) + kpg(2)*proj_site(2,iproj) + &
&           kpg(3)*proj_site(3,iproj) ) * 2*pi
           cstr_fact = cmplx(cos(arg), -sin(arg) )

!          obtain guiding functions
           gf(ipw,iproj)=cstr_fact*dot_product(ylmcp(:),gft_lm)

           gsum2(iproj)=gsum2(iproj)+real(gf(ipw,iproj))**2+aimag(gf(ipw,iproj))**2
         end do !iproj
       end do !ipw

       do iproj=1,nproj
!        
!        In PAW, we can use proj_radial > 4 to indicate that we just 
!        want the in-sphere contribution
!        
         if(psps%usepaw==1 ) then
           if (just_augmentation(iproj)) cycle
         end if
!        
         gsum2(iproj)=16._dp*pi**2*gsum2(iproj)/ucvol
         gf(:,iproj)=gf(:,iproj)/sqrt(gsum2(iproj))
         norm_error=max(abs(gsum2(iproj)-one),norm_error)
         norm_error_bar=norm_error_bar+(gsum2(iproj)-one)**2
       end do !iproj

!      ! Guiding functions are computed.
!      compute overlaps of gaussian projectors and wave functions
       do iproj=1,nproj
!        
!        In PAW, we can use proj_radial > 4 to indicate that we just 
!        want the in-sphere contribution
!        
         if(psps%usepaw==1 ) then
           if ( just_augmentation(iproj)) cycle
         end if
!        
         jband=0
         do iband=1,mband
           if(band_in(iband)) then
             icg_shift=npw_k*nspinor*(iband-1)+icg
             jband=jband+1
             amn_tmp(:)=cmplx(0.d0,0.d0)
             do ispinor=1,nspinor
               do ipw=1,npw_k
!                
!                The case of spinors is tricky, we have nproj =  nwan/2
!                so we project to spin up and spin down separately, to have at 
!                the end an amn matrix with nwan projections.
!                
!                idx=ipw*nspinor - (nspinor-ispinor)
                 idx=ipw+(ispinor-1)*npw_k
                 amn_tmp(ispinor)=amn_tmp(ispinor)+gf(ipw,iproj)*cmplx(cg(1,idx+icg_shift),-cg(2,idx+icg_shift))
               end do !ipw
             end do !ispinor
             do ispinor=1,nspinor
               iwan=(iproj*nspinor)- (nspinor-ispinor)
               A_matrix(jband,iwan,ikpt,isppol)=amn_tmp(ispinor)
             end do
           end if !band_in
         end do !iband
       end do !iproj
       icg=icg+npw_k*nspinor*mband
       ikg=ikg+npw_k
     end do !ikpt
   end do !isppol

   norm_error_bar=sqrt(norm_error_bar/real(nkpt*nwan,dp))
   if(norm_error>0.05_dp) then
     write(message, '(6a,f6.3,a,f6.3,12a)' )ch10,&
&     ' mlwfovlp_proj : WARNING',ch10,&
&     '  normalization error for wannier projectors',ch10,&
&     '  is',norm_error_bar,' (average) and',norm_error,' (max).',ch10,&
&     '  this may indicate more cell-to-cell overlap of the radial functions',ch10,&
&     '  than you want.',ch10,&
&     '  Action : modify zona (inverse range of radial functions)',ch10,&
     '  under "begin projectors" in ',trim(filew90_win),' file',ch10
     call wrtout(std_out,message,'COLL')
   end if

!  Deallocations
   deallocate(gf,gft_lm,gsum2)
   deallocate(kpg2,radial)
   deallocate(ylmc_fac,ylmcp)
 end if !lproj==2


!*************** computes projection  from PROJECTORS ********************
 if(lproj==3) then  !! if LPROJPRJ
!  ----- set values for projections --------------------- ! INPUT
!  nbprjn:number of  different l-values for projectors
!  lprjn: value of l for each projectors par ordre croissant
!  npprjn: number of projectors for each lprjn
   natprjn=1  ! atoms with wannier functions are first
   if(natprjn/=1) then ! in this case lprjn should depend on iatprjn
     stop
   end if
   nbprjn=2
   allocate(lprjn(nbprjn))
   lprjn(1)=0
   lprjn(2)=1
   allocate(npprjn(0:lprjn(nbprjn)))
   npprjn(0)=1
   npprjn(1)=1
!  --- test coherence of nbprjn and nwan
   sumtmp=0
   do iatprjn=1,natprjn
     do libprjn=0,lprjn(nbprjn)
       sumtmp=sumtmp+(2*libprjn+1)*npprjn(libprjn)
     end do
   end do
   if(sumtmp/=nwan) then
     write(6,*) "Number of Wannier orbitals is not equal to number of projections"
     write(6,*) "Action: check values of lprjn,npprjn % nwan"
     write(6,*) "nwan, sumtmp=",nwan,sumtmp
     stop
   end if
!  --- end test of coherence
   allocate(amn2(2,natom,nsppol,nkpt,mband,nspinor,nwan))
   if(psps%usepaw==1) then
     amn2=zero
     ibg=0
     do isppol=1,nsppol
       do ikpt=1,nkpt
         nband_k=dtset%nband(ikpt+(isppol-1)*nkpt)
         do iband=1,nband_k
!          write(6,*)"amn2",iband,ibg,ikpt
           do ispinor=1,nspinor
             icat=1
             do itypat=1,dtset%ntypat
               lmn_size=pawtab(itypat)%lmn_size
               do iatom=icat,icat+nattyp(itypat)-1
                 jj1=0
                 do ilmn=1,lmn_size
                   if(iatom.le.natprjn) then
!                    do iwan=1,nwan
                     do libprjn=0,lprjn(nbprjn)
!                      if (psps%indlmn(1,ilmn,itypat)==proj_l(iwan)) then
!                      if (psps%indlmn(2,ilmn,itypat)==mtransfo(proj_l(iwan),proj_m(iwan))) then
                       if (psps%indlmn(1,ilmn,itypat)==libprjn) then
                         if (psps%indlmn(3,ilmn,itypat)<=npprjn(libprjn)) then
                           if(band_in(iband)) then
                             jj1=jj1+1
                             if(jj1>nwan) then
                               write(6,*) "number of wannier orbitals is lower than lmn_size"
                               write(6,*) jj1,nwan
                               stop
                             end if
                             amn2(1,iatom,isppol,ikpt,iband,ispinor,jj1)=cprj(iatom,iband+ibg)%cp(1,ilmn)
                             amn2(2,iatom,isppol,ikpt,iband,ispinor,jj1)=cprj(iatom,iband+ibg)%cp(2,ilmn)
                           end if
                         end if
                       end if
                     end do ! libprjn
!                    endif
!                    endif
!                    enddo ! iwan
                   end if ! natprjn
                 end do !ilmn
               end do ! iatom
               icat=icat+nattyp(itypat)
             end do ! itypat
           end do ! ispinor
         end do !iband
         ibg=ibg+nband_k*nspinor
!        write(6,*)'amn2b',iband,ibg,ikpt
       end do !ikpt
     end do ! isppol

!    -----------------------  Save Amn   --------------------
     do isppol=1,nsppol
       do ikpt=1,nkpt
         do iband2=1,nwan
           jband=0
           do iband1=1,mband
             if(band_in(iband1)) then
               jband=jband+1
               A_matrix(jband,iband2,ikpt,isppol)=&
&               cmplx(amn2(1,1,1,ikpt,iband1,1,iband2),amn2(2,1,1,ikpt,iband1,1,iband2))
             end if
           end do
         end do
       end do
     end do
   end if !usepaw
   deallocate(amn2)
   deallocate(npprjn,lprjn)

 end if ! lproj==3


end subroutine mlwfovlp_proj
!!***
