!{\src2tex{textfont=tt}}
!!****f* ABINIT/mlwfovlp_seedname
!! NAME
!! mlwfovlp_seedname
!!
!! FUNCTION
!! Get seed name and file names of all wannier90 related files
!!
!! COPYRIGHT
!!  Copyright (C) 2009-2010 ABINIT group (T Rangel, DRH)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!! fname_w90=root name of file appended with _w90
!!
!! OUTPUT
!! filew90_win= main input file for Wannier90
!! filew90_wout= main output file for Wannier90
!! filew90_amn= file containing Amn matrix
!! filew90_ramn= file containing Amn matrix (random initial projections)
!! filew90_mmn= file containing Mmn matrix
!! filew90_eig= file containing eigenvalues
!! nsppol= number of spin polarizations
!! seed_name= common seed name for all wannier90 related files
!!
!! SIDE EFFECTS
!!
!! NOTES
!!
!! PARENTS
!!  Will be filled automatically by the parent script
!!
!! CHILDREN
!!  Will be filled automatically by the parent script
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine mlwfovlp_seedname(fname_w90,filew90_win,filew90_wout,filew90_amn,&
& filew90_ramn,filew90_mmn,filew90_eig,nsppol,seed_name)
    
 use defs_basis
 use defs_datatypes

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
!End of the abilint section

 implicit none

!Arguments ------------------------------------
 integer,intent(in) :: nsppol
 character(len=fnlen),intent(out) :: filew90_win,filew90_wout,filew90_amn(nsppol),filew90_ramn
 character(len=fnlen),intent(out) :: filew90_mmn(nsppol),filew90_eig(nsppol),seed_name
 character(len=fnlen),intent(in) :: fname_w90

!Local variables-------------------------------
 character(len=fnlen) :: test_win1,test_win2,test_win3
 logical :: lfile
 character(len=500) :: message                   ! to be uncommented, if needed
 
! *************************************************************************
 
!DEBUG
!write (std_out,*) ' mlwfovlp_seedname : enter'
!ENDDEBUG

!DEBUG                                           ! to be uncommented, if needed
!if(option/=1 .and. option/=2 )then
!write(message,'(a,a,a,a,a,a,i6)') ch10,&
!&  ' mlwfovlp_seedname: BUG -',ch10,&
!&  '  The argument option should be 1 or 2,',ch10,&
!&  '  however, option=',option
!call wrtout(std_out,message,'COLL')
!call leave_new('COLL')
!endif
!if(sizein<1)then
!write(message,'(a,a,a,a,a,a,i6)') ch10,&
!&  ' mlwfovlp_seedname: BUG -',ch10,&
!&  '  The argument sizein should be a positive number,',ch10,&
!&  '  however, sizein=',sizein
!call wrtout(std_out,message,'COLL')
!call leave_new('COLL')
!endif
!ENDDEBUG

 seed_name=trim(fname_w90)
 filew90_win=trim(seed_name)//'.win'
 test_win1=filew90_win
 inquire(file=filew90_win,exist=lfile)

 if(.not.lfile) then
   seed_name='wannier90'
   filew90_win=trim(seed_name)//'.win'
   test_win2=filew90_win
   inquire(file=filew90_win,exist=lfile)
 end if

 if(.not.lfile) then
   seed_name='w90'
   filew90_win=trim(seed_name)//'.win'
   test_win3=filew90_win
   inquire(file=filew90_win,exist=lfile)
 end if

 if(.not.lfile) then
   write(message,'(17a)')ch10,&
&   ' mlwfovlp_seedname : ERROR - ',ch10,&
&   ' wannier90 interface needs one of the following files:',ch10,&
&   '      ',trim(test_win1),ch10,&
&   '      ',trim(test_win2),ch10,&
&   '      ',trim(test_win3),ch10,&
&   ' Action: read wannier90 tutorial and/or user manual',ch10,&
&   '  and supply proper *.win file'
   call wrtout(std_out,message,'COLL') ; call leave_new('COLL')
 end if

 filew90_win=trim(seed_name)//'.win'
 filew90_wout=trim(seed_name)//'.wout'
 filew90_ramn=trim(seed_name)//'random.amn'


!Files having different names for
!different spin polarizations
 if(nsppol==1) then
   filew90_amn(1)=trim(seed_name)//'.amn'
   filew90_mmn(1)=trim(seed_name)//'.mmn'
   filew90_eig(1)=trim(seed_name)//'.eig'
 elseif(nsppol==2) then
   filew90_amn(1)=trim(seed_name)//'_up.amn'
   filew90_amn(2)=trim(seed_name)//'_down.amn'
!  
   filew90_mmn(1)=trim(seed_name)//'_up.mmn'
   filew90_mmn(2)=trim(seed_name)//'_down.mmn'
!  
   filew90_eig(1)=trim(seed_name)//'_up.eig'
   filew90_eig(2)=trim(seed_name)//'_down.eig'
 end if

!End file-name section

 write(message, '(a,a)' ) ch10,&
& '---------------------------------------------------------------'
 call wrtout(ab_out,message,'COLL')
 call wrtout(std_out,  message,'COLL')
 write(message, '(16a)' ) ch10,&
& '  Calculation of overlap and call to wannier90 library ',ch10,&
& '  to obtain maximally localized wannier functions ',ch10,&
& '  - ',trim(filew90_win),' is a mandatory secondary input',ch10,&
& '  - ',trim(filew90_wout),' is the output for the library',ch10,&
& '  - ',trim(filew90_ramn),' contains random projections'

 call wrtout(std_out,  message,'COLL')
 call wrtout(ab_out,message,'COLL')

 if(nsppol==1) then
   write(message, '(11a)' ) &
&   '  - ',trim(filew90_amn(1)),' contains projections',ch10,&
&   '  - ',trim(filew90_mmn(1)),' contains the overlap',ch10,&
&   '  - ',trim(filew90_eig(1)),' contains the eigenvalues'
 elseif(nsppol==2) then
   write(message, '(24a)' ) & 
&   '  - ',trim(filew90_amn(1)),' and ',ch10,&
&   '  - ',trim(filew90_amn(2)),' contain the projections',ch10,&
&   '  - ',trim(filew90_mmn(1)),' and ',ch10,&
&   '  - ',trim(filew90_mmn(2)),' contain the overlap',ch10,&
&   '  - ',trim(filew90_eig(1)),' and ',ch10,&
&   '  - ',trim(filew90_eig(2)),' contain the eigenvalues',ch10
 end if

 call wrtout(std_out,  message,'COLL')
 call wrtout(ab_out,message,'COLL')

 write(message, '(a,a)' ) ch10,&
& '---------------------------------------------------------------'
 call wrtout(ab_out,message,'COLL')
 call wrtout(std_out,  message,'COLL')


!DEBUG
!write (std_out,*) ' mlwfovlp_seedname : exit'
!stop
!ENDDEBUG

end subroutine mlwfovlp_seedname
!!***


