!{\src2tex{textfont=tt}}
!!****m* ABINIT/m_self
!! NAME
!!  m_self
!!
!! FUNCTION
!!
!! COPYRIGHT
!! Copyright (C) 2006-2010 ABINIT group (BAmadon)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"

MODULE m_self

 use defs_basis
 use defs_datatypes
 use m_xmpi

 use m_oper, only : oper_type
 use m_matlu, only : matlu_type

 implicit none

 private 

 public :: alloc_self
 public :: initialize_self
 public :: destroy_self
 public :: nullify_self
 public :: print_self
 public :: rw_self
 public :: dc_self
 public :: new_self

!!***

!!****t* m_self/self_type
!! NAME
!!  self_type
!!
!! FUNCTION
!!  This structured datatype contains the necessary data
!!
!! SOURCE

 type, public :: self_type ! for each atom

  integer :: dmft_nwlo
  ! dmft frequencies

  character(len=4) :: w_type
  ! type of frequencies used

  integer :: nw
  ! dmft frequencies

  integer :: iself_cv
  ! integer for self convergence

  integer :: dmft_nwli
  ! dmft frequencies

  real(dp), pointer :: omega(:)
  ! value of frequencies

  type(oper_type), pointer :: oper(:)
  ! self function  in different basis

  type(oper_type):: hdc
  ! self function  in different basis

 end type self_type
!!***

!----------------------------------------------------------------------


CONTAINS  !========================================================================================
!!***

!!****f* m_self/alloc_self
!! NAME
!! alloc_self
!!
!! FUNCTION
!!  Allocate variables used in type self_type.
!!
!! INPUTS
!!  self <type(self_type)>= variables related to self-energy
!!  paw_dmft <type(paw_dmft_type)> =  variables related to self-consistent LDA+DMFT calculations.
!!  opt_oper = 1  Allocate only quantities in the KS basis.
!!             2  Allocate only quantities in the local basis.
!!             3  Allocate quantities in both the KS and local basis.
!!  wtype = "real" Self energy will be computed for real frequencies
!!        = "imag" Self energy will be computed for imaginary frequencies
!!
!! OUTPUTS
!!  self <type(self_type)>= variables related to self-energy
!!
!! PARENTS
!!      m_self
!!
!! CHILDREN
!!      wrtout
!!
!! SOURCE

subroutine alloc_self(self,paw_dmft,opt_oper,wtype)

 use defs_basis
 use defs_datatypes
 use defs_abitypes
 use m_crystal, only : crystal_structure
 use m_oper, only : init_oper,nullify_oper
 use m_paw_dmft, only: paw_dmft_type

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
!type
 type(self_type), intent(inout) :: self
 type(paw_dmft_type), intent(in) :: paw_dmft
 integer, optional, intent(in) :: opt_oper
 character(len=4), optional :: wtype
!local variables ------------------------------------
 integer :: ifreq,optoper

!************************************************************************
 if(present(opt_oper)) then
   optoper=opt_oper
 else
   optoper=3
 endif
 if(present(wtype)) then
   self%w_type=wtype
 else
   self%w_type="imag"
 endif
 if(self%w_type=="imag") then
   self%nw=paw_dmft%dmft_nwlo
   self%omega=>paw_dmft%omega_lo
 else if(self%w_type=="real") then
   self%nw=2*paw_dmft%dmft_nwr
   self%omega=>paw_dmft%omega_r
 endif

 self%dmft_nwlo=paw_dmft%dmft_nwlo
 self%dmft_nwli=paw_dmft%dmft_nwli
 self%iself_cv=0
 
 call nullify_oper(self%hdc)
 call init_oper(paw_dmft,self%hdc,opt_ksloc=optoper)
 nullify(self%oper)
 allocate(self%oper(self%nw))
 do ifreq=1,self%nw
  call nullify_oper(self%oper(ifreq))
  call init_oper(paw_dmft,self%oper(ifreq),opt_ksloc=optoper)
 enddo

end subroutine alloc_self
!!***

!!****f* m_self/initialize_self
!! NAME
!! initialize_self
!!
!! FUNCTION
!!  Initialize self-energy.
!!
!! INPUTS
!!  cryst_struc <type(crystal_structure)>=variables related to crystal structure 
!!  self <type(self_type)>= variables related to self-energy
!!  paw_dmft <type(paw_dmft_type)> =  variables related to self-consistent LDA+DMFT calculations.
!!  opt_read =  not used for the moment 
!!  wtype = "real" Self energy will be computed for real frequencies
!!        = "imag" Self energy will be computed for imaginary frequencies
!!
!! OUTPUTS
!!  self <type(self_type)>= variables related to self-energy
!! 
!!
!! PARENTS
!!      dmft_solve,spectral_function
!!
!! CHILDREN
!!      wrtout
!!
!! SOURCE

subroutine initialize_self(self,paw_dmft,wtype)

 use defs_basis
 use defs_datatypes
 use defs_abitypes
 use m_crystal, only : crystal_structure
 use m_oper, only : init_oper,loc_oper
 use m_matlu, only : print_matlu
 use m_paw_dmft, only: paw_dmft_type

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
!type
 type(self_type), intent(inout) :: self
 type(paw_dmft_type), intent(inout) :: paw_dmft
 character(len=4), optional, intent(in) :: wtype
!local variables ------------------------------------
! character(len=500) :: message
 integer :: iatom,ifreq
 character(len=4) :: wtype2
!************************************************************************
 if(present(wtype)) then
   wtype2=wtype
 else
   wtype2="imag"
 endif

 
 call alloc_self(self,paw_dmft,opt_oper=2,wtype=wtype2) !  opt_oper=1 is not useful and not implemented
 do ifreq=1,self%nw
   do iatom=1,paw_dmft%natom
     self%oper(ifreq)%matlu(iatom)%mat=czero
   enddo
 enddo
! if(paw_dmft%dmft_rslf==1.and.opt_read==1) then
!   call rw_self(cryst_struc,self,mpi_enreg,paw_dmft,pawtab,pawprtvol=2,opt_rw=1)
! endif
! write(message,'(a,a)') ch10,"   Self-energy for large frequency is"
! call wrtout(std_out,message,'COLL')
! call print_matlu(self%oper(paw_dmft%dmft_nwlo)%matlu,  &
!&                 paw_dmft%natom,3)

end subroutine initialize_self
!!***

!!****f* m_self/nullify_self
!! NAME
!! nullify_self
!!
!! FUNCTION
!!  nullify self
!!
!! INPUTS
!!  cryst_struc <type(crystal_structure)>=variables related to crystal structure 
!!  self <type(self_type)>= variables related to self-energy
!!
!! OUTPUT
!!  self <type(self_type)>= variables related to self-energy
!!
!! PARENTS
!!      m_self
!!
!! CHILDREN
!!      wrtout
!!
!! SOURCE

subroutine nullify_self(self)

 use defs_basis
 use m_crystal, only : crystal_structure
 use m_oper, only : nullify_oper

 implicit none

!Arguments ------------------------------------
!scalars
 type(self_type),intent(inout) :: self

!*********************************************************************
 nullify(self%oper)


end subroutine nullify_self
!!***

!!****f* m_self/destroy_self
!! NAME
!! destroy_self
!!
!! FUNCTION
!!  deallocate self
!!
!! INPUTS
!!  self <type(self_type)>= variables related to self-energy
!!
!! OUTPUT
!!
!! PARENTS
!!      dmft_solve,spectral_function
!!
!! CHILDREN
!!      wrtout
!!
!! SOURCE

subroutine destroy_self(self)

 use defs_basis
 use m_crystal, only : crystal_structure
 use m_oper, only : destroy_oper,nullify_oper

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 type(self_type),intent(inout) :: self

!local variables-------------------------------
 integer :: ifreq

! *********************************************************************
 do ifreq=1,self%nw
  call destroy_oper(self%oper(ifreq))
  call nullify_oper(self%oper(ifreq))
 enddo
 if ( associated(self%oper))      deallocate(self%oper)
 call nullify_self(self)

 call destroy_oper(self%hdc)
 call nullify_oper(self%hdc)

end subroutine destroy_self
!!***

!!****f* m_self/print_self
!! NAME
!! print_self
!!
!! FUNCTION
!!  print occupations
!!
!! INPUTS
!!  self <type(self_type)>= variables related to self-energy
!!  option = 1 Do not print double counting.
!!           2 Print double counting
!!  paw_dmft <type(paw_dmft_type)> =  variables related to self-consistent LDA+DMFT calculations.
!!  prtopt = integer which precises the amount of printing in the subroutine called 
!!
!! OUTPUT
!!  self <type(self_type)>= variables related to self-energy
!!
!! PARENTS
!!      dmft_solve
!!
!! CHILDREN
!!      wrtout
!!
!! SOURCE

subroutine print_self(self,prtdc,paw_dmft,prtopt)

 use defs_basis
 use m_oper, only : print_oper
 use m_paw_dmft, only : paw_dmft_type
 use m_matlu, only : print_matlu

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!type
 type(paw_dmft_type), intent(in) :: paw_dmft
 type(self_type),intent(in) :: self
 character(len=*), intent(in) :: prtdc
 integer,intent(in) :: prtopt


!local variables-------------------------------
 character(len=500) :: message
! *********************************************************************

 write(message,'(2a)') ch10,"  == The self-energy for smallest frequency is   == "
 call wrtout(std_out,message,'COLL')
 call print_oper(self%oper(1),1,paw_dmft,prtopt)
 write(message,'(2a)') ch10,"  == The self-energy for large frequency is   == "
 call wrtout(std_out,message,'COLL')
 call print_oper(self%oper(self%nw),1,paw_dmft,prtopt)
 if(prtdc=="print_dc") then
   write(message,'(2a)') ch10,"  == The double couting hamiltonian is (diagonal part)  == "
   call wrtout(std_out,message,'COLL')
   call print_matlu(self%hdc%matlu,paw_dmft%natom,prtopt,opt_diag=1)
 endif

end subroutine print_self
!!***

!!****f* m_hu/dc_self
!! NAME
!! dc_self
!!
!! FUNCTION
!!
!! INPUTS
!!  charge_loc(cryst_struc%natom,paw_dmft%nsppol+1)= total charge for correlated electrons on a given atom, and for spin
!!  cryst_struc <type(crystal_structure)>=variables related to crystal structure 
!!  hu <type(hu_type)>= variables related to the interaction between electrons
!!  self <type(self_type)>= variables related to self-energy
!!  opt_dc = 1 Full localized Limit double counting.
!!           2 not implemented 
!!  prtopt = integer which precises the amount of printing (not used here)
!!
!! OUTPUT
!!  self <type(self_type)>= variables related to self-energy
!!  hu <type(hu_type)>= variables related to the interaction between electrons
!!
!! PARENTS
!!      dmft_solve,spectral_function
!!
!! CHILDREN
!!      wrtout
!!
!! SOURCE

subroutine dc_self(charge_loc,cryst_struc,hu,self,opt_dc,prtopt)

 use defs_basis
 use m_crystal, only : crystal_structure
 use m_paw_dmft, only : paw_dmft_type
 use m_hu, only : hu_type

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_16_hideleave
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!type
 type(crystal_structure),intent(in) :: cryst_struc
 type(self_type),intent(inout) :: self
 real(dp), intent(in) :: charge_loc(cryst_struc%natom,self%hdc%nsppol+1)
 type(hu_type),intent(inout) :: hu(cryst_struc%ntypat)
 integer, intent(in) :: prtopt,opt_dc

!Local variables-------------------------------
 integer :: iatom,isppol,ispinor,lpawu,m1,nspinor,nsppol
 real(dp) :: ntot
! character(len=500) :: message
! *********************************************************************
 nspinor = self%hdc%nspinor
 nsppol  = self%hdc%nsppol

 if(opt_dc==1) then  ! FLL
   do iatom=1,self%hdc%natom
     lpawu=self%hdc%matlu(iatom)%lpawu
     ntot=charge_loc(iatom,nsppol+1)
!     nup=charge_loc(iatom,1)
!     ndn=charge_loc(iatom,nsppol)
     if(lpawu/=-1) then
       self%hdc%matlu(iatom)%mat=czero
       do isppol = 1 , nsppol
         do ispinor = 1 , nspinor
           do m1=1, 2*lpawu+1
             if(opt_dc==1) then
               if(nspinor==2) then
           self%hdc%matlu(iatom)%mat(m1,m1,isppol,ispinor,ispinor) =  &
&         hu(cryst_struc%typat(iatom))%upawu * ( ntot - one / two )     &
&        - one/two * hu(cryst_struc%typat(iatom))%jpawu * ( ntot - one       )
               else
           self%hdc%matlu(iatom)%mat(m1,m1,isppol,ispinor,ispinor)=  &
&         hu(cryst_struc%typat(iatom))%upawu * ( ntot - one / two ) &
&       -  hu(cryst_struc%typat(iatom))%jpawu * ( charge_loc(iatom,2-nsppol+1) - one)
               endif
             endif
           enddo  ! m1
         enddo  ! ispinor
       enddo ! isppol
     endif
   enddo ! iatom
 else
   call leave_new('COLL')
 endif

 if(prtopt>0) then
 endif


end subroutine dc_self
!!***

!!****f* m_self/write_self
!! NAME
!! write_self
!!
!! FUNCTION
!!  
!!
!! INPUTS
!!  self <type(self_type)>= variables related to self-energy
!!  mpi_enreg=informations about MPI parallelization
!!  paw_dmft  <type(paw_dmft_type)>= paw+dmft related data
!!  prtopt = integer which precises the amount of printing 
!!  opt_rw = 1  Read Self-Energy.
!!           2  Write Self-Energy.
!!
!! OUTPUT
!!
!! PARENTS
!!
!! CHILDREN
!!  xcomm_init,xme_init,int2char4,xbarrier_mpi,xcast_mpi,copy_matlu,leave_new
!!
!! SOURCE

subroutine rw_self(self,mpi_enreg,paw_dmft,prtopt,opt_rw)

 use defs_basis
 use defs_abitypes
 use m_crystal, only : crystal_structure
 use m_paw_dmft, only : paw_dmft_type
 use m_matlu, only : copy_matlu

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
 use interfaces_16_hideleave
 use interfaces_27_toolbox_oop
 use interfaces_51_manage_mpi
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!type
 type(self_type),intent(inout) :: self
 type(MPI_type), intent(inout) :: mpi_enreg
 type(paw_dmft_type), intent(inout) :: paw_dmft
 integer,intent(in) :: prtopt
 integer,intent(in),optional :: opt_rw

!local variables-------------------------------
 logical :: lexist
 complex(dpc), allocatable :: buffer(:)
 integer :: iall,iatom,ier,iexist2,ifreq,im,ioerr,ispinor,isppol
 integer :: icount,iexit,master,mbandc,myproc,natom,ncount,ndim,nkpt,nproc,nrecl,nspinor,nsppol,spacecomm
 integer :: natom_read,nsppol_read,nspinor_read,ndim_read,nw_read,optrw
 character(len=500) :: message
 integer,allocatable :: unitselffunc_arr(:)
 character(len=fnlen) :: tmpfil
 character(len=1) :: tag_is,tag_is2
 character(len=4) :: tag_at
 character(len=4) :: chtemp
 real(dp):: xtemp,fermie_read
 real(dp), allocatable:: s_r(:),s_i(:),fermie_read2(:)
! *********************************************************************

! Initialise spaceComm, myproc, and nproc
 if(present(opt_rw)) then
   optrw=opt_rw
 else
   optrw=0
 endif
 if(paw_dmft%dmft_rslf==0.and.optrw==1) optrw=0
 iexit=0
 ioerr=0
 iexist2=1
 lexist=.true.
 call xcomm_init(mpi_enreg,spacecomm)
 call xme_init(mpi_enreg,myproc)
 call xproc_init(mpi_enreg,nproc)
 call xmaster_init(mpi_enreg,master)

! write(6,*) "myproc,master",myproc,master
 if(prtopt>200) then
 endif
 natom=self%oper(1)%natom
 nsppol=paw_dmft%nsppol
 nspinor=paw_dmft%nspinor
 mbandc=paw_dmft%mbandc
 nkpt=paw_dmft%nkpt
 if(optrw==2.or.(optrw==1.and.myproc==master)) then
   allocate(unitselffunc_arr(natom*nsppol*nspinor))
   iall=0
   do iatom=1,natom
     if(self%oper(1)%matlu(iatom)%lpawu.ne.-1) then
       ndim=2*self%oper(1)%matlu(iatom)%lpawu+1
       allocate(s_r(ndim),s_i(ndim))
!       write(6,*) "print_self",ndim
       call int2char4(iatom,tag_at)
       do isppol=1,nsppol
         write(tag_is,'(i1)')isppol
         do ispinor=1,nspinor
           iall=iall+1
           write(tag_is2,'(i1)')ispinor

!          ===========================
!           == Create name for file
!          ===========================
           tmpfil = trim(paw_dmft%filapp)//'Self-omega_iatom'//tag_at//'_isppol'//tag_is//'_ispinor'//tag_is2
           if(optrw==1) write(message,'(3a)') ch10,"  == Read  self function and Fermi Level on file ",trim(tmpfil)
           if(optrw==2) write(message,'(3a)') ch10,"  == Write self function and Fermi Level on file ",trim(tmpfil)
           call wrtout(std_out,message,'COLL')
           unitselffunc_arr(iall)=300+iall-1
!           write(6,*) "1"

!          ===========================
!           == Read: check that the file exists
!          ===========================
           if(optrw==1) then
!           write(6,*) "3"
             inquire(file=trim(tmpfil),exist=lexist,recl=nrecl)
             if((.not.lexist)) then
!           write(6,*) "4"
               iexist2=0
               write(message,'(4x,a,i5,3a)') "File number",unitselffunc_arr(iall),&
&               " called ",trim(tmpfil)," does not exist"
!               write(6,*) lexist,nrecl
               call wrtout(std_out,message,'COLL')
             endif
           endif
           !write(6,*) "2"

!          ===========================
!           == Open file
!          ===========================
           if(optrw==2.or.(optrw==1.and.iexist2==1)) then
             !write(6,*) "5"
             open (unit=unitselffunc_arr(iall),file=trim(tmpfil),status='unknown',form='formatted')
             rewind(unitselffunc_arr(iall))
             !write(6,*) "61",nrecl
             if(prtopt>=3) write(message,'(a,a,a,i4)') 'opened file : ', trim(tmpfil), ' unit', unitselffunc_arr(iall)
             if(prtopt>=3)  call wrtout(std_out,message,'COLL')
           endif
           !write(6,*) "6",nrecl

!          ===========================
!           == Check Header
!          ===========================
           if(optrw==2) then
             write(message,'(3a,5i5,2x,e14.7)') "# natom,nsppol,nspinor,ndim,nw,fermilevel",ch10&
&             ,"####",natom,nsppol,nspinor,ndim,self%nw,paw_dmft%fermie
             call wrtout(unitselffunc_arr(iall),message,'COLL')
           else if(optrw==1.and.iexist2==1) then
             read(unitselffunc_arr(iall),*) 
             read(unitselffunc_arr(iall),*,iostat=ioerr)&
&              chtemp,natom_read,nsppol_read,nspinor_read,ndim_read,nw_read,fermie_read
             if(ioerr<0) then
!              write(6,*)" HEADER IOERR"
!              write(6,'(a4,2x,31(e15.8,2x))') chtemp,natom_read,nsppol_read,nspinor_read,ndim_read,nw_read,fermie_read
             endif
             if(ioerr==0) then
               write(message,'(a,3x,3a,i12,2a,i11,2a,i10,2a,i13,2a,i11,2a,e14.7)') ch10,"Data in Self file corresponds to",&
&               ch10,"     natom",natom_read,&
&               ch10,"     nsppol",nsppol_read,&
&               ch10,"     nspinor",nspinor_read,&
&               ch10,"     ndim",ndim_read, &
&               ch10,"     nw",nw_read, &
&               ch10,"     Fermi level",fermie_read 
               call wrtout(std_out,message,'COLL')
               if((natom/=natom_read).or.(nsppol_read/=nsppol).or.&
&                (nspinor/=nspinor_read).or.(nw_read/=self%nw)) then
                 write(message,'(2a)') ch10,"WARNING: Dimensions in self are not correct"
                 call wrtout(std_out,message,'COLL')
               endif
             else
               write(message,'(a,5x,a)') ch10,"WARNING: Self file is empty"
               call wrtout(std_out,message,'COLL')
             endif
           endif
           !write(6,*) "7"

!          ===========================
!           == Write/Read self in the file
!          ===========================
           do ifreq=1,self%nw
             if(optrw==2) then
!               write(6,'(a,2x,31(e15.8,2x))') &
!&              "SETEST",self%omega(ifreq),&
!&              (self%oper(ifreq)%matlu(iatom)%mat(im,im,isppol,ispinor,ispinor)&
!&               ,im=1,ndim)
               write(message,'(2x,31(e15.8,2x))') &
&              self%omega(ifreq),&
&              (self%oper(ifreq)%matlu(iatom)%mat(im,im,isppol,ispinor,ispinor)&
&               ,im=1,ndim)
               call wrtout(unitselffunc_arr(iall),message,'COLL')
!               write(6,*) unitselffunc_arr(iall)
             else if(optrw==1.and.iexist2==1.and.ioerr==0) then
           !write(6,*) "8"
!               read(unitselffunc_arr(iall),'(2x,31(e15.8,2x))',iostat=ioerr) &
!&              xtemp,(s_r(im),s_i(im),im=1,ndim)
               read(unitselffunc_arr(iall),*,iostat=ioerr) &
&              xtemp,(s_r(im),s_i(im),im=1,ndim)
               if(ioerr<0) then
!                write(6,*)" SELF IOERR"
!                write(6,'(a4,2x,31(e15.8,2x))') xtemp,(s_r(im),s_i(im),im=1,ndim)
               endif
               do im=1,ndim
                 self%oper(ifreq)%matlu(iatom)%mat(im,im,isppol,ispinor,ispinor)&
&                 =cmplx(s_r(im),s_i(im),kind=dp)
               enddo
             endif
           enddo ! ifreq
!          ===========================
!           == Write/Read hdc in the file
!          ===========================
           if(optrw==2) then
!             write(6,'(a,2x,31(e15.8,2x))') &
!&            "SETEST #dc ",(self%hdc%matlu(iatom)%mat(im,im,isppol,ispinor,ispinor),im=1,ndim)
             write(message,'(a,2x,31(e15.8,2x))') &
&            "#dc ",(self%hdc%matlu(iatom)%mat(im,im,isppol,ispinor,ispinor),im=1,ndim)
             call wrtout(unitselffunc_arr(iall),message,'COLL')
           else if(optrw==1.and.iexist2==1.and.ioerr==0) then
         !write(6,*) "8"
             read(unitselffunc_arr(iall),'(a4,2x,31(e15.8,2x))',iostat=ioerr) &
&            chtemp,(s_r(im),s_i(im),im=1,ndim)
             if(ioerr<0) then
!              write(6,*)" HDC IOERR"
!              write(6,'(a4,2x,31(e15.8,2x))') chtemp,(s_r(im),s_i(im),im=1,ndim)
             endif
             do im=1,ndim
               self%hdc%matlu(iatom)%mat(im,im,isppol,ispinor,ispinor)&
&               =cmplx(s_r(im),s_i(im),kind=dp)
             enddo
           endif
           close(unitselffunc_arr(iall))
         enddo
       enddo ! isppol
       deallocate(s_r,s_i)
     endif ! lpawu=/-1
   enddo ! iatom
   deallocate(unitselffunc_arr)
 endif ! optrw==2.or.myproc==master
! call xbarrier_mpi(spacecomm)
           !write(6,*) "9"

!  ===========================
!  == Error messages 
!  ===========================
 if(optrw==1) then
!   call xbarrier_mpi(spacecomm)
   ncount=natom*nsppol*nspinor*(self%nw+1)*(maxval(self%oper(1)%matlu(:)%lpawu)*2+1)
   !write(6,*) ncount,maxval(pawtab(:)%lpawu)*2+1
   call xcast_mpi(iexist2,master,spacecomm ,ier)
   call xcast_mpi(ioerr,master,spacecomm ,ier)
   if(iexist2==0.or.ioerr<0.or.ioerr>0) then
     write(message,'(a,4x,a)') ch10,"Warning: Self file does not exist or is incomplete"
     call wrtout(std_out,message,'COLL')
     if(iexist2==0) then
       write(message,'(4x,2a)') "File does not exist"
       call wrtout(std_out,message,'COLL')
     endif
     if(ioerr<0) then
       write(message,'(4x,2a)') "End of file reached"
       call wrtout(std_out,message,'COLL')
     endif
     if(ioerr>0) then
       write(message,'(4x,2a)') "Error during read statement"
       call wrtout(std_out,message,'COLL')
     endif
!     call leave_new('COLL')
     write(message,'(4x,a,a,5i5,2x,e14.7)') "-> Put Self-Energy Equal to double counting term"
     call wrtout(std_out,message,'COLL')
     do ifreq=1,self%nw
!       write(6,*) "before",self%oper(1)%matlu(1)%mat(1,1,1,1,1)
!       write(6,*) "before",self%hdc%matlu(1)%mat(1,1,1,1,1)
       call copy_matlu(self%hdc%matlu,self%oper(ifreq)%matlu,natom)
       do iatom=1,natom
         if(self%oper(1)%matlu(iatom)%lpawu.ne.-1) then
           ndim=2*self%oper(1)%matlu(iatom)%lpawu+1
           do isppol=1,nsppol
             do ispinor=1,nspinor
               do im=1,ndim
                 self%oper(ifreq)%matlu(iatom)%mat(im,im,isppol,ispinor,ispinor)= &
&                  self%oper(ifreq)%matlu(iatom)%mat(im,im,isppol,ispinor,ispinor)
               enddo
             enddo
           enddo
         endif
       enddo
!       write(6,*) "after",self%oper(1)%matlu(1)%mat(1,1,1,1,1)
!       write(6,*) "before",self%hdc%matlu(1)%mat(1,1,1,1,1)
     enddo
   else ! test read successfull
!   call xbarrier_mpi(spacecomm)
  
!  ===========================
!   bcast to other proc
!  ===========================
     allocate(buffer(ncount))
     allocate(fermie_read2(1))
     buffer(:)=czero
   !write(6,*) self%nw
     if(myproc==master) then
     
!               == Send read data to all process
       icount=0
       fermie_read2(1)=fermie_read
       do iatom=1,natom
         if(self%oper(1)%matlu(iatom)%lpawu.ne.-1) then
           ndim=2*self%oper(1)%matlu(iatom)%lpawu+1
           do isppol=1,nsppol
             do ispinor=1,nspinor
!               Self energy-----------
               do ifreq=1,self%nw
                 do im=1,ndim
                   icount=icount+1
                   if(icount.gt.ncount) then
                     write(message,'(2a,2i5)') ch10,"Error buffer",icount,ncount
                     call wrtout(std_out,message,'COLL')
                     iexit=1
                   endif
                   buffer(icount)=self%oper(ifreq)%matlu(iatom)%mat(im,im,isppol,ispinor,ispinor)
                 enddo
               enddo
!               Double counting-------
               do im=1,ndim
                 icount=icount+1
                 if(icount.gt.ncount) then
                   write(message,'(2a,2i5)') ch10,"Error buffer",icount,ncount
                   call wrtout(std_out,message,'COLL')
                   iexit=1
                 endif
                 buffer(icount)=self%hdc%matlu(iatom)%mat(im,im,isppol,ispinor,ispinor)
               enddo
             enddo
           enddo ! isppol
         endif ! lpawu=/-1
       enddo ! iatom
     endif
! call xcast_mpi(buffer,master,spacecomm ,ier)
!     call xsum_mpi(iexit,spacecomm ,ier)
     call xbarrier_mpi(spacecomm) 
!     if(iexit==1) call leave_new('COLL')
     call xsum_mpi(buffer,spacecomm ,ier)
     call xbarrier_mpi(spacecomm)

! bcast fermi level
   call xsum_mpi(fermie_read2,spacecomm ,ier)

     if(ier/=0) then
       write(message,'(a,a)') "error in xsum_mpi in rw_self"
       call wrtout(std_out,message,'COLL')
       call leave_new('COLL')
     endif
     paw_dmft%fermie=fermie_read2(1)
!     write(6,*) "Fermi level",paw_dmft%fermie
     icount=0
     do iatom=1,natom
       if(self%oper(1)%matlu(iatom)%lpawu.ne.-1) then
         ndim=2*self%oper(1)%matlu(iatom)%lpawu+1
         do isppol=1,nsppol
           do ispinor=1,nspinor
!             self ---------------
             do ifreq=1,self%nw
               do im=1,ndim
                 icount=icount+1
                 self%oper(ifreq)%matlu(iatom)%mat(im,im,isppol,ispinor,ispinor)=buffer(icount)
               enddo
             enddo
!             hdc  ---------------
             do im=1,ndim
               icount=icount+1
               self%hdc%matlu(iatom)%mat(im,im,isppol,ispinor,ispinor)=buffer(icount)
             enddo
           enddo
         enddo ! isppol
       endif ! lpawu=/-1
     enddo ! iatom
     deallocate(fermie_read2)
     deallocate(buffer)
   endif  ! test read successful
 endif  ! optrw==1
!   call flush(std_out)
!   call leave_new('COLL')
 if(optrw==0) then
   write(message,'(4x,a)') "-> Put Self-Energy Equal to double counting term"
   call wrtout(std_out,message,'COLL')
   do ifreq=1,self%nw
     call copy_matlu(self%hdc%matlu,self%oper(ifreq)%matlu,natom)
     do iatom=1,natom
       if(self%oper(1)%matlu(iatom)%lpawu.ne.-1) then
         ndim=2*self%oper(1)%matlu(iatom)%lpawu+1
         do isppol=1,nsppol
           do ispinor=1,nspinor
             do im=1,ndim
               self%oper(ifreq)%matlu(iatom)%mat(im,im,isppol,ispinor,ispinor)= &
&                self%oper(ifreq)%matlu(iatom)%mat(im,im,isppol,ispinor,ispinor)
             enddo
           enddo
         enddo
       endif
     enddo
   enddo
 endif

end subroutine rw_self
!!***

!!****f* m_self/new_self
!! NAME
!! new_self
!!
!! FUNCTION
!!  
!!
!! INPUTS
!!  self <type(self_type)>= variables related to self-energy
!!  self_new <type(self_type)>= variables related to the new self-energy
!!  paw_dmft  <type(paw_dmft_type)>= paw+dmft related data
!!  opt_mix not used
!!
!! OUTPUT
!!  self <type(self_type)>= variables related to mixed self-energy
!!
!! PARENTS
!!      dmft_solve
!!
!! CHILDREN
!!      wrtout
!!
!! SOURCE

subroutine new_self(self,self_new,paw_dmft,opt_mix)

 use defs_basis
 use defs_abitypes
 use m_crystal, only : crystal_structure
 use m_paw_dmft, only : paw_dmft_type
 use m_matlu, only : copy_matlu

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!type
! type(crystal_structure),intent(in) :: cryst_struc
 type(self_type),intent(inout) :: self
 type(self_type),intent(in) :: self_new
 type(paw_dmft_type), intent(in) :: paw_dmft
 integer,intent(in) :: opt_mix

!local variables-------------------------------
 integer :: iatom,icount,ifreq,im,im1,ispinor,isppol,ispinor1
 integer :: natom,ndim,nspinor,nsppol
 real(dp) :: alpha,diff_self,sum_self
 complex(dpc) :: s1,s2
 character(len=500) :: message
! *********************************************************************
 natom=self%hdc%natom
 nsppol=paw_dmft%nsppol
 nspinor=paw_dmft%nspinor
 alpha=paw_dmft%dmft_mxsf

 if(opt_mix==1) then
 endif
 sum_self=zero
 diff_self=zero
 icount=0
 do iatom=1,natom
   if(self%oper(1)%matlu(iatom)%lpawu.ne.-1) then
     ndim=2*self%oper(1)%matlu(iatom)%lpawu+1
     do isppol=1,nsppol
       do ispinor=1,nspinor
         do ispinor1=1,nspinor
           do im=1,ndim
             do im1=1,ndim
               do ifreq=1,self%nw
!  warning: self_new is the recent self-energy, which is mixed with self
!  to give self= mixed self energy. self_new is deallocated just after.
                 self%oper(ifreq)%matlu(iatom)%mat(im,im1,isppol,ispinor,ispinor1)=     &
&                  (one-alpha)*self%oper(ifreq)%matlu(iatom)%mat(im,im1,isppol,ispinor,ispinor1) +    &
&                  (alpha)*self_new%oper(ifreq)%matlu(iatom)%mat(im,im1,isppol,ispinor,ispinor1)
                     s1=self%hdc%matlu(iatom)%mat(im,im1,isppol,ispinor,ispinor1)
                 s2=self_new%hdc%matlu(iatom)%mat(im,im1,isppol,ispinor,ispinor1)
                 if((ispinor==ispinor1).and.(im==im1)) then
                   diff_self=diff_self+dsqrt(real(s1-s2)**2+imag(s1-s2)**2)
                   sum_self=sum_self+dsqrt(real(s1)**2+imag(s1)**2)
                   icount=icount+1
                 endif
               enddo
               self%hdc%matlu(iatom)%mat(im,im1,isppol,ispinor,ispinor1)=             &
&               (one-alpha)*self%hdc%matlu(iatom)%mat(im,im1,isppol,ispinor,ispinor1)   +          &
&               (alpha)*self_new%hdc%matlu(iatom)%mat(im,im1,isppol,ispinor,ispinor1)
             enddo
           enddo
         enddo
       enddo
     enddo ! isppol
   endif ! lpawu=/-1
 enddo ! iatom
 diff_self=diff_self/icount

 write(message,'(8x,a,f12.5)') "DMFT Loop: Precision on self-energy is",diff_self
 call wrtout(std_out,message,'COLL')
 if(diff_self<paw_dmft%dmft_fepr.and.sum_self>tol6.and.paw_dmft%idmftloop>=2) then
    write(message,'(a,8x,a,e8.2,a,8x,a)') ch10, "Change of self =<", paw_dmft%dmft_fepr,&
&    ch10,"DMFT Loop: Self Energy is converged" 
    call wrtout(std_out,message,'COLL')
    self%iself_cv=1
 else
    write(message,'(a,8x,a)') ch10,"DMFT Loop: Self Energy is not converged" 
    call wrtout(std_out,message,'COLL')
    self%iself_cv=0
 endif


end subroutine new_self
!!***

END MODULE m_self
!!***
