!{\src2tex{textfont=tt}}
!!****f* ABINIT/Arjan_assemlychi0
!! NAME
!! assemblychi0
!!
!! FUNCTION
!! Update the independent particle susceptibility for the contribution
!! of one pair of occupied-unoccupied band, for each frequencies.
!! Compute chi0(G,Gp,io)=chi0(G,Gp,io)+(rhotwg(G)*rhotwg*(Gp))*den(io)
!!
!! COPYRIGHT
!! Copyright (C) 1999-2010 ABINIT group (GMR, VO, LR, RWG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  npwsigx=number of plane waves for sigma exchange (input variable)
!!  nomega=number of frequencies
!!  rhotwg(npwsigx)=density of a pair of occupied-unoccupied states, in reciprocal space
!!  den(nomega)=denominator of the susceptibility expression
!!
!! OUTPUT
!!  (see side effects)
!!
!! SIDE EFFECTS
!!  chi0(npwsigx,npwsigx,nomega)=independent-particle susceptibility matrix in reciprocal space
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine assemblychi0(npwsigx,nomega,chi0,rhotwg,den)

 use defs_basis
 use m_blas,      only : xgerc

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: nomega,npwsigx
!arrays
 complex(gwpc),intent(in) :: rhotwg(npwsigx)
 complex(gwpc) :: chi0(npwsigx,npwsigx,nomega)
 complex(dpc),intent(in) :: den(nomega)

!Local variables-------------------------------
!scalars
 integer :: io
 complex(gwpc) :: dd

! *************************************************************************

 do io=1,nomega
  dd=den(io)
!!#if defined HAVE_GW_DPC
!!  call ZGERC(npwsigx,npwsigx,dd,rhotwg,1,rhotwg,1,chi0(:,:,io),npwsigx)
!!#else
!!  call CGERC(npwsigx,npwsigx,dd,rhotwg,1,rhotwg,1,chi0(:,:,io),npwsigx)
!!#endif
  call XGERC(npwsigx,npwsigx,dd,rhotwg,1,rhotwg,1,chi0(:,:,io),npwsigx)
 end do

end subroutine assemblychi0
!!***

!----------------------------------------------------------------------

!!****f* ABINIT/assemlychi0_q0
!! NAME
!! assemblychi0_q0
!!
!! FUNCTION
!!
!! INPUTS
!!  npwsigx=number of plane waves for sigma exchange (input variable)
!!  nomega=number of frequencies
!!  rhotwg(npwsigx)=density of a pair of occupied-unoccupied states, in reciprocal space
!!  den(nomega)=denominator of the susceptibility expression
!!
!! OUTPUT
!!
!! SIDE EFFECTS
!!  chi0(npwsigx,npwsigx,nomega)=independent-particle susceptibility matrix in reciprocal space
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE

subroutine assemblychi0_q0(npwsigx,nomega,chi0,rhotwg,den)

 use defs_basis

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: nomega,npwsigx
!arrays
 complex(gwpc),intent(in) :: rhotwg(npwsigx)
 complex(gwpc) :: chi0(npwsigx,npwsigx,nomega)
 complex(dpc),intent(in) :: den(nomega)

!Local variables-------------------------------
!scalars
 integer :: ig,io
 complex(gwpc) :: dd

! *************************************************************************

 do io=1,nomega
  dd=den(io)
  do ig = 1, npwsigx
   chi0(1,ig,io) = chi0(1,ig,io)+rhotwg(1)*conjg(rhotwg(ig))*dd
   if (ig==1) cycle
   chi0(ig,1,io) = chi0(ig,1,io)+rhotwg(ig)*conjg(rhotwg(1))*dd
  end do
 end do

end subroutine assemblychi0_q0
!!***

!----------------------------------------------------------------------

!!****f* ABINIT/Arjan_assemlychi02
!! NAME
!! assemblychi02
!!
!! FUNCTION
!!
!! INPUTS
!!  npwsigx=number of plane waves for sigma exchange (input variable)
!!  nomega=number of frequencies
!!  rhotwg(npwsigx)=density of a pair of occupied-unoccupied states, in reciprocal space
!!  den(nomega)=denominator of the susceptibility expression
!!
!! OUTPUT
!!
!! SIDE EFFECTS
!!  chi0(npwsigx,npwsigx,nomega)=independent-particle susceptibility matrix in reciprocal space
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE

subroutine assemblychi02(npwsigx,nomega,chi0,rhotwg,omega,delta,green_w,nbhomo,ib1)

 use defs_basis

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: nomega,npwsigx,nbhomo,ib1
!arrays
 complex(gwpc),intent(in) :: rhotwg(npwsigx)
 complex(gwpc),intent(in) :: delta(npwsigx,npwsigx,nomega)
 complex(gwpc) :: chi0(npwsigx,npwsigx,nomega)
 complex(dpc),intent(in) :: omega(nomega)
 complex(dpc),intent(in) :: green_w(nomega)

!Local variables-------------------------------
!scalars
 integer :: ig,igp,io
 complex(gwpc) :: dd

! *************************************************************************

 do io=1,nomega
   do ig=1,npwsigx
     do igp=1,npwsigx
       dd=omega(io)+delta(ig,igp,io)
       chi0(ig,igp,io) = chi0(ig,igp,io)+rhotwg(ig)*conjg(rhotwg(igp))/dd
     enddo
   enddo
 end do

 if (ib1>nbhomo) then

   do io=1,nomega
     do ig=1,npwsigx
       do igp=1,npwsigx
         dd=green_w(io)
         chi0(ig,igp,io) = chi0(ig,igp,io)-rhotwg(ig)*conjg(rhotwg(igp))/dd
       enddo
     enddo
   end do

 endif

end subroutine assemblychi02
!!***

!----------------------------------------------------------------------

!!****f* ABINIT/Arjan_assemlychi02_q0
!! NAME
!! assemblychi02_q0
!!
!! FUNCTION
!!
!! INPUTS
!!  npwsigx=number of plane waves for sigma exchange (input variable)
!!  nomega=number of frequencies
!!  rhotwg(npwsigx)=density of a pair of occupied-unoccupied states, in reciprocal space
!!  den(nomega)=denominator of the susceptibility expression
!!
!! OUTPUT
!!
!! SIDE EFFECTS
!!  chi0(npwsigx,npwsigx,nomega)=independent-particle susceptibility matrix in reciprocal space
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE

subroutine assemblychi02_q0(npwsigx,nomega,chi0,rhotwg,omega,delta,green_w,nbhomo,ib1,nband_EET)

 use defs_basis

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: nomega,npwsigx,nbhomo,ib1,nband_EET
!arrays
 complex(gwpc),intent(in) :: rhotwg(npwsigx)
 complex(gwpc),intent(in) :: delta(npwsigx,npwsigx,nomega)
 complex(gwpc) :: chi0(npwsigx,npwsigx,nomega)
 complex(dpc),intent(in) :: omega(nomega)
 complex(dpc),intent(in) :: green_w(nomega)

!Local variables-------------------------------
!scalars
 integer :: ig,igp,io
 complex(gwpc) :: dd

! *************************************************************************

 if (ib1<=max(nbhomo,nband_EET)) then

   do io=1,nomega
     do ig = 2, npwsigx
       do igp = 2, npwsigx
         dd=omega(io)+delta(ig,igp,io)
         chi0(ig,igp,io) = chi0(ig,igp,io)+rhotwg(ig)*conjg(rhotwg(igp))/dd
       enddo
     enddo
   end do

   if (ib1>nbhomo) then

     do io=1,nomega
       do ig=2,npwsigx
         do igp=2,npwsigx
           dd=green_w(io)
           chi0(ig,igp,io) = chi0(ig,igp,io)-rhotwg(ig)*conjg(rhotwg(igp))/dd
         enddo
       enddo
     end do

  endif

 endif

end subroutine assemblychi02_q0
!!***
