#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"

subroutine calc_delta_chi0(Ep,qpgsq,delta,ptwsq,epsv,epslumo,niter)

 use defs_basis
 use m_errors
 use m_gwdefs
 use defs_abitypes

 implicit none

 type(Epsilonm1_parameters),intent(in) :: Ep

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: niter
!arrays
 complex(gwpc),intent(inout) :: delta(Ep%npwe,Ep%npwe,Ep%nomega)
 real(dp),intent(in) :: qpgsq(Ep%npwe)
 real(dp),intent(in) :: epsv,epslumo
 complex(gwpc),intent(in) :: ptwsq(Ep%npwe,Ep%npwe,niter+1)

!Local variables-------------------------------
!scalars

 integer :: ig,igp,ios
 integer :: iter

 real(dp) :: bq
 real(dp) :: delta_huge,denchk,test

 complex(gwpc) :: daux(niter)
 complex(gwpc) :: dfrac(niter)
 complex(gwpc) :: num,den

!*************************************************************************

   delta_huge = 1.0d8

   if (niter==1) then

     do ig=1,Ep%npwe
       do igp=ig,Ep%npwe
         num = ptwsq(ig,igp,2)+conjg(ptwsq(igp,ig,2))
         den = ptwsq(ig,igp,1)+conjg(ptwsq(igp,ig,1))
         denchk=abs(real(den))+abs(aimag(den))
         if (denchk>0.0) then
           dfrac(1)=num/den
         else
           dfrac(1)=cmplx(delta_huge,0.0)
         endif
         bq=half*(qpgsq(ig)+qpgsq(igp))
         delta(ig,igp,1) = bq + dfrac(1)
       end do !ig
     end do !igp

     do ig = 1, Ep%npwe
       do igp = 1, ig-1
         delta(ig,igp,1)=conjg(delta(igp,ig,1))
       enddo
     enddo

     do ios = 2, Ep%nomega
       delta(:,:,ios) = delta(:,:,1)
     enddo

   elseif (niter==2) then

     do ig=1,Ep%npwe
       do igp=1,Ep%npwe
         bq=half*(qpgsq(ig)+qpgsq(igp))
         do iter = 1, niter
           num = ptwsq(ig,igp,iter+1)+conjg(ptwsq(igp,ig,iter+1))
           den = ptwsq(ig,igp,iter)+conjg(ptwsq(igp,ig,iter))
           denchk=abs(real(den))+abs(aimag(den))
           if (denchk>0.0) then
             dfrac(iter)=num/den
           else
             dfrac(iter)=cmplx(delta_huge,0.0)
           endif
         enddo
         do ios=1,Ep%nomega
           if (abs(aimag(Ep%omega(ios)))<0.001.and.igp<ig) CYCLE
           do iter = 1, 2
             daux(iter) = Ep%omega(ios)+bq+dfrac(iter)
           enddo
           delta(ig,igp,ios) = bq + dfrac(1)*daux(1)/daux(2)
         enddo
       end do !ig
     end do !igp

     do ios=1,Ep%nomega
       if (abs(aimag(Ep%omega(ios)))<0.001) then
         do ig = 1, Ep%npwe
           do igp = 1, ig-1
             delta(ig,igp,ios)=conjg(delta(igp,ig,ios))
           enddo
         enddo
       endif
     enddo

   endif

   do ios = 1, Ep%nomega
     if (abs(aimag(Ep%omega(ios)))<0.001) then
       if (niter>0) then
         do ig = 1, Ep%npwe
           do igp = 1, Ep%npwe
             if (ig==igp) then
               delta(ig,igp,ios)=real(delta(ig,igp,ios))
               test=delta(ig,igp,ios)+epsv
               if (test<epslumo) then
                 delta(ig,igp,ios)=half*(qpgsq(ig)+qpgsq(igp))
                 test=delta(ig,igp,ios)+epsv
               endif
               if (test<epslumo) then
                 delta(ig,igp,ios)=epslumo-epsv
               endif
             else
               test=delta(ig,igp,ios)+epsv
               if (test<epslumo) then
                 delta(ig,igp,ios)=epslumo-epsv
               endif
             endif
           enddo
         enddo
       else
         do ig = 1, Ep%npwe
           do igp = 1, Ep%npwe
             delta(ig,igp,ios)=half*(qpgsq(ig)+qpgsq(igp))
             test=delta(ig,igp,ios)+epsv
             if (test<epslumo) then
               delta(ig,igp,ios)=epslumo-epsv
             endif
           enddo
         enddo
       endif
     endif
   enddo

end subroutine calc_delta_chi0
!!***

subroutine calc_chi0_delta_clos(ik_bz,Ep,Gsph_epsG0,Ltg_q,ptwg_kk,chi0,delta)

 use defs_basis
 use m_errors
 use m_bz_mesh,  only : little_group
 use m_gwdefs,   only : epsilonm1_parameters
 use m_gsphere,  only : gvectors_type
 use m_errors

 implicit none

!Arguments ------------------------------------
!scalars

 type(Epsilonm1_parameters),intent(in) :: Ep
 type(Gvectors_type),intent(in) :: Gsph_epsG0
 type(Little_group),intent(in) :: Ltg_q

 integer,intent(in) :: ik_bz
!arrays
 complex(gwpc),intent(in) :: ptwg_kk(Ep%npwe,Ep%npwe)
 complex(gwpc),intent(in) :: delta(Ep%npwe,Ep%npwe,Ep%nomega)
 complex(gwpc),intent(inout) :: chi0(Ep%npwe,Ep%npwe,Ep%nomega)

!Local variables-------------------------------
!scalars
 integer :: ig,igp,ios,isym,itim
 character(len=500) :: msg

 integer,pointer :: gmG0(:)
 integer,allocatable :: Sm1_gmG0(:)
 complex(gwpc),allocatable :: ptwg_kk_sym(:,:)
 complex(gwpc),pointer :: phmGt(:)

 complex(gwpc) :: delta_sym1,delta_sym2

!*************************************************************************

 SELECT CASE (Ep%symchi)

 CASE (0)

   do ios=1,Ep%nomega
     if (ABS(REAL(Ep%omega(ios)))<0.00001) then
       do ig=1,Ep%npwe
         do igp=ig,Ep%npwe
           chi0(ig,igp,ios) = chi0(ig,igp,ios) - ptwg_kk(ig,igp)/(Ep%omega(ios)+delta(ig,igp,ios)) &
                                               + ptwg_kk(ig,igp)/(Ep%omega(ios)-conjg(delta(igp,ig,ios)))
         end do !igp
       end do !ig
     else
       do ig=1,Ep%npwe
         do igp=1,Ep%npwe
           chi0(ig,igp,ios) = chi0(ig,igp,ios) - ptwg_kk(ig,igp)/(Ep%omega(ios)+delta(ig,igp,ios)) &
                                               + ptwg_kk(ig,igp)/(Ep%omega(ios)-conjg(delta(igp,ig,ios)))
         end do !igp
       end do !ig
     endif
   end do !ios

 CASE (1)

   allocate(ptwg_kk_sym(Ep%npwe,Ep%npwe))
   allocate(Sm1_gmG0(Ep%npwe))

   do isym=1,Ltg_q%nsym_sg
     do itim = 1,Ltg_q%timrev

       if (Ltg_q%wtksym(itim,isym,ik_bz)==1) then

         phmGt => Gsph_epsG0%phmGt(1:Ep%npwe,isym)
         gmG0  => Ltg_q%igmG0(1:Ep%npwe,itim,isym)
         Sm1_gmG0(1:Ep%npwe)=Gsph_epsG0%rottbm1(gmG0(1:Ep%npwe),itim,isym)

         SELECT CASE (itim)
         CASE (1)
           do ig = 1, Ep%npwe
             do igp = 1, Ep%npwe
               ptwg_kk_sym(ig,igp)=ptwg_kk(Sm1_gmG0(ig),Sm1_gmG0(igp))*phmGt(ig)*phmGt(igp)
             enddo
           enddo
         CASE (2)
           do ig = 1, Ep%npwe
             do igp = 1, Ep%npwe
               ptwg_kk_sym(ig,igp)=conjg(ptwg_kk(Sm1_gmG0(ig),Sm1_gmG0(igp)))*phmGt(ig)*phmGt(igp)
             enddo
           enddo
         CASE DEFAULT
           write(msg,'(a,i3)')'Wrong value of itim= ',itim
           MSG_BUG(msg)
         END SELECT

         do ios=1,Ep%nomega
           if (ABS(REAL(Ep%omega(ios)))<0.00001) then
             do ig=1,Ep%npwe
               do igp=ig,Ep%npwe
                 if (itim==1) then
                   delta_sym1=delta(Sm1_gmG0(ig),Sm1_gmG0(igp),ios)
                   delta_sym2=conjg(delta(Sm1_gmG0(igp),Sm1_gmG0(ig),ios))
                 elseif (itim==2) then
                   delta_sym1=delta(Sm1_gmG0(igp),Sm1_gmG0(ig),ios)
                   delta_sym2=conjg(delta(Sm1_gmG0(ig),Sm1_gmG0(igp),ios))
                 endif
                 chi0(ig,igp,ios) = chi0(ig,igp,ios) - ptwg_kk_sym(ig,igp)/(Ep%omega(ios)+delta_sym1) &
                                                     + ptwg_kk_sym(ig,igp)/(Ep%omega(ios)-delta_sym2)
               end do !igp
             end do !ig
           else
             do ig=1,Ep%npwe
               do igp=1,Ep%npwe
                 if (itim==1) then
                   delta_sym1=delta(Sm1_gmG0(ig),Sm1_gmG0(igp),ios)
                   delta_sym2=conjg(delta(Sm1_gmG0(igp),Sm1_gmG0(ig),ios))
                 elseif (itim==2) then
                   delta_sym1=delta(Sm1_gmG0(igp),Sm1_gmG0(ig),ios)
                   delta_sym2=conjg(delta(Sm1_gmG0(ig),Sm1_gmG0(igp),ios))
                 endif
                 chi0(ig,igp,ios) = chi0(ig,igp,ios) - ptwg_kk_sym(ig,igp)/(Ep%omega(ios)+delta_sym1) &
                                                     + ptwg_kk_sym(ig,igp)/(Ep%omega(ios)-delta_sym2)
               end do !igp
             end do !ig
           endif
         end do !ios

       endif
     enddo
   enddo

   deallocate(ptwg_kk_sym)
   deallocate(Sm1_gmG0)

 CASE DEFAULT
  write(msg,'(a,i3)')'Wrong symchi= ',Ep%symchi
  MSG_BUG(msg)
 END SELECT

end subroutine calc_chi0_delta_clos

subroutine calc_chi0_delta0(ik_bz,Ep,Gsph_epsG0,Ltg_q,ptwg_kk,paux,chi0,delta)

 use defs_basis
 use m_errors
 use m_bz_mesh,  only : little_group
 use m_gwdefs,   only : epsilonm1_parameters
 use m_gsphere,  only : gvectors_type
 use m_errors

 implicit none

!Arguments ------------------------------------
!scalars

 type(Epsilonm1_parameters),intent(in) :: Ep
 type(Gvectors_type),intent(in) :: Gsph_epsG0
 type(Little_group),intent(in) :: Ltg_q

 integer,intent(in) :: ik_bz
!arrays
 complex(gwpc),intent(in) :: ptwg_kk(Ep%npwe,Ep%npwe)
 complex(gwpc),intent(in) :: delta(Ep%npwe,Ep%npwe,Ep%nomega)
 complex(gwpc),intent(inout) :: paux(Ep%npwe,Ep%npwe)
 complex(gwpc),intent(inout) :: chi0(Ep%npwe,Ep%npwe,Ep%nomega)

!Local variables-------------------------------
!scalars
 integer :: ig,igp,ios,isym,itim
 character(len=500) :: msg

 integer,pointer :: gmG0(:)
 integer,allocatable :: Sm1_gmG0(:)
 complex(gwpc),allocatable :: ptwg_kk_sym(:,:)
 complex(gwpc),pointer :: phmGt(:)

 complex(gwpc) :: delta_sym

!*************************************************************************

 paux(:,:)=paux(:,:)+ptwg_kk(:,:)

 SELECT CASE (Ep%symchi)

 CASE (0)

   do ios=1,Ep%nomega
     if (ABS(REAL(Ep%omega(ios)))<0.00001) then
       if (abs(aimag(Ep%omega(ios)))<0.001) then
         do ig=1,Ep%npwe
           do igp=ig,Ep%npwe
             chi0(ig,igp,ios) = chi0(ig,igp,ios) - ptwg_kk(ig,igp)/(Ep%omega(ios)+delta(ig,igp,ios)) &
                                                 + ptwg_kk(ig,igp)/(Ep%omega(ios)-delta(ig,igp,ios))
           end do !igp
         end do !ig
       endif
     else 
       if (abs(aimag(Ep%omega(ios)))<0.001) then
         do ig=1,Ep%npwe
           do igp=1,Ep%npwe
             chi0(ig,igp,ios) = chi0(ig,igp,ios) - ptwg_kk(ig,igp)/(Ep%omega(ios)+delta(ig,igp,ios)) &
                                                 + ptwg_kk(ig,igp)/(Ep%omega(ios)-delta(ig,igp,ios))
           end do !igp
         end do !ig
       endif
     endif
   end do !ios

 CASE (1)

   allocate(ptwg_kk_sym(Ep%npwe,Ep%npwe))
   allocate(Sm1_gmG0(Ep%npwe))

   do isym=1,Ltg_q%nsym_sg
     do itim = 1,Ltg_q%timrev

       if (Ltg_q%wtksym(itim,isym,ik_bz)==1) then

         phmGt => Gsph_epsG0%phmGt(1:Ep%npwe,isym)
         gmG0  => Ltg_q%igmG0(1:Ep%npwe,itim,isym)
         Sm1_gmG0(1:Ep%npwe)=Gsph_epsG0%rottbm1(gmG0(1:Ep%npwe),itim,isym)

         SELECT CASE (itim)
         CASE (1)
           do ig = 1, Ep%npwe
             do igp = 1, Ep%npwe
               ptwg_kk_sym(ig,igp)=ptwg_kk(Sm1_gmG0(ig),Sm1_gmG0(igp))*phmGt(ig)*phmGt(igp)
             enddo
           enddo
         CASE (2)
           do ig = 1, Ep%npwe
             do igp = 1, Ep%npwe
               ptwg_kk_sym(ig,igp)=conjg(ptwg_kk(Sm1_gmG0(ig),Sm1_gmG0(igp)))*phmGt(ig)*phmGt(igp)
             enddo
           enddo
         CASE DEFAULT
           write(msg,'(a,i3)')'Wrong value of itim= ',itim
           MSG_BUG(msg)
         END SELECT

         do ios=1,Ep%nomega
           if (ABS(REAL(Ep%omega(ios)))<0.00001) then
             if (abs(aimag(Ep%omega(ios)))<0.001) then
               do ig=1,Ep%npwe
                 do igp=ig,Ep%npwe
                   delta_sym=delta(Sm1_gmG0(ig),Sm1_gmG0(igp),ios)
                   chi0(ig,igp,ios) = chi0(ig,igp,ios) - ptwg_kk_sym(ig,igp)/(Ep%omega(ios)+delta_sym) &
                                                       + ptwg_kk_sym(ig,igp)/(Ep%omega(ios)-delta_sym)
                 end do !igp
               end do !ig
             endif
           else
             if (abs(aimag(Ep%omega(ios)))<0.001) then
               do ig=1,Ep%npwe
                 do igp=1,Ep%npwe
                   delta_sym=delta(Sm1_gmG0(ig),Sm1_gmG0(igp),ios)
                   chi0(ig,igp,ios) = chi0(ig,igp,ios) - ptwg_kk_sym(ig,igp)/(Ep%omega(ios)+delta_sym) &
                                                       + ptwg_kk_sym(ig,igp)/(Ep%omega(ios)-delta_sym)
                 end do !igp
               end do !ig
             endif
           endif
         end do !ios

       endif
     enddo
   enddo

   deallocate(ptwg_kk_sym)
   deallocate(Sm1_gmG0)

 CASE DEFAULT
  write(msg,'(a,i3)')'Wrong symchi= ',Ep%symchi
  MSG_BUG(msg)
 END SELECT

end subroutine calc_chi0_delta0

subroutine calc_corr_chi0(ik_bz,Ep,Kmesh,Gsph_epsG0,Ltg_q,rhotwg,spin_fact,qp_occ,qp_energy, &
&                         ibv,ibc,ik_ibz,ikmq_ibz,is,chi0)

 use defs_basis
 use m_bz_mesh
 use m_gwdefs
 use m_gsphere,  only : gvectors_type
 use m_errors

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 type(Epsilonm1_parameters),intent(in) :: Ep
 type(BZ_mesh_type),intent(in) :: Kmesh
 type(Gvectors_type),intent(in) :: Gsph_epsG0
 type(Little_group),intent(in) :: Ltg_q

 integer,intent(in) :: ik_bz,ibv,ibc,ik_ibz,ikmq_ibz,is
 real(dp),intent(in) :: spin_fact
 real(dp),intent(in) :: qp_occ(Ep%nbnds,Kmesh%nibz,Ep%nsppol)
 real(dp),intent(in) :: qp_energy(Ep%nbnds,Kmesh%nibz,Ep%nsppol)
 complex(gwpc),intent(in) :: rhotwg(Ep%npwe)
 complex(gwpc),intent(inout) :: chi0(Ep%npwe,Ep%npwe,Ep%nomega)

 integer :: ig,igp,ios,isym,itim
 real(dp) :: deltae,deltaf
 complex(dpc) :: green_w

 character(len=500) :: msg
!arrays
 integer,pointer :: gmG0(:)
 integer,allocatable :: Sm1_gmG0(:)
 complex(gwpc),allocatable :: rhotwg_sym(:)
 complex(gwpc),pointer :: phmGt(:)

!************************************************************************

 deltaf=spin_fact*(qp_occ(ibc,ikmq_ibz,is)-qp_occ(ibv,ik_ibz,is))
 deltae=qp_energy(ibc,ikmq_ibz,is)-qp_energy(ibv,ik_ibz,is)

 SELECT CASE (Ep%symchi)

 CASE (0) ! Do not use symmetries

   do ios = 1, Ep%nomega
     if (ibc==ibv) then
       green_w = g0g0w(Ep%omega(ios),deltaf,deltae,Ep%zcut,GW_TOL_W0,1)
     else
       green_w = g0g0w(Ep%omega(ios),deltaf,deltae,Ep%zcut,GW_TOL_W0,2)
     endif
     if (ABS(REAL(Ep%omega(ios)))<0.00001) then
       do ig=1,Ep%npwe
         do igp=ig,Ep%npwe
           chi0(ig,igp,ios) = chi0(ig,igp,ios)+rhotwg(ig)*conjg(rhotwg(igp))*green_w
         end do !igp
       end do !ig
     else
       do ig=1,Ep%npwe
         do igp=1,Ep%npwe
           chi0(ig,igp,ios) = chi0(ig,igp,ios)+rhotwg(ig)*conjg(rhotwg(igp))*green_w
         end do !igp
       end do !ig
     endif
   end do !ios

 CASE (1) ! Use symmetries to reconstruct the integrand in the BZ.

   allocate(rhotwg_sym(Ep%npwe))
   allocate(Sm1_gmG0  (Ep%npwe))

   do isym=1,Ltg_q%nsym_sg
     do itim=1,Ltg_q%timrev

       if (Ltg_q%wtksym(itim,isym,ik_bz)==1) then

        phmGt => Gsph_epsG0%phmGt(1:Ep%npwe,isym)
        gmG0  => Ltg_q%igmG0     (1:Ep%npwe,itim,isym)
        Sm1_gmG0(1:Ep%npwe)=Gsph_epsG0%rottbm1(gmG0(1:Ep%npwe),itim,isym)

        SELECT CASE (itim)
        CASE (1)
          rhotwg_sym(1:Ep%npwe)=rhotwg(Sm1_gmG0)*phmGt(1:Ep%npwe)
        CASE (2)
          rhotwg_sym(1:Ep%npwe)=CONJG(rhotwg(Sm1_gmG0))*phmGt(1:Ep%npwe)
        CASE DEFAULT
          write(msg,'(a,i3)')'Wrong itim= ',itim
          MSG_BUG(msg)
        END SELECT

        do ios=1, Ep%nomega
          if (ibc==ibv) then
            green_w = g0g0w(Ep%omega(ios),deltaf,deltae,Ep%zcut,GW_TOL_W0,1)
          else
            green_w = g0g0w(Ep%omega(ios),deltaf,deltae,Ep%zcut,GW_TOL_W0,2)
          endif
          if (ABS(REAL(Ep%omega(ios)))<0.00001) then
            do ig=1,Ep%npwe
              do igp=ig,Ep%npwe
                chi0(ig,igp,ios) = chi0(ig,igp,ios)+rhotwg_sym(ig)*conjg(rhotwg_sym(igp))*green_w
              end do !igp
            end do !ig
          else
            do ig=1,Ep%npwe
              do igp=1,Ep%npwe
                chi0(ig,igp,ios) = chi0(ig,igp,ios)+rhotwg_sym(ig)*conjg(rhotwg_sym(igp))*green_w
              end do !igp
            end do !ig
          endif
        end do

       end if
     end do
   end do

   deallocate(rhotwg_sym)
   deallocate(Sm1_gmG0)

 CASE DEFAULT
   write(msg,'(a,i3)')'Wrong symchi= ',Ep%symchi
   MSG_BUG(msg)
 END SELECT

end subroutine calc_corr_chi0

subroutine calc_corr_sig(Sigp,Sr,nomega,nspinor,npwc1,npwc2,botsq,otq,rhotwg,is,ibv,kb, &
&                        ik_bz,ikmq_bz,ik_ibz,ikmq_ibz,i_sz,vc_sqrt_qbz,sigmac)

 use defs_basis
 use m_gwdefs
 use defs_datatypes

 implicit none

!Arguments ------------------------------------
!scalars
 type(Sigma_parameters),intent(in) :: Sigp
 type(Sigma_results),intent(in) :: Sr

 integer,intent(in) :: nomega,nspinor,npwc1,npwc2
 integer,intent(in) :: is,ibv,kb
 integer,intent(in) :: ik_bz,ikmq_bz,ik_ibz,ikmq_ibz
 real(dp),intent(in) :: i_sz
 complex(gwpc),intent(in) :: rhotwg(Sigp%npwc)
 complex(gwpc),intent(in) :: vc_sqrt_qbz(Sigp%npwc)
 complex(gwpc),intent(in) :: otq(Sigp%npwc,npwc2)
 complex(gwpc),intent(in) :: botsq(Sigp%npwc,npwc1)
 complex(dpc),intent(inout) :: sigmac(nomega)

 complex(gwpc),allocatable :: rtaux(:)

 integer :: ig,igp,ios
 real(dp) :: otw,twofm1_zcut
 real(dp) :: den,omegame0i
 complex(gwpc) :: num

!************************************************************************

 allocate(rtaux(Sigp%npwc*nspinor**2))

 twofm1_zcut=-Sigp%zcut

 do ig = 1,Sigp%npwc
   rtaux(ig)=rhotwg(ig)*vc_sqrt_qbz(ig)
 enddo
 if (ik_bz==ikmq_bz) then
   rtaux(1)=czero_gw
   if (ibv==kb) then
     rtaux(1)=cmplx(sqrt(i_sz),0.0_gwp)
   endif
 endif
 do ios=1,nomega
   omegame0i = real(Sr%omega4sd(kb,ikmq_ibz,ios,is)) - Sr%e0(ibv,ik_ibz,is)
   do ig=1,Sigp%npwc
     do igp=1,Sigp%npwc
       otw = DBLE(otq(ig,igp)) !in principle otw -> otw - ieta
       num = botsq(ig,igp)*conjg(rtaux(ig))*rtaux(igp)
       den = omegame0i-otw
       if (real(den*den)>Sigp%zcut**2) then
         sigmac(ios) = sigmac(ios) + 0.5*num/(den*otw)
       else
         sigmac(ios) = sigmac(ios) + 0.5*num*cmplx(den,twofm1_zcut)/((den**2+twofm1_zcut**2)*otw)
       end if
     end do !igp
   end do !ig
 end do !ios

 deallocate(rtaux)

end subroutine calc_corr_sig

subroutine calc_delta0(Ep,qpgsq,delta)

 use defs_basis
 use m_gwdefs
 use defs_abitypes

 implicit none

!Arguments ------------------------------------
!scalars
 type(Epsilonm1_parameters),intent(in) :: Ep

 real(dp), intent(in) :: qpgsq(Ep%npwe)
 complex(gwpc),intent(out) :: delta(Ep%npwe,Ep%npwe,Ep%nomega)

 integer :: ig,igp,ios

!************************************************************************

 do ig = 1, Ep%npwe
   do igp = ig, Ep%npwe
     delta(ig,igp,1)=half*(qpgsq(ig)+qpgsq(igp))
   enddo
 enddo
 do ig = 1, Ep%npwe
   do igp = 1, ig-1
     delta(ig,igp,1)=delta(igp,ig,1)
   enddo
 enddo
 do ios = 2, Ep%nomega
   delta(:,:,ios)=delta(:,:,1)
 enddo

end subroutine calc_delta0

subroutine calc_chi0_delta0_bis(ik_bz,Ep,Gsph_epsG0,Ltg_q,paux,delta,chi0)

 use defs_basis
 use m_errors
 use m_bz_mesh,  only : little_group
 use m_gwdefs,   only : epsilonm1_parameters
 use m_gsphere,  only : gvectors_type
 use m_errors

 implicit none

!Arguments ------------------------------------
!scalars
 type(Epsilonm1_parameters),intent(in) :: Ep
 type(Gvectors_type),intent(in) :: Gsph_epsG0
 type(Little_group),intent(in) :: Ltg_q

 integer,intent(in) :: ik_bz

 complex(gwpc),intent(in) :: paux(Ep%npwe,Ep%npwe)
 complex(gwpc),intent(in) :: delta(Ep%npwe,Ep%npwe,Ep%nomega)
 complex(gwpc),intent(out) :: chi0(Ep%npwe,Ep%npwe,Ep%nomega)

 integer :: ig,igp,ios,isym,itim
 character(len=500) :: msg

 integer,pointer :: gmG0(:)
 integer,allocatable :: Sm1_gmG0(:)
 complex(gwpc),allocatable :: paux_sym(:,:)
 complex(gwpc),pointer :: phmGt(:)

 complex(gwpc) :: delta_sym

!************************************************************************

 SELECT CASE (Ep%symchi)

 CASE (0)

   do ios = 1, Ep%nomega
     if (ABS(REAL(Ep%omega(ios)))<0.00001) then
       if (abs(aimag(Ep%omega(ios)))>=0.001) then
         do ig = 1, Ep%npwe
           do igp = ig, Ep%npwe
             chi0(ig,igp,ios) = chi0(ig,igp,ios) - paux(ig,igp)/(Ep%omega(ios)+delta(ig,igp,ios)) &
                                                 + paux(ig,igp)/(Ep%omega(ios)-delta(ig,igp,ios))
           enddo
         enddo
       endif
     else
       if (abs(aimag(Ep%omega(ios)))>=0.001) then
         do ig = 1, Ep%npwe
           do igp = 1, Ep%npwe
             chi0(ig,igp,ios) = chi0(ig,igp,ios) - paux(ig,igp)/(Ep%omega(ios)+delta(ig,igp,ios)) &
                                                 + paux(ig,igp)/(Ep%omega(ios)-delta(ig,igp,ios))
           enddo
         enddo
       endif
     endif
   enddo

 CASE (1)

   allocate(paux_sym(Ep%npwe,Ep%npwe))
   allocate(Sm1_gmG0(Ep%npwe))

   do isym=1,Ltg_q%nsym_sg
     do itim = 1,Ltg_q%timrev

       if (Ltg_q%wtksym(itim,isym,ik_bz)==1) then

         phmGt => Gsph_epsG0%phmGt(1:Ep%npwe,isym)
         gmG0  => Ltg_q%igmG0(1:Ep%npwe,itim,isym)
         Sm1_gmG0(1:Ep%npwe)=Gsph_epsG0%rottbm1(gmG0(1:Ep%npwe),itim,isym)

         SELECT CASE (itim)
         CASE (1)
           do ig = 1, Ep%npwe
             do igp = 1, Ep%npwe
               paux_sym(ig,igp)=paux(Sm1_gmG0(ig),Sm1_gmG0(igp))*phmGt(ig)*phmGt(igp)
             enddo
           enddo
         CASE (2)
           do ig = 1, Ep%npwe
             do igp = 1, Ep%npwe
               paux_sym(ig,igp)=conjg(paux(Sm1_gmG0(ig),Sm1_gmG0(igp)))*phmGt(ig)*phmGt(igp)
             enddo
           enddo
         CASE DEFAULT
           write(msg,'(a,i3)')'Wrong itim= ',itim
           MSG_BUG(msg)
         END SELECT

         do ios = 1, Ep%nomega
           if (ABS(REAL(Ep%omega(ios)))<0.00001) then
             if (abs(aimag(Ep%omega(ios)))>=0.001) then
               do ig = 1, Ep%npwe
                 do igp = ig, Ep%npwe
                   delta_sym=delta(Sm1_gmG0(ig),Sm1_gmG0(igp),ios)
                   chi0(ig,igp,ios) = chi0(ig,igp,ios) - paux_sym(ig,igp)/(Ep%omega(ios)+delta_sym) &
                                                       + paux_sym(ig,igp)/(Ep%omega(ios)-delta_sym)
                 enddo
               enddo
             endif
           else
             if (abs(aimag(Ep%omega(ios)))>=0.001) then
               do ig = 1, Ep%npwe
                 do igp = 1, Ep%npwe
                   delta_sym=delta(Sm1_gmG0(ig),Sm1_gmG0(igp),ios)
                   chi0(ig,igp,ios) = chi0(ig,igp,ios) - paux_sym(ig,igp)/(Ep%omega(ios)+delta_sym) &
                                                       + paux_sym(ig,igp)/(Ep%omega(ios)-delta_sym)
                 enddo
               enddo
             endif
           endif
         enddo

       endif
     enddo
   enddo

   deallocate(paux_sym)
   deallocate(Sm1_gmG0)


 CASE DEFAULT
  write(msg,'(a,i3)')'Wrong symchi= ',Ep%symchi
  MSG_BUG(msg)
 END SELECT

end subroutine calc_chi0_delta0_bis
!!***
