!!{\src2tex{textfont=tt}}
!!****f* ABINIT/calc_delta_ppm
!! NAME
!! calc_delta_ppm
!!
!! FUNCTION
!! Calculation of the function \delta required for OPTIMAL GW
!!
!! INPUTS
!!
!! OUTPUT
!!
!! PARENTS
!!      Arjan_calc_sig_ppm,csigme
!!
!! CHILDREN
!!      calc_delta_ppm,,calc_sig_ppm_delta_clos
!!      destroy_kb_potential,init_kb_potential,nullify_kb_potential
!!
!! SOURCE
#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"

subroutine calc_delta_ppm(Sigp,nomega,otq,omegame0k,omegame0lumo,npwc2, &
&                          qbzpg,ikbz,jkbz,ptwsq,delta,niter)

 use defs_basis
 use m_errors
 use m_gwdefs

 implicit none

!Arguments ------------------------------------
!scalars
 type(Sigma_parameters),intent(in) :: Sigp

 integer,intent(in) :: npwc2,nomega,niter
!arrays
 real(dp),intent(in) :: omegame0k(nomega),omegame0lumo(nomega)
 complex(gwpc),intent(in) :: otq(Sigp%npwc,npwc2)
 complex(gwpc),intent(in) :: ptwsq(Sigp%npwc,Sigp%npwc,niter+1)
 complex(gwpc),intent(out) :: delta(Sigp%npwc,Sigp%npwc,nomega)

!Local variables-------------------------------
!scalars
 integer :: ig,igp,ios,ikbz,jkbz
 real(dp) :: otw,omegakg
 complex(gwpc) :: daux(niter)
!arrays
 real(dp),intent(in) :: qbzpg(Sigp%npwc)
 real(dp) :: bq

 integer :: iter

 real(dp) :: delta_huge,denchk,test

 logical :: ggpnonzero

 complex(gwpc) :: dfrac(niter)
 complex(gwpc) :: num,den

!*************************************************************************

 if (niter==0) then

   do ig = 1, Sigp%npwc
     do igp = ig, Sigp%npwc
       delta(ig,igp,:) = 0.25*(qbzpg(ig)*qbzpg(ig)+qbzpg(igp)*qbzpg(igp))
     enddo
   enddo

 elseif (niter==1) then

   do ig=1,Sigp%npwc
     do igp=ig,Sigp%npwc
       ggpnonzero=(ig/=1.and.igp/=1)
       if (ikbz/=jkbz.or.ggpnonzero) then
         num = ptwsq(ig,igp,2)+conjg(ptwsq(igp,ig,2))
         den = ptwsq(ig,igp,1)+conjg(ptwsq(igp,ig,1))
         denchk=abs(real(den))+abs(aimag(den))
         if (denchk>0.0) then
           dfrac(1)=num/den
         else
           dfrac(1)=cmplx(delta_huge,0.0)
         endif

         bq=0.25*(qbzpg(ig)*qbzpg(ig)+qbzpg(igp)*qbzpg(igp))
         delta(ig,igp,1) = bq + dfrac(1)
       else
         delta(ig,igp,1) = (0.0,0.0)
       endif
     end do !igp
   end do !ig

   do ios = 2, nomega
     do ig=1,Sigp%npwc
       do igp = ig, Sigp%npwc
         delta(ig,igp,ios) = delta(ig,igp,1)
       enddo
     enddo
   enddo

 elseif (niter==2) then

   do ig=1,Sigp%npwc
     do igp=ig,Sigp%npwc
       ggpnonzero=(ig/=1.and.igp/=1)
       if (ikbz/=jkbz.or.ggpnonzero) then
         do iter = 1, 2
           num = ptwsq(ig,igp,iter+1)+conjg(ptwsq(igp,ig,iter+1))
           den = ptwsq(ig,igp,iter)+conjg(ptwsq(igp,ig,iter))
           denchk=abs(real(den))+abs(aimag(den))
           if (denchk>0.0) then
             dfrac(iter)=num/den
           else
             dfrac(iter)=cmplx(delta_huge,0.0)
           endif
         enddo
         bq=0.25*(qbzpg(ig)*qbzpg(ig)+qbzpg(igp)*qbzpg(igp))
         otw=DBLE(otq(ig,igp)) !in principle otw -> otw - ieta
         do ios=1,nomega
           omegakg=omegame0k(ios)-otw
           do iter = 1, 2
             daux(iter) = omegakg-bq-dfrac(iter)
           enddo
           delta(ig,igp,ios) = bq + dfrac(1)*daux(1)/daux(2)
         enddo
       else
         delta(ig,igp,:) = (0.0,0.0)
       endif
     end do !igp
   end do !ig

 endif

 do ig = 1, Sigp%npwc
   do igp = ig, Sigp%npwc
     do ios = 1, nomega
      ggpnonzero=(ig/=1.and.igp/=1)
      if (ikbz/=jkbz.or.ggpnonzero) then
        if (ig==igp) then
          delta(ig,igp,ios)=real(delta(ig,igp,ios))
          test=omegame0k(ios)-real(delta(ig,igp,ios))
          if (test>omegame0lumo(ios).and.niter>0) then
            delta(ig,igp,ios)=0.25*qbzpg(ig)**2+0.25*qbzpg(igp)**2
            test=omegame0k(ios)-real(delta(ig,igp,ios))
          endif
          if (test>omegame0lumo(ios)) then
            delta(ig,igp,ios)=omegame0k(ios)-omegame0lumo(ios)
          endif
        else
          test=omegame0k(ios)-real(delta(ig,igp,ios))
          if (test>omegame0lumo(ios)) then
            delta(ig,igp,ios)=omegame0k(ios)-omegame0lumo(ios)
          endif
        endif
      else
        delta(ig,igp,ios)=(0.0,0.0)
      endif
     enddo
   enddo
 enddo
 do ig = 1, Sigp%npwc
   do igp = 1, ig-1
     delta(ig,igp,:)=conjg(delta(igp,ig,:))
    enddo
 enddo

end subroutine calc_delta_ppm
!!***

!!{\src2tex{textfont=tt}}
!!****f* ABINIT/calc_delta_ppm2
!! NAME
!! calc_delta_ppm2
!!
!! FUNCTION
!! Calculation of the function \delta required for OPTIMAL GW
!!
!! INPUTS
!!
!! OUTPUT
!!
!! PARENTS
!!      Arjan_calc_sig_ppm,csigme
!!
!! CHILDREN
!!      calc_delta_ppm,calc_sig_ppm_delta_clos
!!      destroy_kb_potential,init_kb_potential,nullify_kb_potential
!!
!! SOURCE
#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"

subroutine calc_delta_ppm2(Sigp,nomega,otq,omegame0k,omegame0lumo,npwc2, &
&                          qbzpg,ikbz,jkbz,ptwsq,delta,niter)

 use defs_basis
 use m_errors
 use m_gwdefs

 implicit none

!Arguments ------------------------------------
!scalars
 type(Sigma_parameters),intent(in) :: Sigp

 integer,intent(in) :: npwc2,nomega,niter
!arrays
 real(dp),intent(in) :: omegame0k(nomega),omegame0lumo(nomega)
 complex(gwpc),intent(in) :: otq(Sigp%npwc,npwc2)
 complex(gwpc),intent(in) :: ptwsq(Sigp%npwc,Sigp%npwc,niter+1)
 complex(gwpc),intent(out) :: delta(Sigp%npwc,Sigp%npwc,nomega)

!Local variables-------------------------------
!scalars
 integer :: ig,igp,ios,ikbz,jkbz
 real(dp) :: otw,omegakg
 complex(gwpc) :: daux(niter)
!arrays
 real(dp),intent(in) :: qbzpg(Sigp%npwc)
 complex(gwpc), allocatable :: deltaux(:,:,:)
 real(dp) :: bq,bqp

 integer :: iter

 real(dp) :: delta_huge,denchk,test

 logical :: ggpnonzero

 complex(gwpc) :: dfrac(niter)

!*************************************************************************

 allocate(deltaux(Sigp%npwc,Sigp%npwc,nomega))

 if (niter==0) then

   do igp=1,Sigp%npwc
     bqp=0.5*qbzpg(igp)*qbzpg(igp)
     do ig=1,Sigp%npwc
       deltaux(ig,igp,:) = bqp
     enddo
   enddo

 elseif(niter==1) then

   do igp=1,Sigp%npwc
     bqp=0.5*qbzpg(igp)*qbzpg(igp)
     do ig=1,Sigp%npwc
       ggpnonzero=(ig/=1.and.igp/=1)
       if (ikbz/=jkbz.or.ggpnonzero) then
         denchk=abs(real(ptwsq(ig,igp,1)))+abs(aimag(ptwsq(ig,igp,1)))
         if (denchk>0.0) then
           dfrac(1)=ptwsq(ig,igp,2)/ptwsq(ig,igp,1)
         else
           dfrac(1)=cmplx(delta_huge,0.0)
         endif
         deltaux(ig,igp,1) = bqp + dfrac(1)
       else
         deltaux(ig,igp,1) = (0.0,0.0)
       endif
     end do !ig
   end do !igp

   do ios = 2, nomega
     deltaux(:,:,ios) = deltaux(:,:,1)
   enddo

 elseif(niter==2) then

   do igp=1,Sigp%npwc
     bqp=0.5*qbzpg(igp)*qbzpg(igp)
     do ig=1,Sigp%npwc
       ggpnonzero=(ig/=1.and.igp/=1)
       if (ikbz/=jkbz.or.ggpnonzero) then
         do iter = 1, 2
           if (real(ptwsq(ig,igp,iter))==0d0.and.aimag(ptwsq(ig,igp,iter))==0d0) then
             dfrac(iter)=cmplx(delta_huge,0.0)
           else
             dfrac(iter)=ptwsq(ig,igp,iter+1)/ptwsq(ig,igp,iter)
           endif
         enddo
         bq=0.5*qbzpg(ig)*qbzpg(ig)
         otw=DBLE(otq(ig,igp)) !in principle otw -> otw - ieta
         do ios=1,nomega
           omegakg=omegame0k(ios)-otw
           daux(1) = omegakg-bqp-dfrac(1)
           daux(2) = omegakg-bq-dfrac(2)
           deltaux(ig,igp,ios) = bqp + dfrac(1)*daux(1)/daux(2)
         enddo
       else
         deltaux(ig,igp,:) = (0.0,0.0)
       endif
     end do !igp
   end do !ig

 endif

 do ig = 1, Sigp%npwc
   do igp = 1, ig
     ggpnonzero=(ig/=1.and.igp/=1)
     if (ikbz/=jkbz.or.ggpnonzero) then
       do ios = 1, nomega
         delta(ig,igp,ios)=0.5*(deltaux(ig,igp,ios)+conjg(deltaux(igp,ig,ios)))
         if (ig==igp) then
           delta(ig,igp,ios)=real(delta(ig,igp,ios))
           test=omegame0k(ios)-real(delta(ig,igp,ios))
           if (test>omegame0lumo(ios).and.niter>0) then
             delta(ig,igp,ios)=0.25*qbzpg(ig)**2+0.25*qbzpg(igp)**2
             test=omegame0k(ios)-real(delta(ig,igp,ios))
           endif
           if (test>omegame0lumo(ios)) then
             delta(ig,igp,ios)=omegame0k(ios)-omegame0lumo(ios)
           endif
         else
           test=omegame0k(ios)-real(delta(ig,igp,ios))
           if (test>omegame0lumo(ios)) then
             delta(ig,igp,ios)=omegame0k(ios)-omegame0lumo(ios)
           endif
         endif
       enddo
     else
       delta(ig,igp,:)=(0.0,0.0)
     endif
   enddo
 enddo
 do ig = 1, Sigp%npwc
   do igp = 1, ig-1
     delta(igp,ig,:)=conjg(delta(ig,igp,:))
    enddo
 enddo

 deallocate(deltaux)

end subroutine calc_delta_ppm2
!!***

!----------------------------------------------------------------------

!!****f* ABINIT/calc_sig_ppm_delta
!! NAME
!! calc_sig_delta_ppm
!!
!! FUNCTION
!! Calculation of the part of the matrix elements of the self-energy coming from the sum
!! over the valence states in OPTIMAL GW
!!
!! INPUTS
!!
!! OUTPUT
!!
!! PARENTS
!!
!! CHILDREN
!!  
!!
!! SOURCE

subroutine calc_sig_ppm_delta(npwc,nomega,rhotwgp,botsq,otq,omegame0i,zcut,theta_mu_minus_e0i, &
&                             ket,npwx,npwc1,npwc2,omega4sd,e0,delta)

 use defs_basis
 use m_errors

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: nomega,npwc,npwc1,npwc2,npwx
 real(dp),intent(in) :: theta_mu_minus_e0i,zcut
!arrays
 real(dp),intent(in) :: omegame0i(nomega),e0
 complex(dpc),intent(in) :: omega4sd(nomega)
 complex(gwpc),intent(in) :: otq(npwc,npwc2)
 complex(gwpc),intent(in) :: botsq(npwc,npwc1)
 complex(gwpc),intent(in) :: rhotwgp(npwx)
 complex(gwpc),intent(in) :: delta(npwc,npwc,nomega)
 complex(gwpc),intent(inout) :: ket(npwc,nomega)

!Local variables-------------------------------
!scalars
 integer :: ig,igp,ios
 real(dp) :: den,omegame0i_io,otw,twofm1_zcut
 complex(gwpc) :: num,den2,rhotwgdp_igp
 logical :: fully_occupied,totally_empty

!*************************************************************************

  fully_occupied=(abs(theta_mu_minus_e0i-1.)<0.001)
  totally_empty=(abs(theta_mu_minus_e0i)<0.001)

  if (.not.(totally_empty)) then
   twofm1_zcut=zcut

   do ios=1,nomega
    omegame0i_io=omegame0i(ios)
    do igp=1,npwc
     rhotwgdp_igp=rhotwgp(igp)
     do ig=1,npwc
      otw=DBLE(otq(ig,igp)) !in principle otw -> otw - ieta
      num = botsq(ig,igp)*rhotwgdp_igp
      den = omegame0i_io+otw

      if (den**2>zcut**2)then
       ket(ig,ios) = ket(ig,ios) + num/(den*otw) * theta_mu_minus_e0i
      else
       ket(ig,ios) = ket(ig,ios) + num*cmplx(den,twofm1_zcut)/((den**2+twofm1_zcut**2)*otw)&
&                            *theta_mu_minus_e0i
      end if
     end do !ig
    end do !igp
   end do !ios

  end if !not totally empty


  if (.not.(totally_empty)) then
   twofm1_zcut=-zcut

   do ios=1,nomega
    omegame0i_io=DBLE(omega4sd(ios)) - e0
    do igp=1,npwc
     rhotwgdp_igp=rhotwgp(igp)
     do ig=1,npwc
      otw=DBLE(otq(ig,igp)) !in principle otw -> otw - ieta
      num = botsq(ig,igp)*rhotwgdp_igp
      den2 = omegame0i_io-otw-delta(ig,igp,ios)

      if (real(conjg(den2)*den2)>zcut**2) then
       ket(ig,ios) = ket(ig,ios) - num/(den2*otw)*theta_mu_minus_e0i
      else
       ket(ig,ios) = ket(ig,ios) - num*(den2+cmplx(0.0,twofm1_zcut))/((den2**2+twofm1_zcut**2)*otw) &
&                           *theta_mu_minus_e0i
      end if
     end do !ig
    end do !igp
   end do !ios

  end if

  if (.not.(fully_occupied)) then
   twofm1_zcut=-zcut

   do ios=1,nomega
    omegame0i_io=DBLE(omega4sd(ios)) - e0
    do igp=1,npwc
     rhotwgdp_igp=rhotwgp(igp)
     do ig=1,npwc
      otw=DBLE(otq(ig,igp)) !in principle otw -> otw - ieta
      num = botsq(ig,igp)*rhotwgdp_igp
      den2 = omegame0i_io-otw-delta(ig,igp,ios)

      if (real(conjg(den2)*den2)>zcut**2) then
       ket(ig,ios) = ket(ig,ios) - num/(den2*otw)*(1.-theta_mu_minus_e0i)
      else
       ket(ig,ios) = ket(ig,ios) - num*(den2+cmplx(0.0,twofm1_zcut))/((den2**2+twofm1_zcut**2)*otw) &
&                           *(1.-theta_mu_minus_e0i)
      end if
     end do !ig
    end do !igp
   end do !ios

   do ios=1,nomega
    omegame0i_io=omegame0i(ios)
    do igp=1,npwc
     rhotwgdp_igp=rhotwgp(igp)
     do ig=1,npwc
      otw=DBLE(otq(ig,igp)) !in principle otw -> otw - ieta
      num = botsq(ig,igp)*rhotwgdp_igp

      den = omegame0i_io-otw
      if (den**2>zcut**2) then
       ket(ig,ios) = ket(ig,ios) + num/(den*otw)*(1.-theta_mu_minus_e0i)
      else
       ket(ig,ios) = ket(ig,ios) + num*cmplx(den,twofm1_zcut)/((den**2+twofm1_zcut**2)*otw) &
&                           *(1.-theta_mu_minus_e0i)
      end if
     end do !ig
    end do !igp
   end do !ios

  end if

  ket(:,:)=ket(:,:)*0.5

end subroutine calc_sig_ppm_delta
!!***

!----------------------------------------------------------------------

!!****f* ABINIT/calc_sig_ppm_delta_clos
!! NAME
!! calc_sig_ppm_delta_clos
!!
!! FUNCTION
!! Calculation of the part of the matrix elements of the self-energy coming from
!! the sum over all the states in OPTIMAL GW
!!
!! INPUTS
!!
!! OUTPUT
!!
!! PARENTS
!!      Arjan_calc_sig_ppm,csigme
!!
!! CHILDREN
!!      calc_delta_ppm,calc_sig_ppm_delta_clos
!!      destroy_kb_potential,init_kb_potential,nullify_kb_potential
!!
!! SOURCE
subroutine calc_sig_ppm_delta_clos(npwc,nomega,botsq,otq,omegame0k,zcut,ptwg_kk, &
&                                   ket,npwc1,npwc2,delta)

 use defs_basis
 use m_errors

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: nomega,npwc,npwc1,npwc2
 real(dp),intent(in) :: zcut
!arrays
 real(dp),intent(in) :: omegame0k(nomega) 
 complex(gwpc),intent(in) :: otq(npwc,npwc2)
 complex(gwpc),intent(in) :: botsq(npwc,npwc1)
 complex(gwpc),intent(in) :: ptwg_kk(npwc,npwc)
 complex(gwpc),intent(in) :: delta(npwc,npwc,nomega)
 complex(dpc),intent(inout) :: ket(nomega)

!Local variables-------------------------------
!scalars
 integer :: ig,igp,ios
 real(dp) :: omegame0i_io,otw,twofm1_zcut
 complex(gwpc) :: den,num

!*************************************************************************

   twofm1_zcut=-zcut

   do ios=1,nomega
     omegame0i_io=omegame0k(ios)
     do ig=1,npwc
       do igp=1,npwc
         otw=DBLE(otq(ig,igp)) !in principle otw -> otw - ieta
         num = botsq(ig,igp)*ptwg_kk(ig,igp)
         den = omegame0i_io-otw-delta(ig,igp,ios)
         if (real(conjg(den)*den)>zcut**2) then
           ket(ios) = ket(ios) + 0.5*num/(den*otw)
         else
           ket(ios) = ket(ios) + 0.5*num*(den+cmplx(0.0,twofm1_zcut))/((den**2+twofm1_zcut**2)*otw)
         end if
       end do !igp
     end do !ig
   end do !ios

end subroutine calc_sig_ppm_delta_clos
!!***

!----------------------------------------------------------------------

!!****f* ABINIT/gw_EET
!! NAME
!! gw_EET
!!
!! FUNCTION
!! Wrapper routine for the calculation of the matrix elements of Sigma using GW_OPTIMAL
!!
!! INPUTS
!!
!! OUTPUT
!!
!! PARENTS
!!      csigme
!!
!! CHILDREN
!!      calc_delta_ppm,calc_sig_ppm_delta_clos
!!      destroy_kb_potential,init_kb_potential,nullify_kb_potential
!!
!! SOURCE

subroutine gw_EET_sigma(Sigp,Sr,Dtset,Cryst,Wfs,Kmesh,Qmesh,Gsph_Max,Psps,Vcp,isppol, &
&                       iq_bz,ik_bz,jk_bz,ik_ibz,jk_ibz,itim_q,isym_q,iq_ibz,gvec,grottb, &
&                       tabr_ki,tabr_kj,spinrot_ki,spinrot_kj,ph_mkit,ph_mkjt, &
&                       nfftot_gw,ngfft_gw,use_padfft,igfftcg0,gw_gbound,gw_mgfft, &
&                       qp_occ,ib1,ib2,nomega_tot,nomega_sigc,fact_sp,nspinor, &
&                       botsq,otq,npwc1,npwc2,sigcme_tmp,sigc,nbmax,tim_fourdp, &
&                       wtqp,wtqm,MPI_enreg,extrapolar_distrb,can_symmetrize)

 use defs_basis
 use m_gwdefs
 use defs_datatypes
 use defs_abitypes
 use m_jolly_pointers
 use m_crystal
 use m_bz_mesh
 use m_gsphere
 use m_wfs
 use m_commutator_vkbr
 use m_errors

 use m_geometry,      only : normv, vdotw
 use m_coulombian,    only : coulombian_type

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_68_gw, except_this_one => gw_EET_sigma
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 type(Crystal_structure),intent(in) :: Cryst
 type(BZ_mesh_type),intent(in) :: Kmesh,Qmesh
 type(Coulombian_type),intent(in) :: Vcp
 type(Gvectors_type),intent(in) :: Gsph_Max
 type(Dataset_type),intent(in) :: Dtset
 type(Pseudopotential_type),intent(in) :: Psps
 type(Sigma_parameters),intent(in) :: Sigp
 type(Sigma_results),intent(in) :: Sr
 type(wfs_descriptor),intent(inout) :: Wfs
 type(MPI_type),intent(inout) :: MPI_enreg

 type(kb_potential) :: KBff_ki,KBff_kj

 integer,intent(in) :: nfftot_gw,ngfft_gw(18),tim_fourdp,use_padfft,gw_mgfft
 integer,intent(in) :: igfftcg0(Sigp%npwc)
 integer,intent(in) :: gw_gbound(2*gw_mgfft+8,2*use_padfft)

 integer,intent(in) :: isppol
 integer,intent(in) :: itim_q,isym_q,iq_ibz
 integer,intent(in) :: npwc1,npwc2
 integer,intent(in) :: nomega_tot,nomega_sigc
 integer,intent(in) :: gvec(3,Sigp%npwvec)
 integer,intent(in) :: nspinor
 integer,intent(in) :: tabr_ki(nfftot_gw),tabr_kj(nfftot_gw)
 integer,intent(in) :: iq_bz,ik_bz,jk_bz,ik_ibz,jk_ibz,ib1,ib2
 integer,intent(in) :: grottb(Sigp%npwvec,Gsph_Max%timrev,Gsph_Max%nsym)
 integer,intent(in) :: extrapolar_distrb(ib1:ib2,ib1:ib2,Kmesh%nbz,Wfs%nsppol)
 integer,intent(in) :: wtqp,wtqm
 integer,intent(out) :: nbmax
 real(dp),intent(in) :: spinrot_ki(4),spinrot_kj(4)
 complex(dpc),intent(in) ::  ph_mkit,ph_mkjt
 complex(dpc),intent(inout) :: sigcme_tmp(nomega_sigc,ib1:ib2,ib1:ib2,Sigp%nsppol*Sigp%nsig_ab)
 complex(dpc),intent(inout) :: sigc(2,nomega_sigc,ib1:ib2,ib1:ib2,Sigp%nsppol*Sigp%nsig_ab)
 logical,intent(in) :: can_symmetrize(Wfs%nsppol)

 real(dp),allocatable :: qplg(:,:)
 real(dp),allocatable :: kplqg(:)

 complex(gwpc),allocatable :: vc_sqrt_qbz(:)

 complex(gwpc),allocatable :: fnlkr(:,:,:)
 complex(gwpc),allocatable :: fnlkpr(:,:,:)
 complex(gwpc),allocatable :: wfr1(:,:)
 complex(gwpc),allocatable :: wfr2(:)
 complex(gwpc),allocatable :: mtwk(:,:)
 complex(gwpc),allocatable :: mtwkp(:,:)

 complex(gwpc),allocatable :: ptwsq(:,:,:)

 complex(gwpc),allocatable :: delta(:,:,:)

 real(dp),intent(in) :: qp_occ(Sigp%nbnds,Kmesh%nibz,Sigp%nsppol)
 real(dp),intent(in) :: fact_sp

 complex(gwpc),intent(in) :: otq(Sigp%npwc,npwc2)
 complex(gwpc),intent(in) :: botsq(Sigp%npwc,npwc1)

 integer :: io,kb
 integer :: niter,nptwg,iter,nbhomo
 integer :: ig,igp,ib,ibv,iat,ilm,i
 integer :: isym_kgw,isym_ki,iik,jik

 real(dp),allocatable :: omegame0k(:),omegame0lumo(:)

 real(dp),allocatable :: qbzpg(:) 

 character(len=fnlen) :: title
 integer :: lloc,lmax,mmax,pspcod,pspdat,pspxc
 integer :: ityp
 integer :: fnlloc(Cryst%ntypat,2),fnlmax(Cryst%ntypat)
 real(dp) :: r2well,zion,znucl

 complex(dpc) :: sigctmp(nomega_sigc)

!************************************************************************

 ! min and Max band indeces for GW corrections (for this k-point)

 nbhomo=1
 do ib = 2, Sigp%nbnds 
   if (fact_sp*qp_occ(ib,jk_ibz,isppol)<GW_TOL_DOCC) exit
   nbhomo=nbhomo+1
 enddo
 nbmax=max(nbhomo,Dtset%gw_EET_nband)

 !allocate(val_idx(QP_BSt%nkpt,QP_BSt%nsppol))
 !val_idx = get_valence_idx(QP_BSt,tol3)
 !do isppol=1,nsppol
 ! nbhomo(isppol) = val_idx(1,isppol)
 ! ltest = ALL(val_idx(:,isppol))==val_idx(1,isppol),
 ! ABI_CHECK(ltest,"Optimal GW + metals not coded")
 !end do
 !deallocate(val_idx)

 niter = Dtset%gw_EET
 nptwg=1
 do iter = 1, niter
   nptwg=nptwg+mod(iter,2)
 enddo

 allocate(vc_sqrt_qbz(Sigp%npwc))
 do ig=1,Sigp%npwc
   vc_sqrt_qbz(grottb(ig,itim_q,isym_q))=Vcp%vc_sqrt(ig,iq_ibz)
 end do

 !@Arjan: nomega replaced by nomega_tot = no freqs. for sigma derivatives + no.
 !freqs for spectral function.
 allocate(omegame0k(nomega_tot))
 allocate(omegame0lumo(nomega_tot))
 allocate(qplg(Sigp%npwc,3))
 allocate(kplqg(Sigp%npwc))
 allocate(qbzpg(Sigp%npwc))

 isym_kgw = Kmesh%tabo(jk_bz)
 jik = (3-Kmesh%tabi(jk_bz))/2

 isym_ki = Kmesh%tabo(ik_bz)
 iik = (3-Kmesh%tabi(ik_bz))/2

 do ig=1,Sigp%npwc
   qplg(ig,:) = Qmesh%bz(:,iq_bz) + gvec(:,ig)
   kplqg(ig) = -vdotw(Kmesh%bz(:,jk_bz),qplg(ig,:),Cryst%gmet,"G")
   qbzpg(ig) = normv(qplg(ig,:),Cryst%gmet,"G")
 end do

 fnlloc(:,:)=0
 fnlmax(:)=0
 do ityp = 1, Cryst%ntypat
   open (unit=tmp_unit,file=psps%filpsp(ityp),form='formatted',status='old')
   rewind (unit=tmp_unit)
   read (tmp_unit,'(a)') title
   read (tmp_unit,*) znucl,zion,pspdat
   read (tmp_unit,*) pspcod,pspxc,lmax,lloc,mmax,r2well
   do i = 1, lloc
     fnlloc(ityp,1) = fnlloc(ityp,1) + 2*(lloc-1)+1
   enddo
   fnlloc(ityp,1)=fnlloc(ityp,1)+1
   do i = 1, lloc+1
     fnlloc(ityp,2) = fnlloc(ityp,2) + 2*(lloc-1)+1
   enddo
   do i = 1, lmax+1
     fnlmax(ityp) = fnlmax(ityp) + 2*(lmax-1)+1
   enddo
 enddo

 !MG KB form factors: to be done outside. array dimensioned with Kmesh%nibz
 if (niter>0) then
   call nullify_kb_potential(KBff_ki)
   call nullify_kb_potential(KBff_kj)

   call init_kb_potential(KBff_ki,Cryst,Psps,2,Sigp%npwwfn,Kmesh%ibz(:,ik_ibz),gvec)
   call init_kb_potential(KBff_kj,Cryst,Psps,2,Sigp%npwwfn,Kmesh%ibz(:,jk_ibz),gvec)
   deallocate(KBff_ki%fnld)
   deallocate(KBff_kj%fnld)
 endif

 !MG: note that it is not necessary to rotate fnl in the full BZ to
 !calculate
 !<SK|V_nl|Sk>.
 !MG check this part in parallel. Keep in mind the difference between
 !Wfs_braket (bdgw states= and Wfs (full set distributed
 !across the nod

 !MG check Sigp%nbnds dimension.  !Mind here wfs here

 allocate(fnlkr(Wfs%nfftot*nspinor,Psps%mpsang*Psps%mpsang,Cryst%natom))
 allocate(fnlkpr(Wfs%nfftot*nspinor,Psps%mpsang*Psps%mpsang,Cryst%natom))

 if (niter>0) then
   do iat = 1, Cryst%natom
     do ilm = 1, Psps%mpsang*Psps%mpsang
       if (ilm>fnlmax(Cryst%typat(iat))) CYCLE
       if (ilm>=fnlloc(Cryst%typat(iat),1).and.ilm<=fnlloc(Cryst%typat(iat),2)) CYCLE
       call fft_onewfn(Wfs%paral_kgb,Wfs%istwfk(ik_ibz),nspinor,Sigp%npwwfn,Wfs%nfftot, &
&                      conjg(KBff_ki%fnl(:,ilm,iat)),fnlkr(:,ilm,iat),Wfs%igfft0,Wfs%ngfft, &
&                      Wfs%gvec,Wfs%gbound,tim_fourdp,MPI_enreg)
       call fft_onewfn(Wfs%paral_kgb,Wfs%istwfk(jk_ibz),nspinor,Sigp%npwwfn,Wfs%nfftot, &
&                      conjg(KBff_kj%fnl(:,ilm,iat)),fnlkpr(:,ilm,iat),Wfs%igfft0,Wfs%ngfft, &
&                      Wfs%gvec,Wfs%gbound,tim_fourdp,MPI_enreg)
     enddo
   enddo
   call destroy_kb_potential(KBff_ki)
   call destroy_kb_potential(KBff_kj)
 endif

 allocate(mtwk(Wfs%nfftot*nspinor,nbmax))
 allocate(mtwkp(Wfs%nfftot*nspinor,ib1:ib2))

 if (niter>0) then
   call calc_EET_sig_prep(Sigp,Cryst,Wfs,Kmesh,Psps,isppol,nbmax,ib1,ib2,ik_ibz,jk_ibz, &
&                         nspinor,fnlloc,fnlmax,fnlkr,fnlkpr,mtwk,mtwkp)
 endif

 allocate(wfr1(Wfs%nfftot*nspinor,nbmax))

 do ibv = 1, nbmax
   call wfd_get_ur(Wfs,ibv,ik_ibz,isppol,wfr1(:,ibv))
 enddo

 do kb = ib1,ib2

   if (extrapolar_distrb(kb,kb,ik_bz,isppol)/=Wfs%my_rank) CYCLE

   allocate(delta(Sigp%npwc,Sigp%npwc,nomega_tot))
   allocate(ptwsq(Sigp%npwc,Sigp%npwc,niter+1))
   allocate(wfr2(Wfs%nfftot*nspinor))

   call wfd_get_ur(Wfs,kb,jk_ibz,isppol,wfr2)

   do io=1,Sr%nomega4sd
     omegame0k(io)  = real(Sr%omega4sd(kb,jk_ibz,io,isppol)) - sr%e0(kb,jk_ibz,isppol)
     omegame0lumo(io)= real(Sr%omega4sd(kb,jk_ibz,io,isppol)) - sr%e0(nbmax+1,ik_ibz,isppol)
   end do

   sigctmp=czero_gw

   call fft4EET_sig(Sigp,Dtset,Cryst,Wfs,Kmesh,Psps,Sr,nbhomo,nbmax,nomega_tot,isppol,nfftot_gw,ngfft_gw, &
&               use_padfft,igfftcg0,gw_gbound,gw_mgfft,iik,tabr_ki,ph_mkit,spinrot_ki, &
&               ik_ibz,jk_ibz,isym_kgw,jik,tabr_kj,ph_mkjt,spinrot_kj,Gsph_Max%rottbm1, &
&               nspinor,tim_fourdp,MPI_enreg,fnlloc,fnlmax,fnlkr,mtwk,mtwkp(:,kb),wfr1,wfr2, &
&               vc_sqrt_qbz,Vcp%i_sz,kb,qplg,kplqg,niter,ptwsq,ik_bz,jk_bz,npwc1,npwc2,botsq,otq, &
&               sigctmp)

   call calc_delta_ppm2(Sigp,nomega_tot,otq,omegame0k,omegame0lumo,npwc2,qbzpg,ik_bz,jk_bz,ptwsq,delta, &
&                       niter)

   do ig = 1, Sigp%npwc
     do igp = 1, Sigp%npwc
       if (ik_bz==jk_bz) then
         if (ig/=1.and.igp/=1) then
           ptwsq(ig,igp,1)= ptwsq(ig,igp,1)*vc_sqrt_qbz(ig)*vc_sqrt_qbz(igp)
         else
           if (kb<=nbmax) then
             ptwsq(ig,igp,1)=(0.0,0.0)
           else
             if (ig==1.and.igp==1) then
               ptwsq(ig,igp,1) = cmplx(Vcp%i_sz,0.0_gwp)
             elseif (ig==1.and.igp/=1) then
               ptwsq(ig,igp,1) = cmplx(sqrt(Vcp%i_sz),0.0_gwp)*ptwsq(ig,igp,1)*vc_sqrt_qbz(igp)
             elseif (igp==1.and.ig/=1) then
               ptwsq(ig,igp,1) = cmplx(sqrt(Vcp%i_sz),0.0_gwp)*ptwsq(ig,igp,1)*vc_sqrt_qbz(ig)
             else
               ptwsq(ig,igp,1)= ptwsq(ig,igp,1)*vc_sqrt_qbz(ig)*vc_sqrt_qbz(igp)
             endif
           endif
         endif
       else
         ptwsq(ig,igp,1)= ptwsq(ig,igp,1)*vc_sqrt_qbz(ig)*vc_sqrt_qbz(igp)
       endif
     enddo
   enddo

   call calc_sig_ppm_delta_clos(Sigp%npwc,nomega_tot,botsq,otq,omegame0k,Sigp%zcut,ptwsq(:,:,1), &
&                               sigctmp,npwc1,npwc2,delta)
 
   if (can_symmetrize(isppol)) then
     sigcme_tmp(:,kb,kb,isppol)=sigcme_tmp(:,kb,kb,isppol) + &
       (wtqp+wtqm)*DBLE(sigctmp(:)) + (wtqp-wtqm)*j_gw*AIMAG(sigctmp(:))
     sigc(1,:,kb,kb,isppol)=sigc(1,:,kb,kb,isppol) + wtqp*      sigctmp(:)
     sigc(2,:,kb,kb,isppol)=sigc(2,:,kb,kb,isppol) + wtqm*CONJG(sigctmp(:))
   else
     sigcme_tmp(:,kb,kb,isppol)=sigcme_tmp(:,kb,kb,isppol)+sigctmp(:)
   endif

   deallocate(wfr2)
   deallocate(ptwsq)
   deallocate(delta)

 enddo

 deallocate(wfr1)
 deallocate(mtwk)
 deallocate(mtwkp)
 deallocate(fnlkr)
 deallocate(fnlkpr)
 deallocate(vc_sqrt_qbz)
 deallocate(omegame0k)
 deallocate(omegame0lumo)
 deallocate(qplg,kplqg,qbzpg)

 nbmax=nbhomo

end subroutine gw_EET_sigma

subroutine gw_EET_chi0(Ep,Dtset,Cryst,Wfs,Kmesh,Gsph_epsG0,Gsph_wfn,Psps,Ltg_q,nbvw,qpoint, &
&                      nfftot_gw,ngfft_gw,use_padfft,igfftepsG0,gw_gbound,gw_mgfft,is, &
&                      ik_bz,ik_ibz,isym_k,itim_k,tabr_k,ph_mkt,spinrot_k, &
&                      ikmq_ibz,itim_kmq,tabr_kmq,ph_mkmqt,spinrot_kmq,dim_rtwg, &
&                      qp_energy,chi0,spin_fact,qp_occ,nspinor,tim_fourdp,bbp_ks_distrb,nbmax)

 use defs_basis
 use m_gwdefs
 use defs_datatypes
 use defs_abitypes
 use m_jolly_pointers
 use m_crystal
 use m_bz_mesh
 use m_gsphere
 use m_wfs
 use m_commutator_vkbr
 use m_errors

 use m_geometry,      only : normv,vdotw
 use m_coulombian,    only : coulombian_type

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_68_gw, except_this_one => gw_EET_chi0
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 type(Crystal_structure),intent(in) :: Cryst
 type(BZ_mesh_type),intent(in) :: Kmesh
 type(Gvectors_type),intent(in) :: Gsph_epsG0,Gsph_wfn
 type(Dataset_type),intent(in) :: Dtset
 type(Pseudopotential_type),intent(in) :: Psps
 type(Epsilonm1_parameters),intent(in) :: Ep
 type(wfs_descriptor),intent(inout) :: Wfs
 type(kb_potential) :: KBff_k_ibz,KBff_kmq_ibz
 type(Little_group),intent(in) :: Ltg_q

 integer,intent(in) :: nbvw,nfftot_gw,ngfft_gw(18),nspinor,tim_fourdp,use_padfft,gw_mgfft
 integer,intent(in) :: is
 integer,intent(in) :: isym_k,itim_k,itim_kmq
 integer,intent(in) :: tabr_k(nfftot_gw),tabr_kmq(nfftot_gw)
 integer,intent(in) :: igfftepsG0(Ep%npwepG0)
 integer,intent(in) :: gw_gbound(2*gw_mgfft+8,2*use_padfft)
 integer,intent(in) :: dim_rtwg
 integer,intent(in) :: bbp_ks_distrb(nbvw,Kmesh%nbz,Wfs%nsppol)
 integer,intent(out) :: nbmax
 real(dp),intent(in) :: qp_occ(Ep%nbnds,Kmesh%nibz,Ep%nsppol)
 real(dp),intent(in) :: qp_energy(Ep%nbnds,Kmesh%nibz,Ep%nsppol)
 real(dp),intent(in) :: spinrot_k(4),spinrot_kmq(4),spin_fact

 complex(dpc),intent(in) :: ph_mkmqt,ph_mkt
 complex(gwpc),intent(inout) :: chi0(Ep%npwe*Ep%nI,Ep%npwe*Ep%nJ,Ep%nomega)

 real(dp),intent(in) :: qpoint(3)

 integer,intent(in) :: ik_bz,ik_ibz,ikmq_ibz

 integer :: ib,ibv
 integer :: niter,nptwg,iter
 integer :: ig

 real(dp),allocatable :: qpgsq(:)
 real(dp),allocatable :: qplg(:,:)
 real(dp),allocatable :: kplqg(:)
 complex(gwpc),allocatable :: fnlkr(:,:,:)
 complex(gwpc),allocatable :: fnlkpr(:,:,:)
 complex(gwpc),allocatable :: wfr1(:,:)
 complex(gwpc),allocatable :: wfr2(:,:)
 complex(gwpc),allocatable :: mtwk(:,:)
 complex(gwpc),allocatable :: mtwkp(:,:)

 complex(gwpc),allocatable :: ptwsq(:,:,:)
 complex(gwpc),allocatable :: delta(:,:,:)
 complex(gwpc),allocatable :: paux(:,:)

 integer :: nbhomo(2)
 integer :: i,ilm,iat

 character(len=fnlen) :: title
 integer :: lloc,lmax,mmax,pspcod,pspdat,pspxc
 integer :: ityp
 integer :: fnlloc(Cryst%ntypat,2),fnlmax(Cryst%ntypat)
 real(dp) :: r2well,zion,znucl

!************************************************************************

 nbhomo(:)=1
 do ib = 2, Ep%nbnds
   if (spin_fact*qp_occ(ib,ikmq_ibz,is)<GW_TOL_DOCC) exit
   nbhomo(1)=nbhomo(1)+1
 enddo
 do ib = 2, Ep%nbnds
   if (spin_fact*qp_occ(ib,ikmq_ibz,is)<(one-GW_TOL_DOCC)) exit
   nbhomo(2)=nbhomo(2)+1
 enddo
 nbmax=max(nbhomo(1),Dtset%gw_EET_nband)

 niter = Dtset%gw_EET
 nptwg=1
 do iter = 1, niter
   nptwg=nptwg+mod(iter,2)
 enddo

 allocate(qpgsq(Ep%npwe))
 allocate(qplg(Ep%npwe,3))
 allocate(kplqg(Ep%npwe))

 do ig=1,Ep%npwe
   qplg(ig,:) = qpoint(:)+ Gsph_epsG0%gvec(:,ig)
   kplqg(ig)=-vdotw(Kmesh%bz(:,ik_bz),qplg(ig,:),Cryst%gmet,"G")
   qpgsq(ig) = normv(qplg(ig,:),Cryst%gmet,"G")
 enddo
 qpgsq(:)=half*qpgsq(:)**2

 if (niter>0.and.Ep%inclvkb/=0) then

   fnlloc(:,:)=0
   fnlmax(:)=0
   do ityp = 1, Cryst%ntypat
     open (unit=tmp_unit,file=psps%filpsp(ityp),form='formatted',status='old')
     rewind (unit=tmp_unit)
     read (tmp_unit,'(a)') title
     read (tmp_unit,*) znucl,zion,pspdat
     read (tmp_unit,*) pspcod,pspxc,lmax,lloc,mmax,r2well
     do i = 1, lloc
       fnlloc(ityp,1) = fnlloc(ityp,1) + 2*(lloc-1)+1
     enddo
     fnlloc(ityp,1)=fnlloc(ityp,1)+1
     do i = 1, lloc+1
       fnlloc(ityp,2) = fnlloc(ityp,2) + 2*(lloc-1)+1
     enddo
     do i = 1, lmax+1
       fnlmax(ityp) = fnlmax(ityp) + 2*(lmax-1)+1
     enddo
   enddo

   !MG KB form factors: to be done outside. array dimensioned with Kmesh%nibz
   call nullify_kb_potential(KBff_k_ibz  )
   call nullify_kb_potential(KBff_kmq_ibz)

   call init_kb_potential(KBff_k_ibz ,Cryst,Psps,2,Ep%npwwfn,Kmesh%ibz(:,ik_ibz),Wfs%gvec)
   call init_kb_potential(KBff_kmq_ibz,Cryst,Psps,2,Ep%npwwfn,Kmesh%ibz(:,ikmq_ibz),Wfs%gvec)
   deallocate(KBff_k_ibz%fnld  )
   deallocate(KBff_kmq_ibz%fnld)

   allocate(fnlkpr(Wfs%nfftot*nspinor,Psps%mpsang*Psps%mpsang,Cryst%natom))
   allocate(fnlkr(Wfs%nfftot*nspinor,Psps%mpsang*Psps%mpsang,Cryst%natom))

   do iat = 1, Cryst%natom
     do ilm = 1, Psps%mpsang*Psps%mpsang
       if (ilm>fnlmax(Cryst%typat(iat))) CYCLE
       if (ilm>=fnlloc(Cryst%typat(iat),1).and.ilm<=fnlloc(Cryst%typat(iat),2)) CYCLE
       call fft_onewfn(Wfs%paral_kgb,Wfs%istwfk(ik_ibz),nspinor,Ep%npwwfn,Wfs%nfftot, &
&                      conjg(KBff_k_ibz%fnl(:,ilm,iat)),fnlkr(:,ilm,iat),Wfs%igfft0,Wfs%ngfft, &
&                      Wfs%gvec,Wfs%gbound,tim_fourdp,Wfs%MPI_enreg)
       call fft_onewfn(Wfs%paral_kgb,Wfs%istwfk(ikmq_ibz),nspinor,Ep%npwwfn,Wfs%nfftot, &
&                      conjg(KBff_kmq_ibz%fnl(:,ilm,iat)),fnlkpr(:,ilm,iat),Wfs%igfft0,Wfs%ngfft, &
&                      Wfs%gvec,Wfs%gbound,tim_fourdp,Wfs%MPI_enreg)
     enddo
   enddo

   call destroy_kb_potential(KBff_k_ibz  )
   call destroy_kb_potential(KBff_kmq_ibz)

 endif

 if (niter>0.and.Ep%inclvkb/=0) then
   allocate(mtwk(Wfs%nfftot*nspinor,nbhomo(1)))
   allocate(mtwkp(Wfs%nfftot*nspinor,nbmax))
   call calc_EET_prep(Ep,Cryst,Wfs,Kmesh,Psps,is,nbhomo(1),nbmax,ik_ibz,ikmq_ibz,nspinor, &
&                     fnlloc,fnlmax,fnlkr,fnlkpr,mtwk,mtwkp)
 endif

 allocate(wfr1(Wfs%nfftot*nspinor,nbmax))
 allocate(wfr2(Wfs%nfftot*nspinor,nbhomo(1)))

 do ibv = 1, nbmax
   call wfd_get_ur(Wfs,ibv,ikmq_ibz,is,wfr1(:,ibv))
 enddo
 do ibv = 1, nbhomo(1)
   call wfd_get_ur(Wfs,ibv,ik_ibz,is,wfr2(:,ibv))
 enddo

 if (niter==0) then
   allocate(delta(Ep%npwe,Ep%npwe,Ep%nomega))
   allocate(paux(Ep%npwe,Ep%npwe))
   call calc_delta0(Ep,qpgsq,delta)
   paux(:,:)=(0.0,0.0)
 endif

 do ibv = 1, nbhomo(1)

   if ((bbp_ks_distrb(ibv,ik_bz,is) /= Wfs%my_rank)) CYCLE

   if (niter>0) then
     allocate(delta(Ep%npwe,Ep%npwe,Ep%nomega))
   endif
   allocate(ptwsq(Ep%npwe,Ep%npwe,niter+1))

   if (niter==0.or.Ep%inclvkb==0) then
     call fft4EET(ik_bz,Ep,Cryst,Wfs,Kmesh,Gsph_epsG0,Ltg_q,nbhomo,nbmax, &
&                 is,nfftot_gw,ngfft_gw,use_padfft,igfftepsG0, &
&                 gw_gbound,gw_mgfft,ik_ibz,ikmq_ibz,isym_k,itim_k,tabr_k,ph_mkt,spinrot_k, &
&                 itim_kmq,tabr_kmq,ph_mkmqt,spinrot_kmq,dim_rtwg,Gsph_wfn%rottbm1, &
&                 nspinor,tim_fourdp,wfr1,wfr2,ibv,qplg,kplqg,niter,ptwsq, &
&                 spin_fact,qp_occ,qp_energy,chi0)
   else
     call fft4EET_kb(ik_bz,Ep,Cryst,Wfs,Kmesh,Gsph_epsG0,Ltg_q,Psps,nbhomo,nbmax, &
&                    is,nfftot_gw,ngfft_gw,use_padfft,igfftepsG0, &
&                    gw_gbound,gw_mgfft,ik_ibz,ikmq_ibz,isym_k,itim_k,tabr_k,ph_mkt,spinrot_k, &
&                    itim_kmq,tabr_kmq,ph_mkmqt,spinrot_kmq,dim_rtwg,Gsph_wfn%rottbm1, &
&                    nspinor,tim_fourdp,fnlloc,fnlmax,fnlkpr,mtwk,mtwkp,wfr1,wfr2,ibv,qplg,kplqg, &
&                    niter,ptwsq,spin_fact,qp_occ,qp_energy,chi0)
   endif

   call calc_delta_chi0(Ep,qpgsq,delta,ptwsq,qp_energy(ibv,ik_ibz,is), &
&                       qp_energy(nbmax+1,ikmq_ibz,is),niter)

   ptwsq(:,:,1)=spin_fact*qp_occ(ibv,ik_ibz,is)*ptwsq(:,:,1)
   if (niter==0) then
     call calc_chi0_delta0(ik_bz,Ep,Gsph_epsG0,Ltg_q,ptwsq(:,:,1),paux,chi0,delta)
   else
     call calc_chi0_delta_clos(ik_bz,Ep,Gsph_epsG0,Ltg_q,ptwsq(:,:,1),chi0,delta)
   endif

   deallocate(ptwsq)

   if (niter>0) then
     deallocate(delta)
   endif

 enddo

 if (niter==0) then
   call calc_chi0_delta0_bis(ik_bz,Ep,Gsph_epsG0,Ltg_q,paux,delta,chi0)
   deallocate(paux)
   deallocate(delta)
 endif
 deallocate(wfr1,wfr2)
 if (niter>0.and.Ep%inclvkb/=0) then
   deallocate(mtwk,mtwkp)
 endif


 if (niter>0.and.Ep%inclvkb/=0) then
   deallocate(fnlkr,fnlkpr)
 endif

 deallocate(qpgsq,qplg,kplqg)

 nbmax=0

end subroutine gw_EET_chi0

subroutine gw_EET_chi0q0(Ep,Dtset,Cryst,Wfs,Kmesh,Gsph_epsG0,Gsph_wfn,Psps,Ltg_q,nbvw,nspinor, &
&                        nfftot_gw,ngfft_gw,use_padfft,igffteps0,gw_gbound,gw_mgfft,is, &
&                        ik_bz,ik_ibz,isym_k,itim_k,tabr_k,ph_mkt,spinrot_k,dim_rtwg, &
&                        qp_energy,chi0,spin_fact,qp_occ,tim_fourdp,bbp_ks_distrb)

 use defs_basis
 use m_gwdefs
 use defs_datatypes
 use defs_abitypes
 use m_jolly_pointers
 use m_crystal
 use m_bz_mesh
 use m_gsphere
 use m_wfs
 use m_commutator_vkbr
 use m_errors
 use m_oscillators,   only : rho_tw_g

 use m_geometry,      only : normv,vdotw
 use m_coulombian,    only : coulombian_type

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_68_gw, except_this_one => gw_EET_chi0q0
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 type(Crystal_structure),intent(in) :: Cryst
 type(BZ_mesh_type),intent(in) :: Kmesh
 type(Gvectors_type),intent(in) :: Gsph_epsG0,Gsph_wfn
 type(Dataset_type),intent(in) :: Dtset
 type(Pseudopotential_type),intent(in) :: Psps
 type(Epsilonm1_parameters),intent(in) :: Ep
 type(wfs_descriptor),intent(inout) :: Wfs
 type(kb_potential) :: KBff_k_ibz
 type(Little_group),intent(in) :: Ltg_q

 integer,intent(in) :: is
 integer,intent(in) :: nbvw,nfftot_gw,ngfft_gw(18),use_padfft,gw_mgfft
 integer,intent(in) :: igffteps0(Ep%npwepG0)
 integer,intent(in) :: gw_gbound(2*gw_mgfft+8,2*use_padfft)
 integer,intent(in) :: isym_k,itim_k
 integer,intent(in) :: tabr_k(nfftot_gw)
 integer,intent(in) :: nspinor,tim_fourdp
 integer,intent(in) :: dim_rtwg
 integer,intent(in) :: bbp_ks_distrb(nbvw,Kmesh%nbz,Wfs%nsppol)
 real(dp),intent(in) :: spinrot_k(4)
 real(dp),intent(in) :: qp_occ(Ep%nbnds,Kmesh%nibz,Ep%nsppol)
 real(dp),intent(in) :: qp_energy(Ep%nbnds,Kmesh%nibz,Ep%nsppol)
 real(dp),intent(in) :: spin_fact
 complex(dpc),intent(in) :: ph_mkt
 complex(gwpc),intent(inout) :: chi0(Ep%npwe*Ep%nI,Ep%npwe*Ep%nJ,Ep%nomega)

 real(dp),allocatable :: qpgsq(:)
 real(dp),allocatable :: qplg(:,:)
 real(dp),allocatable :: kplqg(:)
 complex(gwpc),allocatable :: fnlkr(:,:,:)
 complex(gwpc),allocatable :: wfr1(:,:)
 complex(gwpc),allocatable :: mtwk(:,:)

 complex(gwpc),allocatable :: ptwsq(:,:,:)
 complex(gwpc),allocatable :: delta(:,:,:)
 complex(gwpc),allocatable :: paux(:,:)

 integer,intent(in) :: ik_bz,ik_ibz

 integer :: nbhomo(2),nbmax
 integer :: ib,ibv
 integer :: niter,nptwg,iter
 integer :: ig,i,ilm,iat
 integer :: isym_ki,iik

 character(len=fnlen) :: title
 integer :: lloc,lmax,mmax,pspcod,pspdat,pspxc
 integer :: ityp
 integer :: fnlloc(Cryst%ntypat,2),fnlmax(Cryst%ntypat)
 real(dp) :: r2well,zion,znucl

!************************************************************************

 !@Arjan: 
 ! 1) Now  Wfs_val == Wfs see the parent. Thus Wfs contains the entire set of 
 !    occupied states + a buffer of empty bands (MPI distributed)
 !    Please, change the code accordingly i.e. pass a single wfs_descriptor object and change Wfs_val --> Wfs 
 ! 2) wfs_descriptor has undergone several changes. %ug and %ur does not exist anymore
 !    You have to use Wfs%Wave(b,k,s)%ug to access the Fourier components. 

 nbhomo(:)=1
 do ib = 2, Ep%nbnds
   if (spin_fact*qp_occ(ib,ik_ibz,is)<GW_TOL_DOCC) exit
   nbhomo(1)=nbhomo(1)+1
 enddo
 do ib = 2, Ep%nbnds
   if (spin_fact*qp_occ(ib,ik_ibz,is)<(one-GW_TOL_DOCC)) exit
   nbhomo(2)=nbhomo(2)+1
 enddo
 nbmax=max(nbhomo(1),Dtset%gw_EET_nband)

 niter = Dtset%gw_EET
 nptwg=1
 do iter = 1, niter
  nptwg=nptwg+mod(iter,2)
 enddo

 !@Arjan: nomega replaced by nomega_tot = no freqs. for sigma derivatives + no.
 !freqs for spectral function.
 allocate(qpgsq(Ep%npwe))
 allocate(qplg(Ep%npwe,3))
 allocate(kplqg(Ep%npwe))

 do ig=1,Ep%npwe
   qplg(ig,:) = Ep%qlwl(:,1) + Gsph_epsG0%gvec(:,ig)
   kplqg(ig)=-vdotw(Kmesh%bz(:,ik_bz),qplg(ig,:),Cryst%gmet,"G")
   qpgsq(ig) = normv(qplg(ig,:),Cryst%gmet,"G")
 enddo
 qpgsq(:)=half*qpgsq(:)**2

 isym_ki = Kmesh%tabo(ik_bz)
 iik = (3-Kmesh%tabi(ik_bz))

 if (niter>0.and.Ep%inclvkb/=0) then

   fnlloc(:,:)=0
   fnlmax(:)=0
   do ityp = 1, Cryst%ntypat
     open (unit=tmp_unit,file=psps%filpsp(ityp),form='formatted',status='old')
     rewind (unit=tmp_unit)
     read (tmp_unit,'(a)') title
     read (tmp_unit,*) znucl,zion,pspdat
     read (tmp_unit,*) pspcod,pspxc,lmax,lloc,mmax,r2well
     do i = 1, lloc
       fnlloc(ityp,1) = fnlloc(ityp,1) + 2*(lloc-1)+1
     enddo
     fnlloc(ityp,1)=fnlloc(ityp,1)+1
     do i = 1, lloc+1
       fnlloc(ityp,2) = fnlloc(ityp,2) + 2*(lloc-1)+1
     enddo
     do i = 1, lmax+1
       fnlmax(ityp) = fnlmax(ityp) + 2*(lmax-1)+1
     enddo
   enddo

   call nullify_kb_potential(KBff_k_ibz)
   call init_kb_potential(KBff_k_ibz,Cryst,Psps,2,Ep%npwwfn,Kmesh%ibz(:,ik_ibz),Wfs%gvec)
   deallocate(KBff_k_ibz%fnld)

   allocate(fnlkr(Wfs%nfftot*nspinor,Psps%mpsang*Psps%mpsang,Cryst%natom))

   do iat = 1, Cryst%natom
     do ilm = 1, Psps%mpsang*Psps%mpsang
       if (ilm>fnlmax(Cryst%typat(iat))) CYCLE
       if (ilm>=fnlloc(Cryst%typat(iat),1).and.ilm<=fnlloc(Cryst%typat(iat),2)) CYCLE
       call fft_onewfn(Wfs%paral_kgb,Wfs%istwfk(ik_ibz),nspinor,Ep%npwwfn,Wfs%nfftot, &
&                      conjg(KBff_k_ibz%fnl(:,ilm,iat)),fnlkr(:,ilm,iat),Wfs%igfft0,Wfs%ngfft, &
&                      Wfs%gvec,Wfs%gbound,tim_fourdp,Wfs%MPI_enreg)
     enddo
   enddo

   call destroy_kb_potential(KBff_k_ibz)

 endif

 if (niter>0.and.Ep%inclvkb/=0) then
   allocate(mtwk(Wfs%nfftot*nspinor,nbmax))
   call calc_EET_prep_q0(Ep,Cryst,Wfs,Kmesh,Psps,is,nbmax,ik_ibz,nspinor,fnlloc,fnlmax,fnlkr,mtwk)
 endif

 allocate(wfr1(Wfs%nfftot*nspinor,nbmax))

 do ibv = 1, nbmax
   call wfd_get_ur(Wfs,ibv,ik_ibz,is,wfr1(:,ibv))
 enddo

 if (niter==0) then
   allocate(delta(Ep%npwe,Ep%npwe,Ep%nomega))
   allocate(paux(Ep%npwe,Ep%npwe))
   paux(:,:)=(0.0,0.0)
   call calc_delta0(Ep,qpgsq,delta)
 endif

 do ibv = 1, nbhomo(1)

   if ((bbp_ks_distrb(ibv,ik_bz,is) /= Wfs%my_rank)) CYCLE

   if (niter>0) then
     allocate(delta(Ep%npwe,Ep%npwe,Ep%nomega))
   endif
   allocate(ptwsq(Ep%npwe,Ep%npwe,niter+1))

   if (niter==0.or.Ep%inclvkb==0) then

     call fft4EET_q0(ik_bz,Ep,Cryst,Wfs,Kmesh,Gsph_epsG0,Ltg_q,nbhomo,nbmax, &
&                    is,nfftot_gw,ngfft_gw,use_padfft,igffteps0, &
&                    gw_gbound,gw_mgfft,ik_ibz,isym_k,itim_k,tabr_k,ph_mkt,spinrot_k, &
&                    dim_rtwg,Gsph_wfn%rottbm1,nspinor,tim_fourdp,wfr1,ibv, &
&                    qplg,kplqg,niter,ptwsq,spin_fact,qp_occ,qp_energy,chi0)

   else

     call fft4EET_q0_kb(ik_bz,Ep,Cryst,Wfs,Kmesh,Gsph_epsG0,Ltg_q,Psps,nbhomo,nbmax, &
&                       is,nfftot_gw,ngfft_gw,use_padfft,igffteps0, &
&                       gw_gbound,gw_mgfft,ik_ibz,isym_k,itim_k,tabr_k,ph_mkt,spinrot_k, &
&                       dim_rtwg,Gsph_wfn%rottbm1,nspinor,tim_fourdp,fnlloc,fnlmax,fnlkr,mtwk,wfr1,ibv, &
&                       qplg,kplqg,niter,ptwsq,spin_fact,qp_occ,qp_energy,chi0)

   endif

   call calc_delta_chi0(Ep,qpgsq,delta,ptwsq,qp_energy(ibv,ik_ibz,is), &
&                       qp_energy(nbmax+1,ik_ibz,is),niter)

   ptwsq(:,:,1)=spin_fact*qp_occ(ibv,ik_ibz,is)*ptwsq(:,:,1)
   ptwsq(1,:,1)=(0.0,0.0)
   ptwsq(:,1,1)=(0.0,0.0)
   if (niter==0) then
     call calc_chi0_delta0(ik_bz,Ep,Gsph_epsG0,Ltg_q,ptwsq(:,:,1),paux,chi0,delta)
   else
     call calc_chi0_delta_clos(ik_bz,Ep,Gsph_epsG0,Ltg_q,ptwsq(:,:,1),chi0,delta)
   endif

   deallocate(ptwsq)

   if (niter>0) then
     deallocate(delta)
   endif

 enddo

 if (niter==0) then
   call calc_chi0_delta0_bis(ik_bz,Ep,Gsph_epsG0,Ltg_q,paux,delta,chi0)
   deallocate(paux)
   deallocate(delta)
 endif
 deallocate(wfr1)
 if (niter>0.and.Ep%inclvkb/=0) then
   deallocate(mtwk)
 endif

 if (niter>0.and.Ep%inclvkb/=0) then
   deallocate(fnlkr)
 endif
 deallocate(qpgsq,qplg,kplqg)

end subroutine gw_EET_chi0q0

subroutine gw_EET_chi0q02(Ep,Dtset,Cryst,rhotwg,rhotwx,itim_k,isym_k,green_w,chi0_head,chi0_lwing,chi0_uwing)

 use defs_basis
 use m_gwdefs
 use defs_datatypes
 use defs_abitypes
 use m_jolly_pointers
 use m_crystal
 use m_bz_mesh
 use m_gsphere
 use m_wfs
 use m_commutator_vkbr
 use m_errors

 use m_geometry,      only : normv
 use m_coulombian,    only : coulombian_type

 implicit none

!Arguments ------------------------------------
!scalars
 type(Crystal_structure),intent(in) :: Cryst
 type(Epsilonm1_parameters),intent(in) :: Ep
 type(Dataset_type),intent(in) :: Dtset

 integer,intent(in) :: itim_k,isym_k
 complex(gwpc),intent(inout) :: rhotwg(Ep%npwe*Dtset%nspinor**2)
 complex(gwpc),intent(in) :: rhotwx(3,Dtset%nspinor**2)
 complex(dpc),intent(in) :: green_w(Ep%nomega)
 complex(dpc),intent(inout) :: chi0_head(3,3,Ep%nomega)
 complex(dpc),intent(inout) :: chi0_lwing(Ep%npwe*Ep%nI,Ep%nomega,3)
 complex(dpc),intent(inout) :: chi0_uwing(Ep%npwe*Ep%nJ,Ep%nomega,3)
 complex(dpc) :: mir_kbz(3)

 integer :: io,idir,jdir

!************************************************************************

 ! Symmetrize <r> in full BZ: <Sk b|r|Sk b'> = R <k b|r|k b'> + \tau \delta_{bb'}
 mir_kbz =(3-2*itim_k) * MATMUL(Cryst%symrec(:,:,isym_k),rhotwx(:,1))
 if (itim_k==2) mir_kbz=CONJG(mir_kbz)

 ! here we might take advantage of Hermiticity along Im axis in RPA (see
 ! mkG0w)
 do idir=1,3
   do io=1,Ep%nomega
     chi0_uwing(:,io,idir) = chi0_uwing(:,io,idir) + green_w(io) * mir_kbz(idir)*CONJG(rhotwg)
     chi0_lwing(:,io,idir) = chi0_lwing(:,io,idir) + green_w(io) * rhotwg*CONJG(mir_kbz(idir))
   end do
 end do
 !
 ! Accumulate the head.
 do io=1,Ep%nomega
   do jdir=1,3
     do idir=1,3
       chi0_head(idir,jdir,io) = chi0_head(idir,jdir,io) + green_w(io) * mir_kbz(idir)*CONJG(mir_kbz(jdir))
     end do
   end do
 end do

end subroutine gw_EET_chi0q02

subroutine drho_tw_g(paral_kgb,nspinor,npwvec,nr,ngfft,map2sphere,use_padfft,igfftg0,gbound,&
&                    wfn1,i1,ktabr1,ktabp1,wfn2,dim_rtwg,rhotwg,tim_fourdp,MPI_enreg)

 use defs_basis
 use defs_abitypes
 use m_errors
 use m_gwdefs,    only : czero_gw

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_53_ffts
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: paral_kgb,i1,npwvec,nr,tim_fourdp,nspinor,dim_rtwg,map2sphere,use_padfft
 complex(dpc),intent(in) :: ktabp1
 type(MPI_type),intent(inout) :: MPI_enreg
!arrays
 !integer,intent(in) :: gbound(2*mgfft+8,2)
 integer,intent(in) :: gbound(:,:)
 integer,intent(in) :: igfftg0(npwvec*map2sphere),ngfft(18)
 integer,intent(in) :: ktabr1(nr)
 complex(gwpc),intent(in) :: wfn1(nr*nspinor),wfn2(nr*nspinor)
 complex(gwpc),intent(out) :: rhotwg(npwvec*dim_rtwg)

!Local variables-------------------------------
!scalars
 integer :: ig,igfft
 integer :: nx,ny,nz,ldx,ldy,ldz,mgfft
!arrays
 complex(dpc),allocatable :: usk(:),uu(:)

! *************************************************************************

 SELECT CASE (nspinor)

 CASE (1) ! Collinear case.
  !
  ! Form rho-twiddle(r)=u_1^*(r,b1,kbz1) u_2(r,b2,kbz2), to account for
  ! symmetries:
  ! u(r,b,kbz)=e^{-2i\pi kibz.(R^{-1}t} u (R{^-1}(r-t),b,kibz)
  !           =e^{+2i\pi kibz.(R^{-1}t} u*({R^-1}(r-t),b,kibz) for time-reversal
  !
  allocate(uu(nr),usk(nr))

  uu  = wfn1(ktabr1)*ktabp1; if (i1==1) uu  = CONJG(uu)
!  usk = wfn2(ktabr2)*ktabp2; if (i2==2) usk = CONJG(usk)
  usk = wfn2
  uu  = uu * usk

  SELECT CASE (map2sphere)

  CASE (0) ! Need results on the full FFT box thus cannot use zero-padded FFT.

    call fourdp_c2c_ip(uu,-1,MPI_enreg,nr,ngfft,paral_kgb,tim_fourdp)
    rhotwg=uu
    !call fourdp_c2c_op(uu,rhotwg,-1,MPI_enreg,nr,ngfft,paral_kgb,tim_fourdp)

  CASE (1) ! Need results on the G-sphere. Call zero-padded FFT routines if required.

    if (use_padfft==1) then
      nx =ngfft(1); ny =ngfft(2); nz =ngfft(3); mgfft = MAXVAL(ngfft(1:3))
      ldx=nx      ; ldy=ny      ; ldz=nz
      call padded_fourwf_cplx(uu,ngfft,nx,ny,nz,ldx,ldy,ldz,mgfft,-1,gbound)
    else
      call fourdp_c2c_ip(uu,-1,MPI_enreg,nr,ngfft,paral_kgb,tim_fourdp)
    end if

    do ig=1,npwvec       ! Have to map FFT to G-sphere.
      igfft=igfftg0(ig)
      if (igfft/=0) then ! G-G0 belong to the FFT mesh.
        rhotwg(ig)=uu(igfft)
      else               ! Set this component to zero.
        rhotwg(ig)=czero_gw
      end if
    end do

  CASE DEFAULT
    MSG_BUG("Wrong map2sphere")
  END SELECT

  deallocate(uu,usk)

  RETURN

 CASE DEFAULT
   MSG_BUG('Wrong nspinor')
 END SELECT

end subroutine drho_tw_g

subroutine calc_dwfwfg(MPI_enreg,paral_kgb,tim_fourdp,ktabr_k,ktabi_k,nfftot,ngfft_gw,wfr_jb,wfr_kb,wfg2_jk)

 use defs_basis
 use defs_abitypes
 use m_errors

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_53_ffts
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: ktabi_k,nfftot,paral_kgb,tim_fourdp
 type(MPI_type),intent(inout) :: MPI_enreg
!arrays
 integer,intent(in) :: ktabr_k(nfftot),ngfft_gw(18)
 complex(gwpc),intent(in) :: wfr_jb(nfftot),wfr_kb(nfftot)
 complex(gwpc),intent(out) :: wfg2_jk(nfftot)

!Local variables-------------------------------
!arrays
 complex(dpc),allocatable :: wfr2_dpcplx(:)
#if ! defined HAVE_GW_DPC
 complex(dpc),allocatable :: wfg2_dpcplx(:)
#endif

! *************************************************************************

 ! There is no need to take into account phases arising from non-symmorphic
 ! operations since the wavefunctions are evaluated at the same k-point.
 allocate(wfr2_dpcplx(nfftot))

 SELECT CASE (ktabi_k)

 CASE (1)
!   wfr2_dpcplx = CONJG(wfr_jb(ktabr_k)) * wfr_kb(ktabr_k)
   wfr2_dpcplx = CONJG(wfr_jb(ktabr_k)) * wfr_kb

 CASE (2) ! Conjugate the product if time-reversal is used to reconstruct this k-point
!   wfr2_dpcplx = wfr_jb(ktabr_k) * CONJG(wfr_kb(ktabr_k))
   wfr2_dpcplx = wfr_jb(ktabr_k) * wfr_kb

 CASE DEFAULT
   MSG_ERROR("Wrong ktabi_k")
 END SELECT

 ! Transform to Fourier space (result in wfg2_jk)
#if defined HAVE_GW_DPC
 call fourdp_c2c_op(wfr2_dpcplx,wfg2_jk,-1,MPI_enreg,nfftot,ngfft_gw,paral_kgb,tim_fourdp)
#else
 allocate(wfg2_dpcplx(nfftot))
 call fourdp_c2c_op(wfr2_dpcplx,wfg2_dpcplx,-1,MPI_enreg,nfftot,ngfft_gw,paral_kgb,tim_fourdp)
 wfg2_jk=wfg2_dpcplx
 deallocate(wfg2_dpcplx)
#endif

 deallocate(wfr2_dpcplx)

end subroutine calc_dwfwfg

subroutine calc_ddwfwfg(MPI_enreg,paral_kgb,tim_fourdp,ktabi_k,nfftot,ngfft_gw,wfr_jb,wfr_kb,wfg2_jk)

 use defs_basis
 use defs_abitypes
 use m_errors

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_53_ffts
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: ktabi_k,nfftot,paral_kgb,tim_fourdp
 type(MPI_type),intent(inout) :: MPI_enreg
!arrays
 integer,intent(in) :: ngfft_gw(18)
 complex(gwpc),intent(in) :: wfr_jb(nfftot),wfr_kb(nfftot)
 complex(gwpc),intent(out) :: wfg2_jk(nfftot)

!Local variables-------------------------------
!arrays
 complex(dpc),allocatable :: wfr2_dpcplx(:)
#if ! defined HAVE_GW_DPC
 complex(dpc),allocatable :: wfg2_dpcplx(:)
#endif

! *************************************************************************

 ! There is no need to take into account phases arising from non-symmorphic
 ! operations since the wavefunctions are evaluated at the same k-point.
 allocate(wfr2_dpcplx(nfftot))

 SELECT CASE (ktabi_k)

 CASE (1)
!   wfr2_dpcplx = CONJG(wfr_jb(ktabr_k)) * wfr_kb(ktabr_k)
   wfr2_dpcplx = CONJG(wfr_jb) * wfr_kb

 CASE (2) ! Conjugate the product if time-reversal is used to reconstruct this k-point
!   wfr2_dpcplx = wfr_jb(ktabr_k) * CONJG(wfr_kb(ktabr_k))
   wfr2_dpcplx = CONJG(wfr_jb) * wfr_kb

 CASE DEFAULT
   MSG_ERROR("Wrong ktabi_k")
 END SELECT

 ! Transform to Fourier space (result in wfg2_jk)
#if defined HAVE_GW_DPC
 call fourdp_c2c_op(wfr2_dpcplx,wfg2_jk,-1,MPI_enreg,nfftot,ngfft_gw,paral_kgb,tim_fourdp)
#else
 allocate(wfg2_dpcplx(nfftot))
 call fourdp_c2c_op(wfr2_dpcplx,wfg2_dpcplx,-1,MPI_enreg,nfftot,ngfft_gw,paral_kgb,tim_fourdp)
 wfg2_jk=wfg2_dpcplx
 deallocate(wfg2_dpcplx)
#endif

 deallocate(wfr2_dpcplx)

end subroutine calc_ddwfwfg

subroutine fft4EET(ik_bz,Ep,Cryst,Wfs,Kmesh,Gsph_epsG0,Ltg_q,nbhomo,nbmax, &
&                  is,nfftot_gw,ngfft_gw,use_padfft,igfftepsG0, &
&                  gw_gbound,gw_mgfft,ik_ibz,ikmq_ibz,isym_k,itim_k,tabr_k,ph_mkt,spinrot_k, &
&                  itim_kmq,tabr_kmq,ph_mkmqt,spinrot_kmq,dim_rtwg,grottbm1, &
&                  nspinor,tim_fourdp,wfr1,wfr2,ibv,qplg,kplqg, &
&                  niter,ptwsq,spin_fact,qp_occ,qp_energy,chi0)

 use defs_basis
 use m_gwdefs
 use defs_datatypes
 use defs_abitypes
 use m_jolly_pointers
 use m_crystal
 use m_bz_mesh
 use m_gsphere
 use m_wfs
 use m_commutator_vkbr
 use m_errors

 use m_geometry,      only : vdotw
 use m_coulombian,    only : coulombian_type
 use m_oscillators,   only : rho_tw_g, calc_wfwfg

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
 use interfaces_68_gw, except_this_one => fft4EET
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 type(Crystal_structure),intent(in) :: Cryst
 type(Epsilonm1_parameters),intent(in) :: Ep
 type(wfs_descriptor),intent(inout) :: Wfs
 type(BZ_mesh_type),intent(in) :: Kmesh
 type(Gvectors_type),intent(in) :: Gsph_epsG0
 type(Little_group),intent(in) :: Ltg_q

 integer,intent(in) :: ik_bz,nbhomo(2),nbmax,is,ibv,niter
 integer,intent(in) :: nfftot_gw,ngfft_gw(18),nspinor,tim_fourdp,use_padfft,gw_mgfft
 integer,intent(in) :: ik_ibz,ikmq_ibz
 integer,intent(in) :: isym_k,itim_k,itim_kmq
 integer,intent(in) :: tabr_k(nfftot_gw),tabr_kmq(nfftot_gw)
 integer,intent(in) :: dim_rtwg
 integer,intent(in) :: igfftepsG0(Ep%npwepG0)
 integer,intent(in) :: gw_gbound(2*gw_mgfft+8,2*use_padfft)
 integer,intent(in) :: grottbm1(Ep%npwvec,2,Cryst%nsym)
 real(dp),intent(in) :: spinrot_k(4),spinrot_kmq(4)
 real(dp),intent(in) :: qplg(Ep%npwe,3),kplqg(Ep%npwe)
 real(dp),intent(in) :: spin_fact
 real(dp),intent(in) :: qp_occ(Ep%nbnds,Kmesh%nibz,Ep%nsppol)
 real(dp),intent(in) :: qp_energy(Ep%nbnds,Kmesh%nibz,Ep%nsppol)
 complex(dpc),intent(in) :: ph_mkmqt,ph_mkt
 complex(gwpc),intent(in) :: wfr1(Wfs%nfftot*nspinor,nbmax)
 complex(gwpc),intent(in) :: wfr2(Wfs%nfftot*nspinor,nbhomo(1))
 complex(gwpc),intent(inout) :: chi0(Ep%npwe,Ep%npwe,Ep%nomega)

 complex(gwpc),intent(out) :: ptwsq(Ep%npwe,Ep%npwe,niter+1)

 complex(gwpc),allocatable :: rhotwg(:,:)
 complex(gwpc),allocatable :: drhotwg(:,:,:)
 complex(gwpc),allocatable :: wfwfg(:)
 complex(gwpc),allocatable :: dwfwfg(:,:)
 complex(gwpc),allocatable :: ddwfwfg(:,:,:)

 complex(gwpc),allocatable :: dwfr(:,:)
 complex(gwpc),allocatable :: gwfg(:)
 complex(gwpc),allocatable :: cauxg(:,:)

 integer :: ibvp,ig,igp,igbz
 integer :: i,j
 integer :: ig4,ig4x,ig4y,ig4z
 integer :: gmgp(3)
 integer :: outofbox
 integer,save :: enough=0
 character(len=500) :: msg

 complex(dpc) :: drhaux(3)
 complex(dpc) :: paux(3)

!************************************************************************

 allocate(rhotwg(Ep%npwepG0*nspinor**2,nbmax))
 allocate(wfwfg(nfftot_gw*nspinor**2))
 if (niter>0) then
   allocate(drhotwg(Ep%npwepG0*nspinor**2,nbmax,3))
   allocate(dwfwfg(nfftot_gw*nspinor**2,3))
   allocate(gwfg(Ep%npwwfn))
   allocate(dwfr(Wfs%nfftot*nspinor,3))
 endif
 if (niter>1) allocate(ddwfwfg(nfftot_gw*nspinor**2,3,3))

 call calc_wfwfg(Wfs%MPI_enreg,Wfs%paral_kgb,tim_fourdp,tabr_k,itim_k,nfftot_gw,ngfft_gw, &
&                wfr2(:,ibv),wfr2(:,ibv),wfwfg(:))

 do ibvp = 1, nbmax
   call rho_tw_g(Wfs%paral_kgb,nspinor,Ep%npwepG0,nfftot_gw,ngfft_gw,1,use_padfft,igfftepsG0,gw_gbound, &
&                wfr1(:,ibvp),itim_kmq,tabr_kmq,ph_mkmqt,spinrot_kmq,wfr2(:,ibv),itim_k,tabr_k,ph_mkt, &
&                spinrot_k,dim_rtwg,rhotwg(:,ibvp),tim_fourdp,Wfs%MPI_enreg)

   if (ibvp>nbhomo(2)) then
     call calc_corr_chi0(ik_bz,Ep,Kmesh,Gsph_epsG0,Ltg_q,rhotwg(:,ibvp),spin_fact,qp_occ,qp_energy, &
&                        ibv,ibvp,ik_ibz,ikmq_ibz,is,chi0)
   endif

 enddo

 if (niter>0) then

   do i = 1, 3
     do ig = 1, Ep%npwwfn
       igbz = grottbm1(ig,itim_k,isym_k)
       if (itim_k==1) then
         gwfg(ig)=-Wfs%gvec(i,ig)*Wfs%Wave(ibv,ik_ibz,is)%ug(igbz)
       else
         gwfg(ig)=-Wfs%gvec(i,ig)*conjg(Wfs%Wave(ibv,ik_ibz,is)%ug(igbz))
       endif
     enddo
     call fft_onewfn(Wfs%paral_kgb,Wfs%istwfk(ik_ibz),nspinor,Ep%npwwfn,Wfs%nfftot, &
&                    gwfg,dwfr(:,i),Wfs%igfft0,Wfs%ngfft,Wfs%gvec,Wfs%gbound,tim_fourdp,Wfs%MPI_enreg)
   enddo

   do ibvp = 1, nbmax
     do i = 1, 3
       call drho_tw_g(Wfs%paral_kgb,nspinor,Ep%npwepG0,nfftot_gw,ngfft_gw,1,use_padfft,igfftepsG0,gw_gbound,&
&                     wfr1(:,ibvp),itim_kmq,tabr_kmq,ph_mkmqt,dwfr(:,i), &
&                     dim_rtwg,drhotwg(:,ibvp,i),tim_fourdp,Wfs%MPI_enreg)
     enddo
   enddo

   do i = 1, 3
     call calc_dwfwfg(Wfs%MPI_enreg,Wfs%paral_kgb,tim_fourdp,tabr_k,itim_k,nfftot_gw,ngfft_gw, &
&                     wfr2(:,ibv),dwfr(:,i),dwfwfg(:,i))
     if (niter>1) then
       do j = 1, 3
         call calc_ddwfwfg(Wfs%MPI_enreg,Wfs%paral_kgb,tim_fourdp,itim_k,nfftot_gw,ngfft_gw, &
&                          dwfr(:,i),dwfr(:,j),ddwfwfg(:,i,j))
       enddo
     endif
   enddo

   deallocate(gwfg,dwfr)
   allocate(cauxg(Ep%npwe,nbmax))

   do ig=1,Ep%npwe
     do ibvp = 1, nbmax
       drhaux(:)=cmplx(real(drhotwg(ig,ibvp,:)),aimag(drhotwg(ig,ibvp,:)))
       cauxg(ig,ibvp)=vdotw(qplg(ig,:),drhaux,Cryst%gmet,"G")
     enddo
   enddo

 endif

 ptwsq(:,:,:)=czero_gw
 outofbox=0
 do ig=1,Ep%npwe
   do igp=1,Ep%npwe
     gmgp(:)=Wfs%gvec(:,ig)-Wfs%gvec(:,igp)
     if (ANY(gmgp(:)>ngfft_gw(1:3)/2) .or. ANY(gmgp(:)<-(ngfft_gw(1:3)-1)/2)) then
       outofbox = outofbox+1; CYCLE
     end if
     ig4x= modulo(gmgp(1),ngfft_gw(1))
     ig4y= modulo(gmgp(2),ngfft_gw(2))
     ig4z= modulo(gmgp(3),ngfft_gw(3))
     ig4= 1+ig4x+ig4y*ngfft_gw(1)+ig4z*ngfft_gw(1)*ngfft_gw(2)
     if (ig>=igp) then
       ptwsq(ig,igp,1)=wfwfg(ig4)
     endif
     if (niter>0) then
       drhaux(:)=cmplx(real(dwfwfg(ig4,:)),aimag(dwfwfg(ig4,:)))
       ptwsq(ig,igp,2)=ptwsq(ig,igp,2) + vdotw(qplg(ig,:),drhaux,Cryst%gmet,"G")
       if (niter>1.and.ig>=igp) then
         paux(:)=czero
         do i = 1, 3
           drhaux(:)=cmplx(real(ddwfwfg(ig4,:,i)),aimag(ddwfwfg(ig4,:,i)))
           paux(i)=paux(i) + vdotw(qplg(igp,:),drhaux,Cryst%gmet,"G")
         enddo
         ptwsq(ig,igp,3)=ptwsq(ig,igp,3) + vdotw(qplg(ig,:),paux,Cryst%gmet,"G")
       endif
     endif
   enddo
 enddo

 if (outofbox/=0) then
   enough=enough+1
   if (enough<=10) then
     write(msg,'(a,i5)')' Number of G1-G2 pairs outside the G-sphere for Wfns = ',outofbox
     MSG_WARNING(msg)
     if (enough==10) then
       write(msg,'(a)')' ========== Stop writing Warnings =========='
       call wrtout(std_out,msg,'COLL')
     end if
   end if
 end if

 do ig=1,Ep%npwe
   do igp=1,ig
     do ibvp = 1, nbmax
       ptwsq(ig,igp,1)=ptwsq(ig,igp,1)-conjg(rhotwg(igp,ibvp))*rhotwg(ig,ibvp)
     enddo
   end do !igp
 end do !ig

 do ig = 1, Ep%npwe
   do igp = ig+1, Ep%npwe
     ptwsq(ig,igp,1)=conjg(ptwsq(igp,ig,1))
   enddo
 enddo

 if (niter>0) then
   do ig=1,Ep%npwe
     do igp=1,Ep%npwe
       do ibvp = 1, nbmax
         ptwsq(ig,igp,2)=ptwsq(ig,igp,2)-conjg(rhotwg(igp,ibvp))*cauxg(ig,ibvp)
       enddo
       ptwsq(ig,igp,2)=ptwsq(ig,igp,2)+ptwsq(ig,igp,1)*kplqg(ig)
     end do !igp
   end do !ig
 end if

 if (niter>1) then

   do ig=1,Ep%npwe
     do igp=1,ig
       do ibvp = 1, nbmax
         ptwsq(ig,igp,3)=ptwsq(ig,igp,3)-conjg(cauxg(igp,ibvp))*cauxg(ig,ibvp)
       enddo
       ptwsq(ig,igp,3)=ptwsq(ig,igp,3)+kplqg(igp)*ptwsq(ig,igp,2)+ kplqg(ig)*conjg(ptwsq(igp,ig,2)) - &
&                                      kplqg(igp)*ptwsq(ig,igp,1)*kplqg(ig)
     end do !igp
   end do !ig

   do ig = 1, Ep%npwe
     do igp = ig+1, Ep%npwe
       ptwsq(ig,igp,3)=conjg(ptwsq(igp,ig,3))
     enddo
   enddo

 endif

 deallocate(rhotwg,wfwfg)
 if (niter>0) then
   deallocate(cauxg,drhotwg,dwfwfg)
 endif
 if (niter>1) deallocate(ddwfwfg)

end subroutine fft4EET

subroutine fft4EET_kb(ik_bz,Ep,Cryst,Wfs,Kmesh,Gsph_epsG0,Ltg_q,Psps,nbhomo,nbmax, &
&                     is,nfftot_gw,ngfft_gw,use_padfft,igfftepsG0, &
&                     gw_gbound,gw_mgfft,ik_ibz,ikmq_ibz,isym_k,itim_k,tabr_k,ph_mkt,spinrot_k, &
&                     itim_kmq,tabr_kmq,ph_mkmqt,spinrot_kmq,dim_rtwg,grottbm1, &
&                     nspinor,tim_fourdp,fnlloc,fnlmax,fnlkpr,mtwk,mtwkp,wfr1,wfr2,ibv,qplg,kplqg, &
&                     niter,ptwsq,spin_fact,qp_occ,qp_energy,chi0)

 use defs_basis
 use m_gwdefs
 use defs_datatypes
 use defs_abitypes
 use m_jolly_pointers
 use m_crystal
 use m_bz_mesh
 use m_gsphere
 use m_wfs
 use m_commutator_vkbr
 use m_errors

 use m_geometry,      only : vdotw
 use m_coulombian,    only : coulombian_type
 use m_oscillators,   only : rho_tw_g, calc_wfwfg

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
 use interfaces_68_gw, except_this_one => fft4EET_kb
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 type(Crystal_structure),intent(in) :: Cryst
 type(BZ_mesh_type),intent(in) :: Kmesh
 type(Pseudopotential_type),intent(in) :: Psps
 type(Epsilonm1_parameters),intent(in) :: Ep
 type(wfs_descriptor),intent(inout) :: Wfs
 type(Gvectors_type),intent(in) :: Gsph_epsG0
 type(kb_potential) :: KBff_k_ibz
 type(Little_group),intent(in) :: Ltg_q

 integer,intent(in) :: ik_bz,nbhomo(2),nbmax,is,ibv,niter
 integer,intent(in) :: nfftot_gw,ngfft_gw(18),nspinor,tim_fourdp,use_padfft,gw_mgfft
 integer,intent(in) :: ik_ibz,ikmq_ibz
 integer,intent(in) :: isym_k,itim_k,itim_kmq
 integer,intent(in) :: tabr_k(nfftot_gw),tabr_kmq(nfftot_gw)
 integer,intent(in) :: dim_rtwg
 integer,intent(in) :: igfftepsG0(Ep%npwepG0)
 integer,intent(in) :: gw_gbound(2*gw_mgfft+8,2*use_padfft)
 integer,intent(in) :: grottbm1(Ep%npwvec,2,Cryst%nsym)
 integer,intent(in) :: fnlloc(Cryst%ntypat,2)
 integer,intent(in) :: fnlmax(Cryst%ntypat)
 real(dp),intent(in) :: spinrot_k(4),spinrot_kmq(4)
 real(dp),intent(in) :: spin_fact
 real(dp),intent(in) :: qplg(Ep%npwe,3),kplqg(Ep%npwe)
 real(dp),intent(in) :: qp_occ(Ep%nbnds,Kmesh%nibz,Ep%nsppol)
 real(dp),intent(in) :: qp_energy(Ep%nbnds,Kmesh%nibz,Ep%nsppol)
 complex(dpc),intent(in) :: ph_mkmqt,ph_mkt

 complex(gwpc),intent(in) :: fnlkpr(Wfs%nfftot*nspinor,Psps%mpsang*Psps%mpsang,Cryst%natom)
 complex(gwpc),intent(in) :: mtwk(Wfs%nfftot*nspinor,nbhomo(1))
 complex(gwpc),intent(in) :: mtwkp(Wfs%nfftot*nspinor,nbmax)

 complex(gwpc),intent(in) :: wfr1(Wfs%nfftot*nspinor,nbmax)
 complex(gwpc),intent(in) :: wfr2(Wfs%nfftot*nspinor,nbhomo(1))

 complex(gwpc),intent(out) :: ptwsq(Ep%npwe,Ep%npwe,niter+1)
 complex(gwpc),intent(inout) :: chi0(Ep%npwe,Ep%npwe,Ep%nomega)

 complex(gwpc),allocatable :: rhotwg(:,:)
 complex(gwpc),allocatable :: drhotwg(:,:,:)
 complex(gwpc),allocatable :: fnltwg(:,:,:)
 complex(gwpc),allocatable :: fnltwg2(:,:)
 complex(gwpc),allocatable :: fnltwg3(:,:)
 complex(gwpc),allocatable :: kns(:,:,:)
 complex(gwpc),allocatable :: wfwfg(:)
 complex(gwpc),allocatable :: dwfwfg(:,:)
 complex(gwpc),allocatable :: ddwfwfg(:,:,:)
 complex(gwpc),allocatable :: fnlwfg(:)
 complex(gwpc),allocatable :: fkdwfg(:,:)
 complex(gwpc),allocatable :: fdrhotwg(:,:,:,:)
 complex(gwpc),allocatable :: lnkp(:)

 complex(gwpc),allocatable :: dwfr(:,:)
 complex(gwpc),allocatable :: gwfg(:)
 complex(gwpc),allocatable :: cauxg(:,:)
 complex(gwpc),allocatable :: ff(:,:,:,:)
 complex(gwpc),allocatable :: vzn(:,:,:)

 complex(gwpc),allocatable :: paux(:,:)

 integer :: ilm,iat,ilm2,iat2,ibvp,ig,igp,igbz
 integer :: i,j
 integer :: ig4,ig4x,ig4y,ig4z
 integer :: ig5,ig5x,ig5y,ig5z
 integer :: nlx
 integer :: gmgp(3),ngfft(3)
 integer :: outofbox
 integer,save :: enough=0
 character(len=500) :: msg

 complex(dpc) :: drhaux(3)
 complex(dpc) :: paux2(3)

!************************************************************************

 nlx = min(Psps%mpsang,4)

 allocate(rhotwg(Ep%npwepG0*nspinor**2,nbmax))
 allocate(wfwfg(nfftot_gw*nspinor**2))

 if (niter>0) then
   allocate(drhotwg(Ep%npwepG0*nspinor**2,nbmax,3))
   allocate(dwfwfg(nfftot_gw*nspinor**2,3))
   allocate(gwfg(Ep%npwwfn))
   allocate(dwfr(Wfs%nfftot*nspinor,3))
   allocate(fnltwg(Ep%npwepG0*nspinor**2,Psps%mpsang*Psps%mpsang,Cryst%natom))
   allocate(fnlwfg(nfftot_gw*nspinor**2))
   allocate(fnltwg2(Ep%npwepG0*nspinor**2,nbmax))
   allocate(fnltwg3(Ep%npwepG0*nspinor**2,nbmax))
 endif

 if (niter>1) then
   allocate(ddwfwfg(nfftot_gw*nspinor**2,3,3))
   allocate(lnkp(nfftot_gw*nspinor**2))
   allocate(kns(Ep%npwepG0*nspinor**2,Psps%mpsang*Psps%mpsang,Cryst%natom))
   allocate(fdrhotwg(Ep%npwepG0*nspinor**2,Psps%mpsang*Psps%mpsang,Cryst%natom,3))
   allocate(fkdwfg(nfftot_gw*nspinor**2,3))
   allocate(ff(nlx*nlx,Cryst%natom,nlx*nlx,Cryst%natom))
   allocate(vzn(Ep%npwepG0*nspinor**2,nlx*nlx,Cryst%natom))
 endif

 call calc_wfwfg(Wfs%MPI_enreg,Wfs%paral_kgb,tim_fourdp,tabr_k,itim_k,nfftot_gw,ngfft_gw, &
&                wfr2(:,ibv),wfr2(:,ibv),wfwfg(:))

 do ibvp = 1, nbmax
   call rho_tw_g(Wfs%paral_kgb,nspinor,Ep%npwepG0,nfftot_gw,ngfft_gw,1,use_padfft,igfftepsG0,gw_gbound, &
&                wfr1(:,ibvp),itim_kmq,tabr_kmq,ph_mkmqt,spinrot_kmq,wfr2(:,ibv),itim_k,tabr_k,ph_mkt, &
&                spinrot_k,dim_rtwg,rhotwg(:,ibvp),tim_fourdp,Wfs%MPI_enreg)

   if (ibvp>nbhomo(2)) then
     call calc_corr_chi0(ik_bz,Ep,Kmesh,Gsph_epsG0,Ltg_q,rhotwg(:,ibvp),spin_fact,qp_occ,qp_energy, &
&                        ibv,ibvp,ik_ibz,ikmq_ibz,is,chi0)
   endif
 enddo

 if (niter>0) then

   do i = 1, 3
     do ig = 1, Ep%npwwfn
       igbz = grottbm1(ig,itim_k,isym_k)
       if (itim_k==1) then
         gwfg(ig)=-Wfs%gvec(i,ig)*Wfs%Wave(ibv,ik_ibz,is)%ug(igbz)
       else
         gwfg(ig)=-Wfs%gvec(i,ig)*conjg(Wfs%Wave(ibv,ik_ibz,is)%ug(igbz))
       endif
     enddo
     call fft_onewfn(Wfs%paral_kgb,Wfs%istwfk(ik_ibz),nspinor,Ep%npwwfn,Wfs%nfftot, &
&                      gwfg,dwfr(:,i),Wfs%igfft0,Wfs%ngfft,Wfs%gvec,Wfs%gbound,tim_fourdp,Wfs%MPI_enreg)
   enddo

   do ibvp = 1, nbmax
     do i = 1, 3
       call drho_tw_g(Wfs%paral_kgb,nspinor,Ep%npwepG0,nfftot_gw,ngfft_gw,1,use_padfft,igfftepsG0,gw_gbound,&
&                     wfr1(:,ibvp),itim_kmq,tabr_kmq,ph_mkmqt,dwfr(:,i), &
&                     dim_rtwg,drhotwg(:,ibvp,i),tim_fourdp,Wfs%MPI_enreg)
     enddo
   enddo

   do i = 1, 3
     call calc_dwfwfg(Wfs%MPI_enreg,Wfs%paral_kgb,tim_fourdp,tabr_k,itim_k,nfftot_gw,ngfft_gw, &
&                     wfr2(:,ibv),dwfr(:,i),dwfwfg(:,i))
     if (niter>1) then
       do j = 1, 3
         call calc_ddwfwfg(Wfs%MPI_enreg,Wfs%paral_kgb,tim_fourdp,itim_k,nfftot_gw,ngfft_gw, &
&                          dwfr(:,i),dwfr(:,j),ddwfwfg(:,i,j))
       enddo
     endif
   enddo

   do iat = 1, Cryst%natom
     do ilm = 1, Psps%mpsang*Psps%mpsang
       if (ilm>fnlmax(Cryst%typat(iat))) CYCLE
       if (ilm>=fnlloc(Cryst%typat(iat),1).and.ilm<=fnlloc(Cryst%typat(iat),2)) CYCLE
       call rho_tw_g(Wfs%paral_kgb,nspinor,Ep%npwepG0,nfftot_gw,ngfft_gw,1,use_padfft,igfftepsG0,gw_gbound, &
&                    fnlkpr(:,ilm,iat),itim_kmq,tabr_kmq,ph_mkmqt,spinrot_kmq,wfr2(:,ibv),itim_k,tabr_k,ph_mkt, &
&                    spinrot_k,dim_rtwg,fnltwg(:,ilm,iat),tim_fourdp,Wfs%MPI_enreg)
     enddo
   enddo

   call calc_wfwfg(Wfs%MPI_enreg,Wfs%paral_kgb,tim_fourdp,tabr_k,itim_k,nfftot_gw,ngfft_gw, &
&                  wfr2(:,ibv),mtwk(:,ibv),fnlwfg)

   do ibvp = 1, nbmax
     call rho_tw_g(Wfs%paral_kgb,nspinor,Ep%npwepG0,nfftot_gw,ngfft_gw,1,use_padfft,igfftepsG0,gw_gbound, &
&                  wfr1(:,ibvp),itim_kmq,tabr_kmq,ph_mkmqt,spinrot_kmq,mtwk(:,ibv),itim_k,tabr_k,ph_mkt, &
&                  spinrot_k,dim_rtwg,fnltwg2(:,ibvp),tim_fourdp,Wfs%MPI_enreg)
     call rho_tw_g(Wfs%paral_kgb,nspinor,Ep%npwepG0,nfftot_gw,ngfft_gw,1,use_padfft,igfftepsG0,gw_gbound, &
&                  mtwkp(:,ibvp),itim_kmq,tabr_kmq,ph_mkmqt,spinrot_kmq,wfr2(:,ibv),itim_k,tabr_k,ph_mkt, &
&                  spinrot_k,dim_rtwg,fnltwg3(:,ibvp),tim_fourdp,Wfs%MPI_enreg)
  
   enddo

   if (niter>1) then

     do iat = 1, Cryst%natom
       do ilm = 1, Psps%mpsang*Psps%mpsang
         if (ilm>fnlmax(Cryst%typat(iat))) CYCLE
         if (ilm>=fnlloc(Cryst%typat(iat),1).and.ilm<=fnlloc(Cryst%typat(iat),2)) CYCLE
         do i = 1, 3
           call drho_tw_g(Wfs%paral_kgb,nspinor,Ep%npwepG0,nfftot_gw,ngfft_gw,1,use_padfft,igfftepsG0,gw_gbound,&
&                         fnlkpr(:,ilm,iat),itim_kmq,tabr_kmq,ph_mkmqt, &
&                         dwfr(:,i),dim_rtwg,fdrhotwg(:,ilm,iat,i),tim_fourdp,Wfs%MPI_enreg)
         enddo
         call rho_tw_g(Wfs%paral_kgb,nspinor,Ep%npwepG0,nfftot_gw,ngfft_gw,1,use_padfft,igfftepsG0,gw_gbound,&
&                       fnlkpr(:,ilm,iat),itim_kmq,tabr_kmq,ph_mkmqt,spinrot_kmq,mtwk(:,ibv),itim_k,tabr_k,ph_mkt, &
&                       spinrot_k,dim_rtwg,kns(:,ilm,iat),tim_fourdp,Wfs%MPI_enreg)
       enddo
     enddo

     do i = 1, 3
       call calc_dwfwfg(Wfs%MPI_enreg,Wfs%paral_kgb,tim_fourdp,tabr_k,itim_k,nfftot_gw,ngfft_gw, &
&                       mtwk(:,ibv),dwfr(:,i),fkdwfg(:,i))
     enddo
     call calc_wfwfg(Wfs%MPI_enreg,Wfs%paral_kgb,tim_fourdp,tabr_k,itim_k,nfftot_gw,ngfft_gw, &
&                    mtwk(:,ibv),mtwk(:,ibv),lnkp)

   endif

   deallocate(gwfg,dwfr)
   allocate(cauxg(Ep%npwe,nbmax))

   do ig=1,Ep%npwe
     do ibvp = 1, nbmax
       drhaux(:)=cmplx(real(drhotwg(ig,ibvp,:)),aimag(drhotwg(ig,ibvp,:)))
       cauxg(ig,ibvp)=vdotw(qplg(ig,:),drhaux,Cryst%gmet,"G")
     enddo
     cauxg(ig,:)=cauxg(ig,:)-fnltwg2(ig,:)+fnltwg3(ig,:)
   enddo

 endif

 ptwsq(:,:,:)=(0.0,0.0)
 outofbox=0
 do ig=1,Ep%npwe
   do igp=1,Ep%npwe
     gmgp(:)=Wfs%gvec(:,ig)-Wfs%gvec(:,igp)
     ngfft(1)=ngfft_gw(1)
     ngfft(2)=ngfft_gw(2)
     ngfft(3)=ngfft_gw(3)
     if (ANY(gmgp(:)>ngfft(1:3)/2) .or. ANY(gmgp(:)<-(ngfft(1:3)-1)/2)) then
       outofbox = outofbox+1; CYCLE
     end if
     ig4x= modulo(gmgp(1),ngfft(1))
     ig4y= modulo(gmgp(2),ngfft(2))
     ig4z= modulo(gmgp(3),ngfft(3))
     ig4= 1+ig4x+ig4y*ngfft(1)+ig4z*ngfft(1)*ngfft(2)

     ig5x= modulo(-gmgp(1),ngfft(1))
     ig5y= modulo(-gmgp(2),ngfft(2))
     ig5z= modulo(-gmgp(3),ngfft(3))
     ig5= 1+ig5x+ig5y*ngfft(1)+ig5z*ngfft(1)*ngfft(2)

     if (ig>=igp) then
       ptwsq(ig,igp,1)=wfwfg(ig4)
     endif
     if (niter>0) then
       drhaux(:)=cmplx(real(dwfwfg(ig4,:)),aimag(dwfwfg(ig4,:)))
       ptwsq(ig,igp,2)=ptwsq(ig,igp,2) + vdotw(qplg(ig,:),drhaux,Cryst%gmet,"G")-fnlwfg(ig4)
       if (niter>1.and.ig>=igp) then
         paux2(:)=czero
         do i = 1, 3
           drhaux(:)=cmplx(real(ddwfwfg(ig4,:,i)),aimag(ddwfwfg(ig4,:,i)))
           paux2(i)=paux2(i) + vdotw(qplg(igp,:),drhaux,Cryst%gmet,"G")
         enddo
         drhaux(:)=paux2(:)-cmplx(real(fkdwfg(ig4,:)),aimag(fkdwfg(ig4,:)))
         ptwsq(ig,igp,3)=ptwsq(ig,igp,3) + vdotw(qplg(ig,:),drhaux,Cryst%gmet,"G")
         drhaux(:)=cmplx(real(fkdwfg(ig5,:)),-aimag(fkdwfg(ig5,:)))
         ptwsq(ig,igp,3)=ptwsq(ig,igp,3) - vdotw(qplg(igp,:),drhaux,Cryst%gmet,"G")+lnkp(ig4)
       endif
     endif
   enddo
 enddo

 if (outofbox/=0) then
   enough=enough+1
   if (enough<=10) then
     write(msg,'(a,i5)')' Number of G1-G2 pairs outside the G-sphere for Wfns = ',outofbox
     MSG_WARNING(msg)
     if (enough==10) then
       write(msg,'(a)')' ========== Stop writing Warnings =========='
       call wrtout(std_out,msg,'COLL')
     end if
   end if
 end if

 do ig=1,Ep%npwe
   do igp=1,ig
     do ibvp = 1, nbmax
       ptwsq(ig,igp,1)=ptwsq(ig,igp,1)-conjg(rhotwg(igp,ibvp))*rhotwg(ig,ibvp)
     enddo
   end do !igp
 end do !ig

 do ig = 1, Ep%npwe
   do igp = ig+1, Ep%npwe
     ptwsq(ig,igp,1)=conjg(ptwsq(igp,ig,1))
   enddo
 enddo

 if (niter>0) then
   allocate(paux(Ep%npwe,Ep%npwe))
   paux(:,:)=(0.0,0.0)
   do ig=1,Ep%npwe
     do igp=1,Ep%npwe
       do ibvp = 1, nbmax
         ptwsq(ig,igp,2)=ptwsq(ig,igp,2)-conjg(rhotwg(igp,ibvp))*cauxg(ig,ibvp)
       enddo
       if (ig>=igp) then
         do iat = 1, Cryst%natom
           do ilm = 1, nlx*nlx
             if (ilm>fnlmax(Cryst%typat(iat))) CYCLE
             if (ilm>=fnlloc(Cryst%typat(iat),1).and.ilm<=fnlloc(Cryst%typat(iat),2)) CYCLE
             paux(ig,igp)=paux(ig,igp)+conjg(fnltwg(igp,ilm,iat))*fnltwg(ig,ilm,iat)
           enddo
         enddo
       endif
       ptwsq(ig,igp,2)=ptwsq(ig,igp,2)+ptwsq(ig,igp,1)*kplqg(ig)
     end do !igp
   end do !ig
   do ig=1,Ep%npwe
     do igp=1,Ep%npwe
       if (ig>=igp) then
         ptwsq(ig,igp,2)=ptwsq(ig,igp,2)+paux(ig,igp)
       else
         ptwsq(ig,igp,2)=ptwsq(ig,igp,2)+conjg(paux(igp,ig))
       endif
     end do !igp
   end do !ig
   deallocate(paux)
 end if

 if (niter>1) then

  !MG KB form factors: to be done outside. array dimensioned with Kmesh%nibz
   call nullify_kb_potential(KBff_k_ibz  )

   call init_kb_potential(KBff_k_ibz ,Cryst,Psps,2,Ep%npwwfn,Kmesh%ibz(:,ik_ibz),Wfs%gvec)
   deallocate(KBff_k_ibz%fnld  )

   ff(:,:,:,:)=czero_gw
   do iat = 1, Cryst%natom
     do ilm = 1, nlx*nlx
       if (ilm>fnlmax(Cryst%typat(iat))) CYCLE
       if (ilm>=fnlloc(Cryst%typat(iat),1).and.ilm<=fnlloc(Cryst%typat(iat),2)) CYCLE
       do iat2 = 1, Cryst%natom
         do ilm2 = 1, nlx*nlx
           if (ilm2>fnlmax(Cryst%typat(iat2))) CYCLE
           if (ilm2>=fnlloc(Cryst%typat(iat2),1).and.ilm2<=fnlloc(Cryst%typat(iat2),2)) CYCLE
           do ig = 1, Ep%npwwfn
             igbz = grottbm1(ig,itim_k,isym_k)
             if (itim_k==1) then
               ff(ilm,iat,ilm2,iat2)=ff(ilm,iat,ilm2,iat2)+ &
                conjg(KBff_k_ibz%fnl(igbz,ilm,iat))*KBff_k_ibz%fnl(igbz,ilm2,iat2)
             else
               ff(ilm,iat,ilm2,iat2)=ff(ilm,iat,ilm2,iat2)+ &
                KBff_k_ibz%fnl(igbz,ilm,iat)*conjg(KBff_k_ibz%fnl(igbz,ilm2,iat2))
             endif
           enddo
         enddo
       enddo
     enddo
   enddo

   call destroy_kb_potential(KBff_k_ibz)

   vzn(:,:,:)=czero_gw
   do ig=1,Ep%npwe
     do iat = 1, Cryst%natom
       do ilm = 1, nlx*nlx
         if (ilm>fnlmax(Cryst%typat(iat))) CYCLE
         if (ilm>=fnlloc(Cryst%typat(iat),1).and.ilm<=fnlloc(Cryst%typat(iat),2)) CYCLE
         vzn(ig,:,:) = vzn(ig,:,:) + half*ff(ilm,iat,:,:)*fnltwg(ig,ilm,iat)
       enddo
     enddo
     do iat = 1, Cryst%natom
       do ilm = 1, nlx*nlx
         if (ilm>fnlmax(Cryst%typat(iat))) CYCLE
         if (ilm>=fnlloc(Cryst%typat(iat),1).and.ilm<=fnlloc(Cryst%typat(iat),2)) CYCLE
         drhaux(:)=cmplx(real(fdrhotwg(ig,ilm,iat,:)),aimag(fdrhotwg(ig,ilm,iat,:)))
         vzn(ig,ilm,iat)=vzn(ig,ilm,iat)+vdotw(qplg(ig,:),drhaux,Cryst%gmet,"G")-kns(ig,ilm,iat)
       enddo
     enddo
   enddo
   do ig=1,Ep%npwe
     do igp=1,ig
       do ibvp = 1, nbmax
         ptwsq(ig,igp,3)=ptwsq(ig,igp,3)-conjg(cauxg(igp,ibvp))*cauxg(ig,ibvp)
       enddo
       ptwsq(ig,igp,3)=ptwsq(ig,igp,3)+kplqg(igp)*ptwsq(ig,igp,2) + kplqg(ig)*conjg(ptwsq(igp,ig,2))&
&                                     -kplqg(igp)*ptwsq(ig,igp,1)*kplqg(ig)
       do iat = 1, Cryst%natom
         do ilm = 1, nlx*nlx
           if (ilm>fnlmax(Cryst%typat(iat))) CYCLE
           if (ilm>=fnlloc(Cryst%typat(iat),1).and.ilm<=fnlloc(Cryst%typat(iat),2)) CYCLE
           ptwsq(ig,igp,3)=ptwsq(ig,igp,3)+conjg(fnltwg(igp,ilm,iat))*vzn(ig,ilm,iat)+ &
&                                                fnltwg(ig,ilm,iat)*conjg(vzn(igp,ilm,iat))
         enddo
       enddo
     end do !igp
   end do !ig

   do ig = 1, Ep%npwe
     do igp = ig+1, Ep%npwe
       ptwsq(ig,igp,3)=conjg(ptwsq(igp,ig,3))
     enddo
   enddo

 end if

 deallocate(rhotwg,wfwfg)
 if (niter>0) then
   deallocate(cauxg,drhotwg,dwfwfg,fnltwg,fnltwg2,fnltwg3,fnlwfg)
 endif
 if (niter>1) then
   deallocate(ddwfwfg,lnkp,kns,fdrhotwg,fkdwfg,vzn,ff)
 endif

end subroutine fft4EET_kb

subroutine calc_EET_prep(Ep,Cryst,Wfs,Kmesh,Psps,is,nbhomo,nbmax,ik_ibz,ikmq_ibz,nspinor, &
&                        fnlloc,fnlmax,fnlkr,fnlkpr,mtwk,mtwkp)

 use defs_basis
 use m_gwdefs
 use defs_datatypes
 use defs_abitypes
 use m_jolly_pointers
 use m_crystal
 use m_bz_mesh
 use m_gsphere
 use m_wfs
 use m_commutator_vkbr
 use m_errors
 use m_oscillators,   only : rho_tw_g

 use m_geometry,      only : normv
 use m_coulombian,    only : coulombian_type

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 type(Crystal_structure),intent(in) :: Cryst
 type(BZ_mesh_type),intent(in) :: Kmesh
 type(Pseudopotential_type),intent(in) :: Psps
 type(Epsilonm1_parameters),intent(in) :: Ep
 type(wfs_descriptor),intent(in) :: Wfs
 type(kb_potential) :: KBff_k_ibz,KBff_kmq_ibz

 integer,intent(in) :: is,nbhomo,nbmax
 integer,intent(in) :: nspinor
 integer,intent(in) :: ik_ibz,ikmq_ibz
 integer,intent(in) :: fnlloc(Cryst%ntypat,2)
 integer,intent(in) :: fnlmax(Cryst%ntypat)

 complex(gwpc),intent(in) :: fnlkr(Wfs%nfftot*nspinor,Psps%mpsang*Psps%mpsang,Cryst%natom)
 complex(gwpc),intent(in) :: fnlkpr(Wfs%nfftot*nspinor,Psps%mpsang*Psps%mpsang,Cryst%natom)

 complex(gwpc),intent(out) :: mtwk(Wfs%nfftot*nspinor,nbhomo)
 complex(gwpc),intent(out) :: mtwkp(Wfs%nfftot*nspinor,nbmax)

 complex(gwpc),allocatable :: maux(:,:)

 integer :: ibv,ilm,iat,ig

!************************************************************************

 !MG KB form factors: to be done outside. array dimensioned with Kmesh%nibz
 call nullify_kb_potential(KBff_k_ibz  )
 call nullify_kb_potential(KBff_kmq_ibz)

 call init_kb_potential(KBff_k_ibz ,Cryst,Psps,2,Ep%npwwfn,Kmesh%ibz(:,ik_ibz),Wfs%gvec)
 call init_kb_potential(KBff_kmq_ibz,Cryst,Psps,2,Ep%npwwfn,Kmesh%ibz(:,ikmq_ibz),Wfs%gvec)
 deallocate(KBff_k_ibz%fnld  )
 deallocate(KBff_kmq_ibz%fnld)

 allocate(maux(Psps%mpsang*Psps%mpsang,Cryst%natom))

 mtwk(:,:)=(0.0,0.0)
 mtwkp(:,:)=(0.0,0.0)
 do ibv = 1, nbhomo
   maux(:,:)=(0.0,0)
   do ig = 1, Ep%npwwfn
     maux(:,:) = maux(:,:) + Wfs%Wave(ibv,ik_ibz,is)%ug(ig) * KBff_k_ibz%fnl(ig,:,:)
   enddo
   do iat = 1, Cryst%natom
     do ilm = 1, Psps%mpsang*Psps%mpsang
       if (ilm>fnlmax(Cryst%typat(iat))) CYCLE
       if (ilm>=fnlloc(Cryst%typat(iat),1).and.ilm<=fnlloc(Cryst%typat(iat),2)) CYCLE
       mtwk(:,ibv)=mtwk(:,ibv)+maux(ilm,iat)*fnlkr(:,ilm,iat)
     enddo
   enddo
 enddo
 do ibv = 1, nbmax
   maux(:,:)=(0.0,0)
   do ig = 1, Ep%npwwfn
     maux(:,:) = maux(:,:) + Wfs%Wave(ibv,ikmq_ibz,is)%ug(ig)* KBff_kmq_ibz%fnl(ig,:,:)
   enddo
   do iat = 1, Cryst%natom
     do ilm = 1, Psps%mpsang*Psps%mpsang
       if (ilm>fnlmax(Cryst%typat(iat))) CYCLE
       if (ilm>=fnlloc(Cryst%typat(iat),1).and.ilm<=fnlloc(Cryst%typat(iat),2)) CYCLE
       mtwkp(:,ibv)=mtwkp(:,ibv)+maux(ilm,iat)*fnlkpr(:,ilm,iat)
     enddo
   enddo
 enddo

 deallocate(maux)

 call destroy_kb_potential(KBff_k_ibz)
 call destroy_kb_potential(KBff_kmq_ibz)

end subroutine calc_EET_prep

subroutine calc_EET_prep_q0(Ep,Cryst,Wfs,Kmesh,Psps,is,nbmax,ik_ibz,nspinor,fnlloc,fnlmax,fnlkr,mtwk)

 use defs_basis
 use m_gwdefs
 use defs_datatypes
 use defs_abitypes
 use m_jolly_pointers
 use m_crystal
 use m_bz_mesh
 use m_gsphere
 use m_wfs
 use m_commutator_vkbr
 use m_errors
 use m_oscillators,   only : rho_tw_g

 use m_geometry,      only : normv
 use m_coulombian,    only : coulombian_type

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 type(Crystal_structure),intent(in) :: Cryst
 type(BZ_mesh_type),intent(in) :: Kmesh
 type(Pseudopotential_type),intent(in) :: Psps
 type(Epsilonm1_parameters),intent(in) :: Ep
 type(wfs_descriptor),intent(in) :: Wfs
 type(kb_potential) :: KBff_k_ibz

 integer,intent(in) :: is,nbmax
 integer,intent(in) :: nspinor
 integer,intent(in) :: ik_ibz
 integer,intent(in) :: fnlloc(Cryst%ntypat,2)
 integer,intent(in) :: fnlmax(Cryst%ntypat)

 complex(gwpc),intent(in) :: fnlkr(Wfs%nfftot*nspinor,Psps%mpsang*Psps%mpsang,Cryst%natom)
 complex(gwpc),intent(out) :: mtwk(Wfs%nfftot*nspinor,nbmax)

 complex(gwpc),allocatable :: maux(:,:)

 integer :: ibv,ilm,iat,ig

!************************************************************************

 !MG KB form factors: to be done outside. array dimensioned with Kmesh%nibz
 call nullify_kb_potential(KBff_k_ibz  )
 call init_kb_potential(KBff_k_ibz ,Cryst,Psps,2,Ep%npwwfn,Kmesh%ibz(:,ik_ibz),Wfs%gvec)
 deallocate(KBff_k_ibz%fnld  )

 allocate(maux(Psps%mpsang*Psps%mpsang,Cryst%natom))

 mtwk(:,:)=(0.0,0.0)
 do ibv = 1, nbmax
   maux(:,:)=(0.0,0)
   do ig = 1, Ep%npwwfn
     maux(:,:) = maux(:,:) + Wfs%Wave(ibv,ik_ibz,is)%ug(ig) * KBff_k_ibz%fnl(ig,:,:)
   enddo
   do iat = 1, Cryst%natom
     do ilm = 1, Psps%mpsang*Psps%mpsang
       if (ilm>fnlmax(Cryst%typat(iat))) CYCLE
       if (ilm>=fnlloc(Cryst%typat(iat),1).and.ilm<=fnlloc(Cryst%typat(iat),2)) CYCLE
       mtwk(:,ibv)=mtwk(:,ibv)+maux(ilm,iat)*fnlkr(:,ilm,iat)
     enddo
   enddo
 enddo

 deallocate(maux)

 call destroy_kb_potential(KBff_k_ibz)

end subroutine calc_EET_prep_q0

subroutine fft4EET_q0(ik_bz,Ep,Cryst,Wfs,Kmesh,Gsph_epsG0,Ltg_q,nbhomo,nbmax, &
&                     is,nfftot_gw,ngfft_gw,use_padfft,igffteps0, &
&                     gw_gbound,gw_mgfft,ik_ibz,isym_k,itim_k,tabr_k,ph_mkt,spinrot_k, &
&                     dim_rtwg,grottbm1,nspinor,tim_fourdp,wfr1,ibv,qplg,kplqg, &
&                     niter,ptwsq,spin_fact,qp_occ,qp_energy,chi0)

 use defs_basis
 use m_gwdefs
 use defs_datatypes
 use defs_abitypes
 use m_jolly_pointers
 use m_crystal
 use m_bz_mesh
 use m_gsphere
 use m_wfs
 use m_commutator_vkbr
 use m_errors

 use m_geometry,      only : vdotw
 use m_coulombian,    only : coulombian_type
 use m_oscillators,   only : rho_tw_g, calc_wfwfg

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
 use interfaces_68_gw, except_this_one => fft4EET_q0
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 type(Crystal_structure),intent(in) :: Cryst
 type(Epsilonm1_parameters),intent(in) :: Ep
 type(wfs_descriptor),intent(inout) :: Wfs
 type(BZ_mesh_type),intent(in) :: Kmesh
 type(Gvectors_type),intent(in) :: Gsph_epsG0
 type(Little_group),intent(in) :: Ltg_q

 integer,intent(in) :: ik_bz,nbhomo(2),nbmax,is,ibv,niter
 integer,intent(in) :: nfftot_gw,ngfft_gw(18),nspinor,tim_fourdp,use_padfft,gw_mgfft
 integer,intent(in) :: ik_ibz,isym_k,itim_k
 integer,intent(in) :: tabr_k(nfftot_gw)
 integer,intent(in) :: dim_rtwg
 integer,intent(in) :: igffteps0(Ep%npwepG0)
 integer,intent(in) :: gw_gbound(2*gw_mgfft+8,2*use_padfft)
 integer,intent(in) :: grottbm1(Ep%npwvec,2,Cryst%nsym)
 real(dp),intent(in) :: spinrot_k(4)
 real(dp),intent(in) :: qplg(Ep%npwe,3),kplqg(Ep%npwe)
 real(dp),intent(in) :: spin_fact
 real(dp),intent(in) :: qp_occ(Ep%nbnds,Kmesh%nibz,Ep%nsppol)
 real(dp),intent(in) :: qp_energy(Ep%nbnds,Kmesh%nibz,Ep%nsppol)
 complex(dpc),intent(in) :: ph_mkt

 complex(gwpc),intent(in) :: wfr1(Wfs%nfftot*nspinor,nbmax)

 complex(gwpc),intent(out) :: ptwsq(Ep%npwe,Ep%npwe,niter+1)
 complex(gwpc),intent(inout) :: chi0(Ep%npwe,Ep%npwe,Ep%nomega)

 complex(gwpc),allocatable :: rhotwg(:,:)
 complex(gwpc),allocatable :: drhotwg(:,:,:)
 complex(gwpc),allocatable :: wfwfg(:)
 complex(gwpc),allocatable :: dwfwfg(:,:)
 complex(gwpc),allocatable :: ddwfwfg(:,:,:)

 complex(gwpc),allocatable :: dwfr(:,:)
 complex(gwpc),allocatable :: gwfg(:)
 complex(gwpc),allocatable :: cauxg(:,:)

 integer :: ibvp,ig,igp,igbz
 integer :: i,j
 integer :: ig4,ig4x,ig4y,ig4z
 integer :: gmgp(3)
 integer :: outofbox
 integer,save :: enough=0
 character(len=500) :: msg

 complex(dpc) :: drhaux(3)
 complex(dpc) :: paux(3)

!************************************************************************

 allocate(rhotwg(Ep%npwepG0*nspinor**2,nbmax))
 allocate(wfwfg(nfftot_gw*nspinor**2))
 if (niter>0) then
   allocate(drhotwg(Ep%npwepG0*nspinor**2,nbmax,3))
   allocate(dwfwfg(nfftot_gw*nspinor**2,3))
   allocate(gwfg(Ep%npwwfn))
   allocate(dwfr(Wfs%nfftot*nspinor,3))
 endif
 if (niter>1) allocate(ddwfwfg(nfftot_gw*nspinor**2,3,3))

 call calc_wfwfg(Wfs%MPI_enreg,Wfs%paral_kgb,tim_fourdp,tabr_k,itim_k,nfftot_gw,ngfft_gw, &
&                wfr1(:,ibv),wfr1(:,ibv),wfwfg(:))

 do ibvp = 1, nbmax
   call rho_tw_g(Wfs%paral_kgb,nspinor,Ep%npwepG0,nfftot_gw,ngfft_gw,1,use_padfft,igffteps0,gw_gbound, &
&                wfr1(:,ibvp),itim_k,tabr_k,ph_mkt,spinrot_k,wfr1(:,ibv),itim_k,tabr_k,ph_mkt, &
&                spinrot_k,dim_rtwg,rhotwg(:,ibvp),tim_fourdp,Wfs%MPI_enreg)

   if (ibvp>nbhomo(2)) then
     call calc_corr_chi0(ik_bz,Ep,Kmesh,Gsph_epsG0,Ltg_q,rhotwg(:,ibvp),spin_fact,qp_occ,qp_energy, &
&                        ibv,ibvp,ik_ibz,ik_ibz,is,chi0)
   endif
 enddo

 if (niter>0) then

   do i = 1, 3
     do ig = 1, Ep%npwwfn
       igbz = grottbm1(ig,itim_k,isym_k)
       if (itim_k==1) then
         gwfg(ig)=-Wfs%gvec(i,ig)*Wfs%Wave(ibv,ik_ibz,is)%ug(igbz)
       else
         gwfg(ig)=-Wfs%gvec(i,ig)*conjg(Wfs%Wave(ibv,ik_ibz,is)%ug(igbz))
       endif
     enddo
     call fft_onewfn(Wfs%paral_kgb,Wfs%istwfk(ik_ibz),nspinor,Ep%npwwfn,Wfs%nfftot, &
&                    gwfg,dwfr(:,i),Wfs%igfft0,Wfs%ngfft,Wfs%gvec,Wfs%gbound,tim_fourdp,Wfs%MPI_enreg)
   enddo

   do ibvp = 1, nbmax
     do i = 1, 3
       call drho_tw_g(Wfs%paral_kgb,nspinor,Ep%npwepG0,nfftot_gw,ngfft_gw,1,use_padfft,igffteps0,gw_gbound,&
&                     wfr1(:,ibvp),itim_k,tabr_k,ph_mkt,dwfr(:,i), &
&                     dim_rtwg,drhotwg(:,ibvp,i),tim_fourdp,Wfs%MPI_enreg)
     enddo
   enddo

   do i = 1, 3
     call calc_dwfwfg(Wfs%MPI_enreg,Wfs%paral_kgb,tim_fourdp,tabr_k,itim_k,nfftot_gw,ngfft_gw, &
&                     wfr1(:,ibv),dwfr(:,i),dwfwfg(:,i))
     if (niter>1) then
       do j = 1, 3
         call calc_ddwfwfg(Wfs%MPI_enreg,Wfs%paral_kgb,tim_fourdp,itim_k,nfftot_gw,ngfft_gw, &
&                          dwfr(:,i),dwfr(:,j),ddwfwfg(:,i,j))
       enddo
     endif
   enddo

   deallocate(gwfg,dwfr)
   allocate(cauxg(Ep%npwe,nbmax))

   do ig=1,Ep%npwe
     do ibvp = 1, nbmax
       drhaux(:)=cmplx(real(drhotwg(ig,ibvp,:)),aimag(drhotwg(ig,ibvp,:)))
       cauxg(ig,ibvp)=vdotw(qplg(ig,:),drhaux,Cryst%gmet,"G")
     enddo
   enddo

 endif

 ptwsq(:,:,:)=(0.0,0.0)
 outofbox=0
 do ig=1,Ep%npwe
   do igp=1,Ep%npwe
     gmgp(:)=Wfs%gvec(:,ig)-Wfs%gvec(:,igp)
     if (ANY(gmgp(:)>ngfft_gw(1:3)/2) .or. ANY(gmgp(:)<-(ngfft_gw(1:3)-1)/2)) then
       outofbox = outofbox+1; CYCLE
     end if
     ig4x= modulo(gmgp(1),ngfft_gw(1))
     ig4y= modulo(gmgp(2),ngfft_gw(2))
     ig4z= modulo(gmgp(3),ngfft_gw(3))
     ig4= 1+ig4x+ig4y*ngfft_gw(1)+ig4z*ngfft_gw(1)*ngfft_gw(2)
     if (ig>=igp) then
       ptwsq(ig,igp,1)=wfwfg(ig4)
     endif
     if (niter>0) then
       drhaux(:)=cmplx(real(dwfwfg(ig4,:)),aimag(dwfwfg(ig4,:)))
       ptwsq(ig,igp,2)=ptwsq(ig,igp,2) + vdotw(qplg(ig,:),drhaux,Cryst%gmet,"G")
       if (niter>1.and.ig>=igp) then
         paux(:)=czero
         do i = 1, 3
           drhaux(:)=cmplx(real(ddwfwfg(ig4,:,i)),aimag(ddwfwfg(ig4,:,i)))
           paux(i)=paux(i) + vdotw(qplg(igp,:),drhaux,Cryst%gmet,"G")
         enddo
         ptwsq(ig,igp,3)=ptwsq(ig,igp,3) + vdotw(qplg(ig,:),paux,Cryst%gmet,"G")
       endif
     endif
   enddo
 enddo

 if (outofbox/=0) then
   enough=enough+1
   if (enough<=10) then
     write(msg,'(a,i5)')' Number of G1-G2 pairs outside the G-sphere for Wfns = ',outofbox
     MSG_WARNING(msg)
     if (enough==10) then
       write(msg,'(a)')' ========== Stop writing Warnings =========='
       call wrtout(std_out,msg,'COLL')
     end if
   end if
 end if

 do ig=1,Ep%npwe
   do igp=1,ig
     do ibvp = 1, nbmax
       ptwsq(ig,igp,1)=ptwsq(ig,igp,1)-conjg(rhotwg(igp,ibvp))*rhotwg(ig,ibvp)
     enddo
   end do !igp
 end do !ig

 do ig = 1, Ep%npwe
   do igp = ig+1, Ep%npwe
     ptwsq(ig,igp,1)=conjg(ptwsq(igp,ig,1))
   enddo
 enddo

 if (niter>0) then
   do ig=1,Ep%npwe
     do igp=1,Ep%npwe
       do ibvp = 1, nbmax
         ptwsq(ig,igp,2)=ptwsq(ig,igp,2)-conjg(rhotwg(igp,ibvp))*cauxg(ig,ibvp)
       enddo
       ptwsq(ig,igp,2)=ptwsq(ig,igp,2)+ptwsq(ig,igp,1)*kplqg(ig)
     end do !igp
   end do !ig
 endif

 if (niter>1) then
   do ig=1,Ep%npwe
     do igp=1,ig
       do ibvp = 1, nbmax
         ptwsq(ig,igp,3)=ptwsq(ig,igp,3)-conjg(cauxg(igp,ibvp))*cauxg(ig,ibvp)
       enddo
       ptwsq(ig,igp,3)=ptwsq(ig,igp,3)+kplqg(igp)*ptwsq(ig,igp,2)+kplqg(ig)*conjg(ptwsq(igp,ig,2)) - &
&                                      kplqg(igp)*ptwsq(ig,igp,1)*kplqg(ig)
     end do !igp
   end do !ig

   do ig = 1, Ep%npwe
     do igp = ig+1, Ep%npwe
       ptwsq(ig,igp,3)=conjg(ptwsq(igp,ig,3))
     enddo
   enddo

 endif

 deallocate(rhotwg,wfwfg)
 if (niter>0) then
   deallocate(cauxg,drhotwg,dwfwfg)
 endif
 if (niter>1) deallocate(ddwfwfg)

end subroutine fft4EET_q0

subroutine fft4EET_q0_kb(ik_bz,Ep,Cryst,Wfs,Kmesh,Gsph_epsG0,Ltg_q,Psps,nbhomo,nbmax, &
&                        is,nfftot_gw,ngfft_gw,use_padfft,igffteps0, &
&                        gw_gbound,gw_mgfft,ik_ibz,isym_k,itim_k,tabr_k,ph_mkt,spinrot_k, &
&                        dim_rtwg,grottbm1,nspinor,tim_fourdp,fnlloc,fnlmax,fnlkr,mtwk,wfr1,ibv,qplg,kplqg, &
&                        niter,ptwsq,spin_fact,qp_occ,qp_energy,chi0)

 use defs_basis
 use m_gwdefs
 use defs_datatypes
 use defs_abitypes
 use m_jolly_pointers
 use m_crystal
 use m_bz_mesh
 use m_gsphere
 use m_wfs
 use m_commutator_vkbr
 use m_errors

 use m_geometry,      only : vdotw
 use m_coulombian,    only : coulombian_type
 use m_oscillators,   only : rho_tw_g, calc_wfwfg

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
 use interfaces_68_gw, except_this_one => fft4EET_q0_kb
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 type(Crystal_structure),intent(in) :: Cryst
 type(BZ_mesh_type),intent(in) :: Kmesh
 type(Pseudopotential_type),intent(in) :: Psps
 type(Epsilonm1_parameters),intent(in) :: Ep
 type(wfs_descriptor),intent(inout) :: Wfs
 type(Gvectors_type),intent(in) :: Gsph_epsG0
 type(kb_potential) :: KBff_k_ibz
 type(Little_group),intent(in) :: Ltg_q

 integer,intent(in) :: ik_bz,nbhomo(2),nbmax,is,ibv,niter
 integer,intent(in) :: nfftot_gw,ngfft_gw(18),nspinor,tim_fourdp,use_padfft,gw_mgfft
 integer,intent(in) :: ik_ibz,isym_k,itim_k
 integer,intent(in) :: tabr_k(nfftot_gw)
 integer,intent(in) :: dim_rtwg
 integer,intent(in) :: igffteps0(Ep%npwepG0)
 integer,intent(in) :: gw_gbound(2*gw_mgfft+8,2*use_padfft)
 integer,intent(in) :: grottbm1(Ep%npwvec,2,Cryst%nsym)
 integer,intent(in) :: fnlloc(Cryst%ntypat,2)
 integer,intent(in) :: fnlmax(Cryst%ntypat)
 real(dp),intent(in) :: spinrot_k(4)
 real(dp),intent(in) :: qplg(Ep%npwe,3),kplqg(Ep%npwe)
 real(dp),intent(in) :: spin_fact
 real(dp),intent(in) :: qp_occ(Ep%nbnds,Kmesh%nibz,Ep%nsppol)
 real(dp),intent(in) :: qp_energy(Ep%nbnds,Kmesh%nibz,Ep%nsppol)
 complex(dpc),intent(in) :: ph_mkt

 complex(gwpc),intent(in) :: fnlkr(Wfs%nfftot*nspinor,Psps%mpsang*Psps%mpsang,Cryst%natom)
 complex(gwpc),intent(in) :: mtwk(Wfs%nfftot*nspinor,nbmax)

 complex(gwpc),intent(in) :: wfr1(Wfs%nfftot*nspinor,nbmax)

 complex(gwpc),intent(out) :: ptwsq(Ep%npwe,Ep%npwe,niter+1)
 complex(gwpc),intent(inout) :: chi0(Ep%npwe,Ep%npwe,Ep%nomega)

 complex(gwpc),allocatable :: rhotwg(:,:)
 complex(gwpc),allocatable :: drhotwg(:,:,:)
 complex(gwpc),allocatable :: fnltwg(:,:,:)
 complex(gwpc),allocatable :: fnltwg2(:,:)
 complex(gwpc),allocatable :: fnltwg3(:,:)
 complex(gwpc),allocatable :: kns(:,:,:)
 complex(gwpc),allocatable :: wfwfg(:)
 complex(gwpc),allocatable :: dwfwfg(:,:)
 complex(gwpc),allocatable :: ddwfwfg(:,:,:)
 complex(gwpc),allocatable :: fnlwfg(:)
 complex(gwpc),allocatable :: fkdwfg(:,:)
 complex(gwpc),allocatable :: fdrhotwg(:,:,:,:)
 complex(gwpc),allocatable :: lnkp(:)

 complex(gwpc),allocatable :: dwfr(:,:)
 complex(gwpc),allocatable :: gwfg(:)
 complex(gwpc),allocatable :: cauxg(:,:)
 complex(gwpc),allocatable :: ff(:,:,:,:)
 complex(gwpc),allocatable :: vzn(:,:,:)

 complex(gwpc),allocatable :: paux(:,:)

 integer :: ilm,iat,ilm2,iat2,ibvp,ig,igp,igbz
 integer :: i,j
 integer :: ig4,ig4x,ig4y,ig4z
 integer :: ig5,ig5x,ig5y,ig5z
 integer :: nlx
 integer :: gmgp(3)
 integer :: outofbox
 integer,save :: enough=0
 character(len=500) :: msg

 complex(dpc) :: drhaux(3)
 complex(dpc) :: paux2(3)

!************************************************************************

 nlx = min(Psps%mpsang,4)

 allocate(rhotwg(Ep%npwepG0*nspinor**2,nbmax))
 allocate(wfwfg(nfftot_gw*nspinor**2))

 if (niter>0) then
   allocate(drhotwg(Ep%npwepG0*nspinor**2,nbmax,3))
   allocate(dwfwfg(nfftot_gw*nspinor**2,3))
   allocate(gwfg(Ep%npwwfn))
   allocate(dwfr(Wfs%nfftot*nspinor,3))
   allocate(fnltwg(Ep%npwepG0*nspinor**2,Psps%mpsang*Psps%mpsang,Cryst%natom))
   allocate(fnlwfg(nfftot_gw*nspinor**2))
   allocate(fnltwg2(Ep%npwepG0*nspinor**2,nbmax))
   allocate(fnltwg3(Ep%npwepG0*nspinor**2,nbmax))
 endif

 if (niter>1) then
   allocate(ddwfwfg(nfftot_gw*nspinor**2,3,3))
   allocate(lnkp(nfftot_gw*nspinor**2))
   allocate(kns(Ep%npwepG0*nspinor**2,Psps%mpsang*Psps%mpsang,Cryst%natom))
   allocate(fdrhotwg(Ep%npwepG0*nspinor**2,Psps%mpsang*Psps%mpsang,Cryst%natom,3))
   allocate(fkdwfg(nfftot_gw*nspinor**2,3))
   allocate(ff(nlx*nlx,Cryst%natom,nlx*nlx,Cryst%natom))
   allocate(vzn(Ep%npwepG0*nspinor**2,nlx*nlx,Cryst%natom))
 endif

 call calc_wfwfg(Wfs%MPI_enreg,Wfs%paral_kgb,tim_fourdp,tabr_k,itim_k,nfftot_gw,ngfft_gw, &
&                wfr1(:,ibv),wfr1(:,ibv),wfwfg(:))

 do ibvp = 1, nbmax
   call rho_tw_g(Wfs%paral_kgb,nspinor,Ep%npwepG0,nfftot_gw,ngfft_gw,1,use_padfft,igffteps0,gw_gbound, &
&                 wfr1(:,ibvp),itim_k,tabr_k,ph_mkt,spinrot_k,wfr1(:,ibv),itim_k,tabr_k,ph_mkt, &
&                spinrot_k,dim_rtwg,rhotwg(:,ibvp),tim_fourdp,Wfs%MPI_enreg)

   if (ibvp>nbhomo(2)) then
     call calc_corr_chi0(ik_bz,Ep,Kmesh,Gsph_epsG0,Ltg_q,rhotwg(:,ibvp),spin_fact,qp_occ,qp_energy, &
&                        ibv,ibvp,ik_ibz,ik_ibz,is,chi0)
   endif
 enddo

 if (niter>0) then

   do iat = 1, Cryst%natom
     do ilm = 1, Psps%mpsang*Psps%mpsang
       if (ilm>fnlmax(Cryst%typat(iat))) CYCLE
       if (ilm>=fnlloc(Cryst%typat(iat),1).and.ilm<=fnlloc(Cryst%typat(iat),2)) CYCLE
       call rho_tw_g(Wfs%paral_kgb,nspinor,Ep%npwepG0,nfftot_gw,ngfft_gw,1,use_padfft,igffteps0,gw_gbound, &
&                    fnlkr(:,ilm,iat),itim_k,tabr_k,ph_mkt,spinrot_k,wfr1(:,ibv),itim_k,tabr_k,ph_mkt, &
&                    spinrot_k,dim_rtwg,fnltwg(:,ilm,iat),tim_fourdp,Wfs%MPI_enreg)
     enddo
   enddo

   call calc_wfwfg(Wfs%MPI_enreg,Wfs%paral_kgb,tim_fourdp,tabr_k,itim_k,nfftot_gw,ngfft_gw, &
&                  wfr1(:,ibv),mtwk(:,ibv),fnlwfg)

   do i = 1, 3
     do ig = 1, Ep%npwwfn
       igbz = grottbm1(ig,itim_k,isym_k)
       if (itim_k==1) then
         gwfg(ig)=-Wfs%gvec(i,ig)*Wfs%Wave(ibv,ik_ibz,is)%ug(igbz)
       else
         gwfg(ig)=-Wfs%gvec(i,ig)*conjg(Wfs%Wave(ibv,ik_ibz,is)%ug(igbz))
       endif
     enddo
     call fft_onewfn(Wfs%paral_kgb,Wfs%istwfk(ik_ibz),nspinor,Ep%npwwfn,Wfs%nfftot, &
&                    gwfg,dwfr(:,i),Wfs%igfft0,Wfs%ngfft,Wfs%gvec,Wfs%gbound,tim_fourdp,Wfs%MPI_enreg)
   enddo

   do ibvp = 1, nbmax
     do i = 1, 3
       call drho_tw_g(Wfs%paral_kgb,nspinor,Ep%npwepG0,nfftot_gw,ngfft_gw,1,use_padfft,igffteps0,gw_gbound,&
&                     wfr1(:,ibvp),itim_k,tabr_k,ph_mkt,dwfr(:,i), &
&                     dim_rtwg,drhotwg(:,ibvp,i),tim_fourdp,Wfs%MPI_enreg)
     enddo

     call rho_tw_g(Wfs%paral_kgb,nspinor,Ep%npwepG0,nfftot_gw,ngfft_gw,1,use_padfft,igffteps0,gw_gbound, &
&                  wfr1(:,ibvp),itim_k,tabr_k,ph_mkt,spinrot_k,mtwk(:,ibv),itim_k,tabr_k,ph_mkt, &
&                  spinrot_k,dim_rtwg,fnltwg2(:,ibvp),tim_fourdp,Wfs%MPI_enreg)
     call rho_tw_g(Wfs%paral_kgb,nspinor,Ep%npwepG0,nfftot_gw,ngfft_gw,1,use_padfft,igffteps0,gw_gbound, &
&                  mtwk(:,ibvp),itim_k,tabr_k,ph_mkt,spinrot_k,wfr1(:,ibv),itim_k,tabr_k,ph_mkt, &
&                  spinrot_k,dim_rtwg,fnltwg3(:,ibvp),tim_fourdp,Wfs%MPI_enreg)
!  
   enddo

   do i = 1, 3
     call calc_dwfwfg(Wfs%MPI_enreg,Wfs%paral_kgb,tim_fourdp,tabr_k,itim_k,nfftot_gw,ngfft_gw, &
&                     wfr1(:,ibv),dwfr(:,i),dwfwfg(:,i))
     if (niter>1) then
       do j = 1, 3
         call calc_ddwfwfg(Wfs%MPI_enreg,Wfs%paral_kgb,tim_fourdp,itim_k,nfftot_gw,ngfft_gw, &
&                          dwfr(:,i),dwfr(:,j),ddwfwfg(:,i,j))
       enddo
     endif
   enddo

   if (niter>1) then

     do iat = 1, Cryst%natom
       do ilm = 1, Psps%mpsang*Psps%mpsang
         if (ilm>fnlmax(Cryst%typat(iat))) CYCLE
         if (ilm>=fnlloc(Cryst%typat(iat),1).and.ilm<=fnlloc(Cryst%typat(iat),2)) CYCLE
         do i = 1, 3
           call drho_tw_g(Wfs%paral_kgb,nspinor,Ep%npwepG0,nfftot_gw,ngfft_gw,1,use_padfft,igffteps0,gw_gbound,&
&                         fnlkr(:,ilm,iat),itim_k,tabr_k,ph_mkt,dwfr(:,i),&
&                         dim_rtwg,fdrhotwg(:,ilm,iat,i),tim_fourdp,Wfs%MPI_enreg)
         enddo
         call rho_tw_g(Wfs%paral_kgb,nspinor,Ep%npwepG0,nfftot_gw,ngfft_gw,1,use_padfft,igffteps0,gw_gbound,&
&                      fnlkr(:,ilm,iat),itim_k,tabr_k,ph_mkt,spinrot_k,mtwk(:,ibv),itim_k,tabr_k,ph_mkt, &
&                      spinrot_k,dim_rtwg,kns(:,ilm,iat),tim_fourdp,Wfs%MPI_enreg)
       enddo
     enddo

     do i = 1, 3
       call calc_dwfwfg(Wfs%MPI_enreg,Wfs%paral_kgb,tim_fourdp,tabr_k,itim_k,nfftot_gw,ngfft_gw, &
&                       mtwk(:,ibv),dwfr(:,i),fkdwfg(:,i))
     enddo
     call calc_wfwfg(Wfs%MPI_enreg,Wfs%paral_kgb,tim_fourdp,tabr_k,itim_k,nfftot_gw,ngfft_gw, &
&                    mtwk(:,ibv),mtwk(:,ibv),lnkp)

   endif

   deallocate(gwfg,dwfr)
   allocate(cauxg(Ep%npwe,nbmax))

   cauxg(:,:)=(0.0,0.0)
   do ig=1,Ep%npwe
     do ibvp = 1, nbmax
       drhaux(:)=cmplx(real(drhotwg(ig,ibvp,:)),aimag(drhotwg(ig,ibvp,:)))
       cauxg(ig,ibvp)=vdotw(qplg(ig,:),drhaux,Cryst%gmet,"G")
     enddo
     cauxg(ig,:)=cauxg(ig,:)-fnltwg2(ig,:)+fnltwg3(ig,:)
   enddo

 endif

 ptwsq(:,:,:)=(0.0,0.0)
 outofbox=0
 do ig=1,Ep%npwe
   do igp=1,Ep%npwe
     gmgp(:)=Wfs%gvec(:,ig)-Wfs%gvec(:,igp)
     if (ANY(gmgp(:)>ngfft_gw(1:3)/2) .or. ANY(gmgp(:)<-(ngfft_gw(1:3)-1)/2)) then
       outofbox = outofbox+1; CYCLE
     end if
     ig4x= modulo(gmgp(1),ngfft_gw(1))
     ig4y= modulo(gmgp(2),ngfft_gw(2))
     ig4z= modulo(gmgp(3),ngfft_gw(3))
     ig4= 1+ig4x+ig4y*ngfft_gw(1)+ig4z*ngfft_gw(1)*ngfft_gw(2)

     ig5x= modulo(-gmgp(1),ngfft_gw(1))
     ig5y= modulo(-gmgp(2),ngfft_gw(2))
     ig5z= modulo(-gmgp(3),ngfft_gw(3))
     ig5= 1+ig5x+ig5y*ngfft_gw(1)+ig5z*ngfft_gw(1)*ngfft_gw(2)

     if (ig>=igp) then
       ptwsq(ig,igp,1)=wfwfg(ig4)
     endif
     if (niter>0) then
       drhaux(:)=cmplx(real(dwfwfg(ig4,:)),aimag(dwfwfg(ig4,:)))
       ptwsq(ig,igp,2)=ptwsq(ig,igp,2) + vdotw(qplg(ig,:),drhaux,Cryst%gmet,"G")-fnlwfg(ig4)
       if (niter>1.and.ig>=igp) then
         paux2(:)=czero
         do i = 1, 3
           drhaux(:)=cmplx(real(ddwfwfg(ig4,:,i)),aimag(ddwfwfg(ig4,:,i)))
           paux2(i)=paux2(i) + vdotw(qplg(igp,:),drhaux,Cryst%gmet,"G")
         enddo
         drhaux(:)=paux2(:)-cmplx(real(fkdwfg(ig4,:)),aimag(fkdwfg(ig4,:)))
         ptwsq(ig,igp,3)=ptwsq(ig,igp,3) + vdotw(qplg(ig,:),drhaux,Cryst%gmet,"G")
         drhaux(:)=cmplx(real(fkdwfg(ig5,:)),-aimag(fkdwfg(ig5,:)))
         ptwsq(ig,igp,3)=ptwsq(ig,igp,3) - vdotw(qplg(igp,:),drhaux,Cryst%gmet,"G")+lnkp(ig4)
       endif

     endif
   enddo
 enddo

 if (outofbox/=0) then
   enough=enough+1
   if (enough<=10) then
     write(msg,'(a,i5)')' Number of G1-G2 pairs outside the G-sphere for Wfns = ',outofbox
     MSG_WARNING(msg)
     if (enough==10) then
       write(msg,'(a)')' ========== Stop writing Warnings =========='
       call wrtout(std_out,msg,'COLL')
     end if
   end if
 end if

 do ig=1,Ep%npwe
   do igp=1,ig
     do ibvp = 1, nbmax
       ptwsq(ig,igp,1)=ptwsq(ig,igp,1)-conjg(rhotwg(igp,ibvp))*rhotwg(ig,ibvp)
     enddo
   end do !igp
 end do !ig

 do ig = 1, Ep%npwe
   do igp = ig+1, Ep%npwe
     ptwsq(ig,igp,1)=conjg(ptwsq(igp,ig,1))
   enddo
 enddo

 if (niter>0) then
   allocate(paux(Ep%npwe,Ep%npwe))
   paux(:,:)=(0.0,0.0)
   do ig=1,Ep%npwe
     do igp=1,Ep%npwe
       do ibvp = 1, nbmax
         ptwsq(ig,igp,2)=ptwsq(ig,igp,2)-conjg(rhotwg(igp,ibvp))*cauxg(ig,ibvp)
       enddo
       if (ig>=igp) then
         do iat = 1, Cryst%natom
           do ilm = 1, nlx*nlx
             if (ilm>fnlmax(Cryst%typat(iat))) CYCLE
             if (ilm>=fnlloc(Cryst%typat(iat),1).and.ilm<=fnlloc(Cryst%typat(iat),2)) CYCLE
             paux(ig,igp)=paux(ig,igp)+conjg(fnltwg(igp,ilm,iat))*fnltwg(ig,ilm,iat)
           enddo
         enddo
       endif
       ptwsq(ig,igp,2)=ptwsq(ig,igp,2)+ptwsq(ig,igp,1)*kplqg(ig)
     end do !igp
   end do !ig
   do ig=1,Ep%npwe
     do igp=1,Ep%npwe
       if (ig>=igp) then
         ptwsq(ig,igp,2)=ptwsq(ig,igp,2)+paux(ig,igp)
       else
         ptwsq(ig,igp,2)=ptwsq(ig,igp,2)+conjg(paux(igp,ig))
       endif
     end do !igp
   end do !ig
   deallocate(paux)
 end if

 if (niter>1) then

   !MG KB form factors: to be done outside. array dimensioned with Kmesh%nibz
   call nullify_kb_potential(KBff_k_ibz  )

   call init_kb_potential(KBff_k_ibz ,Cryst,Psps,2,Ep%npwwfn,Kmesh%ibz(:,ik_ibz),Wfs%gvec)
   deallocate(KBff_k_ibz%fnld  )

   ff(:,:,:,:)=(0.0,0.0)
   do iat = 1, Cryst%natom
     do ilm = 1, nlx*nlx
       if (ilm>fnlmax(Cryst%typat(iat))) CYCLE
       if (ilm>=fnlloc(Cryst%typat(iat),1).and.ilm<=fnlloc(Cryst%typat(iat),2)) CYCLE
       do iat2 = 1, Cryst%natom
         do ilm2 = 1, nlx*nlx
           if (ilm2>fnlmax(Cryst%typat(iat2))) CYCLE
           if (ilm2>=fnlloc(Cryst%typat(iat2),1).and.ilm2<=fnlloc(Cryst%typat(iat2),2)) CYCLE
           do ig = 1, Ep%npwwfn
             igbz = grottbm1(ig,itim_k,isym_k)
             if (itim_k==1) then
               ff(ilm,iat,ilm2,iat2)=ff(ilm,iat,ilm2,iat2)+ &
                conjg(KBff_k_ibz%fnl(igbz,ilm,iat))*KBff_k_ibz%fnl(igbz,ilm2,iat2)
             else
               ff(ilm,iat,ilm2,iat2)=ff(ilm,iat,ilm2,iat2)+ &
                KBff_k_ibz%fnl(igbz,ilm,iat)*conjg(KBff_k_ibz%fnl(igbz,ilm2,iat2))
             endif
           enddo
         enddo
       enddo
     enddo
   enddo

   call destroy_kb_potential(KBff_k_ibz)

   vzn(:,:,:)=(0.0,0.0)
   do ig=1,Ep%npwe
     do iat = 1, Cryst%natom
       do ilm = 1, nlx*nlx
         if (ilm>fnlmax(Cryst%typat(iat))) CYCLE
         if (ilm>=fnlloc(Cryst%typat(iat),1).and.ilm<=fnlloc(Cryst%typat(iat),2)) CYCLE
         vzn(ig,:,:) = vzn(ig,:,:) + half*ff(ilm,iat,:,:)*fnltwg(ig,ilm,iat)
       enddo
     enddo
     do iat = 1, Cryst%natom
       do ilm = 1, nlx*nlx
         if (ilm>fnlmax(Cryst%typat(iat))) CYCLE
         if (ilm>=fnlloc(Cryst%typat(iat),1).and.ilm<=fnlloc(Cryst%typat(iat),2)) CYCLE
         drhaux(:)=cmplx(real(fdrhotwg(ig,ilm,iat,:)),aimag(fdrhotwg(ig,ilm,iat,:)))
         vzn(ig,ilm,iat)=vzn(ig,ilm,iat)+vdotw(qplg(ig,:),drhaux,Cryst%gmet,"G")-kns(ig,ilm,iat)
       enddo
     enddo
   enddo
   do ig=1,Ep%npwe
     do igp=1,Ep%npwe
       do ibvp = 1, nbmax
         ptwsq(ig,igp,3)=ptwsq(ig,igp,3)-conjg(cauxg(igp,ibvp))*cauxg(ig,ibvp)
       enddo
       ptwsq(ig,igp,3)=ptwsq(ig,igp,3)+kplqg(igp)*ptwsq(ig,igp,2) + kplqg(ig)*conjg(ptwsq(igp,ig,2))&
&                                     -kplqg(igp)*ptwsq(ig,igp,1)*kplqg(ig)
       do iat = 1, Cryst%natom
         do ilm = 1, nlx*nlx
           if (ilm>fnlmax(Cryst%typat(iat))) CYCLE
           if (ilm>=fnlloc(Cryst%typat(iat),1).and.ilm<=fnlloc(Cryst%typat(iat),2)) CYCLE
           ptwsq(ig,igp,3)=ptwsq(ig,igp,3)+conjg(fnltwg(igp,ilm,iat))*vzn(ig,ilm,iat)+ &
&                                                fnltwg(ig,ilm,iat)*conjg(vzn(igp,ilm,iat))
         enddo
       enddo
     end do !igp
   end do !ig

   do ig = 1, Ep%npwe
     do igp = ig+1, Ep%npwe
       ptwsq(ig,igp,3)=conjg(ptwsq(igp,ig,3))
     enddo
   enddo

 endif

 deallocate(rhotwg,wfwfg)
 if (niter>0) then
   deallocate(cauxg,drhotwg,dwfwfg,fnltwg,fnltwg2,fnltwg3,fnlwfg)
 endif
 if (niter>1) then
   deallocate(ddwfwfg,lnkp,kns,fdrhotwg,fkdwfg,vzn,ff)
 endif

end subroutine fft4EET_q0_kb

subroutine fft4EET_sig(Sigp,Dtset,Cryst,Wfs,Kmesh,Psps,Sr,nbhomo,nbmax,nomega,is,nfftot_gw,ngfft_gw, &
&                  use_padfft,igfftepsG0,gw_gbound,gw_mgfft,itim_k,tabr_k,ph_mkt,spinrot_k, &
&                  ik_ibz,ikmq_ibz,isym_kmq,itim_kmq,tabr_kmq,ph_mkmqt,spinrot_kmq,grottbm1, &
&                  nspinor,tim_fourdp,MPI_enreg,fnlloc,fnlmax,fnlkr,mtwk,mtwkp,wfr1,wfr2, &
&                  vc_sqrt_qbz,i_sz,kb,qplg,kplqg,niter,ptwsq,ik_bz,ikmq_bz, &
&                  npwc1,npwc2,botsq,otq,sigmac)

 use defs_basis
 use m_gwdefs
 use defs_datatypes
 use defs_abitypes
 use m_jolly_pointers
 use m_crystal
 use m_bz_mesh
 use m_gsphere
 use m_wfs
 use m_commutator_vkbr
 use m_errors

 use m_geometry,      only : vdotw
 use m_coulombian,    only : coulombian_type
 use m_oscillators,   only : rho_tw_g, calc_wfwfg

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
 use interfaces_68_gw, except_this_one => fft4EET_sig
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 type(Crystal_structure),intent(in) :: Cryst
 type(BZ_mesh_type),intent(in) :: Kmesh
 type(Pseudopotential_type),intent(in) :: Psps
 type(Sigma_parameters),intent(in) :: Sigp
 type(wfs_descriptor),intent(in) :: Wfs
 type(kb_potential) :: KBff_kmq_ibz
 type(Dataset_type),intent(in) :: Dtset
 type(Sigma_results),intent(in) :: Sr
 type(MPI_type),intent(inout) :: MPI_enreg

 integer,intent(in) :: nbhomo,nbmax,is,kb,niter,npwc1,npwc2,nomega
 integer,intent(in) :: nfftot_gw,ngfft_gw(18),nspinor,tim_fourdp,use_padfft,gw_mgfft
 integer,intent(in) :: ik_bz,ikmq_bz,ik_ibz,ikmq_ibz
 integer,intent(in) :: isym_kmq,itim_k,itim_kmq
 integer,intent(in) :: tabr_k(nfftot_gw),tabr_kmq(nfftot_gw)
 integer,intent(in) :: igfftepsG0(Sigp%npwc)
 integer,intent(in) :: gw_gbound(2*gw_mgfft+8,2*use_padfft)
 integer,intent(in) :: grottbm1(Sigp%npwvec,2,Cryst%nsym)
 integer,intent(in) :: fnlloc(Cryst%ntypat,2)
 integer,intent(in) :: fnlmax(Cryst%ntypat)
 real(dp),intent(in) :: spinrot_k(4),spinrot_kmq(4)
 real(dp),intent(in) :: qplg(Sigp%npwc,3),kplqg(Sigp%npwc)
 real(dp),intent(in) :: i_sz
 complex(dpc),intent(in) :: ph_mkmqt,ph_mkt

 complex(gwpc),intent(in) :: fnlkr(Wfs%nfftot*nspinor,Psps%mpsang*Psps%mpsang,Cryst%natom)
 complex(gwpc),intent(in) :: mtwk(Wfs%nfftot*nspinor,nbmax)
 complex(gwpc),intent(in) :: mtwkp(Wfs%nfftot*nspinor)

 complex(gwpc),intent(in) :: wfr1(Wfs%nfftot*nspinor,nbmax)
 complex(gwpc),intent(in) :: wfr2(Wfs%nfftot*nspinor)

 complex(gwpc),intent(in) :: vc_sqrt_qbz(Sigp%npwc)
 complex(gwpc),intent(in) :: otq(Sigp%npwc,npwc2)
 complex(gwpc),intent(in) :: botsq(Sigp%npwc,npwc1)

 complex(gwpc),intent(out) :: ptwsq(Sigp%npwc,Sigp%npwc,niter+1)
 complex(dpc),intent(inout) :: sigmac(nomega)

 complex(gwpc),allocatable :: rhotwg(:,:)
 complex(gwpc),allocatable :: drhotwg(:,:,:)
 complex(gwpc),allocatable :: fnltwg(:,:,:)
 complex(gwpc),allocatable :: fnltwg2(:,:)
 complex(gwpc),allocatable :: fnltwg3(:,:)
 complex(gwpc),allocatable :: kns(:,:,:)
 complex(gwpc),allocatable :: wfwfg(:)
 complex(gwpc),allocatable :: dwfwfg(:,:)
 complex(gwpc),allocatable :: ddwfwfg(:,:,:)
 complex(gwpc),allocatable :: fnlwfg(:)
 complex(gwpc),allocatable :: fkdwfg(:,:)
 complex(gwpc),allocatable :: fdrhotwg(:,:,:,:)
 complex(gwpc),allocatable :: lnkp(:)

 complex(gwpc),allocatable :: dwfr(:,:)
 complex(gwpc),allocatable :: gwfg(:)
 complex(gwpc),allocatable :: cauxg(:,:)
 complex(gwpc),allocatable :: ff(:,:,:,:)
 complex(gwpc),allocatable :: vzn(:,:,:)

 complex(gwpc),allocatable :: paux(:,:)

 integer :: ibv,ilm,iat,ilm2,iat2,ig,igp,igbz
 integer :: i,j
 integer :: ig4,ig4x,ig4y,ig4z
 integer :: ig5,ig5x,ig5y,ig5z
 integer :: nlx
 integer :: gmgp(3)
 integer :: outofbox
 integer,save :: enough=0
 character(len=500) :: msg

 complex(dpc) :: drhaux(3)
 complex(dpc) :: paux2(3)

!************************************************************************

 nlx = min(Psps%mpsang,4)

 allocate(rhotwg(Sigp%npwc*nspinor**2,nbmax))
 allocate(wfwfg(nfftot_gw*nspinor**2))

 if (niter>0) then
   allocate(drhotwg(Sigp%npwc*nspinor**2,nbmax,3))
   allocate(dwfwfg(nfftot_gw*nspinor**2,3))
   allocate(gwfg(Sigp%npwwfn))
   allocate(dwfr(Wfs%nfftot*nspinor,3))
   allocate(fnltwg(Sigp%npwc*nspinor**2,Psps%mpsang*Psps%mpsang,Cryst%natom))
   allocate(fnlwfg(nfftot_gw*nspinor**2))
   allocate(fnltwg2(Sigp%npwc*nspinor**2,nbmax))
   allocate(fnltwg3(Sigp%npwc*nspinor**2,nbmax))
 endif

 if (niter>1) then
   allocate(ddwfwfg(nfftot_gw*nspinor**2,3,3))
   allocate(lnkp(nfftot_gw*nspinor**2))
   allocate(kns(Sigp%npwc*nspinor**2,Psps%mpsang*Psps%mpsang,Cryst%natom))
   allocate(fdrhotwg(Sigp%npwc*nspinor**2,Psps%mpsang*Psps%mpsang,Cryst%natom,3))
   allocate(fkdwfg(nfftot_gw*nspinor**2,3))
   allocate (ff(nlx*nlx,Cryst%natom,nlx*nlx,Cryst%natom))
   allocate (vzn(Sigp%npwc*nspinor**2,nlx*nlx,Cryst%natom))
 endif

 call calc_wfwfg(MPI_enreg,Dtset%paral_kgb,tim_fourdp,tabr_kmq,itim_kmq,nfftot_gw,ngfft_gw, &
&                wfr2,wfr2,wfwfg(:))

 do ibv = 1, nbmax
   call rho_tw_g(Dtset%paral_kgb,nspinor,Sigp%npwc,nfftot_gw,ngfft_gw,1,use_padfft,igfftepsG0,gw_gbound, &
&                wfr1(:,ibv),itim_k,tabr_k,ph_mkt,spinrot_k,wfr2,itim_kmq,tabr_kmq,ph_mkmqt, &
&                spinrot_kmq,nspinor,rhotwg(:,ibv),tim_fourdp,MPI_enreg)

   if (ibv>nbhomo) then
     call calc_corr_sig(Sigp,Sr,nomega,nspinor,npwc1,npwc2,botsq,otq,rhotwg(:,ibv), &
&                       is,ibv,kb,ik_bz,ikmq_bz,ik_ibz,ikmq_ibz,i_sz,vc_sqrt_qbz,sigmac)
   endif
 enddo

 if (niter>0) then

   do iat = 1, Cryst%natom
     do ilm = 1, Psps%mpsang*Psps%mpsang
       if (ilm>fnlmax(Cryst%typat(iat))) CYCLE
       if (ilm>=fnlloc(Cryst%typat(iat),1).and.ilm<=fnlloc(Cryst%typat(iat),2)) CYCLE
       call rho_tw_g(Dtset%paral_kgb,nspinor,Sigp%npwc,nfftot_gw,ngfft_gw,1,use_padfft,igfftepsG0,gw_gbound, &
&                    fnlkr(:,ilm,iat),itim_k,tabr_k,ph_mkt,spinrot_k,wfr2,itim_kmq,tabr_kmq,ph_mkmqt, &
&                    spinrot_kmq,nspinor,fnltwg(:,ilm,iat),tim_fourdp,MPI_enreg)
     enddo
   enddo

   call calc_wfwfg(MPI_enreg,Dtset%paral_kgb,tim_fourdp,tabr_kmq,itim_kmq,nfftot_gw,ngfft_gw, &
&                  wfr2,mtwkp,fnlwfg)

   do i = 1, 3
     do ig = 1, Sigp%npwwfn
       igbz = grottbm1(ig,itim_kmq,isym_kmq)
       if (itim_kmq==1) then
         gwfg(ig)=-Wfs%gvec(i,ig)*Wfs%Wave(kb,ikmq_ibz,is)%ug(igbz)
       else
         gwfg(ig)=-Wfs%gvec(i,ig)*conjg(Wfs%Wave(kb,ikmq_ibz,is)%ug(igbz))
       endif
     enddo
     call fft_onewfn(Dtset%paral_kgb,Wfs%istwfk(ikmq_ibz),nspinor,Sigp%npwwfn,Wfs%nfftot, &
&                    gwfg,dwfr(:,i),Wfs%igfft0,Wfs%ngfft,Wfs%gvec,Wfs%gbound,tim_fourdp,MPI_enreg)
   enddo

   do ibv = 1, nbmax
     do i = 1, 3
       call drho_tw_g(Dtset%paral_kgb,nspinor,Sigp%npwc,nfftot_gw,ngfft_gw,1,use_padfft,igfftepsG0,gw_gbound,&
&                     wfr1(:,ibv),itim_k,tabr_k,ph_mkt,dwfr(:,i), &
&                     nspinor,drhotwg(:,ibv,i),tim_fourdp,MPI_enreg)
     enddo
     call rho_tw_g(Dtset%paral_kgb,nspinor,Sigp%npwc,nfftot_gw,ngfft_gw,1,use_padfft,igfftepsG0,gw_gbound, &
&                  wfr1(:,ibv),itim_k,tabr_k,ph_mkt,spinrot_k,mtwkp,itim_kmq,tabr_kmq,ph_mkmqt, &
&                  spinrot_kmq,nspinor,fnltwg2(:,ibv),tim_fourdp,MPI_enreg)
     call rho_tw_g(Dtset%paral_kgb,nspinor,Sigp%npwc,nfftot_gw,ngfft_gw,1,use_padfft,igfftepsG0,gw_gbound, &
&                  mtwk(:,ibv),itim_k,tabr_k,ph_mkt,spinrot_k,wfr2,itim_kmq,tabr_kmq,ph_mkmqt, &
&                  spinrot_kmq,nspinor,fnltwg3(:,ibv),tim_fourdp,MPI_enreg)
   enddo

   call calc_wfwfg(MPI_enreg,Dtset%paral_kgb,tim_fourdp,tabr_kmq,itim_kmq,nfftot_gw,ngfft_gw, &
&                  wfr2,wfr2,wfwfg(:))

   do i = 1, 3
     call calc_dwfwfg(MPI_enreg,Dtset%paral_kgb,tim_fourdp,tabr_kmq,itim_kmq,nfftot_gw,ngfft_gw, &
&                     wfr2,dwfr(:,i),dwfwfg(:,i))
     if (niter>1) then
       do j = 1, 3
         call calc_ddwfwfg(MPI_enreg,Dtset%paral_kgb,tim_fourdp,itim_kmq,nfftot_gw,ngfft_gw, &
&                          dwfr(:,i),dwfr(:,j),ddwfwfg(:,i,j))
       enddo
     endif
   enddo

   if (niter>1) then

     do iat = 1, Cryst%natom
       do ilm = 1, Psps%mpsang*Psps%mpsang
         if (ilm>fnlmax(Cryst%typat(iat))) CYCLE
         if (ilm>=fnlloc(Cryst%typat(iat),1).and.ilm<=fnlloc(Cryst%typat(iat),2)) CYCLE
         do i = 1, 3
           call drho_tw_g(Dtset%paral_kgb,nspinor,Sigp%npwc,nfftot_gw,ngfft_gw,1,use_padfft,igfftepsG0,gw_gbound,&
&                         fnlkr(:,ilm,iat),itim_k,tabr_k,ph_mkt,dwfr(:,i), &
&                         nspinor,fdrhotwg(:,ilm,iat,i),tim_fourdp,MPI_enreg)
         enddo
         call rho_tw_g(Dtset%paral_kgb,nspinor,Sigp%npwc,nfftot_gw,ngfft_gw,1,use_padfft,igfftepsG0,gw_gbound,&
&                      fnlkr(:,ilm,iat),itim_k,tabr_k,ph_mkt,spinrot_k,mtwkp,itim_kmq,tabr_kmq,ph_mkmqt, &
&                      spinrot_kmq,nspinor,kns(:,ilm,iat),tim_fourdp,MPI_enreg)
       enddo
     enddo

     do i = 1, 3
       call calc_dwfwfg(MPI_enreg,Dtset%paral_kgb,tim_fourdp,tabr_kmq,itim_kmq,nfftot_gw,ngfft_gw, &
&                       mtwkp,dwfr(:,i),fkdwfg(:,i))
     enddo
     call calc_wfwfg(MPI_enreg,Dtset%paral_kgb,tim_fourdp,tabr_kmq,itim_kmq,nfftot_gw,ngfft_gw, &
&                    mtwkp,mtwkp,lnkp)

   endif

   deallocate(gwfg,dwfr)
   allocate(cauxg(Sigp%npwc,nbmax))

   cauxg(:,:)=(0.0,0.0)
   do ig=1,Sigp%npwc
     do ibv = 1, nbmax
       drhaux(:)=cmplx(real(drhotwg(ig,ibv,:)),aimag(drhotwg(ig,ibv,:)))
       cauxg(ig,ibv)=vdotw(qplg(ig,:),drhaux,Cryst%gmet,"G")
     enddo
     cauxg(ig,:)=cauxg(ig,:)-fnltwg2(ig,:)+fnltwg3(ig,:)
   enddo

 endif

 ptwsq(:,:,:)=(0.0,0.0)
 outofbox=0
 do igp=1,Sigp%npwc
   do ig=1,Sigp%npwc
     gmgp(:)=Wfs%gvec(:,igp)-Wfs%gvec(:,ig)
     if (ANY(gmgp(:)>ngfft_gw(1:3)/2) .or. ANY(gmgp(:)<-(ngfft_gw(1:3)-1)/2)) then
       outofbox = outofbox+1; CYCLE
     end if
     ig4x= modulo(gmgp(1),ngfft_gw(1))
     ig4y= modulo(gmgp(2),ngfft_gw(2))
     ig4z= modulo(gmgp(3),ngfft_gw(3))
     ig4= 1+ig4x+ig4y*ngfft_gw(1)+ig4z*ngfft_gw(1)*ngfft_gw(2)

     ig5x= modulo(-gmgp(1),ngfft_gw(1))
     ig5y= modulo(-gmgp(2),ngfft_gw(2))
     ig5z= modulo(-gmgp(3),ngfft_gw(3))
     ig5= 1+ig5x+ig5y*ngfft_gw(1)+ig5z*ngfft_gw(1)*ngfft_gw(2)

     if (igp>=ig) then
       ptwsq(ig,igp,1)=wfwfg(ig4)
     endif
     if (niter>0) then
       drhaux(:)=cmplx(real(dwfwfg(ig4,:)),aimag(dwfwfg(ig4,:)))
       ptwsq(ig,igp,2)=ptwsq(ig,igp,2) + vdotw(qplg(igp,:),drhaux,Cryst%gmet,"G")-fnlwfg(ig4)
       if (niter>1.and.igp>=ig) then
         paux2(:)=czero
         do i = 1, 3
           drhaux(:)=cmplx(real(ddwfwfg(ig4,:,i)),aimag(ddwfwfg(ig4,:,i)))
           paux2(i)=paux2(i) + vdotw(qplg(ig,:),drhaux,Cryst%gmet,"G")
         enddo
         drhaux(:)=paux2(:)-cmplx(real(fkdwfg(ig4,:)),aimag(fkdwfg(ig4,:)))
         ptwsq(ig,igp,3)=ptwsq(ig,igp,3) + vdotw(qplg(igp,:),drhaux,Cryst%gmet,"G")
         drhaux(:)=cmplx(real(fkdwfg(ig5,:)),-aimag(fkdwfg(ig5,:)))
         ptwsq(ig,igp,3)=ptwsq(ig,igp,3) - vdotw(qplg(ig,:),drhaux,Cryst%gmet,"G")+lnkp(ig4)
       endif
     endif
   enddo
 enddo

 if (outofbox/=0) then
   enough=enough+1
   if (enough<=10) then
     write(msg,'(a,i5)')' Number of G1-G2 pairs outside the G-sphere for Wfns = ',outofbox
     MSG_WARNING(msg)
     if (enough==10) then
       write(msg,'(a)')' ========== Stop writing Warnings =========='
       call wrtout(std_out,msg,'COLL')
     end if
   end if
 end if

 do igp=1,Sigp%npwc
   do ig=1,igp
     do ibv = 1, nbmax
       ptwsq(ig,igp,1)=ptwsq(ig,igp,1)-conjg(rhotwg(ig,ibv))*rhotwg(igp,ibv)
     enddo
   end do !igp
 end do !ig

 do igp = 1, Sigp%npwc
   do ig = igp+1, Sigp%npwc
     ptwsq(ig,igp,1)=conjg(ptwsq(igp,ig,1))
   enddo
 enddo

 if (niter>0) then
   allocate(paux(Sigp%npwc,Sigp%npwc))
   paux(:,:)=(0.0,0.0)
   do igp=1,Sigp%npwc
     do ig=1,Sigp%npwc
       do ibv = 1, nbmax
         ptwsq(ig,igp,2)=ptwsq(ig,igp,2)-conjg(rhotwg(ig,ibv))*cauxg(igp,ibv)
       enddo
       if (ig>=igp) then
         do iat = 1, Cryst%natom
           do ilm = 1, nlx*nlx
             if (ilm>fnlmax(Cryst%typat(iat))) CYCLE
             if (ilm>=fnlloc(Cryst%typat(iat),1).and.ilm<=fnlloc(Cryst%typat(iat),2)) CYCLE
             paux(ig,igp)=paux(ig,igp)+conjg(fnltwg(ig,ilm,iat))*fnltwg(igp,ilm,iat)
           enddo
         enddo
       endif
       ptwsq(ig,igp,2)=ptwsq(ig,igp,2)+ptwsq(ig,igp,1)*kplqg(igp)
     end do !igp
   end do !ig
   do ig=1,Sigp%npwc
     do igp=1,Sigp%npwc
       if (ig>=igp) then
         ptwsq(ig,igp,2)=ptwsq(ig,igp,2)+paux(ig,igp)
       else
         ptwsq(ig,igp,2)=ptwsq(ig,igp,2)+conjg(paux(igp,ig))
       endif
     end do !igp
   end do !ig
   deallocate(paux)
 endif

 if (niter>1) then

   !MG KB form factors: to be done outside. array dimensioned with Kmesh%nibz
   call nullify_kb_potential(KBff_kmq_ibz)

   call init_kb_potential(KBff_kmq_ibz,Cryst,Psps,2,Sigp%npwwfn,Kmesh%ibz(:,ikmq_ibz),Wfs%gvec)
   deallocate(KBff_kmq_ibz%fnld)

   ff(:,:,:,:)=(0.0,0.0)
   do iat = 1, Cryst%natom
     do ilm = 1, nlx*nlx
       if (ilm>fnlmax(Cryst%typat(iat))) CYCLE
       if (ilm>=fnlloc(Cryst%typat(iat),1).and.ilm<=fnlloc(Cryst%typat(iat),2)) CYCLE
       do iat2 = 1, Cryst%natom
         do ilm2 = 1, nlx*nlx
           if (ilm2>fnlmax(Cryst%typat(iat2))) CYCLE
           if (ilm2>=fnlloc(Cryst%typat(iat2),1).and.ilm2<=fnlloc(Cryst%typat(iat2),2)) CYCLE
           do ig = 1, Sigp%npwwfn
             igbz = grottbm1(ig,itim_kmq,isym_kmq)
             if (itim_kmq==1) then
               ff(ilm,iat,ilm2,iat2)=ff(ilm,iat,ilm2,iat2)+ &
                conjg(KBff_kmq_ibz%fnl(igbz,ilm,iat))*KBff_kmq_ibz%fnl(igbz,ilm2,iat2)
             else
               ff(ilm,iat,ilm2,iat2)=ff(ilm,iat,ilm2,iat2)+ &
                KBff_kmq_ibz%fnl(igbz,ilm,iat)*conjg(KBff_kmq_ibz%fnl(igbz,ilm2,iat2))
             endif
           enddo
         enddo
       enddo
     enddo
   enddo

   call destroy_kb_potential(KBff_kmq_ibz)

   vzn(:,:,:)=(0.0,0.0)
   do igp=1,Sigp%npwc
     do iat = 1, Cryst%natom
       do ilm = 1, nlx*nlx
         if (ilm>fnlmax(Cryst%typat(iat))) CYCLE
         if (ilm>=fnlloc(Cryst%typat(iat),1).and.ilm<=fnlloc(Cryst%typat(iat),2)) CYCLE
         vzn(igp,:,:) = vzn(igp,:,:) + half*ff(ilm,iat,:,:)*fnltwg(igp,ilm,iat)
       enddo
     enddo
     do iat = 1, Cryst%natom
       do ilm = 1, nlx*nlx
         if (ilm>fnlmax(Cryst%typat(iat))) CYCLE
         if (ilm>=fnlloc(Cryst%typat(iat),1).and.ilm<=fnlloc(Cryst%typat(iat),2)) CYCLE
         drhaux(:)=cmplx(real(fdrhotwg(igp,ilm,iat,:)),aimag(fdrhotwg(igp,ilm,iat,:)))
         vzn(igp,ilm,iat)=vzn(igp,ilm,iat)+vdotw(qplg(igp,:),drhaux,Cryst%gmet,"G")-kns(igp,ilm,iat)
       enddo
     enddo
     do ig=1,igp
       do ibv = 1, nbmax
         ptwsq(ig,igp,3)=ptwsq(ig,igp,3)-conjg(cauxg(ig,ibv))*cauxg(igp,ibv)
       enddo
       ptwsq(ig,igp,3)=ptwsq(ig,igp,3)+kplqg(igp)*ptwsq(ig,igp,2)+kplqg(ig)*conjg(ptwsq(igp,ig,2))&
&                                     -kplqg(ig)*ptwsq(ig,igp,1)*kplqg(igp)
       do iat = 1, Cryst%natom
         do ilm = 1, nlx*nlx
           if (ilm>fnlmax(Cryst%typat(iat))) CYCLE
           if (ilm>=fnlloc(Cryst%typat(iat),1).and.ilm<=fnlloc(Cryst%typat(iat),2)) CYCLE
           ptwsq(ig,igp,3)=ptwsq(ig,igp,3)+conjg(fnltwg(ig,ilm,iat))*vzn(igp,ilm,iat)+ &
&                                                fnltwg(igp,ilm,iat)*conjg(vzn(ig,ilm,iat))
         enddo
       enddo
     end do !igp
   end do !ig

   do igp = 1, Sigp%npwc
     do ig = igp+1, Sigp%npwc
       ptwsq(ig,igp,3)=conjg(ptwsq(igp,ig,3))
     enddo
   enddo

 endif

 deallocate(rhotwg,wfwfg)
 if (niter>0) then
   deallocate(cauxg,drhotwg,dwfwfg,fnltwg,fnltwg2,fnltwg3,fnlwfg)
 endif
 if (niter>1) then
   deallocate(ddwfwfg,lnkp,kns,fdrhotwg,fkdwfg,vzn,ff)
 endif

end subroutine fft4EET_sig

subroutine calc_EET_sig_prep(Sigp,Cryst,Wfs,Kmesh,Psps,is,nbmax,ib1,ib2,ik_ibz, &
&                            jk_ibz,nspinor,fnlloc,fnlmax,fnlkr,fnlkpr,mtwk,mtwkp)

 use defs_basis
 use m_gwdefs
 use defs_datatypes
 use defs_abitypes
 use m_jolly_pointers
 use m_crystal
 use m_bz_mesh
 use m_gsphere
 use m_wfs
 use m_commutator_vkbr
 use m_errors
 use m_oscillators,   only : rho_tw_g

 use m_geometry,      only : normv
 use m_coulombian,    only : coulombian_type

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 type(Crystal_structure),intent(in) :: Cryst
 type(BZ_mesh_type),intent(in) :: Kmesh
 type(Pseudopotential_type),intent(in) :: Psps
 type(wfs_descriptor),intent(in) :: Wfs
 type(Sigma_parameters),intent(in) :: Sigp
 type(kb_potential) :: KBff_ki,KBff_kj

 integer,intent(in) :: is,nbmax,ib1,ib2
 integer,intent(in) :: nspinor
 integer,intent(in) :: ik_ibz,jk_ibz
 integer,intent(in) :: fnlloc(Cryst%ntypat,2)
 integer,intent(in) :: fnlmax(Cryst%ntypat)

 complex(gwpc),intent(in) :: fnlkr(Wfs%nfftot*nspinor,Psps%mpsang*Psps%mpsang,Cryst%natom)
 complex(gwpc),intent(in) :: fnlkpr(Wfs%nfftot*nspinor,Psps%mpsang*Psps%mpsang,Cryst%natom)

 complex(gwpc),intent(out) :: mtwk(Wfs%nfftot*nspinor,nbmax)
 complex(gwpc),intent(out) :: mtwkp(Wfs%nfftot*nspinor,ib1:ib2)

 complex(gwpc),allocatable :: maux(:,:)

 integer :: ibv,kb,ilm,iat,ig

!************************************************************************

 !MG KB form factors: to be done outside. array dimensioned with Kmesh%nibz
 call nullify_kb_potential(KBff_ki  )
 call nullify_kb_potential(KBff_kj)

 call init_kb_potential(KBff_ki,Cryst,Psps,2,Sigp%npwwfn,Kmesh%ibz(:,ik_ibz),Wfs%gvec)
 call init_kb_potential(KBff_kj,Cryst,Psps,2,Sigp%npwwfn,Kmesh%ibz(:,jk_ibz),Wfs%gvec)
 deallocate(KBff_ki%fnld  )
 deallocate(KBff_kj%fnld)

 allocate(maux(Psps%mpsang*Psps%mpsang,Cryst%natom))

 mtwk(:,:)=(0.0,0.0)
 do ibv = 1, nbmax
   maux(:,:)=(0.0,0)
   do ig = 1, Sigp%npwwfn
     maux(:,:) = maux(:,:) + Wfs%Wave(ibv,ik_ibz,is)%ug(ig)*KBff_ki%fnl(ig,:,:)
   enddo
   do iat = 1, Cryst%natom
     do ilm = 1, Psps%mpsang*Psps%mpsang
       if (ilm>fnlmax(Cryst%typat(iat))) CYCLE
       if (ilm>=fnlloc(Cryst%typat(iat),1).and.ilm<=fnlloc(Cryst%typat(iat),2)) CYCLE
       mtwk(:,ibv)=mtwk(:,ibv)+maux(ilm,iat)*fnlkr(:,ilm,iat)
     enddo
   enddo
 enddo

 mtwkp(:,:)=(0.0,0.0)
 do kb = ib1, ib2
   maux(:,:)=(0.0,0)
   do ig = 1, Sigp%npwwfn
     maux(:,:) = maux(:,:) + Wfs%Wave(kb,jk_ibz,is)%ug(ig)*KBff_kj%fnl(ig,:,:)
   enddo
   do iat = 1, Cryst%natom
     do ilm = 1, Psps%mpsang*Psps%mpsang
       if (ilm>fnlmax(Cryst%typat(iat))) CYCLE
       if (ilm>=fnlloc(Cryst%typat(iat),1).and.ilm<=fnlloc(Cryst%typat(iat),2)) CYCLE
       mtwkp(:,kb)=mtwkp(:,kb)+maux(ilm,iat)*fnlkpr(:,ilm,iat)
     enddo
   enddo
 enddo

 deallocate(maux)

 call destroy_kb_potential(KBff_ki)
 call destroy_kb_potential(KBff_kj)

end subroutine calc_EET_sig_prep
!!***
