!{\src2tex{textfont=tt}}
!!****f* ABINIT/cchi0
!! NAME
!! cchi0
!!
!! FUNCTION
!! Main calculation of the independent-particle susceptibility chi0 for qpoint!=0
!!
!! COPYRIGHT
!! Copyright (C) 1999-2010 ABINIT group (GMR, VO, LR, RWG, MG, RShaltaf)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!! use_tr=If .TRUE. valence states are stored in Wfs_val and only resonant transitions are calculated
!!  (time reversal is assumed)
!! Dtset <type(dataset_type)>=all input variables in this dataset
!! Dtfil <type(datafiles_type)>=variables related to files
!! k_mesh <type(bz_mesh_type)>= datatype gathering parameters related to the k-point sampling
!!    %nibz=number of k-points in the IBZ
!!    %nbz=number of k-points in the BZ
!!    %bz(3,nbz)=reduced coordinates for k-points in the full Brillouin zone
!!    %ibz(3,nibz)=reduced coordinates for k-points in the irreducible wedge
!!    %tab(nbz)=mapping between a kpt in the BZ (array bz) and the irred point in the array ibz
!!    %tabi(nbz)= -1 if inversion is needed to obtain this particular kpt in the BZ, 1 means identity
!!    %tabo(nbz)= for each point in the BZ, the index of the symmetry operation S in reciprocal
!!      space which rotates k_IBZ onto \pm k_BZ (depending on tabi)
!!    %tabp(nbz)= For each k_BZ, it gives the phase factors associated to non-symmorphic operations, i.e
!!      e^{-i 2 \pi k_IBZ \cdot R{^-1}t} == e{-i 2\pi k_BZ cdot t} where :
!!      \transpose R{-1}=S and (S k_IBZ) = \pm k_BZ (depending on ktabi)
!!    %tabr(nfftot,nbz) For each point r on the real mesh and for each k-point in the BZ, tabr
!!      gives the index of (R^-1 (r-t)) in the FFT array where R=\transpose S^{-1} and k_BZ=S k_IBZ.
!!      t is the fractional translation associated to R
!! Ep<type(epsilonm1_parameters_type)>= Parameters related to the calculation of the inverse dielectric matrix.
!!    %nbnds=number of bands summed over
!!    %npwe=number of planewaves for the irreducible polarizability X^0_GGp
!!    %npwvec=maximum number of G vectors (between Ep%npwe and Ep%npwwfn)
!!     used to define the dimension of some arrays e.g igfft
!!    %npwwfn=number of planewaves for wavefunctions (input variable, might be modified in screening)
!!    %nsppol=1 for unpolarized, 2 for spin-polarized
!!    %nomega=total number of frequencies in X^0 (both real and imaginary)
!!    %nomegasf=number of real frequencies used to sample the imaginary part of X^0 (spectral method)
!!    %spmeth=1 if we use the spectral method, 0 for standard Adler-Wiser expression
!!    %spsmear=gaussian broadening used to approximate the delta distribution
!!    %zcut=small imaginary shift to avoid poles in X^0
!! Gsph_wfn<gvectors_type data type> The G-sphere used to describe the wavefunctions.
!! Gsph_epsG0<gvectors_type data type> The G-sphere used to describe chi0/eps. (including umklapp G0 vectors)
!!    %ng=number of G vectors for chi0
!!    %rottbm1(ng,2,nsym)=contains the index (IS^{-1}) G
!!    %phmGt(Ep%npwe,nsym)=phase factors e^{-iG \cdot t} needed to symmetrize oscillator matrix elements and epsilon
!!    %gprimd(3,3)=dimensional reciprocal space primitive translations (b^-1)
!!    %gmet(3,3)=reciprocal space metric ($\textrm{bohr}^{-2}$).
!! igfft(Ep%npwepG0,2*Ep%mG0(1)+1,2*Ep%mG0(2)+1,Ep%mG0(3)+1)=index of G-G0 in the FFT grid for
!!  each G0 vector (see the cigfft.F90 routine)
!! nbvw=number of bands in the arrays wfrv
!! ngfft_gw(18)= array containing all the information for 3D FFT for the oscillator strengths (see input variable)
!! Cryst<Crystal_structure>= data type gathering info on symmetries and unit cell
!!    %natom=number of atoms
!!    %nsym=number of symmetries
!!    %xred(3,natom)=reduced coordinated of atoms
!!    %typat(natom)=type of each atom
!!    %rprimd(3,3)=dimensional primitive translations in real space (bohr)
!!    %timrev= 2 if time reversal can be used, 1 otherwise
!! nfftot_gw=Total number of points in the GW FFT grid
!! Psps <type(pseudopotential_type)>=variables related to pseudopotentials
!! qpoint(3)=reciprocal space coordinates of the q wavevector
!! Ltg_q<Little group>=Data type gathering information on the little group of the q-points.
!! Pawtab(Psps%ntypat) <type(pawtab_type)>=paw tabulated starting data
!! Pawang<pawang_type> angular mesh discretization and related data:
!! Wfd%wfr(nfftot_gw,my_minb:my_maxb,Kmesh%nibz,Ep%nsppol) = (optional) wavefunctions in real space
!! wfrv(Ep%npwwfn,nbvw,Kmesh%nibz,Ep%nsppol)= (optional) array containing fully and partially occupied states in t space
!! QP_BSt<Bandstructure_type>=Quasiparticle energies and occupations (for the moment real quantities)
!!   %mband=MAX number of bands over k-points and spin (==Ep%nbnds)
!!   %occ(mband,nkpt,nsppol)=QP occupation numbers, for each k point in IBZ, and each band
!!   %eig(mband,nkpt,nsppol)=GW energies, for self-consistency purposes
!!  Paw_pwff<Paw_pwff_type>=Form factor used to calculate the onsite mat. elements of a plane wave.
!!
!! OUTPUT
!!  chi0(Ep%npwe,Ep%npwe,Ep%nomega)=independent-particle susceptibility matrix at wavevector qpoint and
!!   each frequeny defined by Ep%omega and Ep%nomega
!!
!! PARENTS
!!      screening
!!
!! CHILDREN
!!      accumulate_chi0sumrule,approxdelta,assemblychi0_sym,assemblychi0sf
!!      assert,calc_wfwfg,completechi0_deltapart,cprj_free,get_bz_diff
!!      get_bz_item,wfd_get_ur,initmpi_seq,initylmg,leave_test,make_transitions
!!      paw_mkrhox,paw_rho_tw_g,print_little_group,rho_tw_g,setup_spectral
!!      status,symmetrize_afm_chi0,timab,wrtout,xcomm_init,xmaster_init
!!      xme_init,xmpi_nproc,xsum_master,xsum_mpi
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"

subroutine cchi0(use_tr,Dtset,Cryst,Dtfil,qpoint,Ep,Psps,Kmesh,QP_BSt,Gsph_epsG0,Gsph_wfn,&
& Pawtab,Pawang,Paw_pwff,nbvw,ngfft_gw,igfft,nfftot_gw,chi0,ktabr,Ltg_q,chi0_sumrule,Wfd)

 use defs_basis
 use defs_datatypes
 use defs_abitypes
 use m_xmpi
 use m_commutator_vkbr
 use m_errors
#ifdef HAVE_CLIB
 use m_clib
#endif

 use m_gwdefs,        only : GW_TOL_DOCC, GW_TOL_W0, czero_gw, epsilonm1_parameters, g0g0w
 use m_numeric_tools, only : imin_loc
 use m_geometry,      only : normv
 use m_crystal,       only : crystal_structure
 use m_bz_mesh,       only : bz_mesh_type, get_BZ_item, get_BZ_diff, little_group, print_little_group
 use m_gsphere,       only : gvectors_type
 use m_fft_mesh,      only : get_gftt
 use m_paw_pwij,      only : paw_pwff_type, paw_pwij_type, init_paw_pwij, destroy_paw_pwij, paw_rho_tw_g
 use m_wfs,           only : wfd_get_ur, wfs_descriptor, wfd_distribute_kb_kpbp, wfd_get_cprj, wfd_barrier, wfd_change_ngfft
 use m_oscillators,   only : rho_tw_g, calc_wfwfg

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
 use interfaces_18_timing
 use interfaces_53_abiutil
 use interfaces_66_paw
 use interfaces_68_gw, except_this_one => cchi0
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: nbvw,nfftot_gw
 logical,intent(in) :: use_tr
 type(Bandstructure_type),intent(in) :: QP_BSt
 type(BZ_mesh_type),intent(in) :: Kmesh
 type(Crystal_structure),intent(in) :: Cryst
 type(Datafiles_type),intent(in) :: Dtfil
 type(Dataset_type),intent(in) :: Dtset
 type(Epsilonm1_parameters),intent(in) :: Ep
 type(Gvectors_type),intent(in) :: Gsph_epsG0,Gsph_wfn
 type(Little_group),intent(in) :: Ltg_q
 type(Pawang_type),intent(in) :: Pawang
 type(Pseudopotential_type),intent(in) :: Psps
 type(wfs_descriptor),intent(inout) :: Wfd
!arrays
 integer,intent(in) :: ktabr(nfftot_gw,Kmesh%nbz)
 integer,intent(in) :: ngfft_gw(18)
 integer,intent(in) :: igfft(Ep%npwepG0,2*Ep%mG0(1)+1,2*Ep%mG0(2)+1,2*Ep%mG0(3)+1)
 real(dp),intent(in) :: qpoint(3)
 real(dp),intent(out) :: chi0_sumrule(Ep%npwe)
 complex(gwpc),intent(out) :: chi0(Ep%npwe*Ep%nI,Ep%npwe*Ep%nJ,Ep%nomega)
 type(Pawtab_type),intent(in) :: Pawtab(Psps%ntypat*Psps%usepaw)
 type(Paw_pwff_type),intent(in) :: Paw_pwff(Psps%ntypat*Psps%usepaw)

!Local variables ------------------------------
!scalars
 integer,parameter :: level=31,tim_fourdp=1
 integer,parameter :: two_poles=2,one_pole=1
 integer :: dim_rtwg,i1,i2,ib,ib1,ib2,idle,ierr,ig01,ig
 integer :: ig02,ig03,ig1,ig2,ik_bz,ik_ibz,ikmq_bz,ikmq_ibz
 integer :: io,iomegal,iomegar,iosf,is,istat,isym_k
 integer :: isym_kmq,itim_k,itim_kmq,my_wl,my_wr
 integer :: nfound,nkpt_summed,nspinor
 integer :: comm,gw_mgfft,use_padfft,gw_fftalga
 integer :: my_nbbp,my_nbbpks,spin
 integer :: nbmax,nbopt
 real(dp) :: deltaeGW_b1kmq_b2k,deltaeGW_enhigh_b2k,deltaf_b1kmq_b2k
 real(dp) :: e_b1_kmq,en_high,f_b1_kmq,factor,max_rest,min_rest,my_max_rest
 real(dp) :: my_min_rest,numerator,spin_fact,weight,wl,wr
 real(dp) :: gw_gsq
 complex(dpc) :: ct,ph_mkmqt,ph_mkt
 logical :: qzero !,ltest
 character(len=500) :: msg,allup
!arrays
 integer :: G0(3),wtk_ltg(Kmesh%nbz)
 integer :: got(Wfd%nproc)
 integer,allocatable :: tabr_k(:),tabr_kmq(:)
 integer,allocatable :: igfftepsG0(:),gmg0(:,:)
 integer,allocatable :: gw_gfft(:,:),gw_gbound(:,:)
 integer,allocatable :: bbp_ks_distrb(:,:,:,:)
 integer,allocatable :: bbp_ks_distrb_EET(:,:,:)
 real(dp) :: gmet(3,3),gprimd(3,3),kbz(3),kmq_bz(3),spinrot_k(4),spinrot_kmq(4),q0(3),tsec(2)
 real(dp),pointer :: qp_energy(:,:,:),qp_occ(:,:,:)
 real(dp),allocatable :: omegasf(:)
 complex(dpc),allocatable :: green_enhigh_w(:),green_w(:),kkweight(:,:)
 complex(gwpc),allocatable :: sf_chi0(:,:,:),rhotwg(:),wfr1(:)
 complex(gwpc),allocatable :: wfr2(:),wfwfg(:)
 logical,allocatable :: bbp_mask(:,:)
 type(Cprj_type),allocatable :: Cprj1_kmq(:,:),Cprj2_k(:,:)
 type(Paw_pwij_type),allocatable :: Pwij(:),Pwij_fft(:)
!************************************************************************

 DBG_ENTER("COLL")

 call timab(331,1,tsec) ! cchi0

 if ( ANY(ngfft_gw(1:3) /= Wfd%ngfft(1:3)) ) call wfd_change_ngfft(Wfd,Cryst,Psps,ngfft_gw) 
 !
 ! === Initialize MPI variables ===
 comm = Wfd%comm
 !
 ! == Copy some values ===
 nspinor = Wfd%nspinor
 gprimd(:,:)=Gsph_epsG0%gprimd(:,:)
 gmet(:,:)  =Gsph_epsG0%gmet(:,:)

 !can reduce size depending on Ep%nI and Ep%nj
 dim_rtwg=1; if (nspinor==2) dim_rtwg=4

 qp_energy => QP_BSt%eig(:,:,:)
 qp_occ    => QP_BSt%occ(:,:,:)
 !
 ! === Initialize the completeness correction  ===
 if (Ep%gwcomp==1) then
   en_high=MAXVAL(qp_energy(Ep%nbnds,:,:)) + Ep%gwencomp
   write(msg,'(a,f8.2,a)')' Using completeness correction with the energy ',en_high*Ha_eV,' [eV]'
   call wrtout(std_out,msg,'COLL')
   !
   allocate(wfwfg(nfftot_gw*nspinor**2))
   allocate(green_enhigh_w(Ep%nomega))
   !
   if (Psps%usepaw==1) then  ! * Prepare onsite contributions on the GW FFT mesh.   
     allocate(gw_gfft(3,nfftot_gw)); q0=zero
     call get_gftt(ngfft_gw,q0,gmet,gw_gsq,gw_gfft) ! Get the set of plane waves in the FFT Box.
     allocate(Pwij_fft(Psps%ntypat))
     call init_paw_pwij(Pwij_fft,nfftot_gw,(/zero,zero,zero/),gw_gfft,Cryst%rprimd,Dtfil,Psps,Pawtab,Paw_pwff)
   end if
   !
 end if
 !
 ! === Setup weights (2 for spin unpolarized sistem, 1 for polarized) ===
 ! * spin_fact is used to normalize the occupation factors to one. Consider also the AFM case.
 SELECT CASE (Ep%nsppol)
 CASE (1)
   weight=two/Kmesh%nbz; spin_fact=half
   if (Dtset%nspden==2) then
    weight=one/Kmesh%nbz; spin_fact=half
   end if
   if (nspinor==2) then
    weight=one/Kmesh%nbz; spin_fact=one
   end if
 CASE (2)
   weight=one/Kmesh%nbz; spin_fact=one
 CASE DEFAULT
   MSG_BUG("Wrong nsppol")
 END SELECT
 !
 ! === Weight for points in the IBZ_q ===
 wtk_ltg(:)=1
 if (Ep%symchi==1) then
   do ik_bz=1,Ltg_q%nbz
     wtk_ltg(ik_bz)=0
     if (Ltg_q%ibzq(ik_bz)/=1) CYCLE ! Only k-points in the IBZ_q.
     wtk_ltg(ik_bz)=SUM(Ltg_q%wtksym(:,:,ik_bz))
   end do
 end if

 write(msg,'(a,i2,2a,i2)')&
&  ' Using spectral method for the imaginary part = ',Ep%spmeth,ch10,&
&  ' Using symmetries to sum only over the IBZ_q  = ',Ep%symchi
 call wrtout(std_out,msg,'COLL')

 if (use_tr) then
   ! Special care has to be taken in metals and/or spin dependent systems
   ! as Wfs_val might contain unoccupied states.
   write(msg,'(a)')' Using faster algorithm based on time reversal symmetry. '
   call wrtout(std_out,msg,'COLL')
 end if

 ! TODO this table can be calculated for each k-point
 my_nbbpks=0; allup="All"; got=0
 allocate(bbp_ks_distrb(Wfd%mband,Wfd%mband,Kmesh%nbz,Wfd%nsppol))
 allocate(bbp_mask(Wfd%mband,Wfd%mband))

 do spin=1,Wfd%nsppol      
   do ik_bz=1,Kmesh%nbz
     if (Ep%symchi==1) then
       if (Ltg_q%ibzq(ik_bz)/=1) CYCLE  ! Only IBZ_q
     end if
     !
     ! * Get ik_ibz, non-symmorphic phase, ph_mkt, and symmetries from ik_bz.
     call get_BZ_item(Kmesh,ik_bz,kbz,ik_ibz,isym_k,itim_k)
     !
     ! * Get index of k-q in the BZ, stop if not found as the weight=one/nkbz is not correct.
     call get_BZ_diff(Kmesh,kbz,qpoint,ikmq_bz,g0,nfound)
     ABI_CHECK(nfound==1,"Check kmesh")
     !
     ! * Get ikmq_ibz, non-symmorphic phase, ph_mkmqt, and symmetries from ikmq_bz.
     call get_BZ_item(Kmesh,ikmq_bz,kmq_bz,ikmq_ibz,isym_kmq,itim_kmq)

     call chi0_bbp_mask(Ep,use_tr,QP_BSt,Wfd%mband,ikmq_ibz,ik_ibz,spin,spin_fact,bbp_mask)

     call wfd_distribute_kb_kpbp(Wfd,ikmq_ibz,ik_ibz,spin,allup,my_nbbp,bbp_ks_distrb(:,:,ik_bz,spin),got,bbp_mask) 
     my_nbbpks = my_nbbpks + my_nbbp
   end do
 end do

 deallocate(bbp_mask)

 write(msg,'(a,i0,a)')" Will sum ",my_nbbpks," (b,b',k,s) states in chi0."
 call wrtout(std_out,msg,'PERS')

 if (dtset%gw_EET/=-1) then
   !@Arjan: do you really need to reset goth here? This array is used to optimize the load distribution 
   ! taking into account the number of tasks that have been already assigned to the different procs
   got=0 
   allocate(bbp_ks_distrb_EET(nbvw,Kmesh%nbz,Wfd%nsppol))
   do spin=1,Wfd%nsppol
     do ik_bz=1,Kmesh%nbz
       if (Ep%symchi==1) then
         if (Ltg_q%ibzq(ik_bz)/=1) CYCLE  ! Only IBZ_q
       end if
       call get_BZ_item(Kmesh,ik_bz,kbz,ik_ibz,isym_k,itim_k)
       bbp_ks_distrb_EET(:,ik_bz,spin) = xmpi_undefined_rank
       do ib=1,nbvw
         if (Wfd%nproc==1) then
           bbp_ks_distrb_EET(ib,ik_bz,spin)=0
         else
           idle = imin_loc(got)
           got(idle) = got(idle) + 1
           bbp_ks_distrb_EET(ib,ik_bz,spin)=idle-1
         end if
       end do ! ib
     enddo
   enddo
 endif

 if (Psps%usepaw==1) then
   allocate(Pwij(Psps%ntypat))
   call init_paw_pwij(Pwij,Ep%npwepG0,qpoint,Gsph_epsG0%gvec,Cryst%rprimd,Dtfil,Psps,Pawtab,Paw_pwff)
   allocate(Cprj2_k  (Cryst%natom,nspinor)); call cprj_alloc(Cprj2_k,  0,Wfd%nlmn_atm)
   allocate(Cprj1_kmq(Cryst%natom,nspinor)); call cprj_alloc(Cprj1_kmq,0,Wfd%nlmn_atm)
 end if

 allocate(rhotwg(Ep%npwepG0*nspinor**2))
 allocate(tabr_k(nfftot_gw),tabr_kmq(nfftot_gw))
 allocate(wfr1(Wfd%nfftot*nspinor),wfr2(Wfd%nfftot*nspinor))

 SELECT CASE (Ep%spmeth)

 CASE (0)
   call wrtout(std_out,' Calculating chi0(q,omega,G,G")','COLL')
   allocate(green_w(Ep%nomega))

 CASE (1,2)
   call wrtout(std_out,' Calculating Im chi0(q,omega,G,G")','COLL')
   !
   ! Find Max and min resonant transitions for this q, report also treated by this proc.
   call make_transitions(Wfd,1,Ep%nbnds,nbvw,Wfd%nsppol,Ep%symchi,Cryst%timrev,GW_TOL_DOCC,&
&    max_rest,min_rest,my_max_rest,my_min_rest,Kmesh,Ltg_q,qp_energy,qp_occ,qpoint,bbp_ks_distrb)
   !
   ! Calculate frequency dependent weights for Hilbert transform.
   allocate(omegasf(Ep%nomegasf),kkweight(Ep%nomega,Ep%nomegasf))
   !my_wl=1; my_wr=Ep%nomegasf
   call setup_spectral(Ep%nomega,Ep%omega,Ep%nomegasf,omegasf,max_rest,min_rest,my_max_rest,my_min_rest,&
&    0,Ep%zcut,zero,my_wl,my_wr,kkweight)

   if (.not.use_tr) then
     MSG_BUG('spectral method requires time-reversal')
   end if

   write(msg,'(a,f12.1,a)')' memory required by sf_chi0: ',2*gwpc*Ep%npwe**2*(my_wr-my_wl+1)*Ep%nomegasf*b2Mb,' [Mb]'
   call wrtout(std_out,msg,'PERS')

   allocate(sf_chi0(Ep%npwe,Ep%npwe,my_wl:my_wr),STAT=istat)
   ABI_CHECK(istat==0,'out-of-memory sf_chi0')

   sf_chi0=czero_gw

 CASE DEFAULT
   MSG_BUG("Wrong spmeth")
 END SELECT

 nkpt_summed=Kmesh%nbz
 if (Ep%symchi==1) then
   nkpt_summed=Ltg_q%nibz_ltg
   call print_little_group(Ltg_q,std_out,Dtset%prtvol,'COLL')
 end if

 write(msg,'(a,i6,a)')' Calculation status : ',nkpt_summed,' to be completed '
 call wrtout(std_out,msg,'COLL')

 allocate(igfftepsG0(Ep%npwepG0))
 !
 ! ============================================
 ! === Begin big fat loop over transitions ===
 ! ============================================
 chi0=czero_gw; chi0_sumrule=zero

#ifdef HAVE_CLIB
 call clib_progress_bar(-1,Kmesh%nbz)
#endif

 ! === Loop on spin to calculate trace $\chi_{up,up}+\chi_{down,down}$ ===
 ! * Only $\chi_{up,up} for AFM.
 do is=1,Ep%nsppol

   if (ALL(bbp_ks_distrb(:,:,:,is) /= Wfd%my_rank)) CYCLE

   do ik_bz=1,Kmesh%nbz ! Loop over k-points in the BZ.

     if (Ep%symchi==1) then
       if (Ltg_q%ibzq(ik_bz)/=1) CYCLE  ! Only IBZ_q
     end if

     if (ALL(bbp_ks_distrb(:,:,ik_bz,is) /= Wfd%my_rank)) CYCLE

#ifdef HAVE_CLIB
     call clib_progress_bar(ik_bz,Kmesh%nbz)
#else
     write(msg,'(2(a,i4),a,i2,a,i3)')' ik = ',ik_bz,' / ',Kmesh%nbz,' is = ',is,' done by processor ',Wfd%my_rank
     !$call wrtout(std_out,msg,'PERS')
#endif
     !
     ! * Get ik_ibz, non-symmorphic phase, ph_mkt, and symmetries from ik_bz.
     call get_BZ_item(Kmesh,ik_bz,kbz,ik_ibz,isym_k,itim_k,ph_mkt)

     ! * Get index of k-q in the BZ, stop if not found as the weight=one/nkbz is not correct.
     call get_BZ_diff(Kmesh,kbz,qpoint,ikmq_bz,G0,nfound); if (nfound==0) call leave_new('COLL')

     ! * Get ikmq_ibz, non-symmorphic phase, ph_mkmqt, and symmetries from ikmq_bz.
     call get_BZ_item(Kmesh,ikmq_bz,kmq_bz,ikmq_ibz,isym_kmq,itim_kmq,ph_mkmqt)

     ! * Copy tables for rotated FFT points
     tabr_k(:)  =ktabr(:,ik_bz)
     spinrot_k(:)=Cryst%spinrot(:,isym_k)

     tabr_kmq(:)=ktabr(:,ikmq_bz)
     spinrot_kmq(:)=Cryst%spinrot(:,isym_kmq)
     !
     ! Get the G-G0 shift for the FFT of the oscillators on the G-sphere for chi0.
     ig01=G0(1)+Ep%mG0(1)+1
     ig02=G0(2)+Ep%mG0(2)+1
     ig03=G0(3)+Ep%mG0(3)+1
     igfftepsG0 = igfft(1:Ep%npwepG0,ig01,ig02,ig03)
     !
     ! Evaluate the tables needed for the padded FFT performed in rhotwg. Note that we have 
     ! to pass G-G0 to sphereboundary instead of G as we need FFT results on the shifted G-sphere, 
     ! If Gamma is not inside G-G0 one has to disable FFT padding as sphereboundary will give wrong tables.
     gw_mgfft = MAXVAL(ngfft_gw(1:3)) 
     gw_fftalga = ngfft_gw(7)/100 !; gw_fftalgc=MOD(ngfft_gw(7),10)

     use_padfft=0
     allocate(gmg0(3,Ep%npwepG0))
     do ig=1,Ep%npwepG0
       gmg0(:,ig) = Gsph_epsG0%gvec(:,ig)-G0
       if (ALL(gmg0(:,ig) == 0)) use_padfft=1
     end do
     !
     ! FIXME There is a bug in the padded-fft wrapper if one uses sg_fftpad for G-->R. Padded FFTW3 is safe instead!
     !use_padfft=0                    
     if (gw_fftalga/=3) use_padfft=0  

     allocate(gw_gbound(2*gw_mgfft+8,2*use_padfft))
     if (use_padfft==1) call sphereboundary(gw_gbound,1,gmg0,gw_mgfft,Ep%npwepG0)
     deallocate(gmg0)

     nbmax=Ep%nbnds
     if (dtset%gw_EET/=-1) then
       call gw_EET_chi0(Ep,Dtset,Cryst,Wfd,Kmesh,Gsph_epsG0,Gsph_wfn,Psps,Ltg_q,nbvw,qpoint, &
&                       nfftot_gw,ngfft_gw,use_padfft,igfftepsG0,gw_gbound,gw_mgfft,is, &
&                       ik_bz,ik_ibz,isym_k,itim_k,tabr_k,ph_mkt,spinrot_k,ikmq_ibz,itim_kmq, &
&                       tabr_kmq,ph_mkmqt,spinrot_kmq,dim_rtwg,qp_energy,chi0,spin_fact, &
&                       qp_occ,nspinor,tim_fourdp,bbp_ks_distrb_EET,nbopt)
       nbmax=nbopt
     end if

     do ib1=1,nbmax ! Loop over "conduction" states.

       if (ALL(bbp_ks_distrb(ib1,:,ik_bz,is) /= Wfd%my_rank)) CYCLE

       call wfd_get_ur(Wfd,ib1,ikmq_ibz,is,wfr1)

       if (Psps%usepaw==1) then 
         call wfd_get_cprj(Wfd,ib1,ikmq_ibz,is,Cryst,Cprj1_kmq,sorted=.FALSE.)
         call paw_symcprj(ikmq_bz,nspinor,1,Cryst,Kmesh,Psps,Pawtab,Pawang,Cprj1_kmq) 
       end if

       e_b1_kmq=qp_energy(ib1,ikmq_ibz,is)
       f_b1_kmq=   qp_occ(ib1,ikmq_ibz,is)

       do ib2=1,nbmax ! Loop over "valence" states.

         if (bbp_ks_distrb(ib1,ib2,ik_bz,is) /= Wfd%my_rank) CYCLE

         deltaf_b1kmq_b2k=spin_fact*(f_b1_kmq-qp_occ(ib2,ik_ibz,is))

#if 1
         if (Ep%gwcomp==0) then ! Skip negligible transitions.
           if (ABS(deltaf_b1kmq_b2k) < GW_TOL_DOCC) CYCLE
         else
           ! * When the completeness correction is used,
           !   we need to also consider transitions with vanishing deltaf
           !if (qp_occ(ib2,ik_ibz,is) < GW_TOL_DOCC) CYCLE
           !
           ! Rangel This is to compute chi correctly when using the extrapolar method
           if (qp_occ(ib2,ik_ibz,is) < GW_TOL_DOCC .and. (ABS(deltaf_b1kmq_b2k) < GW_TOL_DOCC .or. ib1<ib2)) CYCLE
         end if
#endif

         deltaeGW_b1kmq_b2k=e_b1_kmq-qp_energy(ib2,ik_ibz,is)

         call wfd_get_ur(Wfd,ib2,ik_ibz,is,wfr2)

         if (Psps%usepaw==1) then 
           call wfd_get_cprj(Wfd,ib2,ik_ibz,is,Cryst,Cprj2_k,sorted=.FALSE.)
           call paw_symcprj(ik_bz,nspinor,1,Cryst,Kmesh,Psps,Pawtab,Pawang,Cprj2_k) 
         end if

         SELECT CASE (Ep%spmeth)

         CASE (0) ! Standard Adler-Wiser expression.
          ! * Add the small imaginary of the Time-Ordered RF only for non-zero real omega ! FIXME What about metals?

          if (.not.use_tr) then ! Have to sum over all possible resonant and anti-resonant transitions.
            do io=1,Ep%nomega
              green_w(io) = g0g0w(Ep%omega(io),deltaf_b1kmq_b2k,deltaeGW_b1kmq_b2k,Ep%zcut,GW_TOL_W0,one_pole)
            end do
          else 
#if 1
            if (Ep%gwcomp==0) then ! cannot be completely skipped in case of completeness correction
              if (ib1<ib2) CYCLE ! Here we GAIN a factor ~2
            end if
#endif
            do io=1,Ep%nomega
              !Rangel: In metals, the intra-band transitions term does not contain the antiresonant part
              !green_w(io) = g0g0w(Ep%omega(io),deltaf_b1kmq_b2k,deltaeGW_b1kmq_b2k,Ep%zcut,GW_TOL_W0)
              if (ib1==ib2) green_w(io) = g0g0w(Ep%omega(io),deltaf_b1kmq_b2k,deltaeGW_b1kmq_b2k,Ep%zcut,GW_TOL_W0,one_pole)
              if (ib1/=ib2) green_w(io) = g0g0w(Ep%omega(io),deltaf_b1kmq_b2k,deltaeGW_b1kmq_b2k,Ep%zcut,GW_TOL_W0,two_poles)

              if (Ep%gwcomp==1) then ! Calculate the completeness correction
                numerator= -spin_fact*qp_occ(ib2,ik_ibz,is)
                deltaeGW_enhigh_b2k = en_high-qp_energy(ib2,ik_ibz,is)
                
                if (REAL(Ep%omega(io))<GW_TOL_W0) then ! Completeness correction is NOT valid for real frequencies
                  green_enhigh_w(io) = g0g0w(Ep%omega(io),numerator,deltaeGW_enhigh_b2k,Ep%zcut,GW_TOL_W0,two_poles)
                else
                  green_enhigh_w(io) = czero_gw
                end if
                !
                !Rangel Correction for metals
                !if (deltaf_b1kmq_b2k<0.d0) then
                if (ib1>=ib2 .and. abs(deltaf_b1kmq_b2k) > GW_TOL_DOCC ) then
                  green_w(io)= green_w(io) - green_enhigh_w(io)
                else ! Disregard green_w, since it is already accounted for through the time-reversal
                  green_w(io)=             - green_enhigh_w(io)
                end if
              end if !gwcomp==1
            end do !io
            !
            if (Ep%gwcomp==1.and.ib1==ib2) then ! Add the "delta part" of the extrapolar method. TODO doesnt work for spinor

              !call wfd_get_ur(Wfd,ib2,ik_ibz,is,wfr2)
              call calc_wfwfg(Wfd%MPI_enreg,Wfd%paral_kgb,tim_fourdp,tabr_k,itim_k,nfftot_gw,ngfft_gw,wfr2,wfr2,wfwfg)

              if (Psps%usepaw==1) then
                i2=ib2; if (nspinor==2) i2=(2*ib2-1)
                call paw_rho_tw_g(nfftot_gw,dim_rtwg,nspinor,Cryst%natom,Cryst%ntypat,Cryst%typat,Cryst%xred,gw_gfft,&
&                 Cprj2_k,Cprj2_k,Pwij_fft,wfwfg)

              end if

              qzero=.FALSE.
              call completechi0_deltapart(ik_bz,qzero,Ep%symchi,Ep%npwe,Ep%npwvec,Ep%nomega,nspinor,&
&               nfftot_gw,ngfft_gw,Gsph_wfn%gvec,Wfd%igfft0,Gsph_wfn,Ltg_q,green_enhigh_w,wfwfg,chi0)
            end if
          end if ! use_tr

         CASE (1,2) ! Spectral method, WARNING time-reversal here is always assumed!
#if 1
           if (deltaeGW_b1kmq_b2k<0) CYCLE
#endif
           call approxdelta(Ep%nomegasf,omegasf,deltaeGW_b1kmq_b2k,Ep%spsmear,iomegal,iomegar,wl,wr,Ep%spmeth)
         END SELECT
         !
         ! ==== Form rho-twiddle(r)=u^*_{b1,kmq_bz}(r) u_{b2,kbz}(r) and its FFT transform ====
         call rho_tw_g(Wfd%paral_kgb,nspinor,Ep%npwepG0,nfftot_gw,ngfft_gw,1,use_padfft,igfftepsG0,gw_gbound,&
&          wfr1,itim_kmq,tabr_kmq,ph_mkmqt,spinrot_kmq,&
&          wfr2,itim_k  ,tabr_k  ,ph_mkt  ,spinrot_k,&
&          dim_rtwg,rhotwg,tim_fourdp,Wfd%MPI_enreg) 

         if (Psps%usepaw==1) then! Add PAW on-site contribution, projectors are already in the BZ.
           i1=ib1; if (nspinor==2) i1=(2*ib1-1)
           i2=ib2; if (nspinor==2) i2=(2*ib2-1)
           call paw_rho_tw_g(Ep%npwepG0,dim_rtwg,nspinor,Cryst%natom,Cryst%ntypat,Cryst%typat,Cryst%xred,Gsph_epsG0%gvec,&
&           Cprj1_kmq,Cprj2_k,Pwij,rhotwg)
         end if

         SELECT CASE (Ep%spmeth)

         CASE (0) ! Adler-Wiser.
           call assemblychi0_sym(ik_bz,nspinor,Ep,Ltg_q,green_w,Ep%npwepG0,rhotwg,Gsph_epsG0,chi0)

         CASE (1,2) ! Spectral method ! TODO Does not work with spinor
           call assemblychi0sf(ik_bz,nspinor,Ep%symchi,Ltg_q,Ep%npwepG0,Ep%npwe,rhotwg,Gsph_epsG0,&
&            deltaf_b1kmq_b2k,my_wl,iomegal,wl,my_wr,iomegar,wr,Ep%nomegasf,sf_chi0)

         CASE DEFAULT
           MSG_BUG("Wrong spmeth")
         END SELECT
         !
         ! === Accumulating the sum rule on chi0 ===
         ! *Eq. (5.284) in G.D. Mahan Many-Particle Physics 3rd edition.
         ! TODO Does not work with spinor

         factor=spin_fact*qp_occ(ib2,ik_ibz,is)
         call accumulate_chi0sumrule(ik_bz,Ep%symchi,Ep%npwe,factor,deltaeGW_b1kmq_b2k,&
&          Ltg_q,Gsph_epsG0,Ep%npwepG0,rhotwg,chi0_sumrule)
         !
         ! * Include also the completeness correction in the sum rule
         if (Ep%gwcomp==1) then
           factor=-spin_fact*qp_occ(ib2,ik_ibz,is)
           call accumulate_chi0sumrule(ik_bz,Ep%symchi,Ep%npwe,factor,deltaeGW_enhigh_b2k,&
&            Ltg_q,Gsph_epsG0,Ep%npwepG0,rhotwg,chi0_sumrule)
           if (ib1==Ep%nbnds) then
             chi0_sumrule(:)=chi0_sumrule(:) + wtk_ltg(ik_bz)*spin_fact*qp_occ(ib2,ik_ibz,is)*deltaeGW_enhigh_b2k
           end if
         end if

       end do !ib2
     end do !ib1

     deallocate(gw_gbound, STAT=istat)
   end do !ik_bz
 end do !is

 deallocate(igfftepsG0)
 call wfd_barrier(Wfd)
 !
 ! === After big loop over transitions, now MPI ===
 ! * Master took care of the contribution in case of metallic|spin polarized systems.
 SELECT CASE (Ep%spmeth)
 CASE (0) ! Adler-Wiser
   ! * Collective sum of the contributions of each node.
   ! * Looping on frequencies to avoid problems with the size of the MPI packet
   do io=1,Ep%nomega
     call xsum_mpi(chi0(:,:,io),comm,ierr)
   end do
   !
   ! Divide by the volume
   chi0=chi0*weight/Cryst%ucvol

 CASE (1,2) ! Spectral method.
   write(msg,'(2a,i3,a)')ch10,&
&    ' Performing Hilbert transform using method ',Ep%spmeth,' It might take a while ...'
   call wrtout(std_out,msg,'COLL')
   !
   ! First coding, The loop over ig1, ig2 could be optimised taking into account symmetries
   do ig1=1,Ep%npwe
     do ig2=1,Ep%npwe
       do io=1,Ep%nomega
         ct=czero
         do iosf=my_wl,my_wr
           ct=ct+kkweight(io,iosf)*sf_chi0(ig1,ig2,iosf)
         end do
         chi0(ig1,ig2,io)=ct
       end do
     end do
   end do
   ! === Collective sum of the contributions ===
   ! * Looping on frequencies to avoid problems with the size of the MPI packet
   do io=1,Ep%nomega
    call xsum_master(chi0(:,:,io),Wfd%master,comm,ierr)
   end do
   chi0=chi0*weight/Cryst%ucvol

 CASE DEFAULT
   MSG_BUG("Wrong spmeth")

 END SELECT
 !
 ! === Collect the sum rule ===
 ! * The pi factor comes from Im[1/(x-ieta)] = pi delta(x)
 call xsum_mpi(chi0_sumrule,comm,ierr)
 chi0_sumrule=chi0_sumrule*pi*weight/Cryst%ucvol

 call wfd_barrier(Wfd)
 !
 ! *************************************************
 ! **** Now each node has chi0(q,G,Gp,Ep%omega) ****
 ! *************************************************

 ! Impose Hermiticity (valid only for zero or purely imaginary frequencies)
 ! MG what about metals, where we have poles around zero?
 do io=1,Ep%nomega
   if (ABS(REAL(Ep%omega(io)))<0.00001) then
     do ig2=1,Ep%npwe
       do ig1=1,ig2-1
        chi0(ig2,ig1,io)=CONJG(chi0(ig1,ig2,io))
       end do
     end do
   end if
 end do
 !
 ! === Symmetrize chi0 in case of AFM system ===
 ! * Reconstruct $chi0{\down,\down}$ from $chi0{\up,\up}$.
 ! * Works only in case of magnetic group Shubnikov type IV.
 if (Cryst%use_antiferro) then
   call symmetrize_afm_chi0(Cryst,Gsph_epsG0,Ltg_q,Ep%npwe,Ep%nomega,chi0)
 end if
 !
 ! =====================
 ! ==== Free memory ====
 ! =====================
 deallocate(bbp_ks_distrb)
 if (dtset%gw_EET/=-1) then
   deallocate(bbp_ks_distrb_EET)
 endif
 deallocate(rhotwg,tabr_k,tabr_kmq)
 deallocate(wfr1,wfr2)

 if (allocated(green_enhigh_w)) deallocate(green_enhigh_w)
 if (allocated(gw_gfft       )) deallocate(gw_gfft       )
 if (allocated(wfwfg         )) deallocate(wfwfg         )
 if (allocated(kkweight      )) deallocate(kkweight      )
 if (allocated(omegasf       )) deallocate(omegasf       )
 if (allocated(green_w       )) deallocate(green_w       )
 if (allocated(sf_chi0       )) deallocate(sf_chi0       )

 if (Psps%usepaw==1) then ! deallocation for PAW.
   call cprj_free(Cprj2_k  );   deallocate(Cprj2_k )
   call cprj_free(Cprj1_kmq);   deallocate(Cprj1_kmq)
   call destroy_paw_pwij(Pwij); deallocate(Pwij)
   if (allocated(Pwij_fft)) then
     call destroy_paw_pwij(Pwij_fft); deallocate(Pwij_fft)
   end if
 end if

 call timab(331,2,tsec)

 DBG_EXIT("COLL")

end subroutine cchi0
!!***
