!{\src2tex{textfont=tt}}
!!****f* ABINIT/check_zarot
!! NAME
!! check_zarot
!!
!! FUNCTION
!!  Debugging routine used to test zarot.
!!
!! COPYRIGHT
!!  Copyright (C) 2008-2010 ABINIT group (the_author)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!!
!! OUTPUT
!!
!! PARENTS
!!
!! CHILDREN
!!      initmpi_seq,initylmg,mati3inv,wrtout
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"        

subroutine check_zarot(npwvec,Cryst,ngfft,gvec,psps,pawang,grottb,grottbm1)

 use defs_basis
 use defs_datatypes
 use defs_abitypes
 use m_errors

 use m_fft_mesh,     only : rotate_FFT_mesh
 use m_geometry,     only : normv
 use m_crystal,      only : crystal_structure

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
 use interfaces_32_util
 use interfaces_51_manage_mpi
 use interfaces_56_recipspace
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: npwvec
 type(Crystal_structure),intent(in) :: Cryst
 type(pawang_type),intent(in) :: pawang
 type(pseudopotential_type),intent(in) :: psps
!arrays
 integer,intent(in) :: ngfft(18)
 integer,intent(in) :: grottb(npwvec,Cryst%timrev,Cryst%nsym),grottbm1(npwvec,Cryst%timrev,Cryst%nsym)
 integer,intent(in) :: gvec(3,npwvec)

!Local variables-------------------------------
!scalars
 integer :: aa,ig,ig_sym,iginv_sym,ii,ilpa,ilpm,isym,itim,jj,ll,lmax,mm,mqmem_
 integer :: nqpt_,optder,option,normchoice,npts,ix,iy,iz,ir_sym,ir !,nx,ny,nz
 real(dp) :: err,max_diff,test,tmp,ylm_sym,rx,ry,rz
 logical :: found !,iscompatibleFFT
 character(len=500) :: message
 type(MPI_type) :: Fake_MPI_enreg
!arrays
 integer :: toinv(Cryst%nsym),trial(3,3),rm1(3,3)
 integer,allocatable :: nband(:),npwarr(:),irottb(:,:)
 real(dp),allocatable :: DS_mmpl(:,:,:),DSinv_mmpl(:,:,:),qptns(:,:),ylm_q(:,:)
 real(dp),allocatable :: ylmgr_q(:,:,:)
 real(dp),allocatable :: ylmr(:,:),ylmr_gr(:,:,:),nrm(:),rr(:,:) !,dum_tnons(:,:)
 real(dp) :: search(3)

! *************************************************************************

 write(message,'(a)')' check_zarot  : enter '
 call wrtout(std_out,message,'COLL') 

 do jj=1,Cryst%nsym 
  found=.FALSE.
  do ii=1,Cryst%nsym
   call mati3inv(Cryst%symrec(:,:,ii),trial) 
   trial=transpose(trial)
   if (ALL(trial==Cryst%symrec(:,:,jj))) then
    toinv(jj)=ii
    found=.TRUE.
    exit
   end if
  end do
  if (.not. found) stop "inverse not found! "
 end do

 mqmem_=1 ; nqpt_=1 ; optder=0
 allocate(npwarr(mqmem_),qptns(3,mqmem_)) 
 npwarr(:)=npwvec ; qptns(:,:)=zero

 lmax=psps%mpsang-1
 write(*,*)'lmax= ',lmax
 allocate(ylm_q(npwvec*mqmem_,(lmax+1)**2))
 allocate(ylmgr_q(npwvec*mqmem_,3+6*(optder/2),(lmax+1)**2))
 call initmpi_seq(Fake_MPI_enreg) 
 allocate(nband(1)) ; nband=0

 ! Note: dtset%nband and dtset%nsppol are not used in sequential mode
 call initylmg(Cryst%gprimd,gvec,qptns,mqmem_,Fake_MPI_enreg,Psps%mpsang,npwvec,nband,nqpt_,npwarr,0,optder,&
& Cryst%rprimd,1,1,ylm_q,ylmgr_q)

 allocate(DS_mmpl(2*lmax+1,2*lmax+1,lmax+1))
 allocate(DSinv_mmpl(2*lmax+1,2*lmax+1,lmax+1))
 max_diff=zero ; test=zero

 do ig=1,npwvec
  if (ig==1) cycle

  do isym=1,Cryst%nsym
   do itim=1,Cryst%timrev

    ig_sym=grottb(ig,itim,isym) !index of IS G
    DS_mmpl(:,:,:)=pawang%zarot(:,:,:,isym)

    iginv_sym=grottbm1(ig,itim,isym) !index of (IS)^-1 G
    DSinv_mmpl(:,:,:)=pawang%zarot(:,:,:,toinv(isym))

    do ll=0,lmax
     do mm=1,2*ll+1
      ilpm=1+ll**2+ll+(mm-1-ll)
      ylm_sym=ylm_q(ig_sym,ilpm)     !Ylm(IS   G)
      !ylm_sym=ylm_q(iginv_sym,ilpm) !Ylm(IS^-1G)
      !
      ! here we calculate the symmetric
      tmp=zero
      do aa=1,2*ll+1
       test=MAX(test,ABS(DS_mmpl(aa,mm,ll+1)-DSinv_mmpl(mm,aa,ll+1)))
       ilpa=1+ll**2+ll+(aa-1-ll)
       tmp= tmp+ ylm_q(ig,ilpa)*DS_mmpl(aa,mm,ll+1)
      end do
      if (itim==2) tmp=tmp*(-1)**ll
      err=ABS(tmp-ylm_sym) !Ylm(IS G) = D_am Yma(S) (-1)**l

      if (err > tol6) then
       write(*,*)'WARNING check fort 77'
       write(77,'(6(a,i3),a)')' -- ig: ',ig,' igsym: ',ig_sym,' isym ',isym,' itim:',itim,' ll: ',ll,' mm: ',(mm-1-ll)," --" 
       write(77,*)tmp,ylm_sym,ABS(tmp-ylm_sym)
      end if
      max_diff=MAX(max_diff,err)

     end do
    end do !itim

   end do  !isym
  end do !sym
 end do !ig

 write(*,*)"MAX DIFF ",max_diff
 write(*,*)"MAX TEST ",test


 deallocate(nband)
 deallocate(npwarr,qptns) 
 deallocate(ylm_q,ylmgr_q)

 npts = PRODUCT(ngfft(1:3))

 allocate(irottb(npts,Cryst%nsym))
 !allocate(dum_tnons(3,Cryst%nsym)); dum_tnons=zero
 !call rotate_FFT_mesh(Cryst%nsym,Cryst%symrel,dum_tnons,ngfft,irottb,iscompatibleFFT)
 !if (.not.iscompatibleFFT) then
 !  MSG_ERROR("Uncompatible FFT mesh")
 !end if
 !deallocate(dum_tnons)

 allocate(rr(3,npts),nrm(npts))
 ii = 0
 do iz=0,ngfft(3)-1
   do iy=0,ngfft(2)-1
     do ix=0,ngfft(1)-1
       ii = ii + 1
       if (ix <= ngfft(1)/2) then
         rx = DBLE(ix)/ngfft(1)
       else
         rx = DBLE(ix-ngfft(1))/ngfft(1)
       end if
       if (iy <= ngfft(2)/2) then
         ry = DBLE(iy)/ngfft(2)
       else
         ry = DBLE(iy-ngfft(2))/ngfft(2)
       end if
       if (iz <= ngfft(3)/2) then
         rz = DBLE(iz)/ngfft(3)
       else
         rz = DBLE(iz-ngfft(3))/ngfft(3)
       end if
       rr(:,ii) = (/rx,ry,rz/)
       nrm(ii) = normv(rr(:,ii),Cryst%rmet,"R")
     end do
   end do
 end do

 irottb = HUGE(0)
 do isym=1,Cryst%nsym
   call mati3inv(Cryst%symrel(:,:,isym),rm1)
   rm1 = transpose(rm1)
   do ii=1,npts
     search = MATMUL(rm1,rr(:,ii))
     do jj=1,npts
       if (ALL (ABS(search-rr(:,jj)) < tol6)) irottb(ii,isym) = jj
     end do
   end do
 end do

 option=1; normchoice=1
 allocate(ylmr(Psps%mpsang**2,npts))
 allocate(ylmr_gr(3*(option/2)+6*(option/3),Psps%mpsang**2,npts))

 call initylmr(Psps%mpsang,normchoice,npts,nrm,option,rr,ylmr,ylmr_gr)

 max_diff=zero ; test=zero

 do isym=1,Cryst%nsym
   do ir=1,npts
     ir_sym = irottb(ir,isym) ! idx of R^{-1} (r-\tau)
     if (ir_sym == HUGE(0)) then
       write(*,*)"Got HUGE"
       CYCLE
     end if

     do ll=0,lmax
       do mm=1,2*ll+1
         ilpm=1+ll**2+ll+(mm-1-ll)
         ylm_sym=ylmr(ir_sym,ilpm)      !Ylm(R^{-1}(r-t))
         !ylm_sym=ylm_q(iginv_sym,ilpm) !Ylm(IS^-1G)
         !
         ! here we calculate the symmetric
         tmp=zero
         do aa=1,2*ll+1
           test=MAX(test,ABS(DS_mmpl(aa,mm,ll+1)-DSinv_mmpl(mm,aa,ll+1)))
           ilpa=1+ll**2+ll+(aa-1-ll)
           tmp= tmp+ ylmr(ir,ilpa)*DS_mmpl(aa,mm,ll+1)
         end do
         !if (itim==2) tmp=tmp*(-1)**ll
         err=ABS(tmp-ylm_sym) ! Ylm(R^{1}(r-t)) = D_am Yma(r)

         if (err > tol6) then
           write(*,*)'WARNING check fort 78'
           write(77,'(5(a,i3),a)')' -- ir: ',ir,' ir_sym: ',ir_sym,' isym ',isym,' ll: ',ll,' mm: ',(mm-1-ll)," --" 
           write(77,*)tmp,ylm_sym,ABS(tmp-ylm_sym)
         end if
         max_diff=MAX(max_diff,err)

       end do ! ll
     end do ! mm

   end do ! ir
 end do ! isym

 write(*,*)"MAX DIFF REAL SPACE ",max_diff
 write(*,*)"MAX TEST REAL SPACE ",test

 deallocate(ylmr,ylmr_gr)
 deallocate(irottb)
 deallocate(rr,nrm)

 deallocate(DS_mmpl,DSinv_mmpl)

end subroutine check_zarot
!!***

!{\src2tex{textfont=tt}}
!!****f* ABINIT/calc_oscillators
!! NAME
!! calc_oscillators
!!
!! FUNCTION
!!
!! COPYRIGHT
!! Copyright (C) 1999-2010 ABINIT group (MG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  Dtset <type(dataset_type)>=all input variables in this dataset
!!  Dtfil <type(datafiles_type)>=variables related to files
!!  Ep= datatype gathering differening parameters related to the calculation of the inverse dielectric matrix
!!  igfft(Ep%npwepG0,2*Ep%mG0(1)+1,Ep%mG0(2)+1,Ep%mG0(3)+1)= index of G-G0 planewaves for
!!   each G0 vectors (see cigfft.F90 routine)
!!  inclvkb=flag to include (or not) the grad of Vkb
!!  Ltg_q= little group datatype
!!  Kmesh<bz_mesh_type> The k-point mesh
!!   %kbz(3,nbz)=k-point coordinates, full Brillouin zone
!!   %tab(nbz)= table giving for each k-point in the BZ (kBZ), the corresponding
!!   irreducible point (kIBZ), where kBZ= (IS) kIBZ and I is either the inversion or the identity
!!   %tabi(nbzx)= for each point in the BZ defines whether inversion  has to be
!!   considered in the relation kBZ=(IS) kIBZ (1 => only S; -1 => -S)
!!   %tabo(nbzx)= the symmetry operation S that takes kIBZ to each kBZ
!!   %tabp(nbzx)= phase factor associated to tnons e^{-i 2 \pi k\cdot R{^-1}t}
!!  Ep%nbnds=number of bands
!!  ngfft_gw(18)= array containing all the information for 3D FFT for the oscillator strengths.
!!  Ep%nomega=number of frequencies
!!  Cryst<Crystal_structure>= data type gathering info on symmetries and unit cell
!!   %natom=number of atoms
!!   %nsym=number of symmetry operations
!!   %symrec(3,3,nsym)=symmetry operations in reciprocal space
!!   %typat(natom)=type of each atom
!!   %xred(3,natom)=reduced coordinated of atoms
!!   %rprimd(3,3)=dimensional primitive translations in real space (bohr)
!!   %timrev=2 if time-reversal symmetry can be used, 1 otherwise
!!  Ep%npwe=number of planewaves for sigma exchange (input variable)
!!  Ep%npwvec=dimension of igfft
!!  Ep%npwwfn=number of planewaves for wavefunctions (input variable)
!!  nfftot_gw=Total number of points in the GW FFT grid
!!  Ep%nsppol=1 for unpolarized, 2 for spin-polarized
!!  Ep%omega(Ep%nomega)=frequencies
!!  Psps <type(pseudopotential_type)>=variables related to pseudopotentials
!!     %mpsang=1+maximum angular momentum for nonlocal pseudopotential
!!  Pawang<pawang_type> angular mesh discretization and related data:
!!  Pawrad(ntypat*usepaw)<Pawrad_type>=paw radial mesh and related data
!!  Paw_ij(natom*usepaw)<Paw_ij_type)>=paw arrays given on (i,j) channels
!!  Wfs%ug(Ep%npwwfn,my_minb:my_maxb,Kmesh%nibz,Ep%nsppol)=
!!   Wfs in real space, for each band treated by this processor
!!  Wfs%wfr(nfftot_gw,my_minb:my_maxb,Kmesh%nibz,Ep%nsppol)=
!!   wfs in G space for each band treated by this processor
!!  Wfs_val%ug(Ep%npwwfn,nbvw,Kmesh%nbz,Ep%nsppol)=
!!   array containing fully and partially occupied states in G space
!!  Wfs_val%wfr(nfftot_gw,nbvw,Kmesh%nibz,Ep%nsppol) =  array containing unoccupied states in real space
!!  Cprj_bz(natom,Dtset%nspinor*Ep%nbnds*Kmesh%nbz*Ep%nsppol*Psps%usepaw) <type(Cprj_type)>=
!!  projected input wave functions <Proj_i|Cnk> with all NL projectors for each k-point in the full Brillouin zone
!!  QP_BSt<Bandstructure_type>=Quasiparticle energies and occupations (for the moment real quantities)
!!    %mband=MAX number of bands over k-points and spin (==Ep%nbnds)
!!    %occ(mband,nkpt,nsppol)=QP occupation numbers, for each k point in IBZ, and each band
!!    %eig(mband,nkpt,nsppol)=GW energies, for self-consistency purposes
!!  KS_BSt<Bandstructure_type>=KS energies and occupations.
!!    %eig(mband,nkpt,nsppol)=KS energies
!!  Paw_pwff<Paw_pwff_type>=Form factor used to calculate the onsite mat. elements of a plane wave.
!!
!! OUTPUT
!!
!! NOTES
!!  The terms "head", "wings" and "body" of chi(G,Gp) refer to
!!  G=Gp=0, either G or Gp=0, and neither=0 respectively
!!
!! TODO
!!  Check npwepG0 before Switching on umklapp
!!  Routines used to evaluate mat. elements of the commutator should be redefined as functions
!!  to allow inlining. Unfortunately it seems that doing so make g95 crash.
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"

subroutine calc_oscillators(Dtset,Cryst,Dtfil,Ep,Psps,Kmesh,QP_BSt,KS_BSt,&
&  Pawang,Pawrad,Pawtab,Paw_ij,Paw_pwff,ngfft_gw,igfft,nfftot_gw,&
&  Ltg_q,Cprj_ibz,Cprj_bz,inclvkb,Wfs,Wfs_val)

 use defs_basis
 use defs_datatypes
 use defs_abitypes
 use m_xmpi
 use m_errors

 use m_gwdefs,          only : GW_TOL_DOCC, GW_TOL_W0, czero_gw, epsilonm1_parameters
 use m_crystal,         only : crystal_structure
 use m_fft_mesh,        only : get_gftt, rotate_FFT_mesh
 use m_bz_mesh,         only : bz_mesh_type, get_BZ_item, little_group, print_little_group
 use m_gsphere,         only : gvectors_type
 use m_wfs,             only : wfd_get_ur, wfs_descriptor, wfd_print
 use m_oscillators,     only : rho_tw_g, oscillator_t, calc_pw_oscillator, init_oscillator, &
&                              destroy_oscillator, nullify_oscillator
 use m_paw_pwij,        only : paw_pwff_type, paw_pwij_type, init_paw_pwij, destroy_paw_pwij, paw_rho_tw_g
 use m_paw_commutator,  only : HUr_commutator, destroy_Hur, nullify_Hur, make_Hur_commutator, paw_ihr_comm
 use m_commutator_vkbr, only : kb_potential, nullify_kb_potential, destroy_kb_potential, init_kb_potential, &
&                              nc_ihr_comm

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
 use interfaces_51_manage_mpi
 use interfaces_53_abiutil
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: nfftot_gw,inclvkb
 type(Bandstructure_type),intent(in) :: QP_BSt,KS_BSt
 type(Crystal_structure),intent(in) :: Cryst
 type(Dataset_type),intent(in) :: Dtset
 type(Datafiles_type),intent(in) :: Dtfil
 type(Little_group),intent(in) :: Ltg_q
 type(Epsilonm1_parameters),intent(in) :: Ep
 type(BZ_mesh_type),intent(in) :: Kmesh
 type(Pseudopotential_type),intent(in) :: Psps
 type(Pawang_type),intent(in) :: Pawang
 type(wfs_descriptor),intent(inout) :: Wfs,Wfs_val

!arrays
 integer,intent(in) :: igfft(Ep%npwepG0,2*Ep%mG0(1)+1,2*Ep%mG0(2)+1,Ep%mG0(3)+1)
 integer,intent(in) :: ngfft_gw(18)
 type(Pawrad_type),intent(in) :: Pawrad(Cryst%ntypat*Psps%usepaw)
 type(Pawtab_type),intent(in) :: Pawtab(Cryst%ntypat*Psps%usepaw)
 type(Paw_ij_type),intent(in) :: Paw_ij(Cryst%natom*Psps%usepaw)
 type(Paw_pwff_type),intent(in) :: Paw_pwff(Psps%ntypat*Psps%usepaw)
 type(Cprj_type),intent(in) :: Cprj_ibz(Cryst%natom,Dtset%nspinor*Ep%nbnds*Kmesh%nibz*Ep%nsppol*Psps%usepaw)
 type(Cprj_type),intent(in) :: Cprj_bz (Cryst%natom,Dtset%nspinor*Ep%nbnds*Kmesh%nbz*Ep%nsppol*Psps%usepaw)

!Local variables ------------------------------
!scalars
 integer,parameter :: tim_fourdp=1,paral_kgb=0
 integer :: nspinor,ispinor,ibsp,nab,use_padfft,istat
 integer :: ib,ib1,ib2,itim_k,ik_bz,ik_ibz,iqlwl,isym_k,isppol,spad,dim_rtwg
 integer :: iat,i1,i2,shift,indx_kbz,indx_kibz,ifft
 integer :: master,nprocs,spaceComm,my_rank !,npwwfn,
 real(dp) :: spin_fact,deltaf_b1b2
 real(dp) :: deltaeGW_b1b2
 complex(dpc) :: deltaeKS_b1b2
 !complex(gwpc) :: ct
 logical :: iscompatibleFFT
 character(len=500) :: msg_tmp,msg
 type(MPI_type) :: Fake_MPI_enreg
 type(kb_potential) :: Kb
!arrays
 integer,allocatable :: dimlmn(:)
 integer,allocatable :: gbound(:,:)
 integer :: spinorwf_pad(2,4)
 integer,allocatable :: tabr_k(:)
 integer,pointer :: igfftwfn0(:)
 integer,allocatable :: igffteps0(:)
 integer,allocatable :: irottb(:,:),ktabr(:,:)
 real(dp) :: kbz(3),rcart2red(3,3)
 !real(dp) :: igradpaw_cart(2,3),igradred_paw(2,3)
 real(dp) :: spinrot_kbz(4)
 real(dp),pointer :: ks_energy(:,:,:),qp_energy(:,:,:),qp_occ(:,:,:)
 complex(gwpc) :: rhotwx(3,Dtset%nspinor**2)
 complex(gwpc),allocatable :: rhotwg(:)
 complex(dpc) :: ph_mkt
 complex(gwpc),allocatable :: wfr1(:),wfr2(:) !what about pointers?
 complex(gwpc),pointer :: wfg1(:),wfg2(:) !,ug1(:),ug2(:)
 type(Cprj_type),allocatable :: Cprj_kbz(:,:),Cprj_kibz(:,:)
 type(Paw_pwij_type),allocatable :: Pwij(:)
 type(HUr_commutator),allocatable :: Hur(:)

!************************************************************************

 DBG_ENTER("COLL")

 call wfd_print(Wfs_val)

 ! For the time being no padded-FFT
 use_padfft=0
 allocate(gbound(1,0))

!
!=== Get the FFT index of $ (R^{-1}(r-\tau)) $ ===
!* S= $\transpose R^{-1}$ and k_BZ = S k_IBZ
!* irottb is the FFT index of $ R^{-1} (r-\tau) $ used to symmetrize u_Sk.
 allocate(irottb(nfftot_gw,Cryst%nsym))
 call rotate_FFT_mesh(Cryst%nsym,Cryst%symrel,Cryst%tnons,ngfft_gw,irottb,iscompatibleFFT)
 ABI_CHECK(iscompatibleFFT,"FFT not compatible with symmetry operations")

 allocate(ktabr(nfftot_gw,Kmesh%nbz))
 do ik_bz=1,Kmesh%nbz
  isym_k=Kmesh%tabo(ik_bz)
  do ifft=1,nfftot_gw
   ktabr(ifft,ik_bz)=irottb(ifft,isym_k)
  end do
 end do
 deallocate(irottb)
 !
 ! === Initialize MPI stuff ===
 call initmpi_seq(Fake_MPI_enreg)

 call xcomm_init  (Fake_MPI_enreg,spaceComm)

 nprocs  = xcomm_size(spaceComm) 
 my_rank = xcomm_rank(spaceComm)
 master=0
 !
 ! == Copy some values ===
 nspinor=Dtset%nspinor; nab=nspinor**2
 rcart2red = TRANSPOSE(Cryst%gprimd)

 dim_rtwg=1; if (Dtset%nspinor==2) dim_rtwg=4  !can reduce size depending on Ep%nI and Ep%nj

 spinorwf_pad(:,:)=RESHAPE((/0,0,Wfs%npwwfn,Wfs%npwwfn,0,Wfs%npwwfn,Wfs%npwwfn,0/),(/2,4/))

 SELECT CASE (Ep%nsppol)
 CASE (1)
  spin_fact=half; if (Dtset%nspinor==2) spin_fact=one
 CASE (2)
  spin_fact=one
 CASE DEFAULT
  MSG_BUG("Wrong nsppol")
 END SELECT

 ks_energy => KS_BSt%eig(:,:,:)
 qp_energy => QP_BSt%eig(:,:,:)
 qp_occ    => QP_BSt%occ(:,:,:)

 

 if (Psps%usepaw==0) then
  ! TODO everything should be calculated inside the loop over k-point to save memory and also CPU time.
  if (inclvkb/=0) then ! Include term <n,k|[Vnl,iqr]|n"k>' for q->0.
   ABI_CHECK(nspinor==1,"nspinor+inclvkb not coded")
  else
   msg=' Neglecting term <n,k|[Vnl,iqr]|m,k> '
   MSG_WARNING(msg)
  end if

 else ! For PAW+LDA+U, precalculate <\phi_i|[Hu,r]|phi_j\> ===
  ! MG Not so sure that Paw_ij%noccomp is correctly initialized as we skipped pawdenpot.
  ! FIXME SOLUTION set inclvkb in the output file so that we know it has to be recalculated in the client code.
  allocate(HUr(Cryst%natom))
  call nullify_Hur(HUr)
  if (Dtset%usepawu/=0) then
   call make_Hur_commutator(Ep%nsppol,Dtset%pawprtvol,Cryst,Psps,Pawtab,Pawang,Pawrad,Paw_ij,Hur)
  end if
 end if

 !
 ! * Get the G-G0 shift for the FFT of the oscillators.
 allocate(igffteps0(Ep%npwe))
 igffteps0 = igfft(1:Ep%npwe,Ep%mG0(1)+1,Ep%mG0(2)+1,Ep%mG0(3)+1)

 ! Here I need a first igfft for rho_tw_g (on the espilon sphere) and a second on the g sphere for the wavefunctions.
 !igffwfnt0 => igfft(:,Ep%mG0(1)+1,Ep%mG0(2)+1,Ep%mG0(3)+1)
 igfftwfn0  => Wfs%igfft0

 write(msg,'(a,i3,a)')' Q-points for long wave-length limit. # ',Ep%nqlwl,ch10
 do iqlwl=1,Ep%nqlwl
  write(msg_tmp,'(1x,i5,a,2x,3f12.6,a)') iqlwl,')',Ep%qlwl(:,iqlwl),ch10
  msg=TRIM(msg)//msg_tmp
 end do
 call wrtout(std_out,msg,'COLL')

 ! === Evaluate matrix elements of a planewave btw PAW partial waves ===
 ! * Note that that Gamma is set to zero
 if (Psps%usepaw==1) then
  allocate(Pwij(Cryst%ntypat))
  call init_paw_pwij(Pwij,Ep%npwepG0,(/zero,zero,zero/),Wfs%gvec,Cryst%rprimd,Dtfil,Psps,Pawtab,Paw_pwff)

  allocate(dimlmn(Cryst%natom))
  do iat=1,Cryst%natom
   dimlmn(iat)=Pawtab(Cryst%typat(iat))%lmn_size
  end do
  allocate(Cprj_kbz (Cryst%natom,nspinor*Ep%nbnds)) ; call cprj_alloc(Cprj_kbz,0,dimlmn)
  allocate(Cprj_kibz(Cryst%natom,nspinor*Ep%nbnds)) ; call cprj_alloc(Cprj_kibz,0,dimlmn)
 end if

 allocate(rhotwg(Ep%npwe*nspinor**2),tabr_k(nfftot_gw))
 allocate(wfr1(Wfs%nfftot*nspinor),wfr2(Wfs%nfftot*nspinor))
 ABI_CHECK(Wfs%nfftot==nfftot_gw,"Wrong nfftot_gw")
 !
 ! =================================
 ! === Fat loop over transitions ===
 ! =================================
 call nullify_kb_potential(Kb)

 do isppol=1,Ep%nsppol
  do ik_bz=1,Kmesh%nbz ! k-points in the BZ.
   !
   if (Ltg_q%ibzq(ik_bz)/=1) CYCLE ! Only IBZ_q

   write(msg,'(2(a,i4),a,i2,a,i3)')' ik= ',ik_bz,' / ',Kmesh%nbz,' isppol= ',isppol,' done by processor ',my_rank
   call wrtout(std_out,msg,'PERS')
   !
   ! * Get ik_ibz, non-symmorphic phase and symmetries from ik_bz.
   call get_BZ_item(Kmesh,ik_bz,kbz,ik_ibz,isym_k,itim_k,ph_mkt)
   spinrot_kbz(:)=Cryst%spinrot(:,isym_k)

   tabr_k=ktabr(:,ik_bz) ! Table for rotated FFT points

   if (Psps%usepaw==0.and.Ep%inclvkb/=0) then ! Include term <n,k|[Vnl,iqr]|n"k>' for q->0.
    call init_kb_potential(KB,Cryst,Psps,inclvkb,Wfs%npwwfn,Kmesh%ibz(:,ik_ibz),Wfs%gvec)
   end if

   if (Psps%usepaw==1) then ! Load cprj for this k-point.
    shift=nspinor*Ep%nbnds*Kmesh%nbz*(isppol-1)
    indx_kbz =nspinor*Ep%nbnds*(ik_bz -1)+shift
    indx_kibz=nspinor*Ep%nbnds*(ik_ibz-1)+nspinor*Ep%nbnds*Kmesh%nibz*(isppol-1)
    ibsp=0
    do ib=1,Ep%nbnds
     do ispinor=1,nspinor
      ibsp=ibsp+1
      do iat=1,Cryst%natom
       Cprj_kbz (iat,ibsp)%cp(:,:)=Cprj_bz (iat,indx_kbz +ibsp)%cp(:,:)
       Cprj_kibz(iat,ibsp)%cp(:,:)=Cprj_ibz(iat,indx_kibz+ibsp)%cp(:,:)
      end do
     end do
    end do
   end if
   !
   ! /***********************************************************************/
   ! Conventions: 1) a symmetry in real space acts as R_t f(r) = f(R^-1(r-t))
   !              2) S=\transpose R^-1
   !              3) kbz=S kibz
   !
   !  The wavefunctions for the k-point in the BZ are (assuming nondegenerate states):
   !
   !  u(G,b, Sk) = u ( S^-1G,b,k)* e^{-i(Sk+G)*t)
   !  u(G,b,-Sk) = u*(-S^-1G,b,k)* e^{ i(Sk-G)*t)
   !
   !  u(r,b, Sk) = u (R^-1(r-t),b,k) e^{-iSk*t}
   !  u(r,b,-Sk) = u*(R^-1(r-t),b,k) e^{ iSK*t}
   !
   !  The gradient of Vnl(K,Kp) for the k-point in the BZ should be:
   !   Kb%gradvnl(SG,SGp,Sk)=S Kb%gradvnl(G,Gp,kibz)
   ! FIXME should check the expression in case of non zero tnons.
   ! /***********************************************************************/

   !$all init_oscillator(Osc,isppol,jkbz,Kmesh,iq_bz,Qmesh,Ep%npwe,nspinor,(/ib,ib/),(/ib1,ib2/) )
   !$call calc_pw_oscillator(Wf_info,Cryst,Osc,MPI_enreg)
   !$call destroy_oscillator(Osc)

   do ib1=1,Ep%nbnds ! Loop over "conduction" states.
    do ib2=1,Ep%nbnds ! Loop over "valence" states.

     deltaeKS_b1b2= ks_energy(ib1,ik_ibz,isppol) - ks_energy(ib2,ik_ibz,isppol)
     deltaeGW_b1b2= qp_energy(ib1,ik_ibz,isppol) - qp_energy(ib2,ik_ibz,isppol)

     deltaf_b1b2=spin_fact*(qp_occ(ib1,ik_ibz,isppol)-qp_occ(ib2,ik_ibz,isppol))

     wfg1 => Wfs%Wave(ib1,ik_ibz,isppol)%ug
     wfg2 => Wfs%Wave(ib2,ik_ibz,isppol)%ug

     call wfd_get_ur(Wfs,ib1,ik_ibz,isppol,wfr1)
     call wfd_get_ur(Wfs,ib2,ik_ibz,isppol,wfr2)

     call rho_tw_g(paral_kgb,nspinor,Ep%npwe,nfftot_gw,ngfft_gw,1,use_padfft,igffteps0,gbound,&
&     wfr1,itim_k,tabr_k,ph_mkt,spinrot_kbz,&
&     wfr2,itim_k,tabr_k,ph_mkt,spinrot_kbz,&
&     dim_rtwg,rhotwg,tim_fourdp,Fake_MPI_enreg)
     !
     if (Psps%usepaw==1) then ! Add PAW onsite contribution, projectors are already in the BZ.
      spad=(nspinor-1)
      i1=ib1; if (nspinor==2) i1=(2*ib1-1)
      i2=ib2; if (nspinor==2) i2=(2*ib2-1)
      call paw_rho_tw_g(Ep%npwe,dim_rtwg,nspinor,Cryst%natom,Cryst%ntypat,Cryst%typat,Cryst%xred,Wfs%gvec,&
&      Cprj_kbz(:,i1:i1+spad),Cprj_kbz(:,i2:i2+spad),Pwij,rhotwg)
     end if
     !
     ! 1) Plane wave contribution for -i\nabla_r
     !rhotwx(:,:)=czero_gw
     !do iab=1,nab
     ! spad1 = spinorwf_pad(1,iab)
     ! spad2 = spinorwf_pad(2,iab)
     ! ug1 => wfg1(spad1+1:spad1+Wfs%npwwfn)
     ! ug2 => wfg2(spad2+1:spad2+Wfs%npwwfn)
     ! do ig=1,Wfs%npwwfn
     !  ct=CONJG(ug1(ig))*ug2(ig)
     !  rhotwx(:,iab)=rhotwx(:,iab)+Wfs%gvec(:,ig)*ct
     ! end do
     !end do

     ! 2) If PAW add onsite contribution of \nabla_r
     !  * paw_inabla work with Cartesian coordinates while rhotwx is in reduced coords.
     ! TODO Find a clever way to deal with spinors
     !      paw_inabla should be a function to allow inling but check g95
     !      Add spinorial case
     if (Psps%usepaw==0) then  ! Calculate matrix elements of i[H,r] for NC pseudopotentials.        
       rhotwx = nc_ihr_comm(nspinor,Wfs%npwwfn,Ep%inclvkb,Kb,wfg1,wfg2,Wfs%gvec) 
     else 
      i1=ib1 ; if (nspinor==2) i1=(2*ib1-1)
      i2=ib2 ; if (nspinor==2) i2=(2*ib2-1)

      rhotwx = paw_ihr_comm(isppol,nspinor,Wfs%npwwfn,Kmesh%ibz(:,ik_ibz),Cryst,Pawtab,&
&       wfg1,wfg2,Wfs%gvec,Cprj_kibz(:,i1:),Cprj_kibz(:,i2:),HUr)

      !call paw_inabla(isppol,Cryst%natom,Cryst%typat,Pawtab,Cprj_kbz(:,i1),Cprj_kbz(:,i2),HUr,igradpaw_cart)
      !call paw_inabla(isppol,Cryst%natom,Cryst%typat,Pawtab,Cprj_kibz(:,i1),Cprj_kibz(:,i2),HUr,igradpaw_cart)
      !igradred_paw(1,:)=MATMUL(rcart2red,igradpaw_cart(1,:))
      !igradred_paw(2,:)=MATMUL(rcart2red,igradpaw_cart(2,:))
      !rhotwx(:,1)=rhotwx(:,1)-CMPLX(igradred_paw(1,:),igradred_paw(2,:),gwpc)
     end if
     !
     ! === For PPS add term <c,k|[Vnl,iqr]|v,k> only if required ===
     ! * Two different algorithms are coded, the second one is much faster
     ! * WARNING: Spinor is not coded.
     !
     !if (inclvkb/=0.and.Psps%usepaw==0) then 
     ! call add_vnlr_commutator(Kb,Wfs%npwwfn,nspinor,wfg1,wfg2,rhotwx)
     !end if

     if (abs(deltaeKS_b1b2)>GW_TOL_W0) then
      rhotwx(:,:)=-rhotwx(:,:)/deltaeKS_b1b2
     else
      rhotwx(:,:)=czero_gw
     endif

    end do !ib2
   end do !ib1

   call destroy_kb_potential(Kb)
  end do !ik_bz
 end do !isppol

 deallocate(igffteps0)
 deallocate(gbound, STAT=istat)
 call xbarrier_mpi(spaceComm)
 !
 ! === Free memory ===
 deallocate(rhotwg,tabr_k,ktabr)
 deallocate(wfr1,wfr2)
 !
 ! * Optional deallocation for PAW.
 if (Psps%usepaw==1) then
  deallocate(dimlmn)
  call cprj_free(Cprj_kbz )   ; deallocate(Cprj_kbz )
  call cprj_free(Cprj_kibz)   ; deallocate(Cprj_kibz)
  call destroy_paw_pwij(Pwij) ; deallocate(Pwij     )
  call destroy_Hur(Hur)
 end if

 DBG_EXIT("COLL")

end subroutine calc_oscillators
!!***


!!****f* ABINIT/paw_check_symcprj
!! NAME
!! paw_check_symcprj
!!
!! FUNCTION
!!
!! COPYRIGHT
!! Copyright (C) 2010 ABINIT group (MG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"

subroutine paw_check_symcprj(Wfd,ik_bz,band,spin,sym_mode,Cryst,Kmesh,Psps,Pawtab,Pawang,Cprj_bz) 

 use defs_basis
 use defs_datatypes
 use defs_abitypes
 use m_errors

 use m_crystal,        only : crystal_structure
 use m_bz_mesh,        only : bz_mesh_type, get_BZ_item
 use m_wfs,            only : wfs_descriptor, wfd_get_cprj, kdata_init, kdata_free, kdata_t, wfd_sym_ur

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_53_abiutil
 use interfaces_53_ffts
 use interfaces_65_nonlocal
 use interfaces_66_paw
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: ik_bz,band,spin,sym_mode
 type(Crystal_structure),intent(in) :: Cryst
 type(BZ_mesh_type),intent(in) :: Kmesh
 type(Pawang_type),intent(in) :: Pawang
 type(Pseudopotential_type),intent(in) :: Psps
 type(wfs_descriptor),intent(inout) :: Wfd
!arrays
 type(Pawtab_type),intent(in) :: Pawtab(Psps%ntypat*Psps%usepaw)
 type(Cprj_type),intent(out) :: Cprj_bz(Cryst%natom,Wfd%nspinor)

!Local variables ------------------------------
!scalars
 integer :: k_sym,k_tim,ik_ibz,ig,fft_idx,istat
 integer :: cpopt,choice,matblk,npw_k,istwf_k,nkpg
 integer :: iatom,iatm,isp
 complex(dpc) :: k_eimkt
 logical :: k_isirred
 type(Kdata_t) :: Gdata
!arrays
 integer,pointer :: kg_k(:,:)
 integer :: k_umklp(3)
 real(dp) :: k_bz(3)
 real(dp) :: dummy_ekb(0,0)
 real(dp),allocatable :: kpg_k(:,:),vectin(:,:)
 complex(dpc) :: ur1_dpc(Wfd%nfft*Wfd%nspinor)
 complex(gwpc) :: ur1(Wfd%nfft*Wfd%nspinor)
 type(cprj_type),allocatable :: Cprj_srt(:,:)

!************************************************************************

 call get_BZ_item(Kmesh,ik_bz,k_bz,ik_ibz,k_sym,k_tim,k_eimkt,k_umklp,k_isirred)

 if (k_isirred) then  ! Symmetrization is not needed. Retrieve Cprj_ibz from Wfd and return immediately.
   call wfd_get_cprj(Wfd,band,ik_ibz,spin,Cryst,Cprj_bz,sorted=.FALSE.)
   RETURN
 end if

 select case (sym_mode) 

 case (1) ! Faster Symmetrization in reciprocal space.

   call wfd_get_cprj(Wfd,band,ik_ibz,spin,Cryst,Cprj_bz,sorted=.FALSE.)
   call paw_symcprj(ik_bz,Wfd%nspinor,1,Cryst,Kmesh,Psps,Pawtab,Pawang,Cprj_bz) 

 case (2) ! Symmetrize u(r) in reciprocal space, FFT from r to G then call getcprj to obtain the symmetrized cprj.

   ! Symmetrization in real space on the FFT BOX.
   call wfd_sym_ur(Wfd,Cryst,Kmesh,band,ik_bz,spin,ur1)

   istwf_k = 1 

   ! Init k_data associated to the G-sphere centered at k_bz.
   call kdata_init(Gdata,Cryst,Psps,k_bz,istwf_k,Wfd%ngfft,Wfd%MPI_enreg,ecut=Wfd%ecut)

   npw_k = Gdata%npw
   kg_k  => Gdata%kg_k
   !
   ! Compute (k+G) vectors
   nkpg=0
   allocate(kpg_k(npw_k,nkpg)); if (nkpg>0) call mkkpg(kg_k,kpg_k,k_bz,nkpg,npw_k)

   allocate(vectin(2,npw_k*Wfd%nspinor))
   !ABI_CHECK(npw_k==Wfd%npwwfn,"Wrong npw")
   !
   ! FFT R -> G TODO Fix issue with double precision complex.
   ur1_dpc = ur1
   call fourdp_c2c_ip(ur1_dpc,-1,Wfd%MPI_enreg,Wfd%nfft,Wfd%ngfft,Wfd%paral_kgb,0)

   do ig=1,npw_k ! FFT box to G-sphere.
     fft_idx = Gdata%igfft0(ig)
     if (fft_idx/=0) then ! G-G0 belong to the FFT mesh.
       vectin(1,ig) = DBLE (ur1_dpc(fft_idx))
       vectin(2,ig) = AIMAG(ur1_dpc(fft_idx))
     else               
       vectin(:,ig) = zero ! Set this component to zero.
     end if
   end do
   !
   ! Calculate SORTED cprj.
   cpopt   = 0 ! Nothing is already calculated.
   choice  = 1
   matblk  = Cryst%natom

   allocate(Cprj_srt(Wfd%natom,Wfd%nspinor))
   call cprj_alloc(Cprj_srt,0,Wfd%nlmn_sort)

   call getcprj(choice,cpopt,vectin,Cprj_srt,0,0,Gdata%dim_fnlylm,dummy_ekb,Gdata%fnlylm,&
&    0,Wfd%indlmn,istwf_k,kg_k,kpg_k,k_bz,Wfd%lmnmax,matblk,Wfd%mgfft,Wfd%MPI_enreg,&
&    Cryst%natom,Cryst%nattyp,Wfd%ngfft,nkpg,Wfd%nloalg,npw_k,Wfd%nspinor,Cryst%ntypat,&
&    Gdata%phkxred,Wfd%ph1d,Gdata%ph3d,Cryst%ucvol,Wfd%usepaw,1)

   deallocate(vectin)
   deallocate(kpg_k,STAT=istat)
   !
   ! Reorder cprj (sorted --> unsorted)
   do iatom=1,Cryst%natom
     iatm=Cryst%atindx(iatom)
     do isp=1,Wfd%nspinor
       Cprj_bz(iatom,isp)%cp=Cprj_srt(iatm,isp)%cp
     end do
   end do
   call cprj_free(Cprj_srt); deallocate(Cprj_srt)

   call kdata_free(Gdata)

 case default
   MSG_ERROR("Wrong sym_mode")
 end select

end subroutine paw_check_symcprj
!!***
