!{\src2tex{textfont=tt}}
!!****f* ABINIT/gw2wfk
!! NAME
!! gw2wfk
!!
!! FUNCTION
!!  Produces a standard k-centered WFK file containing QP energies, occupancies 
!!  and wavefunction. The WFK file will contain a modified header with the
!!  basic parameters used for the GW calculation and the QP onsite occupancies
!!  in the case of PAW.
!!
!! COPYRIGHT
!!  Copyright (C) 2008-2010 ABINIT group (MG)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!!  codvsn=code version
!!
!! OUTPUT
!!
!! NOTES
!!  * The routine accepts block of bands with different number of bands for k-point.
!!    Note, however, that ALL the occupied states should be passed in input in order to
!!    have a correct WFK file. If some states are missing, many quantities calculated from the WFK will be wrong.
!!    Providing a Wfs% structure fulfilling the above constraint is delegated to the caller
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"

subroutine gw2wfk(Wfs,Dtset,Cryst,Psps,Pawtab,QP_Pawrhoij,QP_BSt,accesswff,fnameabo_wfk,codvsn,ierr)

 use defs_basis
 use defs_datatypes
 use defs_abitypes
 use m_xmpi
 use m_errors

 use m_io_tools,    only : get_unit
 use m_crystal,     only : crystal_structure
 use m_header,      only : hdr_init, hdr_clean
 use m_ebands,      only : update_occ, bstruct_init, bstruct_clean
 use m_wffile,      only : wffile_type
 use m_wfs,         only : wfs_descriptor, wfd_gamma2k

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
 use interfaces_53_abiutil
 use interfaces_59_io_mpi
 use interfaces_61_ionetcdf
 use interfaces_62_iowfdenpot
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: accesswff
 integer,intent(out) :: ierr
 character(len=fnlen),intent(in) :: fnameabo_wfk
 character(len=6),intent(in) :: codvsn
 type(Dataset_type),intent(in) :: Dtset
 type(wfs_descriptor),intent(inout) :: Wfs
 type(Bandstructure_type),intent(in) :: QP_BSt
 type(Crystal_structure),intent(in) :: Cryst
 type(Pseudopotential_type),intent(in) :: Psps
!arrays
 type(Pawrhoij_type),intent(in) :: QP_pawrhoij(Cryst%natom*Psps%usepaw)
 type(Pawtab_type),intent(in) :: Pawtab(Psps%ntypat*Psps%usepaw)

!Local variables ------------------------------
!scalars
 integer :: my_accesswff,unwff,formeig,my_mkmem,npw_k
 integer :: spaceComm,master,rank,rdwr,fform,imiss,ikg
 integer :: isppol,ikibz,option,headform,icg,optkg,tim_rwwf
 integer :: bantot,ib,jj
 integer :: mcg,nband_k,nband_disk,mband
 integer :: pertcase
 character(len=500) :: msg
 type(Wffile_type) :: Wff
 type(Dataset_type) :: my_Dtset
 type(Hdr_type) :: my_Hdr
 type(Bandstructure_type) :: my_BSt
!arrays
 real(dp),allocatable :: eig_k(:),occ_k(:)
 real(dp),allocatable :: doccde(:),eigen(:),occfact(:)
 integer,pointer :: kg_k(:,:) 
 real(dp),allocatable  :: cg_k(:,:) 

!************************************************************************

 DBG_ENTER("COLL")

 MSG_ERROR("Recheck the implementation as Wfs has been changed")

 ierr=0

 spaceComm = Wfs%comm   
 master    = Wfs%master
 rank      = Wfs%my_rank

 unwff = get_unit()
 call wrtout(std_out,"gw2wfk : about to write "//TRIM(fnameabo_wfk),"COLL")

 my_accesswff = -1 
 SELECT CASE (accesswff)
 CASE (IO_MODE_FORTRAN,IO_MODE_ETSF)
   my_accesswff = accesswff
 CASE (IO_MODE_NETCDF)
   MSG_ERROR("Direct NETCDF not coded")
 END SELECT

 ! === Initialize a local band structure with QP results ===
 ! * Copy QP energies and occupations 

 bantot=SUM(Wfs%nband)
 allocate(doccde(bantot),eigen(bantot),occfact(bantot))
 doccde=zero; eigen=zero; occfact=zero 

 jj=0
 do isppol=1,Wfs%nsppol
   do ikibz=1,Wfs%nkibz
     do ib=1,Wfs%nband(ikibz,isppol)
       if (ib<=QP_BSt%nband(ikibz+(isppol-1)*QP_BSt%nkpt)) then 
         jj=jj+1
         occfact(jj)=QP_BSt%occ(ib,ikibz,isppol)
         eigen  (jj)=QP_BSt%eig(ib,ikibz,isppol)
       else 
         MSG_ERROR("I was about to SIGFAULT")
       end if
     end do
   end do
 end do

 ! Have to change nband
 call bstruct_init(bantot,my_BSt,QP_Bst%nelect,doccde,eigen,Wfs%istwfk,Wfs%kibz,Wfs%nband,&
& Wfs%nkibz,Wfs%npwarr,Wfs%nsppol,Wfs%nspinor,QP_BSt%tphysel,QP_BSt%tsmear,QP_Bst%occopt,occfact,QP_Bst%wtk) 
 
 ! Have to recalculate new occupation numbers, the Fermi level and the Max occupied band index 
 call update_occ(my_BSt,Dtset%fixmom,prtvol=Dtset%prtvol)

 deallocate(doccde,eigen)

 ! === Init new header === 
 ! Have to update some values
 call dtsetCopy(my_Dtset,Dtset)

 my_Dtset%ecut    = Wfs%ecut 
 my_Dtset%ngfft   = Wfs%ngfft
#if 0
 my_Dtset%ngfftdg = Wfs%ngfftdg
 my_Dtset%ecutsm  = Wfs%ecutsm
#endif

 pertcase=0
 call hdr_init(my_BSt,codvsn,my_Dtset,my_Hdr,Pawtab,pertcase,Psps)

 call dtsetFree(my_Dtset)

 ! Update some quantities:
 ! 1) Fermi level
 ! 2) QP_Pawrhoij for PAW
 !
 call hdr_update(bantot,1.0d20,my_BSt%fermie,my_Hdr,Cryst%natom,1.0d20,&
&  Cryst%rprimd,occfact,Wfs%MPI_enreg,QP_Pawrhoij,Psps%usepaw,Cryst%xred)

 deallocate(occfact)
 call bstruct_clean(my_BSt)
 !
 ! * Init Wff structure.
 call WffOpen(my_accesswff,spaceComm,fnameabo_wfk,ierr,Wff,master,rank,unwff)

 call xbarrier_mpi(spaceComm)

 ! * Write Header to unformatted file 
 rdwr=2; fform=2 

 if (ANY(Wff%accesswff == (/IO_MODE_FORTRAN, IO_MODE_FORTRAN_MASTER, IO_MODE_MPI/) )) then
   call hdr_io(fform,my_Hdr,rdwr,Wff)
   call WffKg(Wff,1)
 else if (Wff%accesswff==IO_MODE_ETSF .and. rank==master) then
   call hdr_io_etsf(fform,my_Hdr,rdwr,Wff%unwff)
 end if
 !
 ! For each spin and k-point, do:
 !  1) Convert wfs from gamma-centered to k-centered basis set
 !  2) Write G vectors, energies, occ and u(G) on file.
 !
 do isppol=1,Wfs%nsppol
   do ikibz=1,Wfs%nkibz
     call xbarrier_mpi(spaceComm)
     !
     ! * Perform conversion of basis set.
     ikg=0
     call wfd_gamma2k(Wfs,ikibz,isppol,ikg,kg_k,cg_k,Cryst%gmet,imiss)
     if (imiss>0) then 
       write(msg,'(2(a,i4))')' Missing ',imiss,' components for ikibz= ',ikibz
       MSG_WARNING(msg)
     end if

     npw_k = SIZE(kg_k,DIM=2) 

     nband_k   = Wfs%nband(ikibz,isppol)
     mband     = nband_k  
     nband_disk= nband_k
     my_mkmem  =1
     mcg       =npw_k*Wfs%nspinor*mband*my_mkmem*Wfs%nsppol

     ABI_CHECK(SIZE(cg_k,DIM=2)==mcg,"Size mismatch")

     formeig=0 
     allocate(eig_k((2*mband)**formeig * mband))
     allocate(occ_k(mband))
     occ_k = QP_BSt%occ(1:mband,ikibz,isppol)
     eig_k = QP_BSt%eig(1:mband,ikibz,isppol)

     headform=0; icg=0; option=2; optkg=1; tim_rwwf=0

     ! Write set of bands for this (k,s).
     call rwwf(cg_k,eig_k,formeig,headform,icg,ikibz,isppol,kg_k,mband,mcg,Wfs%MPI_enreg,nband_k,&
&      nband_disk,npw_k,Wfs%nspinor,occ_k,option,optkg,tim_rwwf,Wff)

     deallocate(eig_k,occ_k)
     deallocate(kg_k,cg_k)

   end do !ikibz
 end do !isppol
 !
 ! * Close the wavefunction file (and do NOT delete it !)
 call WffClose(Wff,ierr)
 !
 ! * Free local memory.
 call hdr_clean(my_Hdr)

 DBG_EXIT("COLL")

end subroutine gw2wfk
!!***

