!{\src2tex{textfont=tt}}
!!****m* ABINIT/m_FFT_prof
!! NAME
!! m_FFT_prof
!!
!! COPYRIGHT
!!  Copyright (C) 2008-2009 ABINIT group (MG)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"

MODULE m_FFT_prof

 use defs_basis
 use defs_abitypes
 use m_fftw3
 use m_errors 

 use m_fft_mesh,    only : print_ngfft, fftalg_info
 use m_gsphere,     only : get_kg
 use m_oscillators, only : rho_tw_g

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_12_hide_mpi
 use interfaces_32_util
 use interfaces_42_geometry
 use interfaces_51_manage_mpi
 use interfaces_53_ffts
 use interfaces_56_recipspace
!End of the abilint section

 implicit none

 public

 integer,public,parameter :: TNAME_LEN=100

 type,public :: FFT_test_t
   !private
   integer :: ndat=-1
   integer :: istwf_k=-1
   !?integer :: option_fourwf=-1
   integer :: paral_kgb=-1
   integer :: npw_k=-1
   integer :: nfft=-1
   integer :: mgfft=-1
   integer :: ngfft(18)=-1
   integer,pointer :: kg_k(:,:)     SET2NULL       
   real(dp) :: kpoint(3)=(/zero,zero,zero/)
   logical :: use_istwfk=.FALSE.
   logical :: store_results=.FALSE.
   type(MPI_type) :: MPI_enreg
 end type FFT_test_t   
                                            
 type,public :: FFT_prof_t
   !private
   integer :: ncalls
   !$integer :: ndat
   character(len=TNAME_LEN) :: test_name   
   real(dp) :: cpu_time
   real(dp) :: wall_time
   !$integer :: ngfft(18)=-1
   real(dp),pointer :: results(:,:,:)  SET2NULL
 end type FFT_prof_t

 integer,save,private :: NCALLS_FOR_TEST=1

CONTAINS  !====================================================================
!!***

!----------------------------------------------------------------------

!!****f* m_FFT_prof/init_FFT_test
!! NAME
!!  init_FFT_test
!!
!! FUNCTION
!!  Creation method for the FFT_test_t structured datatype.
!!
!! INPUTS
!!
!! OUTPUT
!!
!! PARENTS
!!      fftprof
!!
!! CHILDREN
!!      init_fft_prof,initmpi_seq,kgindex,rho_tw_g,sphereboundary,timein
!!
!! SOURCE

subroutine init_FFT_test(Ftest,fft_setup,kpoint,ecut,boxcutmin,gmet,nsym,symrel,MPI_enreg_in,use_istwfk,store_results)


!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_32_util
 use interfaces_51_manage_mpi
 use interfaces_56_recipspace
!End of the abilint section

 implicit none

!Arguments -----------------------------------
!scalars
 integer,intent(in) :: nsym
 logical,intent(in) :: use_istwfk,store_results
 real(dp),intent(in) :: ecut,boxcutmin
 type(FFT_test_t),intent(inout) :: Ftest
 type(MPI_type),intent(inout) :: MPI_enreg_in
!arrays
 integer,intent(in) :: fft_setup(3),symrel(3,3,nsym)
 real(dp),intent(in) :: kpoint(3),gmet(3,3)

!Local variables-------------------------------
!scalars
 integer,parameter :: option_lob=2
 integer :: fftalg,fftcache,ndat

! *************************************************************************

 fftalg   = fft_setup(1)
 fftcache = fft_setup(2)
 ndat     = fft_setup(3)

 nullify(Ftest%kg_k)
 Ftest%paral_kgb = 0

 Ftest%kpoint       = kpoint
 Ftest%use_istwfk   = use_istwfk
 Ftest%store_results = store_results

 Ftest%istwf_k=1; if (use_istwfk) Ftest%istwf_k = set_istwfk(kpoint)
                                                             
 call get_kg(Ftest%kpoint,Ftest%istwf_k,ecut,gmet,Ftest%npw_k,Ftest%kg_k) 

 call copy_mpi_enreg(MPI_enreg_in,Ftest%MPI_enreg,opt_bandfft=1)

 Ftest%ngfft(7) = fftalg
 Ftest%ngfft(8) = fftcache

 ! Fill part of ngfft
 call getng(boxcutmin,ecut,gmet,Ftest%MPI_enreg%me_fft,Ftest%mgfft,Ftest%nfft,Ftest%ngfft,Ftest%MPI_enreg%nproc_fft,nsym,&
&  option_lob,Ftest%MPI_enreg%paral_fft,symrel)

 Ftest%ndat  = ndat

end subroutine init_FFT_test
!!***

!!****f* m_FFT_prof/destroy_FFT_test
!! NAME
!!  destroy_FFT_test
!!
!! FUNCTION
!!  Destruction method for the FFT_test_t structured datatype.
!!
!! INPUTS
!!
!! OUTPUT
!!
!! PARENTS
!!      fftprof
!!
!! CHILDREN
!!      init_fft_prof,initmpi_seq,kgindex,rho_tw_g,sphereboundary,timein
!!
!! SOURCE

subroutine destroy_FFT_test(Ftest)


 implicit none

!Arguments -----------------------------------
!scalars
 type(FFT_test_t),intent(inout) :: Ftest(:)

!Local variables-------------------------------
!scalars
 integer :: ii

! ********************************************************************* 

 do ii=1,SIZE(Ftest)
   if (associated(Ftest(ii)%kg_k)) deallocate(Ftest(ii)%kg_k)
 end do

end subroutine destroy_FFT_test

!!***

!----------------------------------------------------------------------

!!****f* m_FFT_prof/print_FFT_test
!! NAME
!!  print_FFT_test
!!
!! FUNCTION
!!  Printout of the FFT_test_t structured datatype.
!!
!! INPUTS
!!
!! OUTPUT
!!
!! PARENTS
!!
!! CHILDREN
!!      init_fft_prof,initmpi_seq,kgindex,rho_tw_g,sphereboundary,timein
!!
!! SOURCE

subroutine print_FFT_test(Ftest,header,unit,mode_paral,prtvol) 


!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
!End of the abilint section

 implicit none

!Arguments -----------------------------------
!scalars
 integer,optional,intent(in) :: unit,prtvol
 character(len=4),optional,intent(in) :: mode_paral 
 character(len=*),optional,intent(in) :: header
 type(FFT_test_t),intent(in) :: Ftest

!Local variables-------------------------------
!scalars
 integer :: my_unt,my_prtvol
 character(len=4) :: my_mode
 character(len=500) :: msg      
! ********************************************************************* 

 my_unt   =std_out; if (PRESENT(unit      )) my_unt   =unit
 my_prtvol=0      ; if (PRESENT(prtvol    )) my_prtvol=prtvol 
 my_mode  ='COLL' ; if (PRESENT(mode_paral)) my_mode  =mode_paral

 msg=' ==== Info on the FFT test object ==== '
 if (PRESENT(header)) msg=' ==== '//TRIM(ADJUSTL(header))//' ==== '
 call wrtout(my_unt,msg,my_mode)

 !TODO add additional info

 call print_ngfft(Ftest%ngfft,header="ngfft content",unit=std_out,mode_paral="COLL")

end subroutine print_FFT_test
!!***

!----------------------------------------------------------------------

!!****f* m_FFT_prof/name_of
!! NAME
!!  name_of
!!
!! FUNCTION
!!  Returns a string with info on the test.
!!
!! INPUTS
!!
!! OUTPUT
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE

function name_of(Ftest) 


!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
!End of the abilint section

 implicit none

!Arguments -----------------------------------
!scalars
 character(len=TNAME_LEN) :: name_of
 type(FFT_test_t),intent(in) :: Ftest

!Local variables-------------------------------
!scalars
 character(len=TNAME_LEN) :: library_name,cplex_mode,padding_mode

! ********************************************************************* 

 call fftalg_info(Ftest%ngfft(7),library_name,cplex_mode,padding_mode)
 name_of = TRIM(library_name)//"; "//TRIM(cplex_mode)//"; "//TRIM(padding_mode)

end function name_of
!!***

!----------------------------------------------------------------------

!!****f* m_FFT_prof/init_FFT_prof
!! NAME
!!  init_FFT_prof
!!
!! FUNCTION
!!  Creation method for the FFT_prof_t structured datatype.
!!
!! INPUTS
!!
!! OUTPUT
!!
!! PARENTS
!!      m_fft_prof
!!
!! CHILDREN
!!      init_fft_prof,initmpi_seq,kgindex,rho_tw_g,sphereboundary,timein
!!
!! SOURCE

subroutine init_FFT_prof(Ftprof,ncalls,cpu_time,wall_time,test_name)


 implicit none

!Arguments -----------------------------------
!scalars
 integer,intent(in) :: ncalls
 real(dp),intent(in) :: cpu_time,wall_time
 character(len=*),intent(in) :: test_name
 type(FFT_prof_t),intent(out) :: Ftprof
!arrays

!Local variables-------------------------------
!scalars

! *************************************************************************

 Ftprof%ncalls    =  ncalls
 Ftprof%cpu_time  = cpu_time
 Ftprof%wall_time = wall_time
 Ftprof%test_name = test_name

end subroutine init_FFT_prof
!!***

!----------------------------------------------------------------------

!!****f* m_FFT_prof/destroy_FFT_prof
!! NAME
!!  destroy_FFT_prof      
!!
!! FUNCTION
!!  Destruction method for the FFT_prof_t structured datatype.
!!
!! INPUTS
!!
!! OUTPUT
!!
!! PARENTS
!!      fftprof
!!
!! CHILDREN
!!      init_fft_prof,initmpi_seq,kgindex,rho_tw_g,sphereboundary,timein
!!
!! SOURCE

subroutine destroy_FFT_prof(Ftprof)


 implicit none

!Arguments -----------------------------------
!scalars
 type(FFT_prof_t),intent(inout) :: Ftprof(:)

!Local variables-------------------------------
!scalars
 integer :: ii
! ********************************************************************* 

 do ii=1,SIZE(Ftprof)
   if (associated(Ftprof(ii)%results)) deallocate(Ftprof(ii)%results)
 end do

end subroutine destroy_FFT_prof
!!***

!----------------------------------------------------------------------

!!****f* m_FFT_prof/print_FFT_prof
!! NAME
!!  print_FFT_prof
!!
!! FUNCTION
!!  Printout of the FFT_prof_t structured datatype.
!!
!! INPUTS
!!
!! OUTPUT
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE

subroutine print_FFT_profs(Fprof,header,unit,mode_paral,prtvol) 


!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
!End of the abilint section

 implicit none

!Arguments -----------------------------------
!scalars
 integer,optional,intent(in) :: unit,prtvol
 character(len=4),optional,intent(in) :: mode_paral 
 character(len=*),optional,intent(in) :: header
 type(FFT_prof_t),intent(in) :: Fprof(:)

!Local variables-------------------------------
!scalars
 integer :: my_unt,my_prtvol,ncalls
 integer :: field1_w,ii
 character(len=4) :: my_mode
 character(len=500) :: ofmt,hfmt 
 character(len=500) :: msg      
! ********************************************************************* 

 my_unt   =std_out; if (PRESENT(unit      )) my_unt   =unit
 my_prtvol=0      ; if (PRESENT(prtvol    )) my_prtvol=prtvol 
 my_mode  ='COLL' ; if (PRESENT(mode_paral)) my_mode  =mode_paral

 msg=' ==== Info on the FFT_prof_t objects ==== '
 if (PRESENT(header)) msg=' ==== '//TRIM(ADJUSTL(header))//' ==== '
 call wrtout(my_unt,msg,my_mode)

 field1_w=0 ! Width of the field used to print key names.
 do ii=1,SIZE(Fprof)
   field1_w = MAX(field1_w, LEN_TRIM(Fprof(ii)%test_name))
 end do

 if (field1_w==0) RETURN
 write(ofmt,*)"(a",field1_w,",2x,2(f6.3,2x),3x,i0)"

 write(hfmt,*)"(a",field1_w,",2x,a)"
 write(std_out,hfmt)" Library      ","CPU-time  WALL-time  ncalls"

 do ii=1,SIZE(Fprof)
   ncalls = Fprof(ii)%ncalls; if (ncalls==0) CYCLE
   write(std_out,ofmt)TRIM(Fprof(ii)%test_name),Fprof(ii)%cpu_time/ncalls,Fprof(ii)%wall_time/ncalls,ncalls
 end do
 write(std_out,*)

end subroutine print_FFT_profs
!!***

!----------------------------------------------------------------------

!!****f* m_FFT_prof/time_fourdp
!! NAME
!!  time_fourdp
!!
!! FUNCTION
!!  Profiling of the fourdp routine.
!!
!! INPUTS
!!
!! OUTPUT
!!
!! PARENTS
!!      fftprof
!!
!! CHILDREN
!!      init_fft_prof,initmpi_seq,kgindex,rho_tw_g,sphereboundary,timein
!!
!! SOURCE

subroutine time_fourdp(Ftest,cplex,Ftprof)


!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_18_timing
 use interfaces_53_ffts
!End of the abilint section

 implicit none

!Arguments -----------------------------------
!scalars
 integer,intent(in) :: cplex
 type(FFT_test_t),intent(inout) :: Ftest 
 type(FFT_prof_t),intent(out) :: Ftprof

!Local variables-------------------------------
!scalars
 integer :: isign,icall
 real(dp) :: cpu_time,wall_time,cpu0,wall0
 character(len=TNAME_LEN) :: test_name
!arrays
 real(dp),allocatable :: fofg(:,:),fofr(:)

! ********************************************************************* 

 test_name = name_of(Ftest)

 isign=+1
 allocate(fofg(2,Ftest%nfft),fofr(cplex*Ftest%nfft))
 fofg=zero; fofr=zero

 call timein(cpu0,wall0)

 do icall=1,NCALLS_FOR_TEST
   call fourdp(cplex,fofg,fofr,isign,Ftest%MPI_enreg,Ftest%nfft,Ftest%ngfft,Ftest%paral_kgb,0)
 end do

 call timein(cpu_time,wall_time)
 cpu_time  = cpu_time-cpu0
 wall_time = wall_time-wall0

 deallocate(fofg,fofr)

 call init_FFT_prof(Ftprof,NCALLS_FOR_TEST,cpu_time,wall_time,test_name)

end subroutine time_fourdp
!!***

!----------------------------------------------------------------------

!!****f* m_FFT_prof/time_fourdp_cplx
!! NAME
!!  time_fourdp_cplx
!!
!! FUNCTION
!!  Profiling of the fourdp_c2c_* routines.
!!
!! INPUTS
!!
!! OUTPUT
!!
!! PARENTS
!!      fftprof
!!
!! CHILDREN
!!      init_fft_prof,initmpi_seq,kgindex,rho_tw_g,sphereboundary,timein
!!
!! SOURCE

subroutine time_fourdp_cplx(Ftest,Ftprof,inplace)


!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_18_timing
 use interfaces_53_ffts
!End of the abilint section

 implicit none

!Arguments -----------------------------------
!scalars
 logical,intent(in) :: inplace
 type(FFT_test_t),intent(inout) :: Ftest
 type(FFT_prof_t),intent(out) :: Ftprof

!Local variables-------------------------------
!scalars
 integer :: isign,icall
 real(dp) :: cpu_time,wall_time,cpu0,wall0
 character(len=TNAME_LEN) :: test_name
!arrays
 complex(dpc),allocatable :: ffc(:),ggc(:)
! ********************************************************************* 

 test_name = name_of(Ftest)

 isign=+1

 allocate(ffc(Ftest%nfft),ggc(Ftest%nfft))
 ffc=czero; ggc=czero

 call timein(cpu0,wall0)

 if (inplace) then
   do icall=1,NCALLS_FOR_TEST
     call fourdp_c2c_op(ffc,ggc,isign,Ftest%mpi_enreg,Ftest%nfft,Ftest%ngfft,Ftest%paral_kgb,0)
   end do 
 else
   do icall=1,NCALLS_FOR_TEST
     call fourdp_c2c_ip(ffc,isign,Ftest%mpi_enreg,Ftest%nfft,Ftest%ngfft,Ftest%paral_kgb,0)
   end do 
 end if

 call timein(cpu_time,wall_time)
 cpu_time  = cpu_time-cpu0
 wall_time = wall_time-wall0

 deallocate(ffc,ggc)

 call init_FFT_prof(Ftprof,NCALLS_FOR_TEST,cpu_time,wall_time,test_name)

end subroutine time_fourdp_cplx
!!***

!----------------------------------------------------------------------

!!****f* m_FFT_prof/time_fourwf
!! NAME
!!  time_fourwf
!!
!! FUNCTION
!!  Profiling of the fourwf routine.
!!
!! INPUTS
!!
!! OUTPUT
!!
!! PARENTS
!!      fftprof
!!
!! CHILDREN
!!      init_fft_prof,initmpi_seq,kgindex,rho_tw_g,sphereboundary,timein
!!
!! SOURCE

subroutine time_fourwf(Ftest,cplex,option_fourwf,Ftprof)


!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_18_timing
 use interfaces_53_ffts
!End of the abilint section

 implicit none

!Arguments -----------------------------------
!scalars
 integer,intent(in) :: cplex,option_fourwf
 type(FFT_test_t),intent(inout) :: Ftest
 type(FFT_prof_t),intent(out) :: Ftprof

!Local variables-------------------------------
!scalars
 integer :: n4,n5,n6,npw_out,icall
 real(dp) :: cpu_time,wall_time,cpu0,wall0
 real(dp),parameter :: weight_i=one,weight_r=one
 character(len=TNAME_LEN) :: test_name
!arrays
 integer,allocatable :: gbound_in(:,:) !,gbound_out(:,:) 
 real(dp),allocatable :: denpot(:,:,:),fofg_in(:,:) !denpot(cplex*n4,n5,n6),fofg_in(2,npw_in*ndat)
 real(dp),allocatable :: fofr_4(:,:,:,:),fofg_out(:,:) !fofr_4(2,n4,n5,n6*ndat),fofg_out(2,npw_out*ndat)
! ********************************************************************* 

 test_name = name_of(Ftest)

 npw_out=Ftest%npw_k

 n4 = Ftest%ngfft(4)
 n5 = Ftest%ngfft(5)
 n6 = Ftest%ngfft(6)

 allocate(denpot(cplex*n4,n5,n6),fofg_in(2,Ftest%npw_k*Ftest%ndat))
 allocate(fofg_out(2,npw_out*Ftest%ndat),fofr_4(2,n4,n5,n6*Ftest%ndat))

 !denpot = zero; fofg_in = zero; fofg_out= zero; fofr_4=zero

 call timein(cpu0,wall0)

 allocate(gbound_in(2*Ftest%mgfft+8,2))
 !if (Ftest%ngfft(7) /= 310) then  ! FFTW3 does not need gbound_in
 call sphereboundary(gbound_in,Ftest%istwf_k,Ftest%kg_k,Ftest%mgfft,Ftest%npw_k)
 !end if

 do icall=1,NCALLS_FOR_TEST

   denpot = zero; fofg_in = zero; fofg_out= zero; fofr_4=zero

   call fourwf(cplex,denpot,fofg_in,fofg_out,fofr_4,gbound_in,gbound_in,Ftest%istwf_k,&
&    Ftest%kg_k,Ftest%kg_k,Ftest%mgfft,Ftest%mpi_enreg,Ftest%ndat,Ftest%ngfft,Ftest%npw_k,npw_out,n4,n5,n6,option_fourwf,&
&    Ftest%paral_kgb,0,weight_r,weight_i)

 end do

 call timein(cpu_time,wall_time)
 cpu_time  = cpu_time-cpu0
 wall_time = wall_time-wall0

 deallocate(denpot,fofg_in)
 deallocate(fofg_out,fofr_4)
 if (allocated(gbound_in)) deallocate(gbound_in)

 call init_FFT_prof(Ftprof,NCALLS_FOR_TEST,cpu_time,wall_time,test_name)

end subroutine time_fourwf
!!***
!----------------------------------------------------------------------

!!****f* m_FFT_prof/fftprof_ncalls_per_test
!! NAME
!!  fftprof_ncalls_per_test
!!
!! FUNCTION
!!  Helper function used to set the number of calls to  be used in each time_* routine.
!!
!! INPUTS
!!   nc=Number of calls to be used.
!!
!! SIDE EFFECTS 
!!  NCALLS_FOR_TEST = nc
!!
!! PARENTS
!!      fftprof
!!
!! CHILDREN
!!      init_fft_prof,initmpi_seq,kgindex,rho_tw_g,sphereboundary,timein
!!
!! SOURCE

subroutine fftprof_ncalls_per_test(nc)


 implicit none

!Arguments -----------------------------------
!scalars
 integer,intent(in) :: nc

! ********************************************************************* 

  NCALLS_FOR_TEST = nc

end subroutine fftprof_ncalls_per_test
!!***


!!****f* m_FFT_prof/time_rhotwg
!! NAME
!!  time_rhotwg
!!
!! FUNCTION
!!  Profiling of the rho_tw_g  routine.
!!
!! INPUTS
!!
!! OUTPUT
!!
!! PARENTS
!!      fftprof
!!
!! CHILDREN
!!      init_fft_prof,initmpi_seq,kgindex,rho_tw_g,sphereboundary,timein
!!
!! SOURCE

subroutine time_rhotwg(Ftest,map2sphere,use_padfft,osc_npw,osc_gvec,Ftprof)


!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_18_timing
 use interfaces_51_manage_mpi
 use interfaces_53_ffts
!End of the abilint section

 implicit none

!Arguments -----------------------------------
!scalars
 integer,intent(in) :: map2sphere,use_padfft,osc_npw
 type(FFT_test_t),intent(inout) :: Ftest
 type(FFT_prof_t),intent(out) :: Ftprof
!arrays 
 integer,intent(in) :: osc_gvec(3,osc_npw)

!Local variables-------------------------------
!scalars
 integer,parameter :: paral_kgb=0,nspinor=1,dim_rtwg=1,istwf_k=1
 integer :: icall,istat,ifft,itim1,itim2
 real(dp) :: cpu_time,wall_time,cpu0,wall0
 complex(dpc) :: ktabp1=cone,ktabp2=cone
 character(len=TNAME_LEN) :: test_name
 type(MPI_type) :: MPI_enreg_seq
!arrays
 integer,allocatable :: gbound(:,:) 
 integer,allocatable :: ktabr1(:),ktabr2(:)
 integer,allocatable :: igfftg0(:)
 logical,allocatable :: mask(:)
 complex(gwpc),allocatable :: rhotwg(:)
 complex(gwpc),allocatable :: wfn1(:),wfn2(:)
 real(dp) :: spinrot1(4)=(/one,zero,zero,one/),spinrot2(4)=(/one,zero,zero,one/)
! ********************************************************************* 

 test_name = name_of(Ftest)

 call initmpi_seq(MPI_enreg_seq)

 itim1=1; itim2=1
 allocate(ktabr1(Ftest%nfft),ktabr2(Ftest%nfft))

 do ifft=1,Ftest%nfft
   ktabr1(ifft)= ifft 
   ktabr2(ifft)= ifft 
 end do

 allocate(igfftg0(osc_npw*map2sphere),mask(osc_npw))
 !call cigfft(mG0,osc_npw,ngfft,gvec,igfft,ierr)
 call kgindex(igfftg0,osc_gvec,mask,MPI_enreg_seq,Ftest%ngfft,osc_npw)
 deallocate(mask)

 allocate(gbound(2*Ftest%mgfft+8,2*use_padfft))
 if (use_padfft==1) then  
   call sphereboundary(gbound,istwf_k,osc_gvec,Ftest%mgfft,osc_npw)
 end if

 allocate(rhotwg(osc_npw*dim_rtwg))
 allocate(wfn1(Ftest%nfft*nspinor),wfn2(Ftest%nfft*nspinor))
 wfn1 = czero; wfn2 = czero

 call timein(cpu0,wall0)

 do icall=1,NCALLS_FOR_TEST

   call rho_tw_g(paral_kgb,nspinor,osc_npw,Ftest%nfft,Ftest%ngfft,map2sphere,use_padfft,igfftg0,gbound,&
&    wfn1,itim1,ktabr1,ktabp1,spinrot1,&
&    wfn2,itim2,ktabr2,ktabp2,spinrot2,&
&    dim_rtwg,rhotwg,0,MPI_enreg_seq)

 end do

 call timein(cpu_time,wall_time)
 cpu_time  = cpu_time-cpu0
 wall_time = wall_time-wall0

 deallocate(ktabr1,ktabr2)
 deallocate(igfftg0, STAT=istat)
 deallocate(gbound, STAT=istat)
 deallocate(rhotwg)
 deallocate(wfn1,wfn2)

 call init_FFT_prof(Ftprof,NCALLS_FOR_TEST,cpu_time,wall_time,test_name)

end subroutine time_rhotwg

END MODULE m_FFT_prof
!!***
