!{\src2tex{textfont=tt}}
!!****f* ABINIT/fermisolverec
!! NAME
!! fermisolverec
!!
!! FUNCTION
!! This routine computes the fermi energy in order to have a given number of
!! valence electrons in the recursion method, using a Ridder s Method
!! 
!! COPYRIGHT
!! Copyright (C) 2008-2010 ABINIT group ( ).
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  debug_rec=debugging variable
!!  nb_rec=order of recursion
!!  nb_point=number of discretization point in one dimension (=n1=n2=n3)
!!  temperature=temperature (Hartree)
!!  trotter=trotter parameter
!!  nelect=number of valence electrons (dtset%nelect)
!!  acc=accuracy for the fermi energy
!!  max_it=maximum number of iteration for the Ridder's Method
!!  long_tranche=number of point computed by thi proc
!!  mpi_enreg=informations about MPI parallelization
!!  inf_ucvol=infinitesimal unit cell volume
!! 
!! OUTPUT
!! 
!! SIDE EFFECTS
!!  fermie=fermi energy
!!  rho=density, recomputed for the new fermi energy
!!  a, b2 : coefficient given by recursion recomputed for the new fermi energy
!! 
!! PARENTS
!!      vtorhorec
!!
!! CHILDREN
!!      density_rec,leave_new,timab,wrtout,xsum_mpi
!!
!! NOTES
!!  at this time :
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine fermisolverec(fermie,rho,a,b2,debug_rec,nb_rec, &
  &                      temperature,trotter,nelect, &
  &                      acc, max_it, &
  &                      long_tranche,mpi_enreg,&
  &                      inf_ucvol)

 use defs_basis
 use defs_abitypes
 use defs_rectypes
 use m_xmpi

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
 use interfaces_16_hideleave
 use interfaces_18_timing
 use interfaces_68_recursion, except_this_one => fermisolverec
!End of the abilint section

 implicit none

 !Arguments -------------------------------
 !scalars
 integer,intent(in) :: long_tranche,max_it,nb_rec,trotter
 logical,intent(in) :: debug_rec
 real(dp),intent(in) :: acc,inf_ucvol,nelect,temperature
 real(dp), intent(inout) :: fermie
 type(MPI_type),intent(inout) :: mpi_enreg
 !arrays 
 real(dp), intent(inout) :: a(0:nb_rec,long_tranche), b2(0:nb_rec,long_tranche)
 real(dp), intent(inout) :: rho(long_tranche)

 !Local variables-------------------------------
 !scalars  
 integer  ::  ierr,ii,ipointlocal,nn,dim_trott
 real(dp) :: beta,fermieh,fermiel,fermiem,fermienew,nelecth,nelectl,nelectm
 real(dp) :: nelectnew,res_nelecth,res_nelectl,res_nelectm,res_nelectnew
 real(dp) :: rtrotter,ss
 character(len=500) :: msg
 !arrays
 real(dp) :: tsec(2)
 real(dp) :: rhom(long_tranche), rhol(long_tranche), rhoh(long_tranche), rhonew(long_tranche)
 ! *************************************************************************

 call timab(609,1,tsec)

 beta = one/temperature
 rtrotter  = max(half,real(trotter,dp))
 dim_trott = max(0,2*trotter-1)


 write(msg,'(a)')' -- fermisolverec ---------------------------------'
 call wrtout(std_out,msg,'COLL')
 if(debug_rec) then 
   write (msg,'(a,d8.3)')' nelect= ',nelect 
   call wrtout(std_out,msg,'COLL') 
 end if
!initialisation of fermiel
 fermiel = fermie
 call timab(609,2,tsec)
 do ipointlocal = 1,long_tranche
   call density_rec(     &
&   a(:,ipointlocal),& 
&   b2(:,ipointlocal),& 
&   rhol(ipointlocal),&
&   nb_rec,fermiel,temperature,rtrotter,dim_trott, &
&   tol14,inf_ucvol)
 end do
 call timab(609,1,tsec)
 nelectl = sum(rhol)
 call xsum_mpi( nelectl,mpi_enreg%commcart,ierr)
 res_nelectl = inf_ucvol*nelectl - nelect


 if (res_nelectl /= zero) then 
!  initialisation of fermih
!  excess of electrons -> smaller fermi
   res_nelecth = zero
   ii = 1
   fermieh = fermie - ten*sign(one,res_nelectl)*temperature  
   do while(ii<6 .and. res_nelecth*res_nelectl>=0)
     fermieh = fermieh - ten*sign(one,res_nelectl)*temperature     
     call timab(609,2,tsec)
     do ipointlocal = 1,long_tranche
       call density_rec(     &
&       a(:,ipointlocal),  & 
&       b2(:,ipointlocal), & 
&       rhoh(ipointlocal), &
&       nb_rec,fermieh,temperature,rtrotter,dim_trott, &
&       tol14,inf_ucvol)
     end do
     call timab(609,1,tsec)
     nelecth = sum(rhoh)
     call xsum_mpi( nelecth,mpi_enreg%commcart ,ierr);
     res_nelecth = inf_ucvol*nelecth - nelect
     if(debug_rec) then
       write (msg,'(a,es11.4e2,a,es11.4e2)') ' Fermi energy interval',fermieh,' ',fermie
       call wrtout(std_out,msg,'COLL') 
     end if
     ii = ii +1
   end do


   if (res_nelecth*res_nelectl>0) then
     write (msg,'(4a)')' fermisolverec : ERROR- ',ch10,&
&     ' initial guess for fermi energy doesnt permit to  find solutions in solver',ch10
     call wrtout(std_out,msg,'COLL')
     call leave_new('COLL')
   end if


!  MAIN LOOP   ------------------------------------------------------
   main : do nn=1,max_it     
!    fermiem computation
     fermiem = 0.5d0*(fermiel+fermieh) 
!    nelectm = zero
     call timab(609,2,tsec)
     do ipointlocal = 1,long_tranche
       call density_rec(     &
&       a(:,ipointlocal),  & 
&       b2(:,ipointlocal), & 
&       rhom(ipointlocal), &
&       nb_rec,fermiem,temperature,rtrotter,dim_trott, &
&       tol14,inf_ucvol)       
     end do
     call timab(609,1,tsec)
     nelectm = sum(rhom)
     call xsum_mpi( nelectm,mpi_enreg%commcart,ierr)
     res_nelectm = inf_ucvol*nelectm - nelect


!    new guess
     ss = sqrt(res_nelectm**two-res_nelectl*res_nelecth)
     fermienew = fermiem + (fermiem-fermiel)*sign(one, res_nelectl-res_nelecth)*res_nelectm/ss

     call timab(609,2,tsec)
     do ipointlocal = 1,long_tranche
       call density_rec(     &
&       a(:,ipointlocal),  & 
&       b2(:,ipointlocal), & 
&       rhonew(ipointlocal), &
&       nb_rec,fermienew,temperature,rtrotter,dim_trott, &
&       tol14,inf_ucvol)       
     end do
     call timab(609,1,tsec)
     nelectnew = sum(rhonew)
     call xsum_mpi( nelectnew,mpi_enreg%commcart ,ierr); 
     res_nelectnew = inf_ucvol*nelectnew - nelect

!    fermiel et fermieh for new iteration
     if (sign(res_nelectm,res_nelectnew) /= res_nelectm) then
       fermiel = fermiem
       res_nelectl = res_nelectm
       fermieh = fermienew
       res_nelecth = res_nelectnew
     else if (sign(res_nelectl,res_nelectnew) /= res_nelectl) then
       fermieh = fermienew
       res_nelecth = res_nelectnew
     else if (sign(res_nelecth,res_nelectnew) /= res_nelecth) then
       fermiel = fermienew
       res_nelectl = res_nelectnew
     end if

!    are we within the tolerance ?
     if ((abs(res_nelectnew) < acc).or.(nn == max_it)) then
       fermie = fermienew
       rho = rhonew
       if(debug_rec) then
         write (msg,'(a,es11.4e2,a,i2)')' err, num_iter ', res_nelectnew, ' ',nn
         call wrtout(std_out,msg,'COLL')
         write(msg,'(a,50a)')' ',('-',ii=1,50); call wrtout(std_out,msg,'COLL')   
       end if
       exit main
     end if

   end do main

 end if

 call timab(609,2,tsec)

end subroutine fermisolverec
!!***
