!{\src2tex{textfont=tt}}
!!****f* ABINIT/excden
!! NAME
!!  exden
!!
!! FUNCTION
!!  This routines calculates the electron-hole excited state density.
!!
!! COPYRIGHT
!! Copyright (C) 1992-2009 EXC group (L.Reining, V.Olevano, F.Sottile, S.Albrecht, G.Onida)
!! Copyright (C) 2009-2010 ABINIT group (L.Reining, V.Olevano, F.Sottile, S.Albrecht, G.Onida, M.Giantomassi)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  filbseig=Name of the file containing the excitonic eigenvectors and eigenvalues.
!!
!! OUTPUT
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"

subroutine excden(p,filbseig,ntrans,trans,ngfft,nfftot,Kmesh,ktabr,Wfs)

 use defs_basis
 use defs_abitypes
 use m_bs_defs
 use m_errors

 use m_io_tools,        only : get_unit
 use m_bz_mesh,         only : bz_mesh_type
 use m_wfs,             only : wfs_descriptor, wfd_get_ur

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: ntrans
 integer,intent(in) :: nfftot
 character(len=*),intent(in) :: filbseig
 type(excparam),intent(in) :: p
 type(BZ_mesh_type),intent(in) :: Kmesh
 type(wfs_descriptor),intent(inout) :: Wfs
!arrays
 integer,intent(in) :: ngfft(18)
 integer,intent(in) :: ktabr(nfftot,p%nkbz)
 type(transition),intent(in) :: trans(ntrans)

!Local variables ------------------------------
!scalars
 integer :: nfft1,nfft2,nfft3,isppol
 integer :: it,itp,ik,ikp,ib,iv,ivp,ic,icp,ir,i1,i2,i3,iik,ikibz,istat
 integer :: mi,nmi,lowmi,eig_unt,den_unt,sden_unt
 real :: lowexevl,cost
 character(len=500) :: msg
!arrays
 real(dp) :: n0(nfftot),neh(nfftot),nexc(nfftot)
 real,allocatable :: exevl(:)
 complex(dpc) :: nh(nfftot),ne(nfftot)
 complex(gwpc),allocatable :: wfr(:,:,:), wfrk(:,:)
 complex,allocatable :: cexevl(:)
 complex,allocatable :: exevc(:)

!************************************************************************
      
 msg='calculating electron, hole, excited state density'
 call wrtout(std_out,msg,"COLL")

 ABI_CHECK(nfftot==PRODUCT(ngfft(1:3)),"Mismatch in FFT size")

 nfft1 = ngfft(1)
 nfft2 = ngfft(2)
 nfft3 = ngfft(3)

!allocate and load wavefunctions in real space
 allocate(wfr(nfftot*Wfs%nspinor,p%nbnds,p%nkibz),stat=istat)
 if(istat/=0) stop 'out of memory: excden, wfr'

 isppol=1 ! SPIN support is missing.

 do ik=1, p%nkibz
   !read(31,rec=ik) ((wfr(ir,ib,ik),ir=1,nfftot),ib=1,p%nbnds)
   do ib=1,p%nbnds
     call wfd_get_ur(Wfs,ib,ik,isppol,wfr(:,ib,ik))
   end do
 end do

 eig_unt = get_unit()
 open(eig_unt,file=filbseig,status='old',form='unformatted')

 read(eig_unt) nmi
 if(nmi/=ntrans) then 
   print *, 'not resonant calculation'
   close(eig_unt)
   RETURN 
 end if

 allocate(cexevl(nmi),exevl(nmi),exevc(nmi))
 read(eig_unt) cexevl(1:nmi)
 exevl(:) = cexevl(:)

!find the lowest non-negative eigenvalue
 lowexevl = 10000.0
 do mi = 1, nmi
   if(exevl(mi) < 0.0) cycle
   if(exevl(mi) < lowexevl) then
     lowexevl = exevl(mi)
     lowmi = mi
   end if
 end do
 if(lowexevl == 10000.0) stop 'meaningless eigenvalues'
 print *, 'lowest eigenvalue ', lowmi, lowexevl*27.2116

!skip other eigenvectors
 do mi = 1, lowmi-1
   read(eig_unt)
 end do
!read "lowest" eigenvector
 read(eig_unt) exevc(1:nmi)

 close(eig_unt)
 
 allocate(wfrk(nfftot,p%nbnds),stat=istat)
 if(istat/=0) stop 'out of memory: excden, wfrk'

!calculate ground state density
 n0(:) = 0.0
 do ik = 1, p%nkbz
   ikibz = Kmesh%tab(ik)
   iik = (3-Kmesh%tabi(ik))/2
    
   if(iik==1) then
     do ir = 1, nfftot
       wfrk(ir,1:p%homo) = wfr(ktabr(ir,ik),1:p%homo,ikibz)
     end do
   else
     do ir = 1, nfftot
       wfrk(ir,1:p%homo) = conjg(wfr(ktabr(ir,ik),1:p%homo,ikibz))
     end do
   end if

   do iv = 1, p%homo
     n0(:) = n0(:) + conjg(wfrk(:,ib)) * wfrk(:,ib)
   end do
 end do
 
!calculate electron and hole density
 nh(:) = 0.0
 ne(:) = 0.0
 do it = 1, nmi
   ik = trans(it)%k
   iv = trans(it)%v
   ic = trans(it)%c
   ikibz = Kmesh%tab(ik)
   iik = (3-Kmesh%tabi(ik))/2
    
   if(iik==1) then
     do ir = 1, nfftot
       wfrk(ir,:) = wfr(ktabr(ir,ik),:,ikibz)
     end do
   else
     do ir = 1, nfftot
       wfrk(ir,:) = conjg(wfr(ktabr(ir,ik),:,ikibz))
     end do
   end if
   do itp = 1, nmi
     ikp = trans(itp)%k
     if(ikp/=ik) cycle
     icp = trans(itp)%c
     ivp = trans(itp)%v
     if(icp==ic) then
       nh(:) = nh(:) - conjg(exevc(it)) * exevc(itp) * wfrk(:,iv) * conjg(wfrk(:,ivp))
     end if
     if(ivp==iv) then
       ne(:) = ne(:) + conjg(exevc(it)) * exevc(itp) * conjg(wfrk(:,ic)) * wfrk(:,icp)
     end if
   end do
 end do
 
!calculate excited state density minus ground state density
!n* - n0 = ne + nh
 neh(:) = ne(:) + nh(:)
!calculate excited state density
!n* = n0 + ne + nh
 nexc(:) = n0(:) + neh(:)
 
!here conversion to cartesian through a1, a2, a3

 den_unt = get_unit()

 open(unit=den_unt,file='out.den')
 cost = 0.0
 do i1 = 0, nfft1-1
   do i2 = 0, nfft2-1
     do i3 = 0, nfft3-1
       ir = 1 + i1 + i2 * nfft1 + i3 * nfft1 * nfft2
       write(den_unt,'(3i3,2x,5e11.4)')i1,i2,i3,n0(ir),nexc(ir),neh(ir),real(ne(ir)),real(nh(ir))
       cost = cost + n0(ir)
     end do
   end do
 end do

 print *, 'density normalization constant ', cost
 close(den_unt)

 sden_unt = get_unit()
 open(sden_unt,file='out.sden')
!we are looking for the plane between (100) (111)
!so it's the place where (111) [ (100) x v ] = 0 (mixed product)
!finally v2 - v3 = 0
 do i2 = 0, nfft2-1
   do i3 = 0, nfft3-1
     if(i2 == i3) then
       print *, i2, i3
       write(sden_unt,*) (neh(1+i1+i2*nfft1+i3*nfft1*nfft2),i1=0,nfft1-1)
     end if
   end do
 end do

 close(sden_unt)

end subroutine excden      
!!***
