!!****m* ABINIT/interfaces_69_bse
!! NAME
!! interfaces_69_bse
!!
!! FUNCTION
!! This module contains the interfaces of the routines
!! in the directory src/69_bse
!!
!! COPYRIGHT
!! Copyright (C) 2010 ABINIT group
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!!
!! NOTES
!! THIS FILE IS GENERATED AUTOMATICALLY BY abilint.
!! To do that: config/scripts/abilint . .
!! 
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

module interfaces_69_bse

 implicit none

interface
 subroutine calc_exch(BSp,Dtfil,usepaw,nspinor,nsppol,Cryst,Kmesh,Qmesh,ktabr,Gsph_Max,igfft,Vcp,&  
  &  Wfd,Er,trans,transtab,nfftot_osc,ngfft_osc,Psps,Pawtab,Pawang,Paw_pwff,rhxtwg_q0,&  
  &  is_resonant,fname,spaceComm,prtvol)
  use defs_basis
  use m_coulombian
  use m_bz_mesh
  use defs_gw
  use m_wfs
  use defs_abitypes
  use m_bs_defs
  use m_crystal
  use m_gsphere
  use defs_datatypes
  use m_paw_pwij
  implicit none
  integer,intent(in) :: nfftot_osc
  integer,intent(in) :: nspinor
  integer,intent(in) :: nsppol
  integer,intent(in) :: prtvol
  integer,intent(in) :: spaceComm
  integer,intent(in) :: usepaw
  type(excparam),intent(in) :: BSp
  type(crystal_structure),intent(in) :: Cryst
  type(datafiles_type),intent(in) :: Dtfil
  type(epsilonm1_results),intent(inout) :: Er
  type(gvectors_type),intent(in) :: Gsph_Max
  type(bz_mesh_type),intent(in) :: Kmesh
  type(pawang_type),intent(in) :: Pawang
  type(pseudopotential_type),intent(in) :: Psps
  type(bz_mesh_type),intent(in) :: Qmesh
  type(coulombian_type),intent(in) :: Vcp
  type(wfs_descriptor),intent(inout) :: Wfd
  character(len=fnlen),intent(in) :: fname
  logical,intent(in) :: is_resonant
  integer,intent(in) :: ngfft_osc(18)
  type(paw_pwff_type),intent(in) :: Paw_pwff(Psps%ntypat*usepaw)
  type(pawtab_type),intent(in) :: Pawtab(Psps%ntypat)
  integer,intent(in) :: igfft(Bsp%npwvec,2*BSp%mG0(1)+1,2*BSp%mG0(2)+1,2*BSp%mG0(3)+1)
  integer,intent(in) :: ktabr(nfftot_osc,BSp%nkbz)
  complex(gwpc),intent(in) :: rhxtwg_q0(BSp%npweps,BSp%nbnds,BSp%nbnds,BSp%nkibz)
  type(transition),intent(in) :: trans(BSp%nh)
  integer,intent(in) :: transtab(BSp%nkbz,BSp%nbndv,BSp%nbndc)
 end subroutine calc_exch
end interface

interface
 subroutine cexch_haydock(BSp,Dtfil,usepaw,nspinor,nsppol,Cryst,Kmesh,Qmesh,ktabr,Gsph_Max,igfft,Vcp,&  
  &  Wfd,Er,trans,transtab,nfftot_osc,ngfft_osc,MPI_enreg,Psps,Pawtab,Pawang,Paw_pwff)
  use m_coulombian
  use m_bz_mesh
  use defs_gw
  use m_wfs
  use defs_abitypes
  use m_bs_defs
  use m_crystal
  use m_gsphere
  use defs_datatypes
  use m_paw_pwij
  implicit none
  integer,intent(in) :: nfftot_osc
  integer,intent(in) :: nspinor
  integer,intent(in) :: nsppol
  integer,intent(in) :: usepaw
  type(excparam),intent(inout) :: BSp
  type(crystal_structure),intent(in) :: Cryst
  type(datafiles_type),intent(in) :: Dtfil
  type(epsilonm1_results),intent(inout) :: Er
  type(gvectors_type),intent(in) :: Gsph_Max
  type(bz_mesh_type),intent(in) :: Kmesh
  type(mpi_type),intent(inout) :: MPI_enreg
  type(pawang_type),intent(in) :: Pawang
  type(pseudopotential_type),intent(in) :: Psps
  type(bz_mesh_type),intent(in) :: Qmesh
  type(coulombian_type),intent(in) :: Vcp
  type(wfs_descriptor),intent(inout) :: Wfd
  integer,intent(in) :: ngfft_osc(18)
  type(paw_pwff_type),intent(in) :: Paw_pwff(Psps%ntypat*Psps%usepaw)
  type(pawtab_type),intent(in) :: Pawtab(Psps%ntypat)
  integer,intent(in) :: igfft(Bsp%npwvec,2*BSp%mG0(1)+1,2*BSp%mG0(2)+1,2*BSp%mG0(3)+1)
  integer,intent(in) :: ktabr(nfftot_osc,BSp%nkbz)
  type(transition),intent(in) :: trans(BSp%nh)
  integer,intent(in) :: transtab(BSp%nkbz,BSp%nbndv,BSp%nbndc)
 end subroutine cexch_haydock
end interface

interface
 subroutine exc_iterative_diago(ntrans,nbands,nstep,nline,nbdbuf,tolwfr,BS_files,prtvol,spaceComm)
  use defs_basis
  use m_bs_defs
  implicit none
  integer,intent(in) :: nbands
  integer,intent(in) :: nbdbuf
  integer,intent(in) :: nline
  integer,intent(in) :: nstep
  integer,intent(in) :: ntrans
  integer,intent(in) :: prtvol
  integer,intent(in) :: spaceComm
  type(excfiles),intent(in) :: BS_files
  real(dp),intent(in) :: tolwfr
 end subroutine exc_iterative_diago
end interface

interface
 subroutine excden(p,filbseig,ntrans,trans,ngfft,nfftot,Kmesh,ktabr,Wfs)
  use m_bz_mesh
  use m_bs_defs
  use m_wfs
  implicit none
  integer,intent(in) :: nfftot
  integer,intent(in) :: ntrans
  type(bz_mesh_type),intent(in) :: Kmesh
  type(wfs_descriptor),intent(inout) :: Wfs
  character(len=*),intent(in) :: filbseig
  type(excparam),intent(in) :: p
  integer,intent(in) :: ngfft(18)
  integer,intent(in) :: ktabr(nfftot,p%nkbz)
  type(transition),intent(in) :: trans(ntrans)
 end subroutine excden
end interface

interface
 subroutine exceig(nh,BS_files,filbseig,prtvol,spaceComm)
  use m_bs_defs
  implicit none
  integer,intent(in) :: nh
  integer,intent(in) :: prtvol
  integer,intent(in) :: spaceComm
  type(excfiles),intent(in) :: BS_files
  character(len=*),intent(in) :: filbseig
 end subroutine exceig
end interface

interface
 subroutine printexcevl(nh,filbseig,gw_gap,exc_gap)
  use defs_basis
  implicit none
  integer,intent(in) :: nh
  complex(dpc),intent(out) :: exc_gap
  character(len=*),intent(in) :: filbseig
  complex(dpc),intent(in) :: gw_gap
 end subroutine printexcevl
end interface

interface
 subroutine exccoupl(nh,filbseig,BS_files,prtvol,spaceComm)
  use m_bs_defs
  implicit none
  integer,intent(in) :: nh
  integer,intent(in) :: prtvol
  integer,intent(in) :: spaceComm
  type(excfiles),intent(in) :: BS_files
  character(len=*),intent(in) :: filbseig
 end subroutine exccoupl
end interface

interface
 subroutine excoverlap(nh,filbseig,BS_files,spaceComm)
  use m_bs_defs
  implicit none
  integer,intent(in) :: nh
  integer,intent(in) :: spaceComm
  type(excfiles),intent(in) :: BS_files
  character(len=*),intent(in) :: filbseig
 end subroutine excoverlap
end interface

interface
 subroutine cexch(BSp,Dtfil,BS_files,usepaw,nspinor,nsppol,Cryst,Kmesh,Qmesh,ktabr,Gsph_Max,igfft,Vcp,&  
  &  Wfd,Er,trans,transtab,nfftot_osc,ngfft_osc,MPI_enreg,Psps,Pawtab,Pawang,Paw_pwff,spaceComm,prtvol)
  use m_coulombian
  use m_bz_mesh
  use defs_gw
  use m_wfs
  use defs_abitypes
  use m_bs_defs
  use m_crystal
  use m_gsphere
  use defs_datatypes
  use m_paw_pwij
  implicit none
  integer,intent(in) :: nfftot_osc
  integer,intent(in) :: nspinor
  integer,intent(in) :: nsppol
  integer,intent(in) :: prtvol
  integer,intent(in) :: spaceComm
  integer,intent(in) :: usepaw
  type(excfiles),intent(in) :: BS_files
  type(excparam),intent(in) :: BSp
  type(crystal_structure),intent(in) :: Cryst
  type(datafiles_type),intent(in) :: Dtfil
  type(epsilonm1_results),intent(inout) :: Er
  type(gvectors_type),intent(in) :: Gsph_Max
  type(bz_mesh_type),intent(in) :: Kmesh
  type(mpi_type),intent(inout) :: MPI_enreg
  type(pawang_type),intent(in) :: Pawang
  type(pseudopotential_type),intent(in) :: Psps
  type(bz_mesh_type),intent(in) :: Qmesh
  type(coulombian_type),intent(in) :: Vcp
  type(wfs_descriptor),intent(inout) :: Wfd
  integer,intent(in) :: ngfft_osc(18)
  type(paw_pwff_type),intent(in) :: Paw_pwff(Psps%ntypat*usepaw)
  type(pawtab_type),intent(in) :: Pawtab(Psps%ntypat)
  integer,intent(in) :: igfft(Bsp%npwvec,2*BSp%mG0(1)+1,2*BSp%mG0(2)+1,2*BSp%mG0(3)+1)
  integer,intent(in) :: ktabr(nfftot_osc,BSp%nkbz)
  type(transition),intent(in) :: trans(BSp%nh)
  integer,intent(in) :: transtab(BSp%nkbz,BSp%nbndv,BSp%nbndc)
 end subroutine cexch
end interface

interface
 subroutine haydock_diago(BSp,nspinor,nsppol,usepaw,fnameabo_exc_mdf,&  
  &  Cryst,Kmesh,energy,inclvkb,Wfs,Psps,Pawtab,Hur,transtab,spaceComm)
  use m_wfs
  use m_bz_mesh
  use m_bs_defs
  use m_crystal
  use m_paw_commutator
  use defs_basis
  use defs_datatypes
  implicit none
  integer,intent(in) :: inclvkb
  integer,intent(in) :: nspinor
  integer,intent(in) :: nsppol
  integer,intent(in) :: spaceComm
  integer,intent(in) :: usepaw
  type(excparam),intent(in) :: BSp
  type(crystal_structure),intent(in) :: Cryst
  type(bz_mesh_type),intent(in) :: Kmesh
  type(pseudopotential_type),intent(in) :: Psps
  type(wfs_descriptor),intent(inout) :: Wfs
  character(len=fnlen),intent(in) :: fnameabo_exc_mdf
  type(hur_commutator),intent(in) :: Hur(Cryst%natom*usepaw)
  type(pawtab_type),intent(in) :: Pawtab(Cryst%ntypat*usepaw)
  real(dp),intent(in) :: energy(BSp%nbnds,BSp%nkibz,nsppol)
  integer,intent(in) :: transtab(BSp%nkbz,BSp%nbndv,BSp%nbndc)
 end subroutine haydock_diago
end interface

interface
 subroutine haydock(BSp,rhotilde,omega,FAQ,spectrum,spaceComm)
  use defs_basis
  use m_bs_defs
  implicit none
  integer,intent(in) :: spaceComm
  type(excparam),intent(in) :: BSp
  real(dp),intent(in) :: FAQ
  complex(dpc),intent(in) :: omega(BSp%nomega)
  complex(dpc),intent(in) :: rhotilde(BSp%nh)
  real(dp),intent(out) :: spectrum(BSp%nomega)
 end subroutine haydock
end interface

interface
 subroutine setup_bse(codvsn,acell,rprim,ngfftf,ngfft_osc,Dtset,Dtfil,BS_files,Psps,Pawtab,BSp,&  
  &  Cryst,Kmesh,Qmesh,KS_BSt,gwenergy,Hdr_kss,Gsph_Max,Vcp,Hdr_bse,Er,Trans,transtab,gw_gap,spaceComm)
  use m_coulombian
  use m_bz_mesh
  use defs_gw
  use defs_abitypes
  use m_bs_defs
  use m_gsphere
  use m_crystal
  use defs_basis
  use defs_datatypes
  implicit none
  integer,intent(in) :: spaceComm
  type(excfiles),intent(out) :: BS_files
  type(excparam),intent(inout) :: Bsp
  type(crystal_structure),intent(out) :: Cryst
  type(datafiles_type),intent(in) :: Dtfil
  type(dataset_type),intent(inout) :: Dtset
  type(epsilonm1_results),intent(out) :: Er
  type(gvectors_type),intent(out) :: Gsph_Max
  type(hdr_type),intent(out) :: Hdr_bse
  type(hdr_type),intent(out) :: Hdr_kss
  type(bandstructure_type),intent(out) :: KS_BSt
  type(bz_mesh_type),intent(out) :: Kmesh
  type(pseudopotential_type),intent(in) :: Psps
  type(bz_mesh_type),intent(out) :: Qmesh
  type(coulombian_type),intent(out) :: Vcp
  character(len=6),intent(in) :: codvsn
  complex(dpc),intent(out) :: gw_gap
  integer,intent(out) :: ngfft_osc(18)
  integer,intent(in) :: ngfftf(18)
  integer,pointer :: transtab(:,:,:)
  type(pawtab_type),intent(in) :: Pawtab(Psps%ntypat*Dtset%usepaw)
  type(transition),pointer :: Trans(:)
  real(dp),intent(in) :: acell(3)
  complex(dpc),pointer :: gwenergy(:,:,:)
  real(dp),intent(in) :: rprim(3,3)
 end subroutine setup_bse
end interface

interface
 subroutine build_spectra(BSp,nspinor,nsppol,usepaw,Dtfil,BS_files,Cryst,Kmesh,energy,gwenergy,&  
  &  Psps,Pawtab,ntrans,trans,inclvkb,Wfd,Hur,omegaplasma,spaceComm)
  use m_wfs
  use m_bz_mesh
  use defs_abitypes
  use m_bs_defs
  use m_crystal
  use m_paw_commutator
  use defs_basis
  use defs_datatypes
  implicit none
  integer,intent(in) :: inclvkb
  integer,intent(in) :: nspinor
  integer,intent(in) :: nsppol
  integer,intent(in) :: ntrans
  integer,intent(in) :: spaceComm
  integer,intent(in) :: usepaw
  type(excfiles),intent(in) :: BS_files
  type(excparam),intent(in) :: BSp
  type(crystal_structure),intent(in) :: Cryst
  type(datafiles_type),intent(in) :: Dtfil
  type(bz_mesh_type),intent(in) :: Kmesh
  type(pseudopotential_type),intent(in) :: Psps
  type(wfs_descriptor),intent(inout) :: Wfd
  real(dp),intent(in) :: omegaplasma
  type(hur_commutator),intent(in) :: Hur(Cryst%natom*usepaw)
  type(pawtab_type),intent(in) :: Pawtab(Cryst%ntypat*usepaw)
  real(dp),intent(in) :: energy(BSp%nbnds,BSp%nkibz,nsppol)
  complex(dpc),intent(in) :: gwenergy(BSp%nbnds,BSp%nkibz,nsppol)
  type(transition),intent(in) :: trans(ntrans)
 end subroutine build_spectra
end interface

interface
 subroutine cfcvk(nbnds,nkibz,nkbz,Kmesh,nspinor,nsppol,energy,BSp,&  
  &  inclvkb,usepaw,Cryst,Wfd,Psps,Pawtab,Hur,fcvk,spaceComm)
  use m_wfs
  use m_bz_mesh
  use m_bs_defs
  use m_crystal
  use m_paw_commutator
  use defs_basis
  use defs_datatypes
  implicit none
  integer,intent(in) :: inclvkb
  integer,intent(in) :: nbnds
  integer,intent(in) :: nkbz
  integer,intent(in) :: nkibz
  integer,intent(in) :: nspinor
  integer,intent(in) :: nsppol
  integer,intent(in) :: spaceComm
  integer,intent(in) :: usepaw
  type(excparam),intent(in) :: BSp
  type(crystal_structure),intent(in) :: Cryst
  type(bz_mesh_type),intent(in) :: Kmesh
  type(pseudopotential_type),intent(in) :: Psps
  type(wfs_descriptor),intent(inout) :: Wfd
  type(hur_commutator),intent(in) :: Hur(Cryst%natom*usepaw)
  type(pawtab_type),intent(in) :: Pawtab(Cryst%ntypat*usepaw)
  real(dp),intent(in) :: energy(nbnds,nkibz,nsppol)
  complex(dpc),intent(out) :: fcvk(nbnds,nbnds,nkbz,nsppol,BSp%nq)
 end subroutine cfcvk
end interface

interface
 subroutine cepsrpagw(nbnds,lomo,nbndo,Kmesh,nsppol,energy,gwenergy,fcvk,ucvol,nomega,emin,dE,eta,epsrpanlf,epsgwnlf)
  use m_bz_mesh
  use defs_basis
  implicit none
  integer,intent(in) :: lomo
  integer,intent(in) :: nbndo
  integer,intent(in) :: nbnds
  integer,intent(in) :: nomega
  integer,intent(in) :: nsppol
  type(bz_mesh_type),intent(in) :: Kmesh
  real(dp),intent(in) :: dE
  real(dp),intent(in) :: emin
  real(dp),intent(in) :: eta
  real(dp),intent(in) :: ucvol
  real(dp),intent(in) :: energy(nbnds,Kmesh%nibz,nsppol)
  complex(dpc),intent(out) :: epsgwnlf(nomega)
  complex(dpc),intent(out) :: epsrpanlf(nomega)
  complex(dpc),intent(in) :: fcvk(nbnds,nbnds,Kmesh%nbz,nsppol)
  complex(dpc),intent(in) :: gwenergy(nbnds,Kmesh%nibz,nsppol)
 end subroutine cepsrpagw
end interface

interface
 subroutine cepsexc(filbseig,nsppol,nkbz,nbnds,ntrans,trans,fcvk,ucvol,nomega,emin,dE,eta,epsexc)
  use defs_basis
  use m_bs_defs
  implicit none
  integer,intent(in) :: nbnds
  integer,intent(in) :: nkbz
  integer,intent(in) :: nomega
  integer,intent(in) :: nsppol
  integer,intent(in) :: ntrans
  real(dp),intent(in) :: dE
  real(dp),intent(in) :: emin
  real(dp),intent(in) :: eta
  character(len=*),intent(in) :: filbseig
  real(dp),intent(in) :: ucvol
  complex(dpc),intent(out) :: epsexc(nomega)
  complex(dpc),intent(in) :: fcvk(nbnds,nbnds,nkbz,nsppol)
  type(transition),intent(in) :: trans(ntrans)
 end subroutine cepsexc
end interface

interface
 subroutine cepsexccoupl(filbseig,BS_files,nsppol,nkbz,nbnds,ntrans,nh2,trans,fcvk,ucvol,nomega,emin,dE,eta,epsexc)
  use defs_basis
  use m_bs_defs
  implicit none
  integer,intent(in) :: nbnds
  integer,intent(in) :: nh2
  integer,intent(in) :: nkbz
  integer,intent(in) :: nomega
  integer,intent(in) :: nsppol
  integer,intent(in) :: ntrans
  type(excfiles),intent(in) :: BS_files
  real(dp),intent(in) :: dE
  real(dp),intent(in) :: emin
  real(dp),intent(in) :: eta
  character(len=*),intent(in) :: filbseig
  real(dp),intent(in) :: ucvol
  complex(dpc),intent(out) :: epsexc(nomega)
  complex(dpc),intent(in) :: fcvk(nbnds,nbnds,nkbz,nsppol)
  type(transition),intent(in) :: trans(ntrans)
 end subroutine cepsexccoupl
end interface

interface
 subroutine check_kramerskronig(n,o,eps)
  use defs_basis
  implicit none
  integer,intent(in) :: n
  complex(dpc),intent(in) :: eps(n)
  real(dp),intent(in) :: o(n)
 end subroutine check_kramerskronig
end interface

interface
 subroutine check_fsumrule(n,o,e2,omegaplasma)
  use defs_basis
  implicit none
  integer,intent(in) :: n
  real(dp),intent(in) :: omegaplasma
  real(dp),intent(in) :: e2(n)
  real(dp),intent(in) :: o(n)
 end subroutine check_fsumrule
end interface

interface
 subroutine wreps(BSp,Dtfil,epsexc,epsrpanlf,epsgwnlf)
  use defs_basis
  use defs_abitypes
  use m_bs_defs
  implicit none
  type(excparam),intent(in) :: BSp
  type(datafiles_type),intent(in) :: Dtfil
  complex(dpc),intent(inout) :: epsexc(BSp%nomega,BSp%nq+2)
  complex(dpc),intent(inout) :: epsgwnlf(BSp%nomega,BSp%nq+2)
  complex(dpc),intent(inout) :: epsrpanlf(BSp%nomega,BSp%nq+2)
 end subroutine wreps
end interface

interface
 subroutine wrtitle(unt,BSp)
  use m_bs_defs
  implicit none
  integer,intent(in) :: unt
  type(excparam),intent(in) :: BSp
 end subroutine wrtitle
end interface

interface
 subroutine wrq(unt,BSp,iq)
  use m_bs_defs
  implicit none
  integer,intent(in) :: iq
  integer,intent(in) :: unt
  type(excparam),intent(in) :: BSp
 end subroutine wrq
end interface

end module interfaces_69_bse
!!***
