!{\src2tex{textfont=tt}}
!!****f* ABINIT/wreps
!! NAME
!!  wreps
!!
!! FUNCTION
!!  This routine drives the writing of the files produced by the Bethe-Salpeter code. 
!!
!! COPYRIGHT
!! Copyright (C) 2009-2010 ABINIT group (L.Reining, V.Olevano, F.Sottile, S.Albrecht, G.Onida, M.Giantomassi)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!! Dtfil<datafiles_type)>=variables related to file names and unit numbers.
!! BSp<type(excparam)>=Bethe-Salpeter Parameters.
!!
!! OUTPUT
!!  Only writing.
!!
!! SIDE EFFECTS
!!  epsexc(BSp%nomega,BSp%nq+2) = Macroscopic dielectric function with excitonic effects
!!  epsrpanlf(BSp%nomega,BSp%nq+2) = RPA macroscopic dielectric function without local field effects.
!!  epsgwnlf(BSp%nomega,BSp%nq+2) = RPA+GW macroscopic dielectric function without local field effects.
!!  FIXME get rid of side effects!!!
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"

subroutine wreps(BSp,Dtfil,epsexc,epsrpanlf,epsgwnlf)

 use defs_basis
 use m_bs_defs
 use m_errors

 use defs_abitypes,  only : datafiles_type
 use m_io_tools,     only : get_unit

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_69_bse, except_this_one => wreps
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 type(Datafiles_type),intent(in) :: Dtfil
 type(excparam),intent(in) :: BSp
!arrays
 complex(dpc),intent(inout) :: epsexc(BSp%nomega,BSp%nq+2)
 complex(dpc),intent(inout) :: epsrpanlf(BSp%nomega,BSp%nq+2), epsgwnlf(BSp%nomega,BSp%nq+2)

!Local variables ------------------------------
!scalars
 integer :: io,iq,exc_mdf_unt,rpa_mdf_unt,gw_mdf_unt
 real(dp) :: omegaev,domega,domev
!arrays
 character(len=500) :: legend

!************************************************************************

 domega = REAL(BSp%omega(BSp%nomega) - BSp%omega(1)) / (BSp%nomega - 1)
 domev = domega * Ha_eV

!  calculating reciprocal lattice and cartesian averages
 do io=1,BSp%nomega
   epsexc(io,7) = (epsexc(io,1)+epsexc(io,2)+epsexc(io,3)) / 3.0
   epsexc(io,8) = (epsexc(io,4)+epsexc(io,5)+epsexc(io,6)) / 3.0

   epsrpanlf(io,7) = (epsrpanlf(io,1)+epsrpanlf(io,2)+epsrpanlf(io,3)) / 3.0
   epsrpanlf(io,8) = (epsrpanlf(io,4)+epsrpanlf(io,5)+epsrpanlf(io,6)) / 3.0

   epsgwnlf(io,7) =  (epsgwnlf(io,1)+epsgwnlf(io,2)+epsgwnlf(io,3)) / 3.0
   epsgwnlf(io,8) =  (epsgwnlf(io,4)+epsgwnlf(io,5)+epsgwnlf(io,6)) / 3.0
 end do
      
 exc_mdf_unt  = get_unit() 

 open(unit=exc_mdf_unt,file=dtfil%fnameabo_exc_mdf,form='formatted')
 write(exc_mdf_unt,'("# macroscopic dielectric function")')
 write(exc_mdf_unt,'("# ",a3,"     " ,a3)') BSp%type, BSp%lftype
 write(exc_mdf_unt,'("# ",a8)') BSp%htype
 write(exc_mdf_unt,'("# ",a5)') BSp%wtype
 call wrtitle(exc_mdf_unt,BSp)

 rpa_mdf_unt = get_unit()

 open(unit=rpa_mdf_unt,file=dtfil%fnameabo_rpa_nlf_mdf,form='formatted')
 write(rpa_mdf_unt,'("# macroscopic dielectric function")')
 write(rpa_mdf_unt,'("# rpa without local fields")')
 call wrtitle(rpa_mdf_unt,BSp)

 gw_mdf_unt = get_unit()

 open(unit=gw_mdf_unt,file=dtfil%fnameabo_gw_nlf_mdf,form='formatted')
 write(gw_mdf_unt,'("# macroscopic dielectric function")')
 write(gw_mdf_unt,'("# gw without local fields")')
 call wrtitle(gw_mdf_unt,BSp)

 if (BSp%nq==1) then

   legend = "# omega       eps_1       eps_2"
   iq=1
   call wrq(exc_mdf_unt,BSp,1)
   write(exc_mdf_unt,'(a)')TRIM(legend)
   do io=1,BSp%nomega
     omegaev = real(BSp%omega(io))*Ha_eV
     write(exc_mdf_unt,'(f7.3,2e12.4)') omegaev, epsexc(io,iq)
   end do

   call wrq(rpa_mdf_unt,BSp,1)
   write(rpa_mdf_unt,'(a)')TRIM(legend)
   do io=1,BSp%nomega
     omegaev = real(BSp%omega(io))*Ha_eV
     write(rpa_mdf_unt,'(f7.3,2e12.4)') omegaev, epsrpanlf(io,iq)
   end do

   call wrq(gw_mdf_unt,BSp,1)
   write(gw_mdf_unt,'(a)')TRIM(legend)
   do io=1,BSp%nomega
     omegaev = real(BSp%omega(io))*Ha_eV
     write(gw_mdf_unt,'(f7.3,2e12.4)') omegaev, epsgwnlf(io,iq)
   end do

 else

   write(exc_mdf_unt,'("# 8 polarization:")')
   call wrq(exc_mdf_unt,BSp,7)
   call wrq(exc_mdf_unt,BSp,8)
   do iq=1,BSp%nq
     call wrq(exc_mdf_unt,BSp,iq)
   end do

   legend = "# omega       eps_1       eps_2  for r c 1 2 3 x y z"
   write(exc_mdf_unt,'(a)')TRIM(legend)

   do io=1,BSp%nomega
     omegaev = real(BSp%omega(io))*Ha_eV
     write(exc_mdf_unt,'(f7.3,16e12.4)') omegaev, epsexc(io,7),epsexc(io,8),&
&            epsexc(io,1), epsexc(io,2), epsexc(io,3),&
&            epsexc(io,4), epsexc(io,5), epsexc(io,6)
   end do

   write(rpa_mdf_unt,'("# 8 polarization:")')
   call wrq(rpa_mdf_unt,BSp,7)
   call wrq(rpa_mdf_unt,BSp,8)
   do iq=1,BSp%nq
     call wrq(rpa_mdf_unt,BSp,iq)
   end do
   write(rpa_mdf_unt,'(a)')TRIM(legend)
   do io=1,BSp%nomega
     omegaev = real(BSp%omega(io))*Ha_eV
     write(rpa_mdf_unt,'(f7.3,16e12.4)') omegaev,&
&            epsrpanlf(io,7), epsrpanlf(io,8),&
&            epsrpanlf(io,1), epsrpanlf(io,2), epsrpanlf(io,3),&
&            epsrpanlf(io,4), epsrpanlf(io,5), epsrpanlf(io,6)
   end do

   write(gw_mdf_unt,'("# 8 polarization:")')
   call wrq(gw_mdf_unt,BSp,7)
   call wrq(gw_mdf_unt,BSp,8)
   do iq=1,BSp%nq
     call wrq(gw_mdf_unt,BSp,iq)
   end do
   write(gw_mdf_unt,'(a)')TRIM(legend)
   do io=1,BSp%nomega
     omegaev = real(BSp%omega(io))*Ha_eV
     write(gw_mdf_unt,'(f7.3,16e12.4)') omegaev,& 
&            epsgwnlf(io,7), epsgwnlf(io,8),&
&            epsgwnlf(io,1), epsgwnlf(io,2), epsgwnlf(io,3),&
&            epsgwnlf(io,4), epsgwnlf(io,5), epsgwnlf(io,6)
   end do
 end if
      
 close(exc_mdf_unt)
 close(rpa_mdf_unt)
 close(gw_mdf_unt )

end subroutine wreps
!!***

!----------------------------------------------------------------------

!!****f* ABINIT/wrtitle
!! NAME
!!  wrtitle
!!
!! FUNCTION
!!  Write title for the files of the bethe-salpeter calculation
!!
!! COPYRIGHT
!! Copyright (C) 2009-2010 ABINIT group (L.Reining, V.Olevano, F.Sottile, S.Albrecht, G.Onida, M.Giantomassi)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  unt=Unit number
!!  BSp<type(excparam)>=Bethe-Salpeter Parameters.
!!
!! OUTPUT
!!  Only writing.
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"

subroutine wrtitle(unt,BSp)

 use defs_basis
 use m_bs_defs
 use m_errors

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: unt
 type(excparam),intent(in) :: BSp

!************************************************************************

 write(unt,'(a,i4)')"# npweps = ",BSp%npweps
 write(unt,'(a,i4)')"# npwwfn = ",BSp%npwwfn
 write(unt,'(a,i4)')"# nbands = ",BSp%nbnds
 write(unt,'(a,i4)')"# lomo   = ",BSp%lomo
 write(unt,'(a,i4)')"# nkibz  = ",BSp%nkibz
 write(unt,'(a,i4)')"# nkbz   = ",BSp%nkbz
 if (BSp%soshift) then
   write(unt,'(a,f6.4,a)')'# scissor operator energy = ',BSp%soenergy*Ha_eV,' [eV]'
 end if
 write(unt,'(a,f6.4,a)')'# lorentzian broadening = ',BSp%broad*Ha_eV,' [eV]'

end subroutine wrtitle
!!***

!----------------------------------------------------------------------

!!****f* ABINIT/wrq
!! NAME
!!  wrq
!!
!! FUNCTION
!!  Write info on the q on the output files of the Bethe-Salpeter calculation. 
!!
!! COPYRIGHT
!! Copyright (C) 2009-2010 ABINIT group (L.Reining, V.Olevano, F.Sottile, S.Albrecht, G.Onida, M.Giantomassi)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  unt=Unit number for output.
!!  iq=Sequential index of the q-point.
!!  BSp<type(excparam)>=Bethe-Salpeter Parameters.
!!
!! OUTPUT
!!  Only writing.
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"

subroutine wrq(unt,BSp,iq)

 use defs_basis
 use m_bs_defs

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: unt,iq
 type(excparam),intent(in) :: BSp

!************************************************************************

 if (iq <= 6) then
   write(unt,'(a,3(f9.6,","),a)')'# q = ',BSp%q(:,iq),  ' [r.l.u.]'
   write(unt,'(a,3(f9.6,","),a)')'# q = ',BSp%qcc(:,iq),' [c.c.]  '
 else if (iq == 7) then
   write(unt,'(a)')'# q -> 0; average over the three reciprocal lattice directions'
 else if (iq == 8) then
   write(unt,'(a)')'# q -> 0; average over the three cartesian directions'
 end if

end subroutine wrq
!!***

!----------------------------------------------------------------------
