!{\src2tex{textfont=tt}}
!!****f* ABINIT/asria9
!! NAME
!! asria9
!!
!! FUNCTION
!! Imposition of the Acoustic sum rule on the InterAtomic Forces
!!
!! COPYRIGHT
!! Copyright (C) 1999-2010 ABINIT group (XG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!! asr=(0 => no ASR, 1 or 2=> the diagonal element is modified to give the ASR,
!!      5 => impose hermitian solution using lapack call)
!! calc_or_impose= 1 => the correction to enforce asr is computed from
!!                      d2cart, but NOT applied;
!!                 2 => one uses the previously determined correction)
!! mpert =maximum number of ipert
!! natom=number of atom
!!
!! OUTPUT
!!  (see side effects)
!!
!! SIDE EFFECTS
!! Input/Output:
!! d2cart=matrix of second derivatives of total energy, in cartesian coordinates
!! d2asr=matrix used to store the correction needed to fulfill
!! the acoustic sum rule.
!!
!! PARENTS
!!      anaddb,gath3,mkphbs
!!
!! CHILDREN
!!      leave_new,wrtout,zgelss
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine asria9(asr,calc_or_impose,d2asr,d2cart,mpert,natom)

 use defs_basis

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
 use interfaces_16_hideleave
!End of the abilint section

 implicit none

!Arguments -------------------------------
!scalars
 integer,intent(in) :: asr,calc_or_impose,mpert,natom
!arrays
 real(dp),intent(inout) :: d2asr(2,3,natom,3,natom),d2cart(2,3,mpert,3,mpert)

!Local variables-------------------------------
!scalars
 integer :: idir1,idir2,ii,ipert1,ipert2
 character(len=500) :: message

 integer, allocatable :: packingindex(:,:,:,:)
 real(dp), allocatable :: constraints(:,:,:)
 real(dp), allocatable :: d2cart_packed(:,:)
 real(dp), allocatable :: singvals(:)
 real(dp), allocatable :: constr_rhs(:,:)
 real(dp), allocatable :: work(:,:),rwork(:)
 integer :: constrank, imatelem, iconst, nconst, nd2_packed, info

! *********************************************************************

 if(calc_or_impose/=1 .and. calc_or_impose/=2)then
   write(message, '(a,a,a,a,a,i4,a,a,a)' )&
&   ' asria9 : ERROR -',ch10,&
&   '  calc_or_impose should be equal to 1 or 2 while',ch10,&
&   '  it is equal to ',calc_or_impose,'.',ch10,&
&   '  Action : the call to this subroutine should be changed'
   call wrtout(std_out,message,'COLL')
   call leave_new('COLL')
 end if

 if(calc_or_impose==1) d2asr = zero

 if (asr==0) return

 write(message, '(a)' )&
& ' asria9 : imposition of the ASR for the interatomic forces.'
 call wrtout(std_out,message,'COLL')
 do ipert1=1,natom
   do idir1=1,3
     do idir2=1,3

!      Compute d2asr
       if(calc_or_impose==1)then
         do ipert2=1,natom
           d2asr(:,idir1,ipert1,idir2,ipert1)=&
&           d2asr(:,idir1,ipert1,idir2,ipert1)+&
&           d2cart(:,idir1,ipert1,idir2,ipert2)
         end do
       end if

!      Apply d2asr
       if(calc_or_impose==2)then
         do ipert2=1,natom
           d2cart(:,idir1,ipert1,idir2,ipert2)=&
&           d2cart(:,idir1,ipert1,idir2,ipert2)-&
&           d2asr(:,idir1,ipert1,idir2,ipert2)
         end do
       end if
     end do
   end do
 end do

!holistic method: overwrite d2asr with hermitian solution
 if (calc_or_impose==1 .and. asr == 5) then
   nconst = 9*natom
   nd2_packed = 3*natom*(3*natom+1)/2
   allocate(constraints(2,nconst, nd2_packed))
   allocate(d2cart_packed(2,nd2_packed))
   allocate(constr_rhs(2,nd2_packed))
   allocate(singvals(nconst))
   allocate(work(2,3*nd2_packed))
   allocate(rwork(5*nd2_packed))
   allocate(packingindex(3,natom,3,natom))
   ii=1
   packingindex=-1
   do ipert2=1,natom
     do idir2=1,3
       do ipert1=1,ipert2-1
         do idir1=1,3
           packingindex(idir1,ipert1,idir2,ipert2) = ii
           ii = ii+1
         end do
       end do
       do idir1=1,idir2
         packingindex(idir1,ipert2,idir2,ipert2) = ii
         ii = ii+1
       end do
     end do
   end do
!  setup constraint matrix
   constraints = zero
   do ipert1=1,natom
     do idir1=1,3
       do idir2=1,3
         iconst = idir2+3*(idir1-1 + 3*(ipert1-1))
!        set all atom forces, this component
         do ipert2=1,natom
           imatelem = packingindex(idir1,ipert1,idir2,ipert2)
           if (imatelem == -1) then
             imatelem = packingindex(idir2,ipert2,idir1,ipert1)
           end if
           constraints(1,iconst,imatelem) = one
         end do
       end do
     end do
   end do

   d2cart_packed = -999.0d0
   do ipert2=1,natom
     do idir2=1,3
       do ipert1=1,natom
         do idir1=1,3
           imatelem = packingindex(idir1,ipert1,idir2,ipert2)
           if (imatelem == -1) cycle
           d2cart_packed(:,imatelem) = d2cart(:,idir1,ipert1,idir2,ipert2)
         end do
       end do
     end do
   end do
   constr_rhs = zero
   constr_rhs(1,1:nconst) = matmul(constraints(1,:,:),d2cart_packed(1,:))
   constr_rhs(2,1:nconst) = matmul(constraints(1,:,:),d2cart_packed(2,:))

!  lwork = 3*nd2_packed
   call zgelss (nconst,nd2_packed,1,constraints,nconst,constr_rhs,nd2_packed,&
&   singvals,-one,constrank,work,3*nd2_packed,rwork,info)
   write (*,*) 'zgelss info ', info

!  unpack 
   do ipert2=1,natom
     do idir2=1,3
       do ipert1=1,natom
         do idir1=1,3
           imatelem = packingindex(idir1,ipert1,idir2,ipert2)
           if (imatelem == -1) then
             imatelem = packingindex(idir2,ipert2,idir1,ipert1)
!            NOTE: should complex conjugate the correction below.
           end if
           d2asr(:,idir1,ipert1,idir2,ipert2) = constr_rhs(:,imatelem)
         end do
       end do
     end do
   end do

   deallocate(constraints)
   deallocate(d2cart_packed)
   deallocate(singvals)
   deallocate(constr_rhs)
   deallocate(work)
   deallocate(rwork)
   deallocate(packingindex)

 end if

end subroutine asria9
!!***
