!{\src2tex{textfont=tt}}
!!****f* ABINIT/eig2tot
!! NAME
!! eig2tot
!!
!! FUNCTION
!! This routine calculates the second-order eigenvalues.
!! The output eig2nkq is this quantity for the input k points.
!!
!! COPYRIGHT
!! Copyright (C) 1999-2010 ABINIT group (PB, XG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors .
!!
!! INPUTS
!!  bdeigrf = number of bands for which to calculate the second-order eigenvalues
!!  clflg(3,mpert)= Array on calculated perturbations for eig2rf
!!  cg1_pert(2,mpw1*nspinor*mband*mk1mem*nsppol,3,mpert)= first-order wf in G space for each perturbation 
!!    The wavefunction is orthogonal to the active space.
!!  gh1_pert(2,mpw1*nspinor,mband,nkpt_rbz,3,mpert)= matrix containing the vector:  <G|H(1)|n,k>, for each perturbation
!!  ghc_pert(2,mpw1*nspinor,mband,nkpt_rbz,3,mpert)= matrix containing the vector:  <G|H(0)|psi(1)>, for each perturbation
!!    The wavefunction is orthogonal to the active space. 
!!  eigen0(nkpt_rbz*mband*nsppol)= 0-order eigenvalues at all K-points: <k,n'|H(0)|k,n'> (hartree)
!!  eigenq(nkpt_rbz*mband*nsppol)= 0-order eigenvalues at all shifted K-points: <k+Q,n'|H(0)|k+Q,n'> (hartree)
!!  eigen1(nkpt_rbz*2*nsppol*mband**2,3,mpert)= matrix of first-order: <k+Q,n'|H(1)|k,n> (hartree) (calculated in cgwf3)
!!  ieig2rf= integer for calculation type
!!  indsym(4,nsym,natom)= indirect indexing array for atom labels (not used yet, but will be used with symmetries)
!!  istwfk_pert(nkpt_rbz,3,mpert)= integer for choice of storage of wavefunction at each k point for each perturbation
!!  mband= maximum number of bands
!!  mk1mem= maximum number of k points which can fit in memory (RF data)  ; 0 if use disk
!!  mpert= maximum number of perturbations
!!  natom= number of atoms in the unit cell
!!  npert= number of phonon perturbations, without taking into account directions: natom 
!!  nsym= number of symmetries (not used yet)
!!  mpi_enreg= informations about MPI parallelization
!!  mpw1= maximum number of planewaves used to represent first-order wavefunctions
!!  nkpt_rbz= number of k-points for each perturbation
!!  npwar1(nkpt_rbz,mpert)= number of planewaves at k-point for first-order
!!  nspinor= number of spinorial components of the wavefunctions
!!  nsppol= 1 for unpolarized, 2 for spin-polarized
!!  smdelta= integer controling the calculation of electron lifetimes
!!  symq(4,2,nsym)= 1 if symmetry preserves present qpoint. From symq3 (not used yet)
!!  symrec(3,3,nsym)= 3x3 matrices of the group symmetries (reciprocal space) (not used yet)
!!  symrel(3,3,nsym)= array containing the symmetries in real space (not used yet)
!!  timrev= 1 if time-reversal preserves the q wavevector; 0 otherwise (not in use yet)
!!
!! OUTPUT
!!  eig2nkq(2,mband*nsppol,nkpt_rbz,3,npert,3,npert)= diagonal part of the second-order eigenvalues: E^{(2),diag}_{k,q,j}
!!  eigbrd(2,mband*nsppol,nkpt_rbz,3,npert,3,npert)= OPTIONAL, array containing the the electron lifetimes
!!
!! PARENTS
!!      loper3
!!
!! CHILDREN
!!      dotprod_g,smeared_delta
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine eig2tot(bdeigrf,clflg,cg1_pert,dim_eig2rf,esmear,gh1_pert,ghc_pert,eigen0,eigenq,eigen1,&
&  eig2nkq,ieig2rf,istwfk_pert,mband,mk1mem,mpert,npert,mpi_enreg,mpw1,&
&  nkpt_rbz,npwar1,nspinor,nsppol,smdelta,eigbrd)

 use defs_basis
 use defs_datatypes
 use defs_abitypes
#if defined HAVE_NETCDF
 use netcdf
#endif

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_53_spacepar
 use interfaces_72_response, except_this_one => eig2tot
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: bdeigrf,dim_eig2rf,ieig2rf,mband,mk1mem,mpert,mpw1,nkpt_rbz
 integer,intent(in) :: npert,nspinor,nsppol,smdelta
 type(MPI_type),intent(inout) :: mpi_enreg
!arrays
 integer,intent(in) :: clflg(3,mpert)
 integer,intent(in) :: istwfk_pert(nkpt_rbz,3,mpert)
 integer,intent(in) :: npwar1(nkpt_rbz,mpert)
 real(dp),intent(in) :: cg1_pert(2,mpw1*nspinor*mband*mk1mem*nsppol*dim_eig2rf,3,mpert)
 real(dp),intent(in) :: eigen0(nkpt_rbz*mband*nsppol)
 real(dp),intent(in) :: eigen1(nkpt_rbz*2*nsppol*mband**2,3,mpert)
 real(dp),intent(in) :: eigenq(nkpt_rbz*mband*nsppol),esmear
 real(dp),intent(in) :: gh1_pert(2,mpw1*nspinor*dim_eig2rf,mband*dim_eig2rf,nkpt_rbz*dim_eig2rf,3,mpert)
 real(dp),intent(in) :: ghc_pert(2,mpw1*nspinor*dim_eig2rf,mband*dim_eig2rf,nkpt_rbz*dim_eig2rf,3,mpert)
 real(dp),intent(out) :: eig2nkq(2,mband*nsppol,nkpt_rbz,3,npert,3,npert)
 real(dp),intent(out),optional :: eigbrd(2,mband*nsppol,nkpt_rbz,3,npert,3,npert)

!Local variables-------------------------------
!tolerance for non degenerated levels
!scalars
 integer :: band2tot_index,band_index,bandtot_index,iband,icg2,idir1,idir2
 integer :: ikpt,ikpt2,ipert1,ipert2,isppol,istwf_k,jband,npw1_k
 real(dp),parameter :: etol=1.0d-3
 real(dp) :: dot2i,dot2r,dot3i,dot3r,doti,dotr,eig1_i1,eig1_i2
 real(dp) :: eig1_r1,eig1_r2,eig2_diai
 real(dp) :: eig2_diar,eigbrd_i,eigbrd_r
!arrays
 integer :: blk1flg(3,mpert,3,mpert)
 real(dp),allocatable :: cwavef(:,:),cwavef2(:,:)
 real(dp) :: eigen(mband*nsppol),eigen_prime(mband*nsppol)
 real(dp),allocatable :: gh(:,:),gh1(:,:),ghc(:,:)
 real(dp),allocatable :: smdfun(:,:)

! *********************************************************************

 band2tot_index =0
 bandtot_index=0
 band_index=0

 eig2nkq(:,:,:,:,:,:,:) = zero
 if(present(eigbrd))then
   eigbrd(:,:,:,:,:,:,:) = zero
 end if
 blk1flg(:,:,:,:) = 0


 do isppol=1,nsppol
   do ikpt =1,nkpt_rbz

     if(smdelta >0) then   !broadening
       if(.not.allocated(smdfun)) allocate(smdfun(mband,mband))
       smdfun(:,:) = zero
       do iband=1,mband
         eigen(iband) = eigen0(iband+bandtot_index)
         eigen_prime(iband) =eigenq(iband+bandtot_index)
       end do
       call smeared_delta(eigen,eigen_prime,esmear,mband,smdelta,smdfun)
     end if

     do ipert1=1,npert
       npw1_k = npwar1(ikpt,ipert1)
       allocate(cwavef(2,npw1_k*nspinor),cwavef2(2,npw1_k*nspinor))
       allocate(gh(2,npw1_k*nspinor),gh1(2,npw1_k*nspinor))
       allocate(ghc(2,npw1_k*nspinor))
       icg2 = 0
       do ikpt2 = 1, ikpt-1
         icg2 = icg2 + npwar1(ikpt2,ipert1)*nspinor*mband !does not work with isppol
       end do

       do idir1=1,3
         if(clflg(idir1,ipert1)==0)cycle
         istwf_k = istwfk_pert(ikpt,idir1,ipert1)

         do ipert2=1,npert
           do idir2=1,3
             if(clflg(idir2,ipert2)==0)cycle
             blk1flg(idir1,ipert1,idir2,ipert2)=1

             do iband=1,bdeigrf

               eig2_diar = zero
               eig2_diai = zero
               eigbrd_r = zero
               eigbrd_i = zero

               if(ieig2rf == 1) then
                 gh1(:,:) = zero
                 gh(:,:) = zero
                 ghc(:,:) = zero
                 cwavef(:,:) = zero
                 cwavef2(:,:) = zero

                 cwavef(:,:) = cg1_pert(:,1+(iband-1)*npw1_k*nspinor+icg2:iband*npw1_k*nspinor+icg2,idir2,ipert2)
                 gh1(:,:)    = gh1_pert(:,1:npw1_k*nspinor,iband,ikpt,idir1,ipert1)
                 cwavef2(:,:)= cg1_pert(:,1+(iband-1)*npw1_k*nspinor+icg2:iband*npw1_k*nspinor+icg2,idir1,ipert1)
                 gh(:,:)     = gh1_pert(:,1:npw1_k*nspinor,iband,ikpt,idir2,ipert2)
                 ghc(:,:)    = ghc_pert(:,1:npw1_k*nspinor,iband,ikpt,idir1,ipert1)

!                The first two dotprod corresponds to:  <Psi(1)|H(1)|Psi(0)> + cc.
!                They are calculated using wavefunctions <Psi(1)| that are orthogonal to the active space.
                 call dotprod_g(dotr,doti,istwf_k,mpi_enreg,npw1_k*nspinor,2,cwavef,gh1)
                 call dotprod_g(dot2r,dot2i,istwf_k,mpi_enreg,npw1_k*nspinor,2,gh,cwavef2)

!                This dotprod corresponds to : <Psi(1)|H(0)- E(0)|Psi(1)>
!                It is calculated using wavefunctions that are orthogonal to the active space.
!                Should work for metals. (But adiabatic approximation is bad in this case...)
                 call dotprod_g(dot3r,dot3i,istwf_k,mpi_enreg,npw1_k*nspinor,2,cwavef,ghc)
               end if

               do jband=1,mband
                 eig1_r1 = eigen1(2*jband-1+(iband-1)*2*mband+band2tot_index,idir1,ipert1)  
                 eig1_r2 = eigen1(2*jband-1+(iband-1)*2*mband+band2tot_index,idir2,ipert2)
                 eig1_i1 = eigen1(2*jband+(iband-1)*2*mband+band2tot_index,idir1,ipert1)
                 eig1_i2 = - eigen1(2*jband+(iband-1)*2*mband+band2tot_index,idir2,ipert2) !the negative sign is from the CC
                 
                 if(present(eigbrd))then
                   if(smdelta >0) then   !broadening
                     eigbrd_r = eigbrd_r + (eig1_r1*eig1_r2 - eig1_i1*eig1_i2)*smdfun(iband,jband)  
                     eigbrd_i = eigbrd_i + (eig1_r1*eig1_i2 + eig1_i1*eig1_r2)*smdfun(iband,jband)
                   end if
                 end if

!                Sum over all active space to retrieve the diagonal gauge
                 if(ieig2rf == 1) then
                   if((abs(eigenq(jband+bandtot_index)-eigen0(iband+bandtot_index))>etol)) then
                     eig2_diar=eig2_diar+(eig1_r1*eig1_r2-eig1_i1*eig1_i2)/(eigenq(jband+bandtot_index)-eigen0(iband+bandtot_index))
                     eig2_diai=eig2_diai+(eig1_r1*eig1_i2+eig1_i1*eig1_r2)/(eigenq(jband+bandtot_index)-eigen0(iband+bandtot_index))
                   end if ! on degenerate bands
                 else if(ieig2rf == 2) then
                   if(abs(eigenq(jband+bandtot_index)-eigen0(iband+bandtot_index))>etol) then
                     eig2_diar=eig2_diar+(eig1_r1*eig1_r2-eig1_i1*eig1_i2)/(eigenq(jband+bandtot_index)-eigen0(iband+bandtot_index))
                     eig2_diai=eig2_diai+(eig1_r1*eig1_i2+eig1_i1*eig1_r2)/(eigenq(jband+bandtot_index)-eigen0(iband+bandtot_index))
                   end if ! on degenerate bands
                 end if ! on ieig2rf

               end do !jband

               if(ieig2rf == 1) then
                 eig2nkq(1,iband+band_index,ikpt,idir1,ipert1,idir2,ipert2) = dotr + dot2r + dot3r - eig2_diar 
                 eig2nkq(2,iband+band_index,ikpt,idir1,ipert1,idir2,ipert2) = doti + dot2i + dot3i - eig2_diai 
               else if(ieig2rf == 2) then
                 eig2nkq(1,iband+band_index,ikpt,idir1,ipert1,idir2,ipert2) = - eig2_diar
                 eig2nkq(2,iband+band_index,ikpt,idir1,ipert1,idir2,ipert2) = - eig2_diai 
               end if

               if(present(eigbrd))then
                 if(smdelta >0) then   !broadening
                   eigbrd(1,iband+band_index,ikpt,idir1,ipert1,idir2,ipert2) = eigbrd_r
                   eigbrd(2,iband+band_index,ikpt,idir1,ipert1,idir2,ipert2) = eigbrd_i
                 end if
               end if

             end do !iband
           end do !idir2
         end do !ipert2
       end do  !idir1
       deallocate(cwavef,cwavef2,gh,gh1,ghc)
     end do   !ipert1
     band2tot_index = band2tot_index + 2*mband**2
     bandtot_index = bandtot_index + mband

   end do    !ikpt
   band_index = band_index + mband
 end do !isppol


 write(ab_out,'(a)')'eig2tot: First component of the real part of the second-order derivatives'
 write(ab_out,'(a)')'eig2tot: for automatic tests only, printing at most 20 lines ... '
 do iband=1,min(20,bdeigrf)
   write (ab_out,'(a,i5)') ' Band:', iband
   write (ab_out,'(4i4,2es20.10)') 1, 1, 1, 2,&
&   eig2nkq(1,iband,1,1,1,1,2),&
&   eig2nkq(2,iband,1,1,1,1,2)
 end do !nband

 if(present(eigbrd))then
  if(smdelta >0) then   !broadening
   write(ab_out,'(a)')'eig2tot: First component of the imaginary part second-order derivatives'
   write(ab_out,'(a)')'eig2tot: for automatic tests only, printing at most 20 lines ... '
   do iband=1,min(20,bdeigrf)
     write (ab_out,'(a,i5)') ' Band:', iband
     write (ab_out,'(4i4,2es20.10)') 1, 1, 1, 2,&
&          eigbrd(1,iband,1,1,1,1,2),&
&          eigbrd(2,iband,1,1,1,1,2)
   end do !nband
  end if
 end if

 if(allocated(smdfun)) deallocate(smdfun)

!DEBUG
!write(6,*)' eig2tot: exit'
!ENDDEBUG

end subroutine eig2tot
!!***

