!{\src2tex{textfont=tt}}
!!****f* ABINIT/anaddb_dtset_clean
!!
!! NAME
!!   anaddb_dtset_clean
!!
!! FUNCTION
!!   deallocate remaining arrays in the anaddb_dtset datastructure
!!
!! COPYRIGHT
!! Copyright (C) 2010 ABINIT group (MVer)
!! This file is distributed under the terms of the
!! GNU General Public Licence, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  anaddb_dtset = anaddb datastructure
!!
!! OUTPUT
!!
!! NOTES
!!
!! PARENTS
!!      anaddb
!!
!! CHILDREN
!!
!! NOTES
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine anaddb_dtset_clean(anaddb_dtset)

 use defs_abitypes

 implicit none

!Arguments ------------------------------------
!scalars
 type(anaddb_dataset_type), intent(inout) :: anaddb_dtset

! *************************************************************************
 
 if (associated(anaddb_dtset%atifc)) deallocate(anaddb_dtset%atifc)
 if (associated(anaddb_dtset%iatfix)) deallocate(anaddb_dtset%iatfix)
 if (associated(anaddb_dtset%qnrml1)) deallocate(anaddb_dtset%qnrml1)
 if (associated(anaddb_dtset%qnrml2)) deallocate(anaddb_dtset%qnrml2)
 if (associated(anaddb_dtset%qpath)) deallocate(anaddb_dtset%qpath)
 if (associated(anaddb_dtset%qph1l)) deallocate(anaddb_dtset%qph1l)
 if (associated(anaddb_dtset%qph2l)) deallocate(anaddb_dtset%qph2l)
 if (associated(anaddb_dtset%ep_qptlist)) deallocate(anaddb_dtset%ep_qptlist)

end subroutine anaddb_dtset_clean
!!***
