!{\src2tex{textfont=tt}}
!!****f* ABINIT/completeperts
!!
!! NAME
!! completeperts
!!
!! FUNCTION
!!  Complete perturbations wrt atoms and reduced directions
!!  for a fixed qpoint. Normally there is a test in read_gkk which guarantees
!!  that enough irreducible perturbations are present to generate everything.
!!  h1_mat_el is first squared, making a (ipert,jpert) matrix which has the same
!!  symmetry properties as the dynamical matrix.
!!
!! COPYRIGHT
!! Copyright (C) 2004-2010 ABINIT group (MVer)
!! This file is distributed under the terms of the
!! GNU General Public Licence, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!   elph_ds = datastructure for elph data (dimensions and eventually data)
!!   gkk_flag = flags for presence of gkk matrix elements
!!   h1_mat_el = irreducible matrix elements to be completed and squared
!!   indsym = mapping of atoms under symops
!!   iqptirred = qpoint index
!!   natom = number of atoms
!!   nsym = number of syms
!!   qpt = qpoint
!!   symq = flags for symmetry elements conserving the present qpoint
!!   symrec = symmetry operations for reduced reciprocal coordinates $=(symrel^{-1})^{T}$
!!   symrel = symmetry operations for reduced reciprocal coordinates
!!   tnons = translation vectors associated with symops
!!
!! OUTPUT
!!   h1_mat_el_sq = irreducible matrix elements squared and completed
!!   gkk_flag = changed on output
!!
!! NOTES
!!
!! PARENTS
!!      read_gkk
!!
!! CHILDREN
!!      d2sym3,leave_new,wrtout
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine completeperts(elph_ds,gkk_flag,h1_mat_el,h1_mat_el_sq,&
&   indsym,iqptirred,natom,nsym,qpt,symq,symrec,symrel,timrev)

 use defs_basis
 use defs_datatypes
 use defs_abitypes
 use defs_elphon

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
 use interfaces_16_hideleave
 use interfaces_72_response
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: iqptirred,natom,nsym,timrev
 type(elph_type),intent(in) :: elph_ds
!arrays
 integer,intent(in) :: indsym(4,nsym,natom)
 integer,intent(in) :: symq(4,2,nsym),symrec(3,3,nsym),symrel(3,3,nsym)
 integer,intent(inout) :: gkk_flag(elph_ds%nbranch,elph_ds%nbranch,elph_ds%k_phon%nkpt,elph_ds%nsppol,elph_ds%nqptirred)
 real(dp),intent(in) :: h1_mat_el(2,elph_ds%nFSband*elph_ds%nFSband,elph_ds%nbranch,elph_ds%k_phon%nkpt,elph_ds%nsppol)
 real(dp),intent(in) :: qpt(3)
 real(dp),intent(out) :: &
& h1_mat_el_sq(2,elph_ds%nFSband*elph_ds%nFSband,elph_ds%nbranch*elph_ds%nbranch,elph_ds%k_phon%nkpt,elph_ds%nsppol)

!Local variables-------------------------------
!scalars
 integer :: ikpt_phon,iatom1,iatom2,ibb,idir1,idir2,ipert1,ipert2
 integer :: isppol,mpert,printflag
 real(dp) :: im1,im2,re1,re2,res,valtol
 character(len=500) :: message
!arrays
 integer,allocatable :: tmpflg(:,:,:,:)
 real(dp),allocatable :: tmpval(:,:,:,:,:)

! *************************************************************************

!WARNING! Stupid patch in d2sym3 imposes these matrices to have size natom+2
 mpert = natom+2

 allocate(tmpflg(3,mpert,3,mpert))
 allocate(tmpval(2,3,mpert,3,mpert))

 valtol = 1.0d-50
 printflag = 0

 h1_mat_el_sq(:,:,:,:,:) = zero
 write (*,*) ' completeperts: shape(h1_mat_el_sq) = ', shape(h1_mat_el_sq)

 do isppol=1,elph_ds%nsppol
   write(*,*)'completeperts: isppol = ', isppol

   do ikpt_phon=1,elph_ds%k_phon%nkpt
     do ibb=1,elph_ds%nFSband*elph_ds%nFSband

       tmpval(:,:,:,:,:) = zero
       tmpflg(:,:,:,:) = 0
       do iatom1=1,natom
         do idir1=1,3
           ipert1 = (iatom1-1)*3+idir1
           if (gkk_flag(ipert1,ipert1,ikpt_phon,isppol,iqptirred) < 0) cycle
           re1 = h1_mat_el(1,ibb,ipert1,ikpt_phon,isppol)
           im1 = h1_mat_el(2,ibb,ipert1,ikpt_phon,isppol)

           do iatom2=1,natom
             do idir2=1,3
               ipert2 = (iatom2-1)*3+idir2
               if (gkk_flag(ipert2,ipert2,ikpt_phon,isppol,iqptirred) < 0) cycle
               tmpflg(idir1,iatom1,idir2,iatom2) = 1
               re2 = h1_mat_el(1,ibb,ipert2,ikpt_phon,isppol)
               im2 = h1_mat_el(2,ibb,ipert2,ikpt_phon,isppol)

!              conjg(h1_mat_el_2) * h1_mat_el_1
               res =  re1*re2 + im1*im2
               tmpval(1,idir1,iatom1,idir2,iatom2) =  res
               res =  re1*im2 - im1*re2
               tmpval(2,idir1,iatom1,idir2,iatom2) = res

             end do !idir2 
           end do !iatom2
         end do !idir1
       end do !iatom1

       call d2sym3(tmpflg,tmpval,indsym,mpert,natom,nsym,qpt,symq,symrec,symrel,timrev)

       if (sum(tmpflg(:,1:natom,:,1:natom)) /= 3*natom*3*natom) then
         write(*,*)' tmpflg = ',tmpflg
         write(*,*)'  ikpt_phon,isppol,iqptirred', ikpt_phon,isppol,iqptirred
         write(message,'(4a)')ch10,&
&         ' completeperts : ERROR- ',ch10,&
&         ' A perturbation is missing after completion with d2sym3'
         call wrtout(std_out,message,'COLL')
         call leave_new('COLL')
       end if

!      Save values for calculation of |gkk|^2
       do iatom1=1,natom
         do idir1=1,3
           ipert1 = (iatom1-1)*3+idir1
           do iatom2=1,natom
             do idir2=1,3
               
!              mjv 29/10/2007 ipert2 now contains the composite index ip1*nperts+ip2
               ipert2 = (iatom2-1)*3+idir2 + (ipert1-1)*3*natom
               h1_mat_el_sq(1,ibb,ipert2,ikpt_phon,isppol) = tmpval(1,idir2,iatom2,idir1,iatom1)
               h1_mat_el_sq(2,ibb,ipert2,ikpt_phon,isppol) = tmpval(2,idir2,iatom2,idir1,iatom1)
               
             end do
           end do
         end do
       end do

     end do !end ibb band dos

!    Set flags
     do ipert1=1,3*natom
       do ipert2=1,3*natom
         if (gkk_flag(ipert2,ipert1,ikpt_phon,isppol,iqptirred) < 0) then
           gkk_flag(ipert2,ipert1,ikpt_phon,isppol,iqptirred) = 1
         end if
       end do
     end do

   end do !end kpt_phon do
 end do !end sppol do

 deallocate(tmpflg,tmpval)

end subroutine completeperts
!!***
