!{\src2tex{textfont=tt}}
!!****f* ABINIT/ep_setupqpt
!!
!! NAME
!! ep_setupqpt
!!
!! FUNCTION
!!  set up qpoint grid for elphon.
!!  2 modes, either uniform grid from anaddb input npqpt
!!  or take qpt from anaddb input (explicitly listed)
!!
!! COPYRIGHT
!! Copyright (C) 2009-2010 ABINIT group (MVer, )
!! This file is distributed under the terms of the
!! GNU General Public Licence, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!   anaddb_dtset=dataset with input variables
!!     %qgrid_type gives type of q grid 1=uniform 2=take from input
!!     %ep_nqpt    number of auxiliary qpoints 
!!     %ep_qptlist list of qpoints, 
!!
!! OUTPUT
!!   
!! NOTES
!!   
!! PARENTS
!!      elphon
!!
!! CHILDREN
!!      getkgrid,leave_new,smpbz,symkpt,wrap2_pmhalf,wrtout
!!
!! NOTES
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine ep_setupqpt (anaddb_dtset,elph_ds,gmet,nsym,qptrlatt,rprimd,symrec,symrel,timrev)

 use defs_basis
 use defs_datatypes
 use defs_abitypes
 use defs_elphon

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
 use interfaces_16_hideleave
 use interfaces_32_util
 use interfaces_56_recipspace
!End of the abilint section

 implicit none

!Arguments -------------------------------

 integer, intent(in) :: nsym
 integer, intent(in) :: timrev
 integer, intent(in) :: symrel(3,3,nsym)
 integer, intent(in) :: symrec(3,3,nsym)
 type(anaddb_dataset_type), intent(in) :: anaddb_dtset

 real(dp), intent(in) :: gmet(3,3)
 real(dp), intent(in) :: rprimd(3,3)

 type(elph_type), intent(inout) :: elph_ds
 integer, intent(out) :: qptrlatt(3,3) 

!Local variables -------------------------

 integer :: nqshft,option,iqpt, nqpt1
 integer :: iscf,mqpt,istat,iout,berryopt,nqpt_computed
 real(dp) :: qptrlen, kpt(3), res

 integer :: symafm(nsym),vacuum(3)
 integer,allocatable :: indqpt1(:)

 real(dp),allocatable :: wtq_folded(:)
 real(dp), allocatable :: wtq(:),qpt_full(:,:),tmpshifts(:,:)
 character(len=500) :: message

! *********************************************************************

!default is to expect a uniform grid
 elph_ds%tuniformgrid = 1


!if we use the normal grid way of generating the qpoints:
 if (anaddb_dtset%qgrid_type==1) then
!  qpoint lattice vectors (inverse, like kptrlatt)
   qptrlatt(:,:)=0
   qptrlatt(1,1)=anaddb_dtset%ngqpt(1)
   qptrlatt(2,2)=anaddb_dtset%ngqpt(2)
   qptrlatt(3,3)=anaddb_dtset%ngqpt(3)
   
   if (anaddb_dtset%nqshft /= 1) then
!    MG Check this part, dont know if it works, never used shifted grids!
!    try to reduce the qpoint grid to a single qshift, otherwise stop
!    dummy args for call to getkgrid
     symafm(:) = 1
     vacuum(:) = 0
     iscf = 3
     
     mqpt = anaddb_dtset%ngqpt(1)*anaddb_dtset%ngqpt(2)*anaddb_dtset%ngqpt(3)*anaddb_dtset%nqshft
     allocate(qpt_full(3,mqpt),wtq(mqpt),tmpshifts(3,8),stat=istat)
     if (istat /= 0) stop 'elphon: error in allocating qpt_full(3,mqpt),wtq(mqpt),tmpshifts(3,8)'

     wtq(:) = one

     tmpshifts(:,:) = zero
     tmpshifts(:,1:4) = anaddb_dtset%q1shft(:,:)

     iout=6

     berryopt = 1

!    just call with identity, to get full set of kpts in qpt_full, but
!    reduce qshfts
     
     nqshft=anaddb_dtset%nqshft
     call getkgrid(0,iout,iscf,qpt_full,3,qptrlatt,qptrlen, &
&     1,mqpt,nqpt_computed,nqshft,1,rprimd,tmpshifts,symafm, &
&     symrel,vacuum,wtq)
     deallocate (qpt_full,wtq,tmpshifts)
     if (anaddb_dtset%nqshft /= 1) then
       write (message,'(6a,i4)')ch10,&
&       ' elphon : ERROR- ',ch10,&
&       ' multiple qpt shifts not treated yet',ch10,&
&       ' -- should be possible ', anaddb_dtset%nqshft
       call wrtout(std_out,message,'COLL')
       call leave_new('COLL')
     end if
   end if  ! end multiple shifted qgrid


   write(message,'(3a,9i3)')&
&   ' elphon : enter smpbz ',ch10,&
&   ' qptrlatt = ',qptrlatt 
   call wrtout(std_out,message,'COLL')

   option=1
!  mqpt=anaddb_dtset%ngqpt(1)*anaddb_dtset%ngqpt(2)*anaddb_dtset%ngqpt(3)*anaddb_dtset%nqshft
   mqpt= qptrlatt(1,1)*qptrlatt(2,2)*qptrlatt(3,3) &
&   +qptrlatt(1,2)*qptrlatt(2,3)*qptrlatt(3,1) &
&   +qptrlatt(1,3)*qptrlatt(2,1)*qptrlatt(3,2) &
&   -qptrlatt(1,2)*qptrlatt(2,1)*qptrlatt(3,3) &
&   -qptrlatt(1,3)*qptrlatt(2,2)*qptrlatt(3,1) &
&   -qptrlatt(1,1)*qptrlatt(2,3)*qptrlatt(3,2)

   allocate(qpt_full(3,mqpt),stat=istat)
   if (istat /= 0) stop 'elphon: error in allocating qpt_full'
   iout = 6
   call smpbz(anaddb_dtset%brav,iout,qptrlatt,mqpt,elph_ds%nqpt_full,anaddb_dtset%nqshft,option,anaddb_dtset%q1shft,qpt_full)


!  save the q-grid for future reference
   allocate(elph_ds%qpt_full(3,elph_ds%nqpt_full),stat=istat)
   if (istat /= 0) stop 'elphon: error in allocating elph_ds%qpt_full'

!  reduce qpt_full to correct zone
   do iqpt=1,elph_ds%nqpt_full
     call wrap2_pmhalf(qpt_full(1,iqpt),kpt(1),res)
     call wrap2_pmhalf(qpt_full(2,iqpt),kpt(2),res)
     call wrap2_pmhalf(qpt_full(3,iqpt),kpt(3),res)
     qpt_full(:,iqpt) = kpt
     elph_ds%qpt_full(:,iqpt)=kpt
   end do
   deallocate (qpt_full)

 else if (anaddb_dtset%qgrid_type==2) then ! use explicit list of qpoints from anaddb input
   qptrlatt(:,:)=0
   qptrlatt(1,1)=1
   qptrlatt(2,2)=1
   qptrlatt(3,3)=1

   elph_ds%nqpt_full=anaddb_dtset%ep_nqpt
   allocate(elph_ds%qpt_full(3,elph_ds%nqpt_full),stat=istat)
   if (istat /= 0) stop 'elphon: error in allocating elph_ds%qpt_full'
   
   elph_ds%qpt_full = anaddb_dtset%ep_qptlist

   elph_ds%tuniformgrid = 0

 end if ! type of qgrid for elphon

!=================================================================
!Calculate weights, needed to estimate lambda using the weighted
!sum of the uninterpolated e-ph matrix elements
!=================================================================

 write (message,'(a)')' setqgrid : calling symkpt to find irred q points'
 call wrtout(6,message,'COLL')

 allocate(indqpt1(elph_ds%nqpt_full),wtq_folded(elph_ds%nqpt_full),wtq(elph_ds%nqpt_full),stat=istat)
 if (istat /= 0) stop 'elphon: error in allocating indqpt1 ,wtq_folded ,wtq'
 wtq(:) = one/dble(elph_ds%nqpt_full) !weights normalized to unity

!
!NOTE: this reduction of irred qpt may not be identical to that in GKK file
!which would be more practical to use.
!
 option=0 !do not write to ab_out
!should we save indqpt1 for use inside elph_ds?
 call symkpt(0,gmet,indqpt1,elph_ds%qpt_full,elph_ds%nqpt_full,nqpt1,nsym,option,symrec,&
& timrev,wtq,wtq_folded)

 write (message,'(2a,i6)')ch10,' Number of irreducible q-points = ',nqpt1
 call wrtout(6,message,'COLL')
 elph_ds%nqptirred=nqpt1

 write (message,'(a)')' Irreducible q points with weights :'
 call wrtout(6,message,'COLL')

 do iqpt=1,elph_ds%nqpt_full
   if (wtq_folded(iqpt) /= zero) then
     write (message,'(1x,i4,a2,4es16.8)')iqpt,') ',elph_ds%qpt_full(:,iqpt),wtq_folded(iqpt)
     call wrtout(6,message,'COLL')
   end if
 end do

 write(message,'(a)')ch10
 call wrtout(6,message,'COLL')

 allocate (elph_ds%wtq(elph_ds%nqpt_full),stat=istat)
 if (istat /= 0) stop 'elphon: error in allocating elph_ds%wtq'
 elph_ds%wtq(:)=wtq_folded(:)
!MEMO indqpt could be useful to test the qgrid read by abinit
 deallocate (indqpt1,wtq_folded,wtq)


end subroutine ep_setupqpt
!!***
